
import link.kotlin.scripts.dsl.Article
import link.kotlin.scripts.dsl.LinkType.*
import link.kotlin.scripts.dsl.LanguageCodes.*
import java.time.LocalDate

// language=Markdown
val body = """

# 10 Kotlin Tutorials for Beginners: Dive Into Kotlin Programming

There is a serious lack of Kotlin tutorials for beginners![The first Kotlin tutorial for beginners](http://petersommerhoff.com/wp-content/uploads/2016/02/kotlin-programming-course-300x169.png). You only find experienced Java developers hacking down Kotlin code in record time. Don’t get me wrong — those are really great for other experienced developers and I enjoy watching them. But for beginners, they are just voodoo code appearing on the screen like magic.

Kotlin is actually a great language to learn first, if only the necessary tutorials were out there. So I decided to create a course that even total beginners can follow. Check out the first 10 Kotlin tutorials below or [check out the whole course](https://www.udemy.com/kotlin-course/?couponCode=AMAZINGREADERS25) (it’s $25 with the 50% reader discount).

## #1: A Brief Overview of Kotlin

Learn where Kotlin comes from, the language concepts it incorporates, and _why you should learn it_.

<iframe src="https://www.youtube.com/embed/AcwzpPLV5HY?feature=oembed" allowfullscreen="" height="540" frameborder="0" width="960"></iframe>

##  #2: Try It Out in 30 Seconds

This is a quick video for those who cannot wait to dive into code. Learn how to use the [Kotlin online editor](http://try.kotlinlang.org/) to try out some of the language basics.

<iframe src="https://www.youtube.com/embed/kdorCemb2v8?feature=oembed" allowfullscreen="" height="540" frameborder="0" width="960"></iframe>

## #3: Installing the JDK

If you already have the Java Development Kit (JDK) installed, you can happily skip this step. If not, just follow this video and use [this link](http://www.oracle.com/technetwork/java/javase/downloads/jdk8-downloads-2133151.html) that is mentioned in the video.

<iframe src="https://www.youtube.com/embed/2rOYygAEEQQ?feature=oembed" allowfullscreen="" height="540" frameborder="0" width="960"></iframe>

## #4: Installing IntelliJ

If you don’t already have IntelliJ, you should change that right away — I really learned to love this powerful IDE. This tutorial guides you through the download and installation process. And [here’s the link](http://www.jetbrains.com/idea/) mentioned in the video.

<iframe src="https://www.youtube.com/embed/EbGHqY5EJvU?feature=oembed" allowfullscreen="" height="540" frameborder="0" width="960"></iframe>

## #5: Setting Up IntelliJ

This tutorial covers just the most basic layout settings: how you can adjust the theme and font in IntelliJ to your favorite style.

<iframe src="https://www.youtube.com/embed/TtIKESmXTXQ?feature=oembed" allowfullscreen="" height="540" frameborder="0" width="960"></iframe>

## #6: Using Kotlin Interactively in The REPL

The Kotlin REPL allows us to use Kotlin interpreter-style, so that we can put in an expression (or any line of code) and see what Kotlin does with it. It’s great to try out some basic expressions and calculations.

<iframe src="https://www.youtube.com/embed/wDkWaHYiLWk?feature=oembed" allowfullscreen="" height="540" frameborder="0" width="960"></iframe>

## #7: Variables

It’s time to learn about variables in Kotlin. This tutorial covers how to create and use variables of different types and the differences of the val and var keywords (to create immutable and mutable variables, respectively).

<iframe src="https://www.youtube.com/embed/Nz-lMqxfUUs?feature=oembed" allowfullscreen="" height="540" frameborder="0" width="960"></iframe>

## #8: Basic Types & Strings

This tutorial covers all the basic types in Kotlin including strings. In the video, I go through the differences between the different data types for storing integer values, floating point numbers, text and logical values.

<iframe src="https://www.youtube.com/embed/8JhPR-vojiI?feature=oembed" allowfullscreen="" height="540" frameborder="0" width="960"></iframe>

## #9: Nullable Variables

Kotlin gets rid of the worst enemy of all Java developers — the NullPointerException. In Kotlin, you can use nullable types to decide which variables can be set to null and which cannot. By default, a variable just cannot be assigned to null.

<iframe src="https://www.youtube.com/embed/PYwJ-07I9as?feature=oembed" allowfullscreen="" height="540" frameborder="0" width="960"></iframe>

## #10: Your First Standalone Application

This tutorial covers how you can create a main() function in Kotlin to define the entry-point to your applications. Once you have made it through this lecture, you’re ready to go and really dive into development with Kotlin.

<iframe src="https://www.youtube.com/embed/wqUfs89N5yg?feature=oembed" allowfullscreen="" height="540" frameborder="0" width="960"></iframe>

## Continue Learning...

If you’re as excited about Kotlin as I am, you can get my whole course on Udemy for $25 using [this coupon link](https://www.udemy.com/kotlin-course/?couponCode=AMAZINGREADERS25).

Inside the course, you’ll go from the basics to more advanced topics. These include:

* Conditional expressions using _if_ and _when_
* Loops using _for_ and _while_
* Arrays and lists
* Functions
* Classes, objects, interfaces, inheritance and all you need to know about object-orientation
* Functional programming in Kotlin
* Several coding challenges and quizzes for you to test what you’ve learned

The course will be improved and extended based on student feedback and I’ll be there to help you personally whenever you get stuck. That way, there is no excuse for not learning Kotlin — even if you’re a total beginner.

[Join the course now (50% discount for my readers)](https://www.udemy.com/kotlin-course/?couponCode=AMAZINGREADERS25)

## Any Thoughts?

What do you think about Kotlin? Is it “better than Java” or just yet another JVM language for you?

What else do you want to learn about Kotlin? Let me know in the comments and I’ll respond to you personally.

"""

Article(
  title = "10 Kotlin Tutorials for Beginners: Dive Into Kotlin Programming",
  url = "http://petersommerhoff.com/dev/kotlin/kotlin-beginner-tutorial/",
  categories = listOf(
    "Kotlin",
    "Videos"
  ),
  type = article,
  lang = EN,
  author = "Peter Sommerhoff",
  date = LocalDate.of(2016, 2, 2),
  body = body
)
