
import link.kotlin.scripts.dsl.Article
import link.kotlin.scripts.dsl.LanguageCodes.RU
import link.kotlin.scripts.dsl.LinkType.article
import java.time.LocalDate

// language=Markdown
val body = """
В феврале 2016-го, после шести лет разработки, компания JetBrains выпустила в релиз версию 1.0 статически типизированного языка программирования [Kotlin](https://kotlinlang.org/). Его авторы ставили целью создать язык «более лаконичный и типобезопасный, чем Java, и более простой, чем Scala». О том, что из этого вышло, а также о моде на языки программирования, конкуренции между ними, перспективах и «серебряной пуле» в интервью dev.by рассказал руководитель разработки проекта Kotlin в JetBrains​ **Андрей Бреслав**.   


![](https://dev.by/ckeditor_assets/pictures/20014/content_breslav.jpg)

# О Kotlin и о конкуренции

**— Первому релизу Kotlin предшествовали шесть лет разработки. Получилось ли у вас то, к чему стремились?**

**—** В разные моменты мы стремились к разным вещам, но большая часть из того, что сейчас мы считаем правильными целями, состоялась. Мы хотели сделать удобный язык для разработчиков с широким кругом задач — получилось. Мы хотели сделать язык, который будет нравиться людям и сделает их жизнь заметно лучше — результатом мы довольны. Цели в процессе менялись: менялись приоритеты, появлялись новые внешние обстоятельства — конкуренты, новые платформы. Например, Android, о котором мы изначально не думали, стал для нас очень интересной и важной платформой, и сейчас мы получаем аудиторию в среде Android-разработчиков. Мы придумали компилироваться в JavaScript — сразу такой мысли не было, а сейчас понятно, что это тоже очень полезное направление.

**— Кстати, о конкурентах. За последние 10-15 лет языков под JVM развелось много, и многие на слуху: Groovy, Gosu, Ceylon. Почему этих разработок так много? Почему не удаётся сконцентрироваться на какой-то одной, особенно в случаях, когда цели схожи?**

— Языков программирования вообще появляется много, и поиск в этом поле бесконечен.

> Создать новый язык — одна из немногих задач системного программирования, относительно несложная, с интересной «математикой». Написать базу данных или операционную систему куда сложнее, поэтому это делают не так часто.

Многие языки возникают, чтобы заполнить новые или пустующие ниши. Например, Gosu изначально создавался для внуренних конфигурационных скриптов, то есть как язык внутри конкретного продукта компании Guidewire, и только потом отделился и стал более самостоятельным. Groovy — одна из первых успешных попыток сделать динамически типизированный язык специально для JVM, и в какой-то момент он стал новым словом в этом направлении.

**— Многие ли идеи конкурентов перекочевали в Kotlin?**

— Мы использовали всё полезное, что нашли у других: цели придумывать всё с нуля не было. Из названных языков по задачам мы пересекаемся с Ceylon, но общий набор требований у нас другой. Большой упор в Kotlin — на взаимодействие с существующим кодом, так называемый interop с Java, а создатели Ceylon от этой идеи отказались. Они запускаются на JVM, но при этом полностью переписывают стандартную библиотеку: вместо классов из JDK используется их собственная SDK. Это сильно меняет дело: подмешать немножечко Ceylon в существующий проект на Java — большая проблема просто потому, что язык создан не для этого, а для того, чтобы на нём с нуля разрабатывать красивые проекты. А Kotlin хорошо подходит для уже существующих проектов.

**— Создание обратной совместимости с Java и стало самой сложной частью проекта?**

— Да, это, пожалуй, принесло больше всего головной боли. По пути мы перебрали четыре основных схемы взаимодействия с библиотеками Java. Первая была очень консервативной: мы считали, что код на Java очень небезопасен, и в Kotlin нужно проверять всё, что можно. Оказалось, что это очень неудобно. Потом мы пытались аннотировать Java-библиотеки, чтобы внести в код на Java дополнительную типовую информацию и её использовать — это решение оказалось слишком хрупким. Закончили мы тем, что создали концепцию платформенных типов, у меня есть [целый доклад о ней](http://medianetwork.oracle.com/video/player/1785452087001) на JVM Language Summit. Модель достаточно сложна и оригинальна, но на практике она работает хорошо.

**— Вернёмся к релизу. Первый фидбек уже собран? Что понравилось пользователям?**

— Разным людям — разные вещи. Очень многим нравится, что программы становятся короткими и понятными, что компилятор ловит ошибки, которые другие компиляторы не поймали бы.

> На Kotlin удаётся и прозрачно использовать существующие библиотеки, и писать хорошие новые — а это значит, что можно добавлять немножко кода на Kotlin в существующий проект и ничего не бояться. Есть и узкоспециализированные вещи: пользователям на Android, например, нравится, что у нас маленькая стандартная библиотека.

# Как и почему возникает мода на языки

**— Появились ли в последние лет 10-15 языки, которые уже стали поворотными для сферы или могут ими стать?**

— Есть такое образное выражение: «Язык превратился в COBOL». Казалось бы, COBOL — старый язык, который должны давно забыть, но в реальности на нём работает ещё очень много систем, особенно в финансовой сфере. Мы наверняка пишем на Java больше новых проектов, чем на COBOL, но при этом я не брался бы утверждать, что мы пишем больше кода на Java в целом :).

> Я к тому, что судьбоносными становятся те языки, которые в какой-то момент были популярны — на них пишут много больших систем, которые потом нужно поддерживать, и от них никуда не денешься.

В своё время C в этом смысле совершил революцию, Java тоже стала судьбоносным языком. Из более новых языков не смогу назвать ни одного —  наверное, прошло недостаточно много времени, чтобы они могли набрать такую популярность. Но в любом случае, очень успешные языки были. На JVM это Scala и Groovy, на которых крупные компании написали уже немало кода. Вне JVM в своё время имел огромный успех Ruby, на нём писали крупные web-проекты; потом случился кризис роста, люди стали отказываться от Ruby, но этот язык так или иначе серьёзно повлиял на восприятие динамических языков программирования.

Очень большое влияние на направление мысли оказывают функциональные языки. С одной стороны, это языки семейства Lisp-Scheme и всё, что рядом с ним. На JVM есть Clojure, который воплощает те же идеи. С другой стороны — Haskell и другие языки семейства ML. Думаю, что хорошо закрепится Swift, поскольку Apple переводит на него разработчиков для своих платформ, а платформа — вещь такая, что с ней не поспоришь. Раз велено писать на Swift под устройства Apple, значит, все будут писать на Swift — а язык очень хороший, поэтому никакого сопротивления я не ожидаю.

**— Как вы считаете, стоит ли гнаться за модой на языки?**

— Есть люди, которые получают удовольствие от того, что пробуют новые языки и технологии — им, безусловно, стоит пробовать. А есть те, у которых нет на это времени — им есть смысл подождать, пока более резвые коллеги разберутся, какой из конкурирующих языков лучше, и уже постфактум выбирать язык для себя.

> В принципе, язык программирования — это только рабочий инструмент. Менять его слишком часто не нужно — не будет полноты овладения инструментом. Но если не менять инструменты совсем, можно отстать от жизни.

Здесь нужен баланс. Важно правильно выбирать инструмент по задаче. Когда мы меняем сферу деятельности или переходим к работе в другой области, или просто устали от проблем с тем, что используем сейчас, то есть смысл рассмотреть новые инструменты, понять, не сделают ли они нашу работу принципиально лучше.

**— Тот же Ruby, да и Swift тоже, частенько называют «хипстерскими языками». Почему они стали такими модными?**

— Элемент моды возникает там, где пишутся короткие маленькие проекты. Люди начинают новый проект каждые три месяца и могут себе позволить очередной из них написать на Ruby или на новомодной технологии на базе JavaScript. Естественно, этот эффект хайпа недолговечен, как и любая мода. В мире клиентской разработки это видно особенно ярко: фреймворки и системы программирования на JavaScript сменяют одна другую со страшной скоростью. Мы даже испытываем некоторые сложности из-за этого при разработке Kotlin, потому что при компиляции в JavaScript нам нужно поддерживать какие-то популярные технологии, а их каждый день появляется очень много, и за всем очень сложно уследить. Для Swift всё сказанное тоже частично релевантно, но у этого языка принципиально другая судьба: это стандартное решение, которое поставляется вместе с платформой, и его выбирают не из-за моды.

**— Есть ли, по-вашему, критерии, по которым язык может «выстрелить»?**

— Возвращаясь к сказанному, самый надёжный способ «выстрелить» — быть языком, привязанным к платформе. В своё время C широко распространился, потому что он был языком для платформы Unix, которая была популярной и очень удобной. Java тоже в распространялась как платформа, и язык был её частью. То же касается C#: пускай это и не единственный, но основной язык для платформы .NET. Опять же, есть JavaScript, который популярен не потому, что он хороший или плохой, а потому, что это язык для браузера, браузер нужен всем.

Дать надежный рецепт «Как сделать язык, который станет популярным», я не могу, но есть и другие понятные причины, по которым языки становятся популярными.

Есть языки, которые распространяются по идеологическим моделям — например, Haskell или в какой-то степени Python. Но идеология — это скорее способ сформировать комьюнити, а не удержать его. Тот же Python — это просто хороший язык для многих задач. А вот кто победит из нескольких конкурирующих языков, которые не являются частью платформы и не являются идеологической революцией — как Kotlin, например, — решает рынок.

> Попадание во время и потребности пользователей, правильная маркетинговая работа, своевременный отзыв от ярких представителей сообщества — это все очень важно, но на популярность влияет ещё целая куча разных вещей, которые трудно предсказывать.

![](https://dev.by/ckeditor_assets/pictures/20015/content_breslav2.jpg)

# Прилетит ли «серебряная пуля»?

**— В каком направлении сейчас меняются языки программирования?**

— Есть выраженная тенденция включения в мейнстримовые языки возможностей, изначально придуманных в мире функционального программирования. Наибольшую популярность получили функции высших порядков и лямбда-выражения.

Ещё одна популярная вещь, которая пришла из функционального мира — неизменяемые данные. Здесь есть вполне понятная причина: многоядерные процессоры, которые не так давно произвели революцию на рынке аппаратных средств, а вместе с собой принесли много так называемого «конкурентного программирования», когда программа выполняется в нескольких параллельных нитях. Разделяемые между разными потоками изменяемые данные ведут себя плохо, ошибки отслеживать очень сложно, а чтобы этих ошибок не делать, нужно очень многое держать в голове. В функциональных языках программирования мутирующие операции изначально не в чести, и сейчас эта идея неизменяемых данных становится всё популярнее, поскольку пользоваться ими гораздо проще и надёжнее.

**— Чего, на ваш взгляд, современным языкам не хватает? Что в них «ещё не пришло» из того, что уже, казалось бы, должно?**

— Про языки мне сложно ответить: если бы знал, чего не хватает, уже добавил бы! Мне кажется, что основные болезненные места на сегодня связаны, как я отмечал выше, с многопоточностью. А там главная сложность в том, что никто не знает хорошей модели для многопоточного программирования. Сама эта идея — независимые нитки исполнения, имеющие общую память — несколько противоестественная, и порождает тяжкие ухищрения на аппаратном уровне. Процессор, синхронизируя кеши между ядрами, фактически реализует message passing, но мы притворяемся, что этого нет, и на самом деле у нас разделяемая память. Но чтобы как-то совладать с многопоточным программированием, мы стараемся поменьше пользоваться разделяемой памятью, и программно реализуем поверх неё — снова message passing!

Так получилось исторически: новые процессоры эмулируют поведение старых для совместимости, поэтому сменить парадигму радикально очень сложно. И это отражается на программировании, конечно. Если бы железо могло быть гибче, программирование тоже было бы другим, я думаю. Но мы все в этом смысле связаны во многом всё той же совместимостью. Можно сделать всё очень здорово — и процессор и языки, но только программ и библиотек под это все никаких не будет, и пользователи останутся на традиционных платформах...

**— У программистов есть давняя мечта о «серебряной пуле» — одном языке, который удовлетворил бы большинство или даже всех. Возможно ли его появление?**

— Думаю, в обозримое время ни один язык не победит. Есть искусственные ситуации, в которых можно писать только на одном языке: например, в случае с клиентским вебом. Основным языком браузера был и остаётся JavaScript, и не очень понятно, может ли это измениться. А в остальных случаях, когда есть свобода выбора, я не вижу никаких предпосылок к появлению универсальной идеи, которая бы всех примирила. Слишком уж много противоречивых требований.

# Надо ли уметь программировать каждому школьнику

**— Программирование становится всё более популярным. Сложится ли так, что через какое-то время программировать должен будет уметь каждый?**

— Не думаю, что такое должно произойти. У людей есть автоматически не приобретаемые навыки, которые нужны всем. Например, писать на родном языке или считать. А вот зачем всем на свете нужно будет программировать, я себе представить не могу. Непрограммисты иногда пишут программы, но, как правило, этим всё же занимаются профессионалы. Например, инженеры, которые работают с численными моделями и используют специализированные языки программирования для математического моделирования. Или люди, которые пользуются сложными офисными программами — внутри того же Microsoft Office есть язык программирования Visual Basic for Applications, на котором часто пишут достаточно сложные вещи.

Если человек по роду деятельности никак не связан с таким набором задач, то зачем ему программировать? Многие считают, что раз компьютеры — передний край прогресса, значит, все должны разбираться в компьютерах. Когда квантовая физика казалась передним краем прогресса, многие думали, что все будут очень «квантово» жить, но на самом деле никто не будет жить более «квантово», чем живёт сейчас, по-моему.

**— Тем не менее, пока число программистов растёт, и количество запросов на программы тоже растёт.**

— И в ближайшее время этот рост никуда не денется хотя бы из-за того, что правительство Китая изменяет экономический курс. Насколько я понимаю, количество программистов в Китае должно резко увеличиться в ближайшие годы, и для мирового рынка программистов это будет весьма заметный рост. Означает ли это, что в других странах количество рабочих мест для программистов замедлит рост или начнёт падать — хороший вопрос.

**— Стоит ли тогда, на ваш взгляд, преподавать программирование в школе?**

— Я сам восемь лет преподавал программирование в физико-математической школе, и мне кажется, что это столь же разумно, как и преподавание математики или физики. Другой вопрос — содержание курса. Как правильно преподавать программирование в школе без специализации или с гуманитарным уклоном, я не знаю, но всё равно считаю, что это может быть полезным. Программирование развивает алгоритмические и аналитические навыки мышления, очень полезные по жизни, даже если человек никогда больше не будет писать программы.

"""

Article(
  title = "Архитектор Kotlin: «Язык программирования — рабочий инструмент. Если никогда их не менять, можно отстать от жизни»",
  url = "https://dev.by/lenta/main/arhitektor-kotlin-yazyk-programmirovaniya-rabochiy-instrument",
  categories = listOf(
    "Kotlin"
  ),
  type = article,
  lang = RU,
  author = "yankoits",
  date = LocalDate.of(2016, 6, 9),
  body = body
)
