
import link.kotlin.scripts.dsl.Article
import link.kotlin.scripts.dsl.Enclosure
import link.kotlin.scripts.dsl.LanguageCodes.RU
import link.kotlin.scripts.dsl.LinkType.article
import java.time.LocalDate

// language=Markdown
val body = """
![sd-podcast-logo](https://sdcast.ksdaemon.ru/wp-content/uploads/2014/06/sd-podcast-logo-200x200.png) Рад представить вам 41-й выпуск подкаста! Этот эпизод посвящен языку Kotlin, у меня в гостях Андрей Бреслав, руководитель проекта Kotlin в компании JetBrains.

В начале выпуска мы поговорили о том, зачем вообще нужен еще один язык, Андрей рассказал про историю и предпосылки появления Kotlin, как все начиналось и развивалось.

Обсудили так же общие теоретические аспекты разработки языков программирования: чем разработка языка отличается от разработки каких-либо других программных продуктов, какие компоненты являются основой для построения языка, на какие аспекты следует обращать особое внимание и как правильно заложить архитектуру.

Так же Андрей рассказал, почему в качестве платформы была выбрана JVM, рассказал некоторые технические подробности реализации проекта. Подробно рассказал про interop с Java, о том, как можно начать использовать Kotlin в уже существующем проекте на Java сейчас, и как они у себя, в компании JetBrains уже начали это делать.

Не обошли мы сторой и социальную составляющую проекта. Код языка Kotlin выложен в open source на github. Андрей рассказал про сообщество, которое сформировалось вокруг проекта, и как они с ним взаимодействуют, обсуждают запросы на новый функционал, баг-репорты и все прочее.

В завершение выпуска, Андрей поделился планами по развитию языка как в ближайшем будущем, так и в долгосрочной перспективе.

Ссылки на ресурсы по темам выпуска:

* Андрей в соц сетях:
  * [Twitter](https://twitter.com/abreslav)
  * [Facebook](https://fb.com/abreslav)
  * [ВКонтакте](https://vk.com/abreslav)
  * [LinkedIn](https://www.linkedin.com/in/abreslav)
* [Основной сайт проекта kotlinlang.org](https://kotlinlang.org/)
* [Репозиторий на github](https://github.com/JetBrains/kotlin)
* [Пост в блоге проекта о релизе 1.0](http://blog.jetbrains.com/kotlin/2016/02/kotlin-1-0-released-pragmatic-language-for-jvm-and-android/)
* Несколько видео докладов про Kotlin Андрея Бреслава и Дмитрия Жемерова:
  * [Что такое Kotlin? Введение](https://www.youtube.com/watch?v=HWyd1gYMkl0)
  * [Kotlin: самое сложное — совместимость](https://www.youtube.com/watch?v=LWFx4QWrTyo)
  * [Kotlin для Android: коротко и ясно](https://www.youtube.com/watch?v=VU_L2_XGQ9s)
  * [Kotlin: сессия вопросов и ответов со встречи JUG.ru 04.03.2016](https://www.youtube.com/watch?v=YOmdOTlhZa8)


"""

Article(
  title = "SDCast #41: в гостях Андрей Бреслав, руководитель проекта Kotlin в компании JetBrains",
  url = "https://sdcast.ksdaemon.ru/2016/03/sdcast-41/",
  categories = listOf(
    "Kotlin",
    "Podcast"
  ),
  type = article,
  lang = RU,
  author = "Андрей Бреслав, Константин Буркалев",
  date = LocalDate.of(2016, 3, 11),
  body = body,
  enclosure = Enclosure(
    url = "https://sdcast.ksdaemon.ru/podlove/file/159/s/download/SDCast-41.ogg",
    size = 22683272
  )
)
