
import link.kotlin.scripts.dsl.Article
import link.kotlin.scripts.dsl.LinkType.*
import link.kotlin.scripts.dsl.LanguageCodes.*
import java.time.LocalDate

// language=Markdown
val body = """
I am a huge Android fanboy, and have been one ever since the Nexus One came out. The Android OS has evolved so much and into so many variations. Almost a year ago, one of the Android developers I follow on Twitter was pushing for Kotlin to be the main language for Android. What was more interesting was it was retweeted by an Android Developer from Google. Fast forward to around this time, and the guys behinds IntelliJ announce 1.0 of Kotlin.

I decided to see what the big hype was about on Kotlin. Consider this blog as a first impression rather than a review.

## Going from Java to Kotlin

[Kotlin](https://github.com/Kotlin) (for the most part) is similar to Groovy and Scala, as it runs on a JVM. It can also be compiled to JavaScript.

I took the time to learn the syntax by first going to its official website. It’s advertised that Kotlin should be easy to pick up if you already code in Java, and it is interoperable with existing Java frameworks. I’ve been a Java developer most of my life, so I figured it wouldn’t be too hard to learn Kotlin.

The [official website](https://kotlinlang.org/) had a nice tutorial section for it. Here are a couple of cool things about the syntax I liked:

*   Types are defined after the variable name.
    In Java, you would declare variables with the type first then the variable name like `private int x;` while the Kotlin equivalent is `var x: Int`.
    The type can also be inferred `var x = 1 //is Int initialized to 1`.
*   Variables can be declared as nullable with `?`.
    For example: `y?.length`. If y is null, then return null. Otherwise return `y.length`.
*   Smart Casts! If a variable is of certain type, it is already cast to that type.
    For example: `if (a is String) print(a.length)`

There are a lot more that I liked, but to keep this blog short, I suggest you check out [the official website](https://kotlinlang.org/).

## Kotlin in Android Studio

It has been a while since I played around with the Android API. The last time I messed around with an Android app was around the time Android was known as “Jelly Bean.”

So, that said, I had to familiarize myself with the newer APIs such as [RecyclerView](http://developer.android.com/reference/android/support/v7/widget/RecyclerView.html) and new UI elements from the Design Support Library. Luckily, since Android Studio is from the same guys who did Kotlin, it was easy to integrate Kotlin into the SDK.

First, I created a new project in Android Studio which created a default main activity. Then with the Android Studio Kotlin plugin, I am able to invoke an action to convert from Java to Kotlin. This will convert the Java code thats autogenerated in MainActivity.java to Kotlin in MainActivity.kt. It will also add the Kotlin dependency to your build.gradle.

## Put away that Butterknife

A nice Kotlin feature worth mentioning is that within an Activity or Fragment, you don’t have to call on findViewById to get a View widget. Simply refer to it by id.

So, instead of `TextView myTextView = (TextView) findViewById(R.id.myTextView)`, you can simply refer to the TextView widget by `myTextView`. Kotlin will get the reference to that view.

## So, overall?

Rather than making, say, a Hello World app or an app with a generic List view, I decided to try out creating an app that plays sounds using MediaPlayer API to challenge myself.

![Kotlin](https://www.javacodegeeks.com/wp-content/uploads/2016/04/Kotlin.png)

During my experience with it as I coded the activities, inflating layouts, and RecyclerView adapters, I think I spent more time going back to the Android API documentation than I did with Kotlin. At first I had to refer back to the Kotlin docs to look up stuff until I got use to the syntax.

What I liked most about Kotlin was there were less lines of code. When comparing things I would do in Java that would take a couple of lines, I could accomplish the same in Kotlin with just one line. Less lines of code is pleasant to my tiring eyes. Plus, less boilerplate which is helpful, especially in Android.

## Anko

You could also use [Anko](https://github.com/Kotlin/anko) which is a UI library written in Kotlin. Instead of XML, Anko does the UI in DSL. I heard much praise for this tool. But as I started playing around with Kotlin, I wanted to be more familiar with Android’s default XML layout UI.

Maybe one day I’ll write another blog on Anko or something :).

## The future...

So what are the chances that Kotlin will indeed be the official, main go-to when coding in Android?

There have been rumors that Google is seeking to stray away from Java for Android development, there have been reports that [Google is looking into adopting Apple’s Swift language](http://thenextweb.com/dd/2016/04/07/google-facebook-uber-swift/). However, that same report also stated that Google isn’t considering Kotlin because of its long build times.

With all that said, if you’re an existing Java developer looking into something new or looking into developing Android apps, I would suggest to look into Kotlin and give it a try.

"""

Article(
  title = "Kotlin + Android First Impressions",
  url = "https://www.javacodegeeks.com/2016/04/kotlin-android-first-impressions.html",
  categories = listOf(
    "Kotlin",
    "Android"
  ),
  type = article,
  lang = EN,
  author = "Keyhole Software",
  date = LocalDate.of(2016, 4, 20),
  body = body
)
