
import link.kotlin.scripts.dsl.Article
import link.kotlin.scripts.dsl.LanguageCodes.RU
import link.kotlin.scripts.dsl.LinkType.article
import java.time.LocalDate

// language=Markdown
val body = """
15 февраля 2016 года компания JetBrains выпустила версию 1.0 языка Kotlin, находившегося в разработке около пяти лет. Работает этот язык поверх JVM. Что такое Java, мы уже рассмотрели в отдельной статье с Александром Михальченко. Сегодня мы снова собрались с ним, на этот раз для разговора о Kotlin - о том, чем хорош этот язык и чем плох, как для разработчиков, так и для предпринимателей.

**Привет, Саш.**  

И тебе привет.

**Итак, что, собственно, такое Kotlin?**  

Язык программирования, разработанный компанией JetBrains, работающий на платформе Java. Он использует JDK, как и сама Java, но имеет другой синтаксис. Решение не ново - уже существуют языки, которые так делают: Scala и Closure, например. Появились они, в основном, из-за проблем с самой Java в плане синтаксиса. То есть, Java - язык надежный, хороший, добротный, на нём можно писать серверные приложения, но синтаксис у него, скажем так, излишне многословный. Дело в том, что разработчики Java довольно инертно её дорабатывают. Они стараются по максимуму поддерживать обратную совместимость и считают, что у пользователей, перешедших на новую версию, должен работать код, написанный ещё в 95-м. У них даже лозунг такой: "написанное однажды работает везде". Это, конечно, больше про кроссплатформенность...

**...но они решили копнуть глубже?**

Да - написано на одной версии, будет работать на всех следующих.

**Смело!**

В этом, собственно, и заключается проблема - ничего старого из языка они не выкидывают. Из-за этого замедляется его развитие. Со временем появляется всевозможный мусор. Там даже есть метка для устаревших классов, которая стоит над ними внутри самого JDK. В документации, конечно, говорится, что если такая метка появилась, то в одной из следующих версий устаревшая функциональность может исчезнуть, но мне такие случаи неизвестны.

**Сами разработчики понимают, что эти устаревшие методы уже давным-давно никто не использует?**

Они понимают и даже настаивают на том, чтобы эти методы не использовали. Но поскольку есть софт, написанный на старых версиях, не получится так просто убрать старый код. Всё те приложения сломаются.

**От чего же избавился Kotlin?**  

Kotlin и другие JVM-языки помогли разработчикам писать программы с меньшим количеством кода. Помимо всего того, что есть в Java, они добавляют вещи из мира функционального программирования. Это значительно облегчает написание кода - делает его короче и выразительнее. Чем меньше кода мы пишем, тем меньше кода нужно поддерживать, писать меньше тестов. Собственно, большинство языков появилось по этой самой причине - поменять синтаксис Java, сделать его более удобным, более прагматичным.

**Насколько сейчас актуален этот язык?**  

Сейчас он не то, чтобы слишком популярен - язык молодой, сообщество ещё не набралось. По причине своей молодости Kotlin ещё не в силах конкурировать с той же Scala - более мощным языком с длинной историей. Там уже и над ошибками поработали, и добавили кучу интересных вещей, а Kotlin это только предстоит. В этом более зрелые языки пока что его переигрывают. Но тем не менее, амбиций Kotlin не занимать: язык разрабатывали пять лет, разработчики старались сделать его как можно прагматичнее и не допустить ошибок, которые есть в Java, чтобы "написано однажды" не было высечено в камне и язык можно было развивать. Обещают много интересных фич в будущем, которые в том числе покроют функциональность, имеющуюся на данный момент в Scala.

**Как и Java, Kotlin лучше подойдёт большим проектам?**  

Да. По синтаксису, его можно использовать просто как дополнение к Java. Берём стек Java, к примеру, для серверных приложений, и просто заменяем Java на Kotlin. Всё будет работать, при этом, писать код станет проще. Вопрос заключается лишь в том, что выбрать вместо Java. На сегодняшний день, думаю, многие разработчики всё же остановятся на Scala.

**А тебе что больше по душе - Kotlin или Scala?**  

Мне нравятся оба языка. Думаю, что Kotlin дальше пойдёт в плане Android. Есть, конечно, возможность писать Android-приложения на Scala, но там есть проблема: большой runtime. Она за собой тащит кучу библиотек, из-за чего увеличивается размер apk-файла. У Kotlin же самый маленький runtime среди всех остальных языков (кроме Java). Обычно это Java плюс "что-то", и это "что-то" - это overhead, который за собой язык тащит. У Kotlin он самый маленький - около 700 кб, в то время как у Scala - несколько мегабайт.

**Какие недостатки у Kotlin?**  

Сам я пока что не натыкался ни на какие баги, с компилятором или чем-то другим у меня проблем тоже не было. По поводу синтаксиса - он справлялся с задачами, с которыми я сталкивался. В чём он уступает той же Scala - это в работе с многопоточностью. Java, к слову, тоже в этом проигрывает. У Scala есть future API, которая позволяет выполнять асинхронные задачи в несколько потоков и при этом получается нормальный код вместо мешанины, где разные секции работают в разных потоках и при этом не видна их связь. Scala всё это структурирует средствами своего синтаксиса. В Kotlin что-то такое обещали реализовать в версии 1.1. Но в целом, мне нравится работать на Kotlin из-за его добротного синтаксиса.

**Что скажешь насчёт безопасности Kotlin?**  

Тут вот в чём дело: весь код, написанный на Kotlin, в дальнейшем преобразуется в Java-код. Своего он ничего не добавляет. Соответственно, насколько безопасна Java, настолько безопасен и Kotlin. Если мы говорим о безопасности написания кода, то мне очень нравится null safety в Kotlin. Компилятор может предупредить программиста о том, что ссылка может быть пустой. Если мы попробуем с ней что-то сделать, произойдет ошибка на этапе компиляции. В Java же приложение просто упадет на этапе выполнения.

**Что Kotlin может предложить бизнесу? Чем он заинтересует бизнесменов?**  

Если сравнивать с Java то разработка на Kotlin обойдётся дешевле. Почему? Нужно писать меньше кода и меньше кода поддерживать. Это значит, что код писать проще, а следовательно, приложение будет разрабатываться быстрее. А как известно, время - это деньги.

**Маленькие проекты и Kotlin.**  

Если мы говорим о каких-то маленьких десктопных приложениях, то для коммерческого использования лучше брать С++. Опять же, Kotlin в дальнейшем транслируется в Java, поэтому, насколько Java хороша в какой-то области, настолько хорош и Kotlin. Kotlin больше помогает писать программы, непосредственную пользу он приносит в первую очередь программистам.

**Спасибо большое за интервью, Саш. Было интересно!**

Всегда рад.

**Итого**

По сути, прямое назначение Kotlin - облегчить жизнь программистов, дать им возможность уместить в одну строчку кода то, что в Java заняло бы пять. Как сказал Александр, по ощущениям это сродни смене старого Ford Focus на новенький BMW M3 - когда почувствуешь этот полёт, на старые колёса не захочется возвращаться.

Несомненным преимуществом является полная совместимость с Java, в том числе и обратная. Все библиотеки для Java будут работать на Kotlin и наоборот. Также этот язык открывает прелести тех же Closure и Scala для Android-разработчиков. Порадуются и предприниматели, ведь теперь проекты будут делаться быстрее и дешевле.

Минус у языка один - его юный возраст. Однако, судя по тому, что JetBrains целых пять лет потратили на его разработку, очень сомнительно, что они забросят своё детище в ближайшие годы. Поэтому уже сейчас можно и нужно брать Kotlin на вооружение - тем более, если вы разрабатываете приложения для Android.

"""

Article(
  title = "Kotlin: как сделать жизнь Java-разработчика легче?",
  url = "https://dev.by/lenta/anadea/kotlin-kak-sdelat-zhizn-java-razrabotchika-legche",
  categories = listOf(
    "Kotlin",
    "Android"
  ),
  type = article,
  lang = RU,
  author = "Stanislav Sinitsky, Alexander Mikhalchenko",
  date = LocalDate.of(2016, 12, 7),
  body = body
)
