
import link.kotlin.scripts.dsl.Article
import link.kotlin.scripts.dsl.LinkType.*
import link.kotlin.scripts.dsl.LanguageCodes.*
import java.time.LocalDate

// language=Markdown
val body = """
Last week, there was a wonderful announcement: (see title of post)! No more milestones, betas, or release candidates required! Obviously, release candidates for later versions will be coming out, but now you don’t have to worry about them if you don’t want to.

If you’re like me and were waiting until release before trying to convince company management to consider Kotlin as a development option, now is the time to speak out!

In celebration of Kotlin’s proper release, I will be doing a short series of articles describing some of my favorite things about the language. Starting this weekend with a quick overview of smaller features that I don’t have a ton to say about. I’m calling it Kotlin Month, and I only slightly regret that the first one will be in one month while the others are in the next month :P

Also, you may notice that there’s now a page at the top pertaining to Kotlin articles. This won’t be much more useful than selecting the Kotlin tag from the tag cloud to the right, but it will at least stay there, even if Kotlin posts dwindle far enough to remove the tag from the cloud.
"""

Article(
  title = "Kotlin 1.0 is finally released!",
  url = "https://programmingideaswithjake.wordpress.com/2016/02/22/kotlin-1-0-is-finally-released/",
  categories = listOf(
    "Kotlin"
  ),
  type = article,
  lang = EN,
  author = "Jacob Zimmerman",
  date = LocalDate.of(2016, 2, 23),
  body = body
)
