
import link.kotlin.scripts.dsl.Article
import link.kotlin.scripts.dsl.LinkType.*
import link.kotlin.scripts.dsl.LanguageCodes.*
import java.time.LocalDate

// language=Markdown
val body = """

Welcome the Kotlin Digest of Q1 2016. It was in this quarter that Kotlin 1.0 was released, and naturally the number of articles and coverage received has substantially increased.
We want to thank everyone for their contributions, and highlight some of the most notable articles and blog posts.

<center>![2016Q1Cover](http://i0.wp.com/blog.jetbrains.com/kotlin/files/2016/04/2016Q1Cover.png?resize=640%2C320)</center>

By the way, you can [join us on slack](http://kotlinslackin.herokuapp.com/) and subscribe to the _#feed_ channel, where we push quite a bit of interesting content as it appears.

# General Articles

* [Kotlin 1.0 Is Now Available and the Newest JVM Language Is a Breeze](https://dzone.com/articles/kotlin-10-is-now-available)
* Two Q&A of Kotlin’s project lead Andrey Breslav on [DZone](https://dzone.com/articles/a-qa-with-andrey-breslav-on-kotlin) and [InfoQ](http://www.infoq.com/news/2016/02/kotlin-10-released)
* [Kotlin: a new JVM language you should try](https://opencredo.com/kotlin/) by [Rafal Gancarz](https://twitter.com/rafalgancarz)
* [Kotlin: The Ying and Yang of Programming Languages](https://www.linkedin.com/pulse/kotlin-ying-yang-programming-languages-eric-kolotyluk) by [Eric Kolotyluk](https://www.linkedin.com/in/eric-kolotyluk-7462253?trk=pulse-det-athr_prof-art_hdr)
* [Kotlin – 2 Years On](https://yobriefca.se/blog/2016/02/24/kotlin-2-years-on/) by [James Hughes](https://twitter.com/kouphax)

# Android

* [Kotlin awesome tricks for Android](http://antonioleiva.com/kotlin-awesome-tricks-for-android/) by Antonio Leiva (author of [Kotlin for Android Developers](https://leanpub.com/kotlin-for-android-developers) book)
* Series of posts [Kotlin & Android: A Brass Tacks Experiment](https://medium.com/@CodingDoug/kotlin-android-a-brass-tacks-experiment-part-1-3e5028491bcc#.d0dy6mji7) by [Doug Stevenson](https://www.linkedin.com/in/doug-stevenson-95509b22) (Developer Advocate in Google)
* [Getting Started with Kotlin and Anko on Android](https://realm.io/news/getting-started-with-kotlin-and-anko/) by [Donn Felker](https://twitter.com/donnfelker) from Realm
* [Roberto Perez](https://www.linkedin.com/in/raperez) shared his expirience in [creating an AndroidWear watchface using Kotlin](https://medium.com/@robj.perez/creating-an-androidwear-watchface-using-kotlin-e5f725813fa9)

# Web Development

* Two great posts by [Sébastien Deleuze](https://twitter.com/sdeleuze) from Spring: [Developing Spring Boot applications with Kotlin](https://spring.io/blog/2016/02/15/developing-spring-boot-applications-with-kotlin) and [A Geospatial Messenger with Kotlin, Spring Boot and PostgreSQL](https://spring.io/blog/2016/03/20/a-geospatial-messenger-with-kotlin-spring-boot-and-postgresql)
* Three-part article by [Mike Gehard](https://twitter.com/mikegehard) from Pivotal: [The Journey of a Spring Boot application from Java 8 to Kotlin: The Application Class](http://engineering.pivotal.io/post/spring-boot-application-with-kotlin/)
* [Nicolas Frankel](https://twitter.com/nicolas_frankel) wrote about his [experiments with Spring Boot, Vaadin, and Kotlin](https://dzone.com/articles//playing-with-spring-boot-vaadin-and-kotlin)
* [Writing a RESTful backend using Kotlin and Spring Boot](https://medium.com/@dime.kotevski/writing-a-restful-backend-using-kotlin-and-spring-boot-9f162c96e428) by [Dimitar Kotevski](https://twitter.com/dimitar_)
* [Rest API plumbing with kotlin](https://medium.com/@gz_k/rest-api-plumbing-with-kotlin-b161af052178) by [Gaëtan Zoritchak](https://twitter.com/gz_k)

# Ecosystem

* [TornadoFX](https://dzone.com/articles/a-new-javafx-app-framework-for-kotlin-tornadofx) — a new JavaFX app framework for Kotlin
* [KillerTask](http://inaka.net/blog/2016/01/25/killertask-the-solution-to-asynctask-implementation/) — a solution to AsyncTask implementation
* [PaperParcel](http://blog.bradcampbell.nz/introducing-paperparcel/) — a new annotation processor that automatically generates type-safe [Parcelable](http://developer.android.com/intl/es/reference/android/os/Parcelable.html) boilerplate code for Kotlin and Java
* [Kotlin + RxJava = Functional Powerhouse](http://tomstechnicalblog.blogspot.ru/2016/02/kotlin-rxjava-what-rxjava-should-be.html)
* [Kotlin : Retrofit + RxAndroid + Realm](https://medium.com/@ahmedrizwan/kotlin-retrofit-rxandroid-realm-39d7be5dc9dc)
* [Using Dagger 1 and Kotlin](http://michaelevans.org/blog/2016/02/17/using-dagger-1-and-kotlin/)
* [Using libGDX with Kotlin](http://obviam.net/index.php/libgdx-and-kotlin/) and [creating a simple 2D platformer](http://obviam.net/index.php/libgx-and-kotlin-2d-platformer-prototyping/)

# Features overwiew

* [Kotlin for Java Developers: 10 Features You Will Love About Kotlin](http://petersommerhoff.com/dev/kotlin/kotlin-for-java-devs/)
* [10 Features I Wish Java Would Steal From the Kotlin Language](http://blog.jooq.org/2016/03/31/10-features-i-wish-java-would-steal-from-the-kotlin-language/)
* [Kotlin — Love at first line](https://medium.com/@dime.kotevski/kotlin-love-at-first-line-7127befe240f#.kan4x5dyg)
* [An Introduction to Kotlin](https://objectpartners.com/2016/02/23/an-introduction-to-kotlin/)
* [Kotlin, superseding the language we love](http://www.endran.nl/blog/kotlin-super-seeding-the-language-we-love-2)
* [Kotlin, the somewhat obscure modern Android-friendly programming language](https://medium.com/math-camp-engineering/kotlin-3e963864db9e#.4hxqlfnvn)

# Technical

* [A Very Peculiar, but Possibly Cunning Kotlin Language Feature](http://blog.jooq.org/2016/02/22/a-very-peculiar-but-possibly-cunning-kotlin-language-feature/)
* [Solving the Josephus problem in Kotlin](https://blog.frankel.ch/solving-the-josephus-problem-in-kotlin) & [update](https://blog.frankel.ch/feedback-jospehus-problem)
* [Kotlin: Easily storing a list in SharedPreferences with Custom Accessors](http://blog.dennislysenko.com/2016/01/22/kotlin-easily-storing-a-list-in-sharedpreferences-with-custom-accessors/)
* [Using Kotlin Extensions for Rx-ifying](http://vishnurajeevan.com/2016/02/13/Using-Kotlin-Extensions-for-Rx-ifying/)
* [Using Mockito for unit testing with Kotlin (1/x)](http://makingiants.com/blog/using-mockito-for-unit-tests-with-kotlin-1x/)
* [Using Kotlin For Tests in Android](https://medium.com/@sergii/using-kotlin-for-tests-in-android-6d4a0c818776)

# Kotlin series

* [Juan Saravia](https://twitter.com/juanchosaravia) started his series of stories about learning Kotlin, while developing an Android App
  * [Introduction: A few words about this](https://medium.com/@juanchosaravia/learn-kotlin-while-developing-an-android-app-introduction-567e21ff9664)
  * [Part 1: Configuring Android Studio with Kotlin](https://medium.com/@juanchosaravia/learn-kotlin-while-developing-an-android-app-part-1-e0f51fc1a8b3)
  * [Part 2: MainActivity.kt: Syntax, Null Safety and more...](https://medium.com/@juanchosaravia/learn-kotlin-while-developing-an-android-app-part-2-e53317ffcbe9)
  * [Part 3: NewsFragment.kt: Extension Functions, Android Extensions...](https://medium.com/@juanchosaravia/keddit-part-3-extension-functions-android-extensions-and-more-faa7d232f232)
  * [Part 4: RecyclerView — Delegate Adapters & Data Classes with Kotlin](https://medium.com/@juanchosaravia/keddit-part-4-recyclerview-delegate-adapters-data-classes-with-kotlin-9248f44327f7)
  * [Part 5: Kotlin, RxJava & RxAndroid](https://medium.com/@juanchosaravia/keddit-part-5-kotlin-rxjava-rxandroid-105f95bfcd22)
  * [Part 6: API — Retrofit & Kotlin](https://medium.com/@juanchosaravia/keddit-part-6-api-retrofit-kotlin-d309074af0)
* Kotlin Month series by Jacob Zimmerman
  * [Post 1: Assorted Features](https://programmingideaswithjake.wordpress.com/2016/02/27/kotlin-month-post-1-assorted-features/)
  * [Post 2: Inheritance and Defaults](https://programmingideaswithjake.wordpress.com/2016/03/05/kotlin-month-post-2-inheritance-and-defaults/)
  * [Post 3: Safety](https://programmingideaswithjake.wordpress.com/2016/03/13/kotlin-month-post-3-safety/)
  * [Post 4: Properties](https://programmingideaswithjake.wordpress.com/2016/03/19/kotlin-month-post-4-properties/)
* by [Ciro Rizzo](https://github.com/cirorizzo):
  * [My Kotlin Adventure](http://www.cirorizzo.net/2016/01/23/kotlin-at-glance/)
  * [Kotlin Coding](http://www.cirorizzo.net/2016/02/03/kotlin-code/)
  * Building a Kotlin project ([part 1](http://www.cirorizzo.net/2016/03/04/building-a-kotlin-project/) and [part 2](http://www.cirorizzo.net/2016/03/04/building-a-kotlin-project-2/))


"""

Article(
  title = "Kotlin Digest 2016.Q1",
  url = "http://blog.jetbrains.com/kotlin/2016/04/kotlin-digest-2016-q1/",
  categories = listOf(
    "Kotlin",
    "Digest"
  ),
  type = article,
  lang = EN,
  author = "Roman Belov",
  date = LocalDate.of(2016, 4, 6),
  body = body
)
