

import link.kotlin.scripts.dsl.Article
import link.kotlin.scripts.dsl.LanguageCodes.EN
import link.kotlin.scripts.dsl.LinkType.article
import java.time.LocalDate

// language=Markdown
val body = """
We’re happy to announce the release of Kotlin 1.1.2, the second bugfix and tooling update for Kotlin 1.1. The update brings performance improvements to the compiler and the IntelliJ IDEA plugin, several new features in the tools, and lots of bugfixes in all areas. Kotlin 1.1.2 also brings compatibility with version 2.4.0-alpha of the Android Gradle plugin.

The complete list of changes in this release can be found in the [changelog](https://github.com/JetBrains/kotlin/blob/1.1.2/ChangeLog.md).

We’d like to thank our external contributors whose pull requests were included in this release: [Yoshinori Isogai](https://github.com/shiraji) and [Jonathan Leitschuh](https://github.com/JLLeitschuh). Thanks to everyone who tried the EAP builds and sent us feedback, too!

## Migration Notes

The Kotlin compiler now requires JDK 8 to run. You shouldn’t notice any changes, because most other Java development tools such as Gradle and the Android toolchain also require JDK 8, so you almost certainly already have it installed. For code generated by the compiler, Java 1.6 compatibility is still the default, and we have no plans to drop support for generating Java 1.6 compatible bytecode.

An object can no longer be declared inside an inner class. Such an object would be able to access the outer class instance, which is conceptually impossible because an object is always a singleton. inner sealed class’es are also prohibited. This is a temporary limitation which will be removed when we add the possibility to declare a subclass of an inner sealed class inside its outer class, and not inside the inner class itself. ([KT-16232](https://youtrack.jetbrains.com/issue/KT-16232), [KT-16233](https://youtrack.jetbrains.com/issue/KT-16233))

Using a declaration with a name consisting entirely of underscore characters now always requires backticks. ([KT-16264](https://youtrack.jetbrains.com/issue/KT-16264))

## Maven Incremental Compilation

Since Kotlin 1.1.2, incremental compilation which was previously available for IntelliJ IDEA and Gradle builds is now supported for Maven. To enable, set the `kotlin.compiler.incremental` property to true, using either the -D command line argument or the `properties` tag:

```xml
<properties>
    <kotlin.compiler.incremental>true</kotlin.compiler.incremental>
</properties>
```

## Maven Annotation Processing

Kotlin’s annotation processing tool, kapt, can now be invoked from Maven builds. Just add an execution of the `kapt` goal from kotlin-maven-plugin before `compile`:

```xml
<execution>
    <id>kapt</id>
    <goals>
        <goal>kapt</goal>
    </goals>
    <configuration>
        <sourceDirs>
            <sourceDir>src/main/kotlin</sourceDir>
            <sourceDir>src/main/java</sourceDir>
        </sourceDirs>
        <annotationProcessorPaths>
            <!-- Specify your annotation processors here. -->
            <annotationProcessorPath>
                <groupId>com.google.dagger</groupId>
                <artifactId>dagger-compiler</artifactId>
                <version>2.9</version>
            </annotationProcessorPath>
        </annotationProcessorPaths>
    </configuration>
</execution>
```

[Here](https://github.com/JetBrains/kotlin-examples/blob/master/maven/dagger-maven-example/pom.xml) is a complete example of the POM file with Java-Kotlin code support and tests.

Please note that `kapt` is still not supported for IntelliJ IDEA’s own build system. Launch the build from the “Maven Projects” toolbar whenever you want to re-run the annotation processing.

## Inline Method Refactoring

We’ve finally implemented the support for Inline Method (Function) in Kotlin code.

## Other IDE Improvements

A large percentage of our efforts in the 1.1.x timeframe is dedicated to improving the performance of the IntelliJ IDEA plugin. We’re releasing several major performance improvements, affecting primarily typing responsiveness, in 1.1.2, and we already have additional major improvements in the pipeline for the 1.1.3 release.

Beyond that, as usual, we’ve implemented a large number of new inspections, quickfixes and small IDE features in this release. Specifically worth mentioning are the support for folding Android String resource references in the editor, as well as new quickfixes for dealing with Android API version issues.

## How to update

To update the plugin, use Tools | Kotlin | Configure Kotlin Plugin Updates and press the “Check for updates now” button. Also, don’t forget to update the compiler and standard library version in your Maven and Gradle build scripts.

As usual, if you run into any problems with the new release, you’re welcome to ask for help on the [forums](https://discuss.kotlinlang.org/), on Slack (get an invite [here](http://kotlinslackin.herokuapp.com/)), or to report issues in the [issue tracker](https://youtrack.jetbrains.com/issues/KT).

Let’s Kotlin!
"""

Article(
  title = "Kotlin 1.1.2 is out",
  url = "https://blog.jetbrains.com/kotlin/2017/04/kotlin-1-1-2-is-out/",
  categories = listOf(
    "Kotlin"
  ),
  type = article,
  lang = EN,
  author = "Dmitry Jemerov",
  date = LocalDate.of(2017, 4, 25),
  body = body
)
