category("Android") {
  subcategory("Libraries") {
    link {
      github = "JakeWharton/kotterknife"
      setPlatforms(ANDROID)
      setTags("bindings")
    }
    link {
      github = "MarcinMoskala/ActivityStarter"
      setPlatforms(ANDROID)
    }
    link {
      github = "MarcinMoskala/KotlinPreferences"
      setPlatforms(ANDROID)
      setTags("preferences")
    }
    link {
      github = "MarcinMoskala/PreferenceHolder"
      setPlatforms(ANDROID)
      setTags("preferences")
    }
    link {
      github = "nsk-mironov/kotlin-jetpack"
      setPlatforms(ANDROID)
      setTags("bindings")
    }
    link {
      github = "pawegio/KAndroid"
      setPlatforms(ANDROID)
      setTags("extensions")
    }
    link {
      github = "chibatching/Kotpref"
      setPlatforms(ANDROID)
      setTags("preferences")
    }
    link {
      github = "TouK/bubble"
      setPlatforms(ANDROID)
    }
    link {
      github = "ragunathjawahar/kaffeine"
      setPlatforms(ANDROID)
    }
    link {
      github = "mcxiaoke/kotlin-koi"
      setPlatforms(ANDROID)
    }
    link {
      github = "PicsArt/stateful"
      setPlatforms(ANDROID)
    }
    link {
      github = "BennyWang/KBinding"
      setTags("bindings")
      setPlatforms(ANDROID)
    }
    link {
      github = "inaka/KillerTask"
      setTags("AsyncTasks")
      setPlatforms(ANDROID)
    }
    link {
      github = "grandstaish/paperparcel"
      desc = "Boilerplate reduction library written specifically for working with Kotlin data classes on Android."
      setTags("annotation processing")
    }
    link {
      github = "andre-artus/AnvilKotlin"
      desc = "Minimal UI library for Android inspired by React."
      setTags("react", "view")
    }
    link {
      github = "mathcamp/fiberglass"
      desc = "Easy lightweight SharedPreferences library for Android in Kotlin using delegated properties."
      setTags("SharedPreferences")
    }
    link {
      github = "nitrico/LastAdapter"
      desc = "Don't write a RecyclerView adapter again. Not even a ViewHolder!."
      setTags("RecyclerView", "ViewHolder")
    }
    link {
      github = "denisidoro/krouter"
      desc = "A lightweight Android activity router."
      setTags("router", "android")
    }
    link {
      github = "metalabdesign/AsyncAwait"
      desc = "async/await for Android built upon coroutines introduced in Kotlin 1.1."
      setTags("async", "await", "android")
    }
    link {
      github = "jupf/staticlog"
      desc = "StaticLog - super lightweight static logging for Kotlin, Java and Android."
      setTags("logging", "android")
    }
    link {
      github = "zserge/anvil"
      desc = "Minimal UI library for Android inspired by React."
      setTags("layout")
    }
    link {
      github = "robinchew/mvil"
      desc = "'Virtual DOM' for Android inspired by Anvil."
      setTags("layout")
    }
    link {
      github = "DanielMartinus/Stepper-Touch"
      desc = "Fun playful Android stepper widget for counting, written in Kotlin."
      setTags("widget", "counter", "ui")
    }
    link {
      github = "GlimpseFramework/glimpse-framework-android"
      desc = "OpenGL made simple."
      setTags("opengl")
    }
    link {
      github = "infotech-group/android-drawable-dsl"
      desc = "DSL for constructing the drawables in Kotlin instead of in XML."
      setTags("drawable", "dsl")
    }
    link {
      github = "zsmb13/MaterialDrawerKt"
      desc = "A DSL for creating Material Design navigation drawers without any XML."
      setTags("dsl")
    }
    link {
      github = "SnowdreamFramework/ToyBricks"
      desc = "Android Library that provide simpler way to achieve modularity."
      setTags("apt")
    }
    link {
      github = "DanielMartinus/Konfetti"
      desc = "Lightweight particle system to create realistic confetti"
      setTags("library", "particle", "confetti", "ui", "konfetti", "confetti")
    }
    link {
      github = "rahulchowdhury/Mystique"
      desc = "A generalized adapter for RecyclerView on Android which makes it easy to add heterogeneous items to a list."
      setTags("recycler view")
    }
    link {
      github = "calintat/alps"
      desc = "Android library for preferences which includes property delegates and a custom DSL for definining preferences."
      setTags("android-library", "kotlin", "preferences", "dsl")
    }
    link {
      github = "costular/kotlin-android-utils"
      desc = "Android utilities for easier and faster Kotlin programming."
      setTags("kotlin", "kotlin-android", "android-utils",
        "fragments", "activity", "permissions", "utils", "notifications", "android-kotlin", "library")
    }
    link {
      github = "rakshakhegde/ObservableFlow"
      desc = "Functional Constructs for Databinding + Kotlin + RxJava"
      setTags("library", "functional", "reactive", "databinding", "rxjava")
    }
    link {
      github = "programmerr47/ganalytics"
      desc = "A tiny api layer for any analytics in application."
      setTags("kotlin", "kotlin-android", "analytics", "android-analytics")
    }
    link {
      github = "line/clay"
      desc = "Clay is an Android library project that provides image trimming which is originally an UI component of LINE Creators Studio."
      setTags("trimming")
    }
    link {
      github = "WindSekirun/RichUtilsKt"
      desc = "Advancement Utils for Android Developer written in Kotlin."
    }
    link {
      github = "TradeMe/MapMe"
      desc = "A library that brings the adapter pattern and DiffUtil to Google Maps and MapBox."
      setTags("diffutil", "googlemaps", "mapbox", "maps", "kotlin", "kotlin-android", "recyclerview", "markers")
    }
    link {
      github = "iglaweb/Ferris-Wheel"
      desc = "Simple android library to present an animated ferris wheel"
      setTags("kotlin", "android-library", "animation", "ferris-wheel", "kotlin-android", "customview")
    }
    link {
      github = "ehsunshine/colored-time-selector"
      desc = "A smart colored time selector. Users can select just free time with a handy colorful range selector."
      setTags("selector", "range", "time", "timebar", "kotlin", "kotlin-android", "rangebar", "market")
    }
    link {
      github = "yundom/kache"
      desc = "A lightweight cache library written in Kotlin."
      setTags("cache", "kotlin")
    }
    link {
      github = "adrielcafe/KBus"
      desc = "Dead simple EventBus for Android made with Kotlin and RxJava 2"
      setTags("eventbus", "rxjava")
    }
    link {
      github = "Jintin/MixAdapter"
      desc = "Compose multiple Adapter for RecyclerView in Android."
      setTags("RecyclerView", "Adapter", "kotlin", "kotlin-android")
    }
    link {
      github = "yundom/RxVan"
      desc = "A lightweight event bus written in Kotlin and RxJava."
      setTags("eventbus", "rxjava", "kotlin")
    }
    link {
      github = "duanhong169/DrawableToolbox"
      desc = "The missing drawable toolbox for Android."
      setTags("android-drawables", "kotlin", "kotlin-android")
    }
    link {
      github = "adrielcafe/AndroidCoroutineScopes"
      desc = "This lib implements the most common CoroutineScopes used in Android apps."
      setTags("kotlin", "coroutines", "coroutinescopes")
    }
    link {
      github = "WindSekirun/RxSocialLogin"
      desc = "This Android library is a library that provides social login for 15 platforms powered by RxJava2, Kotlin and Firebase Authentication. "
      setTags("sociallogin", "rxjava", "kotlin")
    }
    link {
      github = "bakhtiyork/gradients"
      desc = "A curated collection of splendid gradients"
      setTags("gradient", "drawable")
    }
    link {
      github = "hpost/rx-brainwaves"
      desc = "RxJava wrapper for NeuroSky MindWave headsets"
      setTags("rxjava2", "rxjava-wrapper", "neurosky-mindwave", "android")
    }
    link {
      github = "adrielcafe/KrumbsView"
      desc = "The ultimate breadcrumbs view for Android!"
      setTags("breadcrumbs", "breadcrumb-navigation")
    }
    link {
      github = "inshiro/Skate"
      desc = "A simple and easy to use Android fragment stack controller"
      setTags("fragment", "controller", "navigation")
    }
    link {
      github = "cortinico/slidetoact"
      desc = "A simple 'Slide to Unlock' Material widget for Android, written in Kotlin"
      setTags("ui", "widget", "material", "kotlin", "kotlin-android", "slider")
    }
    link {
      github = "AppIntro/AppIntro"
      desc = "Make a cool/material intro for you Android App - Now all in Kotlin!"
      setTags("fragment", "intro", "material", "kotlin", "kotlin-android", "viewpager")
    }
    link {
      github = "CuriousNikhil/gossip"
      desc = "Android TextToSpeech Helper to speak any text you want and handle events."
      setTags("kotlin", "coroutines", "TextToSpeech")
    }
    link {
      github = "adrielcafe/PufferDB"
      desc = "An Android & JVM key-value storage powered by Protobuf and Coroutines."
      setTags("kotlin", "coroutines", "rxjava", "protobuf", "storage", "database", "key-value")
    }
    link {
      github = "adrielcafe/HAL"
      desc = "A non-deterministic finite-state machine for Android & JVM that won't let you down."
      setTags("kotlin", "coroutines", "livedata", "fsm", "state-machine", "finite-state-machine")
    }
    link {
      github = "coil-kt/coil"
      desc = "Image loading for Android backed by Kotlin Coroutines."
    }
    link {
      github = "levibostian/Shutter-Android"
      desc = "an Android library to take photos, record videos, pick images/videos from gallery, with ease. Written in Kotlin."
    }
    link {
      github = "skydoves/balloon"
      desc = "A lightweight popup like tooltips, fully customizable with arrow and animations."
    }
    link {
      github = "ChuckerTeam/chucker"
      desc = "An on-device network inspection tool for Android."
    }
    link {
      github = "rosariopfernandes/firecoil"
      desc = "Display images stored in Cloud Storage for Firebase using Coil."
      setTags("kotlin", "coroutines")
    }
    link {
      github = "skydoves/Only"
      desc = "An easy way to persist and run code block only as many times as necessary on Android."
      setTags("preference", "dsl", "persistence")
    }
    link {
      github = "skydoves/AndroidVeil"
      desc = "An easy, flexible way to implement veil skeletons and shimmering effect for Android."
      setTags("skeleton", "shimmer", "ui", "animation")
    }
    link {
      github = "skydoves/Submarine"
      desc = "Fully customizable floating navigation view for listing items dynamically on Android."
      setTags("navigation", "animation", "dsl")
    }
    link {
      github = "skydoves/Needs"
      desc = "An easy way to implement modern permission instructions popup."
      setTags("permission", "popup", "animation")
    }
    link {
      github = "evilthreads669966/EvadeMe"
      desc = "A heuristics evasion library that prevents your code from being analyzed or tested."
      setTags("security", "functional")
    }
    link {
      github = "evilthreads669966/BootLaces"
      desc = "Turns your background service persistent."
      setTags("service", "functional")
    }
    link {
      github = "evilthreads669966/WakeService"
      desc = "An IntentService that keeps your processor awake while doing work."
      setTags("service")
    }
    link {
      github = "evilthreads669966/Pickpocket"
      desc = "An asynchronous Android library for content providers and more."
      setTags("content-providers")
    }
    link {
      github = "evilthreads669966/EasyShells"
      desc = "A simple shell for executing Linux commands with responses"
      setTags("system")
    }
    link {
      github = "mr-wizman/Consent"
      desc = "Easy Android permissions. Powered by Kotlin."
      setPlatforms(ANDROID)
      setTags("permissions")
    }
    link {
      github = "matteocrippa/Parrot"
      desc = "A lightweight library to load remote image and handle caching in ImageView."
      setPlatforms(ANDROID)
      setTags("image", "download")
    }
    link {
      github = "deva666/peko"
      desc = "Android library for requesting runtime permissions with Kotlin Coroutines"
      setTags("permissions", "coroutines", "android", "library")
      setPlatforms(ANDROID)
    }
    link {
      github = "MackHartley/DashedView"
      desc = "The easiest way to create a dashed or striped background on Android"
      setTags("library", "android", "ui")
      setPlatforms(ANDROID)
    }
    link {
      github = "MackHartley/RoundedProgressBar"
      desc = "A customizable, animated progress bar that features rounded corners. This Android library is designed to look great and be simple to use"
      setTags("library", "android", "ui", "progressbar")
      setPlatforms(ANDROID)
    }
    link {
      github = "developingdeveloper-tech/toaster-android"
      desc = "A simple library to add custom toast to android applications."
      setTags("ui", "android", "custom-toast")
      setPlatforms(ANDROID)
    }
    link {
      github = "popovanton0/heart-switch"
      name = "heart-switch"
      desc = "A heart-shaped toggle switch component for Jetpack Compose"
      href = "https://github.com/popovanton0/heart-switch"
      setTags("android", "kotlin", "ui", "toggle", "switch", "heart", "ui-components", "heart-shaped-curve", "toggle-switch", "jetpack-compose", "heart-shape")
      setPlatforms(ANDROID)
    }
    link {
      github = "popovanton0/Blueprint"
      name = "Blueprint"
      desc = "📐 A library that draws a blueprint on top of your Jetpack Compose composables. It visualizes dimensions, like paddings and sizes."
      href = "https://github.com/popovanton0/Blueprint"
      setTags("android", "kotlin", "jetpack-compose", "ui", "layout", "ui-components", "debug", "debugging")
      setPlatforms(ANDROID)
    }
    link {
      github = "itmaginationdemos/OTPComposable"
      name = "OTPComposable"
      desc = "A library dedicated to making OTP (One Time Password) components a breeze to implement"
      setTags("android", "kotlin", "ui", "jetpack-compose")
      setPlatforms(ANDROID)
    }
    link {
      github = "smtrz/FilesCrypter"
      desc = "A lightweight Kotlin library for secure file encryption on Android."
      setTags("android","encryption", "security", "files", "cryptography")
      setPlatforms(ANDROID)
    }
  }
  subcategory("Frameworks") {
    link {
      github = "nekocode/kotgo"
      desc = "An android development framework on kotlin using MVP architecture."
    }
    link {
      github = "lightningkite/kotlin-core"
      desc = "A full framework for making Android apps. Based on Anko and Kotson."
      setTags("kotson", "anko", "android")
    }
    link {
      github = "codenameone/CodenameOne"
      desc = "Open source cross platform mobile development framework that offers write once run anywhere native development for iOS (iPhone/iPad), Android, Windows & more using Kotlin & Java"
      setTags("cross-platform", "ikvm", "codenameone", "java", "iphone", "mobile")
    }
    link {
      github = "hpost/rx-mvi"
      desc = "Minimal framework for Model View Intent inspired Android applications written in Kotlin."
      setTags("rxjava2", "rxjava", "mvi", "mvi-architecture", "android-architecture")
    }
    link {
      github = "LouisCAD/Splitties"
      desc = "A family of small Kotlin libraries for delightful Android development including View DSLs"
    }
    link {
      github = "Miha-x64/Lychee"
      desc = "Data binding and persistence infrastructure for building Android and JavaFX UIs and binding them with data"
    }
    link {
      github = "0xe1f/ararat"
      setPlatforms(ANDROID)
    }
  }
  subcategory("Projects") {
    link {
      github = "BanDev/Buddha-Quotes"
      desc = "A collaborative project to create a Free and Open Source Buddha Quotes app."
    }
    link {
      github = "antoniolg/Bandhook-Kotlin"
      desc = "A showcase music app for Android entirely written using Kotlin language."
    }
    link {
      github = "antoniolg/Kotlin-for-Android-Developers"
      desc = "Companion App for the book \"Kotlin Android Developers\"."
    }
    link {
      github = "damianpetla/kotlin-dagger-example"
      desc = "Example of Android project showing integration with Kotlin and Dagger 2."
    }
    link {
      github = "dodyg/AndroidRivers"
      desc = "RSS Readers for Android."
      setTags("rss", "android")
    }
    link {
      github = "MakinGiants/banjen"
      desc = "Android app to help to tune a banjo."
      setTags("application", "tuner")
    }
    link {
      github = "inaka/kotlillon"
      desc = "Android Kotlin Examples."
      setTags("application")
    }
    link {
      github = "MakinGiants/todayhistory"
      desc = "App that shows what happened today in history."
      setTags("application")
    }
    link {
      github = "RxKotlin/Pocket"
      desc = "This app help user to save links easily, and can export to Evernote as weekly."
      setTags("application", "rx")
    }
    link {
      github = "SidneyXu/AndroidDemoIn4Languages"
      desc = "Comparison between Java, Groovy, Scala, Kotlin in Android Development."
      setTags("Java", "Groovy", "Scala", "Kotlin", "Android")
    }
    link {
      github = "inorichi/tachiyomi"
      desc = " Free and open source manga reader for Android."
      setTags("application")
    }
    link {
      github = "skydoves/DisneyMotions"
      desc = "A beautiful Disney app using transformation motions based on MVVM architecture."
      setTags("Android", "Application", "Kotlin", "Motion", "MVVM", "Architecture", "Coroutines")
    }
    link {
      github = "ziggy42/Blum-kotlin"
      desc = "A simple android Twitter client written in Kotlin"
      setTags("twitter", "application")
    }
    link {
      github = "TwidereProject/Twidere-Android"
      desc = "Material Design ready and feature rich Twitter app for Android 4.0+"
      setTags("twitter", "application")
    }
    link {
      github = "SimpleMobileTools/Simple-Calendar"
      desc = "A simple calendar with events, customizable widget and no ads."
      setTags("application")
    }
    link {
      github = "SimpleMobileTools/Simple-Camera"
      desc = "A camera with flash, zoom and no ads."
      setTags("application")
    }
    link {
      github = "SimpleMobileTools/Simple-Draw"
      desc = "A canvas you can draw on with different colors."
      setTags("application")
    }
    link {
      github = "SimpleMobileTools/Simple-File-Manager"
      desc = "A simple file manager for browsing and editing files and directories."
      setTags("application")
    }
    link {
      github = "SimpleMobileTools/Simple-Gallery"
      desc = "A gallery for viewing photos and videos without ads."
      setTags("application")
    }
    link {
      github = "SimpleMobileTools/Simple-Notes"
      desc = "A simple textfield for adding quick notes without ads."
      setTags("application")
    }
    link {
      github = "ahong222/happy21"
      desc = "A simple game of Black-Jack write with kotlin"
      setTags("application")
    }
    link {
      github = "AllanWang/KAU"
      desc = "An extensive collection of Kotlin Android Utils"
      setTags("extensions", "utils", "library", "material", "ui", "sharedpreferences", "media-picker", "searchview", "color-picker", "permission-manager")
    }
    link {
      github = "inshiro/Kodesh"
      desc = "Free and open source Bible for Android"
      setTags("application", "read", "book", "bible")
    }
    link {
      github = "hanjoongcho/aaf-easyphotomap"
      desc = "This is a photomap app that shows photos taken on a map."
      setTags("application", "photomap", "map")
    }
    link {
      github = "Karumi/KataScreenshotKotlin"
      desc = "An full exercise to learn how to create screenshot tests for Android"
      setTags("application", "testing", "screenshot")
    }
    link {
      github = "massivedisaster/AFM"
      desc = "A library to help android developers work easily with activities and fragments with Kotlin"
      setTags("utils", "library", "material", "ui", "fragment", "activity", "sharedelements")
    }
    link {
      github = "mustafaberkaymutlu/uv-index"
      desc = "A simple ultraviolet index viewer app for demonstrating Instant Apps + Kotlin + Dagger + MVP"
      setTags("instant-apps", "application", "dagger", "mvp")
    }
    link {
      github = "Karumi/KataSuperHeroesKotlin"
      desc = "A full exercise to learn how to create espresso tests using test doubles and a dependency injector for Android written in Kotlin."
      setTags("application", "testing", "espresso", "test-doubles")
    }
    link {
      github = "Karumi/KataContactsKotlin"
      desc = "An exercise to learn how to write software based on Clean Architecture using Kotlin."
      setTags("architecture", "testing")
    }
    link {
      github = "Karumi/KataTODOApiClientKotlin"
      desc = "A full exercise to learn how to use stubbing HTTP in Kotlin."
      setTags("testing", "stubbing-http")
    }
    link {
      github = "Karumi/MaxibonKataKotlin"
      desc = "A ready to use playground to learn how to write tests using property-based testing in Kotlin. "
      setTags("testing", "functional-programming", "property-based")
    }
    link {
      github = "hanjoongcho/aaf-easypassword"
      desc = "A password manager using a single lock pattern for various type passwords management."
      setTags("application", "password-manager", "password-strength")
    }
    link {
      github = "WilderPereira/lmgtfyGen"
      desc = "Simple Android App to generate Let Me Google That For You urls."
      setTags("application", "rx", "MVP")
    }
    link {
      github = "WilderPereira/ftwfy"
      desc = "The real life Command/Ctrl + F - Android App that uses the Mobile Vision API to allow you to search for any occurrence of a text in a digital document."
      setTags("application", "ocr", "android-vision", "computer-vision")
    }
    link {
      github = "hanjoongcho/aaf-easydiary"
      desc = "This is a diary application optimized to user experience."
      setTags("diary-application", "diary", "realm", "android-diary", "calendar", "material", "android")
    }
    link {
      github = "adrielcafe/GreenHellCompanionApp"
      desc = "Unofficial companion app for the game Green Hell."
      setTags("app", "companion-app", "kotlin", "mvvm", "android-architecture-components", "kotlin-coroutines", "dependency-injection", "fastadapter")
    }
    link {
      github = "adrielcafe/ChromaAndroidApp"
      desc = "Chromatic tuner app."
      setTags("app", "mvvm", "android-architecture-components", "kotlin-coroutines", "music", "tuner", "chromatic-tuner")
    }
    link {
      github = "cuongpm/youtube-dl-android"
      desc = "Video downloader for Android - Download videos from Youtube, Facebook, Twitter, Instagram, Dailymotion, Vimeo and more than 1000 other sites."
      setTags("kotlin", "mvvm", "youtube-dl", "youtube-downloader", "video-downloader", "android-video-downloader")
    }
    link {
      github = "dgngulcan/droid-feed"
      desc = "News feed aggregated exclusively for Android Developers."
      setTags("kotlin", "mvvm", "kotlin-coroutines", "news", "app")
    }
    link {
      github = "VMadalin/kotlin-sample-app"
      desc = "Android Sample App using modular, clean, scalable, testable Architecture written in Kotlin following the best practices with Jetpack"
    }
    link {
      github = "PatilShreyas/Foodium"
      desc = "Foodium is a sample food blog Android application built to demonstrate use of Modern Android development tools - (Kotlin, Coroutines, Flow, Dagger 2, Architecture Components, MVVM, Room, Retrofit, Moshi, Material Components)."
      setTags("kotlin", "mvvm", "architecture")
    }
    link {
      github = "skydoves/MarvelHeroes"
      desc = "A sample Marvel heroes application based on MVVM (ViewModel, Coroutines, LiveData, Room, Repository, Koin)  architecture."
      setTags("kotlin", "mvvm", "architecture", "coroutines", "motion", "app")
    }
    link {
      github = "halilozel1903/LearnKotlinProgramming"
      desc = "Let's Learn Kotlin Programming ❤️"
      setTags("kotlin", "programming", "tutorial")
    }
    link {
      github = "halilozel1903/KotlinTutorials"
      desc = "It's a project that contains lessons and examples about Kotlin programming language."
      setTags("kotlin", "tutorial", "kotlintutorial", "kotlin101")
    }
    link {
      github = "android-password-store/Android-Password-Store"
      desc = "Android application compatible with ZX2C4's Pass command line application."
      setTags("kotlin", "android", "app", "password-manager", "pass", "openpgp", "gpg")
      setPlatforms(ANDROID)
    }
    link {
      github = "PatilShreyas/NotyKT"
      desc = "NotyKT is a complete Kotlin-stack (Backend + Android) application built to demonstrate the use of Modern development tools with best practices implementation."
      setTags("kotlin", "mvvm", "architecture", "kotlin-android", "ktor", "jetpack-compose", "navigation", "hilt", "coroutines", "flow")
    }
    link {
      github = "Marwa-Eltayeb/CurrencyExchange"
      desc = "Currency Exchange App that displays real-time currency rates, shows a chart for any currency pair in the world to see their currency history and provides a currency converter."
      setTags("kotlin", "mvvm", "android", "dagger2", "rxjava2", "Retrofit", "leakcanary ", "Timber", "ViewBinding", "Live Data")
    }
    link {
      github = "AmrDeveloper/Linkhub"
      desc = "Free and open source effective link management app with no ads."
      setTags("kotlin", "mvvm", "hilt", "navigation", "room", "coroutines")
    }
    link {
      github = "AnkitSuda/Rebound"
      desc = "Feature Rich & Highly Customizable Workout Log App."
      setTags("kotlin", "mvvm", "hilt", "navigation", "room", "coroutines", "flow", "jetpack-compose", "room", "workout", "multi-module")
    }
  }
  subcategory("Extensions") {
    link {
      github = "ajalt/timberkt"
      desc = "Easy Android logging with Kotlin and Timber."
      setTags("logging")
    }
    link {
      github = "rosariopfernandes/fireXtensions"
      desc = "Unofficial Kotlin Extensions for the Firebase Android SDK."
      setTags("firebase", "kotlin", "firebase-database", "firestore")
    }
    link {
      github = "matteocrippa/karamba"
      desc = "A Swiss army knife of useful extensions for Kotlin"
      setPlatforms(ANDROID)
      setTags("extension", "string", "date", "boolean")
    }
  }
  subcategory("Tools") {
    link {
      github = "kiruto/debug-bottle"
      desc = "Debug Bottle is an Android runtime debug / develop tools written using kotlin language."
      setTags("debug")
    }
    link {
      github = "didi/booster"
      desc = "Booster is an optimization toolkit for Android applications"
      setTags("optimizer", "gradle-plugin", "bytecode-manipulation", "static-analysis")
    }
    link {
      github = "Kotlin/kdoctor"
      desc = "CLI tool that helps to set up the environment for Kotlin Multiplatform Mobile app development."
      setTags("kmm", "multiplatform")
    }
    link {
      github = "jzbrooks/vgo"
      desc = "vgo is a tool for optimizing and converting between vector artwork representations."
      setTags("drawables", "icons", "gradle-plugin")
    }
  }
  subcategory("Tests") {
    link {
      github = "KakaoCup/Kakao"
      desc =  "Nice and simple DSL for Espresso in Kotlin"
      setTags("espresso", "dsl")
      setPlatforms(ANDROID)
      awesome()
    }
    link {
      github = "KakaoCup/Compose"
      desc = "Nice and simple DSL for Espresso Compose UI testing in Kotlin"
    }
  }
  subcategory("Multiplatform") {
    link {
      github = "Reedyuk/blue-falcon"
      desc = "A unified Bluetooth library for Android and iOS."
      setTags("bluetooth", "kotlin multiplatform", "ios")
    }
    link {
      github = "cossacklabs/themis"
      desc = "Multi-language framework for solving typical data security tasks: storage and messaging encryption, authentication, works for 14 languages."
      setTags("security", "cryptography", "crypto", "encryption", "kotlin multiplatform", "ios")
    }
  }
  subcategory("Boilerplate") {
    link {
      github = "bufferapp/android-clean-architecture-mvi-boilerplate"
      desc = "A clean architecture boilerplate using android written in Kotlin and using the Model-View-Intent pattern"
      setTags("cleanarchitecture", "android", "boilerplate", "mvi")
      setPlatforms(ANDROID)
    }
    link {
      github = "bufferapp/clean-architecture-components-boilerplate"
      desc = "A clean architecture boilerplate using andorid architecture components for android written in Kotlin"
      setTags("cleanarchitecture", "android", "boilerplate", "architecturecomponents")
      setPlatforms(ANDROID)
    }
    link {
      github = "bufferapp/android-clean-architecture-boilerplate"
      desc = "A clean architecture boilerplate for android written in Kotlin"
      setTags("cleanarchitecture", "android", "boilerplate")
      setPlatforms(ANDROID)
    }
  }
}
