category("Libraries/Frameworks") {
  subcategory("Web") {
    link {
      github = "ktorio/ktor"
      href = "https://ktor.io/"
      desc = "Web backend framework for Kotlin. Easy to use, fun and asynchronous."
      setPlatforms(JVM, ANDROID, NATIVE, IOS)
      setTags("web")
      awesome()
    }
    link {
      github = "Flaxoos/flax-ktor-plugins"
      href = "https://github.com/Flaxoos/flax-ktor-plugins"
      desc = "A Ktor plugins repository for servers and clients, including a kafka client plugin, circuit breaker and more"
      setPlatforms(JVM, ANDROID, NATIVE, IOS)
      setTags("web", "mobile", "ktor", "plugins", "server", "client", "kafka", "rate-limiting", "circuit-breaker")
    }
    link {
      github = "darkredz/zeko-restapi-framework"
      setTags("web", "http", "rest", "vert.x", "swagger", "openapi", "microframework", "rest-api", "reactive", "mvc")
    }
    link {
      github = "TinyMission/kara"
      desc = "Web framework written in Kotlin."
      setTags("web")
    }
    link {
      github = "http4k/http4k"
      desc = "Toolkit for serving and consuming HTTP services in a functional and consistent way."
      href = "https://www.http4k.org"
      setTags("web", "http", "http client", "jetty", "netty", "undertow")
      awesome()
    }
    link {
      github = "jean79/yested"
      desc = "A Kotlin framework for building web applications in Javascript."
      setTags("web")
    }
    link {
      github = "hhariri/wasabi"
      desc = "An HTTP Framework built with Kotlin for the JVM."
      setTags("web")
    }
    link {
      github = "Kotlin/kotlinx.html"
      desc = "Kotlin DSL for HTML."
      setTags("web", "html")
      awesome()
    }
    link {
      github = "allangomes/kotlinwind.css"
      desc = "Kotlin DSL for CSS based on Tailwind."
      setTags("web", "html", "tailwind", "css")
      awesome()
    }
    link {
      github = "celtric/kotlin-html"
      desc = "A library to generate HTML in Kotlin."
      setPlatforms(JVM)
      setTags("html-generator", "template-engine")
    }
    link {
      github = "MarioAriasC/KotlinPrimavera"
      desc = "Spring support libraries for Kotlin."
      setTags("spring")
    }
    link {
      github = "kohesive/kovert"
      desc = "An invisible, super easy and powerful REST and Web framework over Vert.x or Undertow."
      setTags("web", "http", "rest", "vert.x", "undertow")
    }
    link {
      github = "stuebingerb/KGraphQL"
      desc = "A GraphQL implementation written in Kotlin"
      setTags("graphql", "web")
    }
    link {
      github = "taskworld/kraph"
      desc = "GraphQL request string builder written in Kotlin"
      setTags("graphql", "builder")
    }
    link {
      github = "sepatel/tekniq"
      desc = "Full-feature HTTP DSL Framework, HTTP Client, JDBC DSL, Loading Cache and Configuration"
      setTags("web", "jdbc", "http client", "spark java", "cache")
    }
    link {
      github = "vert-x3/vertx-lang-kotlin"
      desc = "This module provides Kotlin language bindings including DSL and extension functions for vert.x 3"
      setTags("web", "vert.x")
    }
    link {
      github = "jooby-project/jooby"
      desc = "Modular micro web framework for Java and Kotlin"
      setTags("web", "jooby", "microframework", "http", "rest")
    }
    link {
      github = "gimlet2/kottpd"
      desc = "REST framework in pure Kotlin, inspired by spark-java"
      setTags("web", "rest", "http")
    }
    link {
      github = "kwebio/kweb-core"
      desc = "Build rich live-updating web apps in pure server-side Kotlin."
      setTags("web", "rest", "http", "fullstack")
    }
    link {
      github = "brianmadden/krawler"
      desc = "A web crawling framework written in Kotlin"
      setTags("crawler4j", "web-crawler", "webcrawler", "link-checker")
    }
    link {
      github = "mvysny/vaadin-on-kotlin"
      desc = "A simple way to write full-stack database-backed component-oriented web apps"
      setTags("web", "fullstack", "vaadin")
    }
    link {
      github = "perwendel/spark-kotlin"
      desc = "A DSL in idiomatic Kotlin for the Spark web framework."
      setTags("web", "rest", "http")
    }
    link {
      github = "hexagontk/hexagon"
      href = "https://hexagontk.com"
      desc = "A Microservices toolkit that takes care of HTTP, serialization and templates."
      setTags("web", "rest", "http")
    }
    link {
      github = "danneu/kog"
      desc = "A web framework focused on simplicity, middleware, and functional composition"
      setTags("web", "http", "rest", "jetty", "websockets")
    }
    link {
      github = "tipsy/javalin"
      desc = "A Simple REST API Library for Java/Kotlin."
      setTags("kotlin", "rest-api", "web-framework", "microservice", "servlet", "jetty")
    }
    link {
      github = "laviua/komock"
      desc = "HTTP/Consul/SMTP/Spring Config mocker framework written in Kotlin"
      setTags("kotlin", "http", "consul", "microservice", "mock", "jetty", "netty", "smtp", "ssl")
    }
    link {
      github = "hypercube1024/firefly"
      desc = "An asynchronous web framework for rapid development of high-performance web application."
      setTags("kotlin", "web", "http", "tcp", "ssl", "reactive")
    }
    link {
      github = "phenax/h"
      desc = "HTML templating library written in Kotlin"
      setTags("kotlin", "http", "web", "html", "template")
    }
    link {
      github = "bootique/bootique-kotlin"
      desc = "Provides extension function and features for smooth development with Bootique and Kotlin."
      setTags("kotlin", "web-framework", "undertow", "jetty")
      setPlatforms(JVM)
    }
    link {
      github = "SeunAdelekan/Kanary"
      desc = "A micro webframework for Kotlin"
      setTags("web")
    }
    link {
      github = "ExpediaDotCom/graphql-kotlin"
      desc = "Code-only GraphQL schema generation for Kotlin"
      setTags("graphql", "web")
    }
    link {
      github = "moia-dev/lambda-kotlin-request-router"
      desc = "A REST request routing layer for AWS lambda handlers written in Kotlin"
    }
    link {
      github = "spypunk/sponge"
      desc = "A website crawler and links downloader command line tool written in Kotlin"
    }
    link {
      github = "alpas/alpas"
      desc = "Kotlin web framework inspired by Laravel/Rails. Easy, elegant and productive."
    }
    link {
      github = "jetbrains/kotless"
      desc = "Kotlin serverless framework reducing the routine of serverless deployment."
      setTags("web", "microservice", "serverless")
      awesome()
    }
    link {
      github = "jwstegemann/fritz2"
      desc = "small lib to build reactive web-apps in pure Kotlin based on Flows"
      setTags("web", "ui", "reactive", "coroutines", "html", "routing")
    }
    link {
      github = "AurityLab/graphql-kotlin-toolkit"
      desc = "GraphQL toolkit for Kotlin (includes code generator and spring boot integration)"
      setTags("web", "graphql", "codegenerator", "spring")
    }
    link {
      github = "apollographql/apollo-android"
      desc = "Typesafe GraphQL client for the JVM and Kotlin native"
      setTags("web", "graphql")
    }
    link {
      github = "welvet/summer"
      desc = "Lightweight Jetty/JDBC wrapper library inspired by SparkJava and MyBatis with DI and Testing support for Kotlin"
      setTags("jdbc", "web", "di")
      setPlatforms(JVM)
    }
    link {
      github = "ButterCam/sisyphus"
      desc = "Modern gRPC service framework based on Kotlin/Spring Boot with Message DSL/HTTP transcoding/Google AIP support."
      setTags("web", "microservice", "grpc", "spring", "protobuf", "rest")
      setPlatforms(JVM)
    }
    link {
      github = "varabyte/kobweb"
      href = "https://kobweb.varabyte.com"
      desc = "A modern framework for full stack web apps in Kotlin"
      setPlatforms(JS)
      setTags("web", "framework", "fullstack")
    }
    link {
      github = "Ahoo-Wang/CoSec"
      desc = "RBAC-based And Policy-based Multi-Tenant Security Framework."
      setTags("kotlin", "security", "rbac", "policy", "multi-tenant", "jwt", "reactive", "web-flux", "spring-boot", "spring-cloud-gateway")
    }
    link {
      github = "nacular/doodle"
      href = "https://nacular.github.io/doodle/"
      desc = "A pure Kotlin UI framework for the Web (and Desktop)"
      setTags("web", "javascript", "kotlin-js", "framework", "desktop")
      setPlatforms(COMMON, JVM, JS)
    }
    link {
      github = "Ahoo-Wang/Wow"
      desc = "A Modern Reactive CQRS Architecture Microservice development framework based on DDD and EventSourcing."
      setTags("kotlin", "ddd", "cqrs", "eventsourcing", "eda", "microservice", "reactive", "mongodb", "r2dbc", "kafka", "test-driven", "opentelemetry", "webflux", "spring-boot")
    }
  }
  subcategory("Testing") {
    link {
      github = "JetBrains/spek"
      desc = "A specification framework for Kotlin."
      setTags("test", "assert", "bdd")
      awesome()
    }
    link {
      github = "npryce/hamkrest"
      desc = "A reimplementation of Hamcrest to take advantage of Kotlin language features."
      setTags("test", "assert")
    }
    link {
      github = "nhaarman/mockito-kotlin"
      desc = "Using Mockito with Kotlin."
      setTags("test", "mock")
      awesome()
    }
    link {
      github = "robstoll/atrium"
      desc = "Multiplatform assertion library for Kotlin supporting i18n."
      setTags("test", "assertion-library", "assert")
    }
    link {
      github = "MarkusAmshove/Kluent"
      desc = "Fluent Assertion-Library for Kotlin."
      setTags("test", "assert")
    }
    link {
      github = "winterbe/expekt"
      desc = "BDD assertion library for Kotlin."
      setTags("test", "assert", "bdd")
    }
    link {
      github = "kotest/kotest"
      desc = "Formerly known as KotlinTest, Kotest is a flexible and comprehensive testing tool that is multiplatform enabled."
      setTags("test", "bdd", "matchers")
    }
    link {
      github = "dmcg/konsent"
      desc = "An acceptance test library for Kotlin."
      setTags("test", "bdd", "gherkin")
    }
    link {
      github = "EPadronU/balin"
      desc = "Balin is a browser automation library for Kotlin. It's basically a Selenium-WebDriver wrapper library inspired by Geb."
      setTags("test", "selenium", "UI", "automation")
    }
    link {
      github = "dmcg/k-sera"
      desc = "A JMock wrapper for Kotlin."
      setTags("mock", "test")
    }
    link {
      github = "dam5s/aspen"
      desc = "Aspen is an RSpec and Spek inspired test runner for Kotlin."
      setTags("test", "specification", "rspec", "spek")
    }
    link {
      github = "qwertukg/SeleniumBuilder"
      desc = "DSL for Selenium 2.0. Provide a possibility to write tests in Kotlin builder style."
      setTags("selenium", "test")
    }
    link {
      github = "mockk/mockk"
      desc = "Pure Kotlin mocking library."
      setTags("test", "mock")
      awesome()
    }
    link {
        github = "lupuuss/Mokkery"
        desc = "The mocking library for Kotlin Multiplatform, easy to use, boilerplate-free and compiler plugin driven."
        setTags("test", "mock")
        setPlatforms(JVM, ANDROID, NATIVE, IOS)
    }
    link {
      github = "Ninja-Squad/springmockk"
      desc = "SpringMockK: MockBean and SpyBean, but for MockK instead of Mockito"
      setTags("spring", "mock")
    }
    link {
      github = "mvysny/DynaTest"
      desc = "Write your tests in DSL way. Runs on JUnit5 Platform."
      setTags("test", "assert", "dsl")
    }
    link {
      github = "tyro/arbitrater"
      desc = "Arbitrater is a library for creating arbitrary (randomized) instances of classes by reflection for use in testing."
      setTags("test", "random", "random-generation")
    }
    link {
      github = "xgouchet/Elmyr"
      desc = "A utility to make Kotlin/Java tests random yet reproducible"
      setTags("test", "random", "random-generation")
    }
    link {
      github = "neworld/kupiter"
      desc = "Kotlin DSL for Junit5"
      setTags("test", "junit5", "dsl")
    }
    link {
      github = "karumi/KotlinSnapshot"
      desc = "Verify your data with snapshot testing."
      setTags("snapshot", "test", "assert")
    }
    link {
      github = "permissions-dispatcher/kompile-testing"
      desc = "Testing tools for kotlinc and kapt."
      setTags("kapt", "test")
    }
    link {
      github = "robfletcher/strikt"
      desc = "An assertion library for Kotlin"
      setTags("test", "strikt", "assert")
    }
    link {
      github = "dmcg/minutest"
      desc = "Simple, Expressive, Extensible Testing for Kotlin on the JVM"
      setTags("test", "minutest", "dsl")
    }
    link {
      github = "codecentric/hikaku"
      desc = "A library that tests if the implementation of a REST-API meets its specification."
      setTags("test", "assert", "api", "rest")
    }
    link {
      github = "serpro69/kotlin-faker"
      desc = "Port of ruby faker gem written in kotlin"
      setTags("test", "testing", "data-generator", "faker")
    }
    link {
      github = "skrapeit/skrape.it"
      desc = "A DSL-driven HTML/XML parser-library that enables meaningful testing of rendered HTML templates."
      setPlatforms(JVM)
      setTags("test", "html", "template", "dom", "dsl", "parser", "webcrawler", "scraper", "ktor", "spring-boot")
    }
    link {
      github = "krzema12/vis-assert"
      desc = "Test the shape of your functions!"
      setTags("test", "testing", "dsl", "ascii-art")
    }
    link {
      github = "EranBoudjnah/TestIt"
      desc = "Generate unit testing boilerplate from kotlin files."
      setTags("test", "testing", "generator", "generation", "mock")
    }
    link {
      github = "EranBoudjnah/RandomGenKt"
      desc = "Initialize instances of any class with generated data."
      setTags("test", "testing", "random", "random-generation")
    }
    link {
      github = "KennethWussmann/mock-fuel"
      desc = "JUnit 5 extension to easily mock external HTTP requests made with the HTTP client Fuel."
      setTags("test", "testing", "mock", "fuel", "junit")
    }
    link {
      github = "jcornaz/kwik"
      desc = "A property-based testing library for Kotlin. Execute tests with randomized inputs with a test-engine agnostic and compile-time safe library."
      setTags("test", "testing", "assert", "random", "random-generation")
    }
    link {
      github = "from-source/kiwi"
      desc = "Fluent assertions library with support of json path."
      setTags("test", "testing", "assert", "dsl", "multiplatform", "jsonpath")
    }
    link {
      github = "tschuchortdev/kotlin-compile-testing"
      desc = "A library for testing Kotlin and Java annotation processors, compiler plugins and code generation"
      setPlatforms(JVM)
    }
    link {
      github = "willowtreeapps/assertk"
      desc = "assertions for kotlin inspired by assertj"
      setPlatforms(COMMON, JVM, JS, NATIVE)
    }
    link {
      github = "willowtreeapps/opentest4k"
      desc = "kotlin multiplatform implementation/bindings of opentest4j"
      setPlatforms(COMMON, JVM, JS, NATIVE)
    }
    link {
      github = "sokomishalov/skraper"
      desc = "Kotlin/Java library, cli tool and telegram-bot for scraping posts and media from various sources with neither authorization nor full page rendering (Facebook, Instagram, Twitter, Youtube, Tiktok, Telegram, Twitch, Reddit, Pinterest, Flickr, Tumblr, etc.)"
      setPlatforms(JVM)
      setTags("scraper", "parser", "webcrawler", "telegram", "bot")
    }
    link {
      github = "iotacb/ChefkochAPI"
      desc = "Kotlin/Java library, to parse and get information of recipes from chefkoch"
      setPlatforms(JVM)
      setTags("scraper", "parser", "webcrawler", "chefkoch", "api")
    }
    link {
      github = "HelloCuriosity/model-forge"
      desc = "A Kotlin library for auto generating models for tests."
      setTags("test", "model-generation", "fixtures")
    }
    link {
      github = "Trendyol/stove"
      desc = "The easiest way of writing e2e tests for your JVM back-end API with Kotlin"
      setTags("test", "e2e-testing", "testing-framework", "docker", "ktor", "spring", "test-automation")
    }
    link {
      github = "Kotlin/kotlinx-benchmark"
      desc = "A powerful library for benchmarking in Kotlin."
      setTags("benchmark", "performance", "multiplatform")
      setPlatforms(JVM, JS, NATIVE)
    }
    link {
      github = "diffplug/selfie"
      href = "https://selfie.dev/jvm"
      desc = "Snapshot testing (inline, on disk, and memoization)"
      setTags("test", "snapshot", "multiplatform")
    }
    link {
      github = "clovis-ai/prepared"
      href = "https://opensavvy.gitlab.io/groundwork/prepared/docs/index.html"
      desc = "Magicless testing framework for Kotlin Multiplatform, featuring time management, parameterization and isolated features."
      setTags("test", "testing", "multiplatform")
      setPlatforms(COMMON, JVM, JS, NATIVE)
    }
  }
  subcategory("Mocks and Fakes") {
    link {
      github = "moove-it/fakeit"
      desc = "Generates realistic fake data — like names, emails, dates, countries — to be used in your Android development environment."
      setTags("testing", "android", "utility")
    }
    link {
      github = "bluegroundltd/kfactory"
      desc = "Fixture factory in Kotlin"
    }
  }
  subcategory("Dependency Injection") {
    link {
      github = "Kodein-Framework/Kodein-DI"
      desc = "Painless Kotlin Dependency Injection."
      setTags("di", "dependency injection")
      awesome()
    }
    link {
      github = "kailan/kodeinject"
      desc = "Constructor dependency injection for Kodein."
      setTags("di", "dependency injection", "kodein")
    }
    link {
      github = "traversals/kapsule"
      desc = "Minimalist dependency injection library for Kotlin."
      setTags("di", "dependency injection")
    }
    link {
      github = "JLLeitschuh/kotlin-guiced"
      desc = "Convenience Kotlin API over the Google Guice DI Library."
      setTags("Dependency Injection", "Guice")
    }
    link {
      github = "authzee/kotlin-guice"
      desc = "Guice DSL extensions for Kotlin"
      setTags("guice", "dependency injection", "di")
    }
    link {
      github = "Ekito/koin"
      desc = "A functional Kotlin dependency injection framework for Android and JVM."
      setTags("android", "dependency-injection", "injection", "functional")
      awesome()
    }
    link {
      github = "Rasalexman/KODI"
      desc = "light-weight KOtlin Dependency Injection Framework with or without reflection module without kapt"
    }
    link {
      github = "evant/kotlin-inject"
      setPlatforms(JVM)
    }
    link {
      github = "corbella83/PopKorn"
      desc = "Forget about modules and components. DI can be simple"
      setTags("di", "dependency injection", "android", "multiplatform")
      setPlatforms(ANDROID, COMMON, IOS, JS, JVM, NATIVE)
    }
    link {
      github = "sergeshustoff/dikt"
      desc = "Simple and powerful DI for kotlin multiplatform"
      setTags("di", "dependency injection", "android", "multiplatform")
      setPlatforms(ANDROID, COMMON, IOS, JS, JVM, NATIVE)
    }
  }
  subcategory("Coroutines") {
    link {
      github = "Kotlin/kotlin-coroutines"
      desc = "Design documents and examples for coroutines in Kotlin."
      setTags("coroutines")
    }
    link {
      github = "Kotlin/kotlinx.coroutines"
      desc = "Libraries built upon Kotlin coroutines."
      setTags("async", "await", "yield", "generator")
      awesome()
    }
    link {
      github = "soywiz/korio"
      desc = "Korio: Kotlin cORoutines I/O: Streams + Async TCP Client/Server + Virtual File System for JVM, Node.JS and Browser."
      setTags("vfs", "coroutiones", "io")
    }
    link {
      github = "soywiz/korim"
      desc = "Korim: Kotlin cORoutines IMaging utilities depending on Korio."
      setTags("image", "coroutiones")
    }
    link {
      github = "soywiz/korui"
      desc = "Korui: Kotlin cORoutines User Interfaces: korio + kimage + korui"
      setTags("ui", "coroutiones")
    }
    link {
      github = "konrad-kaminski/spring-kotlin-coroutine"
      desc = "Kotlin coroutine support for Spring."
      setTags("coroutines", "spring")
    }
    link {
      github = "marcoferrer/kroto-plus"
      desc = "Protoc plugin for bringing together Kotlin, Protobuf, Coroutines, and gRPC."
      setTags("coroutines", "grpc", "protobuf")
    }
    link {
      github = "cloudoptlab/cloudopt-next"
      desc = "A next-generation Java web lightweight framework based on vertx and kotlin. "
      setTags("web", "vertx", "spring", "restful", "springboot", "springboot", "cloudopt", "next")
    }
    link {
      github = "Rasalexman/coroutinesmanager"
      desc = "try-catch safety coroutines manager"
    }
    link {
      github = "rozkminiacz/FlowRiddles"
      desc = "Repository for learning Kotlin Flow API"
      setTags("kotlin", "kotlin-flow", "learning", "riddles")
    }
    link {
      github = "KingFalse/harrier"
      desc = "Simpler use of multithreading in Kotlin."
      setTags("Thread", "Coroutines", "Multithreading", "JVM")
      setPlatforms(JVM)
    }
    link {
      github = "Anamorphosee/stacktrace-decoroutinator"
      desc = "Library for recovering stack traces in Kotlin coroutines."
      setTags("debug", "stack-trace", "exceptions")
      setPlatforms(JVM, ANDROID)
    }
  }
  subcategory("Functional Programming") {
    link {
      github = "arrow-kt/arrow"
      desc = "Functional companion to Kotlin's Standard Library."
      setTags("fp", "functional")
    }
    link {
      github = "arrow-kt/arrow-meta"
      desc = "Functional companion to Kotlin's Compiler."
      setTags("fp", "functional")
    }
    link {
      github = "ReactiveX/RxKotlin"
      desc = "RxJava bindings for Kotlin."
      setTags("fp", "functional")
    }
    link {
      github = "kittinunf/Result"
      desc = "The modelling for success/failure of operations in Kotlin."
      setTags("fp", "functional", "monad")
    }
    link {
      github = "brianegan/bansa"
      desc = "A state container for Kotlin & Java, inspired by Elm & Redux."
      setTags("fp", "functional", "UI", "Interface", "Redux")
    }
    link {
      github = "pardom/redux-kotlin"
      desc = "Direct port of Redux for Kotlin."
      setTags("fp", "functional", "UI", "Interface", "Redux")
    }
    link {
      github = "beyondeye/Reduks"
      desc = "A \"batteries included\" port of Reduxjs for Kotlin+Android"
      setTags("fp", "functional", "UI", "Interface", "Redux")
    }
    link {
      github = "michaelbull/kotlin-result"
      desc = "A Result monad for modelling success or failure operations - inspired by Elm, Rust, & Haskell."
      setTags("fp", "functional", "result", "monad", "either", "type")
    }
    link {
      github = "fork-handles/forkhandles"
      name = "fork-handles/result4k"
      desc = "Result monad for type safe error handling in Kotlin"
      href = "https://github.com/fork-handles/forkhandles/blob/trunk/result4k"
      setTags("fp", "functional", "result", "monad", "either", "type", "error handling")
    }
    link {
      github = "pakoito/Komprehensions"
      desc = "Do comprehensions for Kotlin and 3rd party libraries."
      setTags("comprehensions", "fp", "functional")
    }
    link {
      github = "h0tk3y/kotlin-monads"
      desc = "Monads for Kotlin"
      setTags("fp", "functional", "monads")
    }
    link {
      github = "poetix/klenses"
      desc = "Lenses for Kotlin."
      setTags("fp", "functional", "lenses")
    }
    link {
      github = "reactor/reactor-core"
      desc = "Non-Blocking Reactive Streams Foundation for the JVM. Natively supports Kotlin, since 3.1.0.M3."
      setTags("reactive", "stream", "functional")
    }
    link {
      github = "UrbanCompass/Snail-Kotlin"
      desc = "An observables framework for Kotlin."
      setTags("observables", "fp", "functional")
    }
    link {
      github = "RubyLichtenstein/RxTest"
      desc = "Kotlin DSL for testing RxJava2"
      setTags("rxjava2", "kotlin",  "kotlin-android",  "testing", "kotlin-dsl")
      setPlatforms(JVM)
    }
  }
  subcategory("Serialization") {
    link {
      github = "Kotlin/kotlinx.serialization"
      desc = "Kotlin multiplatform / multi-format reflectionless serialization"
      awesome()
    }
    link {
      github = "cbeust/klaxon"
      desc = "Lightweight library to parse JSON in Kotlin."
      setTags("json")
    }
    link {
      github = "SalomonBrys/Kotson"
      desc = "Gson for Kotlin, Kotson enables you to parse and write JSON with Google's Gson using a conciser and easier syntax."
      setTags("json")
    }
    link {
      github = "FasterXML/jackson-module-kotlin"
      desc = "Jackson module that adds support for serialization/deserialization of Kotlin classes and data classes."
      setTags("json", "jakson")
      setPlatforms(JVM)
      awesome()
    }
    link {
      github = "Shengaero/kotlin-json"
      desc = "A lightweight, stylistic, optimized, and multiplatform JSON library for Kotlin-JVM and Kotlin-JS"
      setTags("json", "multiplatform")
    }
    link {
      github = "fboldog/ext4klaxon"
      desc = "Type Extensions (Long, Int, Enum, Date) for Klaxon."
      setTags("json")
    }
    link {
      github = "marifeta/kvalidator"
      desc = "Kotlin validator (compatible with laravel validation rules) for json kotlinx.serialization!"
      setTags("json", "validation", "laravel", "laravel-validation")
    }
    link {
      github = "Jire/KTON"
      desc = "Object notation in pure Kotlin!"
      setTags("JSON", "XML")
    }
    link {
      github = "fluidsonic/fluid-json"
      desc = "A JSON library written in pure Kotlin."
      setTags("json")
    }
    link {
      github = "s4kibs4mi/kotlin-jsonq"
      desc = "A simple Kotlin library to Query over Json Data."
      setTags("json", "json-query", "json-manager", "kotlin-library", "kotlin-android")
    }
    link {
      github = "aafanasev/kson"
      desc = "Auto-generate GSON type adapters for Kotlin data classes"
      setTags("json", "gson", "type adapter", "annotation processing", "kapt")
    }
    link {
      github = "holgerbrandl/jsonbuilder"
      desc = "A tiny DSL to create json using idiomatic Kotlin"
      setPlatforms(JVM)
      setTags("json")
    }
    link {
      github = "qwertukg/xml-builder"
      desc = "Simplest XML builder for Kotlin"
      setTags("xml", "builder", "dsl")
      setPlatforms(JVM)
    }
    link {
      github = "lectra-tech/koson"
      desc = "A concise and lightweight Kotlin DSL to build JSON objects and render their String representations"
      setTags("json", "dsl", "builder")
      setPlatforms(JVM)
    }
    link {
      name = "knbt"
      github = "BenWoodworth/knbt"
      desc = "Minecraft NBT support for kotlinx.serialization"
      setTags("nbt", "snbt", "minecraft", "kotlinx.serialization")
      setPlatforms(COMMON, ANDROID, IOS, JS, JVM, NATIVE)
    }
  }
  subcategory("Validation") {
    link {
      github = "deva666/KValidation"
      desc = "Validation library"
      setPlatforms(JVM)
      setTags("validation", "validator")
    }
    link {
      github = "konform-kt/konform"
      desc = "Multiplatform validations for Kotlin data classes"
      setPlatforms(JVM, JS)
      setTags("validation", "dsl")
    }
    link {
      github = "LeoColman/SimpleCpfValidator"
      desc = "Simple Brazilian taxpayer document (CPF) validator"
      setPlatforms(JVM)
      setTags("validation", "validator", "cpf", "brazil")
    }
    link {
      github = "kciter/thing"
      desc = "A rule-based entity management library written in Kotlin"
      setPlatforms(JVM)
      setTags("validation", "validator", "spring", "entity")
    }
    link {
      github = "mbalatsko/emailverifier-kt"
      desc = "Composable, pluggable Kotlin library for validating email addresses beyond just their syntax. It's built with a clear focus: help developers reliably assess whether a given email is real, meaningful, and worth accepting."
      setPlatforms(JVM)
      setTags("validation", "validator", "email", "kotlin")
    }
  }
  subcategory("Database") {
    link {
      github = "JetBrains/Exposed"
      desc = "Exposed is a prototype for a lightweight SQL library written over JDBC driver for Kotlin language."
      setTags("database", "query", "schema", "dao")
      awesome()
    }
    link {
      github = "JetBrains/xodus"
      desc = "Transactional schema-less embedded database used by JetBrains YouTrack and JetBrains Hub."
      setTags("embedded-database", "java", "kotlin", "key-value", "entity-store", "transactional", "log-structured", "schema-less", "snapshot-isolation", "nosql", "xodus", "db", "database", "youtrack")
      setPlatforms(JVM)
      awesome()
    }
    link {
      github = "mongodb/mongo-java-driver"
      desc = "The official MongoDB Kotlin Driver allows developers to build server-side Kotlin applications with MongoDB."
      setTags("database", "java", "kotlin", "mongodb", "query", "nosql", "db")
      awesome()
    }
    link {
      github = "ebean-orm/ebean"
      desc = "Ebean is a Java & Kotlin ORM including type safe kotlin queries"
      setTags("database", "sql", "orm", "query", "type-safe builder", "jpa")
    }
    link {
      github = "cheptsov/kotlin-nosql"
      desc = "NoSQL database query and access library for Kotlin."
      setTags("database", "mongodb", "query")
    }
    link {
      github = "jankotek/mapdb"
      desc = "MapDB provides concurrent Maps, Sets and Queues backed by disk storage or off-heap-memory. It is a fast and easy to use embedded Java database engine."
      setPlatforms(JVM)
    }
    link {
      github = "darkredz/Zeko-SQL-Builder"
      setTags("database", "sql", "query", "vert.x", "hikari-cp")
    }
    link {
      github = "seratch/kotliquery"
      desc = "A handy database access library in Kotlin."
      setTags("database", "sql", "query")
    }
    link {
      github = "andrewoma/kwery"
      desc = "Kwery is an SQL library for Kotlin."
      setTags("database", "sql", "query")
    }
    link {
      github = "square/sqldelight"
      desc = "Generates Java models from CREATE TABLE statements."
      setTags("database", "sql", "type-safe builder")
      awesome()
    }
    link {
      github = "bloomberg/selekt"
      href = "https://bloomberg.github.io/selekt"
      desc = "Android SQL database library wrapping the community edition of SQLCipher, an SQLite extension that provides 256-bit AES encryption. Selekt realises the maximum concurrency offered by SQLite3."
      setTags("android", "database", "sql", "sqlcipher", "sqlite")
    }
    link {
      github = "x2bool/kuery"
      desc = "Typesafe SQL with Kotlin."
      setTags("database", "sql", "type-safe builder")
    }
    link {
      github = "Litote/kmongo"
      desc = "KMongo - Kotlin toolkit for Mongo"
      setTags("database", "mongodb", "query")
    }
    link {
      github = "requery/requery"
      desc = "Modern SQL based query & persistence for Java/Kotlin/Android."
      setTags("database", "query", "type-safe builder")
    }
    link {
      github = "consoleau/kotlin-jpa-specification-dsl"
      desc = "This library provides a fluent DSL for querying spring data JPA repositories using spring data Specifications."
      setTags("database", "query", "jpa")
    }
    link {
      github = "Ganet/rxaerospike"
      desc = "RxJava2 wrapper for aerospike-client-java."
      setTags("database", "arospike", "rx", "rxjava2")
    }
    link {
      github = "Raizlabs/DBFlow"
      desc = "A blazing fast, powerful, and very simple ORM android database library that writes database code for you."
      setTags("orm", "jap", "kapt", "database")
    }
    link {
      github = "KotlinPorts/kt-postgresql-async"
      desc = "Kotlin/Gradle port of mauricio's async driver for postgres/mysql."
      setTags("postgres", "mysql", "database driver")
    }
    link {
      github = "shyiko/levelkt"
      desc = "LevelDB client for Kotlin and/or Java 8+."
      setTags("leveldb", "embedded")
    }
    link {
      github = "SubiyaCryolite/jds"
      desc = "Jenesis Data Store: a dynamic, cross platform, high performance, ORM data-mapper. Designed to assist in rapid development and data mining."
      setTags("orm", "postgres", "mysql", "mssql", "sqlite", "oracle")
    }
    link {
      github = "dizitart/nitrite-database"
      desc = "Potassium Nitrite is a kotlin extension of nitrite database, an open source nosql embedded document store with mongodb like api."
      href = "https://github.com/dizitart/nitrite-database/tree/master/potassium-nitrite"
      setTags("nosql", "embedded", "documentdb", "object-storage")
    }
    link {
      github = "pm-dev/kotlin-gremlin-ogm"
      desc = "Kotlin-gremlin-ogm is a type-safe object/graph mapping library for Gremlin enabled graph databases."
      setTags("nosql", "graph", "database", "gremlin", "janusgraph", "orm")
    }
    link {
      github = "fluidsonic/fluid-mongo"
      desc = "Coroutine support for MongoDB built on top of the official Reactive Streams Java Driver"
      setPlatforms(JVM)
      setTags("database", "mongodb", "nosql", "coroutines")
    }
    link {
      github = "jasync-sql/jasync-sql"
      desc = "Kotlin port of mauricio's async driver for postgres/mysql."
      setTags("postgres", "mysql", "database driver")
    }
    link {
      github = "kotlin-orm/ktorm"
      desc = "A lightweight ORM Framework for Kotlin. Provides strong-typed and flexible SQL DSL and convenient sequence APIs to reduce our duplicated effort on database operations. "
      setTags("ORM", "SQL", "DSL", "JDBC")
    }
    link {
      github = "TouK/krush"
      desc = "Idiomatic persistence layer for Kotlin, based on Exposed. It’s based on a compile-time JPA annotation processor that generates Exposed DSL table and objects mappings from your data classes."
    }
    link {
      github = "coupang/spring-data-requery"
      desc = "Spring Data for Requery (lightweight ORM)"
      setTags("spring", "spring-data", "requery", "java", "kotlin", "kotlin-coroutines", "orm", "jpa")
      setPlatforms(JVM)
    }
    link {
      github = "ctripcorp/SQLlin"
      desc = "A DSL SQLite library for Kotlin Multiplatform"
      setTags("multiplatform", "android", "native", "sql", "sqlite", "database", "orm", "dsl", "ksp")
      setPlatforms(COMMON, ANDROID, IOS, NATIVE)
    }
    link {
      github = "komapper/komapper"
      desc = "Komapper is an ORM library for server-side Kotlin with JDBC and R2DBC support."
      setTags("database", "orm", "query", "sql", "jdbc", "r2dbc")
    }
    link {
      github = "objectbox/objectbox-java"
      desc = "Embedded on-device object database for Mobile Apps and IoT."
      setTags("android", "database", "nosql")
    }
    link {
      github = "smyrgeorge/sqlx4k"
      desc = "A small non-blocking database driver written in Kotlin for the Native platform."
      setTags("database", "SQL", "driver", "query", "postgres", "postgresql", "mysql", "async", "async-io", "non-blocking")
      setPlatforms(NATIVE)
    }
    link {
      github = "huanshankeji/exposed-vertx-sql-client"
      desc = "Exposed on top of Vert.x Reactive SQL Client"
      setTags("Exposed", "Vert.x", "vertx", "database", "query", "SQL", "postgres", "postgresql", "async", "async-io", "non-blocking")
      setPlatforms(JVM)
    }
    link {
      github = "clovis-ai/ktmongo"
      href = "https://opensavvy.gitlab.io/ktmongo/docs"
      desc = "Modern typesafe MongoDB DSL for Kotlin."
      setTags("database", "NoSQL", "driver", "query", "mongodb", "bson", "async", "async-io", "non-blocking")
      setPlatforms(JVM)
    }
  }
  subcategory("Tools") {
    link {
      github = "SonarSource/sonarlint-intellij"
      desc = "An IDE extension that helps you detect and fix quality issues as you write code."
      setTags("scripting", "ide", "linter", "language")
    }
    link {
      github = "Kotlin/dokka"
      desc = "Documentation Engine for Kotlin."
      awesome()
    }
    link {
      github = "Vorlonsoft/EasyDokkaPlugin"
      desc = "Gradle Script plugin to generate documentation by Dokka for Kotlin and Java, Android and non-Android projects."
    }
    link {
      github = "Vorlonsoft/GradleMavenPush"
      desc = "Gradle Script plugin to upload Gradle Android/Kotlin/Java Artifacts to Maven repositories (JCenter, Maven Central, ...)."
    }
    link {
      github = "holgerbrandl/kscript"
      desc = "Scripting utils for Kotlin."
      setTags("bash", "scripting", "kts")
    }
    link {
      github = "kohesive/keplin"
      desc = "Secure Kotlin scripting and binary lambda-scripts."
      setTags("scripting", "kts")
    }
    link {
      github = "pinterest/ktlint"
      desc = "An anti-bikeshedding Kotlin linter with built-in formatter."
      setTags("style", "linter")
      awesome()
    }
    link {
      github = "nbadal/ktlint-intellij-plugin"
      desc = "An anti-bikeshedding Kotlin linter with built-in formatter. Get instant formating with Ktlint in your IDEA."
      setTags("style", "linter","Intellij IDEA, Android Studio")
      awesome()
    }
    link {
      github = "sapotero/DocGenPlugin"
      href = "https://plugins.jetbrains.com/plugin/26488-kdocgen"
      desc = "KDocGen – an IntelliJ IDEA plugin that automatically generates KDoc, completes missing code, creates Kotest tests, and adds meaningful comments with a single shortcut!"
      setTags("artificial-intelligence", "code-generation", "documentation", "Intellij IDEA, Android Studio")
    }
    link {
      name = "Kotlin Notebook"
      desc = "Kotlin notebooks are interactive worksheets with rich outputs."
      href = "https://plugins.jetbrains.com/plugin/16340-kotlin-notebook"
      setTags("scripting", "kts")
      awesome()
    }
    link {
      github = "saveourtool/diktat"
      desc = "Strict coding standard for Kotlin and a custom set of rules for detecting and autofixing code smells."
      setTags("style", "linter", "static-analysis", "check style", "code smell")
      setPlatforms(COMMON)
    }
    link {
      github = "jtransc/jtransc"
      desc = "JVM AOT compiler created in Kotlin."
      setTags("aot", "compiller")
    }
    link {
      github = "detekt/detekt"
      desc = "Static code analysis for Kotlin."
      setTags("check style", "checkstyle")
      awesome()
    }
    link {
      github = "Kotlin/kotlinx-kover"
      desc = "Gradle plugin for Kotlin code coverage agents."
      setTags("coverage", "code coverage", "jacoco")
      awesome()
    }
    link {
      github = "facebookincubator/ktfmt"
      desc = "Kotlin code formatter that reflows lines and always produces the same result."
      setTags("formatter", "pretty print")
    }
    link {
      github = "mkohm/detekt-hint"
      desc = "Detection of design principle violations as a plugin to detekt."
    }
    link {
      github = "cypressious/KotlinW"
      desc = "A small wrapper for the Kotlin compiler that can be used to execute .kts scripts."
      setTags("wrapper", "scripting")
    }
    link {
      github = "s1monw1/KtsRunner"
      desc = "Library for executing .kts files from regular Kotlin code using Java Scripting Engines API"
      setTags("dsl", "scripting")
    }
    link {
      github = "jmfayard/refreshVersions"
      desc = "Better Gradle dependencies management inside the IDE. Search for available updates."
      setTags("gradle", "plugin", "build", "development", "libraries", "versions")
      awesome()
    }
    link {
      github = "Kotlin/kotlin-interactive-shell"
      desc = "Kotlin Language Interactive Shell"
      setTags("shell")
      setPlatforms(JVM)
    }
    link {
      github = "typesafegithub/github-workflows-kt"
      desc = "Authoring GitHub Actions workflows in Kotlin. You won't go back to YAML!"
      setTags("github", "dsl", "scripting")
      setPlatforms(JVM)
    }
    link {
      github = "L-Briand/TT"
      desc = "A powerful key:value template processor."
      setTags("template", "template-engine")
      setPlatforms(JVM)
    }
    link {
      github = "clovis-ai/Dokka-MkDocs"
      href = "https://opensavvy.gitlab.io/automation/dokka-material-mkdocs/docs"
      desc = "Embed your kdoc comments into an MkDocs website."
      setTags("documentation")
    }
    link {
      github = "CLOVIS-AI/Kotlin-Transitive-Resources"
      desc = "Include resource files into a KotlinJS library"
      setTags("build", "resource", "gradle")
      setPlatforms(JS)
    }
  }
  subcategory("Compiler Plugins") {
    link {
      github = "google/ksp"
      desc = "Kotlin Symbol Processing API"
      setPlatforms(JVM)
    }
    link {
      github = "aafanasev/sekret"
      desc = "Kotlin compiler plugin to exclude secret properties from toString() of Data class"
      setPlatforms(JVM, ANDROID)
      setTags("Data class", "toString")
    }
    link {
      github = "AhmedMourad0/no-copy"
      desc = "A Kotlin compiler plugin that performs 'copy-erasure' on data classes."
      setPlatforms(ANDROID, COMMON, IOS, JS, JVM, NATIVE, WASM)
      setTags("data-class", "compiler-plugin", "value-based-classes", "binary-compatibility")
    }
    link {
      github = "Mr-Mappie/mappie"
      desc = "Kotlin compiler plugin generating type-safe and performant object mapping code."
      setPlatforms(ANDROID, COMMON, IOS, JS, JVM, NATIVE, WASM)
      setTags("compiler-plugin", "object-mapping", "utility", "conversion")
    }
    link {
      github = "guimauvedigital/zodable"
      desc = "Generate zod & pydantic schemas from Kotlin data classes."
      setPlatforms(ANDROID, COMMON, IOS, JS, JVM, NATIVE)
      setTags("compiler-plugin", "data-class", "schema", "zod", "pydantic")
    }
  }
  subcategory("Continuous Integration") {
    link {
      github = "danger/kotlin"
      desc = "Stop saying \"you forgot to …\" in code review in Kotlin"
      setTags("danger", "ci", "continuous", "integration", "code", "review")
    }
    link {
      github = "CLOVIS-AI/gitlab.main.kts"
      href = "https://opensavvy.gitlab.io/automation/gitlab-ci.kt/docs/"
      desc = "Replace your GitLab CI YAML files by Kotlin scripts"
      setTags("ci", "continuous", "integration", "gitlab")
    }
  }
  subcategory("Code Generators") {
    link {
      github = "jhipster/jhipster-kotlin"
      desc = "A scaffold generator to generate web apps or APIs using springboot and angularJS or React"
    }
  }
  subcategory("Desktop") {
    link {
      github = "edvin/tornadofx"
      desc = "Lightweight JavaFX Framework for Kotlin/"
      setTags("javafx", "desktop", "application")
    }
  }
  subcategory("Http Clients") {
    link {
      github = "kittinunf/Fuel"
      desc = "The easiest HTTP networking library for Kotlin/Android."
      setTags("http", "http client", "file upload")
    }
    link {
      github = "jkcclemens/khttp"
      desc = "Kotlin HTTP requests library."
      setTags("http", "http client")
    }
    link {
      github = "egorzhdan/networkinkt"
      desc = "Multiplatform coroutine-based HTTP client."
      setTags("http", "http client", "coroutines")
    }
    link {
      github = "rybalkinsd/kohttp"
      desc = "Kotlin DSL-based HTTP client."
      setTags("http", "http client", "dsl", "okhttp")
    }
    link {
      github = "curiousnikhil/Asynkio"
      desc = "Make asynchronous calls painlessly with async/await style."
      setTags("http", "http client", "coroutines")
    }
    link {
      github = "speekha/httpmocker"
      desc = "Kotlin library to handle offline mode easily with OkHttp."
      setTags("http", "http client", "offline", "okhttp")
    }
    link {
      github = "corbella83/kotliny.network"
      desc = "Simple, powerful and lightweight Kotlin Multiplatform Network Client"
      setTags("http", "http client", "multiplatform")
      setPlatforms(ANDROID, COMMON, IOS, JVM, NATIVE)
    }
  }
  subcategory("Networking") {
    link {
      github = "seniorjoinu/reliable-udp"
      desc = "Multiplexed, coroutine-powered reliable UDP for Kotlin using fountain codes"
      setPlatforms(JVM)
      setTags("networking", "reliable transport", "reliable udp", "no-arq", "fec")
    }
    link {
      github = "open-coap/kotlin-mbedtls"
      desc = "Integration with mbedtls library to provide DTLS client and server in jvm"
      setPlatforms(JVM)
      setTags("networking", "udp", "dtls", "tls")
    }
    link {
      github = "guimauvedigital/kourier"
      desc = "Pure Kotlin AMQP client and protocol implementation, optimized for KMP and coroutines."
      setPlatforms(COMMON, ANDROID, IOS, JS, JVM, NATIVE)
      setTags("networking", "amqp", "rabbitmq", "kmp", "coroutines")
    }
  }
  subcategory("Editors") {
    link {
      github = "JetBrains/intellij-community"
      desc = "IntelliJ IDEA Community Edition"
      setTags("editor", "ide", "language")
      awesome()
    }
    link {
      github = "alexmt/atom-kotlin-language"
      desc = "Adds syntax highlighting to Kotlin files in Atom"
      setTags("editor", "ide", "language")
    }
    link {
      github = "vkostyukov/kotlin-sublime-package"
      desc = "A Sublime Package for Kotlin."
      setTags("editor", "ide", "language")
    }
    link {
      github = "udalov/kotlin-vim"
      desc = "Kotlin Syntax Highlighter for Vim."
      setTags("editor", "ide", "language")
    }
    link {
      github = "sargunster/kotlin-textmate-bundle"
      desc = "Kotlin bundle for TextMate."
      setTags("editor", "ide", "language")
    }
    link {
      github = "ice1000/NppExtension"
      desc = "Kotlin Language extension for Notepad++"
      setTags("editor", "ide", "language")
    }
    link {
      github = "ftomassetti/kanvas"
      desc = "A truly hackable editor: simple, lightweight, understandable."
      setTags("editor", "ide", "language")
    }
    link {
      github = "fwcd/KotlinLanguageServer"
      desc = "Smart code completion, diagnostics and more for Kotlin using the Language Server Protocol. VS Code extension included."
      setTags("editor", "ide", "language")
    }
    link {
      github = "mathiasfrohlich/vscode-kotlin"
      desc = "Kotlin language support for VS Code."
      setTags("editor", "ide", "language")
    }
  }
  subcategory("Syntax Highlighters") {
    link {
      github = "jneen/rouge"
      desc = "A pure-ruby code highlighter that is compatible with pygments. (wip)"
      setTags("syntax", "highlight")
    }
    link {
      github = "isagalaev/highlight.js"
      desc = "Javascript syntax highlighter. (out-of-date)"
      setTags("syntax", "highlight")
    }
    link {
      github = "github/linguist"
      desc = "For Ruby/Github, uses Sublime package"
      setTags("syntax", "highlight")
    }
    link {
      bitbucket = "birkenfeld/pygments-main"
      desc = "Python syntax highlighter."
      setTags("syntax", "highlight")
    }
    link {
      github = "cansik/kotlin-latex-listing"
      desc = "A syntax highlighting template for the Kotlin language in LaTeX listings."
      setTags("syntax", "highlight")
    }
  }
  subcategory("Game Development") {
    link {
      github = "zeganstyl/thelema-engine"
      desc = "3d graphics engine in Kotlin, based on sources of libGDX. Platforms: JVM, TeaVM, Kotlin/JS, Kotlin/Native. See live demo: [TeaVM](https://zeganstyl.github.io/thelema-teavm-tests/), [Kotlin/JS](https://zeganstyl.github.io/thelema-kxjs-demo/)"
      setTags("thelema-engine", "game dev", "games", "desktop", "webgl")
    }
    link {
      github = "libktx/ktx"
      desc = "Kotlin utilities for LibGDX applications."
      setTags("LibGDX", "game dev", "games")
    }
    link {
      github = "AlmasB/FXGL"
      desc = "JavaFX 8 Game Library written in Java + Kotlin"
      setTags("javafx", "desktop", "games", "game dev")
    }
    link {
      github = "icela/FriceEngine"
      desc = "Make game developing easy again!"
      setTags("desktop", "games", "game dev")
    }
    link {
      github = "vassilibykov/AdventKT"
      desc = "A Kotlin-based DSL for text adventures, with a partial replica of the classic Colossal Cave as an example."
      setTags("games", "text adventures")
    }
    link {
      github = "Hexworks/zircon"
      desc = "An extensible text GUI library which targets multiple platforms and designed specifically for game developers, written in Kotlin."
      setTags("text-gui", "games", "game-dev")
    }
    link {
      github = "korlibs/KorGE"
      desc = "Modern Multiplatform Game Engine for Kotlin. Write games for the JVM, JavaScript, Android and iOS in no time using Kotlin."
      setTags("desktop", "android", "games", "game-dev")
    }
    link {
      github = "KogeLabs/Ockero"
      desc = "Ockero: Kotlin OpenGl Game Engine"
      setPlatforms(JVM)
    }
    link {
      github = "littlektframework/littlekt"
      desc = "A Kotlin multiplatform 2D game development framework based on OpenGL that is inspired by libGDX and KorGE. Current platforms: JVM, Web, and Android."
      setTags("multiplatform", "desktop", "webgl", "android", "games", "game-dev")
    }
  }
  subcategory("Misc") {
    link {
      github = "RationalityFrontline/kevent"
      desc = "A powerful in-process event dispatcher based on Kotlin and Coroutines."
      setTags("eventbus", "event-dispatcher", "event-driven", "publish–subscribe", "android", "swing", "javafx", "coroutines", "functional-programming")
    }
    link {
      github = "themichailov/kache"
      desc = "Kotlin functions caching library, reducing count of function executions."
      setTags("cache")
    }
    link {
      github = "Kotlin/kotlinx.reflect.lite"
      desc = "Lightweight library allowing to introspect basic stuff about Kotlin symbols."
      setTags("reflection")
    }
    link {
      github = "puniverse/quasar"
      desc = "Fibers, Channels and Actors for the JVM."
      href = "https://github.com/puniverse/quasar/tree/master/quasar-kotlin"
    }
    link {
      github = "MehdiK/Humanizer.jvm"
      desc = "Humanizer.jvm meets all your jvm needs for manipulating and displaying strings, enums, dates, times, timespans, numbers and quantities."
      setTags("pluralization")
    }
    link {
      github = "mplatvoet/kovenant"
      desc = "Promises for Kotlin and Android"
      setTags("promise", "android")
    }
    link {
      github = "kohesive/klutter"
      desc = "A mix of random small libraries for Kotlin, the smallest reside here until big enough for their own repository."
    }
    link {
      github = "DragonKnightOfBreeze/breeze-framework"
      desc = "Integrated code framework base on Kotlin, provide many useful extensions for standard library and some frameworks."
    }
    link {
      github = "kohesive/solr-undertow"
      desc = "Solr Standalone Tiny and High performant server."
      setTags("solr", "undertow")
    }
    link {
      github = "leprosus/kotlin-hashids"
      desc = "Library that generates short, unique, non-sequential hashes from numbers."
      setTags("hash")
    }
    link {
      github = "mplatvoet/progress"
      desc = "Progress for Kotlin."
      setTags("progress")
    }
    link {
      github = "sargunster/KtUnits"
      desc = "Tiny unit conversion library for Kotlin."
      setTags("time", "unit", "conversion")
    }
    link {
      github = "hotchemi/khronos"
      desc = "An intuitive Date extensions in Kotlin."
      setTags("time", "date")
    }
    link {
      github = "yole/kxdate"
      desc = "Kotlin extensions for Java 8 java.time API"
      setTags("time", "date")
    }
    link {
      github = "seljabali/java-time-fun"
      desc = "java.time Kotlin extension functions library."
      setTags("time", "date", "conversion")
    }
    link {
      github = "ingokegel/jclasslib"
      desc = "jclasslib bytecode viewer is a tool that visualizes all aspects of compiled Java class files and the contained bytecode."
      setTags("bytecode")
    }
    link {
      github = "debop/koda-time"
      desc = "Joda Time Extensions in Kotlin. (From Java 8 use java.time instead)"
      setTags("joda-time", "jsr-310")
    }
    link {
      github = "saschpe/log4k"
      desc = "Lightweight logging library for Kotlin/Multiplatform. Supports Android, iOS, JavaScript and plain JVM environments."
    }
    link {
      github = "MicroUtils/kotlin-logging"
      desc = "Lightweight logging framework for Kotlin. Used as a wrapper for slf4j with Kotlin extensions."
      setTags("logging", "slf4j")
    }
    link {
      github = "InsanusMokrassar/KSLog"
      desc = "Fully customizable and lightweight logging library for Kotlin"
      setTags("logging")
    }
    link {
      github = "cesarferreira/kotlin-pluralizer"
      desc = "Kotlin extension to pluralize and singularize strings."
      setTags("pluralize", "singularizen")
    }
    link {
      github = "JoelW-S/groothy"
      desc = "Kotlin implementation of Groovy Truth."
      setTags("groovy truth")
    }
    link {
      github = "Jire/Strukt"
      desc = "Value types on the JVM, today!"
      setTags("gc-free", "structure")
    }
    link {
      github = "moshbit/Kotlift"
      desc = "Kotlift is the first source-to-source language transpiler from Kotlin to Swift."
      setTags("swift")
    }
    link {
      github = "consoleau/kassava"
      desc = "This library provides some useful kotlin extension functions for implementing toString() and equals() without all of the boilerplate."
      setTags("hashCode", "equals", "toString")
    }
    link {
      github = "czyzby/kotlin-times"
      desc = "A simple utility library for readable loops."
      setTags("extensions", "utility")
    }
    link {
      github = "doyaaaaaken/kotlin-csv"
      desc = "A pure kotlin simple csv reader/writer."
      setTags("csv", "kotlin multiplatform")
    }
    link {
      github = "phxql/aleksa"
      desc = "Aleksa is a small framework for writing Alexa Skills in Kotlin."
      setTags("alexa", "amazon echo", "text to speech")
    }
    link {
      github = "just-ai/jaicf-kotlin"
      desc = "Kotlin framework for conversational voice assistants and chatbots development."
      setTags("chatbot", "speech to text", "text to speech", "alexa", "google assistant", "actions on google", "voice")
      setPlatforms(JVM, ANDROID)
    }
    link {
      github = "TicketmasterMobileStudio/actions-on-google-kotlin"
      desc = "Port of official Node.js SDK to Kotlin. Complete with all features and tests and nearly identical API."
      setTags("actions on google", "google assistant", "google home")
    }
    link {
      github = "cretz/asmble"
      desc = "Compile WebAssembly to JVM and other WASM tools."
      setTags("wasm", "webassembly")
    }
    link {
      github = "fork-handles/forkhandles"
      name = "fork-handles/tuples4k"
      desc = "Tuple classes"
      href = "https://github.com/fork-handles/forkhandles/tree/trunk/tuples4k"
      setTags("tuples")
    }
    link {
      github = "Kotlin/kotlinx.atomicfu"
      desc = "The idiomatic way to use atomic operations in Kotlin."
      setTags("atomic")
      awesome()
    }
    link {
      github = "vjames19/kotlin-futures"
      desc = "A collections of extension functions to make the JVM Future, CompletableFuture, ListenableFuture API more functional and Kotlin like."
    }
    link {
      github = "kunalsheth/units-of-measure"
      desc = "A type-safe dimensional analysis library for Kotlin."
      setTags("dimensional-analysis", "typesafety", "metaprogramming")
    }
    link {
      github = "vsirotin/si-units"
      name = "KotUniL"
      desc = "KotUniL: Kotlin function and objects for working with SI units like meter, second, as well as currencies and general units like percent."
      setTags("si-units", "dimensional-analysis", "typesafety", "physics", "multiplatform", "js")
    }
    link {
      github = "spoptchev/kotlin-preconditions"
      desc = "Precondition error checking in kotlin."
      setTags("preconditions")
    }
    link {
      github = "spoptchev/scientist"
      desc = "A kotlin library for refactoring code. Port of GitHub's scientist."
      setTags("scientist", "refactoring")
    }
    link {
      github = "soywiz/klock"
      desc = "Consistent and portable date and time utilities for multiplatform kotlin (JVM, JS and Common)."
      setTags("js", "date", "time")
    }
    link {
      github = "d-max/dsl-logger"
      desc = "Simple DSL for logging with logger abstraction layer"
      setTags("dsl", "logging", "android", "slf4j")
    }
    link {
      github = "evoasm/kasm"
      desc = "x64/x86-64 assembler and execution library"
      setTags("x64", "x86", "assembly", "assembler")
    }
    link {
      github = "korlibs/kds"
      desc = "Optimized Kotlin Data Structures for JVM, JS and Common"
      setTags("ds")
    }
    link {
      github = "s1monw1/TLSLibrary"
      desc = "Simple TlsLibrary written in Kotlin - Provides DSL for creating TLS connections"
      setTags("dsl", "tls", "ssl", "jsse")
    }
    link {
      github = "KotlinNLP/SimpleDNN"
      desc = "SimpleDNN is a machine learning lightweight open-source library part of KotlinNLP and has been designed to support relevant neural network architectures in natural language processing tasks."
      setTags("machine-learning", "recurrent-neural-networks", "feedforward-neural-network", "natural-language-processing")
    }
    link {
      github = "nickhristov/krakdown"
      desc = "A native markdown parser written in Kotlin."
      setTags("markdown", "parser")
    }
    link {
      github = "ziggy42/kolor"
      desc = "A library to print colored strings, with Kotlin."
      setTags("ansi-colors", "colors", "shell")
    }
    link {
      github = "holgerbrandl/kravis"
      desc = "A Kotlin grammar for scientific data visualization"
      setTags("Data Science")
    }
    link {
      github = "MiloszKrajewski/stateful4k"
      desc = "State Machine Construction Kit for Kotlin"
      setTags("state machine")
    }
    link {
      github = "charleskorn/kaml"
      desc = "YAML support for kotlinx.serialization"
      setTags("serialization", "yaml")
    }
    link {
      github = "jershell/kbson"
      desc = "Bson support for kotlinx.serialization"
    }
    link {
      github = "pemistahl/lingua"
      desc = "A language detection library suitable for long and short text alike"
      setTags("nlp", "natural-language-processing", "linguistics", "languages", "language-detection", "language-modeling", "machine-learning")
    }
    link {
      github = "sandjelkovic/kxjtime"
      desc = "Lightweight Kotlin extensions for java.time API"
      setTags("extensions", "time", "date", "jdk8", "java.time", "utility")
    }
    link {
      github = "pmwmedia/tinylog"
      desc = "Lightweight logging framework with native logging API for Kotlin."
      setPlatforms(JVM, ANDROID)
      setTags("logging", "logger")
    }
    link {
      github = "Lewik/klog"
      desc = "Minimalistic and multiplatform logging for Kotlin"
      setPlatforms(JVM, JS, COMMON)
      setTags("logging", "multiplatform")
    }
    link {
      github = "Rasalexman/KDispatcher"
      desc = "Simple and light-weight event dispatcher for Kotlin"
    }
    link {
      github = "dotCipher/kase-format"
      desc = "String case conversion and detection library"
    }
    link {
      github = "vittee/kformula"
      desc = "Mathematical expression engine written in Kotlin, running on JVM."
    }
    link {
      github = "eriksencosta/math-common"
      desc = "Mathematical conventions to reduce boilerplate code"
      setTags("math", "rounding", "exponentiation")
    }
    link {
      github = "eriksencosta/math-percentage"
      desc = "Percentage calculations made easy"
      setTags("math", "percentage")
    }
    link {
      github = "eriksencosta/money"
      desc = "Monetary calculations and allocations made easy"
      setTags("money", "currency", "cryptocurrency", "foreign-exchange")
    }
    link {
      github = "vendelieu/telegram-bot"
      desc = "A lightweight, feature-rich wrapper for the Telegram Bot API"
      setTags("telegram", "bot", "Kotlin")
    }
    link {
      github = "kotlin-telegram-bot/kotlin-telegram-bot"
      desc = "A wrapper for the Telegram Bot API written in Kotlin."
    }
    link {
      github = "insanusmokrassar/TelegramBotAPI"
      desc = "Kotlin Multiplatform library for type-safe work with Telegram Bot API"
      setTags("telegram", "bot", "multiplatform", "Kotlin/JVM", "Kotlin/JS")
      setPlatforms(COMMON, JVM, JS)
    }
    link {
      github = "aminography/PrimeCalendar"
      desc = "Provides all of the java.util.Calendar functionalities for Civil, Persian, Hijri, Japanese, etc, as well as their conversion to each other."
    }
    link {
      github = "pearxteam/kasechange"
      desc = "Multiplatform Kotlin library to convert strings between various case formats including Camel Case, Snake Case, Pascal Case and Kebab Case"
      setPlatforms(ANDROID, COMMON, IOS, JS, JVM, NATIVE, WASM)
      setTags("multiplatform", "string", "case-conversion")
    }
    link {
      github = "pearxteam/kpastebin"
      desc = "Multiplatform Kotlin library to interact with the pastebin.com API"
      setPlatforms(ANDROID, COMMON, IOS, JS, JVM, NATIVE)
      setTags("multiplatform", "pastebin", "api")
    }
    link {
      github = "justwrote/kjob"
      desc = "A coroutine based persistent background scheduler written in Kotlin."
      setTags("job-scheduler", "task", "job-queue", "kotlin", "runner", "job", "mongodb", "kotlin-library", "kotlin-coroutines", "queue", "job-processor")
    }
    link {
      github = "fluidsonic/fluid-pdf"
      desc = "Easy PDF generation with HTML & CSS using Chromium or Google Chrome"
      setPlatforms(JVM)
      setTags("pdf")
    }
    link {
      github = "Kotlin/kotlinx-datetime"
      desc = "A multiplatform Kotlin library for working with date and time."
      setTags("multiplatform", "date", "time")
      awesome()
    }
    link {
      github = "vendelieu/re.this"
      desc = "Kotlin Multiplatform Redis Client: coroutine-based, DSL-powered, and easy to use. "
      href = "https://vendelieu.github.io/re.this/"
      setTags("multiplatform", "coroutines", "redis", "client")
      setPlatforms(COMMON, IOS, JVM, NATIVE)
    }
    link {
      github = "sapotero/dice-db-client"
      desc = "DiceDB Kotlin Client - strongly typed, coroutine-based, and easy to use."
      setTags("coroutines", "dice-db", "client")
      setPlatforms(COMMON, JVM)
    }
    link {
      github = "oolong-kt/oolong"
      href = "https://oolong-kt.org"
      desc = "Elm inspired Model-View-Update (MVU) implementation for Kotlin multiplatform."
      setTags("multiplatform", "mvu", "coroutines")
      setPlatforms(COMMON, IOS, JVM, NATIVE)
    }
    link {
      github = "mobiletoly/urlsome"
      desc = "URL builder library for Kotlin"
      setTags("URL", "builder", "http")
      setPlatforms(JVM)
    }
    link {
      github = "ssuukk/Qotlin"
      desc = "IBM Q Experience Kotlin toolkit - Kotlin library to interact and write assembly code for IBM Quantum computers"
      setPlatforms(JVM)
    }
    link {
      github = "DavidMellul/Kotlin-Publish-Subscribe"
      desc = "Intuitive and powerful human-readable Kotlin DSL for IPCs & turning anything into a message receiver / broadcaster"
      setTags("ipc", "extension", "misc")
      setPlatforms(JVM)
    }
    link {
      github = "ivanisidrowu/KtRssReader"
      desc = "Kotlin library for parsing RSS feeds"
      setTags("rss", "feed")
      setPlatforms(JVM, ANDROID)
    }
    link {
      github = "z4kn4fein/kotlin-semver"
      desc = "Semantic Versioning library for Kotlin Multiplatform."
      setTags("multiplatform", "semver", "semantic", "version")
      setPlatforms(ANDROID, COMMON, IOS, JS, JVM, NATIVE, WASM)
    }
    link {
      github = "krud-dev/shapeshift"
      desc = "A Kotlin library for intelligent object mapping and conversion between objects."
      setTags("object-mapping", "utility", "conversion", "spring")
      setPlatforms(JVM, ANDROID)
    }
    link {
      github = "touchlab/KMMBridge"
      desc = "KMMBridge is a set of Gradle tooling that facilitates publishing and consuming pre-built KMM (Kotlin Multiplatform Mobile) Xcode Framework binaries."
      setTags("gradle", "multiplatform", "tooling")
      setPlatforms(NATIVE, IOS, ANDROID)
    }
    link {
      github = "Ahoo-Wang/CoCache"
      desc = "Level 2 Distributed Coherence Cache Framework"
      setTags("cache", "redis", "distributed", "coherence", "spring-boot")
    }
    link {
      github = "kryptokrona/kryptokrona-kotlin-sdk"
      desc = "Kryptokrona SDK in Kotlin for building decentralized private communication and payment systems."
      setTags("blockchain", "cryptocurrency", "cryptography", "sdk", "crypto")
    }
    link {
      github = "lpicanco/krate"
      desc = "Krate is a rate limiter library designed specifically for Kotlin applications. In memory, Redis and Caffeine support."
      href = "https://lpicanco.github.io/krate"
      setTags("rate-limit", "token-bucket", "redis")
      setPlatforms(JVM, ANDROID)
    }
    link {
      github = "Ahoo-Wang/Simba"
      desc = "Distributed lock service"
      setTags("lock", "mutex", "distributed", "scheduler", "redis", "zookeeper", "jdbc", "spring-boot")
    }
    link {
      github = "nsk90/kstatemachine"
      desc = "KStateMachine is a Kotlin DSL library for creating state machines and statecharts."
      setTags("state machine", "coroutines", "multiplatform", "dsl")
      setPlatforms(JVM, ANDROID, IOS)
    }
    link {
      github = "jillesvangurp/geogeometry"
      desc = "GeoGeometry is a set of algorithms and functions for manipulating geo hashes and geometric shapes with geo coordinates"
      setTags("gis", "geo-spatial","utm","mgrs","ups","geojson","alhorithms")
      setPlatforms(JVM, JS, NATIVE, IOS)
    }
    link {
      github = "jillesvangurp/querylight"
      desc = "In memory search engine for simple in app search. Implements tf/idf and a some basic queries, tokenizers and analyzers."
      setTags("search","tf/idf")
      setPlatforms(COMMON, JVM, JS)
    }
    link {
      github = "clovis-ai/pedestal"
      desc = "Caching, error tracking, progress tracking, weak references, and more…"
      setTags("cache", "error", "progress", "weak")
      setPlatforms(COMMON, JVM, JS, NATIVE)
    }
    link {
      github = "daniel-rusu/pods4k"
      desc = "Performance-oriented data structures for Kotlin, including Immutable Arrays"
      setTags("kotlin", "data-structure", "performance", "efficient")
      setPlatforms(JVM, ANDROID)
    }
  }
  subcategory("Parsers") {
    link {
      github = "fleeksoft/ksoup"
      desc = "Kotlin Multiplatform library for working with HTML and XML. It's a port of the renowned Java library Jsoup."
      setPlatforms(JVM, ANDROID, IOS, NATIVE, JS, WASM)
      setTags("html", "xml", "parser")
      awesome()
    }
    link {
      github = "ParserKt/ParserKt"
      setPlatforms(COMMON, JS, JVM)
    }
    link {
      github = "sargunster/CakeParse"
      desc = "Simple parser combinator library for Kotlin."
      setTags("parser", "combinator", "grammar", "lexer")
      setPlatforms(JVM)
    }
    link {
      github = "h0tk3y/better-parse"
      desc = "A nice parser combinator library for Kotlin"
      setTags("parser", "parser-combinator", "grammar", "lexer")
      setPlatforms(COMMON, JS, JVM, NATIVE, IOS)
    }
    link {
      github = "fork-handles/forkhandles"
      name = "fork-handles/parser4k"
      desc = "Recursive descent parser combinator library"
      href = "https://github.com/fork-handles/forkhandles/tree/trunk/parser4k"
      setTags("parser", "parser-combinator", "recursive descent")
      setPlatforms(JVM)
    }
    link {
      github = "asm0dey/staks"
      desc = "Extensible XML parser DSL, based on StAX"
      setTags("XML", "StAX", "DSL", "parser")
      setPlatforms(JVM)
    }
    link {
      github = "muhrifqii/ParseRSS"
      desc = "Extensible kotlin library to parse RSS for android, included with retrofit and fuel converter factory"
      setTags("rss", "feed", "parser", "retrofit")
      setPlatforms(ANDROID)
    }
  }
  subcategory("Raspberry Pi") {
    link {
      github = "Pi4J/pi4j-kotlin"
      desc = "Pi4J Kotlin DSL and API."
      setTags("raspberry-pi", "raspberrypi", "gpio", "dsl", "pi4j")
    }
  }
  subcategory("Multiplatform") {
    link {
      github = "ionspin/kotlin-multiplatform-bignum"
      desc = "Pure kotlin multiplatform arbitrary precision arithmetic library."
      setTags("multiplatform", "bignum", "biginteger", "bigdecimal", "arbitrary-precision")
    }
    link {
      github = "davidepianca98/KMQTT"
      desc = "MQTT Broker library/executables for Kotlin multiplatform."
    }
    link {
      github = "GitLiveApp/firebase-kotlin-sdk"
      desc = "A Kotlin-first Multiplatform SDK for Firebase supporting iOS, Android & Web"
      setTags("firebase", "firestore", "multiplatform")
    }
    link {
      github = "DetachHead/kotlinxpath"
      desc = "A typesafe builder for Xpath with several useful helper functions that make Xpath easier to work with"
      setTags("xpath", "xpath-builder", "typesafe-builder", "multiplatform")
      setPlatforms(COMMON, JVM, JS, NATIVE)
    }
    link {
      github = "petertrr/kotlin-multiplatform-diff"
      desc = "Multiplatform kotlin library for calculating text differences. Based on java-diff-utils."
      setTags("multiplatform", "tools", "text", "diff", "myers", "algorithm")
      setPlatforms(COMMON, JVM, JS, NATIVE)
    }
    link {
      github = "nacular/measured"
      desc = "Type-safe, intuitive units of measure"
      setTags("multiplatform", "framework")
      setPlatforms(COMMON, JVM, JS)
    }
    link {
      github = "ctripcorp/mmkv-kotlin"
      desc = "The Kotlin Multiplatform wrapper for MMKV"
      setTags("multiplatform", "android", "native", "key-value", "store")
      setPlatforms(COMMON, ANDROID, IOS, NATIVE)
    }
    link {
      github = "Ashampoo/kim"
      desc = "Kotlin Multiplatform library for reading and writing image metadata"
      setTags("multiplatform", "metadata", "native", "jpg", "png", "tiff")
      setPlatforms(COMMON, JVM, ANDROID, IOS, NATIVE)
    }
    link {
      github = "Ashampoo/xmpcore"
      desc = "Kotlin Multiplatform port of Adobe's XMP SDK"
      setTags("multiplatform", "metadata", "native", "xmp")
      setPlatforms(COMMON, JVM, ANDROID, IOS, NATIVE)
    }
    link {
      github = "divyanshupundir/mavlink-kotlin"
      desc = "A modern MAVLink library for Kotlin Multiplatform."
      setTags("multiplatform", "mavlink", "drone", "uav", "px4", "ardupilot")
      setPlatforms(COMMON, JVM, JS, ANDROID, IOS, NATIVE)
    }
    link {
      github = "L-Briand/KTM"
      desc = "Mustache templating in kotlin multiplatform"
      setTags("multiplatform", "template", "template-engine", "mustache")
      setPlatforms(COMMON, JVM, JS, ANDROID, IOS, NATIVE)
    }
    link {
      github = "respawn-app/FlowMVI"
      desc = "A Kotlin Multiplatform architectural framework based on coroutines with an extensive feature set, powerful plugin system and a rich DSL."
      setTags("multiplatform", "arch", "architecture", "mvi")
      setPlatforms(COMMON, JVM, JS, ANDROID, IOS, NATIVE, WASM)
    }
  }
  subcategory("Cryptography") {
    link {
      github = "ionspin/kotlin-multiplatform-libsodium"
      desc = "Kotlin multiplatform wrapper for Libsodium cryptographic library."
      setTags("multiplatform", "libsodium", "cryptography")
    }
    link {
      github = "appmattus/crypto"
      desc = "A collection of Kotlin Multiplatform Mobile cryptographic hashing functions."
      setTags("multiplatform", "cryptography", "CRC", "Adler-32", "CityHash", "FarmHash", "HighwayHash", "MetroHash", "MurmurHash", "t1ha", "xxHash", "wyhash", "Blake", "HMAC", "Skein", "BMW", "cSHAKE", "CubeHash", "ECHO", "Fugue", "GOST", "Groestl", "Hamsi", "Haraka", "HAVAL", "JH", "Keccak", "Kupyna", "Luffa", "MessageDigest", "MD5", "PANAMA", "RadioGatun", "RIPEMD", "SHA", "Shabal", "SHAKE", "SIMD", "SM3", "Tiger", "Whirlpool")
    }
  }
  subcategory("DSL") {
    link {
      github = "h0tk3y/regex-dsl"
      desc = "A Kotlin DSL for regular expressions"
      setPlatforms(JVM)
    }
    link {
      github = "bipokot/Kabu"
      desc = "The fastest way to create complex Kotlin DSL"
      setTags("dsl", "kotlin", "codegenerator")
    }
  }
  subcategory("Extensions") {
    link {
      github = "Kotlin/kotlinx.support"
      desc = "Extension and top-level functions to use JDK7/JDK8 features in Kotlin 1.0."
      setTags("extensions", "jdk8", "jdk7")
    }
    link {
      github = "vanshg/KrazyKotlin"
      desc = "A collection of useful Kotlin Extension"
      setTags("extensions")
    }
    link {
      github = "hankdavidson/ktime"
      desc = "Extensions to the java8 time library"
      setTags("extensions", "jdk8", "time", "date", "range")
    }
    link {
      github = "LukasForst/katlib"
      desc = "A collection of Kotlin extension functions and utilities."
      setTags("extensions")
    }
  }
  subcategory("Configuration") {
    link {
      github = "npryce/konfig"
      desc = "A Type Safe Configuration API for Kotlin"
      setTags("configuration")
    }
    link {
      github = "mariomac/kaconf"
      desc = "KickAss Configuration. An annotation-based configuration system for Java and Kotlin"
      setTags("configuration")
    }
    link {
      github = "config4k/config4k"
      desc = "A Kotlin wrapper for Typesafe Config"
      setTags("configuration")
      setPlatforms(JVM)
      awesome()
    }
    link {
      github = "jdiazcano/cfg4k"
      desc = "Flexible and easy to use config library written in kotlin."
      setTags("configuration")
    }
    link {
      github = "daviddenton/configur8"
      desc = "A Kotlin port of Configur8 - A Type Safe Configuration API for Kotlin, extendable to user-defined types."
      setTags("configuration")
    }
    link {
      github = "ufoscout/properlty"
      desc = "Simple configuration library with placeholders resolution and zero magic!"
      setTags("configuration")
    }
    link {
      github = "uchuhimo/konf"
      desc = "A type-safe cascading configuration library for Kotlin/Java, supporting most configuration formats"
      setTags("configuration")
    }
    link {
      github = "sksamuel/hoplite"
      desc = "A library for loading configuration files into typesafe Kotlin data classes in a boilerplate-free way"
    }
    link {
      github = "Nohus/AutoKonfig"
      desc = "A Kotlin configuration library with batteries included. Type-safe, zero lines of setup."
      href = "https://autokonfig.nohus.dev/"
      setTags("configuration")
    }
    link {
      github = "cdimascio/dotenv-kotlin"
      desc = "A zero-dependency module that loads environment variables from a .env file"
      setTags("twelve-factor", "environment-variables")
      setPlatforms(ANDROID, JVM)
    }
    link {
      github = "davidohana/kofiko-kotlin"
      desc = "Kofiko: Code-First configuration library. Lightweight, simple and minimal boilerplate."
      setTags("configuration", "environment-variables", "ini", "json", "env")
      setPlatforms(JVM)
    }
  }
  subcategory("Graphics") {
    link {
      github = "data2viz/data2viz"
      desc = "multiplatform dataviz library, d3js port"
      setTags("d3js", "multiplatform", "svg", "javafx")
    }
    link {
      github = "kotlin-graphics/glm"
      desc = "g-truck glm port, opengl mathematics library"
      setTags("glm", "opengl", "vulkan", "matrices", "vectors", "math-library")
    }
    link {
      github = "dananas/kotlin-glsl"
      desc = "Write your GLSL shaders in Kotlin"
      setTags("glsl", "opengl")
    }
    link {
      github = "kotlin-graphics/kotlin-unsigned"
      desc = "Unsigned operators and boxed types (Ubyte, Uint, Ulong and Ushort) for unsigned support."
      setTags("unsigned", "math")
    }
    link {
      github = "kotlin-graphics/gli"
      desc = "g-truck gli port, image library"
      setTags("gli", "opengl", "vulkan", "texture")
    }
    link {
      github = "kotlin-graphics/uno-sdk"
      desc = "Unofficial OpenGL SDK"
      setTags("gli", "opengl", "vulkan")
    }
    link {
      github = "kotlin-graphics/ovr"
      desc = "Oculus binding"
      setTags("vr", "oculus", "opengl")
    }
    link {
      github = "kotlin-graphics/openvr"
      desc = "OpenVR binding"
      setTags("vr", "openvr", "steamvr", "opengl", "vulkan")
    }
    link {
      github = "kotlin-graphics/assimp"
      desc = "Open Asset Import Library port"
      setTags("assimp", "stl", "md2", "ply", "obj", "collada", "fbx", "opengl", "vulkan")
    }
    link {
      github = "kotlin-graphics/imgui"
      desc = "jvm port of imgui"
      setTags("opengl", "gui", "gamedev", "dear-imgui")
    }
    link {
      github = "kotlin-graphics/bullet"
      desc = "bullet port"
      setTags("opengl", "vulkan", "gamedev", "physics", "simulation", "robotics", "kinematics")
    }
    link {
      github = "GlimpseFramework/glimpse-framework"
      desc = "OpenGL made simple."
      setTags("opengl", "shaders")
    }
    link {
      github = "java-opengl-labs/modern-jogl-examples"
      desc = "port of 'Learning Modern 3D Graphic Programming' by J.L.McKesson (jogl)"
      setTags("opengl", "tutorial", "jogl")
    }
    link {
      github = "java-opengl-labs/learn-OpenGL"
      desc = "port of https://learnopengl.com/ tutorial (lwjgl)"
      setTags("opengl", "tutorial", "lwjgl")
    }
    link {
      github = "java-opengl-labs/Vulkan"
      desc = "port of https://github.com/SaschaWillems/Vulkan"
      setTags("vulkan", "tutorial", "lwjgl")
    }
    link {
      github = "Jonatino/JOGL2D"
      desc = "Zero-overhead 2D rendering library for JOGL using Kotlin."
      setTags("jogl", "opengl")
    }
    link {
      github = "soywiz/kaifu2x"
      desc = "Waifu2x port to Kotlin as library and CLI. Convolutional-neural-network based upscaler for Anime-like images and noise/artifact reduction."
      setTags("waifu2x", "convolutional-neural-networks", "kotlin", "noise-reduction", "scaler")
    }
    link {
      github = "nwillc/ksvg"
      desc = "Kotlin SVG image generation DSL, supporting inline and file formats."
      setTags("ksvg", "svg", "kotlin", "dsl")
    }
    link {
      github = "openrndr/openrndr"
      desc = "OPENRNDR, a framework for creative coding in Kotlin. Accelerated 2D and 3D graphics, vector graphics, shaders and animation"
      setTags("opengl", "creative-coding", "kotlin", "dsl", "shaders", "ljwgl")
    }
    link {
      github = "openrndr/orx"
      desc = "ORX is a collection extras for OPENRNDR which add support for sensors, live-coding, user interfaces and much more."
      setTags("opengl", "creative-coding", "kotlin", "dsl", "shaders", "ljwgl")
    }
    link {
      github = "markaren/three.kt"
      desc = "Kotlin port of three.js JavaScript 3D library"
      setTags("opengl", "lwjgl3", "three-js")
    }
    link {
      github = "JetBrains/skiko"
      desc = "Kotlin Multiplatform bindings to Skia"
      setPlatforms(JVM, NATIVE)
      setTags("skia")
    }
  }
  subcategory("Data Science") {
    link {
      name = "Kotlin for Data Science"
      desc = "Kotlin for Data Science overview page"
      href = "https://kotlinlang.org/docs/reference/data-science-overview.html"
      awesome()
    }
    link {
      github = "Kotlin/dataframe"
      desc = "A Kotlin library for in-memory data manipulation"
      href = "https://github.com/Kotlin/dataframe"
      setTags("data science", "data analysis", "data wrangling", "csv", "json")
      setPlatforms(JVM)
      awesome()
    }
    link {
      github = "Kotlin/kandy"
      desc = "Kotlin plotting library"
      href = "https://github.com/Kotlin/kandy"
      setTags("data science", "data analysis", "plot")
      awesome()
    }
    link {
      github = "JetBrains/lets-plot-kotlin"
      desc = "Grammar of graphics visualization for Kotlin"
      href = "https://github.com/JetBrains/lets-plot-kotlin"
      setTags("data science", "data analysis", "plot")
      awesome()
    }
    link {
      github = "Kotlin/KotlinDL"
      desc = "High-level Deep Learning Framework written in Kotlin and inspired by Keras."
      href = "https://github.com/Kotlin/kotlindl"
      setTags("data science", "neural-networks", "deep-learning", "machine-learning", "artificial-intelligence")
      awesome()
    }
    link {
      github = "Kotlin/kotlin-jupyter"
      desc = "Official Kotlin Jupyter kernel"
      setTags("data science", "juputer", "repl")
      awesome()
    }
    link {
      github = "kyonifer/koma"
      desc = "A scientific computing library for Kotlin."
      setTags("data science", "plot", "matlab", "numpy")
    }
    link {
      github = "mipt-npm/kmath"
      desc = "A (not so numpy-like) multiplatform mathematical library with higher level abstractions."
      awesome()
    }
    link {
      github = "unipu-ict/ksdtoolkit"
      desc = "Kotlin System Dynamics Toolkit - for system dynamics modelling and simulation with Kotlin."
      setTags("system dynamics", "modelling", "simulation", "complex system")
    }
    link {
      github = "MarcinMoskala/KotlinDiscreteMathToolkit"
      desc = "Set of extensions for Kotlin that provides Discrete Math functionalities as an Kotlin extension functions."
      setTags("data science", "math")
    }
    link {
      github = "sekwiatkowski/Komputation"
      desc = "A neural network framework written in Kotlin."
      setTags("data science", "neural-networks", "deep-learning", "machine-learning", "artificial-intelligence")
    }
    link {
      github = "sanity/pairAdjacentViolators"
      desc = "A Kotlin implementation of the Pair Adjacent Violators algorithm for isotonic regression."
      setTags("data science", "pair adjacent violators")
    }
    link {
      github = "breandan/kotlingrad"
      desc = "Shape-Safe Differentiable Programming with Algebraic Data Types."
    }
    link {
      github = "kiegroup/optaplanner"
      desc = "Constraint solving AI for planning and scheduling problems."
      href = "https://www.optaplanner.org/compatibility/kotlin.html"
      setTags("data science", "artificial-intelligence", "mathematical-optimization", "constraint-solving")
    }
    link {
      github = "timefoldai/timefold-solver"
      desc = "AI solver to optimize scheduling of vehicle routes, employees, maintenance, jobs, etc."
      href = "https://timefold.ai"
      setTags("data science", "artificial-intelligence", "mathematical-optimization", "constraint-solving")
    }
    link {
      github = "holgerbrandl/kalasim"
      desc = "Discrete event simulator that enables complex, dynamic process models."
      href = "https://www.kalasim.org"
      setTags("data science", "state machine")
      setPlatforms(JVM)
    }
    link {
      github = "cdietze/euklid"
      setPlatforms(COMMON, JS, JVM)
    }
    link {
      github = "lamba92/KGraph"
      desc = "A Kotlin multi-platform library for graph data structures"
      setTags("data-science")
      setPlatforms(JVM, JS, COMMON, NATIVE)
    }
    link {
      github = "Kotlin/multik"
      desc = "A Kotlin library for working with multi-dimensional arrays"
      setTags("data science", "math", "multidimensional array")
      setPlatforms(COMMON, JVM, JS, NATIVE, WASM)
    }
    link {
      github = "breandan/kaliningraph"
      setPlatforms(JVM)
    }
    link {
      github = "grinisrit/noa-atra"
      desc = "Analytics for Trading with NOA"
    }
    link {
      github = "sigbla/sigbla-app"
      desc = "Sigbla is a framework for working with data in tables, supporting various data types, reactive programming and events, user input, charts, and more"
      href = "https://github.com/sigbla/sigbla-app"
      setTags("data science", "data analysis", "data wrangling", "table", "plot")
      setPlatforms(JVM)
    }
  }
  subcategory("Command Line Interface") {
    link {
      github = "ajalt/clikt"
      desc = "Clikt - Intuitive command line interface parsing for Kotlin."
      setTags("cli", "command line parser", "argument parser", "option parser")
    }
    link {
      github = "leprosus/kotlin-cli"
      desc = "Kotlin-CLI - command line interface options parser for Kotlin."
      setTags("cli", "command line interface")
    }
    link {
      github = "jimschubert/kopper"
      desc = "A simple Kotlin option parser"
      setTags("cli", "parser")
    }
    link {
      github = "xenomachina/kotlin-argparser"
      desc = "Easy to use and concise yet powerful and robust command line argument parsing for Kotlin."
      setTags("command-line-parser", "argument-parser", "option-parser")
    }
    link {
      github = "ajalt/mordant"
      desc = "Mordant - Full-featured text styling for Kotlin command line applications."
      setTags("cli", "ansi", "color")
    }
    link {
      github = "aPureBase/arkenv"
      desc = "Fully fledged command line arguments / environment variables parser via simple Kotlin delegates"
      setTags("cli", "argument", "env", "environment", "variables", "parser")
    }
    link {
      github = "fork-handles/forkhandles"
      name = "fork-handles/bunting4k"
      desc = "Simple, typesafe, testable command line flags"
      href = "https://github.com/fork-handles/forkhandles/tree/trunk/bunting4k"
      setTags("cli", "command", "argument", "flag", "option", "parser")
    }
    link {
      github = "dbaelz/Konclik"
      setTags("native", "CLI")
      setPlatforms(JVM, JS, NATIVE, COMMON)
    }
    link {
      github = "varabyte/kotter"
      desc = "A declarative, Kotlin-idiomatic API for writing dynamic command line applications"
      setTags("cli", "ansi", "color")
      setPlatforms(JVM)
    }
    link {
      github = "kotlin-inquirer/kotlin-inquirer"
      name = "kotlin-inquirer"
      desc = "A collection of common interactive command line user interfaces written in Kotlin"
      href = "https://github.com/kotlin-inquirer/kotlin-inquirer"
      setTags("cli", "command", "interactive", "ui", "ansi", "color", "command line interface")
    }
  }
  subcategory("Browsers") {
    link {
      github = "wendigo/chrome-reactive-kotlin"
      setTags("web", "chrome", "automation", "browser")
    }
    link {
      github = "cdpdriver/kdriver"
      desc = "A blazing fast, coroutine-first, undetectable web scraping / browser automation CDP-based library for Kotlin"
      setTags("web-scraping", "browser-automation", "cdp", "chrome")
      setPlatforms(COMMON, JVM)
    }
  }
  subcategory("I/O") {
    link {
      github = "square/okio"
      href = "https://square.github.io/okio"
      desc = "A modern I/O library for Android, Kotlin, and Java."
      setPlatforms(ANDROID, JVM, COMMON, IOS, NATIVE, JS)
      setTags("io", "multiplatform")
      awesome()
    }
    link {
      github = "rsocket/rsocket-kotlin"
      href = "https://rsocket.io"
      desc = "Kotlin implementation of RSocket."
      setPlatforms(JVM, JS)
      setTags("rsocket", "rx", "reactive-streams")
    }
    link {
      github = "lepicekmichal/SignalRKore"
      href = "https://github.com/lepicekmichal/SignalRKore"
      desc = "Kotlin multiplatform implementation of SignalR."
      setPlatforms(ANDROID, IOS, JVM)
      setTags("signalr", "websocket", "multiplatform", "signalrkore")
    }
    link {
      github = "Dynamium/EVCalc"
      desc = "EVCalc is a calculation engine for mobile electric venicles (Electric scooters, electric unicycles, and so on) written in Kotlin."
      setPlatforms(JVM)
      setTags("evcalc", "dynamium", "calculation", "ev", "euc", "electric unicycles", "electric-scooters", "engine")
    }
    link {
      github = "agcom/knio2"
      desc = "Kotlinx coroutines extensions for Java NIO.2"
      setPlatforms(JVM)
      setTags("io")
    }
  }
  subcategory("API Clients") {
    link {
      github = "jillesvangurp/kt-search"
      desc = "Kotlin multiplatform library for Elasticsearch and Opensearch"
      setPlatforms(COMMON, JS, JVM, NATIVE)
      setTags("elasticsearch", "opensearch", "api-client","co-routines", "dsl")
    }
    link {
      github = "formation-res/overpass-kotlin-client"
      desc = "A simple client for overpass that uses ktor-client and kotlinx.serialization for parsing JSON responses."
      setPlatforms(COMMON, JS, JVM)
      setTags("overpass","api-client","openstreetmap","gis")
    }
    link {
      github = "JetBrains/space-kotlin-sdk"
      desc = "Kotlin client for JetBrains Space HTTP API"
      setPlatforms(COMMON, JS, JVM)
      awesome()
    }
    link {
      github = "adamint/spotify-web-api-kotlin"
      desc = "Spotify Web API wrapper for Kotlin/Android, JVM, JS, and Native targets."
      setPlatforms(JVM, JS, ANDROID, NATIVE, COMMON)
    }
    link {
      github = "awslabs/aws-sdk-kotlin"
      desc = "Multiplatform AWS SDK for Kotlin"
      setPlatforms(JVM, ANDROID)
    }
    link {
      github = "MoviebaseApp/tmdb-api"
      desc = "Modern powerful TMDB API to fetch movies and TV shows for Kotlin Multiplatform."
      setPlatforms(JVM, JS, ANDROID, NATIVE, COMMON)
    }
    link {
      github = "MoviebaseApp/trakt-api"
      desc = "Modern powerful Trakt API to track, discover and share your movies & TV shows."
      setPlatforms(JVM, JS, ANDROID, NATIVE, COMMON)
    }
    link {
      github = "InsanusMokrassar/ktgbotapi"
      desc = "Strongly typed API wrapper for Telegram Bots API"
      setPlatforms(JVM, JS, ANDROID, NATIVE, COMMON)
    }
  }
  subcategory("Internationalisation and Localization") {
    link {
      github = "cashapp/barber"
      desc = "A type safe Kotlin JVM library for building up localized, fillable, themed documents using Mustache templating."
      setTags("Mustache")
      setPlatforms(JVM)
    }
    link {
      github = "projectfluent/fluent-kotlin"
      desc = "Kotlin tooling implementation of ProjectFluent. Read, write, and transform Fluent files."
      setTags("L10n")
      setPlatforms(JVM)
    }
    link {
      github = "formation-res/fluent-kotlin"
      desc = "Kotlin multi platdform localization for js and jvm based on project fluent."
      setTags("localization", "mozilla-fluent")
      setPlatforms(JVM, JS)
    }
  }
  subcategory("Logging") {
    link {
      github = "ivangarzab/barK"
      desc = "Kotlin multiplatform logging library with automatic tag detection and test run support"
      setPlatforms(ANDROID, NATIVE, IOS, COMMON)
      setTags("logging", "multiplatform", "android", "testing")
    }
    link {
      github = "LighthouseGames/KmLogging"
      desc = "Kotlin multiplatform logging. High performance, composable and simple to use."
      setPlatforms(ANDROID, NATIVE, IOS, COMMON, JVM, JS)
      setTags("logging", "multiplatform")
    }
    link {
      github = "Foso/Cabret-Log"
      desc = "Method call logging for Kotlin Multiplatform"
      setPlatforms(JVM, JS, ANDROID, NATIVE, IOS, COMMON)
    }
    link {
      github = "InsanusMokrassar/KSLog"
      desc = "Simple Kotlin Logging"
      setPlatforms(ANDROID, NATIVE, COMMON, JVM, JS)
      setTags("logging", "multiplatform")
    }
  }
  subcategory("Mail") {
    link {
      github = "bluefireoly/SimpleKotlinMail"
      desc = "A simple, modern and coroutine based Kotlin Email API, supporting both clientside and serverside projects."
      setTags("mail", "smtp", "email", "mailserver")
      setPlatforms(JVM)
    }
  }
  subcategory("Blockchain") {
    link {
      github = "sol4k/sol4k"
      desc = "A Kotlin client for Solana that allows building and sending transactions, reading data from the blockchain, performing operations with public and private keys, and more."
      href = "https://sol4k.org"
      setPlatforms(JVM, ANDROID, COMMON)
      setTags("blockchain", "solana", "web3", "rpc-client")
    }
  }
  subcategory("Jetpack-Compose"){
    link{
      github = "CuriousNikhil/neumorphic-compose"
      desc = "Neumorphism UI on Android with Jetpack Compose. Just add one modifier = Modifier.neumorphic()"
      setTags("jetpack-compose", "compose", "kotlin", "ui")
      setPlatforms(ANDROID)
    }

    link{
      github = "CuriousNikhil/compose-particle-system"
      desc = "A lightweight particle system for Jetpack Compose - Quarks"
      setTags("jetpack-compose", "compose", "kotlin", "ui")
      setPlatforms(ANDROID)
    }
    link{
      github = "CuriousNikhil/k5-compose"
      desc = "K5-compose is a sketchy port of p5.js for Jetpack Compose Desktop"
      setTags("jetpack-compose", "compose", "kotlin", "ui", "compose-desktop")
      setPlatforms(NATIVE, JVM)
    }
    link{
      github = "Canopas/Intro-showcase-view"
      desc = "An android library to highlight different features of the app built using Jetpack Compose."
      setTags("jetpack-compose", "compose", "kotlin", "jetpack-android", "android")
      setPlatforms(ANDROID)
    }
    link{
      github = "mahozad/wavy-slider"
      desc = "Multiplatform UI widget that recreates the Android 13 squiggly progress bar"
      setTags("jetpack-compose", "compose", "kotlin", "compose-desktop", "ui")
      setPlatforms(JVM, ANDROID, JS)
    }
    link {
      github = "huanshankeji/compose-multiplatform-html-unified"
      desc = "Unified Compose Multiplatform wrappers of common and Material Design APIs for rendering-based Compose UI and DOM-based Compose HTML"
      setTags("Compose Multiplatform", "Compose UI", "Compose HTML", "compose", "compose-desktop", "ui", "Material Design", "Material", "Material 2", "Material 3", "Material Web", "Kobweb")
      setPlatforms(COMMON, ANDROID, JVM, IOS, WASM, JS)
    }
    link {
      github = "huanshankeji/compose-html-material"
      desc = "Compose HTML Material 3 wrapper components based on Material Web"
      setTags("Compose HTML", "Material Design", "Material", "Material 3", "Material Web", "Web Components")
      setPlatforms(JS)
    }
    link {
      github = "jocoand/compose-showcase"
      desc = "A Jetpack Compose library for highlighting / showcasing your feature"
      setTags("jetpack-compose", "compose", "kotlin", "ui")
      setPlatforms(ANDROID)
    }
    link {
      github = "kronos-orm/kronos-orm"
      desc = "A modern ORM framework designed for Kotlin based on the compiler plugin, which is suitable for both backend and mobile applications, support multi-database. Powerful, high performance, easy to use."
      setTags("ORM", "compiler-plugin", "dsl", "jdbc", "logging", "codegen", "ktor", "spring", "android")
      setPlatforms(JVM, ANDROID)
    }
  }
}
