category("Links") {
  subcategory("Official Links") {
    link {
      github = "JetBrains/kotlin"
      setTags("kotlin")
      awesome()
    }
    link {
      name = "Home Page"
      href = "https://kotlinlang.org/"
      awesome()
    }
    link {
      name = "Language Reference"
      href = "https://kotlinlang.org/docs/reference/"
    }
    link {
      name = "Slack (38k+ users)"
      href = "https://slack.kotlinlang.org/"
      awesome()
    }
    link {
      name = "Try Kotlin!"
      href = "https://try.kotlinlang.org/"
    }
    link {
      name = "Blog"
      href = "https://blog.jetbrains.com/kotlin/"
    }
    link {
      name = "Issue Tracker"
      href = "https://youtrack.jetbrains.com/issues/KT"
    }
    link {
      name = "Twitter"
      href = "https://twitter.com/kotlin"
    }
    link {
      github = "Kotlin/KEEP"
      desc = "Kotlin Evolution and Enhancement Process"
      setTags("keep", "async", "await")
    }
    link {
      name = "Kotlin Forum"
      href = "https://discuss.kotlinlang.org/"
    }
  }
  subcategory("Resources") {
    link {
      name = "Awesome Kotlin Jobs"
      desc = "A curated list of companies using Kotlin"
      href = "https://github.com/vinigmoraes/awesome-kotlin-jobs"
    }
    link {
      name = "Jobs for Kotlin Developers"
      desc = "All job listings require Kotlin skills"
      href = "https://kotlin-jobs.com/"
    }
    link {
      name = "Podcast: Talking Kotlin"
      desc = "A Podcast on Kotlin and more"
      href = "https://talkingkotlin.com/"
      awesome()
    }
    link {
      name = "Kotlin Subreddit"
      href = "https://www.reddit.com/r/Kotlin/"
    }
    link {
      name = "Trending Kotlin on Github"
      href = "https://github.com/trending?l=kotlin"
    }
    link {
      name = "Programming Community Curated Resources for learning Kotlin"
      href = "https://hackr.io/tutorials/learn-kotlin"
    }
    link {
      name = "LinkedIn: Kotlin Developers (Join!)"
      href = "https://www.linkedin.com/groups/7417237/profile"
    }
    link {
      github = "fabiomsr/from-java-to-kotlin"
      name = "From Java To Kotlin"
      href = "https://github.com/fabiomsr/from-java-to-kotlin"
    }
    link {
      github = "dbacinski/Design-Patterns-In-Kotlin"
      setTags("Behavioral Patterns", "Creational Patterns", "Structural Patterns")
    }
    link {
      name = "Kotlin Cheat Sheet"
      href = "https://speakerdeck.com/agiuliani/kotlin-cheat-sheet"
    }
    link {
      name = "Kotlin Kōans Android app"
      desc = "Learn Kotlin with short coding challenges on your Android device"
      href = "https://play.google.com/store/apps/details?id=me.vickychijwani.kotlinkoans"
    }
    link {
      name = "Kotlin Guide"
      desc = "An introduction to Kotlin"
      href = "https://kotlin.guide"
    }
    link {
      name = "Kotlin Quiz"
      desc = "Are You a Kotlin Expert? Test Your Skills with the Kotlin Quiz!"
      href = "https://kotlinquiz.com"
    }
    link {
      github = "AlexeySoshin/Hands-on-Design-Patterns-with-Kotlin"
      desc = "Code examples for 'Hands-on Design Patterns with Kotlin' book"
      setTags("GoF", "concurrency")
    }
    link {
      github = "tbhaxor/GUIDE-TO-KOTLIN"
      desc = "A practical guide on Kotlin for Developers"
    }
    link {
      name = "Kotlin syntax cheat sheet"
      href = "https://blog.kotlin-academy.com/kotlin-cheat-sheet-1137588c75a"
    }
    link {
      name = "Kotlin Standard Functions cheat-sheet "
      desc = "Learn how to use kotlin's standard library with lambda functions"
      href = "https://medium.com/androiddevelopers/kotlin-standard-functions-cheat-sheet-27f032dd4326"
    }
    link {
      name = "Kotlin: An Illustrated Guide"
      desc = "Illustrated guide to learn Kotlin"
      href = "https://typealias.com/start/"
    }
  }
  subcategory("Blogs") {
    link {
      name = "Antonio Leiva - Android and any other monsters"
      href = "https://antonioleiva.com/"
    }
    link {
      name = "freecodecamp Kotlin article collection"
      href = "https://www.freecodecamp.org/news/tag/kotlin/"
    }
    link {
      name = "Kotlin Expertise Blog"
      desc = "A Blog with many articles covering basic and advanced Kotlin topics."
      href = "https://kotlinexpertise.com/"
    }
    link {
      name = "SuperKotlin"
      desc = "A website about Kotlin"
      href = "https://superkotlin.com"
      setTags("blog", "articles", "tutorials", "interviews")
    }
    link {
      name = "Kt. Academy Medium"
      desc = "Blog that teach about Kotlin"
      href = "https://blog.kotlin-academy.com/"
    }
    link {
      name = "Kt. Academy"
      desc = "Publication with regular Kotlin posts."
      href = "https://kt.academy/article"
    }
    link {
      name = "KotlinTesting Blog"
      desc = "Blog about testing with Kotlin"
      href = "https://kotlintesting.com"
      setTags("resources", "testing")
    }
  }
  subcategory("Courses") {
    link {
      name = "Jetbrain's Hyperskill Academy"
      desc = "An interactive learning platform for Kotlin and other languages"
      href = "https://hyperskill.org/onboarding/tracks/3"
      awesome()
    }
    link {
      name = "Google's Kotlin Codelab "
      desc = "Build your first Kotlin Android App"
      href = "https://codelabs.developers.google.com/codelabs/build-your-first-android-app-kotlin/"
      awesome()
    }
    link {
      name = "Android Kotlin Fundamentals"
      href = "https://codelabs.developers.google.com/android-kotlin-fundamentals"
      desc = "Android Kotlin Fundamentals leads you through a series of codelabs that teach you the fundamentals of building Android apps in Kotlin."
      awesome()
    }
    link {
      name = "Kotlin for Java Developers"
      desc = "160-minute Android Course."
      href = "https://teamtreehouse.com/library/kotlin-for-java-developers"
    }
    link {
      name = "Kotlin Programming: Next Level Java Development"
      desc = "Learn coding in Kotlin from scratch!"
      href = "https://www.udemy.com/kotlin-course/"
    }
    link {
      name = "Introduction to Kotlin Programming by Hadi Hariri"
      desc = "From Hello World to Interoperability with Java"
      href = "https://shop.oreilly.com/product/0636920052982.do"
      awesome()
    }
    link {
      name = "Advanced Kotlin Programming"
      desc = "From Nested Functions to Asynchronous Programming"
      href = "https://shop.oreilly.com/product/0636920052999.do"
      awesome()
    }
    link {
      name = "Kotlin an Introduction - Caster.io"
      desc = "Kotlin introductory course at Caster.io"
      href = "https://caster.io/courses/introduction-to-kotlin/"
    }
    link {
      name = "Building Android Apps with Kotlin: Getting Started - Alex Dunn"
      desc = "Dive into the language set to replace Java while building Android applications. This course will give you a foundation of both Kotlin and Android skills to allow you to build apps faster and cleaner than ever before."
      href = "https://www.pluralsight.com/courses/building-android-apps-kotlin-getting-started"
    }
    link {
      name = "Kotlin Bootcamp for Programmers - Google"
      desc = "Language fundamentals for developers"
      href = "https://www.udacity.com/course/kotlin-bootcamp-for-programmers--ud9011"
    }
    link {
      name = "Developing Android Apps with Kotlin - Google"
      desc = "Create concise, secure and performant apps with Kotlin"
      href = "https://www.udacity.com/course/developing-android-apps-with-kotlin--ud9012"
    }
    link {
      name = "Kotlin for Android Developers"
      desc = "Convert an Android app from Java to Kotlin"
      href = "https://www.udacity.com/course/kotlin-for-android-developers--ud888"
    }
    link {
      name = "Kotlin for Java Developers - JetBrains"
      desc = "Detailed Kotlin introductory course for Java developers"
      href = "https://www.coursera.org/learn/kotlin-for-java-developers"
      awesome()
    }
    link {
      name = "Kotlin Online Courses at Classpert"
      desc = "Over 80 Kotlin Online Courses - Classpert Online Course and MOOC Search"
      href = "https://classpert.com/kotlin-programming"
    }
    link {
      name = "Test-Driven Development Tutorial for Android: Getting Started - By Victoria Gonda"
      desc = "Learn the basics of test-driven development, or TDD, and discover how to use TDD effectively when developing your Android apps!"
      href = "https://www.raywenderlich.com/7109-test-driven-development-tutorial-for-android-getting-started"
    }
    link {
      name = "Kotlin Course - Tutorial for Beginners by freeCodeCamp.org"
      href = "https://youtu.be/F9UC9DY-vIU"
      desc = "Learn the Kotlin programming language in this introduction to Kotlin. Kotlin is a general purpose, open source, statically typed “pragmatic” programming language. It is used for many things, including Android development."
    }
    link {
      name = "CS194A Android Development"
      href = "https://www.youtube.com/playlist?list=PL7NYbSE8uaBDcLkbXsQADdvBnVbavonGn"
      desc = "Learn basic, foundational techniques for developing Android mobile applications and apply those toward building a single or multi page, networked Android application"
    }
    link {
      name = "Server-side with Kotlin Series"
      href = "https://www.youtube.com/playlist?list=PLlFc5cFwUnmx-dpq9nkdaVJX0GnrM1Mp1"
      desc = "Learn how to use Kotlin for a variety of purposes such as Functional Programming, Image Detection, Building Microservices, Developing Backend, etc."
    }
    link {
      name = "Programming Fundamentals in Kotlin"
      href = "https://www.coursera.org/learn/meta-programming-fundamentals-kotlin"
      desc = "Practice and expand on the fundamentals of programming that are core to any language as well as the unique aspects of Kotlin syntax."
    }
    link {
      name = "Advanced Programming in Kotlin"
      href = "https://www.coursera.org/learn/advanced-programming-in-kotlin"
      desc = "Get ready to expand on your Kotlin skills to create common advanced functionality that typical Android apps need."
    }
  }
  subcategory("Books") {
    link {
      name = "Kotlin in Action - Dmitry Jemerov, Svetlana Isakova"
      href = "https://manning.com/books/kotlin-in-action"
      awesome()
    }
    link {
      name = "Kotlin in Action, Second Edition"
      href = "https://www.manning.com/books/kotlin-in-action-second-edition"
      awesome()
    }
    link {
      name = "Kotlin for Android Developers - Antonio Leiva"
      href = "https://leanpub.com/kotlin-for-android-developers"
      awesome()
    }
    link {
      name = "Functional Programming in Kotlin - Marco Vermeulen, Rúnar Bjarnason, and Paul Chiusano"
      href = "https://www.manning.com/books/functional-programming-in-kotlin"
    }
    link {
      name = "Programming Kotlin - Stephen Samuel, Stefan Bocutiu"
      href = "https://www.packtpub.com/application-development/programming-kotlin"
    }
    link {
      name = "Fundamental Kotlin, First Edition"
      desc = "Learn Kotlin quickly from the start"
      href = "http://www.fundamental-kotlin.com/"
    }
    link {
      name = "Android Development with Kotlin - Marcin Moskala, Igor Wojda"
      desc = "Learn how to make Android development much faster using a variety of Kotlin features, from basics to advanced, to write better quality code"
      href = "https://www.packtpub.com/application-development/android-development-kotlin"
    }
    link {
      name = "Mastering Android Development with Kotlin - Miloš Vasić"
      desc = "Master Android development using a variety of Kotlin features"
      href = "https://www.packtpub.com/application-development/mastering-android-development-kotlin"
    }
    link {
      name = "Functional Kotlin"
      desc = "Learn Functional Programming in Kotlin from scratch and how to apply Functional Programming with Kotlin to real-life projects with popular libraries like Arrow. By Mario Arias, Rivu Chakraborty"
      href = "https://www.packtpub.com/application-development/functional-kotlin"
    }
    link {
      name = "Reactive Programming in Kotlin - Rivu Chakraborty"
      desc = "Learn how to implement Reactive Programming paradigms with Kotlin, and apply them to Web programming with Spring Framework 5.0 as well as in Android Application Development. By Rivu Chakraborty"
      href = "https://www.packtpub.com/application-development/reactive-programming-kotlin"
    }
    link {
      name = "Kotlin Apprentice - Irina Galata, Joe Howard, Richard Lucas & Ellen Shapiro"
      desc = "Beginning programming with Kotlin"
      href = "https://store.raywenderlich.com/products/kotlin-apprentice"
    }
    link {
      name = "Android Apprentice - Darryl Bayliss & Tom Blankenship"
      desc = "Beginning Android programming using Kotlin"
      href = "https://store.raywenderlich.com/products/android-apprentice"
    }
    link {
      name = "Hands-on Design Patterns with Kotlin - Alexey Soshin"
      desc = "Book that covers building scalable applications using traditional, reactive, and concurrent design patterns in Kotlin"
      href = "https://www.amazon.com/Hands-Design-Patterns-Kotlin-applications/dp/1788998014"
    }
    link {
      name = "Advanced Android App Architecture"
      desc = "In Advanced Android App Architectures, you'll find a diverse and hands-on approach to architecting your apps on Android"
      href = "https://store.raywenderlich.com/products/advanced-android-app-architecture"
    }
    link {
      name = "Data Structures & Algorithms in Kotlin - Irina Galata & Matei Suica"
      desc = "A book that teaches you the fundamental tools of implementing key data structures in Kotlin, and how to use them to solve algorithms"
      href = "https://store.raywenderlich.com/products/data-structures-and-algorithms-in-kotlin"
    }
    link {
      name = "Effective Kotlin"
      href = "https://kt.academy/book/effectivekotlin"
    }
    link {
      name = "Head First Kotlin"
      desc = "Head First Kotlin is a complete introduction to coding in Kotlin"
      href = "https://www.oreilly.com/library/view/head-first-kotlin/9781491996683/"
      awesome()
    }
    link {
      name = "Kotlin Coroutines: Deep Dive"
      desc = "A practical book dedicated to Kotlin Coroutines, common use-cases, best practices and deep understanding."
      href = "https://kt.academy/book/coroutines"
    }
    link {
      name = "Kotlin Crash Course"
      desc = "Quickly master Kotlin by practicing what you learn in eight interactive projects, including REST APIs, serverless deployments, and more."
      href = "https://www.amazon.com/dp/9355516304"
    }
  }
}
