category("Projects") {
  subcategory("Web") {
    link {
      github = "jillesvangurp/rankquest-studio"
      desc = "Rankquest Studio is a web based tool that you can use to benchmark search query metrics for your search APIs. Written in Kotlin & Fritz2"
      setTags("search-ranking","application","kotlin-js","fritz2")
    }
    link {
      github = "sdeleuze/spring-boot-kotlin-demo"
      desc = "Basic Spring Boot app in Kotlin."
      setTags("spring", "spring-boot")
    }
    link {
      github = "IRus/kotlin-dev-proxy"
      desc = "Simple server for proxy requests and host static files written in Kotlin, Spark Java and Apache HttpClient."
      setTags("rest", "web")
    }
    link {
      github = "ratpack/example-ratpack-gradle-kotlin-app"
      desc = "An example of a Kotlin Ratpack app built with Gradle."
      setTags("ratpack", "gradle", "rest", "web")
    }
    link {
      github = "mariomac/codebuilder"
      desc = "Demo app about asynchronous architectures for long-response-time web applications."
      setTags("vertx.io", "async", "example")
    }
    link {
      github = "cbedoy/DYUM"
      desc = "Basic Kotlin Implementation following MVP, and using Third Party library by Natural Analytics Language"
      setTags("natural language", "third_party", "mvp", "demo", "basic kotlin", "retrofit")
    }
    link {
      github = "eddywm/KTFLITE"
      desc = "Computer Vision on Android with Kotlin and Tensorflow Lite."
      setTags("tensorflow", "deep-learning", "computer-vision", "android", "machine-learning")
    }
    link {
      github = "rocketraman/kotlin-web-hello-world"
      desc = "This project shows how to do a web-based \"Hello World!\" with Kotlin in combination with various JVM -" +
        " based web frameworks."
      setTags("spark java", "vertx", "wasabi", "ktor", "akka", "example")
    }
    link {
      github = "FirstArtaxer/karbitrage"
      desc = "Kotlin-based project designed to extract cryptocurrency prices from various exchanges using the Ktor framework."
      setTags("ktor", "cryptocurrency", "web", "exposed", "kotlin", "coroutines", "koin", "reflection")
    }
    link {
      github = "ivanpopelyshev/vertx-facebook-messenger"
      desc = "Seed project for facebook messenger bots. Vertx, Kotlin."
      setTags("chat bot", "vert.x", "facebook")
    }
    link {
      github = "corda/corda"
      desc = "Corda is a distributed ledger platform designed to record, manage and automate legal agreements between business partners. "
      setTags("p2p", "blockchain")
    }
    link {
      github = "spolnik/JAlgoArena"
      desc = "JAlgoArena is a highly scalable programming contest platform which you can host on own infrastructure. It allows to define new problems and solve them in Kotlin and Java."
      setTags("programming", "contest")
    }
    link {
      github = "mixitconf/mixit"
      desc = "MiXiT website"
      setTags("web", "gradle", "spring")
    }
    link {
      github = "derveloper/kiny"
      desc = "Your super simple private serverless service running your kotlin functions like AWS lambda."
      setTags("serverless", "lambda")
    }
    link {
      github = "ssouris/petclinic-spring5-reactive"
      desc = "Spring 5 Reactive Petclinic app written in Kotlin."
      setTags("spring", "reactive", "web")
    }
    link {
      github = "yyunikov/spring-boot-2-kotlin-starter"
      desc = "Spring Boot 2.0 Kotlin application starter with configurations for Gradle, Mongo, JUnit 5 tests, logging, CircleCI and Docker compose."
      setTags("spring", "gradle", "reactive", "web", "spring-boot", "docker", "junit-test")
    }
    link {
      github = "viniciusccarvalho/kodein-cloud-functions"
      desc = "Provides adapters to different cloud functions providers (AWS, Azure) to run vanilla kotlin functions defined as kodein modules"
      setTags("kodein", "cloud", "serverless")
    }
    link {
      github = "MichaelGrigoryan25/kotlin-url-shortener"
      desc = "Basic URL shortener built with Kotlin, Redis and Javalin"
      setTags("javalin", "url-shortener", "redis", "web", "gradle", "kotlin")
    }
    link {
      github = "Ahoo-Wang/CoSky"
      desc = "High-performance, low-cost microservice governance platform. Service Discovery and Configuration Service"
      setTags("microservice", "service-discovery", "configuration-service", "service-registry", "redis", "kotlin")
    }
    link {
      github = "kuvasz-uptime/kuvasz"
      desc = "Kuvasz is an open-source, self-hosted uptime & SSL monitoring service, built with Kotlin."
      setTags("monitoring", "uptime", "ssl", "devops", "cloud-native")
    }
    link {
      github = "gemy411/multi-agents-research"
      desc = "A KTOR server/MCP server written in Kotlin applying multi-agents schools in a flexible research system"
      setTags("ktor", "mcp", "agents", "research", "server")
    }
  }
  subcategory("Build tools") {
    link {
      github = "cbeust/kobalt"
      desc = "Build system inspired by Gradle."
    }
    link {
      github = "gradle/kotlin-dsl-samples"
      desc = "Kotlin language support for Gradle build scripts."
      setTags("gradle", "build")
    }
    link {
      github = "nebula-plugins/nebula-kotlin-plugin"
      desc = "Provides the Kotlin plugin via the Gradle plugin portal, automatically depends on the standard library, and allows Kotlin library versions to be omitted."
      setTags("gradle", "build")
    }
    link {
      github = "pubref/rules_kotlin"
      desc = "Bazel rules for Kotlin."
      setTags("bazel", "build")
    }
  }
  subcategory("Misc") {
    link {
      github = "quicktype/quicktype"
      desc = "Generate Kotlin types and converters from JSON, Schema, TypeScript, and GraphQL"
      setTags("json", "api", "web")
    }
    link {
      github = "lice-lang/lice"
      desc = "A Lisp-like language's interpreter written in Kotlin"
      setTags("lisp", "interpreter")
    }
    link {
      github = "sureshg/InstallCerts"
      desc = "Create a PKCS12 TrustStore by retrieving server certificates."
      setTags("certificate", "crypto")
    }
    link {
      github = "vicboma1/GameBoyEmulatorEnvironment"
      desc = "Front-End developed with Kotlin Experimental for my GameBoy Emulator (coroutines)."
      setTags("GameBoy", "Emulator", "frontend", "kotlin", "experimental")
    }
    link {
      github = "borisf/classyshark-bytecode-viewer"
      desc = "View your Kotlin generated classes as Java and bytecode format."
      setTags("bytecode", "decompiler")
    }
    link {
      github = "jenkinsci/doktor-plugin"
      desc = "Jenkins plugin for automated documentation uploading to Confluence."
      setTags("jenkins", "documentation", "confluence")
    }
    link {
      github = "mkobit/jenkins-pipeline-shared-libraries-gradle-plugin"
      desc = "Gradle plugin to help with build and test of Jenkins Pipeline Shared Libraries."
      setTags("jenkins", "gradle")
    }
    link {
      github = "kpspemu/kpspemu"
      desc = "Multiplatform (JS and JVM) PSP Emulator written in Kotlin."
      setTags("Emulator", "Kotlin/JS", "Kotlin/JVM")
    }
    link {
      github = "sourcerer-io/sourcerer-app"
      desc = "Visual profile for software engineers written in Kotlin."
      setTags("code analysis", "visualization", "resume", "profile")
    }
    link {
      github = "chrislo27/RhythmHeavenRemixEditor"
      desc = "An audio custom remix editor designed for the Rhythm Heaven series, using libGDX and Kotlin."
      setTags("libgdx", "Rhythm Heaven", "custom remix")
    }
    link {
      github = "Poweranimal/PowerCollections"
      desc = "Powerfull Collections, Sets, Lists and Maps."
      setTags("collections", "maps", "lists", "sets", "weakreference", "observable", "bounded")
    }
    link {
      github = "neworld/gradle-jdeploy-plugin"
      desc = "Gradle plugin to publish JVM applications via npmjs.com"
      setTags("gradle", "publish", "npm")
    }
    link {
      github = "ruslanys/telegraff"
      desc = "Kotlin DSL for Telegram Bots creation."
      href = "https://github.com/ruslanys/telegraff"
      setTags("telegram", "bot", "dsl", "telegraff")
    }
    link {
      github = "krzema12/fsynth"
      desc = "Music synthesizer as a Kotlin multiplatform project"
      href = "https://github.com/krzema12/fsynth"
      setTags("music", "functional-programming", "multiplatform")
    }
    link {
      github = "AngryJKirk/familybot"
      desc = "Telegram bot to have some fun with your buddies"
      setTags("telegram")
    }
    link {
      github = "madhead/tyzenhaus"
      desc = "Shared expenses tracking Telegram bot"
      setTags("telegram")
    }
  }
  subcategory("Desktop") {
    link {
      github = "ice1000/Dekoder"
      desc = " A kotlin music player, materially designed."
      setTags("JavaFX", "Desktop", "Player")
    }
    link {
      github = "ice1000/dev-kt"
      desc = "DevC++-like cross-platform Kotlin IDE."
      setTags("IDE", "swing")
    }
    link {
      github = "ruslanys/vkmusic"
      desc = "JavaFX and Spring-Boot based application for grabbing music from VK.com."
      setTags("javafx", "spring", "spring-boot")
    }
    link {
      github = "datalisk/datalisk"
      desc = "A file sync and storage application with end-to-end encryption and multi-platform support."
      setTags("filesync", "end-to-end-encryption", "dropbox", "storage")
    }
    link {
      github = "yschimke/okurl"
      desc = "cURL-like client based on OkHttp."
      setTags("cli", "http", "scripting")
    }
    link {
      github = "hazae41/Kotlin-Compiler-GUI"
      desc = "Easily compile Kotlin classes (.kt) and run Kotlin scripts (.kts)"
      setTags("compiler", "gui", "scripts", "desktop")
    }
    link {
      github = "pintowar/sudoscan"
      desc = "Scans and solves Sudoku Puzzles from images using AI"
      setTags("artificial-intelligence", "machine-learning", "open-cv", "csp", "cli")
    }
    link {
      github = "russellbanks/HashHash"
      desc = "A Multiplatform GUI for Hashing, written in Compose for Desktop."
      setTags("hashing", "compose-for-desktop")
    }
    link {
      github = "krud-dev/ostara"
      desc = "A desktop application that provides various features to monitor and interact with Spring Boot Applications via Actuator."
      setTags("spring", "spring-boot", "spring-actuator")
    }
  }
  subcategory("Examples") {
    link {
      github = "Kotlin/kotlin-koans"
      desc = "Kotlin Koans are a series of exercises to get you familiar with the Kotlin Syntax."
      setTags("koans")
    }
    link {
      github = "JetBrains/kotlin-examples"
      desc = "Various examples for Kotlin."
      setTags("maven", "gradle", "android", "realm", "buttetknife", "dagger", "dbflow", "junit-test", "dokka")
    }
    link {
      github = "JetBrains/swot"
      desc = "Identify email addresses or domains names that belong to colleges or universities. Help automate the process of approving or rejecting academic discounts."
    }
    link {
      github = "robfletcher/midcentury-ipsum"
      desc = "Swingin’ filler text for your jet-age web page."
      setTags("ratpack")
    }
    link {
      github = "som-one/zarif-kherkin"
      desc = "Configurable BDD testing using a Kotlin DSL for Gherkin."
      setTags("bdd", "gherkin", "dsl", "test")
    }
    link {
      github = "robfletcher/lazybones-kotlin"
      desc = "The Lazybones app migrated to Kotlin as a learning exercise."
      setTags("ratpack")
    }
    link {
      github = "wangjiegulu/KotlinAndroidSample"
      desc = "Android sample with kotlin."
      setTags("android", "sample")
    }
    link {
      github = "dodyg/Kotlin101"
      desc = "101 examples for Kotlin Programming language."
      setTags("examples")
    }
    link {
      github = "dkandalov/kotlin-99"
      desc = "Solve 99 problems with Kotlin!"
      setTags("examples", "study")
    }
    link {
      github = "dkandalov/rosettacode-kotlin"
      desc = "Repository with source code from [RosettaCode](https://rosettacode.org/)"
      setTags("examples", "study")
    }
    link {
      github = "vicboma1/Kotlin-Koans"
      desc = "hese are the simple solutions of the kotlin koans online with intellij project."
      setTags("examples")
    }
    link {
      github = "vicboma1/GettingStartedKotlin"
      desc = "Learn the basics of getting started with kotlin."
      setTags("examples")
    }
    link {
      github = "vicboma1/Kotlin-Examples-Problems"
      desc = "These are the simple solutions of the kotlin example problems online."
      setTags("examples")
    }
    link {
      github = "pakoito/FunctionalAndroidReference"
      desc = "A different Android app showcasing Functional Reactive Programming."
      setTags("android", "examples", "functional")
    }
    link {
      github = "bmaslakov/kotlin-algorithm-club"
      desc = "Classic algorithms and data structures in Kotlin."
      setTags("examples")
    }
    link {
      github = "gyulavoros/kotlin-todomvc"
      desc = "Kotlin TodoMVC – full-stack Kotlin application demo"
      setTags("examples", "javascript", "web", "gradle", "todomvc")
    }
    link {
      github = "mkraynov/todomvc-react-kotlin"
      desc = "React Kotlin TodoMVC – example based on create-react-kotlin-app and todomvc-react"
      setTags("examples", "javascript", "web", "react", "todomvc")
    }
    link {
      github = "IvanMwiruki/30-seconds-of-kotlin"
      desc = "Useful Kotlin snippets you can understand quickly, using only the stdlib."
      setTags("examples", "snippets", "sample", "study", "functional")
    }
    link {
      github = "xurxodev/integration-testing-kotlin-multiplatform-kata"
      desc = "A full exercise to learn how to use stubbing HTTP in Kotlin multiplatform using Ktor and Ktor Client Mock."
      setTags("examples", "kotlin-multiplatform", "testing", "stubbing-http", "Ktor", "ktor-client-mock")
    }
    link {
      github = "TobseF/Candy-Crush-Clone"
      desc = "A Kotlin Multiplatform match 3 sample game build to teach, made with KorGE."
      setTags("examples", "kotlin-multiplatform", "KorGE", "game", "native", "tutorial")
      setPlatforms(ANDROID, COMMON, IOS, JS, JVM, NATIVE)
    }
    link {
      github = "mrcsxsiq/Kotlin-Pokedex"
      desc = "A Pokedex demo app built with Kotlin using ViewModel, LiveData, Room and Navigation"
    }
    link {
      github = "LukasLechnerDev/Kotlin-Coroutine-Use-Cases-on-Android"
      desc = "Learn Kotlin Coroutines for Android by example. Sample implementations for real-world Android use cases. Unit tests included."
    }
    link {
      github = "rozkminiacz/KotlinUnitTesting"
      desc = "Kotlin Unit Testing Examples."
      setTags("unit-test", "junit4", "junit5", "kotlintest", "spek", "mockito", "mockk", "strikt")
    }
    link {
      github="itmaginationdemos/KMM-Sample-App"
      desc="A sample app written with the help of KMM (Kotlin Multiplatform). File System access, voice recording, and persistence."
      setTags("example", "kmm", "compose")
      setPlatforms(ANDROID, IOS)
    }
    link {
      github="formation-res/kt-fullstack-demo"
      desc="This demo kotlin-js project implements a UI and server for a little recipe search engine to demonstrate fritz2, kotlin-js, localization with mozilla fluent, use of koin in a webapp."
      setPlatforms(JS)
      setTags("fritz2","fluent-kotlin","koin","kotlin-js","webui","examples")
    }
  }
  subcategory("Idea Plugins") {
    link {
      github = "Vektah/CodeGlance"
      desc = "Intelij IDEA plugin for displaying a code mini-map similar to the one found in Sublime."
      setTags("idea", "plugin")
    }
    link {
      github = "intellij-rust/intellij-rust"
      desc = "Rust IDE built using the IntelliJ Platform."
      setTags("idea", "plugin", "rust")
    }
    link {
      github = "dkandalov/activity-tracker"
      desc = "Plugin for IntelliJ IDEs to track and record user activity."
      setTags("idea", "plugin")
    }
    link {
      github = "dkandalov/limited-wip"
      desc = "Plugin to limit your work-in-progress."
      setTags("idea", "plugin")
    }
    link {
      github = "dkandalov/pomodoro-tm"
      desc = "Pomodoro timer."
      setTags("idea", "plugin")
    }
    link {
      github = "izhangzhihao/intellij-rainbow-brackets"
      desc = "Rainbow Brackets / Rainbow Parentheses for IntelliJ IDEA based IDEs."
      setTags("idea", "plugin")
    }
    link {
      github = "roger-yh99/Readhub"
      desc = "[Readhub](https://plugins.jetbrains.com/plugin/10539-readhub) is a News Reader plugin for IntelliJ IDEs"
      setTags("idea", "plugin")
    }
    link {
      github = "roger-yh99/AwesomeKotlinPlugin"
      desc = "[AwesomeKotlin](https://plugins.jetbrains.com/plugin/11357-awesome-kotlin) plugin for IntelliJ IDEs"
      setTags("idea", "plugin")
    }
    link {
      github = "emedinaa/kotlin-mvvm"
      desc = "MVVM(Model View ViewModel) sample in Kotlin using the components ViewModel, LiveData and Retrofit library"
      setTags("android", "examples", "mvvm", "kotlin")
    }
    link {
      github = "emedinaa/kotlin-mvp-volley"
      desc = "Example of Android project in Kotlin using MVP(Model View Presenter) pattern and volley library"
      setTags("android", "examples", "mvp", "kotlin", "volley")
    }
    link {
      github = "emedinaa/android-recyclerview"
      desc = "Some samples about the RecyclerView and Adapters using kotlin"
      setTags("android", "examples", "recyclerview", "kotlin", "adapter")
    }
    link {
      github = "emedinaa/kotlin-viewmodel"
      desc = "Basic samples about ViewModel component"
      setTags("android", "examples", "viewmodel", "kotlin", "livedata")
    }
    link {
      github = "wuseal/JsonToKotlinClass"
      desc = "Plugin for IntelliJ IDEs to generate Kotlin data class code from JSON text"
      setTags("json", "idea")
    }
    link {
      github = "csense-oss/idea-kotlin-checked-exceptions"
      desc = "Plugin to help integrate with java and exceptions (highlights, warns when not catching exceptions and a lot more)"
      setTags("kotlin", "idea", "exceptions")
    }
  }
  subcategory("Playground") {
    link {
      github = "LouisCAD/kotlin-libraries-playground"
      setPlatforms(JVM)
    }
  }
  subcategory("Android") {
    link {
      github = "skydoves/themovies"
      desc = "A simple project for The Movie DB based on Kotlin MVVM clean architecture and material design & animations."
      setTags("mvvm", "material-design", "dagger2", "tdd")
    }
    link {
      github = "skydoves/githubfollows"
      desc = "A demo project based on MVVM architecture and material design & animations."
      setTags("mvvm", "material-design", "material-animations", "dagger2", "room-persistence", "preferenceroom", "github-api", "retrofit", "repository-pattern")
    }
    link {
      github = "enricocid/Music-Player-GO"
      href = "https://play.google.com/store/apps/details?id=com.iven.musicplayergo"
      desc = "Simple yet fully-featured local music player aiming at simplicity and performance."
      setPlatforms(ANDROID)
      setTags("music-player", "material-design", "media-player")
    }
    link {
      github = "deva666/NewsReader"
      desc = "Android app for reading news"
      setPlatforms(ANDROID)
      setTags("android", "coroutines", "rxJava")
    }
    link {
      github = "TonnyL/Mango"
      desc = "An Android app for dribbble.com"
      setPlatforms(ANDROID)
      setTags("Android", "Dribbble")
    }
    link {
      github = "SimonSchubert/LinuxCommandBibliotheca"
      desc = "Android app which provides a bunch of useful Linux commands."
      setPlatforms(ANDROID)
      setTags("android", "project")
    }
    link {
      github = "SimonSchubert/NewsOut"
      desc = "Android and iOS mobile client for Nextcloud News app"
      setPlatforms(ANDROID, IOS, COMMON)
      setTags("multiplatform", "android", "ios", "project")
    }
    link {
      github = "pranayairan/CoinBit"
      desc = "CoinBit is completely free Bitcoin & cryptocurrency portfolio tracker app. It helps you over 4000+ cryptocurrencies on 150+ platforms including Binance, GDAX, Kraken etc"
      setPlatforms(ANDROID)
      setTags("cryptocurrency", "kotlin", "android", "app")
    }
    link {
      github = "MohsinAli0899/Book Summary App"
      desc = "BookHub is an Android application that helps users to view books and add them to favorites."
      setPlatforms(ANDROID)
      setTags("booksummary", "kotlin", "android", "app")
    }
    link {
      github = "zt64/Hyperion"
      desc = "An alternative YouTube front-end using modern Android architecture and Material 3"
      setPlatforms(ANDROID)
      setTags("android", "kotlin", "compose", "mvvm", "koin", "material3")
    }
    link {
      github = "1sao/Space-Cards-Multiplatform"
      desc = "An astrophotography browser built with Compose Multiplatform. Featuring Clean Architecture, MVI and a custom paging solution."
      setPlatforms(ANDROID, JVM, COMMON)
      setTags("android", "desktop", "jvm", "pager", "pagination")
    }
  }
}
