IronPython 3
============
**There is still much that needs to be done to support Python 3.x. We are working on it, albeit slowly. We welcome all those who would like to help!**

[Official Website](https://ironpython.net)

IronPython is an open-source implementation of the Python programming language that is tightly integrated with .NET. IronPython can use .NET and Python libraries, and other .NET languages can use Python code just as easily.

IronPython 3 targets Python 3, including the re-organized standard library, Unicode strings, and all of the other new features.


| **What?** | **Where?** |
| --------: | :------------: |
| **Windows/Linux/macOS Builds** | [![Build status](https://dotnet.visualstudio.com/IronLanguages/_apis/build/status/ironpython3)](https://dotnet.visualstudio.com/IronLanguages/_build/latest?definitionId=43) [![Github build status](https://github.com/IronLanguages/ironpython3/workflows/CI/badge.svg)](https://github.com/IronLanguages/ironpython3/actions?workflow=CI) |
| **Downloads** | [![NuGet](https://img.shields.io/nuget/vpre/IronPython.svg)](https://www.nuget.org/packages/IronPython/latest) [![Release](https://img.shields.io/github/release/IronLanguages/ironpython3.svg?include_prereleases)](https://github.com/IronLanguages/ironpython3/releases/latest)|
| **Help** | [![Gitter chat](https://badges.gitter.im/IronLanguages/ironpython.svg)](https://gitter.im/IronLanguages/ironpython) [![StackExchange](https://img.shields.io/badge/stack%20overflow-ironpython-informational?logo=stack-overflow&logoColor=white)](https://stackoverflow.com/questions/tagged/ironpython) |


## Examples

To see how to use in PowerShell (either directly embedded or executable invocation), skip to [Installation](#Installation)

The following C# program:

```cs
using System.Windows.Forms;

MessageBox.Show("Hello World!", "Greetings", MessageBoxButtons.OKCancel);
```

can be written in IronPython as follows:

```py
import clr
clr.AddReference("System.Windows.Forms")
from System.Windows.Forms import MessageBox, MessageBoxButtons

MessageBox.Show("Hello World!", "Greetings", MessageBoxButtons.OKCancel)
```

Here is an example how to call Python code from a C# program.

```cs
var eng = IronPython.Hosting.Python.CreateEngine();
var scope = eng.CreateScope();
eng.Execute(@"
def greetings(name):
    return 'Hello ' + name.title() + '!'
", scope);
dynamic greetings = scope.GetVariable("greetings");
System.Console.WriteLine(greetings("world"));
```
This example assumes that `IronPython` has been added to the C# project as a NuGet package.

## Code of Conduct

This project has adopted the code of conduct defined by the Contributor Covenant to clarify expected behavior in our community.
For more information see the [.NET Foundation Code of Conduct](https://dotnetfoundation.org/code-of-conduct).

## State of the Project

The current target is Python 3.4, although features and behaviors from later versions may be included.

See the following lists for features from each version of CPython that have been implemented:

- [What's New In Python 3.0](WhatsNewInPython30.md)
- [What's New In Python 3.1](WhatsNewInPython31.md)
- [What's New In Python 3.2](WhatsNewInPython32.md)
- [What's New In Python 3.3](WhatsNewInPython33.md)
- [What's New In Python 3.4](WhatsNewInPython34.md)
- [What's New In Python 3.5](WhatsNewInPython35.md)
- [What's New In Python 3.6](WhatsNewInPython36.md)

## Contributing

For details on contributing see the [Contributing](CONTRIBUTING.md) article.

## Upgrading from IronPython 2

For details on upgrading from IronPython 2 to 3 see the [Upgrading from IronPython 2 to 3](https://github.com/IronLanguages/ironpython3/wiki/Upgrading-from-IronPython2) article.

## Differences with CPython

While compatibility with CPython is one of our main goals with IronPython 3, there are still some differences that may cause issues. See [Differences from CPython](https://github.com/IronLanguages/ironpython3/wiki/Differences-from-CPython) for details.

## Package compatibility

See the [Package compatibility](https://github.com/IronLanguages/ironpython3/wiki/Package-compatibility) document for information on compatibility with popular packages.

## Installation

Binaries of IronPython 3 can be downloaded from the [release page](https://github.com/IronLanguages/ironpython3/releases/latest), available in various formats: `.msi`, `.zip`, `.deb`, `.pkg`. The IronPython package is also available on [NuGet](https://www.nuget.org/packages/IronPython/latest). See the [installation document](https://github.com/IronLanguages/ironpython3/wiki/Installing) for detailed instructions on how to install a standalone IronPython interpreter on various operating systems and .NET frameworks.

### PowerShell

For usage in PowerShell, you can install using the Install-IronPython.ps1 within the aforementioned `.zip` file or by simply using this one-liner:

```pwsh
& ([scriptblock]::Create((iwr `
    -Uri 'https://raw.githubusercontent.com/IronLanguages/ironpython3/main/eng/scripts/Install-IronPython.ps1').Content)) `
    -Path "~/ipyenv/v3.4.2"

# Optionally, ensure pip:
# & "~/ipyenv/v3.4.2/ipy" -m ensurepip
```

Once installed, you can start using IronPython directly in PowerShell!

To use the ipy shim, you can use:
```pwsh
& "~/ipyenv/v3.4.2/Enter-IronPythonEnvironment.ps1"

ipy -c "print('Hello from IronPython!')"
```

... or to use IronPython embedded in PowerShell, you can use:
```pwsh
Import-Module "~/ipyenv/v3.4.2/IronPython.dll"

$engine = & {
    $engine = [IronPython.Hosting.Python]::CreateEngine()

    # You need to add the correct paths, as IronPython will use PowerShell's installation path by default
    $paths = $engine.GetSearchPaths()
    $paths.Add("$(Resolve-Path "~/ipyenv/v3.4.2/lib")")
    $paths.Add("$(Resolve-Path "~/ipyenv/v3.4.2/lib/site-packages")")

    # To use `wpf` and `sqlite3` you have to add the DLLs search path
    # - the [IronPython.SQLite] and [IronPython.WPF] powershell namespaces will become available on python import
    $paths.Add("$(Resolve-Path "~/ipyenv/v3.4.2/DLLs")")

    # or if you prefer to have the powershell namespaces early, you can use:
    # - just note, you will have to initialize _sqlite3 (see further down the script)
    # Import-Module "~/ipyenv/v3.4.2/DLLs/IronPython.SQLite.dll"
    # Import-Module "~/ipyenv/v3.4.2/DLLs/IronPython.WPF.dll"

    $engine.SetSearchPaths($paths)

    # Then have fun!
    $engine.Execute("print('Hello from IronPython!')")

    # Optionally, if you need to initialize _sqlite3:
    # $engine.Execute("import sqlite3")

    return $engine
}
```

## Build

See the [building document](https://github.com/IronLanguages/ironpython3/wiki/Building). Since the main development is on Windows, bugs on other platforms may inadvertently be introduced - please report them!

## Supported Platforms

IronPython 3 targets .NET Framework 4.6.2, .NET Standard 2.0, .NET 6.0 and .NET 8.0. The support for .NET and .NET Core follow the lifecycle defined on [.NET and .NET Core Support Policy](https://dotnet.microsoft.com/platform/support/policy/dotnet-core).
