# Licensed to the .NET Foundation under one or more agreements.
# The .NET Foundation licenses this file to you under the Apache 2.0 License.
# See the LICENSE file in the project root for more information.

import sys

boundaries = (None, -7, -2, 0, 1, 6, 10, (1<<31)-1, sys.maxsize+1)
steps = (None, -5, -3, -1, 1, 5, 20, (1<<31)-1, sys.maxsize+1)
lengths = (0, 1, 5, 10, 100, (1<<31)-1, sys.maxsize+1)

with open("IndicesTest.py", "w") as file:
    file.write("""# Licensed to the .NET Foundation under one or more agreements.
# The .NET Foundation licenses this file to you under the Apache 2.0 License.
# See the LICENSE file in the project root for more information.

# generated by generate_indicestest.py

def test_indices(self):
    def t(i, j, k, l, r):
        rr = slice(i, j, k).indices(l)
        self.assertEqual(rr, r, "slice({i}, {j}, {k}).indices({l}) != {r}: {rr}".format(i=i, j=j, k=k, l=l, r=r, rr=rr))

""")

    num_tests = 0
    for start in boundaries:
        for stop in boundaries:
            for step in steps:
                for length in lengths:
                    s = slice(start, stop, step)
                    i = s.indices(length)
                    file.write("    t({start}, {stop}, {step}, {length}, {i})\n".format(start=start, stop=stop, step=step, length=length, i=i))
                    num_tests += 1

    print(num_tests)
