- 24 September 2024 - Version 1.7.2
    - Fix several compatibilities
- 4 September 2023 - Version 1.7.1
    - Fix several compatibilities
- 25 May 2023 - Version 1.7.0
    - Add Apple Silicon support (thanks[@rayeesoft](https://github.com/rayeesoft) and [@ArtemBernatskyy](https://github.com/ArtemBernatskyy), see [PR](https://github.com/JaidedAI/EasyOCR/pull/1004))
    - Fix several compatibilities
- 15 September 2022 - Version 1.6.2
    - Add CPU support for DBnet
    - DBNet will only be compiled when users initialize DBnet detector.  
- 1 September 2022 - Version 1.6.1
    - Fix DBNet path bug for Windows
    - Add new built-in model `cyrillic_g2`. This model is a new default for Cyrillic script. (partial financial support by Alejandro Cabrerizo)
- 24 August 2022 - Version 1.6.0
    - Restructure code to support alternative text detectors.
    - Add detector `DBNet`, see [paper](https://arxiv.org/abs/2202.10304v1). It can be used by initializing like this `reader = easyocr.Reader(['en'], detect_network = 'dbnet18')`. *Currently, DBNet text detector requires running with GPU.*
- 2 June 2022 - Version 1.5.0
    - Add trainer for CRAFT detection model (thanks[@gmuffiness](https://github.com/gmuffiness), see [PR](https://github.com/JaidedAI/EasyOCR/pull/739))
- 9 April 2022 - Version 1.4.2
    - Update dependencies (opencv and pillow issues)
- 11 September 2021 - Version 1.4.1
    - Add trainer folder
    - Add `readtextlang` method (thanks[@arkya-art](https://github.com/arkya-art), see [PR](https://github.com/JaidedAI/EasyOCR/pull/525))
    - Extend `rotation_info` argument to support all possible angle (thanks[abde0103](https://github.com/abde0103), see [PR](https://github.com/JaidedAI/EasyOCR/pull/515))
- 29 June 2021 - Version 1.4
    - [Instruction](https://github.com/JaidedAI/EasyOCR/blob/master/custom_model.md) on training/using custom recognition model
    - [Example dataset](https://www.jaided.ai/easyocr/modelhub)
    - Batched image inference for GPU (thanks [@SamSamhuns](https://github.com/SamSamhuns), see [PR](https://github.com/JaidedAI/EasyOCR/pull/458))
    - Vertical text support (thanks [@interactivetech](https://github.com/interactivetech)). This is for rotated text, not to be confused with vertical Chinese or Japanese text. (see [PR](https://github.com/JaidedAI/EasyOCR/pull/450))
    - Output in dictionary format (thanks [@A2va](https://github.com/A2va), see [PR](https://github.com/JaidedAI/EasyOCR/pull/441))
- 30 May 2021 - Version 1.3.2
    - Faster greedy decoder (thanks [@samayala22](https://github.com/samayala22))
    - Fix bug when text box's aspect ratio is disproportional (thanks [iQuartic](https://iquartic.com/) for bug report)
- 20 April 2021 - Version 1.3.1
    - Add support for PIL image (thanks [@prays](https://github.com/prays))
    - Add Tajik language (tjk)
    - Update argument setting for command line
    - Add `x_ths` and `y_ths` to control merging behavior when `paragraph=True`
- 21 March 2021 - Version 1.3
    - Second-generation models: multiple times smaller size, multiple times faster inference, additional characters, comparable accuracy to the first generation models.
    EasyOCR will choose the latest model by default but you can also specify which model to use by passing `recog_network` argument when creating `Reader` instance.
    For example, `reader = easyocr.Reader(['en','fr'], recog_network = 'latin_g1')` will use the 1st generation Latin model.
    - List of all models: [Model hub](https://www.jaided.ai/easyocr/modelhub)
- 22 February 2021 - Version 1.2.5
    - Add dynamic quantization for faster CPU inference (it is enabled by default for CPU mode)
    - More sensible confident score
- 7 February 2021 - Version 1.2.4
    - Faster CPU inference speed by using dynamic input shape (recognition rate increases by around 100% for images with a lot of text)
- 1 February 2021 - Version 1.2.3
    - Add `setLanguageList` method to `Reader` class. This is a convenient api for changing languages (within the same model) after creating class instance.
    - Small change on text box merging. (thanks [z-pc](https://github.com/z-pc), see [PR](https://github.com/JaidedAI/EasyOCR/pull/338))
    - [Basic Demo on website](https://www.jaided.ai/easyocr)
- 5 January 2021 - Version 1.2.2
    - Add `optimal_num_chars` to `detect` method. If specified, bounding boxes with estimated number of characters near this value are returned first. (thanks [@adamfrees](https://github.com/adamfrees))
    - Add `rotation_info` to `readtext` method. Allow EasyOCR to rotate each text box and return the one with the best confident score. Eligible values are 90, 180 and 270. For example, try [90, 180 ,270] for all possible text orientations. (thanks [@mijoo308](https://github.com/mijoo308))
    - Update [documentation](https://www.jaided.ai/easyocr/documentation).
- 24 November 2020 - Version 1.2.1
    - Preparation for user-created models
- 17 November 2020 - Version 1.2
    - New language supports for Telugu and Kannada. These are experimental lite recognition models. Their file sizes are only around 7% of other models and they are ~6x faster at inference with CPU.
- 12 October 2020 - Version 1.1.10
    - Faster beamsearch decoder (thanks @amitbcp)
    - Better code structure (thanks @susmith98)
    - New language supports for Haryanvi, Sanskrit (Devanagari Script) and Manipuri (Bengari script)
- 31 August 2020 - Version 1.1.9
    - Add `detect` and `recognize` method for performing text detection and recognition separately
- 23 August 2020 - Version 1.1.8
    - 20 new language supports for Bengali, Assamese, Abaza, Adyghe, Kabardian, Avar,
    Dargwa, Ingush, Chechen, Lak, Lezgian, Tabassaran, Bihari, Maithili, Angika,
    Bhojpuri, Magahi, Nagpuri, Newari, Goan Konkani
    - Support RGBA input format
    - Add `min_size` argument for `readtext`: for filtering out small text box
- 10 August 2020 - Version 1.1.7
    - New language support for Tamil
    - Temporary fix for memory leakage on CPU mode
- 4 August 2020 - Version 1.1.6
    - New language support for Russian, Serbian, Belarusian, Bulgarian, Mongolian, Ukranian (Cyrillic Script) and Arabic, Persian(Farsi), Urdu, Uyghur (Arabic Script)
    - Docker file and Ainize demo (thanks @ghandic and @Wook-2)
    - Better production friendly with Logger and custom model folder location (By setting ` model_storage_directory` when create `Reader` instance) (thanks @jpotter)
    - Model files are now downloaded from github's releases
    - readtext can now accept grayscale image
- 24 July 2020 - Version 1.1.5
    - New language support for Hindi, Marathi, Nepali (Devanagari Script)
    - Automatic word merging into paragraph (Use this feature by setting `readtext`'s parameter `'paragraph' = True`)
