# Contributing to GitHub Templates Repository

First off, thank you for considering contributing to this project! Your help and expertise are greatly appreciated.

The following is a set of guidelines for contributing to this repository. These are mostly guidelines, not rules. Use your best judgment, and feel free to propose changes to this document in a pull request.

## How Can I Contribute?

### Reporting Bugs

This section guides you through submitting a bug report for this project. Following these guidelines helps maintainers and the community understand your report, reproduce the behavior, and find related reports.

- Use the [bug report template](./ISSUE_TEMPLATE/bug-report.yml) to create a new issue.

### Suggesting Enhancements

This section guides you through submitting an enhancement suggestion for this project, including completely new features and minor improvements to existing functionality. Following these guidelines helps maintainers and the community understand your suggestion and make decisions.

- Use the [feature request template](./ISSUE_TEMPLATE/feature-request.yml) to create a new issue.

### Pull Requests

1. Fork the repository and create your branch from `main`.
2. If you've added code that should be tested, add tests.
3. If you've changed APIs, update the documentation.
4. Ensure the test suite passes.
5. Make sure your code follows the project's coding style (e.g., Black for Python code).
6. Issue that pull request using the [pull request template](./PULL_REQUEST_TEMPLATE/pull_request_template.yml)!

## Styleguides

### Git Commit Messages

- Use the present tense ("Add feature" not "Added feature").
- Use the imperative mood ("Move cursor to..." not "Moves cursor to...").
- Limit the first line to 72 characters or less.
- Reference issues and pull requests liberally after the first line.
- When only changing documentation, include `[ci skip]` in the commit title.

### Code Style

- Follow the project's coding style (e.g., Black for Python code).
