<p align="center">
    <a href="https://kiln.tech">
        <picture>
            <img width="205" alt="Kiln AI Logo" src="https://github.com/user-attachments/assets/fc20f392-d913-4a94-a828-a66d21689496">
        </picture>
    </a>
</p>

<h3 align="center">
  Build, Evaluate, and Optimize AI Systems
</h3>

<p align="center">
  Kiln is a free app with everything you need to build better AI products
</p>

<p align="center">
  <a href="https://docs.kiln.tech/docs/evaluations"><strong>Evals</strong></a> • 
  <a href="https://docs.kiln.tech/docs/documents-and-search-rag"><strong>RAG</strong></a> • 
  <a href="https://docs.kiln.tech/docs/agents"><strong>Agents</strong></a> • 
  <a href="https://docs.kiln.tech/docs/fine-tuning-guide"><strong>Fine Tuning</strong></a> •
  <a href="https://docs.kiln.tech/docs/synthetic-data-generation"><strong>Synthetic Data</strong></a> • 
  <a href="https://docs.kiln.tech"><strong>All Docs</strong></a>
</p>
<p align="center">
  <a href="https://github.com/Kiln-AI/kiln/actions/workflows/build_and_test.yml"><img src="https://github.com/Kiln-AI/kiln/actions/workflows/build_and_test.yml/badge.svg" alt="Build and Test"></a>
  <a href="https://github.com/Kiln-AI/kiln/actions/workflows/test_count.yml"><img src="https://img.shields.io/endpoint?url=https://gist.githubusercontent.com/scosman/57742c1b1b60d597a6aba5d5148d728e/raw/test_count_kiln.json" alt="Test Count Badge"></a>
  <a href="https://kiln.tech/discord"><img src="https://img.shields.io/badge/Discord-Kiln_AI-blue?logo=Discord&logoColor=white" alt="Discord"></a>
  <a href="https://kiln.tech/blog"><img src="https://img.shields.io/badge/Newsletter-subscribe-blue?logo=mailboxdotorg&logoColor=white" alt="Newsletter"></a>
</p>
<p align="center">
  <a href="https://kiln.tech/download"><img width="180" src="https://github.com/user-attachments/assets/a5d51b8b-b30a-4a16-a902-ab6ef1d58dc0" alt="Download Button"></a>
  <a href="https://docs.kiln.tech/getting-started/quickstart"><img width="180" src="https://github.com/user-attachments/assets/aff1b35f-72c0-4286-9b28-40a415558359" alt="Quickstart Button"></a>
</p>

## Key Features

- 🚀 [**Intuitive Desktop Apps**](https://kiln.tech/download): One-click apps for Windows, MacOS, and Linux.
- 📊 [**Evals**](https://docs.kiln.tech/docs/evaluations): Evaluate the quality of your models/tasks using state of the art evaluators.
- 🎛️ [**Fine Tuning**](https://docs.kiln.tech/docs/fine-tuning-guide): Zero-code fine-tuning for Llama, GPT-4o, and more. Automatic serverless deployment of models.
- 🔍 [**Docs & Search (RAG)**](https://docs.kiln.tech/docs/documents-and-search-rag): Add knowledge to your AI systems with Retrieval-Augmented Generation (RAG).
- 🤖 [**Agents**](https://docs.kiln.tech/docs/agents): Build agentic systems with multiple actors
- 🛠 [**Tools & MCP**](https://docs.kiln.tech/docs/tools-and-mcp): Connect powerful tools to your Kiln tasks
- 🪄 [**Synthetic Data Generation**](https://docs.kiln.tech/docs/synthetic-data-generation): Generate eval datasets or fine-tuning data with our interactive visual tooling.
- 🧠 [**Reasoning Models**](https://docs.kiln.tech/docs/guide-train-a-reasoning-model): Train or distill your own custom reasoning models.
- 📝 [**Prompt Generation**](https://docs.kiln.tech/docs/prompts): Automatically generate prompts including chain-of-thought, few-shot, and multi-shot, and more.
- 🌐 [**Comprehensive Model Support**](https://kiln.tech/model_library): Skip the guesswork — we've tested over 100 models' capabilities. Use any model via Ollama, OpenAI, OpenRouter, Fireworks, Groq, AWS, any OpenAI compatible API, and more.
- 🤝 [**Team Collaboration**](https://docs.kiln.tech/docs/collaboration): Git-based version control for your AI datasets. Intuitive UI makes it easy to collaborate with QA, PM, and subject matter experts on data samples, evals, prompts, ratings and issues.
- 🗃️ [**Structured Data**](https://docs.kiln.tech/docs/structured-data-json): Build AI tasks that speak JSON.
- 🧑‍💻 **Open-Source [Library](https://docs.kiln.tech/developers/python-library-quickstart) and [API](https://docs.kiln.tech/developers/rest-api)**: Our Python library and OpenAPI REST API are MIT open source.
- 🔒 [**Privacy-First**](https://docs.kiln.tech/docs/privacy): Kiln runs locally on your computer. We can't access your data. Bring your own API keys or use Ollama.
- 📚 [**Awesome Docs**](https://docs.kiln.tech): easy-to-follow video guides, approachable for beginners, and depth for advanced users.
- 💰 **Free**: Our apps are free and our library is open-source.

## Measure, Improve, Repeat

Build better AI systems through iteration. Kiln brings evals and optimization together so every change is measurable—and every iteration moves you forward.

<img width="600" height="263" alt="kiln_optimization" src="https://github.com/user-attachments/assets/5517b33b-74dd-444a-9f40-6a9c6d8a1ffc" />

## Demo

[Watch a 2 minute overview of Kiln](https://kiln.tech#demo) or our [end to end project demo (20 minutes)](https://docs.kiln.tech/docs/end-to-end-project-demo).

<kbd>
<a href="https://kiln.tech#demo">
<img alt="Kiln Preview" src="guides/kiln_preview.gif">
</a>
</kbd>

## People in Our Community Work For

<img width="600" alt="Logo Grid" src="https://github.com/user-attachments/assets/fa633000-d0db-4140-b3be-485e4c4a71c0" />

<sub>People from these companies have registered for Kiln, starred Kiln on GitHub, or joined our Discord.</sub>

## Download Kiln Desktop Apps

Available on MacOS, Windows and Linux.

[<img width="180" alt="Download button" src="https://github.com/user-attachments/assets/a5d51b8b-b30a-4a16-a902-ab6ef1d58dc0">](https://kiln.tech/download)

## Docs & Guides

Kiln is quite intuitive, so we suggest launching the desktop app and diving in. However if you have any questions or want to learn more, our [docs are here to help](https://docs.kiln.tech).

### Video Guides

- [Fine Tuning LLM Models](https://docs.kiln.tech/docs/fine-tuning-guide)
- [Guide: Train a Reasoning Model](https://docs.kiln.tech/docs/guide-train-a-reasoning-model)
- [LLM Evaluators](https://docs.kiln.tech/docs/evaluators)
- [End to End Project Demo](https://docs.kiln.tech/docs/end-to-end-project-demo)
- [Tools 101: Intro to Tools & MCP](https://docs.kiln.tech/docs/tools-and-mcp)

### All Docs

- [Quick Start](https://docs.kiln.tech/getting-started/quickstart)
- [How to use any AI model or provider in Kiln](https://docs.kiln.tech/docs/models-and-ai-providers)
- [Documents & Search Tools (RAG)](https://docs.kiln.tech/docs/documents-and-search-rag)
- [Agents](https://docs.kiln.tech/docs/agents)
- [Tools & MCP](https://docs.kiln.tech/docs/tools-and-mcp)
- [Reasoning & Chain of Thought](https://docs.kiln.tech/docs/reasoning-and-chain-of-thought)
- [Synthetic Data Generation](https://docs.kiln.tech/docs/synthetic-data-generation)
- [Collaborating with Kiln](https://docs.kiln.tech/docs/collaboration)
- [Rating and Labeling Data](https://docs.kiln.tech/docs/reviewing-and-rating)
- [Prompt Styles](https://docs.kiln.tech/docs/prompts)
- [Structured Data / JSON](https://docs.kiln.tech/docs/structured-data-json)
- [Organizing Kiln Datasets (Tags and Filters)](https://docs.kiln.tech/docs/organizing-datasets)
- [Our Data Model](https://docs.kiln.tech/docs/kiln-datamodel)
- [Repairing Responses](https://docs.kiln.tech/docs/repairing-responses)
- [Keyboard Shortcuts](https://docs.kiln.tech/docs/keyboard-shortcuts)
- [Privacy Overview: Private by Design](https://docs.kiln.tech/docs/privacy)

For developers, see our [Kiln Python Library Docs](https://kiln-ai.github.io/Kiln/kiln_core_docs/kiln_ai.html). These include how to load datasets into Kiln, or using Kiln datasets in your own code-base/notebooks.

## Build & Tools

|         |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    |
| ------- | ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| CI      | [![Build and Test](https://github.com/Kiln-AI/kiln/actions/workflows/build_and_test.yml/badge.svg)](https://github.com/Kiln-AI/kiln/actions/workflows/build_and_test.yml) [![Format and Lint](https://github.com/Kiln-AI/kiln/actions/workflows/format_and_lint.yml/badge.svg)](https://github.com/Kiln-AI/kiln/actions/workflows/format_and_lint.yml) [![Desktop Apps Build](https://github.com/Kiln-AI/kiln/actions/workflows/build_desktop.yml/badge.svg)](https://github.com/Kiln-AI/kiln/actions/workflows/build_desktop.yml) [![Web UI Build](https://github.com/Kiln-AI/kiln/actions/workflows/web_format_lint_build.yml/badge.svg)](https://github.com/Kiln-AI/kiln/actions/workflows/web_format_lint_build.yml)                                                                                                           |
| Tests   | [![Test Count Badge](https://img.shields.io/endpoint?url=https://gist.githubusercontent.com/scosman/57742c1b1b60d597a6aba5d5148d728e/raw/test_count_kiln.json)](https://github.com/Kiln-AI/kiln/actions/workflows/test_count.yml) [![Test Coverage Badge](https://img.shields.io/endpoint?url=https://gist.githubusercontent.com/scosman/57742c1b1b60d597a6aba5d5148d728e/raw/library_coverage_kiln.json)](https://github.com/Kiln-AI/kiln/actions/workflows/test_count.yml)                                                                                                                                                                                                                                                                                                                                                       |
| Package | [![PyPI - Version](https://img.shields.io/pypi/v/kiln-ai.svg?logo=pypi&label=PyPI&logoColor=gold)](https://pypi.org/project/kiln-ai/) [![PyPI - Python Version](https://img.shields.io/pypi/pyversions/kiln-ai.svg?logo=python&label=Python&logoColor=gold)](https://pypi.org/project/kiln-ai/)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    |
| Meta    | [![uv](https://img.shields.io/endpoint?url=https://raw.githubusercontent.com/astral-sh/uv/main/assets/badge/v0.json)](https://github.com/astral-sh/uv) [![linting - Ruff](https://img.shields.io/endpoint?url=https://raw.githubusercontent.com/astral-sh/ruff/main/assets/badge/v2.json)](https://github.com/astral-sh/ruff) [![types - Pyright](https://img.shields.io/badge/types-pyright-blue.svg)](https://github.com/microsoft/pyright) [![Docs](https://img.shields.io/badge/docs-pdoc-blue)](https://kiln-ai.github.io/Kiln/kiln_core_docs/index.html)                                                                                                                                                                                                                                                                     |
| Apps    | [![MacOS](https://img.shields.io/badge/MacOS-black?logo=apple)](https://kiln.tech/download) [![Windows](https://img.shields.io/badge/Windows-0067b8.svg?logo=data:image/svg%2bxml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0idXRmLTgiPz4KPHN2ZyBmaWxsPSIjZmZmIiB2aWV3Qm94PSIwIDAgMzIgMzIiIHZlcnNpb249IjEuMSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZD0iTTE2Ljc0MiAxNi43NDJ2MTQuMjUzaDE0LjI1M3YtMTQuMjUzek0xLjAwNCAxNi43NDJ2MTQuMjUzaDE0LjI1NnYtMTQuMjUzek0xNi43NDIgMS4wMDR2MTQuMjU2aDE0LjI1M3YtMTQuMjU2ek0xLjAwNCAxLjAwNHYxNC4yNTZoMTQuMjU2di0xNC4yNTZ6Ij48L3BhdGg+Cjwvc3ZnPg==)](https://kiln.tech/download) [![Linux](https://img.shields.io/badge/Linux-444444?logo=linux&logoColor=ffffff)](https://kiln.tech/download) ![Github Downsloads](https://img.shields.io/github/downloads/kiln-ai/kiln/total) |
| Connect | [![Discord](https://img.shields.io/badge/Discord-Kiln_AI-blue?logo=Discord&logoColor=white)](https://kiln.tech/discord) [![Newsletter](https://img.shields.io/badge/Newsletter-subscribe-blue?logo=mailboxdotorg&logoColor=white)](https://kiln.tech/blog)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         |

## Python Library

[![PyPI - Version](https://img.shields.io/pypi/v/kiln-ai.svg?logo=pypi&label=PyPI&logoColor=gold)](https://pypi.org/project/kiln-ai/) [![Docs](https://img.shields.io/badge/docs-pdoc-blue)](https://kiln-ai.github.io/Kiln/kiln_core_docs/index.html)

Our open-source [python library](https://pypi.org/project/kiln-ai/) allows you to integrate Kiln datasets into your own workflows, build fine tunes, use Kiln in Notebooks, build custom tools, and much more! [Read the docs](https://kiln-ai.github.io/Kiln/kiln_core_docs/index.html) for examples.

```bash
pip install kiln-ai
```

## Learn More

### Rapid Prototyping

There are new models and techniques emerging all the time. Kiln makes it easy to try a variety of approaches and compare them in a few clicks without writing code. These can result in higher quality and improved performance.

We currently support:

- Various prompting techniques: basic, few-shot, multi-shot, repair & feedback
- Chain of thought / thinking, with optional custom “thinking” instructions
- Many models: GPT, Llama, Claude, Gemini, Mistral, Gemma, Phi
- Fine Tuning: create custom models using your Kiln dataset
- Evaluations using LLM-as-Judge and G-Eval
- Distilling models

In the future, we plan to add more powerful no-code options like RAG. For experienced data-scientists, you can create these techniques today using Kiln datasets and our Python library.

### Collaborate Across Technical and Non-Technical Teams

When building AI products, there’s usually a subject matter expert who knows the problem you are trying to solve, and a different technical team assigned to build the model. Kiln bridges that gap as a collaboration tool.

Subject matter experts can use our intuitive desktop apps to generate structured datasets and ratings, without coding or using technical tools. No command line or GPU required.

Data-scientists can consume the dataset created by subject matter experts, using the UI, or deep dive with our python library.

QA and PM can easily identify issues sooner and help generate the dataset content needed to fix the issue at the model layer.

The dataset file format is designed to be used with Git for powerful collaboration and attribution. Many people can contribute in parallel; collisions are avoided using UUIDs, and attribution is captured inside the dataset files. You can even share a dataset on a shared drive, letting completely non-technical team members contribute data and evals without knowing Git.

### Build High Quality AI Products with Datasets

Products don’t naturally have “datasets”, but Kiln helps you create one. Every time you use Kiln, we capture the inputs, outputs, human ratings, feedback, and repairs needed to build high quality models for use in your product. The more you use it, the more data you have.

Our synthetic data generation tool can build datasets for evals and fine-tuning in minutes.

Your model quality improves automatically as the dataset grows, by giving the models more examples of quality content (and mistakes). If your product goals shift or new bugs are found (as is almost always the case), you can easily iterate the dataset to address issues.

## Contributing & Development

See [CONTRIBUTING.md](CONTRIBUTING.md) for information on how to setup a development environment and contribute to Kiln.

## Citation

```bibtex
@software{kiln_ai,
  title = {Kiln: Rapid AI Prototyping and Dataset Collaboration Tool},
  author = {{Chesterfield Laboratories Inc.}},
  year = {2025},
  url = {https://github.com/Kiln-AI/Kiln},
  version = {latest}
}
```

## Licenses & Trademarks

The Kiln library with our core functionality is fully open source (MIT), while the Kiln desktop app is free to use, source-available, and may be licensed to enterprises in the future.

Why? We’re aiming to make Kiln fair and sustainable:

- Kiln is always free for personal use.
- Larger for-profit companies using Kiln Desktop may require a license in the future, but it is currently free.
- This is based on the concept of the [fair code model](https://faircode.io) with the goal of making Kiln sustainable (adapted since Kiln is an app, not a service).

Open Library and Data Format:

- Kiln’s MIT OSS library contains all of the core logic of Kiln. It can do anything the app can do, just without the font-end/UI.
- Kiln’s data format is open. You own and control your datasets, we don’t have access to them. The data is JSON formatted for maximal compatibility, ensuring zero lock-in.

**Licenses**

- Python Library (core logic/features): [MIT License](libs/core/LICENSE.txt)
- Python Server (REST API): [MIT License](libs/server/LICENSE.txt)
- Desktop App: free to download and use. 100% [source-available](app) with public builds for maximum transparency.

**Trademarks**: The Kiln name and logos are trademarks of Chesterfield Laboratories Inc.

Copyright 2024 - Chesterfield Laboratories Inc.
