"""
Strict mode is a feature that enables extra validations that we want to enforce in Kiln App, ensuring everything follows the ideal schema.

It's off by default when used through the library. Enable it by calling `set_strict_mode(True)`.
"""

# We want to be hard on ourselves for data completeness generated by the Kiln App, but don't want to make it hard for users to use the datamodel/library.
# Strict mode enables extra validations that we want to enforce in Kiln App (and any other client that wants best practices), but not in the library (unless they opt in)
_strict_mode: bool = False


def strict_mode() -> bool:
    """
    Get the current strict mode setting.
    """
    return _strict_mode


def set_strict_mode(value: bool) -> None:
    """
    Set the strict mode setting.
    """
    global _strict_mode
    _strict_mode = value
