# How to Become a Core Contributor

Thanks for your interest in joining the Lightning team! We’re a rapidly growing project which is poised to become the go-to framework for DL researchers!

As a core maintainer, you will have a strong say in the direction of the project. Big changes will require a majority of maintainers to agree.
Our development is fully open, so you can still raise your voice just by commenting on issues and pull requests! Doing so is a big step in becoming part of core.

## Code of Conduct

First and foremost, you'll be evaluated against [these core values](CONTRIBUTING.md). Any code we commit or feature we add needs to align with those core values.
Any collaboration and communication must adhere to our [code of conduct](CODE_OF_CONDUCT.md).

## The Bar for Joining the Team

Lightning is being used to solve really hard problems at the top AI labs in the world. As such, the bar for adding team members is extremely high. Candidates must have solid engineering skills, have a good eye for user experience, and must be a power user of Lightning and PyTorch.

With that said, the Lightning team will be diverse and a reflection of an inclusive AI community. You don't have to be an engineer to contribute! Scientists with great usability intuition and PyTorch ninja skills are welcomed!

## Responsibilities:

Here, we describe general expectations from core contributors:

### Github Issues

- Our community is the main motivation for our work. Help them have an amazing experience. Issues range from answering questions from new people getting into deep learning to helping researchers doing something esoteric.
  They often require some sort of bug fix, document clarification, or new functionality to be scoped out. You can help them solve their issues and guide them to completion.

- Weigh in on discussions in a timely fashion. Most importantly, on the RFCs (request for comments) that will shape the future of Lightning.
  There are some big decisions which the project must make. For these, we expect core contributors to have something meaningful to add, especially if it’s their area of expertise.

- Propose your own RFCs that align with the API design goals for Lightning.

- Identify opportunities from an issue or bug that can solve other related issues or make the framework more flexible.

- Don’t make users feel like they don’t know what they’re doing. We’re here to help and to make everyone’s experience delightful.

- Help out with critical bugs. Nobody likes bugs so you'll be a hero if you fix them!

### Pull Requests (PRs)

- Pull requests are the evolutionary mechanism of Lightning, so quality is extremely important. Make sure contributors adhere to the guidelines described in the [contributing section](CONTRIBUTING.md#pull-request).

- Some PRs are from people who want to get involved and try to add something unnecessary. We do want their help though! So don’t approve the PR, but direct them to a Github issue that they might be interested in helping with instead!

- Provide strong and valuable feedback during reviews. This is expected both when reviewing community PRs as well as PRs from other core contributors.
  Even if you are not part of core yet, you can still review and approve PRs. This will show us your abilities.

### Diversity

Lightning should reflect the broader community it serves. As such we should have scientists/researchers from different fields contributing!

### Community

We have an active [Discord](https://discord.gg/VptPCZkGNa) community, where questions are asked daily.
This is a great way to show off your Lightning and PyTorch knowledge, and help out others.
There's also [GitHub discussions](https://github.com/Lightning-AI/lightning/discussions).

## Applying

There are no precise targets for becoming a core contributor. In the past, community members have become core after fitting the previous expectations consistently.
We are on the lookout for new people to join, however, if you feel like you meet the expectations already and we haven't reached out to you yet, feel free to ping us privately on [Discord](https://discord.gg/XbUZ3xbdQk).

## Employment

You can also become a [Lightning AI](https://lightning.ai/) employee or intern and work on Lightning. To get started, you can email `careers@lightning.ai` with your resume or check out our [open job postings](https://boards.greenhouse.io/lightningai).
