import numpy as np

# Defined because pre-commit is inserting an unacceptable line-break
# between the "1" (or "2") and the "/ 3"
one_third = 1 / 3
two_thirds = 2 / 3


# Expected values for matrices in split_bezier
SPLIT_MATRICES = {
    # For 0-degree Béziers
    0: {
        0: np.array([[1], [1]]),
        one_third: np.array([[1], [1]]),
        two_thirds: np.array([[1], [1]]),
        1: np.array([[1], [1]]),
    },
    # For linear Béziers
    1: {
        0: np.array(
            [
                [1, 0],
                [1, 0],
                [1, 0],
                [0, 1],
            ]
        ),
        one_third: np.array(
            [
                [3, 0],
                [2, 1],
                [2, 1],
                [0, 3],
            ]
        )
        / 3,
        two_thirds: np.array(
            [
                [3, 0],
                [1, 2],
                [1, 2],
                [0, 3],
            ]
        )
        / 3,
        1: np.array(
            [
                [1, 0],
                [0, 1],
                [0, 1],
                [0, 1],
            ]
        ),
    },
    # For quadratic Béziers
    2: {
        0: np.array(
            [
                [1, 0, 0],
                [1, 0, 0],
                [1, 0, 0],
                [1, 0, 0],
                [0, 1, 0],
                [0, 0, 1],
            ]
        ),
        one_third: np.array(
            [
                [9, 0, 0],
                [6, 3, 0],
                [4, 4, 1],
                [4, 4, 1],
                [0, 6, 3],
                [0, 0, 9],
            ]
        )
        / 9,
        two_thirds: np.array(
            [
                [9, 0, 0],
                [3, 6, 0],
                [1, 4, 4],
                [1, 4, 4],
                [0, 3, 6],
                [0, 0, 9],
            ]
        )
        / 9,
        1: np.array(
            [
                [1, 0, 0],
                [0, 1, 0],
                [0, 0, 1],
                [0, 0, 1],
                [0, 0, 1],
                [0, 0, 1],
            ]
        ),
    },
    # For cubic Béziers
    3: {
        0: np.array(
            [
                [1, 0, 0, 0],
                [1, 0, 0, 0],
                [1, 0, 0, 0],
                [1, 0, 0, 0],
                [1, 0, 0, 0],
                [0, 1, 0, 0],
                [0, 0, 1, 0],
                [0, 0, 0, 1],
            ]
        ),
        one_third: np.array(
            [
                [27, 0, 0, 0],
                [18, 9, 0, 0],
                [12, 12, 3, 0],
                [8, 12, 6, 1],
                [8, 12, 6, 1],
                [0, 12, 12, 3],
                [0, 0, 18, 9],
                [0, 0, 0, 27],
            ]
        )
        / 27,
        two_thirds: np.array(
            [
                [27, 0, 0, 0],
                [9, 18, 0, 0],
                [3, 12, 12, 0],
                [1, 6, 12, 8],
                [1, 6, 12, 8],
                [0, 3, 12, 12],
                [0, 0, 9, 18],
                [0, 0, 0, 27],
            ]
        )
        / 27,
        1: np.array(
            [
                [1, 0, 0, 0],
                [0, 1, 0, 0],
                [0, 0, 1, 0],
                [0, 0, 0, 1],
                [0, 0, 0, 1],
                [0, 0, 0, 1],
                [0, 0, 0, 1],
                [0, 0, 0, 1],
            ]
        ),
    },
    # Test case with a quartic Bézier
    # to check if the fallback algorithms work
    4: {
        0: np.array(
            [
                [1, 0, 0, 0, 0],
                [1, 0, 0, 0, 0],
                [1, 0, 0, 0, 0],
                [1, 0, 0, 0, 0],
                [1, 0, 0, 0, 0],
                [1, 0, 0, 0, 0],
                [0, 1, 0, 0, 0],
                [0, 0, 1, 0, 0],
                [0, 0, 0, 1, 0],
                [0, 0, 0, 0, 1],
            ]
        ),
        one_third: np.array(
            [
                [81, 0, 0, 0, 0],
                [54, 27, 0, 0, 0],
                [36, 36, 9, 0, 0],
                [24, 36, 18, 3, 0],
                [16, 32, 24, 8, 1],
                [16, 32, 24, 8, 1],
                [0, 24, 36, 18, 3],
                [0, 0, 36, 36, 9],
                [0, 0, 0, 54, 27],
                [0, 0, 0, 0, 81],
            ]
        )
        / 81,
        two_thirds: np.array(
            [
                [81, 0, 0, 0, 0],
                [27, 54, 0, 0, 0],
                [9, 36, 36, 0, 0],
                [3, 18, 36, 24, 0],
                [1, 8, 24, 32, 16],
                [1, 8, 24, 32, 16],
                [0, 3, 18, 36, 24],
                [0, 0, 9, 36, 36],
                [0, 0, 0, 27, 54],
                [0, 0, 0, 0, 81],
            ]
        )
        / 81,
        1: np.array(
            [
                [1, 0, 0, 0, 0],
                [0, 1, 0, 0, 0],
                [0, 0, 1, 0, 0],
                [0, 0, 0, 1, 0],
                [0, 0, 0, 0, 1],
                [0, 0, 0, 0, 1],
                [0, 0, 0, 0, 1],
                [0, 0, 0, 0, 1],
                [0, 0, 0, 0, 1],
                [0, 0, 0, 0, 1],
            ]
        ),
    },
}
