# Project Alice Privacy Policy

*Last Updated: January 12, 2025*

## Introduction

Project Alice is an open-source project that enables users to create and deploy agentic workflows. This Privacy Policy explains how the Project Alice software handles data and the privacy implications of deploying and using the software.

## Important Notice

Project Alice is distributed as open-source software that you can deploy and run in your own environment. The Project Alice maintainers and contributors:
- Do not collect any data from your deployments
- Do not have access to your deployment or its data
- Do not monitor your usage of the software

## Data Collection and Storage

### Local Deployment
When you deploy Project Alice, all data collection and storage occurs locally within your deployment:

- User account information
- Chat histories and messages
- Task executions and results
- API configurations and credentials
- Generated files and content
- System logs and metrics

### Data Security Features
Project Alice includes several security features that you can implement in your deployment:

- Backend encryption for sensitive data including:
  - Message content
  - User passwords
  - Other sensitive user data
- User data isolation
- No cross-reference of user data in system operations

## User Responsibilities

As the deployer of Project Alice, you are responsible for:

1. **Data Security**
   - Properly configuring security features
   - Maintaining secure deployment environments
   - Managing access controls
   - Implementing backup procedures

2. **API Credentials**
   - Securing your API keys
   - Managing API access
   - Monitoring API usage
   - Complying with API provider terms

3. **User Privacy**
   - Establishing your own privacy policies
   - Protecting user data
   - Implementing necessary security measures
   - Complying with applicable privacy laws

## Third-Party Services

Project Alice can integrate with various third-party APIs and services. Please note:

- You are responsible for any third-party services you integrate
- Your use of third-party services is governed by their respective terms and policies
- The Project Alice maintainers make no warranties about third-party service functionality
- You must secure and manage your own API credentials

## Data Protection Recommendations

We recommend the following practices for your deployment:

1. **Security Configuration**
   - Enable all encryption features
   - Use strong passwords
   - Implement secure network configurations
   - Regularly update the software

2. **Access Control**
   - Implement user authentication
   - Manage user permissions
   - Monitor system access
   - Regular security audits

3. **Data Management**
   - Regular backups
   - Data retention policies
   - Secure data disposal
   - Access logging

## Changes to This Policy

This privacy policy may be updated to reflect changes in the software's features and capabilities. Changes will be documented in the project's version control system.

## Contact

For privacy-related questions about the Project Alice software, please:
- Open an issue on our GitHub repository
- Contact the maintainers through the project's communication channels
- Review our documentation

## Disclaimer

This privacy policy describes the privacy features and implications of the Project Alice software. When you deploy Project Alice, you become the data controller and processor for your deployment. You are responsible for establishing appropriate privacy policies and ensuring compliance with applicable laws and regulations.