# Using Chats

Project Alice provides a powerful chat interface for interacting with AI models and executing various tasks. This guide will walk you through the main features and how to use them effectively.

## Accessing the Chat Interface

1. Navigate to the ChatAlice page in the application.
2. You'll see a sidebar on the left and the main chat area on the right.

## Selecting or Creating

### Selecting an Existing Chat
1. In the sidebar, click on the `Select Chat` tab.
2. You'll see a list of your previous chats.
3. Use the filter at the top to narrow down chats by the AI model's API provider (e.g., OpenAI, Azure, Anthropic).
4. Click on a chat to load it in the main area.

### Creating a New Chat
1. Click the "Create [chat](/shared/knowledgebase/core/chat.md)" button (with a '+' icon) at the top of the sidebar. 
2. Follow the dialog to set up your new chat, including selecting an AI [agent](/shared/knowledgebase/core/agent.md) and any tools ([tasks](/shared/knowledgebase/core/task/task.md)) you want the agent to have access to.

## Chatting with Alice

1. Once you've selected or created a chat, you can start sending messages in the input box at the bottom of the main area.
2. Type your [message](/shared/knowledgebase/core/message.md) and press Enter or click the send button.
3. Alice will respond in the chat area above.

## Adding Functions

You can enhance Alice's capabilities within a chat by adding specific functions:

1. Click on the `Add Functions` tab in the sidebar.
2. Browse or search for available functions.
3. Click on a function to add it to the current chat.
4. Alice can now use these functions when responding to your messages.

## Adding References

You can add various types of references to enrich your conversation:

1. Use the respective tabs in the sidebar:
   - "Add [File Reference](/shared/knowledgebase/core/file.md)"
   - "Add [Message Reference](/shared/knowledgebase/core/message.md)"
   - "Add [Task Results](/shared/knowledgebase/core/task_response.md)"
   - "Add [Entity Reference](/shared/knowledgebase/core/entity_reference.md)"
2. Select the item you want to reference.
3. The reference will be added to your current message input.

## Viewing Chat Details

1. Click on the `Current Chat` tab in the sidebar to view details about the active chat.
2. Here you can see information about the AI agent, active functions, and other settings.

## Tips for Effective Chatting

- Be clear and specific in your requests to get the best responses from Alice.
- Utilize the added functions and references to provide context and enhance your Alice's capabilities.
- If you're not getting the desired results, try rephrasing your query or adding more context, adjusting the system prompt or the model the agent is using. 
- Remember that each chat can have its own set of functions and settings, so choose or create chats appropriate for your current task.