import React from 'react';
import { MessageComponentProps, MessageType } from '../../../../types/MessageTypes';
import EnhancedTableView from '../../../common/enhanced_component/TableView';

const MessageTableView: React.FC<MessageComponentProps> = ({
  items,
  item,
  onInteraction,
  onView,
  showHeaders = true,
}) => {
  const columns = [
    {
      header: 'Role',
      render: (message: MessageType) => message.role,
      sortKey: 'role'
    },
    {
      header: 'Content',
      render: (message: MessageType) => message.content.substring(0, 50) + (message.content.length > 50 ? '...' : ''),
      sortKey: 'content'
    },
    {
      header: 'Generated By',
      render: (message: MessageType) => message.generated_by,
      sortKey: 'generated_by'
    },
    {
      header: 'Created At',
      render: (message: MessageType) => new Date(message.createdAt || '').toLocaleString(),
      sortKey: 'createdAt'
    }
  ];

  return (
    <EnhancedTableView<MessageType>
      items={items as MessageType[]}
      item={item as MessageType}
      columns={columns}
      onView={onView}
      onInteraction={onInteraction}
      showHeaders={showHeaders}
      interactionTooltip="Select Message"
      viewTooltip="View Message Details"
    />
  );
};

export default MessageTableView;