"use client";
import React  from "react";
// import { useState } from "react";
// import {
  // motion,
  // AnimatePresence,
  // useTransform,
  // useSpring,
//   useMotionValue,
// } from "framer-motion";
import { Tooltip } from "@mui/material";

type ImageType = string | React.ReactNode;

interface TooltipItem {
  id: string;
  name: string | undefined;
  designation: string;
  image: ImageType;
}

export const AnimatedTooltip = ({
  items,
}: {
  items: TooltipItem[];
}) => {
  // eslint-disable-next-line
  // const [hoveredIndex, setHoveredIndex] = useState<string | null>(null);
  // const springConfig = { stiffness: 100, damping: 5 };
  // const x = useMotionValue(0);
  // const rotate = useSpring(
  //   useTransform(x, [-100, 100], [-45, 45]),
  //   springConfig
  // );
  // const translateX = useSpring(
  //   useTransform(x, [-100, 100], [-50, 50]),
  //   springConfig
  // );

  // const handleMouseMove = (event: React.MouseEvent<HTMLDivElement>) => {
  //   const halfWidth = event.currentTarget.offsetWidth / 2;
  //   x.set(event.nativeEvent.offsetX - halfWidth);
  // };

  const renderImage = (image: ImageType) => {
    if (typeof image === 'string') {
      return (
        <img
          src={image}
          alt="Profile"
          className="object-cover w-full h-full rounded-full"
        />
      );
    } else {
      return image;
    }
  };

  return (
    <>
      {items.map((item) => (
        <div
          className="-mr-4 relative group"
          key={item.id}
          // onMouseEnter={() => setHoveredIndex(item.id)}
          // onMouseLeave={() => setHoveredIndex(null)}
        >
          {/* <AnimatePresence mode="wait">
            {hoveredIndex === item.id && (
              <motion.div
                initial={{ opacity: 0, y: 20, scale: 0.6 }}
                animate={{
                  opacity: 1,
                  y: 0,
                  scale: 1,
                  transition: {
                    type: "spring",
                    stiffness: 260,
                    damping: 10,
                  },
                }}
                exit={{ opacity: 0, y: 20, scale: 0.6 }}
                style={{
                  translateX: translateX,
                  rotate: rotate,
                  whiteSpace: "nowrap",
                }}
                className="absolute -top-16 -left-1/2 translate-x-1/2 flex text-xs flex-col items-center justify-center rounded-md bg-black z-50 shadow-xl px-4 py-2"
              >
                <div className="absolute inset-x-10 z-30 w-[20%] -bottom-px bg-gradient-to-r from-transparent via-emerald-500 to-transparent h-px " />
                <div className="absolute left-10 w-[40%] z-30 -bottom-px bg-gradient-to-r from-transparent via-sky-500 to-transparent h-px " />
                <div className="font-bold text-white relative z-30 text-base">
                  {item.name}
                </div>
                <div className="text-white text-xs">{item.designation}</div>
              </motion.div>
            )}
          </AnimatePresence> */}
          <Tooltip title={item.name || ''} placement="top">
            <div
              // onMouseMove={handleMouseMove}
              className="object-cover !m-0 !p-0 object-top rounded-full h-14 w-14 border-2 group-hover:scale-105 group-hover:z-30 border-white relative transition duration-500"
            >
              {renderImage(item.image)}
            </div>
          </Tooltip>
        </div>
      ))}
    </>
  );
};