import { SvgIcon, SvgIconProps } from '@mui/material';

export const AnthropicIcon = (props: SvgIconProps) => (
  <SvgIcon {...props} viewBox="0 0 24 24">
    <path d="M17.3041 3.541h-3.6718l6.696 16.918H24Zm-10.6082 0L0 20.459h3.7442l1.3693-3.5527h7.0052l1.3693 3.5528h3.7442L10.5363 3.5409Zm-.3712 10.2232 2.2914-5.9456 2.2914 5.9456Z" />
  </SvgIcon>
);

export const LogicFlowIcon = (props: SvgIconProps) => (
  <SvgIcon {...props} viewBox="0 0 24 24">
    <path fillRule="evenodd" clip-rule="evenodd"
      d="M7.49996 6C7.49996 5.17157 8.17154 4.5 8.99997 4.5H15C15.8284 4.5 16.5 5.17157 16.5 6V7C16.5 7.82843 15.8284 8.5 15 8.5H12.5V10.7928L16.2071 14.5H20C20.2761 14.5 20.5 14.7239 20.5 15V18C20.5 18.2761 20.2761 18.5 20 18.5C19.7239 18.5 19.5 18.2761 19.5 18V15.5H16.6714C16.6508 15.5343 16.6257 15.5666 16.5962 15.5961L12.3535 19.8388C12.1583 20.034 11.8417 20.034 11.6464 19.8388L7.40377 15.5961C7.37422 15.5666 7.34914 15.5343 7.32853 15.5H4.5C4.22386 15.5 4 15.2761 4 15C4 14.7239 4.22386 14.5 4.5 14.5H7.79281L11.5 10.7928V8.5H8.99997C8.17154 8.5 7.49996 7.82843 7.49996 7V6ZM8.99997 5.5C8.72382 5.5 8.49997 5.72386 8.49997 6V7C8.49997 7.27614 8.72382 7.5 8.99997 7.5H15C15.2761 7.5 15.5 7.27614 15.5 7V6C15.5 5.72386 15.2761 5.5 15 5.5H8.99997ZM12 11.7071L8.46443 15.2426L12 18.7781L15.5355 15.2426L12 11.7071Z"
      // fill="#47495F"
    />
  </SvgIcon>
);

export const MistralIcon = (props: SvgIconProps) => (
  <SvgIcon {...props} viewBox="0 0 256 233">
    <path
      d="M186.18182 0h46.54545v46.54545h-46.54545z" />
    <path
      // fill="#F7D046"
      d="M209.45454 0h46.54545v46.54545h-46.54545z" />
    <path d="M0 0h46.54545v46.54545H0zM0 46.54545h46.54545V93.0909H0zM0 93.09091h46.54545v46.54545H0zM0 139.63636h46.54545v46.54545H0zM0 186.18182h46.54545v46.54545H0z" />
    <path
      // fill="#F7D046"
      d="M23.27273 0h46.54545v46.54545H23.27273z" />
    <path
      // fill="#F2A73B"
      d="M209.45454 46.54545h46.54545V93.0909h-46.54545zM23.27273 46.54545h46.54545V93.0909H23.27273z" />
    <path d="M139.63636 46.54545h46.54545V93.0909h-46.54545z" />
    <path
      // fill="#F2A73B"
      d="M162.90909 46.54545h46.54545V93.0909h-46.54545zM69.81818 46.54545h46.54545V93.0909H69.81818z" />
    <path
      // fill="#EE792F"
      d="M116.36364 93.09091h46.54545v46.54545h-46.54545zM162.90909 93.09091h46.54545v46.54545h-46.54545zM69.81818 93.09091h46.54545v46.54545H69.81818z" />
    <path d="M93.09091 139.63636h46.54545v46.54545H93.09091z" />
    <path
      // fill="#EB5829"
      d="M116.36364 139.63636h46.54545v46.54545h-46.54545z" />
    <path
      // fill="#EE792F"
      d="M209.45454 93.09091h46.54545v46.54545h-46.54545zM23.27273 93.09091h46.54545v46.54545H23.27273z" />
    <path d="M186.18182 139.63636h46.54545v46.54545h-46.54545z" />
    <path
      // fill="#EB5829"
      d="M209.45454 139.63636h46.54545v46.54545h-46.54545z" />
    <path d="M186.18182 186.18182h46.54545v46.54545h-46.54545z" />
    <path
      // fill="#EB5829"
      d="M23.27273 139.63636h46.54545v46.54545H23.27273z" />
    <path
      // fill="#EA3326"
      d="M209.45454 186.18182h46.54545v46.54545h-46.54545zM23.27273 186.18182h46.54545v46.54545H23.27273z" />
  </SvgIcon>
);

export const CohereIcon = (props: SvgIconProps) => (
  <SvgIcon {...props} viewBox="0 0 75 75">
    <path
      d="M24.3 44.7c2 0 6-.1 11.6-2.4 6.5-2.7 19.3-7.5 28.6-12.5 6.5-3.5 9.3-8.1 9.3-14.3C73.8 7 66.9 0 58.3 0h-36C10 0 0 10 0 22.3s9.4 22.4 24.3 22.4z"
      fillRule="evenodd"
      clipRule="evenodd"
    // fill="#39594d"
    />
    <path
      d="M30.4 60c0-6 3.6-11.5 9.2-13.8l11.3-4.7C62.4 36.8 75 45.2 75 57.6 75 67.2 67.2 75 57.6 75H45.3c-8.2 0-14.9-6.7-14.9-15z"
      fillRule="evenodd"
      clipRule="evenodd"
    // fill="#d18ee2"
    />
    <path
      d="M12.9 47.6C5.8 47.6 0 53.4 0 60.5v1.7C0 69.2 5.8 75 12.9 75c7.1 0 12.9-5.8 12.9-12.9v-1.7c-.1-7-5.8-12.8-12.9-12.8z"
    // fill="#ff7759"
    />
  </SvgIcon>
);

export const AzureIcon = (props: SvgIconProps) => (
  <SvgIcon {...props} viewBox="-0.4500000000000005 0.38 800.8891043012813 754.2299999999999">
    <linearGradient id="a" gradientUnits="userSpaceOnUse" x1="353.1" x2="107.1" y1="56.3" y2="783">
      <stop offset="0" stopColor="#114a8b" />
      <stop offset="1" stopColor="#0669bc" />
    </linearGradient>
    <linearGradient id="b" gradientUnits="userSpaceOnUse" x1="429.8" x2="372.9" y1="394.9" y2="414.2">
      <stop offset="0" stopOpacity=".3" />
      <stop offset=".1" stopOpacity=".2" />
      <stop offset=".3" stopOpacity=".1" />
      <stop offset=".6" stopOpacity=".1" />
      <stop offset="1" stopOpacity="0" />
    </linearGradient>
    <linearGradient id="c" gradientUnits="userSpaceOnUse" x1="398.4" x2="668.4" y1="35.1" y2="754.4">
      <stop offset="0" stopColor="#3ccbf4" />
      <stop offset="1" stopColor="#2892df" />
    </linearGradient>
    <path
      d="M266.71.4h236.71L257.69 728.9a37.8 37.8 0 0 1-5.42 10.38c-2.33 3.16-5.14 5.93-8.33 8.22s-6.71 4.07-10.45 5.27-7.64 1.82-11.56 1.82H37.71c-5.98 0-11.88-1.42-17.2-4.16A37.636 37.636 0 0 1 7.1 738.87a37.762 37.762 0 0 1-6.66-16.41c-.89-5.92-.35-11.97 1.56-17.64L230.94 26.07c1.25-3.72 3.08-7.22 5.42-10.38 2.33-3.16 5.15-5.93 8.33-8.22 3.19-2.29 6.71-4.07 10.45-5.27S262.78.38 266.7.38v.01z"
    // fill="url(#a)"
    />
    <path
      d="M703.07 754.59H490.52c-2.37 0-4.74-.22-7.08-.67-2.33-.44-4.62-1.1-6.83-1.97s-4.33-1.95-6.34-3.21a38.188 38.188 0 0 1-5.63-4.34l-241.2-225.26a17.423 17.423 0 0 1-5.1-8.88 17.383 17.383 0 0 1 7.17-18.21c2.89-1.96 6.3-3.01 9.79-3.01h375.36l92.39 265.56z"
    // fill="#0078d4"
    />
    <path
      d="M504.27.4l-165.7 488.69 270.74-.06 92.87 265.56H490.43c-2.19-.02-4.38-.22-6.54-.61s-4.28-.96-6.34-1.72a38.484 38.484 0 0 1-11.36-6.51L303.37 593.79l-45.58 134.42c-1.18 3.36-2.8 6.55-4.82 9.48a40.479 40.479 0 0 1-16.05 13.67 40.03 40.03 0 0 1-10.13 3.23H37.82c-6.04.02-12-1.42-17.37-4.2A37.664 37.664 0 0 1 .43 722a37.77 37.77 0 0 1 1.87-17.79L230.87 26.58c1.19-3.79 2.98-7.36 5.3-10.58 2.31-3.22 5.13-6.06 8.33-8.4s6.76-4.16 10.53-5.38S262.75.38 266.72.4h237.56z"
    // fill="url(#b)"
    />
    <path
      d="M797.99 704.82a37.847 37.847 0 0 1 1.57 17.64 37.867 37.867 0 0 1-6.65 16.41 37.691 37.691 0 0 1-30.61 15.72H498.48c5.98 0 11.88-1.43 17.21-4.16 5.32-2.73 9.92-6.7 13.41-11.56s5.77-10.49 6.66-16.41.35-11.97-1.56-17.64L305.25 26.05a37.713 37.713 0 0 0-13.73-18.58c-3.18-2.29-6.7-4.06-10.43-5.26S273.46.4 269.55.4h263.81c3.92 0 7.81.61 11.55 1.81 3.73 1.2 7.25 2.98 10.44 5.26 3.18 2.29 5.99 5.06 8.32 8.21s4.15 6.65 5.41 10.37l228.95 678.77z"
    // fill="url(#c)" 
    />
  </SvgIcon>
);

export const ArxivIcon = (props: SvgIconProps) => (
  <SvgIcon {...props} viewBox="0 0 24 24">
    <path d="M3.8423 0a1.0037 1.0037 0 0 0-.922.6078c-.1536.3687-.0438.6275.2938 1.1113l6.9185 8.3597-1.0223 1.1058a1.0393 1.0393 0 0 0 .003 1.4229l1.2292 1.3135-5.4391 6.4444c-.2803.299-.4538.823-.2971 1.1986a1.0253 1.0253 0 0 0 .9585.635.9133.9133 0 0 0 .6891-.3405l5.783-6.126 7.4902 8.0051a.8527.8527 0 0 0 .6835.2597.9575.9575 0 0 0 .8777-.6138c.1577-.377-.017-.7502-.306-1.1407l-7.0518-8.3418 1.0632-1.13a.9626.9626 0 0 0 .0089-1.3165L4.6336.4639s-.3733-.4535-.768-.463zm0 .272h.0166c.2179.0052.4874.2715.5644.3639l.005.006.0052.0055 10.169 10.9905a.6915.6915 0 0 1-.0072.945l-1.0666 1.133-1.4982-1.7724-8.5994-10.39c-.3286-.472-.352-.6183-.2592-.841a.7307.7307 0 0 1 .6704-.4401Zm14.341 1.5701a.877.877 0 0 0-.6554.2418l-5.6962 6.1584 1.6944 1.8319 5.3089-6.5138c.3251-.4335.479-.6603.3247-1.0292a1.1205 1.1205 0 0 0-.9763-.689zm-7.6557 12.2823 1.3186 1.4135-5.7864 6.1295a.6494.6494 0 0 1-.4959.26.7516.7516 0 0 1-.706-.4669c-.1119-.2682.0359-.6864.2442-.9083l.0051-.0055.0047-.0055z" />
  </SvgIcon>
);

export const WolframAlphaIcon = (props: SvgIconProps) => (
  <SvgIcon {...props} viewBox="0 0 24 24">
    <path d="M20.105 12.001l3.307-3.708-4.854-1.059.495-4.944-4.55 1.996L12 0 9.495 4.287 4.947 2.291l.494 4.944L.587 8.289l3.305 3.707-3.305 3.713 4.854 1.053-.5 4.945 4.553-1.994L12 24l2.504-4.287 4.55 1.994-.495-4.938 4.854-1.06-3.308-3.708zm1.605 2.792l-2.861-.982-1.899-2.471 2.526.942 2.234 2.511zm.459-6.096l-2.602 2.918-3.066-1.141 1.844-2.612 3.824.835zm-4.288-1.324l-1.533 2.179.088-3.162 1.788-2.415-.343 3.398zm-3.304-2.399l3.091-1.354L15.9 5.998l-2.943 1.049 1.62-2.073zm1.187 1.772l-.096 3.652-3.341 1.12V7.969l3.437-1.223zM12 1.308l1.969 3.371L12 7.199l-1.971-2.521L12 1.308zM9.423 4.974l1.619 2.072-2.948-1.048L6.332 3.62l3.091 1.354zm2.245 2.995v3.549l-3.335-1.12-.102-3.652 3.437 1.223zM7.564 6.39l.086 3.162-1.532-2.179-.341-3.397L7.564 6.39zM1.83 8.692l3.824-.83 1.839 2.612-3.065 1.136L1.83 8.692zm2.694 3.585l2.526-.937-1.9 2.471-2.861.977 2.235-2.511zm-2.093 3.159l2.929-1 3.045.896-2.622.837-3.352-.733zm3.28 5.212l.392-3.896 3.111-.982.082 3.31-3.585 1.568zm3.691-5.708l-3.498-1.03 2.226-2.892 3.335 1.126-2.063 2.796zm2.266 7.191l-1.711-2.934-.066-2.771 1.777 2.597v3.108zm-1.73-6.8L12 12.532l2.063 2.799L12 18.336l-2.062-3.005zm4.104 3.866l-1.715 2.934v-3.107l1.782-2.597-.067 2.77zm-1.514-7.052l3.341-1.126 2.221 2.892-3.499 1.03-2.063-2.796zm2.175 6.935l.077-3.31 3.116.982.386 3.901-3.579-1.573zm3.514-2.912l-2.625-.837 3.049-.896 2.928 1.003-3.352.73z" />
  </SvgIcon>
);

export const OpenAiIcon = (props: SvgIconProps) => (
  <SvgIcon {...props} viewBox="0 0 24 24">
    <path d="M22.2819 9.8211a5.9847 5.9847 0 0 0-.5157-4.9108 6.0462 6.0462 0 0 0-6.5098-2.9A6.0651 6.0651 0 0 0 4.9807 4.1818a5.9847 5.9847 0 0 0-3.9977 2.9 6.0462 6.0462 0 0 0 .7427 7.0966 5.98 5.98 0 0 0 .511 4.9107 6.051 6.051 0 0 0 6.5146 2.9001A5.9847 5.9847 0 0 0 13.2599 24a6.0557 6.0557 0 0 0 5.7718-4.2058 5.9894 5.9894 0 0 0 3.9977-2.9001 6.0557 6.0557 0 0 0-.7475-7.0729zm-9.022 12.6081a4.4755 4.4755 0 0 1-2.8764-1.0408l.1419-.0804 4.7783-2.7582a.7948.7948 0 0 0 .3927-.6813v-6.7369l2.02 1.1686a.071.071 0 0 1 .038.052v5.5826a4.504 4.504 0 0 1-4.4945 4.4944zm-9.6607-4.1254a4.4708 4.4708 0 0 1-.5346-3.0137l.142.0852 4.783 2.7582a.7712.7712 0 0 0 .7806 0l5.8428-3.3685v2.3324a.0804.0804 0 0 1-.0332.0615L9.74 19.9502a4.4992 4.4992 0 0 1-6.1408-1.6464zM2.3408 7.8956a4.485 4.485 0 0 1 2.3655-1.9728V11.6a.7664.7664 0 0 0 .3879.6765l5.8144 3.3543-2.0201 1.1685a.0757.0757 0 0 1-.071 0l-4.8303-2.7865A4.504 4.504 0 0 1 2.3408 7.872zm16.5963 3.8558L13.1038 8.364 15.1192 7.2a.0757.0757 0 0 1 .071 0l4.8303 2.7913a4.4944 4.4944 0 0 1-.6765 8.1042v-5.6772a.79.79 0 0 0-.407-.667zm2.0107-3.0231l-.142-.0852-4.7735-2.7818a.7759.7759 0 0 0-.7854 0L9.409 9.2297V6.8974a.0662.0662 0 0 1 .0284-.0615l4.8303-2.7866a4.4992 4.4992 0 0 1 6.6802 4.66zM8.3065 12.863l-2.02-1.1638a.0804.0804 0 0 1-.038-.0567V6.0742a4.4992 4.4992 0 0 1 7.3757-3.4537l-.142.0805L8.704 5.459a.7948.7948 0 0 0-.3927.6813zm1.0976-2.3654l2.602-1.4998 2.6069 1.4998v2.9994l-2.5974 1.4997-2.6067-1.4997Z" />
  </SvgIcon>
);

export const GeminiIcon = (props: SvgIconProps) => (
  <SvgIcon {...props} viewBox="0 0 24 24">
    <path d="M11.04 19.32Q12 21.51 12 24q0-2.49.93-4.68.96-2.19 2.58-3.81t3.81-2.55Q21.51 12 24 12q-2.49 0-4.68-.93a12.3 12.3 0 0 1-3.81-2.58 12.3 12.3 0 0 1-2.58-3.81Q12 2.49 12 0q0 2.49-.96 4.68-.93 2.19-2.55 3.81a12.3 12.3 0 0 1-3.81 2.58Q2.49 12 0 12q2.49 0 4.68.96 2.19.93 3.81 2.55t2.55 3.81" />
  </SvgIcon>
);

export const GroqIcon = (props: SvgIconProps) => (
  <SvgIcon {...props} viewBox="0 0 24 24">
    <path d="M18.901 1.153h3.68l-8.04 9.19L24 22.846h-7.406l-5.8-7.584-6.638 7.584H.474l8.6-9.83L0 1.154h7.594l5.243 6.932ZM17.61 20.644h2.039L6.486 3.24H4.298Z" />
  </SvgIcon>
);

export const DeepseekIcon = (props: SvgIconProps) => (
  <SvgIcon {...props} viewBox="0 0 24 24">
    <path d="M23.748 4.482c-.254-.124-.364.113-.512.234-.051.039-.094.09-.137.136-.372.397-.806.657-1.373.626-.829-.046-1.537.214-2.163.848-.133-.782-.575-1.248-1.247-1.548-.352-.156-.708-.311-.955-.65-.172-.241-.219-.51-.305-.774-.055-.16-.11-.323-.293-.35-.2-.031-.278.136-.356.276-.313.572-.434 1.202-.422 1.84.027 1.436.633 2.58 1.838 3.393.137.093.172.187.129.323-.082.28-.18.552-.266.833-.055.179-.137.217-.329.14a5.526 5.526 0 01-1.736-1.18c-.857-.828-1.631-1.742-2.597-2.458a11.365 11.365 0 00-.689-.471c-.985-.957.13-1.743.388-1.836.27-.098.093-.432-.779-.428-.872.004-1.67.295-2.687.684a3.055 3.055 0 01-.465.137 9.597 9.597 0 00-2.883-.102c-1.885.21-3.39 1.102-4.497 2.623C.082 8.606-.231 10.684.152 12.85c.403 2.284 1.569 4.175 3.36 5.653 1.858 1.533 3.997 2.284 6.438 2.14 1.482-.085 3.133-.284 4.994-1.86.47.234.962.327 1.78.397.63.059 1.236-.03 1.705-.128.735-.156.684-.837.419-.961-2.155-1.004-1.682-.595-2.113-.926 1.096-1.296 2.746-2.642 3.392-7.003.05-.347.007-.565 0-.845-.004-.17.035-.237.23-.256a4.173 4.173 0 001.545-.475c1.396-.763 1.96-2.015 2.093-3.517.02-.23-.004-.467-.247-.588zM11.581 18c-2.089-1.642-3.102-2.183-3.52-2.16-.392.024-.321.471-.235.763.09.288.207.486.371.739.114.167.192.416-.113.603-.673.416-1.842-.14-1.897-.167-1.361-.802-2.5-1.86-3.301-3.307-.774-1.393-1.224-2.887-1.298-4.482-.02-.386.093-.522.477-.592a4.696 4.696 0 011.529-.039c2.132.312 3.946 1.265 5.468 2.774.868.86 1.525 1.887 2.202 2.891.72 1.066 1.494 2.082 2.48 2.914.348.292.625.514.891.677-.802.09-2.14.11-3.054-.614zm1-6.44a.306.306 0 01.415-.287.302.302 0 01.2.288.306.306 0 01-.31.307.303.303 0 01-.304-.308zm3.11 1.596c-.2.081-.399.151-.59.16a1.245 1.245 0 01-.798-.254c-.274-.23-.47-.358-.552-.758a1.73 1.73 0 01.016-.588c.07-.327-.008-.537-.239-.727-.187-.156-.426-.199-.688-.199a.559.559 0 01-.254-.078c-.11-.054-.2-.19-.114-.358.028-.054.16-.186.192-.21.356-.202.767-.136 1.146.016.352.144.618.408 1.001.782.391.451.462.576.685.914.176.265.336.537.445.848.067.195-.019.354-.25.452z"></path>
  </SvgIcon>
);

export const LlamaIcon = (props: SvgIconProps) => (
  <SvgIcon {...props} viewBox="0 0 24 24">
    {/* Stylized llama head */}
    <path d="M16.361 10.26a.894.894 0 0 0-.558.47l-.072.148.001.207c0 .193.004.217.059.353.076.193.152.312.291.448.24.238.51.3.872.205a.86.86 0 0 0 .517-.436.752.752 0 0 0 .08-.498c-.064-.453-.33-.782-.724-.897a1.06 1.06 0 0 0-.466 0zm-9.203.005c-.305.096-.533.32-.65.639a1.187 1.187 0 0 0-.06.52c.057.309.31.59.598.667.362.095.632.033.872-.205.14-.136.215-.255.291-.448.055-.136.059-.16.059-.353l.001-.207-.072-.148a.894.894 0 0 0-.565-.472 1.02 1.02 0 0 0-.474.007Zm4.184 2c-.131.071-.223.25-.195.383.031.143.157.288.353.407.105.063.112.072.117.136.004.038-.01.146-.029.243-.02.094-.036.194-.036.222.002.074.07.195.143.253.064.052.076.054.255.059.164.005.198.001.264-.03.169-.082.212-.234.15-.525-.052-.243-.042-.28.087-.355.137-.08.281-.219.324-.314a.365.365 0 0 0-.175-.48.394.394 0 0 0-.181-.033c-.126 0-.207.03-.355.124l-.085.053-.053-.032c-.219-.13-.259-.145-.391-.143a.396.396 0 0 0-.193.032zm.39-2.195c-.373.036-.475.05-.654.086-.291.06-.68.195-.951.328-.94.46-1.589 1.226-1.787 2.114-.04.176-.045.234-.045.53 0 .294.005.357.043.524.264 1.16 1.332 2.017 2.714 2.173.3.033 1.596.033 1.896 0 1.11-.125 2.064-.727 2.493-1.571.114-.226.169-.372.22-.602.039-.167.044-.23.044-.523 0-.297-.005-.355-.045-.531-.288-1.29-1.539-2.304-3.072-2.497a6.873 6.873 0 0 0-.855-.031zm.645.937a3.283 3.283 0 0 1 1.44.514c.223.148.537.458.671.662.166.251.26.508.303.82.02.143.01.251-.043.482-.08.345-.332.705-.672.957a3.115 3.115 0 0 1-.689.348c-.382.122-.632.144-1.525.138-.582-.006-.686-.01-.853-.042-.57-.107-1.022-.334-1.35-.68-.264-.28-.385-.535-.45-.946-.03-.192.025-.509.137-.776.136-.326.488-.73.836-.963.403-.269.934-.46 1.422-.512.187-.02.586-.02.773-.002zm-5.503-11a1.653 1.653 0 0 0-.683.298C5.617.74 5.173 1.666 4.985 2.819c-.07.436-.119 1.04-.119 1.503 0 .544.064 1.24.155 1.721.02.107.031.202.023.208a8.12 8.12 0 0 1-.187.152 5.324 5.324 0 0 0-.949 1.02 5.49 5.49 0 0 0-.94 2.339 6.625 6.625 0 0 0-.023 1.357c.091.78.325 1.438.727 2.04l.13.195-.037.064c-.269.452-.498 1.105-.605 1.732-.084.496-.095.629-.095 1.294 0 .67.009.803.088 1.266.095.555.288 1.143.503 1.534.071.128.243.393.264.407.007.003-.014.067-.046.141a7.405 7.405 0 0 0-.548 1.873c-.062.417-.071.552-.071.991 0 .56.031.832.148 1.279L3.42 24h1.478l-.05-.091c-.297-.552-.325-1.575-.068-2.597.117-.472.25-.819.498-1.296l.148-.29v-.177c0-.165-.003-.184-.057-.293a.915.915 0 0 0-.194-.25 1.74 1.74 0 0 1-.385-.543c-.424-.92-.506-2.286-.208-3.451.124-.486.329-.918.544-1.154a.787.787 0 0 0 .223-.531c0-.195-.07-.355-.224-.522a3.136 3.136 0 0 1-.817-1.729c-.14-.96.114-2.005.69-2.834.563-.814 1.353-1.336 2.237-1.475.199-.033.57-.028.776.01.226.04.367.028.512-.041.179-.085.268-.19.374-.431.093-.215.165-.333.36-.576.234-.29.46-.489.822-.729.413-.27.884-.467 1.352-.561.17-.035.25-.04.569-.04.319 0 .398.005.569.04a4.07 4.07 0 0 1 1.914.997c.117.109.398.457.488.602.034.057.095.177.132.267.105.241.195.346.374.43.14.068.286.082.503.045.343-.058.607-.053.943.016 1.144.23 2.14 1.173 2.581 2.437.385 1.108.276 2.267-.296 3.153-.097.15-.193.27-.333.419-.301.322-.301.722-.001 1.053.493.539.801 1.866.708 3.036-.062.772-.26 1.463-.533 1.854a2.096 2.096 0 0 1-.224.258.916.916 0 0 0-.194.25c-.054.109-.057.128-.057.293v.178l.148.29c.248.476.38.823.498 1.295.253 1.008.231 2.01-.059 2.581a.845.845 0 0 0-.044.098c0 .006.329.009.732.009h.73l.02-.074.036-.134c.019-.076.057-.3.088-.516.029-.217.029-1.016 0-1.258-.11-.875-.295-1.57-.597-2.226-.032-.074-.053-.138-.046-.141.008-.005.057-.074.108-.152.376-.569.607-1.284.724-2.228.031-.26.031-1.378 0-1.628-.083-.645-.182-1.082-.348-1.525a6.083 6.083 0 0 0-.329-.7l-.038-.064.131-.194c.402-.604.636-1.262.727-2.04a6.625 6.625 0 0 0-.024-1.358 5.512 5.512 0 0 0-.939-2.339 5.325 5.325 0 0 0-.95-1.02 8.097 8.097 0 0 1-.186-.152.692.692 0 0 1 .023-.208c.208-1.087.201-2.443-.017-3.503-.19-.924-.535-1.658-.98-2.082-.354-.338-.716-.482-1.15-.455-.996.059-1.8 1.205-2.116 3.01a6.805 6.805 0 0 0-.097.726c0 .036-.007.066-.015.066a.96.96 0 0 1-.149-.078A4.857 4.857 0 0 0 12 3.03c-.832 0-1.687.243-2.456.698a.958.958 0 0 1-.148.078c-.008 0-.015-.03-.015-.066a6.71 6.71 0 0 0-.097-.725C8.997 1.392 8.337.319 7.46.048a2.096 2.096 0 0 0-.585-.041Zm.293 1.402c.248.197.523.759.682 1.388.03.113.06.244.069.292.007.047.026.152.041.233.067.365.098.76.102 1.24l.002.475-.12.175-.118.178h-.278c-.324 0-.646.041-.954.124l-.238.06c-.033.007-.038-.003-.057-.144a8.438 8.438 0 0 1 .016-2.323c.124-.788.413-1.501.696-1.711.067-.05.079-.049.157.013zm9.825-.012c.17.126.358.46.498.888.28.854.36 2.028.212 3.145-.019.14-.024.151-.057.144l-.238-.06a3.693 3.693 0 0 0-.954-.124h-.278l-.119-.178-.119-.175.002-.474c.004-.669.066-1.19.214-1.772.157-.623.434-1.185.68-1.382.078-.062.09-.063.159-.012z" />
  </SvgIcon>
);

export const WikipediaIcon = (props: SvgIconProps) => (
  <SvgIcon {...props} viewBox="0 0 24 24">
    <path d="M12.09 13.119c-.936 1.932-2.217 4.548-2.853 5.728-.616 1.074-1.127.931-1.532.029-1.406-3.321-4.293-9.144-5.651-12.409-.251-.601-.441-.987-.619-1.139-.181-.15-.554-.24-1.122-.271C.103 5.033 0 4.982 0 4.898v-.455l.052-.045c.924-.005 5.401 0 5.401 0l.051.045v.434c0 .119-.075.176-.225.176l-.564.031c-.485.029-.727.164-.727.436 0 .135.053.33.166.601 1.082 2.646 4.818 10.521 4.818 10.521l.136.046 2.411-4.81-.482-1.067-1.658-3.264s-.318-.654-.428-.872c-.728-1.443-.712-1.518-1.447-1.617-.207-.023-.313-.05-.313-.149v-.468l.06-.045h4.292l.113.037v.451c0 .105-.076.15-.227.15l-.308.047c-.792.061-.661.381-.136 1.422l1.582 3.252 1.758-3.504c.293-.64.233-.801.111-.947-.07-.084-.305-.22-.812-.24l-.201-.021c-.052 0-.098-.015-.145-.051-.045-.031-.067-.076-.067-.129v-.427l.061-.045c1.247-.008 4.043 0 4.043 0l.059.045v.436c0 .121-.059.178-.193.178-.646.03-.782.095-1.023.439-.12.186-.375.589-.646 1.039l-2.301 4.273-.065.135 2.792 5.712.17.048 4.396-10.438c.154-.422.129-.722-.064-.895-.197-.172-.346-.273-.857-.295l-.42-.016c-.061 0-.105-.014-.152-.045-.043-.029-.072-.075-.072-.119v-.436l.059-.045h4.961l.041.045v.437c0 .119-.074.18-.209.18-.648.03-1.127.18-1.443.421-.314.255-.557.616-.736 1.067 0 0-4.043 9.258-5.426 12.339-.525 1.007-1.053.917-1.503-.031-.571-1.171-1.773-3.786-2.646-5.71l.053-.036z" />
  </SvgIcon>
);

export const AIAssistantIcon = (props: SvgIconProps) => (
  <SvgIcon {...props} viewBox="0 0 24 24">
    <g id="assistant">
      <g>
        <path d="M9,12.5H8c-0.6,0-1-0.4-1-1v-1c0-0.6,0.4-1,1-1h1c0.6,0,1,0.4,1,1v1C10,12.1,9.6,12.5,9,12.5z" />
      </g>
      <g>
        <path d="M16,12.5h-1c-0.6,0-1-0.4-1-1v-1c0-0.6,0.4-1,1-1h1c0.6,0,1,0.4,1,1v1C17,12.1,16.6,12.5,16,12.5z" />
      </g>
      <path d="M12,0c1.1,0,2,0.9,2,2s-0.9,2-2,2s-2-0.9-2-2S10.9,0,12,0z" />
      <g>
        <path d="M12,24c-2.7,0-4.9-1.6-5-4.2c-1.1-0.3-2.3-0.8-3.5-1.4L3,18.1v-4.6c0-4.6,3.5-8.4,8-8.9V1.5h2v3.1c4.5,0.5,8,4.3,8,8.9
			v4.6l-0.5,0.3c-0.9,0.5-2.1,1-3.5,1.4C16.9,22.4,14.7,24,12,24z M9.1,20.2C9.5,21.5,10.6,22,12,22s2.6-0.5,2.9-1.8
			C13.3,20.5,11.6,20.6,9.1,20.2z M5,16.9c2.7,1.3,5.3,1.6,7,1.6c3,0,5.4-0.8,7-1.6v-1.5c-1.8,0.9-4.5,1.1-7,1.1s-5.2-0.2-7-1.1
			V16.9z M5.1,12.8c0.1,0.7,2.2,1.7,7,1.7c4.3,0,6.9-0.9,7-1.7c-0.3-3.5-3.3-6.3-7-6.3S5.4,9.3,5.1,12.8z"/>
      </g>
    </g>
  </SvgIcon>
);

export const APIConfigIcon = (props: SvgIconProps) => (
  <SvgIcon {...props} viewBox="0 0 24 24">
    <path d="M11.969 14a1.237 1.237 0 0 0 .044.863l.061.137H8v-1zm5.183-3.25h1.65a1.216 1.216 0 0 1 .198.03V10H8v1h8.412a1.243 1.243 0 0 1 .74-.25zM19 6H8v1h11zM4 13h3v3H4zm1 2h1v-1H5zm5.75 3H2V3h19v9.077l.135-.06a1.1 1.1 0 0 1 .865-.039V2H1v17h9.773a1.201 1.201 0 0 1-.023-.152zM7 8H4V5h3zM6 6H5v1h1zm1 6H4V9h3zm-1-2H5v1h1zm14 8a2 2 0 1 1-2-2 2 2 0 0 1 2 2zm-1 0a1 1 0 1 0-1 1 1 1 0 0 0 1-1zm3.414 1.392l-.296.628.724 1.624-1.162 1.17-1.543-.71-.653.236-.636 1.66h-1.65l-.59-1.586-.628-.295-1.627.727-1.167-1.166.71-1.543-.236-.653-1.66-.636v-1.65l1.586-.59.295-.628-.727-1.627 1.166-1.167 1.543.71.653-.236.636-1.66h1.65l.59 1.586.628.296 1.624-.724 1.166 1.167-.705 1.538.235.653 1.66.636v1.65zm-1.277.523l.544-1.158 1.319-.49v-.582l-1.427-.548-.434-1.204.585-1.28-.412-.412-1.397.622-1.158-.544-.49-1.319h-.582l-.548 1.427-1.206.434-1.283-.59-.41.411.626 1.4-.545 1.161-1.319.49v.582l1.427.548.434 1.206-.59 1.283.411.41 1.4-.626 1.161.545.49 1.319h.582l.548-1.427 1.206-.434 1.28.588.411-.413z" />
    <path fill="none" d="M0 0h24v24H0z" />
  </SvgIcon>
);
export const LMStudioIcon = (props: SvgIconProps) => (
  <SvgIcon {...props} viewBox="0 0 400 400">
    <g id="svgg">
      <path id="path0"
        d="M0.000 200.000 L 0.000 400.000 200.000 400.000 L 400.000 400.000 400.000 200.000 L 400.000 0.000 200.000 0.000 L 0.000 0.000 0.000 200.000 M216.200 72.256 C 216.640 72.506,217.700 73.046,218.555 73.456 C 221.830 75.024,226.400 80.557,226.400 82.954 C 226.400 83.284,226.580 83.664,226.800 83.800 C 227.674 84.340,227.264 91.684,226.211 94.372 C 224.970 97.539,221.596 102.000,220.442 102.000 C 220.230 102.000,219.812 102.225,219.513 102.500 C 216.493 105.276,219.919 105.165,139.400 105.079 C 63.273 104.996,66.544 105.066,62.800 103.448 C 54.545 99.882,50.613 88.252,55.100 80.674 C 55.595 79.838,56.002 79.030,56.003 78.877 C 56.014 78.057,61.667 73.200,62.612 73.200 C 62.759 73.200,63.446 72.938,64.140 72.619 C 64.833 72.299,66.030 71.966,66.800 71.877 C 70.497 71.454,215.436 71.821,216.200 72.256 M285.198 117.799 C 288.290 118.890,293.200 122.540,293.200 123.747 C 293.200 123.955,293.650 124.714,294.200 125.436 C 294.750 126.157,295.200 127.098,295.200 127.528 C 295.200 127.957,295.452 128.794,295.759 129.387 C 296.381 130.584,296.228 137.489,295.564 138.180 C 295.364 138.389,295.199 138.929,295.199 139.380 C 295.196 141.196,290.526 146.894,287.948 148.227 C 284.374 150.075,288.269 149.988,208.924 149.994 C 159.698 149.998,134.363 149.864,134.200 149.600 C 134.064 149.380,133.680 149.200,133.346 149.200 C 132.078 149.200,127.249 145.631,125.679 143.532 C 123.652 140.824,121.708 135.029,122.125 132.939 C 122.924 128.930,123.294 127.510,123.789 126.556 C 124.789 124.629,127.380 121.257,128.200 120.816 C 128.640 120.580,129.720 119.855,130.600 119.206 C 131.480 118.558,132.569 118.021,133.020 118.013 C 133.471 118.006,134.011 117.835,134.220 117.634 C 134.957 116.924,137.263 116.906,210.078 117.062 C 272.928 117.197,283.794 117.304,285.198 117.799 M243.200 162.538 C 250.883 164.683,256.945 172.986,255.852 179.867 C 255.718 180.710,255.493 182.162,255.353 183.094 C 255.212 184.025,254.850 184.992,254.549 185.243 C 254.247 185.493,254.000 185.967,254.000 186.295 C 254.000 188.371,249.966 192.134,245.200 194.505 L 243.400 195.400 169.200 195.400 L 95.000 195.400 92.232 194.230 C 85.880 191.546,82.000 185.686,82.000 178.778 C 82.000 171.010,86.844 164.689,94.400 162.597 C 97.045 161.865,240.585 161.808,243.200 162.538 M194.281 210.452 C 199.240 212.457,201.612 214.411,203.638 218.160 C 203.769 218.402,204.115 219.050,204.407 219.600 C 208.428 227.165,203.844 238.807,195.586 242.000 L 193.000 243.000 118.800 243.000 L 44.600 243.000 41.905 241.727 C 34.453 238.208,29.834 228.544,32.417 221.875 C 34.431 216.678,37.186 213.388,41.000 211.628 C 42.100 211.121,43.270 210.557,43.600 210.376 C 44.581 209.838,192.947 209.913,194.281 210.452 M244.040 255.640 C 246.886 256.559,248.063 257.307,250.493 259.741 C 253.043 262.293,254.927 265.475,255.385 268.000 C 255.524 268.770,255.742 270.010,255.869 270.756 C 256.768 276.025,252.149 283.944,246.628 286.600 L 243.672 288.021 168.926 288.036 L 94.181 288.051 91.260 286.548 C 85.152 283.406,82.000 278.242,82.000 271.375 C 82.000 269.325,82.160 267.549,82.355 267.428 C 82.550 267.307,82.829 266.622,82.976 265.904 C 83.751 262.119,88.696 257.456,93.800 255.698 C 95.542 255.098,242.189 255.041,244.040 255.640 M292.112 300.594 C 297.684 301.886,304.000 306.701,304.000 309.656 C 304.000 309.977,304.221 310.461,304.492 310.732 C 304.763 311.003,305.207 312.524,305.479 314.112 C 306.715 321.327,302.928 328.585,296.127 332.037 L 293.442 333.400 250.421 333.526 C 204.297 333.660,203.943 333.646,200.400 331.553 C 200.070 331.358,199.412 331.029,198.937 330.823 C 196.515 329.770,192.486 323.898,191.786 320.400 C 189.998 311.467,195.129 303.573,204.600 300.686 C 207.579 299.778,288.229 299.693,292.112 300.594 "
        stroke="none"
        // fill="#5d41d4" 
        fillRule="evenodd"
      >
      </path>
      <path id="path1"
        d="M66.800 71.877 C 66.030 71.966,64.833 72.299,64.140 72.619 C 63.446 72.938,62.759 73.200,62.612 73.200 C 61.667 73.200,56.014 78.057,56.003 78.877 C 56.002 79.030,55.595 79.838,55.100 80.674 C 50.613 88.252,54.545 99.882,62.800 103.448 C 66.544 105.066,63.273 104.996,139.400 105.079 C 219.919 105.165,216.493 105.276,219.513 102.500 C 219.812 102.225,220.230 102.000,220.442 102.000 C 221.596 102.000,224.970 97.539,226.211 94.372 C 227.264 91.684,227.674 84.340,226.800 83.800 C 226.580 83.664,226.400 83.284,226.400 82.954 C 226.400 80.557,221.830 75.024,218.555 73.456 C 217.700 73.046,216.640 72.506,216.200 72.256 C 215.436 71.821,70.497 71.454,66.800 71.877 M135.600 117.086 C 135.050 117.186,134.429 117.432,134.220 117.634 C 134.011 117.835,133.471 118.006,133.020 118.013 C 132.569 118.021,131.480 118.558,130.600 119.206 C 129.720 119.855,128.640 120.580,128.200 120.816 C 127.380 121.257,124.789 124.629,123.789 126.556 C 123.294 127.510,122.924 128.930,122.125 132.939 C 121.708 135.029,123.652 140.824,125.679 143.532 C 127.249 145.631,132.078 149.200,133.346 149.200 C 133.680 149.200,134.064 149.380,134.200 149.600 C 134.363 149.864,159.698 149.998,208.924 149.994 C 288.269 149.988,284.374 150.075,287.948 148.227 C 290.526 146.894,295.196 141.196,295.199 139.380 C 295.199 138.929,295.364 138.389,295.564 138.180 C 296.228 137.489,296.381 130.584,295.759 129.387 C 295.452 128.794,295.200 127.957,295.200 127.528 C 295.200 127.098,294.750 126.157,294.200 125.436 C 293.650 124.714,293.200 123.955,293.200 123.747 C 293.200 122.540,288.290 118.890,285.198 117.799 C 283.610 117.239,138.569 116.547,135.600 117.086 M94.400 162.597 C 81.722 166.107,77.666 181.456,86.994 190.630 C 88.770 192.378,90.243 193.390,92.232 194.230 L 95.000 195.400 169.200 195.400 L 243.400 195.400 245.200 194.505 C 249.966 192.134,254.000 188.371,254.000 186.295 C 254.000 185.967,254.247 185.493,254.549 185.243 C 254.850 184.992,255.212 184.025,255.353 183.094 C 255.493 182.162,255.718 180.710,255.852 179.867 C 256.945 172.986,250.883 164.683,243.200 162.538 C 240.585 161.808,97.045 161.865,94.400 162.597 M43.600 210.376 C 43.270 210.557,42.100 211.121,41.000 211.628 C 37.186 213.388,34.431 216.678,32.417 221.875 C 29.834 228.544,34.453 238.208,41.905 241.727 L 44.600 243.000 118.800 243.000 L 193.000 243.000 195.586 242.000 C 203.844 238.807,208.428 227.165,204.407 219.600 C 204.115 219.050,203.769 218.402,203.638 218.160 C 201.612 214.411,199.240 212.457,194.281 210.452 C 192.947 209.913,44.581 209.838,43.600 210.376 M93.800 255.698 C 88.696 257.456,83.751 262.119,82.976 265.904 C 82.829 266.622,82.550 267.307,82.355 267.428 C 82.160 267.549,82.000 269.325,82.000 271.375 C 82.000 274.998,82.208 275.916,83.832 279.476 C 84.918 281.854,88.189 284.968,91.260 286.548 L 94.181 288.051 168.926 288.036 L 243.672 288.021 246.628 286.600 C 252.149 283.944,256.768 276.025,255.869 270.756 C 255.742 270.010,255.524 268.770,255.385 268.000 C 254.927 265.475,253.043 262.293,250.493 259.741 C 248.063 257.307,246.886 256.559,244.040 255.640 C 242.189 255.041,95.542 255.098,93.800 255.698 M204.600 300.686 C 195.129 303.573,189.998 311.467,191.786 320.400 C 192.486 323.898,196.515 329.770,198.937 330.823 C 199.412 331.029,200.070 331.358,200.400 331.553 C 203.943 333.646,204.297 333.660,250.421 333.526 L 293.442 333.400 296.127 332.037 C 302.928 328.585,306.715 321.327,305.479 314.112 C 305.207 312.524,304.763 311.003,304.492 310.732 C 304.221 310.461,304.000 309.977,304.000 309.656 C 304.000 306.701,297.684 301.886,292.112 300.594 C 288.229 299.693,207.579 299.778,204.600 300.686 "
        stroke="none"
        // fill="#e9e8fb"
        fill="#5d41d4"
        fillRule="evenodd">
      </path>
    </g>
  </SvgIcon>
);

export const BarkIcon = (props: SvgIconProps) => (
  <SvgIcon {...props} viewBox="0 0 122 122">
    <path fill="currentColor" fillRule="evenodd" d="M1.773 8.882C0 12.362 0 16.916 0 26.027v69.946c0 9.111 0 13.666 1.773 17.145a16.27 16.27 0 0 0 7.109 7.109C12.362 122 16.916 122 26.027 122h69.946c9.111 0 13.666 0 17.145-1.773a16.27 16.27 0 0 0 7.109-7.109C122 109.639 122 105.084 122 95.973V26.027c0-9.11 0-13.666-1.773-17.145a16.27 16.27 0 0 0-7.109-7.109C109.639 0 105.084 0 95.973 0H26.027C16.917 0 12.36 0 8.882 1.773a16.27 16.27 0 0 0-7.109 7.109M105.733 61c0-24.705-12.517-44.733-27.958-44.733S49.817 36.295 49.817 61h-33.55c0 24.706 12.517 44.733 27.958 44.733S72.183 85.705 72.183 61z" clipRule="evenodd" />
  </SvgIcon>
);

export const AIIcon = (props: SvgIconProps) => (
  <SvgIcon {...props} viewBox="0 0 512 512">
    <g>
      <g>
        <path d="M434.863,126.093V77.137h-48.956V0h-33.391v77.137h-42.083V0h-33.391v77.137h-42.083V0h-33.391v77.137h-42.083V0h-33.391
			v77.137H77.137v48.956H0v33.391h77.137v42.083H0v33.391h77.137v42.083H0v33.391h77.137v42.083H0v33.391h77.137v48.956h48.956V512
			h33.391v-77.137h42.083V512h33.391v-77.137h42.083V512h33.391v-77.137h42.083V512h33.391v-77.137h48.956v-48.956H512v-33.391
			h-77.137v-42.083H512v-33.391h-77.137v-42.083H512v-33.391h-77.137v-42.083H512v-33.39H434.863z M401.473,401.471h-0.001H110.529
			V110.529h290.944V401.471z"/>
      </g>
    </g>
    <g>
      <g>
        <path d="M375.773,229.532c0-22.913-14.194-42.903-34.426-51.239c-1.374-26.935-23.718-48.426-50.987-48.426
			c-13.221,0-25.283,5.052-34.36,13.325c-9.077-8.273-21.139-13.325-34.36-13.325c-27.27,0-49.615,21.491-50.987,48.426
			c-20.234,8.336-34.426,28.326-34.426,51.239c0,9.577,2.445,18.593,6.742,26.459c-4.391,8.051-6.742,17.113-6.742,26.478
			c-0.001,23.125,14.25,42.974,34.428,51.253c1.381,26.928,23.722,48.411,50.986,48.411c13.221,0,25.283-5.052,34.36-13.325
			c9.077,8.273,21.139,13.325,34.36,13.325c27.265,0,49.606-21.483,50.986-48.411c20.176-8.28,34.428-28.129,34.428-51.253
			c0-9.366-2.351-18.428-6.742-26.478C373.328,248.124,375.773,239.108,375.773,229.532z M239.304,331.078
			c0,9.74-7.924,17.664-17.664,17.664c-7.943,0-14.674-5.271-16.889-12.497c10.656-2.612,20.43-8.341,27.914-16.604l-24.749-22.417
			c-4.226,4.667-10.018,7.237-16.308,7.237c-12.127,0-21.992-9.866-21.992-21.992c0-0.697,0.033-1.389,0.098-2.076
			c6.719,2.904,14.12,4.521,21.895,4.521v-33.391c-12.127,0-21.992-9.866-21.992-21.993c-0.001-7.907,4.25-14.938,10.63-18.817
			c5.774,8.031,13.85,14.415,23.463,18.021l11.727-31.264c-6.855-2.571-11.461-9.222-11.461-16.549
			c0-9.74,7.924-17.664,17.664-17.664c9.74,0,17.664,7.924,17.664,17.664V331.078z M342.285,280.393
			c0.065,0.687,0.098,1.379,0.098,2.076c0,12.127-9.866,21.992-21.993,21.992c-6.289,0-12.081-2.57-16.307-7.237l-24.748,22.417
			c7.485,8.263,17.258,13.993,27.914,16.604c-2.215,7.227-8.947,12.497-16.889,12.497c-9.74,0-17.664-7.924-17.664-17.664V180.922
			c0-9.74,7.924-17.664,17.664-17.664c9.739,0,17.664,7.924,17.664,17.664c0,7.327-4.606,13.978-11.461,16.549l11.727,31.264
			c9.613-3.606,17.688-9.991,23.463-18.021c6.38,3.879,10.631,10.911,10.631,18.817c0,12.127-9.866,21.993-21.993,21.993v33.391
			C328.164,284.915,335.566,283.297,342.285,280.393z"/>
      </g>
    </g>
  </SvgIcon>
);

export const AIAgentIcon = (props: SvgIconProps) => (
  <SvgIcon {...props} viewBox="0 0 400 400">
    <path d="M97.8357 54.6682C177.199 59.5311 213.038 52.9891 238.043 52.9891C261.298 52.9891 272.24 129.465 262.683 152.048C253.672 173.341 100.331 174.196 93.1919 165.763C84.9363 156.008 89.7095 115.275 89.7095 101.301" stroke="#000000" strokeOpacity="0.9" strokeWidth="16" strokeLinecap="round" strokeLinejoin="round" />
    <path d="M98.3318 190.694C-10.6597 291.485 121.25 273.498 148.233 295.083"
      stroke="#000000"
      strokeOpacity="0.9" strokeWidth="16" strokeLinecap="round" strokeLinejoin="round" />
    <path d="M98.3301 190.694C99.7917 213.702 101.164 265.697 100.263 272.898"
      stroke="#000000"
      strokeOpacity="0.9" strokeWidth="16" strokeLinecap="round" strokeLinejoin="round" />
    <path d="M208.308 136.239C208.308 131.959 208.308 127.678 208.308 123.396"
      stroke="#000000"
      strokeOpacity="0.9" strokeWidth="16" strokeLinecap="round" strokeLinejoin="round" />
    <path d="M177.299 137.271C177.035 133.883 177.3 126.121 177.3 123.396"
      stroke="#000000"
      strokeOpacity="0.9" strokeWidth="16" strokeLinecap="round" strokeLinejoin="round" />
    <path d="M203.398 241.72C352.097 239.921 374.881 226.73 312.524 341.851"
      stroke="#000000"
      strokeOpacity="0.9" strokeWidth="16" strokeLinecap="round" strokeLinejoin="round" />
    <path d="M285.55 345.448C196.81 341.85 136.851 374.229 178.223 264.504"
      stroke="#000000"
      strokeOpacity="0.9" strokeWidth="16" strokeLinecap="round" strokeLinejoin="round" />
    <path d="M180.018 345.448C160.77 331.385 139.302 320.213 120.658 304.675"
      stroke="#000000"
      strokeOpacity="0.9" strokeWidth="16" strokeLinecap="round" strokeLinejoin="round" />
    <path d="M218.395 190.156C219.024 205.562 219.594 220.898 219.594 236.324"
      stroke="#000000"
      strokeOpacity="0.9" strokeWidth="16" strokeLinecap="round" strokeLinejoin="round" />
    <path d="M218.395 190.156C225.896 202.037 232.97 209.77 241.777 230.327"
      stroke="#000000"
      strokeOpacity="0.9" strokeWidth="16" strokeLinecap="round" strokeLinejoin="round" />
    <path d="M80.1174 119.041C75.5996 120.222 71.0489 119.99 66.4414 120.41"
      stroke="#000000"
      strokeOpacity="0.9" strokeWidth="16" strokeLinecap="round" strokeLinejoin="round" />
    <path d="M59.5935 109.469C59.6539 117.756 59.5918 125.915 58.9102 134.086"
      stroke="#000000"
      strokeOpacity="0.9" strokeWidth="16" strokeLinecap="round" strokeLinejoin="round" />
    <path d="M277.741 115.622C281.155 115.268 284.589 114.823 287.997 114.255"
      stroke="#000000"
      strokeOpacity="0.9" strokeWidth="16" strokeLinecap="round" strokeLinejoin="round" />
    <path d="M291.412 104.682C292.382 110.109 292.095 115.612 292.095 121.093"
      stroke="#000000"
      strokeOpacity="0.9" strokeWidth="16" strokeLinecap="round" strokeLinejoin="round" />
    <path d="M225.768 116.466C203.362 113.993 181.657 115.175 160.124 118.568"
      stroke="#000000"
      strokeOpacity="0.9" strokeWidth="16" strokeLinecap="round" strokeLinejoin="round" />
  </SvgIcon>
);