import {
    Language,
    Book,
    LocalMovies,
    Movie,
    Album,
    MusicNote,
    Group,
    Article,
    Lightbulb,
    Tv,
    SportsEsports,
    Person,
    Place,
    Biotech,
    Memory,
    Science,
    Sports,
    Business,
    School,
    AccountBalance,
    Store,
    LocationOn,
    Event,
    Help,
} from '@mui/icons-material';
import { ReferenceCategoryType } from '../types/EntityReferenceTypes';

export const referenceCategoryToIcon: Record<ReferenceCategoryType, React.ReactElement> = {
    [ReferenceCategoryType.URL]: <Language/>,
    [ReferenceCategoryType.WEBSITE]: <Language/>,
    [ReferenceCategoryType.WORK]: <Article/>,
    [ReferenceCategoryType.BOOK]: <Book/>,
    [ReferenceCategoryType.BOOK_SERIES]: <Book/>,
    [ReferenceCategoryType.MOVIE]: <LocalMovies/>,
    [ReferenceCategoryType.MOVIE_SERIES]: <Movie/>,
    [ReferenceCategoryType.MUSIC_ALBUM]: <Album/>,
    [ReferenceCategoryType.MUSIC_GROUP]: <Group/>,
    [ReferenceCategoryType.MUSIC_RECORDING]: <MusicNote/>,
    [ReferenceCategoryType.PERIODICAL]: <Article/>,
    [ReferenceCategoryType.CONCEPT]: <Lightbulb/>,
    [ReferenceCategoryType.TV_SERIES]: <Tv/>,
    [ReferenceCategoryType.TV_EPISODE]: <Tv/>,
    [ReferenceCategoryType.VIDEO_GAME]: <SportsEsports/>,
    [ReferenceCategoryType.VIDEO_GAME_SERIES]: <SportsEsports/>,
    [ReferenceCategoryType.PERSON]: <Person/>,
    [ReferenceCategoryType.PLACE]: <Place/>,
    [ReferenceCategoryType.BIOLOGICAL_ENTITY]: <Biotech/>,
    [ReferenceCategoryType.TECHNOLOGY]: <Memory/>,
    [ReferenceCategoryType.NATURAL_PHENOMENON]: <Science/>,
    [ReferenceCategoryType.SPORTS_TEAM]: <Sports/>,
    [ReferenceCategoryType.ORGANIZATION]: <Business/>,
    [ReferenceCategoryType.EDUCATIONAL_ORGANIZATION]: <School/>,
    [ReferenceCategoryType.GOVERNMENT_ORGANIZATION]: <AccountBalance/>,
    [ReferenceCategoryType.LOCAL_BUSINESS]: <Store/>,
    [ReferenceCategoryType.LOCATION]: <LocationOn/>,
    [ReferenceCategoryType.EVENT]: <Event/>,
    [ReferenceCategoryType.OTHER]: <Help/>,
};