import sys
from pathlib import Path
current_dir = Path(__file__).parent.absolute()
parent_dir = current_dir.parent
if parent_dir not in sys.path:
    sys.path.insert(0, str(parent_dir))


from workflow.util.logger import LOGGER
from workflow.test.test_utils import TestOutputHandler, TestOutputConfig
from workflow.util.web_scrape_utils import apply_parsing_strategy

inputs = {
  "selectors": [
    "#content h2",
    "#content h3",
    "#content h4",
    "#content p",
    "#content ul",
    "#content ol",
    "#content table",
    "#content blockquote",
    "#content figure",
    "div.mw-heading h2",
    "div.mw-heading h3",
    "div.mw-heading h4",
    "p",
    "table.wikitable.sortable",
    "li .reference-text",
    "cite.citation",
    "span.reference-text",
    "a.external.text",
    "span.Z3988",
    "main h1",
    "main h2",
    "main h3",
    "main p",
    "main ul",
    "main ol",
    "main table"
  ],
  "original_content": "<!DOCTYPE html>\n\n<html class=\"client-nojs vector-feature-language-in-header-enabled vector-feature-language-in-main-page-header-disabled vector-feature-sticky-header-disabled vector-feature-page-tools-pinned-disabled vector-feature-toc-pinned-clientpref-1 vector-feature-main-menu-pinned-disabled vector-feature-limited-width-clientpref-1 vector-feature-limited-width-content-enabled vector-feature-custom-font-size-clientpref-1 vector-feature-appearance-pinned-clientpref-1 vector-feature-night-mode-enabled skin-theme-clientpref-day vector-toc-available\" dir=\"ltr\" lang=\"en\">\n<head>\n<meta charset=\"utf-8\"/>\n<title>Large language model - Wikipedia</title>\n\n\n<link href=\"/w/load.php?lang=en&amp;modules=ext.cite.styles%7Cext.math.styles%7Cext.uls.interlanguage%7Cext.visualEditor.desktopArticleTarget.noscript%7Cext.wikimediaBadges%7Cext.wikimediamessages.styles%7Cjquery.makeCollapsible.styles%7Cjquery.tablesorter.styles%7Cskins.vector.icons%2Cstyles%7Cskins.vector.search.codex.styles%7Cwikibase.client.init&amp;only=styles&amp;skin=vector-2022\" rel=\"stylesheet\"/>\n\n<meta content=\"\" name=\"ResourceLoaderDynamicStyles\"/>\n<link href=\"/w/load.php?lang=en&amp;modules=site.styles&amp;only=styles&amp;skin=vector-2022\" rel=\"stylesheet\"/>\n<meta content=\"MediaWiki 1.44.0-wmf.6\" name=\"generator\"/>\n<meta content=\"origin\" name=\"referrer\"/>\n<meta content=\"origin-when-cross-origin\" name=\"referrer\"/>\n<meta content=\"max-image-preview:standard\" name=\"robots\"/>\n<meta content=\"telephone=no\" name=\"format-detection\"/>\n<meta content=\"width=1120\" name=\"viewport\"/>\n<meta content=\"Large language model - Wikipedia\" property=\"og:title\"/>\n<meta content=\"website\" property=\"og:type\"/>\n<link href=\"//upload.wikimedia.org\" rel=\"preconnect\"/>\n<link href=\"//en.m.wikipedia.org/wiki/Large_language_model\" media=\"only screen and (max-width: 640px)\" rel=\"alternate\"/>\n<link href=\"/w/index.php?title=Large_language_model&amp;action=edit\" rel=\"alternate\" title=\"Edit this page\" type=\"application/x-wiki\"/>\n<link href=\"/static/apple-touch/wikipedia.png\" rel=\"apple-touch-icon\"/>\n<link href=\"/static/favicon/wikipedia.ico\" rel=\"icon\"/>\n<link href=\"/w/rest.php/v1/search\" rel=\"search\" title=\"Wikipedia (en)\" type=\"application/opensearchdescription+xml\"/>\n<link href=\"//en.wikipedia.org/w/api.php?action=rsd\" rel=\"EditURI\" type=\"application/rsd+xml\"/>\n<link href=\"https://en.wikipedia.org/wiki/Large_language_model\" rel=\"canonical\"/>\n<link href=\"https://creativecommons.org/licenses/by-sa/4.0/deed.en\" rel=\"license\"/>\n<link href=\"/w/index.php?title=Special:RecentChanges&amp;feed=atom\" rel=\"alternate\" title=\"Wikipedia Atom feed\" type=\"application/atom+xml\"/>\n<link href=\"//meta.wikimedia.org\" rel=\"dns-prefetch\">\n<link href=\"login.wikimedia.org\" rel=\"dns-prefetch\"/>\n</link></head>\n<body class=\"skin--responsive skin-vector skin-vector-search-vue mediawiki ltr sitedir-ltr mw-hide-empty-elt ns-0 ns-subject mw-editable page-Large_language_model rootpage-Large_language_model skin-vector-2022 action-view\"><a class=\"mw-jump-link\" href=\"#bodyContent\">Jump to content</a>\n<div class=\"vector-header-container\">\n\n</div>\n<div class=\"mw-page-container\">\n<div class=\"mw-page-container-inner\">\n<div class=\"vector-sitenotice-container\">\n<div id=\"siteNotice\"><!-- CentralNotice --></div>\n</div>\n<div class=\"vector-column-start\">\n<div class=\"vector-main-menu-container\">\n<div id=\"mw-navigation\">\n\n</div>\n</div>\n<div class=\"vector-sticky-pinned-container\">\n\n</div>\n</div>\n<div class=\"mw-content-container\">\n<main class=\"mw-body\" id=\"content\">\n\n<div class=\"vector-page-toolbar\">\n<div class=\"vector-page-toolbar-container\">\n<div id=\"left-navigation\">\n\n</div>\n<div class=\"vector-collapsible\" id=\"right-navigation\">\n\n\n</div>\n</div>\n</div>\n<div class=\"vector-column-end\">\n<div class=\"vector-sticky-pinned-container\">\n\n\n</div>\n</div>\n<div aria-labelledby=\"firstHeading\" class=\"vector-body\" data-mw-ve-target-container=\"\" id=\"bodyContent\">\n<div class=\"vector-body-before-content\">\n<div class=\"mw-indicators\">\n</div>\n<div class=\"noprint\" id=\"siteSub\">From Wikipedia, the free encyclopedia</div>\n</div>\n<div id=\"contentSub\"><div id=\"mw-content-subtitle\"></div></div>\n<div class=\"mw-body-content\" id=\"mw-content-text\"><div class=\"mw-content-ltr mw-parser-output\" dir=\"ltr\" lang=\"en\"><div class=\"shortdescription nomobile noexcerpt noprint searchaux\" style=\"display:none\">Type of artificial neural network</div>\n<div class=\"hatnote navigation-not-searchable\" role=\"note\">Not to be confused with <a href=\"/wiki/Logic_learning_machine\" title=\"Logic learning machine\">Logic learning machine</a>.</div>\n\n<link href=\"mw-data:TemplateStyles:r886047488\" rel=\"mw-deduplicated-inline-style\"/><table class=\"sidebar sidebar-collapse nomobile nowraplinks\"><tbody><tr><td class=\"sidebar-pretitle\">Part of a series on</td></tr><tr><th class=\"sidebar-title-with-pretitle\"><a href=\"/wiki/Machine_learning\" title=\"Machine learning\">Machine learning</a><br/>and <a href=\"/wiki/Data_mining\" title=\"Data mining\">data mining</a></th></tr><tr><td class=\"sidebar-content\">\n<div class=\"sidebar-list mw-collapsible mw-collapsed machine-learning-list-title\"><div class=\"sidebar-list-title\" style=\"border-top:1px solid #aaa; text-align:center;;color: var(--color-base)\">Paradigms</div><div class=\"sidebar-list-content mw-collapsible-content hlist\">\n<ul><li><a href=\"/wiki/Supervised_learning\" title=\"Supervised learning\">Supervised learning</a></li>\n<li><a href=\"/wiki/Unsupervised_learning\" title=\"Unsupervised learning\">Unsupervised learning</a></li>\n<li><a class=\"mw-redirect\" href=\"/wiki/Semi-supervised_learning\" title=\"Semi-supervised learning\">Semi-supervised learning</a></li>\n<li><a href=\"/wiki/Self-supervised_learning\" title=\"Self-supervised learning\">Self-supervised learning</a></li>\n<li><a href=\"/wiki/Reinforcement_learning\" title=\"Reinforcement learning\">Reinforcement learning</a></li>\n<li><a href=\"/wiki/Meta-learning_(computer_science)\" title=\"Meta-learning (computer science)\">Meta-learning</a></li>\n<li><a href=\"/wiki/Online_machine_learning\" title=\"Online machine learning\">Online learning</a></li>\n<li><a class=\"mw-redirect\" href=\"/wiki/Batch_learning\" title=\"Batch learning\">Batch learning</a></li>\n<li><a href=\"/wiki/Curriculum_learning\" title=\"Curriculum learning\">Curriculum learning</a></li>\n<li><a href=\"/wiki/Rule-based_machine_learning\" title=\"Rule-based machine learning\">Rule-based learning</a></li>\n<li><a href=\"/wiki/Neuro-symbolic_AI\" title=\"Neuro-symbolic AI\">Neuro-symbolic AI</a></li>\n<li><a class=\"mw-redirect\" href=\"/wiki/Neuromorphic_engineering\" title=\"Neuromorphic engineering\">Neuromorphic engineering</a></li>\n<li><a href=\"/wiki/Quantum_machine_learning\" title=\"Quantum machine learning\">Quantum machine learning</a></li></ul></div></div></td>\n</tr><tr><td class=\"sidebar-content\">\n<div class=\"sidebar-list mw-collapsible mw-collapsed machine-learning-list-title\"><div class=\"sidebar-list-title\" style=\"border-top:1px solid #aaa; text-align:center;;color: var(--color-base)\">Problems</div><div class=\"sidebar-list-content mw-collapsible-content hlist\">\n<ul><li><a href=\"/wiki/Statistical_classification\" title=\"Statistical classification\">Classification</a></li>\n<li><a href=\"/wiki/Generative_model\" title=\"Generative model\">Generative modeling</a></li>\n<li><a href=\"/wiki/Regression_analysis\" title=\"Regression analysis\">Regression</a></li>\n<li><a href=\"/wiki/Cluster_analysis\" title=\"Cluster analysis\">Clustering</a></li>\n<li><a href=\"/wiki/Dimensionality_reduction\" title=\"Dimensionality reduction\">Dimensionality reduction</a></li>\n<li><a href=\"/wiki/Density_estimation\" title=\"Density estimation\">Density estimation</a></li>\n<li><a href=\"/wiki/Anomaly_detection\" title=\"Anomaly detection\">Anomaly detection</a></li>\n<li><a class=\"mw-redirect\" href=\"/wiki/Data_cleaning\" title=\"Data cleaning\">Data cleaning</a></li>\n<li><a href=\"/wiki/Automated_machine_learning\" title=\"Automated machine learning\">AutoML</a></li>\n<li><a href=\"/wiki/Association_rule_learning\" title=\"Association rule learning\">Association rules</a></li>\n<li><a href=\"/wiki/Semantic_analysis_(machine_learning)\" title=\"Semantic analysis (machine learning)\">Semantic analysis</a></li>\n<li><a href=\"/wiki/Structured_prediction\" title=\"Structured prediction\">Structured prediction</a></li>\n<li><a href=\"/wiki/Feature_engineering\" title=\"Feature engineering\">Feature engineering</a></li>\n<li><a href=\"/wiki/Feature_learning\" title=\"Feature learning\">Feature learning</a></li>\n<li><a href=\"/wiki/Learning_to_rank\" title=\"Learning to rank\">Learning to rank</a></li>\n<li><a href=\"/wiki/Grammar_induction\" title=\"Grammar induction\">Grammar induction</a></li>\n<li><a href=\"/wiki/Ontology_learning\" title=\"Ontology learning\">Ontology learning</a></li>\n<li><a href=\"/wiki/Multimodal_learning\" title=\"Multimodal learning\">Multimodal learning</a></li></ul></div></div></td>\n</tr><tr><td class=\"sidebar-content\">\n<div class=\"sidebar-list mw-collapsible mw-collapsed machine-learning-list-title\"><div class=\"sidebar-list-title\" style=\"border-top:1px solid #aaa; text-align:center;;color: var(--color-base)\"><div style=\"display: inline-block; line-height: 1.2em; padding: .1em 0;\"><a href=\"/wiki/Supervised_learning\" title=\"Supervised learning\">Supervised learning</a><br/><span class=\"nobold\"><span style=\"font-size:85%;\">(<b><a href=\"/wiki/Statistical_classification\" title=\"Statistical classification\">classification</a></b> • <b><a href=\"/wiki/Regression_analysis\" title=\"Regression analysis\">regression</a></b>)</span></span> </div></div><div class=\"sidebar-list-content mw-collapsible-content hlist\">\n<ul><li><a href=\"/wiki/Apprenticeship_learning\" title=\"Apprenticeship learning\">Apprenticeship learning</a></li>\n<li><a href=\"/wiki/Decision_tree_learning\" title=\"Decision tree learning\">Decision trees</a></li>\n<li><a href=\"/wiki/Ensemble_learning\" title=\"Ensemble learning\">Ensembles</a>\n<ul><li><a href=\"/wiki/Bootstrap_aggregating\" title=\"Bootstrap aggregating\">Bagging</a></li>\n<li><a href=\"/wiki/Boosting_(machine_learning)\" title=\"Boosting (machine learning)\">Boosting</a></li>\n<li><a href=\"/wiki/Random_forest\" title=\"Random forest\">Random forest</a></li></ul></li>\n<li><a href=\"/wiki/K-nearest_neighbors_algorithm\" title=\"K-nearest neighbors algorithm\"><i>k</i>-NN</a></li>\n<li><a href=\"/wiki/Linear_regression\" title=\"Linear regression\">Linear regression</a></li>\n<li><a href=\"/wiki/Naive_Bayes_classifier\" title=\"Naive Bayes classifier\">Naive Bayes</a></li>\n<li><a class=\"mw-redirect\" href=\"/wiki/Artificial_neural_network\" title=\"Artificial neural network\">Artificial neural networks</a></li>\n<li><a href=\"/wiki/Logistic_regression\" title=\"Logistic regression\">Logistic regression</a></li>\n<li><a href=\"/wiki/Perceptron\" title=\"Perceptron\">Perceptron</a></li>\n<li><a href=\"/wiki/Relevance_vector_machine\" title=\"Relevance vector machine\">Relevance vector machine (RVM)</a></li>\n<li><a href=\"/wiki/Support_vector_machine\" title=\"Support vector machine\">Support vector machine (SVM)</a></li></ul></div></div></td>\n</tr><tr><td class=\"sidebar-content\">\n<div class=\"sidebar-list mw-collapsible mw-collapsed machine-learning-list-title\"><div class=\"sidebar-list-title\" style=\"border-top:1px solid #aaa; text-align:center;;color: var(--color-base)\"><a href=\"/wiki/Cluster_analysis\" title=\"Cluster analysis\">Clustering</a></div><div class=\"sidebar-list-content mw-collapsible-content hlist\">\n<ul><li><a href=\"/wiki/BIRCH\" title=\"BIRCH\">BIRCH</a></li>\n<li><a href=\"/wiki/CURE_algorithm\" title=\"CURE algorithm\">CURE</a></li>\n<li><a href=\"/wiki/Hierarchical_clustering\" title=\"Hierarchical clustering\">Hierarchical</a></li>\n<li><a href=\"/wiki/K-means_clustering\" title=\"K-means clustering\"><i>k</i>-means</a></li>\n<li><a href=\"/wiki/Fuzzy_clustering\" title=\"Fuzzy clustering\">Fuzzy</a></li>\n<li><a href=\"/wiki/Expectation%E2%80%93maximization_algorithm\" title=\"Expectation–maximization algorithm\">Expectation–maximization (EM)</a></li>\n<li><br/><a href=\"/wiki/DBSCAN\" title=\"DBSCAN\">DBSCAN</a></li>\n<li><a href=\"/wiki/OPTICS_algorithm\" title=\"OPTICS algorithm\">OPTICS</a></li>\n<li><a href=\"/wiki/Mean_shift\" title=\"Mean shift\">Mean shift</a></li></ul></div></div></td>\n</tr><tr><td class=\"sidebar-content\">\n<div class=\"sidebar-list mw-collapsible mw-collapsed machine-learning-list-title\"><div class=\"sidebar-list-title\" style=\"border-top:1px solid #aaa; text-align:center;;color: var(--color-base)\"><a href=\"/wiki/Dimensionality_reduction\" title=\"Dimensionality reduction\">Dimensionality reduction</a></div><div class=\"sidebar-list-content mw-collapsible-content hlist\">\n<ul><li><a href=\"/wiki/Factor_analysis\" title=\"Factor analysis\">Factor analysis</a></li>\n<li><a href=\"/wiki/Canonical_correlation\" title=\"Canonical correlation\">CCA</a></li>\n<li><a href=\"/wiki/Independent_component_analysis\" title=\"Independent component analysis\">ICA</a></li>\n<li><a href=\"/wiki/Linear_discriminant_analysis\" title=\"Linear discriminant analysis\">LDA</a></li>\n<li><a href=\"/wiki/Non-negative_matrix_factorization\" title=\"Non-negative matrix factorization\">NMF</a></li>\n<li><a href=\"/wiki/Principal_component_analysis\" title=\"Principal component analysis\">PCA</a></li>\n<li><a href=\"/wiki/Proper_generalized_decomposition\" title=\"Proper generalized decomposition\">PGD</a></li>\n<li><a href=\"/wiki/T-distributed_stochastic_neighbor_embedding\" title=\"T-distributed stochastic neighbor embedding\">t-SNE</a></li>\n<li><a href=\"/wiki/Sparse_dictionary_learning\" title=\"Sparse dictionary learning\">SDL</a></li></ul></div></div></td>\n</tr><tr><td class=\"sidebar-content\">\n<div class=\"sidebar-list mw-collapsible mw-collapsed machine-learning-list-title\"><div class=\"sidebar-list-title\" style=\"border-top:1px solid #aaa; text-align:center;;color: var(--color-base)\"><a href=\"/wiki/Structured_prediction\" title=\"Structured prediction\">Structured prediction</a></div><div class=\"sidebar-list-content mw-collapsible-content hlist\">\n<ul><li><a href=\"/wiki/Graphical_model\" title=\"Graphical model\">Graphical models</a>\n<ul><li><a href=\"/wiki/Bayesian_network\" title=\"Bayesian network\">Bayes net</a></li>\n<li><a href=\"/wiki/Conditional_random_field\" title=\"Conditional random field\">Conditional random field</a></li>\n<li><a href=\"/wiki/Hidden_Markov_model\" title=\"Hidden Markov model\">Hidden Markov</a></li></ul></li></ul></div></div></td>\n</tr><tr><td class=\"sidebar-content\">\n<div class=\"sidebar-list mw-collapsible mw-collapsed machine-learning-list-title\"><div class=\"sidebar-list-title\" style=\"border-top:1px solid #aaa; text-align:center;;color: var(--color-base)\"><a href=\"/wiki/Anomaly_detection\" title=\"Anomaly detection\">Anomaly detection</a></div><div class=\"sidebar-list-content mw-collapsible-content hlist\">\n<ul><li><a href=\"/wiki/Random_sample_consensus\" title=\"Random sample consensus\">RANSAC</a></li>\n<li><a href=\"/wiki/K-nearest_neighbors_algorithm\" title=\"K-nearest neighbors algorithm\"><i>k</i>-NN</a></li>\n<li><a href=\"/wiki/Local_outlier_factor\" title=\"Local outlier factor\">Local outlier factor</a></li>\n<li><a href=\"/wiki/Isolation_forest\" title=\"Isolation forest\">Isolation forest</a></li></ul></div></div></td>\n</tr><tr><td class=\"sidebar-content\">\n<div class=\"sidebar-list mw-collapsible machine-learning-list-title\"><div class=\"sidebar-list-title\" style=\"border-top:1px solid #aaa; text-align:center;;color: var(--color-base)\"><a class=\"mw-redirect\" href=\"/wiki/Artificial_neural_network\" title=\"Artificial neural network\">Artificial neural network</a></div><div class=\"sidebar-list-content mw-collapsible-content hlist\">\n<ul><li><a href=\"/wiki/Autoencoder\" title=\"Autoencoder\">Autoencoder</a></li>\n<li><a href=\"/wiki/Deep_learning\" title=\"Deep learning\">Deep learning</a></li>\n<li><a href=\"/wiki/Feedforward_neural_network\" title=\"Feedforward neural network\">Feedforward neural network</a></li>\n<li><a href=\"/wiki/Recurrent_neural_network\" title=\"Recurrent neural network\">Recurrent neural network</a>\n<ul><li><a href=\"/wiki/Long_short-term_memory\" title=\"Long short-term memory\">LSTM</a></li>\n<li><a href=\"/wiki/Gated_recurrent_unit\" title=\"Gated recurrent unit\">GRU</a></li>\n<li><a href=\"/wiki/Echo_state_network\" title=\"Echo state network\">ESN</a></li>\n<li><a href=\"/wiki/Reservoir_computing\" title=\"Reservoir computing\">reservoir computing</a></li></ul></li>\n<li><a href=\"/wiki/Boltzmann_machine\" title=\"Boltzmann machine\">Boltzmann machine</a>\n<ul><li><a href=\"/wiki/Restricted_Boltzmann_machine\" title=\"Restricted Boltzmann machine\">Restricted</a></li></ul></li>\n<li><a href=\"/wiki/Generative_adversarial_network\" title=\"Generative adversarial network\">GAN</a></li>\n<li><a href=\"/wiki/Diffusion_model\" title=\"Diffusion model\">Diffusion model</a></li>\n<li><a href=\"/wiki/Self-organizing_map\" title=\"Self-organizing map\">SOM</a></li>\n<li><a href=\"/wiki/Convolutional_neural_network\" title=\"Convolutional neural network\">Convolutional neural network</a>\n<ul><li><a href=\"/wiki/U-Net\" title=\"U-Net\">U-Net</a></li>\n<li><a href=\"/wiki/LeNet\" title=\"LeNet\">LeNet</a></li>\n<li><a href=\"/wiki/AlexNet\" title=\"AlexNet\">AlexNet</a></li>\n<li><a href=\"/wiki/DeepDream\" title=\"DeepDream\">DeepDream</a></li></ul></li>\n<li><a href=\"/wiki/Neural_radiance_field\" title=\"Neural radiance field\">Neural radiance field</a></li>\n<li><a class=\"mw-redirect\" href=\"/wiki/Transformer_(machine_learning_model)\" title=\"Transformer (machine learning model)\">Transformer</a>\n<ul><li><a href=\"/wiki/Vision_transformer\" title=\"Vision transformer\">Vision</a></li></ul></li>\n<li><a href=\"/wiki/Mamba_(deep_learning_architecture)\" title=\"Mamba (deep learning architecture)\">Mamba</a></li>\n<li><a href=\"/wiki/Spiking_neural_network\" title=\"Spiking neural network\">Spiking neural network</a></li>\n<li><a href=\"/wiki/Memtransistor\" title=\"Memtransistor\">Memtransistor</a></li>\n<li><a href=\"/wiki/Electrochemical_RAM\" title=\"Electrochemical RAM\">Electrochemical RAM</a> (ECRAM)</li></ul></div></div></td>\n</tr><tr><td class=\"sidebar-content\">\n<div class=\"sidebar-list mw-collapsible mw-collapsed machine-learning-list-title\"><div class=\"sidebar-list-title\" style=\"border-top:1px solid #aaa; text-align:center;;color: var(--color-base)\"><a href=\"/wiki/Reinforcement_learning\" title=\"Reinforcement learning\">Reinforcement learning</a></div><div class=\"sidebar-list-content mw-collapsible-content hlist\">\n<ul><li><a href=\"/wiki/Q-learning\" title=\"Q-learning\">Q-learning</a></li>\n<li><a href=\"/wiki/State%E2%80%93action%E2%80%93reward%E2%80%93state%E2%80%93action\" title=\"State–action–reward–state–action\">SARSA</a></li>\n<li><a href=\"/wiki/Temporal_difference_learning\" title=\"Temporal difference learning\">Temporal difference (TD)</a></li>\n<li><a href=\"/wiki/Multi-agent_reinforcement_learning\" title=\"Multi-agent reinforcement learning\">Multi-agent</a>\n<ul><li><a class=\"mw-redirect\" href=\"/wiki/Self-play_(reinforcement_learning_technique)\" title=\"Self-play (reinforcement learning technique)\">Self-play</a></li></ul></li></ul></div></div></td>\n</tr><tr><td class=\"sidebar-content\">\n<div class=\"sidebar-list mw-collapsible mw-collapsed machine-learning-list-title\"><div class=\"sidebar-list-title\" style=\"border-top:1px solid #aaa; text-align:center;;color: var(--color-base)\">Learning with humans</div><div class=\"sidebar-list-content mw-collapsible-content hlist\">\n<ul><li><a href=\"/wiki/Active_learning_(machine_learning)\" title=\"Active learning (machine learning)\">Active learning</a></li>\n<li><a href=\"/wiki/Crowdsourcing\" title=\"Crowdsourcing\">Crowdsourcing</a></li>\n<li><a href=\"/wiki/Human-in-the-loop\" title=\"Human-in-the-loop\">Human-in-the-loop</a></li>\n<li><a href=\"/wiki/Reinforcement_learning_from_human_feedback\" title=\"Reinforcement learning from human feedback\">RLHF</a></li></ul></div></div></td>\n</tr><tr><td class=\"sidebar-content\">\n<div class=\"sidebar-list mw-collapsible mw-collapsed machine-learning-list-title\"><div class=\"sidebar-list-title\" style=\"border-top:1px solid #aaa; text-align:center;;color: var(--color-base)\">Model diagnostics</div><div class=\"sidebar-list-content mw-collapsible-content hlist\">\n<ul><li><a href=\"/wiki/Coefficient_of_determination\" title=\"Coefficient of determination\">Coefficient of determination</a></li>\n<li><a href=\"/wiki/Confusion_matrix\" title=\"Confusion matrix\">Confusion matrix</a></li>\n<li><a href=\"/wiki/Learning_curve_(machine_learning)\" title=\"Learning curve (machine learning)\">Learning curve</a></li>\n<li><a href=\"/wiki/Receiver_operating_characteristic\" title=\"Receiver operating characteristic\">ROC curve</a></li></ul></div></div></td>\n</tr><tr><td class=\"sidebar-content\">\n<div class=\"sidebar-list mw-collapsible mw-collapsed machine-learning-list-title\"><div class=\"sidebar-list-title\" style=\"border-top:1px solid #aaa; text-align:center;;color: var(--color-base)\">Mathematical foundations</div><div class=\"sidebar-list-content mw-collapsible-content hlist\">\n<ul><li><a class=\"mw-redirect\" href=\"/wiki/Kernel_machines\" title=\"Kernel machines\">Kernel machines</a></li>\n<li><a href=\"/wiki/Bias%E2%80%93variance_tradeoff\" title=\"Bias–variance tradeoff\">Bias–variance tradeoff</a></li>\n<li><a href=\"/wiki/Computational_learning_theory\" title=\"Computational learning theory\">Computational learning theory</a></li>\n<li><a href=\"/wiki/Empirical_risk_minimization\" title=\"Empirical risk minimization\">Empirical risk minimization</a></li>\n<li><a href=\"/wiki/Occam_learning\" title=\"Occam learning\">Occam learning</a></li>\n<li><a href=\"/wiki/Probably_approximately_correct_learning\" title=\"Probably approximately correct learning\">PAC learning</a></li>\n<li><a href=\"/wiki/Statistical_learning_theory\" title=\"Statistical learning theory\">Statistical learning</a></li>\n<li><a href=\"/wiki/Vapnik%E2%80%93Chervonenkis_theory\" title=\"Vapnik–Chervonenkis theory\">VC theory</a></li></ul></div></div></td>\n</tr><tr><td class=\"sidebar-content\">\n<div class=\"sidebar-list mw-collapsible mw-collapsed machine-learning-list-title\"><div class=\"sidebar-list-title\" style=\"border-top:1px solid #aaa; text-align:center;;color: var(--color-base)\">Journals and conferences</div><div class=\"sidebar-list-content mw-collapsible-content hlist\">\n<ul><li><a href=\"/wiki/ECML_PKDD\" title=\"ECML PKDD\">ECML PKDD</a></li>\n<li><a href=\"/wiki/Conference_on_Neural_Information_Processing_Systems\" title=\"Conference on Neural Information Processing Systems\">NeurIPS</a></li>\n<li><a href=\"/wiki/International_Conference_on_Machine_Learning\" title=\"International Conference on Machine Learning\">ICML</a></li>\n<li><a href=\"/wiki/International_Conference_on_Learning_Representations\" title=\"International Conference on Learning Representations\">ICLR</a></li>\n<li><a href=\"/wiki/International_Joint_Conference_on_Artificial_Intelligence\" title=\"International Joint Conference on Artificial Intelligence\">IJCAI</a></li>\n<li><a href=\"/wiki/Machine_Learning_(journal)\" title=\"Machine Learning (journal)\">ML</a></li>\n<li><a href=\"/wiki/Journal_of_Machine_Learning_Research\" title=\"Journal of Machine Learning Research\">JMLR</a></li></ul></div></div></td>\n</tr><tr><td class=\"sidebar-content\">\n<div class=\"sidebar-list mw-collapsible mw-collapsed machine-learning-list-title\"><div class=\"sidebar-list-title\" style=\"border-top:1px solid #aaa; text-align:center;;color: var(--color-base)\">Related articles</div><div class=\"sidebar-list-content mw-collapsible-content hlist\">\n<ul><li><a href=\"/wiki/Glossary_of_artificial_intelligence\" title=\"Glossary of artificial intelligence\">Glossary of artificial intelligence</a></li>\n<li><a href=\"/wiki/List_of_datasets_for_machine-learning_research\" title=\"List of datasets for machine-learning research\">List of datasets for machine-learning research</a>\n<ul><li><a href=\"/wiki/List_of_datasets_in_computer_vision_and_image_processing\" title=\"List of datasets in computer vision and image processing\">List of datasets in computer vision and image processing</a></li></ul></li>\n<li><a href=\"/wiki/Outline_of_machine_learning\" title=\"Outline of machine learning\">Outline of machine learning</a></li></ul></div></div></td>\n</tr><tr><td class=\"sidebar-navbar\"><link href=\"mw-data:TemplateStyles:r1129693374\" rel=\"mw-deduplicated-inline-style\"/><div class=\"navbar plainlinks hlist navbar-mini\"><ul><li class=\"nv-view\"><a href=\"/wiki/Template:Machine_learning\" title=\"Template:Machine learning\"><abbr title=\"View this template\">v</abbr></a></li><li class=\"nv-talk\"><a href=\"/wiki/Template_talk:Machine_learning\" title=\"Template talk:Machine learning\"><abbr title=\"Discuss this template\">t</abbr></a></li><li class=\"nv-edit\"><a href=\"/wiki/Special:EditPage/Template:Machine_learning\" title=\"Special:EditPage/Template:Machine learning\"><abbr title=\"Edit this template\">e</abbr></a></li></ul></div></td></tr></tbody></table>\n<p>A <b>large language model</b> (<b>LLM</b>) is a type of computational <a href=\"/wiki/Model#Conceptual_model\" title=\"Model\">model</a> designed for <a href=\"/wiki/Natural_language_processing\" title=\"Natural language processing\">natural language processing</a> tasks such as language <a href=\"/wiki/Generative_artificial_intelligence\" title=\"Generative artificial intelligence\">generation</a>. As <a href=\"/wiki/Language_model\" title=\"Language model\">language models</a>, LLMs acquire these abilities by <a href=\"/wiki/Machine_learning\" title=\"Machine learning\">learning statistical relationships</a> from vast amounts of text during a <a href=\"/wiki/Self-supervised_learning\" title=\"Self-supervised learning\">self-supervised</a> and <a class=\"mw-redirect\" href=\"/wiki/Semi-supervised_learning\" title=\"Semi-supervised learning\">semi-supervised</a> training process.<sup class=\"reference\" id=\"cite_ref-:7_1-0\"><a href=\"#cite_note-:7-1\"><span class=\"cite-bracket\">[</span>1<span class=\"cite-bracket\">]</span></a></sup>\n</p><p>The largest and most capable LLMs are <a class=\"mw-redirect\" href=\"/wiki/Artificial_neural_network\" title=\"Artificial neural network\">artificial neural networks</a> built with a decoder-only <a href=\"/wiki/Transformer_(deep_learning_architecture)\" title=\"Transformer (deep learning architecture)\">transformer-based architecture</a>, enabling efficient processing and generation of large-scale text data. Modern models can be <a href=\"/wiki/Fine-tuning_(deep_learning)\" title=\"Fine-tuning (deep learning)\">fine-tuned</a> for specific tasks or guided by <a href=\"/wiki/Prompt_engineering\" title=\"Prompt engineering\">prompt engineering</a>.<sup class=\"reference\" id=\"cite_ref-few-shot-learners_2-0\"><a href=\"#cite_note-few-shot-learners-2\"><span class=\"cite-bracket\">[</span>2<span class=\"cite-bracket\">]</span></a></sup> These models acquire <a href=\"/wiki/Predictive_learning\" title=\"Predictive learning\">predictive power</a> regarding <a href=\"/wiki/Syntax\" title=\"Syntax\">syntax</a>, <a href=\"/wiki/Semantics\" title=\"Semantics\">semantics</a>, and <a href=\"/wiki/Ontology_(information_science)\" title=\"Ontology (information science)\">ontologies</a><sup class=\"reference\" id=\"cite_ref-3\"><a href=\"#cite_note-3\"><span class=\"cite-bracket\">[</span>3<span class=\"cite-bracket\">]</span></a></sup> inherent in human language corpora, but they also inherit inaccuracies and <a href=\"/wiki/Algorithmic_bias\" title=\"Algorithmic bias\">biases</a> present in the <a href=\"/wiki/Training,_validation,_and_test_data_sets\" title=\"Training, validation, and test data sets\">data</a> they are trained in.<sup class=\"reference\" id=\"cite_ref-Manning-2022_4-0\"><a href=\"#cite_note-Manning-2022-4\"><span class=\"cite-bracket\">[</span>4<span class=\"cite-bracket\">]</span></a></sup>\n</p>\n<meta property=\"mw:PageProp/toc\">\n<div class=\"mw-heading mw-heading2\"><h2 id=\"History\">History</h2><span class=\"mw-editsection\"><span class=\"mw-editsection-bracket\">[</span><a href=\"/w/index.php?title=Large_language_model&amp;action=edit&amp;section=1\" title=\"Edit section: History\"><span>edit</span></a><span class=\"mw-editsection-bracket\">]</span></span></div>\n<figure class=\"mw-default-size\" typeof=\"mw:File/Thumb\"><a class=\"mw-file-description\" href=\"/wiki/File:Trends_in_AI_training_FLOP_over_time_(2010-2025).svg\"><img class=\"mw-file-element\" data-file-height=\"724\" data-file-width=\"801\" decoding=\"async\" height=\"199\" src=\"//upload.wikimedia.org/wikipedia/commons/thumb/9/9b/Trends_in_AI_training_FLOP_over_time_%282010-2025%29.svg/220px-Trends_in_AI_training_FLOP_over_time_%282010-2025%29.svg.png\" srcset=\"//upload.wikimedia.org/wikipedia/commons/thumb/9/9b/Trends_in_AI_training_FLOP_over_time_%282010-2025%29.svg/330px-Trends_in_AI_training_FLOP_over_time_%282010-2025%29.svg.png 1.5x, //upload.wikimedia.org/wikipedia/commons/thumb/9/9b/Trends_in_AI_training_FLOP_over_time_%282010-2025%29.svg/440px-Trends_in_AI_training_FLOP_over_time_%282010-2025%29.svg.png 2x\" width=\"220\"/></a><figcaption>The training compute of notable large models in FLOPs vs publication date over the period 2010-2024. For overall notable models (top left), frontier models (top right), top language models (bottom left) and top models within leading companies (bottom right). The majority of these models are language models.</figcaption></figure>\n<figure class=\"mw-default-size\" typeof=\"mw:File/Thumb\"><a class=\"mw-file-description\" href=\"/wiki/File:Large-scale_AI_training_compute_(FLOP)_vs_Publication_date_(2017-2024).svg\"><img class=\"mw-file-element\" data-file-height=\"1080\" data-file-width=\"1920\" decoding=\"async\" height=\"124\" src=\"//upload.wikimedia.org/wikipedia/commons/thumb/0/06/Large-scale_AI_training_compute_%28FLOP%29_vs_Publication_date_%282017-2024%29.svg/220px-Large-scale_AI_training_compute_%28FLOP%29_vs_Publication_date_%282017-2024%29.svg.png\" srcset=\"//upload.wikimedia.org/wikipedia/commons/thumb/0/06/Large-scale_AI_training_compute_%28FLOP%29_vs_Publication_date_%282017-2024%29.svg/330px-Large-scale_AI_training_compute_%28FLOP%29_vs_Publication_date_%282017-2024%29.svg.png 1.5x, //upload.wikimedia.org/wikipedia/commons/thumb/0/06/Large-scale_AI_training_compute_%28FLOP%29_vs_Publication_date_%282017-2024%29.svg/440px-Large-scale_AI_training_compute_%28FLOP%29_vs_Publication_date_%282017-2024%29.svg.png 2x\" width=\"220\"/></a><figcaption>The training compute of notable large AI models in FLOPs vs publication date over the period 2017-2024. The majority of large models are language models or multimodal models with language capacity.</figcaption></figure>\n<p>Before 2017, there were a few language models that were large as compared to capacities then available. In the 1990s, the <a href=\"/wiki/IBM_alignment_models\" title=\"IBM alignment models\">IBM alignment models</a> pioneered statistical language modelling. A smoothed n-gram model in 2001 trained on 0.3 billion words achieved state-of-the-art <a href=\"/wiki/Perplexity\" title=\"Perplexity\">perplexity</a> at the time.<sup class=\"reference\" id=\"cite_ref-5\"><a href=\"#cite_note-5\"><span class=\"cite-bracket\">[</span>5<span class=\"cite-bracket\">]</span></a></sup> In the 2000s, as Internet use became prevalent, some researchers constructed Internet-scale language datasets (\"web as corpus\"<sup class=\"reference\" id=\"cite_ref-6\"><a href=\"#cite_note-6\"><span class=\"cite-bracket\">[</span>6<span class=\"cite-bracket\">]</span></a></sup>), upon which they trained statistical language models.<sup class=\"reference\" id=\"cite_ref-7\"><a href=\"#cite_note-7\"><span class=\"cite-bracket\">[</span>7<span class=\"cite-bracket\">]</span></a></sup><sup class=\"reference\" id=\"cite_ref-8\"><a href=\"#cite_note-8\"><span class=\"cite-bracket\">[</span>8<span class=\"cite-bracket\">]</span></a></sup> In 2009, in most language processing tasks, statistical language models dominated over symbolic language models, as they can usefully ingest large datasets.<sup class=\"reference\" id=\"cite_ref-9\"><a href=\"#cite_note-9\"><span class=\"cite-bracket\">[</span>9<span class=\"cite-bracket\">]</span></a></sup>\n</p><p>\nAfter neural networks became dominant in image processing around 2012,<sup class=\"reference\" id=\"cite_ref-10\"><a href=\"#cite_note-10\"><span class=\"cite-bracket\">[</span>10<span class=\"cite-bracket\">]</span></a></sup> they were applied to language modelling as well. Google converted its translation service to <a href=\"/wiki/Google_Neural_Machine_Translation\" title=\"Google Neural Machine Translation\">Neural Machine Translation</a> in 2016. As it was before <a class=\"mw-redirect\" href=\"/wiki/Transformer_model\" title=\"Transformer model\">transformers</a>, it was done by <a href=\"/wiki/Seq2seq\" title=\"Seq2seq\">seq2seq</a> deep <a class=\"mw-redirect\" href=\"/wiki/LSTM\" title=\"LSTM\">LSTM</a> networks.</p><figure class=\"mw-default-size\" typeof=\"mw:File/Thumb\"><a class=\"mw-file-description\" href=\"/wiki/File:The-Transformer-model-architecture.png\"><img class=\"mw-file-element\" data-file-height=\"765\" data-file-width=\"850\" decoding=\"async\" height=\"261\" src=\"//upload.wikimedia.org/wikipedia/commons/thumb/8/8f/The-Transformer-model-architecture.png/290px-The-Transformer-model-architecture.png\" srcset=\"//upload.wikimedia.org/wikipedia/commons/thumb/8/8f/The-Transformer-model-architecture.png/435px-The-Transformer-model-architecture.png 1.5x, //upload.wikimedia.org/wikipedia/commons/thumb/8/8f/The-Transformer-model-architecture.png/580px-The-Transformer-model-architecture.png 2x\" width=\"290\"/></a><figcaption>An illustration of main components of the transformer model from the original paper, where layers were normalized after (instead of before) multiheaded attention</figcaption></figure>\n<p>At the 2017 <a class=\"mw-redirect\" href=\"/wiki/NeurIPS\" title=\"NeurIPS\">NeurIPS</a> conference, Google researchers introduced the transformer architecture in their landmark paper \"<a href=\"/wiki/Attention_Is_All_You_Need\" title=\"Attention Is All You Need\">Attention Is All You Need</a>\". This paper's goal was to improve upon 2014 seq2seq technology,<sup class=\"reference\" id=\"cite_ref-11\"><a href=\"#cite_note-11\"><span class=\"cite-bracket\">[</span>11<span class=\"cite-bracket\">]</span></a></sup> and was based mainly on the <a href=\"/wiki/Attention_(machine_learning)\" title=\"Attention (machine learning)\">attention</a> mechanism developed by Bahdanau et al. in 2014.<sup class=\"reference\" id=\"cite_ref-12\"><a href=\"#cite_note-12\"><span class=\"cite-bracket\">[</span>12<span class=\"cite-bracket\">]</span></a></sup> The following year in 2018, <a href=\"/wiki/BERT_(language_model)\" title=\"BERT (language model)\">BERT</a> was introduced and quickly became \"ubiquitous\".<sup class=\"reference\" id=\"cite_ref-13\"><a href=\"#cite_note-13\"><span class=\"cite-bracket\">[</span>13<span class=\"cite-bracket\">]</span></a></sup> Though the original transformer has both encoder and decoder blocks, BERT is an encoder-only model. \nAcademic and research usage of BERT began to decline in 2023, following rapid improvements in the abilities of decoder-only models (such as GPT) to solve tasks via <a href=\"/wiki/Prompt_engineering\" title=\"Prompt engineering\">prompting</a>.<sup class=\"reference\" id=\"cite_ref-14\"><a href=\"#cite_note-14\"><span class=\"cite-bracket\">[</span>14<span class=\"cite-bracket\">]</span></a></sup>\n</p><p>Although decoder-only <a href=\"/wiki/GPT-1\" title=\"GPT-1\">GPT-1</a> was introduced in 2018, it was <a href=\"/wiki/GPT-2\" title=\"GPT-2\">GPT-2</a> in 2019 that caught widespread attention because <a href=\"/wiki/OpenAI\" title=\"OpenAI\">OpenAI</a> at first deemed it too powerful to release publicly, out of fear of malicious use.<sup class=\"reference\" id=\"cite_ref-15\"><a href=\"#cite_note-15\"><span class=\"cite-bracket\">[</span>15<span class=\"cite-bracket\">]</span></a></sup> <a href=\"/wiki/GPT-3\" title=\"GPT-3\">GPT-3</a> in 2020 went a step further and as of 2024<sup class=\"plainlinks noexcerpt noprint asof-tag update\" style=\"display:none;\"><a class=\"external text\" href=\"https://en.wikipedia.org/w/index.php?title=Large_language_model&amp;action=edit\">[update]</a></sup> is available only via <a href=\"/wiki/Web_API\" title=\"Web API\">API</a> with no offering of downloading the model to execute locally. But it was the 2022 consumer-facing browser-based <a href=\"/wiki/ChatGPT\" title=\"ChatGPT\">ChatGPT</a> that captured the imaginations of the general population and caused some media hype and online buzz.<sup class=\"reference\" id=\"cite_ref-16\"><a href=\"#cite_note-16\"><span class=\"cite-bracket\">[</span>16<span class=\"cite-bracket\">]</span></a></sup> The 2023 <a href=\"/wiki/GPT-4\" title=\"GPT-4\">GPT-4</a> was praised for its increased accuracy and as a \"holy grail\" for its <a href=\"/wiki/Multimodal_learning\" title=\"Multimodal learning\">multimodal</a> capabilities.<sup class=\"reference\" id=\"cite_ref-17\"><a href=\"#cite_note-17\"><span class=\"cite-bracket\">[</span>17<span class=\"cite-bracket\">]</span></a></sup> OpenAI did not reveal the high-level architecture and the number of <a href=\"/wiki/Parameter#Artificial_intelligence\" title=\"Parameter\">parameters</a> of GPT-4. The release of ChatGPT led to an uptick in LLM usage across several research subfields of computer science, including robotics, software engineering, and societal impact work.<sup class=\"reference\" id=\"cite_ref-18\"><a href=\"#cite_note-18\"><span class=\"cite-bracket\">[</span>18<span class=\"cite-bracket\">]</span></a></sup>\n</p><p>Competing language models have for the most part been attempting to equal the GPT series, at least in terms of number of parameters.<sup class=\"reference\" id=\"cite_ref-19\"><a href=\"#cite_note-19\"><span class=\"cite-bracket\">[</span>19<span class=\"cite-bracket\">]</span></a></sup>\n</p><p>Since 2022, <a href=\"/wiki/Source-available_software\" title=\"Source-available software\">source-available</a> models have been gaining popularity, especially at first with <a href=\"/wiki/BLOOM_(language_model)\" title=\"BLOOM (language model)\">BLOOM</a> and <a class=\"mw-redirect\" href=\"/wiki/LLaMA\" title=\"LLaMA\">LLaMA</a>, though both have restrictions on the field of use. <a href=\"/wiki/Mistral_AI\" title=\"Mistral AI\">Mistral AI</a>'s models Mistral 7B and Mixtral 8x7b have the more permissive <a href=\"/wiki/Apache_License\" title=\"Apache License\">Apache License</a>. As of June 2024<sup class=\"plainlinks noexcerpt noprint asof-tag update\" style=\"display:none;\"><a class=\"external text\" href=\"https://en.wikipedia.org/w/index.php?title=Large_language_model&amp;action=edit\">[update]</a></sup>, The Instruction fine tuned variant of the Llama 3 70 billion parameter model is the most powerful open LLM according to the LMSYS Chatbot Arena Leaderboard, being more powerful than GPT-3.5 but not as powerful as GPT-4.<sup class=\"reference\" id=\"cite_ref-20\"><a href=\"#cite_note-20\"><span class=\"cite-bracket\">[</span>20<span class=\"cite-bracket\">]</span></a></sup>\n</p><p>As of 2024, the largest and most capable models are all based on the Transformer architecture. Some recent implementations are based on other architectures, such as <a href=\"/wiki/Recurrent_neural_network\" title=\"Recurrent neural network\">recurrent neural network</a> variants and <a href=\"/wiki/Mamba_(deep_learning_architecture)\" title=\"Mamba (deep learning architecture)\">Mamba</a> (a <a href=\"/wiki/State-space_representation\" title=\"State-space representation\">state space</a> model).<sup class=\"reference\" id=\"cite_ref-21\"><a href=\"#cite_note-21\"><span class=\"cite-bracket\">[</span>21<span class=\"cite-bracket\">]</span></a></sup><sup class=\"reference\" id=\"cite_ref-22\"><a href=\"#cite_note-22\"><span class=\"cite-bracket\">[</span>22<span class=\"cite-bracket\">]</span></a></sup><sup class=\"reference\" id=\"cite_ref-23\"><a href=\"#cite_note-23\"><span class=\"cite-bracket\">[</span>23<span class=\"cite-bracket\">]</span></a></sup>\n</p>\n<div class=\"mw-heading mw-heading2\"><h2 id=\"Dataset_preprocessing\">Dataset preprocessing</h2><span class=\"mw-editsection\"><span class=\"mw-editsection-bracket\">[</span><a href=\"/w/index.php?title=Large_language_model&amp;action=edit&amp;section=2\" title=\"Edit section: Dataset preprocessing\"><span>edit</span></a><span class=\"mw-editsection-bracket\">]</span></span></div>\n<link href=\"mw-data:TemplateStyles:r1236090951\" rel=\"mw-deduplicated-inline-style\"/><div class=\"hatnote navigation-not-searchable\" role=\"note\">See also: <a href=\"/wiki/List_of_datasets_for_machine-learning_research#Internet\" title=\"List of datasets for machine-learning research\">List of datasets for machine-learning research § Internet</a></div>\n<div class=\"mw-heading mw-heading3\"><h3 id=\"Tokenization\">Tokenization</h3><span class=\"mw-editsection\"><span class=\"mw-editsection-bracket\">[</span><a href=\"/w/index.php?title=Large_language_model&amp;action=edit&amp;section=3\" title=\"Edit section: Tokenization\"><span>edit</span></a><span class=\"mw-editsection-bracket\">]</span></span></div>\n<p><span class=\"anchor\" id=\"Tokenization\"></span>\n</p><p>Because <a href=\"/wiki/Machine_learning\" title=\"Machine learning\">machine learning</a> algorithms process numbers rather than text, the text must be converted to numbers. In the first step, a vocabulary is decided upon, then integer indices are arbitrarily but uniquely assigned to each vocabulary entry, and finally, an <a href=\"/wiki/Word_embedding\" title=\"Word embedding\">embedding</a> is associated to the integer index. Algorithms include <a href=\"/wiki/Byte_pair_encoding\" title=\"Byte pair encoding\">byte-pair encoding</a> (BPE) and <a href=\"/wiki/BERT_(language_model)#Design\" title=\"BERT (language model)\">WordPiece</a>. There are also special tokens serving as <a href=\"/wiki/Control_character\" title=\"Control character\">control characters</a>, such as <code>[MASK]</code> for masked-out token (as used in <a href=\"/wiki/BERT_(language_model)\" title=\"BERT (language model)\">BERT</a>), and <code>[UNK]</code> (\"unknown\") for characters not appearing in the vocabulary. Also, some special symbols are used to denote special text formatting. For example, \"Ġ\" denotes a preceding whitespace in RoBERTa and GPT. \"##\" denotes continuation of a preceding word in BERT.<sup class=\"reference\" id=\"cite_ref-24\"><a href=\"#cite_note-24\"><span class=\"cite-bracket\">[</span>24<span class=\"cite-bracket\">]</span></a></sup>\n</p><p>For example, the BPE tokenizer used by GPT-3 (Legacy) would split <small><code>tokenizer: texts -&gt; series of numerical \"tokens\"</code></small> as\n</p>\n<table cellpadding=\"0;\" cellspacing=\"0;\" style=\"border:1px solid black\">\n<tbody><tr>\n<td style=\"border-left: 2px green; border-right: 2px green\">token\n</td>\n<td style=\"background-color: grey; color: white; border-left: 2px green; border-right: 2px green\">izer\n</td>\n<td style=\"border-left: 2px green; border-right: 2px green\">:\n</td>\n<td style=\"background-color: grey; color: white; border-left: 2px green; border-right: 2px green\"> texts\n</td>\n<td style=\"border-left: 2px green; border-right: 2px green\"> -&gt;\n</td>\n<td style=\"background-color: grey; color: white; border-left: 2px green; border-right: 2px green\">series\n</td>\n<td style=\"border-left: 2px green; border-right: 2px green\"> of\n</td>\n<td style=\"background-color: grey; color: white; border-left: 2px green; border-right: 2px green\"> numerical\n</td>\n<td style=\"border-left: 2px green; border-right: 2px green\"> \"\n</td>\n<td style=\"background-color: grey; color: white; border-left: 2px green; border-right: 2px green\">t\n</td>\n<td style=\"border-left: 2px green; border-right: 2px green\">ok\n</td>\n<td style=\"background-color: grey; color: white; border-left: 2px green; border-right: 2px green\">ens\n</td>\n<td style=\"border-left: 2px green; border-right: 2px green\">\"\n</td></tr></tbody></table>\n<p>Tokenization also <a href=\"/wiki/Data_compression\" title=\"Data compression\">compresses</a> the datasets. Because LLMs generally require input to be an <a href=\"/wiki/Array_(data_structure)\" title=\"Array (data structure)\">array</a> that is not <a href=\"/wiki/Jagged_array\" title=\"Jagged array\">jagged</a>, the shorter texts must be \"padded\" until they match the length of the longest one. How many tokens are, on average, needed per word depends on the language of the dataset.<sup class=\"reference\" id=\"cite_ref-25\"><a href=\"#cite_note-25\"><span class=\"cite-bracket\">[</span>25<span class=\"cite-bracket\">]</span></a></sup><sup class=\"reference\" id=\"cite_ref-26\"><a href=\"#cite_note-26\"><span class=\"cite-bracket\">[</span>26<span class=\"cite-bracket\">]</span></a></sup>\n</p>\n<div class=\"mw-heading mw-heading4\"><h4 id=\"BPE\">BPE</h4><span class=\"mw-editsection\"><span class=\"mw-editsection-bracket\">[</span><a href=\"/w/index.php?title=Large_language_model&amp;action=edit&amp;section=4\" title=\"Edit section: BPE\"><span>edit</span></a><span class=\"mw-editsection-bracket\">]</span></span></div>\n<link href=\"mw-data:TemplateStyles:r1236090951\" rel=\"mw-deduplicated-inline-style\"/><div class=\"hatnote navigation-not-searchable\" role=\"note\">Main article: <a href=\"/wiki/Byte_pair_encoding\" title=\"Byte pair encoding\">Byte pair encoding</a></div>\n<p>As an example, consider a tokenizer based on byte-pair encoding. In the first step, all unique characters (including blanks and <a class=\"mw-redirect\" href=\"/wiki/Punctuation_mark\" title=\"Punctuation mark\">punctuation marks</a>) are treated as an initial set of <a href=\"/wiki/N-gram\" title=\"N-gram\"><i>n</i>-grams</a> (i.e. initial set of uni-grams). Successively the most frequent pair of adjacent characters is merged into a bi-gram and all instances of the pair are replaced by it. All occurrences of adjacent pairs of (previously merged) <i>n</i>-grams that most frequently occur together are then again merged into even lengthier <i>n</i>-gram, until a vocabulary of prescribed size is obtained (in case of <a href=\"/wiki/GPT-3\" title=\"GPT-3\">GPT-3</a>, the size is 50257).<sup class=\"reference\" id=\"cite_ref-xbiWb_27-0\"><a href=\"#cite_note-xbiWb-27\"><span class=\"cite-bracket\">[</span>27<span class=\"cite-bracket\">]</span></a></sup> After a tokenizer is trained, any text can be tokenized by it, as long as it does not contain characters not appearing in the initial-set of uni-grams.<sup class=\"reference\" id=\"cite_ref-2022Book_28-0\"><a href=\"#cite_note-2022Book_-28\"><span class=\"cite-bracket\">[</span>28<span class=\"cite-bracket\">]</span></a></sup>\n</p>\n<div class=\"mw-heading mw-heading4\"><h4 id=\"Problems\">Problems</h4><span class=\"mw-editsection\"><span class=\"mw-editsection-bracket\">[</span><a href=\"/w/index.php?title=Large_language_model&amp;action=edit&amp;section=5\" title=\"Edit section: Problems\"><span>edit</span></a><span class=\"mw-editsection-bracket\">]</span></span></div>\n<p>A token vocabulary based on the frequencies extracted from mainly English corpora uses as few tokens as possible for an average English word. An average word in another language encoded by such an English-optimized tokenizer is however split into suboptimal amount of tokens. GPT-2 tokenizer can use up to 15 times more tokens per word for some languages, for example for the <a href=\"/wiki/Shan_language\" title=\"Shan language\">Shan language</a> from <a href=\"/wiki/Myanmar\" title=\"Myanmar\">Myanmar</a>. Even more widespread languages such as Portuguese and German have \"a premium of 50%\" compared to English.<sup class=\"reference\" id=\"cite_ref-29\"><a href=\"#cite_note-29\"><span class=\"cite-bracket\">[</span>29<span class=\"cite-bracket\">]</span></a></sup>\n</p><p>Greedy tokenization also causes subtle problems with text completion.<sup class=\"reference\" id=\"cite_ref-30\"><a href=\"#cite_note-30\"><span class=\"cite-bracket\">[</span>30<span class=\"cite-bracket\">]</span></a></sup>\n</p>\n<div class=\"mw-heading mw-heading3\"><h3 id=\"Dataset_cleaning\">Dataset cleaning</h3><span class=\"mw-editsection\"><span class=\"mw-editsection-bracket\">[</span><a href=\"/w/index.php?title=Large_language_model&amp;action=edit&amp;section=6\" title=\"Edit section: Dataset cleaning\"><span>edit</span></a><span class=\"mw-editsection-bracket\">]</span></span></div>\n<link href=\"mw-data:TemplateStyles:r1236090951\" rel=\"mw-deduplicated-inline-style\"/><div class=\"hatnote navigation-not-searchable\" role=\"note\">Main article: <a href=\"/wiki/Data_cleansing\" title=\"Data cleansing\">Data cleansing</a></div>\n<p>In the context of training LLMs, datasets are typically cleaned by removing toxic passages from the dataset, discarding low-quality data, and de-duplication.<sup class=\"reference\" id=\"cite_ref-aYNg4_31-0\"><a href=\"#cite_note-aYNg4-31\"><span class=\"cite-bracket\">[</span>31<span class=\"cite-bracket\">]</span></a></sup> Cleaned datasets can increase training efficiency and lead to improved downstream performance.<sup class=\"reference\" id=\"cite_ref-32\"><a href=\"#cite_note-32\"><span class=\"cite-bracket\">[</span>32<span class=\"cite-bracket\">]</span></a></sup><sup class=\"reference\" id=\"cite_ref-33\"><a href=\"#cite_note-33\"><span class=\"cite-bracket\">[</span>33<span class=\"cite-bracket\">]</span></a></sup> A trained LLM can be used to clean datasets for training a further LLM.<sup class=\"reference\" id=\"cite_ref-34\"><a href=\"#cite_note-34\"><span class=\"cite-bracket\">[</span>34<span class=\"cite-bracket\">]</span></a></sup>\n</p><p>With the increasing proportion of LLM-generated content on the web, data cleaning in the future may include filtering out such content. LLM-generated content can pose a problem if the content is similar to human text (making filtering difficult) but of lower quality (degrading performance of models trained on it).<sup class=\"reference\" id=\"cite_ref-qbFw1_35-0\"><a href=\"#cite_note-qbFw1-35\"><span class=\"cite-bracket\">[</span>35<span class=\"cite-bracket\">]</span></a></sup>\n</p>\n<div class=\"mw-heading mw-heading3\"><h3 id=\"Synthetic_data\">Synthetic data</h3><span class=\"mw-editsection\"><span class=\"mw-editsection-bracket\">[</span><a href=\"/w/index.php?title=Large_language_model&amp;action=edit&amp;section=7\" title=\"Edit section: Synthetic data\"><span>edit</span></a><span class=\"mw-editsection-bracket\">]</span></span></div>\n<link href=\"mw-data:TemplateStyles:r1236090951\" rel=\"mw-deduplicated-inline-style\"/><div class=\"hatnote navigation-not-searchable\" role=\"note\">Main article: <a href=\"/wiki/Synthetic_data\" title=\"Synthetic data\">Synthetic data</a></div>\n<p>Training of largest language models might need more linguistic data than naturally available, or that the naturally occurring data is of insufficient quality. In these cases, synthetic data might be used. Microsoft's <a class=\"new\" href=\"/w/index.php?title=Phi_(LLM)&amp;action=edit&amp;redlink=1\" title=\"Phi (LLM) (page does not exist)\">Phi</a> series of LLMs is trained on textbook-like data generated by another LLM.<sup class=\"reference\" id=\"cite_ref-36\"><a href=\"#cite_note-36\"><span class=\"cite-bracket\">[</span>36<span class=\"cite-bracket\">]</span></a></sup>\n</p>\n<div class=\"mw-heading mw-heading2\"><h2 id=\"Training_and_architecture\">Training and architecture</h2><span class=\"mw-editsection\"><span class=\"mw-editsection-bracket\">[</span><a href=\"/w/index.php?title=Large_language_model&amp;action=edit&amp;section=8\" title=\"Edit section: Training and architecture\"><span>edit</span></a><span class=\"mw-editsection-bracket\">]</span></span></div>\n<link href=\"mw-data:TemplateStyles:r1236090951\" rel=\"mw-deduplicated-inline-style\"/><div class=\"hatnote navigation-not-searchable\" role=\"note\">See also: <a class=\"mw-redirect\" href=\"/wiki/Fine-tuning_(machine_learning)\" title=\"Fine-tuning (machine learning)\">Fine-tuning (machine learning)</a></div>\n<div class=\"mw-heading mw-heading3\"><h3 id=\"Reinforcement_learning_from_human_feedback_(RLHF)\"><span id=\"Reinforcement_learning_from_human_feedback_.28RLHF.29\"></span>Reinforcement learning from human feedback (RLHF)</h3><span class=\"mw-editsection\"><span class=\"mw-editsection-bracket\">[</span><a href=\"/w/index.php?title=Large_language_model&amp;action=edit&amp;section=9\" title=\"Edit section: Reinforcement learning from human feedback (RLHF)\"><span>edit</span></a><span class=\"mw-editsection-bracket\">]</span></span></div>\n<link href=\"mw-data:TemplateStyles:r1236090951\" rel=\"mw-deduplicated-inline-style\"/><div class=\"hatnote navigation-not-searchable\" role=\"note\">Main article: <a href=\"/wiki/Reinforcement_learning_from_human_feedback\" title=\"Reinforcement learning from human feedback\">Reinforcement learning from human feedback</a></div>\n<p>Reinforcement learning from human feedback (RLHF) through algorithms, such as <a class=\"mw-redirect\" href=\"/wiki/Proximal_Policy_Optimization\" title=\"Proximal Policy Optimization\">proximal policy optimization</a>, is used to further fine-tune a model based on a dataset of human preferences.<sup class=\"reference\" id=\"cite_ref-instructGPT-paper_37-0\"><a href=\"#cite_note-instructGPT-paper-37\"><span class=\"cite-bracket\">[</span>37<span class=\"cite-bracket\">]</span></a></sup>\n</p>\n<div class=\"mw-heading mw-heading3\"><h3 id=\"Instruction_tuning\">Instruction tuning</h3><span class=\"mw-editsection\"><span class=\"mw-editsection-bracket\">[</span><a href=\"/w/index.php?title=Large_language_model&amp;action=edit&amp;section=10\" title=\"Edit section: Instruction tuning\"><span>edit</span></a><span class=\"mw-editsection-bracket\">]</span></span></div>\n<p>Using \"self-instruct\" approaches, LLMs have been able to <a href=\"/wiki/Bootstrapping\" title=\"Bootstrapping\">bootstrap</a> correct responses, replacing any naive responses, starting from human-generated corrections of a few cases. For example, in the instruction \"Write an essay about the main themes represented in <i>Hamlet</i>,\" an initial naive completion might be \"If you submit the essay after March 17, your grade will be reduced by 10% for each day of delay,\" based on the frequency of this textual sequence in the corpus.<sup class=\"reference\" id=\"cite_ref-self-instruct-paper_38-0\"><a href=\"#cite_note-self-instruct-paper-38\"><span class=\"cite-bracket\">[</span>38<span class=\"cite-bracket\">]</span></a></sup>\n</p>\n<div class=\"mw-heading mw-heading3\"><h3 id=\"Mixture_of_experts\">Mixture of experts</h3><span class=\"mw-editsection\"><span class=\"mw-editsection-bracket\">[</span><a href=\"/w/index.php?title=Large_language_model&amp;action=edit&amp;section=11\" title=\"Edit section: Mixture of experts\"><span>edit</span></a><span class=\"mw-editsection-bracket\">]</span></span></div>\n<link href=\"mw-data:TemplateStyles:r1236090951\" rel=\"mw-deduplicated-inline-style\"/><div class=\"hatnote navigation-not-searchable\" role=\"note\">Main article: <a href=\"/wiki/Mixture_of_experts\" title=\"Mixture of experts\">Mixture of experts</a></div>\n<p>The largest LLM may be too expensive to train and use directly. For such models, <a href=\"/wiki/Mixture_of_experts\" title=\"Mixture of experts\">mixture of experts</a> (MoE) can be applied, a line of research pursued by Google researchers since 2017 to train models reaching up to 1 trillion parameters.<sup class=\"reference\" id=\"cite_ref-HGZCJ_39-0\"><a href=\"#cite_note-HGZCJ-39\"><span class=\"cite-bracket\">[</span>39<span class=\"cite-bracket\">]</span></a></sup><sup class=\"reference\" id=\"cite_ref-R9Qq5_40-0\"><a href=\"#cite_note-R9Qq5-40\"><span class=\"cite-bracket\">[</span>40<span class=\"cite-bracket\">]</span></a></sup><sup class=\"reference\" id=\"cite_ref-glam-blog_41-0\"><a href=\"#cite_note-glam-blog-41\"><span class=\"cite-bracket\">[</span>41<span class=\"cite-bracket\">]</span></a></sup>\n</p>\n<div class=\"mw-heading mw-heading3\"><h3 id=\"Prompt_engineering,_attention_mechanism,_and_context_window\"><span id=\"Prompt_engineering.2C_attention_mechanism.2C_and_context_window\"></span>Prompt engineering, attention mechanism, and context window</h3><span class=\"mw-editsection\"><span class=\"mw-editsection-bracket\">[</span><a href=\"/w/index.php?title=Large_language_model&amp;action=edit&amp;section=12\" title=\"Edit section: Prompt engineering, attention mechanism, and context window\"><span>edit</span></a><span class=\"mw-editsection-bracket\">]</span></span></div>\n<link href=\"mw-data:TemplateStyles:r1236090951\" rel=\"mw-deduplicated-inline-style\"/><div class=\"hatnote navigation-not-searchable\" role=\"note\">See also: <a href=\"/wiki/Prompt_engineering\" title=\"Prompt engineering\">Prompt engineering</a> and <a href=\"/wiki/Attention_(machine_learning)\" title=\"Attention (machine learning)\">Attention (machine learning)</a></div>\n<p>Most results previously achievable only by (costly) fine-tuning, can be achieved through <a href=\"/wiki/Prompt_engineering\" title=\"Prompt engineering\">prompt engineering</a>, although limited to the scope of a single conversation (more precisely, limited to the scope of a context window).<sup class=\"reference\" id=\"cite_ref-emergentpaper_42-0\"><a href=\"#cite_note-emergentpaper-42\"><span class=\"cite-bracket\">[</span>42<span class=\"cite-bracket\">]</span></a></sup>\n</p>\n<figure class=\"mw-default-size\" typeof=\"mw:File/Thumb\"><a class=\"mw-file-description\" href=\"/wiki/File:Multiple_attention_heads.png\"><img class=\"mw-file-element\" data-file-height=\"1280\" data-file-width=\"870\" decoding=\"async\" height=\"427\" src=\"//upload.wikimedia.org/wikipedia/commons/thumb/e/e9/Multiple_attention_heads.png/290px-Multiple_attention_heads.png\" srcset=\"//upload.wikimedia.org/wikipedia/commons/thumb/e/e9/Multiple_attention_heads.png/435px-Multiple_attention_heads.png 1.5x, //upload.wikimedia.org/wikipedia/commons/thumb/e/e9/Multiple_attention_heads.png/580px-Multiple_attention_heads.png 2x\" width=\"290\"/></a><figcaption> When each head calculates, according to its own criteria, how much other tokens are relevant for the \"it_\" token, note that the second attention head, represented by the second column, is focusing most on the first two rows, i.e. the tokens \"The\" and \"animal\", while the third column is focusing most on the bottom two rows, i.e. on \"tired\", which has been tokenized into two tokens.<sup class=\"reference\" id=\"cite_ref-Jay_Allamar_43-0\"><a href=\"#cite_note-Jay_Allamar-43\"><span class=\"cite-bracket\">[</span>43<span class=\"cite-bracket\">]</span></a></sup></figcaption></figure>\n<p>In order to find out which tokens are relevant to each other within the scope of the context window, the attention mechanism calculates \"soft\" weights for each token, more precisely for its embedding, by using multiple attention heads, each with its own \"relevance\" for calculating its own soft weights. For example, the small (i.e. 117M parameter sized) <a href=\"/wiki/GPT-2\" title=\"GPT-2\">GPT-2</a> model has had twelve attention heads and a context window of only 1k tokens.<sup class=\"reference\" id=\"cite_ref-Jay_Allamar_GPT2_44-0\"><a href=\"#cite_note-Jay_Allamar_GPT2-44\"><span class=\"cite-bracket\">[</span>44<span class=\"cite-bracket\">]</span></a></sup> In its medium version it has 345M parameters and contains 24 layers, each with 12 attention heads. For the training with gradient descent a batch size of 512 was utilized.<sup class=\"reference\" id=\"cite_ref-2022Book_28-1\"><a href=\"#cite_note-2022Book_-28\"><span class=\"cite-bracket\">[</span>28<span class=\"cite-bracket\">]</span></a></sup>\n</p><p>The largest models, such as Google's <a href=\"/wiki/Gemini_(language_model)\" title=\"Gemini (language model)\">Gemini 1.5</a>, presented in February 2024, can have a context window sized up to 1 million (context window of 10 million was also \"successfully tested\").<sup class=\"reference\" id=\"cite_ref-45\"><a href=\"#cite_note-45\"><span class=\"cite-bracket\">[</span>45<span class=\"cite-bracket\">]</span></a></sup> Other models with large context windows includes Anthropic's Claude 2.1, with a context window of up to 200k tokens.<sup class=\"reference\" id=\"cite_ref-46\"><a href=\"#cite_note-46\"><span class=\"cite-bracket\">[</span>46<span class=\"cite-bracket\">]</span></a></sup> Note that this maximum refers to the number of input tokens and that the maximum number of output tokens differs from the input and is often smaller. For example, the GPT-4 Turbo model has a maximum output of 4096 tokens.<sup class=\"reference\" id=\"cite_ref-47\"><a href=\"#cite_note-47\"><span class=\"cite-bracket\">[</span>47<span class=\"cite-bracket\">]</span></a></sup>\n</p><p>Length of a conversation that the model can take into account when generating its next answer is limited by the size of a context window, as well. If the length of a conversation, for example with <a href=\"/wiki/ChatGPT\" title=\"ChatGPT\">ChatGPT</a>, is longer than its context window, only the parts inside the context window are taken into account when generating the next answer, or the model needs to apply some algorithm to summarize the too distant parts of conversation.\n</p><p>The shortcomings of making a context window larger include higher computational cost and possibly diluting the focus on local context, while making it smaller can cause a model to miss an important long-range dependency. Balancing them are a matter of experimentation and domain-specific considerations.\n</p><p>A model may be pre-trained either to predict how the segment continues, or what is missing in the segment, given a segment from its training dataset.<sup class=\"reference\" id=\"cite_ref-ioUpE_48-0\"><a href=\"#cite_note-ioUpE-48\"><span class=\"cite-bracket\">[</span>48<span class=\"cite-bracket\">]</span></a></sup> It can be either\n</p>\n<ul><li>autoregressive (i.e. predicting how the segment continues, the way <a class=\"mw-redirect\" href=\"/wiki/Generative_pretrained_transformer\" title=\"Generative pretrained transformer\">GPTs</a> do it): for example given a segment \"I like to eat\", the model predicts \"ice cream\", or \"sushi\".</li>\n<li>\"<a href=\"/wiki/Cloze_test\" title=\"Cloze test\">masked</a>\" (i.e. filling in the parts missing from the segment, the way \"BERT\"<sup class=\"reference\" id=\"cite_ref-jm_49-0\"><a href=\"#cite_note-jm-49\"><span class=\"cite-bracket\">[</span>49<span class=\"cite-bracket\">]</span></a></sup> does it): for example, given a segment \"I like to <code>[__] [__]</code> cream\", the model predicts that \"eat\" and \"ice\" are missing.</li></ul>\n<p>Models may be trained on auxiliary tasks which test their understanding of the data distribution, such as Next Sentence Prediction (NSP), in which pairs of sentences are presented and the model must predict whether they appear consecutively in the training corpus.<sup class=\"reference\" id=\"cite_ref-jm_49-1\"><a href=\"#cite_note-jm-49\"><span class=\"cite-bracket\">[</span>49<span class=\"cite-bracket\">]</span></a></sup> During training, <a href=\"/wiki/Regularization_(mathematics)\" title=\"Regularization (mathematics)\">regularization</a> loss is also used to stabilize training. However regularization loss is usually not used during <a href=\"/wiki/Training,_validation,_and_test_data_sets\" title=\"Training, validation, and test data sets\">testing</a> and evaluation.\n</p>\n<div class=\"mw-heading mw-heading3\"><h3 id=\"Infrastructure\">Infrastructure</h3><span class=\"mw-editsection\"><span class=\"mw-editsection-bracket\">[</span><a href=\"/w/index.php?title=Large_language_model&amp;action=edit&amp;section=13\" title=\"Edit section: Infrastructure\"><span>edit</span></a><span class=\"mw-editsection-bracket\">]</span></span></div>\n<p>Substantial infrastructure is necessary for training the largest models.<sup class=\"reference\" id=\"cite_ref-50\"><a href=\"#cite_note-50\"><span class=\"cite-bracket\">[</span>50<span class=\"cite-bracket\">]</span></a></sup><sup class=\"reference\" id=\"cite_ref-51\"><a href=\"#cite_note-51\"><span class=\"cite-bracket\">[</span>51<span class=\"cite-bracket\">]</span></a></sup><sup class=\"reference\" id=\"cite_ref-52\"><a href=\"#cite_note-52\"><span class=\"cite-bracket\">[</span>52<span class=\"cite-bracket\">]</span></a></sup>\n</p>\n<div class=\"mw-heading mw-heading2\"><h2 id=\"Training_cost\">Training cost</h2><span class=\"mw-editsection\"><span class=\"mw-editsection-bracket\">[</span><a href=\"/w/index.php?title=Large_language_model&amp;action=edit&amp;section=14\" title=\"Edit section: Training cost\"><span>edit</span></a><span class=\"mw-editsection-bracket\">]</span></span></div>\n<figure class=\"mw-default-size mw-halign-right\" typeof=\"mw:File/Frameless\"><a class=\"mw-file-description\" href=\"/wiki/File:Estimated_training_cost_of_some_AI_models_-_2024_AI_index.jpg\"><img class=\"mw-file-element\" data-file-height=\"1361\" data-file-width=\"2560\" decoding=\"async\" height=\"175\" src=\"//upload.wikimedia.org/wikipedia/commons/thumb/6/64/Estimated_training_cost_of_some_AI_models_-_2024_AI_index.jpg/330px-Estimated_training_cost_of_some_AI_models_-_2024_AI_index.jpg\" srcset=\"//upload.wikimedia.org/wikipedia/commons/thumb/6/64/Estimated_training_cost_of_some_AI_models_-_2024_AI_index.jpg/495px-Estimated_training_cost_of_some_AI_models_-_2024_AI_index.jpg 1.5x, //upload.wikimedia.org/wikipedia/commons/thumb/6/64/Estimated_training_cost_of_some_AI_models_-_2024_AI_index.jpg/660px-Estimated_training_cost_of_some_AI_models_-_2024_AI_index.jpg 2x\" width=\"330\"/></a><figcaption></figcaption></figure>\n<p>Advances in software and hardware have reduced the cost substantially since 2020, such that in 2023 training of a 12-billion-parameter LLM computational cost is 72,300 <a href=\"/wiki/Ampere_(microarchitecture)\" title=\"Ampere (microarchitecture)\">A100-GPU</a>-hours, while in 2020 the cost of training a 1.5-billion-parameter LLM (which was two orders of magnitude smaller than the state of the art in 2020) was between $80,000 and $1,600,000.<sup class=\"reference\" id=\"cite_ref-Wiggers_53-0\"><a href=\"#cite_note-Wiggers-53\"><span class=\"cite-bracket\">[</span>53<span class=\"cite-bracket\">]</span></a></sup><sup class=\"reference\" id=\"cite_ref-xaytj_54-0\"><a href=\"#cite_note-xaytj-54\"><span class=\"cite-bracket\">[</span>54<span class=\"cite-bracket\">]</span></a></sup><sup class=\"reference\" id=\"cite_ref-Pythia_55-0\"><a href=\"#cite_note-Pythia-55\"><span class=\"cite-bracket\">[</span>55<span class=\"cite-bracket\">]</span></a></sup> Since 2020, large sums were invested in increasingly large models. For example, training of the GPT-2 (i.e. a 1.5-billion-parameters model) in 2019 cost $50,000, while training of the PaLM (i.e. a 540-billion-parameters model) in 2022 cost $8 million, and Megatron-Turing NLG 530B (in 2021) cost around $11 million.<sup class=\"reference\" id=\"cite_ref-56\"><a href=\"#cite_note-56\"><span class=\"cite-bracket\">[</span>56<span class=\"cite-bracket\">]</span></a></sup>\n</p><p>For Transformer-based LLM, training cost is much higher than inference cost. It costs 6 <a class=\"mw-redirect\" href=\"/wiki/FLOPS\" title=\"FLOPS\">FLOPs</a> per parameter to train on one token, whereas it costs 1 to 2 FLOPs per parameter to infer on one token.<sup class=\"reference\" id=\"cite_ref-kaplan-scaling_57-0\"><a href=\"#cite_note-kaplan-scaling-57\"><span class=\"cite-bracket\">[</span>57<span class=\"cite-bracket\">]</span></a></sup>\n</p>\n<div class=\"mw-heading mw-heading2\"><h2 id=\"Tool_use\">Tool use</h2><span class=\"mw-editsection\"><span class=\"mw-editsection-bracket\">[</span><a href=\"/w/index.php?title=Large_language_model&amp;action=edit&amp;section=15\" title=\"Edit section: Tool use\"><span>edit</span></a><span class=\"mw-editsection-bracket\">]</span></span></div>\n<p>There are certain tasks that, in principle, cannot be solved by any LLM, at least not without the use of external tools or additional software. An example of such a task is responding to the user's input '354 * 139 = ', provided that the LLM has not already encountered a continuation of this calculation in its training corpus.<sup class=\"noprint Inline-Template\" style=\"white-space:nowrap;\">[<i><a href=\"/wiki/Wikipedia:Accuracy_dispute#Disputed_statement\" title=\"Wikipedia:Accuracy dispute\"><span title=\"The material near this tag is possibly inaccurate or nonfactual. (September 2024)\">dubious</span></a> – <a href=\"/wiki/Talk:Large_language_model#Dubious\" title=\"Talk:Large language model\">discuss</a></i>]</sup> In such cases, the LLM needs to resort to running program code that calculates the result, which can then be included in its response.<sup class=\"noprint Inline-Template\" style=\"white-space:nowrap;\">[<i><a href=\"/wiki/Wikipedia:Accuracy_dispute#Disputed_statement\" title=\"Wikipedia:Accuracy dispute\"><span title=\"The material near this tag is possibly inaccurate or nonfactual. (September 2024)\">dubious</span></a> – <a href=\"/wiki/Talk:Large_language_model#Dubious\" title=\"Talk:Large language model\">discuss</a></i>]</sup>: Another example is \"What is the time now? It is \", where a separate program interpreter would need to execute a code to get system time on the computer, so that the LLM can include it in its reply.<sup class=\"reference\" id=\"cite_ref-PI1fW_58-0\"><a href=\"#cite_note-PI1fW-58\"><span class=\"cite-bracket\">[</span>58<span class=\"cite-bracket\">]</span></a></sup><sup class=\"reference\" id=\"cite_ref-J5OW5_59-0\"><a href=\"#cite_note-J5OW5-59\"><span class=\"cite-bracket\">[</span>59<span class=\"cite-bracket\">]</span></a></sup> This basic strategy can be sophisticated with multiple attempts of generated programs, and other sampling strategies.<sup class=\"reference\" id=\"cite_ref-gQxzq_60-0\"><a href=\"#cite_note-gQxzq-60\"><span class=\"cite-bracket\">[</span>60<span class=\"cite-bracket\">]</span></a></sup>\n</p><p>Generally, in order to get an LLM to use tools, one must fine-tune it for tool-use. If the number of tools is finite, then fine-tuning may be done just once. If the number of tools can grow arbitrarily, as with online <a href=\"/wiki/API\" title=\"API\">API</a> services, then the LLM can be fine-tuned to be able to read API documentation and call API correctly.<sup class=\"reference\" id=\"cite_ref-lLrda_61-0\"><a href=\"#cite_note-lLrda-61\"><span class=\"cite-bracket\">[</span>61<span class=\"cite-bracket\">]</span></a></sup><sup class=\"reference\" id=\"cite_ref-4Xzrs_62-0\"><a href=\"#cite_note-4Xzrs-62\"><span class=\"cite-bracket\">[</span>62<span class=\"cite-bracket\">]</span></a></sup>\n</p><p>A simpler form of tool use is <a href=\"/wiki/Retrieval-augmented_generation\" title=\"Retrieval-augmented generation\">retrieval-augmented generation</a>: the augmentation of an LLM with <a href=\"/wiki/Document_retrieval\" title=\"Document retrieval\">document retrieval</a>. Given a query, a document retriever is called to retrieve the most relevant documents. This is usually done by encoding the query and the documents into vectors, then finding the documents with vectors (usually stored in a <a href=\"/wiki/Vector_database\" title=\"Vector database\">vector database</a>) most similar to the vector of the query. The LLM then generates an output based on both the query and context included from the retrieved documents.<sup class=\"reference\" id=\"cite_ref-BUZBP_63-0\"><a href=\"#cite_note-BUZBP-63\"><span class=\"cite-bracket\">[</span>63<span class=\"cite-bracket\">]</span></a></sup>\n</p>\n<div class=\"mw-heading mw-heading2\"><h2 id=\"Agency\">Agency</h2><span class=\"mw-editsection\"><span class=\"mw-editsection-bracket\">[</span><a href=\"/w/index.php?title=Large_language_model&amp;action=edit&amp;section=16\" title=\"Edit section: Agency\"><span>edit</span></a><span class=\"mw-editsection-bracket\">]</span></span></div>\n<p>An LLM is typically not an <a href=\"/wiki/Autonomous_agent\" title=\"Autonomous agent\">autonomous agent</a> by itself, as it lacks the ability to interact with dynamic environments, recall past behaviors, and plan future actions, but can be transformed into one by integrating modules like profiling, memory, planning, and action.<sup class=\"reference\" id=\"cite_ref-64\"><a href=\"#cite_note-64\"><span class=\"cite-bracket\">[</span>64<span class=\"cite-bracket\">]</span></a></sup>\n</p><p>The <a class=\"new\" href=\"/w/index.php?title=ReAct_pattern&amp;action=edit&amp;redlink=1\" title=\"ReAct pattern (page does not exist)\">ReAct pattern</a>, a portmanteau of \"Reason + Act\", constructs an <a href=\"/wiki/Intelligent_agent\" title=\"Intelligent agent\">agent</a> out of an LLM, using the LLM as a planner. The LLM is prompted to \"think out loud\". Specifically, the language model is prompted with a textual description of the environment, a goal, a list of possible actions, and a record of the actions and observations so far. It generates one or more thoughts before generating an action, which is then executed in the environment.<sup class=\"reference\" id=\"cite_ref-DmvNE_65-0\"><a href=\"#cite_note-DmvNE-65\"><span class=\"cite-bracket\">[</span>65<span class=\"cite-bracket\">]</span></a></sup> The linguistic description of the environment given to the LLM planner can even be the LaTeX code of a paper describing the environment.<sup class=\"reference\" id=\"cite_ref-JS8Vd_66-0\"><a href=\"#cite_note-JS8Vd-66\"><span class=\"cite-bracket\">[</span>66<span class=\"cite-bracket\">]</span></a></sup>\n</p><p>In the DEPS (\"Describe, Explain, Plan and Select\") method, an LLM is first connected to the visual world via image descriptions, then it is prompted to produce plans for complex tasks and behaviors based on its pretrained knowledge and environmental feedback it receives.<sup class=\"reference\" id=\"cite_ref-67\"><a href=\"#cite_note-67\"><span class=\"cite-bracket\">[</span>67<span class=\"cite-bracket\">]</span></a></sup>\n</p><p>The Reflexion method<sup class=\"reference\" id=\"cite_ref-sbB2T_68-0\"><a href=\"#cite_note-sbB2T-68\"><span class=\"cite-bracket\">[</span>68<span class=\"cite-bracket\">]</span></a></sup> constructs an agent that learns over multiple episodes. At the end of each episode, the LLM is given the record of the episode, and prompted to think up \"lessons learned\", which would help it perform better at a subsequent episode. These \"lessons learned\" are given to the agent in the subsequent episodes.<sup class=\"noprint Inline-Template Template-Fact\" style=\"white-space:nowrap;\">[<i><a href=\"/wiki/Wikipedia:Citation_needed\" title=\"Wikipedia:Citation needed\"><span title=\"This claim needs references to reliable sources. (February 2024)\">citation needed</span></a></i>]</sup>\n</p><p><a href=\"/wiki/Monte_Carlo_tree_search\" title=\"Monte Carlo tree search\">Monte Carlo tree search</a> can use an LLM as rollout heuristic. When a programmatic world model is not available, an LLM can also be prompted with a description of the environment to act as world model.<sup class=\"reference\" id=\"cite_ref-ltTer_69-0\"><a href=\"#cite_note-ltTer-69\"><span class=\"cite-bracket\">[</span>69<span class=\"cite-bracket\">]</span></a></sup>\n</p><p>For open-ended exploration, an LLM can be used to score observations for their \"interestingness\", which can be used as a reward signal to guide a normal (non-LLM) reinforcement learning agent.<sup class=\"reference\" id=\"cite_ref-mBvD9_70-0\"><a href=\"#cite_note-mBvD9-70\"><span class=\"cite-bracket\">[</span>70<span class=\"cite-bracket\">]</span></a></sup> Alternatively, it can <a href=\"/wiki/Zone_of_proximal_development\" title=\"Zone of proximal development\">propose increasingly difficult tasks</a> for <a href=\"/wiki/Curriculum_learning\" title=\"Curriculum learning\">curriculum learning</a>.<sup class=\"reference\" id=\"cite_ref-:0_71-0\"><a href=\"#cite_note-:0-71\"><span class=\"cite-bracket\">[</span>71<span class=\"cite-bracket\">]</span></a></sup> Instead of outputting individual actions, an LLM planner can also construct \"skills\", or <a href=\"/wiki/Function_(computer_programming)\" title=\"Function (computer programming)\">functions</a> for complex action sequences. The skills can be stored and later invoked, allowing increasing levels of abstraction in planning.<sup class=\"reference\" id=\"cite_ref-:0_71-1\"><a href=\"#cite_note-:0-71\"><span class=\"cite-bracket\">[</span>71<span class=\"cite-bracket\">]</span></a></sup>\n</p><p>LLM-powered agents can keep a long-term memory of its previous contexts, and the memory can be retrieved in the same way as Retrieval Augmented Generation. Multiple such agents can interact socially.<sup class=\"reference\" id=\"cite_ref-XuvjF_72-0\"><a href=\"#cite_note-XuvjF-72\"><span class=\"cite-bracket\">[</span>72<span class=\"cite-bracket\">]</span></a></sup>\n</p>\n<div class=\"mw-heading mw-heading2\"><h2 id=\"Compression\">Compression</h2><span class=\"mw-editsection\"><span class=\"mw-editsection-bracket\">[</span><a href=\"/w/index.php?title=Large_language_model&amp;action=edit&amp;section=17\" title=\"Edit section: Compression\"><span>edit</span></a><span class=\"mw-editsection-bracket\">]</span></span></div>\n<p>Typically, LLMs are trained with single- or half-precision floating point numbers (float32 and float16). One float16 has 16 bits, or 2 bytes, and so one billion parameters require 2 gigabytes. The largest models typically have 100 billion parameters, requiring 200 gigabytes to load, which places them outside the range of most consumer electronics.<sup class=\"reference\" id=\"cite_ref-73\"><a href=\"#cite_note-73\"><span class=\"cite-bracket\">[</span>73<span class=\"cite-bracket\">]</span></a></sup>\n</p><p><i>Post-training <a href=\"/wiki/Quantization_(signal_processing)\" title=\"Quantization (signal processing)\">quantization</a></i><sup class=\"reference\" id=\"cite_ref-LS2Go_74-0\"><a href=\"#cite_note-LS2Go-74\"><span class=\"cite-bracket\">[</span>74<span class=\"cite-bracket\">]</span></a></sup> aims to decrease the space requirement by lowering precision of the parameters of a trained model, while preserving most of its performance.<sup class=\"reference\" id=\"cite_ref-cpzcK_75-0\"><a href=\"#cite_note-cpzcK-75\"><span class=\"cite-bracket\">[</span>75<span class=\"cite-bracket\">]</span></a></sup><sup class=\"reference\" id=\"cite_ref-QVU95_76-0\"><a href=\"#cite_note-QVU95-76\"><span class=\"cite-bracket\">[</span>76<span class=\"cite-bracket\">]</span></a></sup> The simplest form of quantization simply truncates all numbers to a given number of bits. It can be improved by using a different quantization <a href=\"/wiki/Block_cipher\" title=\"Block cipher\">codebook</a> per layer. Further improvement can be done by applying <a href=\"/wiki/Mixed-precision_arithmetic\" title=\"Mixed-precision arithmetic\">different precisions</a> to different parameters, with higher precision for particularly important parameters (\"outlier weights\").<sup class=\"reference\" id=\"cite_ref-dU9Bu_77-0\"><a href=\"#cite_note-dU9Bu-77\"><span class=\"cite-bracket\">[</span>77<span class=\"cite-bracket\">]</span></a></sup> See <sup class=\"reference\" id=\"cite_ref-78\"><a href=\"#cite_note-78\"><span class=\"cite-bracket\">[</span>78<span class=\"cite-bracket\">]</span></a></sup> for a visual guide.\n</p><p>While quantized models are typically frozen, and only pre-quantized models are fine-tuned, quantized models can still be fine-tuned.<sup class=\"reference\" id=\"cite_ref-D0nFA_79-0\"><a href=\"#cite_note-D0nFA-79\"><span class=\"cite-bracket\">[</span>79<span class=\"cite-bracket\">]</span></a></sup>\n</p>\n<div class=\"mw-heading mw-heading2\"><h2 id=\"Multimodality\">Multimodality</h2><span class=\"mw-editsection\"><span class=\"mw-editsection-bracket\">[</span><a href=\"/w/index.php?title=Large_language_model&amp;action=edit&amp;section=18\" title=\"Edit section: Multimodality\"><span>edit</span></a><span class=\"mw-editsection-bracket\">]</span></span></div>\n<link href=\"mw-data:TemplateStyles:r1236090951\" rel=\"mw-deduplicated-inline-style\"/><div class=\"hatnote navigation-not-searchable\" role=\"note\">See also: <a href=\"/wiki/Multimodal_learning\" title=\"Multimodal learning\">Multimodal learning</a></div>\n<p>Multimodality means \"having several modalities\", and a <a href=\"/wiki/Modality_(human%E2%80%93computer_interaction)\" title=\"Modality (human–computer interaction)\">\"modality\"</a> refers to a type of input or output, such as video, image, audio, text, <a href=\"/wiki/Proprioception\" title=\"Proprioception\">proprioception</a>, etc.<sup class=\"reference\" id=\"cite_ref-80\"><a href=\"#cite_note-80\"><span class=\"cite-bracket\">[</span>80<span class=\"cite-bracket\">]</span></a></sup> There have been many AI models trained specifically to ingest one modality and output another modality, such as <a href=\"/wiki/AlexNet\" title=\"AlexNet\">AlexNet</a> for image to label,<sup class=\"reference\" id=\"cite_ref-81\"><a href=\"#cite_note-81\"><span class=\"cite-bracket\">[</span>81<span class=\"cite-bracket\">]</span></a></sup> <a class=\"mw-redirect\" href=\"/wiki/Visual_question_answering\" title=\"Visual question answering\">visual question answering</a> for image-text to text,<sup class=\"reference\" id=\"cite_ref-82\"><a href=\"#cite_note-82\"><span class=\"cite-bracket\">[</span>82<span class=\"cite-bracket\">]</span></a></sup> and <a href=\"/wiki/Speech_recognition\" title=\"Speech recognition\">speech recognition</a> for speech to text.\n</p><p>A common method to create multimodal models out of an LLM is to \"tokenize\" the output of a trained encoder. Concretely, one can construct an LLM that can understand images as follows: take a trained LLM, and take a trained image encoder <span class=\"mwe-math-element\"><span class=\"mwe-math-mathml-inline mwe-math-mathml-a11y\" style=\"display: none;\"><math alttext=\"{\\displaystyle E}\" xmlns=\"http://www.w3.org/1998/Math/MathML\">\n<semantics>\n<mrow class=\"MJX-TeXAtom-ORD\">\n<mstyle displaystyle=\"true\" scriptlevel=\"0\">\n<mi>E</mi>\n</mstyle>\n</mrow>\n<annotation encoding=\"application/x-tex\">{\\displaystyle E}</annotation>\n</semantics>\n</math></span><img alt=\"{\\displaystyle E}\" aria-hidden=\"true\" class=\"mwe-math-fallback-image-inline mw-invert skin-invert\" src=\"https://wikimedia.org/api/rest_v1/media/math/render/svg/4232c9de2ee3eec0a9c0a19b15ab92daa6223f9b\" style=\"vertical-align: -0.338ex; width:1.776ex; height:2.176ex;\"/></span>. Make a small multilayered perceptron <span class=\"mwe-math-element\"><span class=\"mwe-math-mathml-inline mwe-math-mathml-a11y\" style=\"display: none;\"><math alttext=\"{\\displaystyle f}\" xmlns=\"http://www.w3.org/1998/Math/MathML\">\n<semantics>\n<mrow class=\"MJX-TeXAtom-ORD\">\n<mstyle displaystyle=\"true\" scriptlevel=\"0\">\n<mi>f</mi>\n</mstyle>\n</mrow>\n<annotation encoding=\"application/x-tex\">{\\displaystyle f}</annotation>\n</semantics>\n</math></span><img alt=\"{\\displaystyle f}\" aria-hidden=\"true\" class=\"mwe-math-fallback-image-inline mw-invert skin-invert\" src=\"https://wikimedia.org/api/rest_v1/media/math/render/svg/132e57acb643253e7810ee9702d9581f159a1c61\" style=\"vertical-align: -0.671ex; width:1.279ex; height:2.509ex;\"/></span>, so that for any image <span class=\"mwe-math-element\"><span class=\"mwe-math-mathml-inline mwe-math-mathml-a11y\" style=\"display: none;\"><math alttext=\"{\\displaystyle y}\" xmlns=\"http://www.w3.org/1998/Math/MathML\">\n<semantics>\n<mrow class=\"MJX-TeXAtom-ORD\">\n<mstyle displaystyle=\"true\" scriptlevel=\"0\">\n<mi>y</mi>\n</mstyle>\n</mrow>\n<annotation encoding=\"application/x-tex\">{\\displaystyle y}</annotation>\n</semantics>\n</math></span><img alt=\"{\\displaystyle y}\" aria-hidden=\"true\" class=\"mwe-math-fallback-image-inline mw-invert skin-invert\" src=\"https://wikimedia.org/api/rest_v1/media/math/render/svg/b8a6208ec717213d4317e666f1ae872e00620a0d\" style=\"vertical-align: -0.671ex; width:1.155ex; height:2.009ex;\"/></span>, the post-processed vector <span class=\"mwe-math-element\"><span class=\"mwe-math-mathml-inline mwe-math-mathml-a11y\" style=\"display: none;\"><math alttext=\"{\\displaystyle f(E(y))}\" xmlns=\"http://www.w3.org/1998/Math/MathML\">\n<semantics>\n<mrow class=\"MJX-TeXAtom-ORD\">\n<mstyle displaystyle=\"true\" scriptlevel=\"0\">\n<mi>f</mi>\n<mo stretchy=\"false\">(</mo>\n<mi>E</mi>\n<mo stretchy=\"false\">(</mo>\n<mi>y</mi>\n<mo stretchy=\"false\">)</mo>\n<mo stretchy=\"false\">)</mo>\n</mstyle>\n</mrow>\n<annotation encoding=\"application/x-tex\">{\\displaystyle f(E(y))}</annotation>\n</semantics>\n</math></span><img alt=\"{\\displaystyle f(E(y))}\" aria-hidden=\"true\" class=\"mwe-math-fallback-image-inline mw-invert skin-invert\" src=\"https://wikimedia.org/api/rest_v1/media/math/render/svg/8d41d0ec0611a795f65ea14a43b8016462703a8e\" style=\"vertical-align: -0.838ex; width:7.828ex; height:2.843ex;\"/></span> has the same dimensions as an encoded token. That is an \"image token\". Then, one can interleave text tokens and image tokens. The compound model is then fine-tuned on an image-text dataset. This basic construction can be applied with more sophistication to improve the model. The image encoder may be frozen to improve stability.<sup class=\"reference\" id=\"cite_ref-83\"><a href=\"#cite_note-83\"><span class=\"cite-bracket\">[</span>83<span class=\"cite-bracket\">]</span></a></sup>\n</p><p>Flamingo demonstrated the effectiveness of the tokenization method, finetuning a pair of pretrained language model and image encoder to perform better on visual question answering than models trained from scratch.<sup class=\"reference\" id=\"cite_ref-84\"><a href=\"#cite_note-84\"><span class=\"cite-bracket\">[</span>84<span class=\"cite-bracket\">]</span></a></sup> <a class=\"mw-redirect\" href=\"/wiki/Pathways_Language_Model\" title=\"Pathways Language Model\">Google PaLM</a> model was fine-tuned into a multimodal model PaLM-E using the tokenization method, and applied to robotic control.<sup class=\"reference\" id=\"cite_ref-85\"><a href=\"#cite_note-85\"><span class=\"cite-bracket\">[</span>85<span class=\"cite-bracket\">]</span></a></sup> <a class=\"mw-redirect\" href=\"/wiki/LLaMA\" title=\"LLaMA\">LLaMA</a> models have also been turned multimodal using the tokenization method, to allow image inputs,<sup class=\"reference\" id=\"cite_ref-86\"><a href=\"#cite_note-86\"><span class=\"cite-bracket\">[</span>86<span class=\"cite-bracket\">]</span></a></sup> and video inputs.<sup class=\"reference\" id=\"cite_ref-87\"><a href=\"#cite_note-87\"><span class=\"cite-bracket\">[</span>87<span class=\"cite-bracket\">]</span></a></sup>\n</p><p><a href=\"/wiki/GPT-4\" title=\"GPT-4\">GPT-4</a> can use both text and image as inputs<sup class=\"reference\" id=\"cite_ref-88\"><a href=\"#cite_note-88\"><span class=\"cite-bracket\">[</span>88<span class=\"cite-bracket\">]</span></a></sup> (although the vision component was not released to the public until GPT-4V<sup class=\"reference\" id=\"cite_ref-89\"><a href=\"#cite_note-89\"><span class=\"cite-bracket\">[</span>89<span class=\"cite-bracket\">]</span></a></sup>); <a href=\"/wiki/Google_DeepMind\" title=\"Google DeepMind\">Google DeepMind</a>'s <a href=\"/wiki/Gemini_(language_model)\" title=\"Gemini (language model)\">Gemini</a> is also multimodal.<sup class=\"reference\" id=\"cite_ref-90\"><a href=\"#cite_note-90\"><span class=\"cite-bracket\">[</span>90<span class=\"cite-bracket\">]</span></a></sup>  Mistral introduced its own multimodel Pixtral 12B model in September 2024.<sup class=\"reference\" id=\"cite_ref-91\"><a href=\"#cite_note-91\"><span class=\"cite-bracket\">[</span>91<span class=\"cite-bracket\">]</span></a></sup>\n</p>\n<div class=\"mw-heading mw-heading2\"><h2 id=\"Properties\">Properties</h2><span class=\"mw-editsection\"><span class=\"mw-editsection-bracket\">[</span><a href=\"/w/index.php?title=Large_language_model&amp;action=edit&amp;section=19\" title=\"Edit section: Properties\"><span>edit</span></a><span class=\"mw-editsection-bracket\">]</span></span></div>\n<div class=\"mw-heading mw-heading3\"><h3 id=\"Scaling_laws\">Scaling laws</h3><span class=\"mw-editsection\"><span class=\"mw-editsection-bracket\">[</span><a href=\"/w/index.php?title=Large_language_model&amp;action=edit&amp;section=20\" title=\"Edit section: Scaling laws\"><span>edit</span></a><span class=\"mw-editsection-bracket\">]</span></span></div>\n<link href=\"mw-data:TemplateStyles:r1236090951\" rel=\"mw-deduplicated-inline-style\"/><div class=\"hatnote navigation-not-searchable\" role=\"note\">Main article: <a href=\"/wiki/Neural_scaling_law\" title=\"Neural scaling law\">Neural scaling law</a></div>\n<p>The performance of an LLM after pretraining largely depends on the:\n</p>\n<ul><li>cost of pretraining <small><span class=\"mwe-math-element\"><span class=\"mwe-math-mathml-inline mwe-math-mathml-a11y\" style=\"display: none;\"><math alttext=\"{\\displaystyle C}\" xmlns=\"http://www.w3.org/1998/Math/MathML\">\n<semantics>\n<mrow class=\"MJX-TeXAtom-ORD\">\n<mstyle displaystyle=\"true\" scriptlevel=\"0\">\n<mi>C</mi>\n</mstyle>\n</mrow>\n<annotation encoding=\"application/x-tex\">{\\displaystyle C}</annotation>\n</semantics>\n</math></span><img alt=\"{\\displaystyle C}\" aria-hidden=\"true\" class=\"mwe-math-fallback-image-inline mw-invert skin-invert\" src=\"https://wikimedia.org/api/rest_v1/media/math/render/svg/4fc55753007cd3c18576f7933f6f089196732029\" style=\"vertical-align: -0.338ex; width:1.766ex; height:2.176ex;\"/></span></small> (the total amount of compute used),</li>\n<li>size of the <a class=\"mw-redirect\" href=\"/wiki/Artificial_neural_network\" title=\"Artificial neural network\">artificial neural network</a> itself, such as number of parameters <small><span class=\"mwe-math-element\"><span class=\"mwe-math-mathml-inline mwe-math-mathml-a11y\" style=\"display: none;\"><math alttext=\"{\\displaystyle N}\" xmlns=\"http://www.w3.org/1998/Math/MathML\">\n<semantics>\n<mrow class=\"MJX-TeXAtom-ORD\">\n<mstyle displaystyle=\"true\" scriptlevel=\"0\">\n<mi>N</mi>\n</mstyle>\n</mrow>\n<annotation encoding=\"application/x-tex\">{\\displaystyle N}</annotation>\n</semantics>\n</math></span><img alt=\"{\\displaystyle N}\" aria-hidden=\"true\" class=\"mwe-math-fallback-image-inline mw-invert skin-invert\" src=\"https://wikimedia.org/api/rest_v1/media/math/render/svg/f5e3890c981ae85503089652feb48b191b57aae3\" style=\"vertical-align: -0.338ex; width:2.064ex; height:2.176ex;\"/></span></small> (i.e. amount of neurons in its layers, amount of weights between them and biases),</li>\n<li>size of its pretraining dataset (i.e. number of tokens in corpus, <small><span class=\"mwe-math-element\"><span class=\"mwe-math-mathml-inline mwe-math-mathml-a11y\" style=\"display: none;\"><math alttext=\"{\\displaystyle D}\" xmlns=\"http://www.w3.org/1998/Math/MathML\">\n<semantics>\n<mrow class=\"MJX-TeXAtom-ORD\">\n<mstyle displaystyle=\"true\" scriptlevel=\"0\">\n<mi>D</mi>\n</mstyle>\n</mrow>\n<annotation encoding=\"application/x-tex\">{\\displaystyle D}</annotation>\n</semantics>\n</math></span><img alt=\"{\\displaystyle D}\" aria-hidden=\"true\" class=\"mwe-math-fallback-image-inline mw-invert skin-invert\" src=\"https://wikimedia.org/api/rest_v1/media/math/render/svg/f34a0c600395e5d4345287e21fb26efd386990e6\" style=\"vertical-align: -0.338ex; width:1.924ex; height:2.176ex;\"/></span></small>).</li></ul>\n<p>\"Scaling laws\" are <a href=\"/wiki/Empirical_statistical_laws\" title=\"Empirical statistical laws\">empirical statistical laws</a> that predict LLM performance based on such factors. One particular scaling law (\"<a class=\"mw-redirect\" href=\"/wiki/Chinchilla_AI\" title=\"Chinchilla AI\">Chinchilla scaling</a>\") for LLM autoregressively trained for one epoch, with a <a class=\"mw-redirect\" href=\"/wiki/Log-log_plot\" title=\"Log-log plot\">log-log</a> <a href=\"/wiki/Learning_rate\" title=\"Learning rate\">learning rate</a> schedule, states that:<sup class=\"reference\" id=\"cite_ref-fJta3_92-0\"><a href=\"#cite_note-fJta3-92\"><span class=\"cite-bracket\">[</span>92<span class=\"cite-bracket\">]</span></a></sup>\n<span class=\"mwe-math-element\"><span class=\"mwe-math-mathml-display mwe-math-mathml-a11y\" style=\"display: none;\"><math alttext=\"{\\displaystyle {\\begin{cases}C=C_{0}ND\\\\[6pt]L={\\frac {A}{N^{\\alpha }}}+{\\frac {B}{D^{\\beta }}}+L_{0}\\end{cases}}}\" display=\"block\" xmlns=\"http://www.w3.org/1998/Math/MathML\">\n<semantics>\n<mrow class=\"MJX-TeXAtom-ORD\">\n<mstyle displaystyle=\"true\" scriptlevel=\"0\">\n<mrow class=\"MJX-TeXAtom-ORD\">\n<mrow>\n<mo>{</mo>\n<mtable columnalign=\"left left\" columnspacing=\"1em\" displaystyle=\"false\" rowspacing=\"0.8em 0.2em\">\n<mtr>\n<mtd>\n<mi>C</mi>\n<mo>=</mo>\n<msub>\n<mi>C</mi>\n<mrow class=\"MJX-TeXAtom-ORD\">\n<mn>0</mn>\n</mrow>\n</msub>\n<mi>N</mi>\n<mi>D</mi>\n</mtd>\n</mtr>\n<mtr>\n<mtd>\n<mi>L</mi>\n<mo>=</mo>\n<mrow class=\"MJX-TeXAtom-ORD\">\n<mfrac>\n<mi>A</mi>\n<msup>\n<mi>N</mi>\n<mrow class=\"MJX-TeXAtom-ORD\">\n<mi>α<!-- α --></mi>\n</mrow>\n</msup>\n</mfrac>\n</mrow>\n<mo>+</mo>\n<mrow class=\"MJX-TeXAtom-ORD\">\n<mfrac>\n<mi>B</mi>\n<msup>\n<mi>D</mi>\n<mrow class=\"MJX-TeXAtom-ORD\">\n<mi>β<!-- β --></mi>\n</mrow>\n</msup>\n</mfrac>\n</mrow>\n<mo>+</mo>\n<msub>\n<mi>L</mi>\n<mrow class=\"MJX-TeXAtom-ORD\">\n<mn>0</mn>\n</mrow>\n</msub>\n</mtd>\n</mtr>\n</mtable>\n<mo fence=\"true\" stretchy=\"true\" symmetric=\"true\"></mo>\n</mrow>\n</mrow>\n</mstyle>\n</mrow>\n<annotation encoding=\"application/x-tex\">{\\displaystyle {\\begin{cases}C=C_{0}ND\\\\[6pt]L={\\frac {A}{N^{\\alpha }}}+{\\frac {B}{D^{\\beta }}}+L_{0}\\end{cases}}}</annotation>\n</semantics>\n</math></span><img alt=\"{\\displaystyle {\\begin{cases}C=C_{0}ND\\\\[6pt]L={\\frac {A}{N^{\\alpha }}}+{\\frac {B}{D^{\\beta }}}+L_{0}\\end{cases}}}\" aria-hidden=\"true\" class=\"mwe-math-fallback-image-display mw-invert skin-invert\" src=\"https://wikimedia.org/api/rest_v1/media/math/render/svg/39435f4ecd5e00c0714a4f7f71cc0b91f5973cdd\" style=\"vertical-align: -3.505ex; width:22.298ex; height:8.176ex;\"/></span> where the variables are\n</p>\n<ul><li><small><span class=\"mwe-math-element\"><span class=\"mwe-math-mathml-inline mwe-math-mathml-a11y\" style=\"display: none;\"><math alttext=\"{\\displaystyle C}\" xmlns=\"http://www.w3.org/1998/Math/MathML\">\n<semantics>\n<mrow class=\"MJX-TeXAtom-ORD\">\n<mstyle displaystyle=\"true\" scriptlevel=\"0\">\n<mi>C</mi>\n</mstyle>\n</mrow>\n<annotation encoding=\"application/x-tex\">{\\displaystyle C}</annotation>\n</semantics>\n</math></span><img alt=\"{\\displaystyle C}\" aria-hidden=\"true\" class=\"mwe-math-fallback-image-inline mw-invert skin-invert\" src=\"https://wikimedia.org/api/rest_v1/media/math/render/svg/4fc55753007cd3c18576f7933f6f089196732029\" style=\"vertical-align: -0.338ex; width:1.766ex; height:2.176ex;\"/></span></small> is the cost of training the model, in <a class=\"mw-redirect\" href=\"/wiki/FLOPS\" title=\"FLOPS\">FLOPs</a>.</li>\n<li><small><span class=\"mwe-math-element\"><span class=\"mwe-math-mathml-inline mwe-math-mathml-a11y\" style=\"display: none;\"><math alttext=\"{\\displaystyle N}\" xmlns=\"http://www.w3.org/1998/Math/MathML\">\n<semantics>\n<mrow class=\"MJX-TeXAtom-ORD\">\n<mstyle displaystyle=\"true\" scriptlevel=\"0\">\n<mi>N</mi>\n</mstyle>\n</mrow>\n<annotation encoding=\"application/x-tex\">{\\displaystyle N}</annotation>\n</semantics>\n</math></span><img alt=\"{\\displaystyle N}\" aria-hidden=\"true\" class=\"mwe-math-fallback-image-inline mw-invert skin-invert\" src=\"https://wikimedia.org/api/rest_v1/media/math/render/svg/f5e3890c981ae85503089652feb48b191b57aae3\" style=\"vertical-align: -0.338ex; width:2.064ex; height:2.176ex;\"/></span></small> is the number of parameters in the model.</li>\n<li><small><span class=\"mwe-math-element\"><span class=\"mwe-math-mathml-inline mwe-math-mathml-a11y\" style=\"display: none;\"><math alttext=\"{\\displaystyle D}\" xmlns=\"http://www.w3.org/1998/Math/MathML\">\n<semantics>\n<mrow class=\"MJX-TeXAtom-ORD\">\n<mstyle displaystyle=\"true\" scriptlevel=\"0\">\n<mi>D</mi>\n</mstyle>\n</mrow>\n<annotation encoding=\"application/x-tex\">{\\displaystyle D}</annotation>\n</semantics>\n</math></span><img alt=\"{\\displaystyle D}\" aria-hidden=\"true\" class=\"mwe-math-fallback-image-inline mw-invert skin-invert\" src=\"https://wikimedia.org/api/rest_v1/media/math/render/svg/f34a0c600395e5d4345287e21fb26efd386990e6\" style=\"vertical-align: -0.338ex; width:1.924ex; height:2.176ex;\"/></span></small> is the number of tokens in the training set.</li>\n<li><small><span class=\"mwe-math-element\"><span class=\"mwe-math-mathml-inline mwe-math-mathml-a11y\" style=\"display: none;\"><math alttext=\"{\\displaystyle L}\" xmlns=\"http://www.w3.org/1998/Math/MathML\">\n<semantics>\n<mrow class=\"MJX-TeXAtom-ORD\">\n<mstyle displaystyle=\"true\" scriptlevel=\"0\">\n<mi>L</mi>\n</mstyle>\n</mrow>\n<annotation encoding=\"application/x-tex\">{\\displaystyle L}</annotation>\n</semantics>\n</math></span><img alt=\"{\\displaystyle L}\" aria-hidden=\"true\" class=\"mwe-math-fallback-image-inline mw-invert skin-invert\" src=\"https://wikimedia.org/api/rest_v1/media/math/render/svg/103168b86f781fe6e9a4a87b8ea1cebe0ad4ede8\" style=\"vertical-align: -0.338ex; width:1.583ex; height:2.176ex;\"/></span></small> is the average negative log-likelihood loss per token (<a href=\"/wiki/Nat_(unit)\" title=\"Nat (unit)\">nats</a>/token), achieved by the trained LLM on the test dataset.</li></ul>\n<p>and the statistical hyper-parameters are\n</p>\n<ul><li><small><span class=\"mwe-math-element\"><span class=\"mwe-math-mathml-inline mwe-math-mathml-a11y\" style=\"display: none;\"><math alttext=\"{\\displaystyle C_{0}=6}\" xmlns=\"http://www.w3.org/1998/Math/MathML\">\n<semantics>\n<mrow class=\"MJX-TeXAtom-ORD\">\n<mstyle displaystyle=\"true\" scriptlevel=\"0\">\n<msub>\n<mi>C</mi>\n<mrow class=\"MJX-TeXAtom-ORD\">\n<mn>0</mn>\n</mrow>\n</msub>\n<mo>=</mo>\n<mn>6</mn>\n</mstyle>\n</mrow>\n<annotation encoding=\"application/x-tex\">{\\displaystyle C_{0}=6}</annotation>\n</semantics>\n</math></span><img alt=\"{\\displaystyle C_{0}=6}\" aria-hidden=\"true\" class=\"mwe-math-fallback-image-inline mw-invert skin-invert\" src=\"https://wikimedia.org/api/rest_v1/media/math/render/svg/b05c98b1743f05e046a3f3bb0a966fa898e431e2\" style=\"vertical-align: -0.671ex; width:6.977ex; height:2.509ex;\"/></span></small>, meaning that it costs 6 FLOPs per parameter to train on one token. Note that training cost is much higher than inference cost, where it costs 1 to 2 FLOPs per parameter to infer on one token.<sup class=\"reference\" id=\"cite_ref-kaplan-scaling_57-1\"><a href=\"#cite_note-kaplan-scaling-57\"><span class=\"cite-bracket\">[</span>57<span class=\"cite-bracket\">]</span></a></sup></li>\n<li><small><span class=\"mwe-math-element\"><span class=\"mwe-math-mathml-inline mwe-math-mathml-a11y\" style=\"display: none;\"><math alttext=\"{\\displaystyle \\alpha =0.34,\\beta =0.28,A=406.4,B=410.7,L_{0}=1.69}\" xmlns=\"http://www.w3.org/1998/Math/MathML\">\n<semantics>\n<mrow class=\"MJX-TeXAtom-ORD\">\n<mstyle displaystyle=\"true\" scriptlevel=\"0\">\n<mi>α<!-- α --></mi>\n<mo>=</mo>\n<mn>0.34</mn>\n<mo>,</mo>\n<mi>β<!-- β --></mi>\n<mo>=</mo>\n<mn>0.28</mn>\n<mo>,</mo>\n<mi>A</mi>\n<mo>=</mo>\n<mn>406.4</mn>\n<mo>,</mo>\n<mi>B</mi>\n<mo>=</mo>\n<mn>410.7</mn>\n<mo>,</mo>\n<msub>\n<mi>L</mi>\n<mrow class=\"MJX-TeXAtom-ORD\">\n<mn>0</mn>\n</mrow>\n</msub>\n<mo>=</mo>\n<mn>1.69</mn>\n</mstyle>\n</mrow>\n<annotation encoding=\"application/x-tex\">{\\displaystyle \\alpha =0.34,\\beta =0.28,A=406.4,B=410.7,L_{0}=1.69}</annotation>\n</semantics>\n</math></span><img alt=\"{\\displaystyle \\alpha =0.34,\\beta =0.28,A=406.4,B=410.7,L_{0}=1.69}\" aria-hidden=\"true\" class=\"mwe-math-fallback-image-inline mw-invert skin-invert\" src=\"https://wikimedia.org/api/rest_v1/media/math/render/svg/848b6d78d881ed6da8d6b60e8d788bc799525401\" style=\"vertical-align: -0.671ex; width:51.588ex; height:2.509ex;\"/></span></small></li></ul>\n<div class=\"mw-heading mw-heading3\"><h3 id=\"Emergent_abilities\">Emergent abilities</h3><span class=\"mw-editsection\"><span class=\"mw-editsection-bracket\">[</span><a href=\"/w/index.php?title=Large_language_model&amp;action=edit&amp;section=21\" title=\"Edit section: Emergent abilities\"><span>edit</span></a><span class=\"mw-editsection-bracket\">]</span></span></div>\n<p><span class=\"anchor\" id=\"Emergent_abilities\"></span></p><figure class=\"mw-default-size\" typeof=\"mw:File/Thumb\"><a class=\"mw-file-description\" href=\"/wiki/File:LLM_emergent_benchmarks.png\"><img class=\"mw-file-element\" data-file-height=\"858\" data-file-width=\"1297\" decoding=\"async\" height=\"146\" src=\"//upload.wikimedia.org/wikipedia/commons/thumb/5/57/LLM_emergent_benchmarks.png/220px-LLM_emergent_benchmarks.png\" srcset=\"//upload.wikimedia.org/wikipedia/commons/thumb/5/57/LLM_emergent_benchmarks.png/330px-LLM_emergent_benchmarks.png 1.5x, //upload.wikimedia.org/wikipedia/commons/thumb/5/57/LLM_emergent_benchmarks.png/440px-LLM_emergent_benchmarks.png 2x\" width=\"220\"/></a><figcaption>At point(s) referred to as <a class=\"mw-redirect\" href=\"/wiki/Broken_Neural_Scaling_Law\" title=\"Broken Neural Scaling Law\">breaks</a>,<sup class=\"reference\" id=\"cite_ref-IYm4Q_93-0\"><a href=\"#cite_note-IYm4Q-93\"><span class=\"cite-bracket\">[</span>93<span class=\"cite-bracket\">]</span></a></sup> the lines change their slopes, appearing on a linear-log plot as a series of linear segments connected by arcs.</figcaption></figure>\n<p>Performance of bigger models on various tasks, when plotted on a log-log scale, appears as a linear extrapolation of performance achieved by smaller models. However, this linearity may be punctuated by \"<a class=\"mw-redirect\" href=\"/wiki/Broken_Neural_Scaling_Law\" title=\"Broken Neural Scaling Law\">break(s)</a>\"<sup class=\"reference\" id=\"cite_ref-IYm4Q_93-1\"><a href=\"#cite_note-IYm4Q-93\"><span class=\"cite-bracket\">[</span>93<span class=\"cite-bracket\">]</span></a></sup> in the scaling law, where the slope of the line changes abruptly, and where larger models acquire \"emergent abilities\".<sup class=\"reference\" id=\"cite_ref-emergentpaper_42-1\"><a href=\"#cite_note-emergentpaper-42\"><span class=\"cite-bracket\">[</span>42<span class=\"cite-bracket\">]</span></a></sup><sup class=\"reference\" id=\"cite_ref-JM6s1_94-0\"><a href=\"#cite_note-JM6s1-94\"><span class=\"cite-bracket\">[</span>94<span class=\"cite-bracket\">]</span></a></sup> They arise from the complex interaction of the model's components and are not explicitly programmed or designed.<sup class=\"reference\" id=\"cite_ref-Bowman_95-0\"><a href=\"#cite_note-Bowman-95\"><span class=\"cite-bracket\">[</span>95<span class=\"cite-bracket\">]</span></a></sup>\n</p><p>Furthermore, recent research has demonstrated that AI systems, including large language models, can employ heuristic reasoning akin to human cognition. They balance between exhaustive logical processing and the use of cognitive shortcuts (heuristics), adapting their reasoning strategies to optimize between accuracy and effort. This behavior aligns with principles of resource-rational human cognition, as discussed in classical theories of bounded rationality and dual-process theory.<sup class=\"reference\" id=\"cite_ref-Heuristic-Mukherjee_96-0\"><a href=\"#cite_note-Heuristic-Mukherjee-96\"><span class=\"cite-bracket\">[</span>96<span class=\"cite-bracket\">]</span></a></sup>\n</p><p>The most intriguing among emergent abilities is <a class=\"mw-redirect\" href=\"/wiki/In-context_learning\" title=\"In-context learning\">in-context learning</a> from example demonstrations.<sup class=\"reference\" id=\"cite_ref-Hahn_20230314_97-0\"><a href=\"#cite_note-Hahn_20230314-97\"><span class=\"cite-bracket\">[</span>97<span class=\"cite-bracket\">]</span></a></sup> In-context learning is involved in tasks, such as:\n</p>\n<ul><li>reported arithmetics, decoding the <a href=\"/wiki/International_Phonetic_Alphabet\" title=\"International Phonetic Alphabet\">International Phonetic Alphabet</a>, unscrambling a word's letters, disambiguate word in context,<sup class=\"reference\" id=\"cite_ref-emergentpaper_42-2\"><a href=\"#cite_note-emergentpaper-42\"><span class=\"cite-bracket\">[</span>42<span class=\"cite-bracket\">]</span></a></sup><sup class=\"reference\" id=\"cite_ref-57FEA_98-0\"><a href=\"#cite_note-57FEA-98\"><span class=\"cite-bracket\">[</span>98<span class=\"cite-bracket\">]</span></a></sup><sup class=\"reference\" id=\"cite_ref-TEIkA_99-0\"><a href=\"#cite_note-TEIkA-99\"><span class=\"cite-bracket\">[</span>99<span class=\"cite-bracket\">]</span></a></sup> converting spatial words, <a href=\"/wiki/Cardinal_direction\" title=\"Cardinal direction\">cardinal directions</a> (for example, replying \"northeast\" upon [0, 0, 1; 0, 0, 0; 0, 0, 0]), color terms represented in text.<sup class=\"reference\" id=\"cite_ref-zgy1i_100-0\"><a href=\"#cite_note-zgy1i-100\"><span class=\"cite-bracket\">[</span>100<span class=\"cite-bracket\">]</span></a></sup></li>\n<li><a class=\"mw-redirect\" href=\"/wiki/Chain-of-thought_prompting\" title=\"Chain-of-thought prompting\">chain-of-thought prompting</a>: Model outputs are improved by chain-of-thought prompting only when model size exceeds 62B. Smaller models perform better when prompted to answer immediately, without chain of thought.<sup class=\"reference\" id=\"cite_ref-Imb98_101-0\"><a href=\"#cite_note-Imb98-101\"><span class=\"cite-bracket\">[</span>101<span class=\"cite-bracket\">]</span></a></sup></li>\n<li>identifying offensive content in paragraphs of <a href=\"/wiki/Hinglish\" title=\"Hinglish\">Hinglish</a> (a combination of Hindi and English), and generating a similar English equivalent of <a class=\"mw-redirect\" href=\"/wiki/Kiswahili\" title=\"Kiswahili\">Kiswahili</a> proverbs.<sup class=\"reference\" id=\"cite_ref-CeQVF_102-0\"><a href=\"#cite_note-CeQVF-102\"><span class=\"cite-bracket\">[</span>102<span class=\"cite-bracket\">]</span></a></sup></li></ul>\n<p>Schaeffer <i>et. al.</i> argue that the emergent abilities are not unpredictably acquired, but predictably acquired according to a <a href=\"/wiki/Neural_scaling_law\" title=\"Neural scaling law\">smooth scaling law</a>. The authors considered a toy statistical model of an LLM solving multiple-choice questions, and showed that this statistical model, modified to account for other types of tasks, applies to these tasks as well.<sup class=\"reference\" id=\"cite_ref-C775b_103-0\"><a href=\"#cite_note-C775b-103\"><span class=\"cite-bracket\">[</span>103<span class=\"cite-bracket\">]</span></a></sup>\n</p><p>Let <span class=\"mwe-math-element\"><span class=\"mwe-math-mathml-inline mwe-math-mathml-a11y\" style=\"display: none;\"><math alttext=\"{\\displaystyle x}\" xmlns=\"http://www.w3.org/1998/Math/MathML\">\n<semantics>\n<mrow class=\"MJX-TeXAtom-ORD\">\n<mstyle displaystyle=\"true\" scriptlevel=\"0\">\n<mi>x</mi>\n</mstyle>\n</mrow>\n<annotation encoding=\"application/x-tex\">{\\displaystyle x}</annotation>\n</semantics>\n</math></span><img alt=\"{\\displaystyle x}\" aria-hidden=\"true\" class=\"mwe-math-fallback-image-inline mw-invert skin-invert\" src=\"https://wikimedia.org/api/rest_v1/media/math/render/svg/87f9e315fd7e2ba406057a97300593c4802b53e4\" style=\"vertical-align: -0.338ex; width:1.33ex; height:1.676ex;\"/></span> be the number of parameter count, and <span class=\"mwe-math-element\"><span class=\"mwe-math-mathml-inline mwe-math-mathml-a11y\" style=\"display: none;\"><math alttext=\"{\\displaystyle y}\" xmlns=\"http://www.w3.org/1998/Math/MathML\">\n<semantics>\n<mrow class=\"MJX-TeXAtom-ORD\">\n<mstyle displaystyle=\"true\" scriptlevel=\"0\">\n<mi>y</mi>\n</mstyle>\n</mrow>\n<annotation encoding=\"application/x-tex\">{\\displaystyle y}</annotation>\n</semantics>\n</math></span><img alt=\"{\\displaystyle y}\" aria-hidden=\"true\" class=\"mwe-math-fallback-image-inline mw-invert skin-invert\" src=\"https://wikimedia.org/api/rest_v1/media/math/render/svg/b8a6208ec717213d4317e666f1ae872e00620a0d\" style=\"vertical-align: -0.671ex; width:1.155ex; height:2.009ex;\"/></span> be the performance of the model.\n</p>\n<div style=\"font-size:85%;\">\n<ul><li>When <span class=\"mwe-math-element\"><span class=\"mwe-math-mathml-inline mwe-math-mathml-a11y\" style=\"display: none;\"><math alttext=\"{\\displaystyle y={\\text{average }}\\Pr({\\text{correct token}})}\" xmlns=\"http://www.w3.org/1998/Math/MathML\">\n<semantics>\n<mrow class=\"MJX-TeXAtom-ORD\">\n<mstyle displaystyle=\"true\" scriptlevel=\"0\">\n<mi>y</mi>\n<mo>=</mo>\n<mrow class=\"MJX-TeXAtom-ORD\">\n<mtext>average </mtext>\n</mrow>\n<mo form=\"prefix\" movablelimits=\"true\">Pr</mo>\n<mo stretchy=\"false\">(</mo>\n<mrow class=\"MJX-TeXAtom-ORD\">\n<mtext>correct token</mtext>\n</mrow>\n<mo stretchy=\"false\">)</mo>\n</mstyle>\n</mrow>\n<annotation encoding=\"application/x-tex\">{\\displaystyle y={\\text{average }}\\Pr({\\text{correct token}})}</annotation>\n</semantics>\n</math></span><img alt=\"{\\displaystyle y={\\text{average }}\\Pr({\\text{correct token}})}\" aria-hidden=\"true\" class=\"mwe-math-fallback-image-inline mw-invert skin-invert\" src=\"https://wikimedia.org/api/rest_v1/media/math/render/svg/25f87a1a04b7eb97aca02ae9170ae7f05e308bd4\" style=\"vertical-align: -0.838ex; width:30.404ex; height:2.843ex;\"/></span>, then <span class=\"mwe-math-element\"><span class=\"mwe-math-mathml-inline mwe-math-mathml-a11y\" style=\"display: none;\"><math alttext=\"{\\displaystyle (\\log x,y)}\" xmlns=\"http://www.w3.org/1998/Math/MathML\">\n<semantics>\n<mrow class=\"MJX-TeXAtom-ORD\">\n<mstyle displaystyle=\"true\" scriptlevel=\"0\">\n<mo stretchy=\"false\">(</mo>\n<mi>log</mi>\n<mo>⁡<!-- ⁡ --></mo>\n<mi>x</mi>\n<mo>,</mo>\n<mi>y</mi>\n<mo stretchy=\"false\">)</mo>\n</mstyle>\n</mrow>\n<annotation encoding=\"application/x-tex\">{\\displaystyle (\\log x,y)}</annotation>\n</semantics>\n</math></span><img alt=\"{\\displaystyle (\\log x,y)}\" aria-hidden=\"true\" class=\"mwe-math-fallback-image-inline mw-invert skin-invert\" src=\"https://wikimedia.org/api/rest_v1/media/math/render/svg/1dccdbdb2af7f930d3fff961d7f76540706bbaf8\" style=\"vertical-align: -0.838ex; width:8.687ex; height:2.843ex;\"/></span> is an exponential curve (before it hits the plateau at one), which looks like emergence.</li>\n<li>When <span class=\"mwe-math-element\"><span class=\"mwe-math-mathml-inline mwe-math-mathml-a11y\" style=\"display: none;\"><math alttext=\"{\\displaystyle y={\\text{average }}\\log(\\Pr({\\text{correct token}}))}\" xmlns=\"http://www.w3.org/1998/Math/MathML\">\n<semantics>\n<mrow class=\"MJX-TeXAtom-ORD\">\n<mstyle displaystyle=\"true\" scriptlevel=\"0\">\n<mi>y</mi>\n<mo>=</mo>\n<mrow class=\"MJX-TeXAtom-ORD\">\n<mtext>average </mtext>\n</mrow>\n<mi>log</mi>\n<mo>⁡<!-- ⁡ --></mo>\n<mo stretchy=\"false\">(</mo>\n<mo form=\"prefix\" movablelimits=\"true\">Pr</mo>\n<mo stretchy=\"false\">(</mo>\n<mrow class=\"MJX-TeXAtom-ORD\">\n<mtext>correct token</mtext>\n</mrow>\n<mo stretchy=\"false\">)</mo>\n<mo stretchy=\"false\">)</mo>\n</mstyle>\n</mrow>\n<annotation encoding=\"application/x-tex\">{\\displaystyle y={\\text{average }}\\log(\\Pr({\\text{correct token}}))}</annotation>\n</semantics>\n</math></span><img alt=\"{\\displaystyle y={\\text{average }}\\log(\\Pr({\\text{correct token}}))}\" aria-hidden=\"true\" class=\"mwe-math-fallback-image-inline mw-invert skin-invert\" src=\"https://wikimedia.org/api/rest_v1/media/math/render/svg/c22c18197c1091afcb5ed896ba90b8429af1c861\" style=\"vertical-align: -0.838ex; width:35.185ex; height:2.843ex;\"/></span>, then the <span class=\"mwe-math-element\"><span class=\"mwe-math-mathml-inline mwe-math-mathml-a11y\" style=\"display: none;\"><math alttext=\"{\\displaystyle (\\log x,y)}\" xmlns=\"http://www.w3.org/1998/Math/MathML\">\n<semantics>\n<mrow class=\"MJX-TeXAtom-ORD\">\n<mstyle displaystyle=\"true\" scriptlevel=\"0\">\n<mo stretchy=\"false\">(</mo>\n<mi>log</mi>\n<mo>⁡<!-- ⁡ --></mo>\n<mi>x</mi>\n<mo>,</mo>\n<mi>y</mi>\n<mo stretchy=\"false\">)</mo>\n</mstyle>\n</mrow>\n<annotation encoding=\"application/x-tex\">{\\displaystyle (\\log x,y)}</annotation>\n</semantics>\n</math></span><img alt=\"{\\displaystyle (\\log x,y)}\" aria-hidden=\"true\" class=\"mwe-math-fallback-image-inline mw-invert skin-invert\" src=\"https://wikimedia.org/api/rest_v1/media/math/render/svg/1dccdbdb2af7f930d3fff961d7f76540706bbaf8\" style=\"vertical-align: -0.838ex; width:8.687ex; height:2.843ex;\"/></span> plot is a straight line (before it hits the plateau at zero), which does not look like emergence.</li>\n<li>When <span class=\"mwe-math-element\"><span class=\"mwe-math-mathml-inline mwe-math-mathml-a11y\" style=\"display: none;\"><math alttext=\"{\\displaystyle y={\\text{average }}\\Pr({\\text{the most likely token is correct}})}\" xmlns=\"http://www.w3.org/1998/Math/MathML\">\n<semantics>\n<mrow class=\"MJX-TeXAtom-ORD\">\n<mstyle displaystyle=\"true\" scriptlevel=\"0\">\n<mi>y</mi>\n<mo>=</mo>\n<mrow class=\"MJX-TeXAtom-ORD\">\n<mtext>average </mtext>\n</mrow>\n<mo form=\"prefix\" movablelimits=\"true\">Pr</mo>\n<mo stretchy=\"false\">(</mo>\n<mrow class=\"MJX-TeXAtom-ORD\">\n<mtext>the most likely token is correct</mtext>\n</mrow>\n<mo stretchy=\"false\">)</mo>\n</mstyle>\n</mrow>\n<annotation encoding=\"application/x-tex\">{\\displaystyle y={\\text{average }}\\Pr({\\text{the most likely token is correct}})}</annotation>\n</semantics>\n</math></span><img alt=\"{\\displaystyle y={\\text{average }}\\Pr({\\text{the most likely token is correct}})}\" aria-hidden=\"true\" class=\"mwe-math-fallback-image-inline mw-invert skin-invert\" src=\"https://wikimedia.org/api/rest_v1/media/math/render/svg/6028c3484d3fbd36ffdc2cad41ff60ba9f8c1e7a\" style=\"vertical-align: -0.838ex; width:47.867ex; height:2.843ex;\"/></span>, then <span class=\"mwe-math-element\"><span class=\"mwe-math-mathml-inline mwe-math-mathml-a11y\" style=\"display: none;\"><math alttext=\"{\\displaystyle (\\log x,y)}\" xmlns=\"http://www.w3.org/1998/Math/MathML\">\n<semantics>\n<mrow class=\"MJX-TeXAtom-ORD\">\n<mstyle displaystyle=\"true\" scriptlevel=\"0\">\n<mo stretchy=\"false\">(</mo>\n<mi>log</mi>\n<mo>⁡<!-- ⁡ --></mo>\n<mi>x</mi>\n<mo>,</mo>\n<mi>y</mi>\n<mo stretchy=\"false\">)</mo>\n</mstyle>\n</mrow>\n<annotation encoding=\"application/x-tex\">{\\displaystyle (\\log x,y)}</annotation>\n</semantics>\n</math></span><img alt=\"{\\displaystyle (\\log x,y)}\" aria-hidden=\"true\" class=\"mwe-math-fallback-image-inline mw-invert skin-invert\" src=\"https://wikimedia.org/api/rest_v1/media/math/render/svg/1dccdbdb2af7f930d3fff961d7f76540706bbaf8\" style=\"vertical-align: -0.838ex; width:8.687ex; height:2.843ex;\"/></span> is a step-function, which looks like emergence.</li></ul></div>\n<div class=\"mw-heading mw-heading2\"><h2 id=\"Interpretation\">Interpretation</h2><span class=\"mw-editsection\"><span class=\"mw-editsection-bracket\">[</span><a href=\"/w/index.php?title=Large_language_model&amp;action=edit&amp;section=22\" title=\"Edit section: Interpretation\"><span>edit</span></a><span class=\"mw-editsection-bracket\">]</span></span></div>\n<p>Large language models by themselves are <a href=\"/wiki/Black_box\" title=\"Black box\">black boxes</a>, and it is not clear how they can perform linguistic tasks. There are several methods for understanding how LLM work.\n</p><p>Mechanistic interpretability aims to <a href=\"/wiki/Reverse_engineering\" title=\"Reverse engineering\">reverse-engineer</a> LLM by discovering symbolic algorithms that approximate the inference performed by LLM. One example is Othello-GPT, where a small Transformer is trained to predict legal <a href=\"/wiki/Reversi\" title=\"Reversi\">Othello</a> moves. It is found that there is a linear representation of Othello board, and modifying the representation changes the predicted legal Othello moves in the correct way.<sup class=\"reference\" id=\"cite_ref-IZSIr_104-0\"><a href=\"#cite_note-IZSIr-104\"><span class=\"cite-bracket\">[</span>104<span class=\"cite-bracket\">]</span></a></sup><sup class=\"reference\" id=\"cite_ref-RLik9_105-0\"><a href=\"#cite_note-RLik9-105\"><span class=\"cite-bracket\">[</span>105<span class=\"cite-bracket\">]</span></a></sup> In another example, a small Transformer is trained on <a href=\"/wiki/Karel_(programming_language)\" title=\"Karel (programming language)\">Karel programs</a>. Similar to the Othello-GPT example, there is a linear representation of Karel program semantics, and modifying the representation changes output in the correct way. The model also generates correct programs that are on average shorter than those in the training set.<sup class=\"reference\" id=\"cite_ref-Hln1l_106-0\"><a href=\"#cite_note-Hln1l-106\"><span class=\"cite-bracket\">[</span>106<span class=\"cite-bracket\">]</span></a></sup>\n</p><p>In another example, the authors trained small transformers on <a href=\"/wiki/Modular_arithmetic\" title=\"Modular arithmetic\">modular arithmetic addition</a>. The resulting models were reverse-engineered, and it turned out they used <a href=\"/wiki/Discrete_Fourier_transform\" title=\"Discrete Fourier transform\">discrete Fourier transform</a>.<sup class=\"reference\" id=\"cite_ref-oYGlo_107-0\"><a href=\"#cite_note-oYGlo-107\"><span class=\"cite-bracket\">[</span>107<span class=\"cite-bracket\">]</span></a></sup>\n</p>\n<div class=\"mw-heading mw-heading3\"><h3 id=\"Understanding_and_intelligence\">Understanding and intelligence</h3><span class=\"mw-editsection\"><span class=\"mw-editsection-bracket\">[</span><a href=\"/w/index.php?title=Large_language_model&amp;action=edit&amp;section=23\" title=\"Edit section: Understanding and intelligence\"><span>edit</span></a><span class=\"mw-editsection-bracket\">]</span></span></div>\n<link href=\"mw-data:TemplateStyles:r1236090951\" rel=\"mw-deduplicated-inline-style\"/><div class=\"hatnote navigation-not-searchable\" role=\"note\">See also: <a href=\"/wiki/Philosophy_of_artificial_intelligence\" title=\"Philosophy of artificial intelligence\">Philosophy of artificial intelligence</a> and <a href=\"/wiki/Artificial_consciousness\" title=\"Artificial consciousness\">Artificial consciousness</a></div>\n<p>NLP researchers were evenly split when asked, in a 2022 survey, whether (untuned) LLMs \"could (ever) understand natural language in some nontrivial sense\".<sup class=\"reference\" id=\"cite_ref-debate_understanding_108-0\"><a href=\"#cite_note-debate_understanding-108\"><span class=\"cite-bracket\">[</span>108<span class=\"cite-bracket\">]</span></a></sup> Proponents of \"LLM understanding\" believe that some LLM abilities, such as mathematical reasoning, imply an ability to <a href=\"/wiki/Natural_language_understanding\" title=\"Natural language understanding\">\"understand\"</a> certain concepts. A Microsoft team argued in 2023 that GPT-4 \"can solve novel and difficult tasks that span mathematics, coding, vision, medicine, law, psychology and more\" and that GPT-4 \"could reasonably be viewed as an early (yet still incomplete) version of an <a href=\"/wiki/Artificial_general_intelligence\" title=\"Artificial general intelligence\">artificial general intelligence</a> system\": \"Can one reasonably say that a system that passes exams for software engineering candidates is not <i>really</i> intelligent?\"<sup class=\"reference\" id=\"cite_ref-O8Upd_109-0\"><a href=\"#cite_note-O8Upd-109\"><span class=\"cite-bracket\">[</span>109<span class=\"cite-bracket\">]</span></a></sup><sup class=\"reference\" id=\"cite_ref-microsoft_sparks_110-0\"><a href=\"#cite_note-microsoft_sparks-110\"><span class=\"cite-bracket\">[</span>110<span class=\"cite-bracket\">]</span></a></sup> <a href=\"/wiki/Ilya_Sutskever\" title=\"Ilya Sutskever\">Ilya Sutskever</a> argues that predicting the next word sometimes involves reasoning and deep insights, for example if the LLM has to predict the name of the criminal in an unknown detective novel after processing the entire story leading up to the revelation.<sup class=\"reference\" id=\"cite_ref-111\"><a href=\"#cite_note-111\"><span class=\"cite-bracket\">[</span>111<span class=\"cite-bracket\">]</span></a></sup> Some researchers characterize LLMs as \"alien intelligence\".<sup class=\"reference\" id=\"cite_ref-rEEmH_112-0\"><a href=\"#cite_note-rEEmH-112\"><span class=\"cite-bracket\">[</span>112<span class=\"cite-bracket\">]</span></a></sup><sup class=\"reference\" id=\"cite_ref-new_yorker_kind_of_mind_113-0\"><a href=\"#cite_note-new_yorker_kind_of_mind-113\"><span class=\"cite-bracket\">[</span>113<span class=\"cite-bracket\">]</span></a></sup> For example, Conjecture CEO <a href=\"/wiki/Connor_Leahy\" title=\"Connor Leahy\">Connor Leahy</a> considers untuned LLMs to be like inscrutable alien \"<a href=\"/wiki/Shoggoth\" title=\"Shoggoth\">Shoggoths</a>\", and believes that RLHF tuning creates a \"smiling facade\" obscuring the inner workings of the LLM: \"If you don't push it too far, the smiley face stays on. But then you give it [an unexpected] prompt, and suddenly you see this massive underbelly of insanity, of weird thought processes and clearly non-human understanding.\"<sup class=\"reference\" id=\"cite_ref-rAFIZ_114-0\"><a href=\"#cite_note-rAFIZ-114\"><span class=\"cite-bracket\">[</span>114<span class=\"cite-bracket\">]</span></a></sup><sup class=\"reference\" id=\"cite_ref-4luKE_115-0\"><a href=\"#cite_note-4luKE-115\"><span class=\"cite-bracket\">[</span>115<span class=\"cite-bracket\">]</span></a></sup>\n</p><p>In contrast, some proponents of the \"LLMs lack understanding\" school believe that existing LLMs are \"simply remixing and recombining existing writing\",<sup class=\"reference\" id=\"cite_ref-new_yorker_kind_of_mind_113-1\"><a href=\"#cite_note-new_yorker_kind_of_mind-113\"><span class=\"cite-bracket\">[</span>113<span class=\"cite-bracket\">]</span></a></sup> a phenomenon known as <a href=\"/wiki/Stochastic_parrot\" title=\"Stochastic parrot\">stochastic parrot</a>, or they point to the deficits existing LLMs continue to have in prediction skills, reasoning skills, agency, and explainability.<sup class=\"reference\" id=\"cite_ref-debate_understanding_108-1\"><a href=\"#cite_note-debate_understanding-108\"><span class=\"cite-bracket\">[</span>108<span class=\"cite-bracket\">]</span></a></sup> For example, GPT-4 has natural deficits in planning and in real-time learning.<sup class=\"reference\" id=\"cite_ref-microsoft_sparks_110-1\"><a href=\"#cite_note-microsoft_sparks-110\"><span class=\"cite-bracket\">[</span>110<span class=\"cite-bracket\">]</span></a></sup> Generative LLMs have been observed to confidently assert claims of fact which do not seem to be <a href=\"/wiki/Justification_(epistemology)\" title=\"Justification (epistemology)\">justified</a> by their <a class=\"mw-redirect\" href=\"/wiki/Training_data\" title=\"Training data\">training data</a>, a phenomenon which has been termed \"<a href=\"/wiki/Hallucination_(artificial_intelligence)\" title=\"Hallucination (artificial intelligence)\">hallucination</a>\".<sup class=\"reference\" id=\"cite_ref-hallucination-survey_116-0\"><a href=\"#cite_note-hallucination-survey-116\"><span class=\"cite-bracket\">[</span>116<span class=\"cite-bracket\">]</span></a></sup> Specifically, hallucinations in the context of LLMs correspond to the generation of text or responses that seem syntactically sound, fluent, and natural but are factually incorrect, nonsensical, or unfaithful to the provided source input.<sup class=\"reference\" id=\"cite_ref-117\"><a href=\"#cite_note-117\"><span class=\"cite-bracket\">[</span>117<span class=\"cite-bracket\">]</span></a></sup> Neuroscientist <a class=\"mw-redirect\" href=\"/wiki/Terrence_Sejnowski\" title=\"Terrence Sejnowski\">Terrence Sejnowski</a> has argued that \"The diverging opinions of experts on the intelligence of LLMs suggests that our old ideas based on natural intelligence are inadequate\".<sup class=\"reference\" id=\"cite_ref-debate_understanding_108-2\"><a href=\"#cite_note-debate_understanding-108\"><span class=\"cite-bracket\">[</span>108<span class=\"cite-bracket\">]</span></a></sup>\n</p><p>The matter of LLM's exhibiting intelligence or understanding has two main aspects – the first is how to model thought and language in a computer system, and the second is how to enable the computer system to generate human like language.<sup class=\"reference\" id=\"cite_ref-debate_understanding_108-3\"><a href=\"#cite_note-debate_understanding-108\"><span class=\"cite-bracket\">[</span>108<span class=\"cite-bracket\">]</span></a></sup> These aspects of language as a model of <a href=\"/wiki/Cognition\" title=\"Cognition\">cognition</a> have been developed in the field of <a href=\"/wiki/Cognitive_linguistics\" title=\"Cognitive linguistics\">cognitive linguistics</a>. American linguist <a href=\"/wiki/George_Lakoff\" title=\"George Lakoff\">George Lakoff</a> presented Neural Theory of Language (NTL)<sup class=\"reference\" id=\"cite_ref-118\"><a href=\"#cite_note-118\"><span class=\"cite-bracket\">[</span>118<span class=\"cite-bracket\">]</span></a></sup> as a <a href=\"/wiki/Cognitive_linguistics#Computational_approaches\" title=\"Cognitive linguistics\">computational basis</a> for using language as a model of learning tasks and understanding. <a class=\"external text\" href=\"https://www.icsi.berkeley.edu/icsi/projects/ai/ntl\" rel=\"nofollow\">The NTL Model</a> outlines how specific neural structures of the human brain shape the nature of thought and language and in turn what are the computational properties of such neural systems that can be applied to model thought and language in a computer system. After a framework for modeling language in a computer systems was established, the focus shifted to establishing frameworks for computer systems to generate language with acceptable grammar. In his 2014 book titled <i><a href=\"/wiki/The_Language_Myth\" title=\"The Language Myth\">The Language Myth: Why Language Is Not An Instinct</a></i>, British cognitive linguist and digital communication technologist <a href=\"/wiki/Vyvyan_Evans\" title=\"Vyvyan Evans\">Vyvyan Evans</a> mapped out the role of <a href=\"/wiki/Probabilistic_context-free_grammar\" title=\"Probabilistic context-free grammar\">probabilistic context-free grammar</a> (PCFG) in enabling <a href=\"/wiki/Natural_language_processing#Cognition\" title=\"Natural language processing\">NLP to model cognitive patterns</a> and generate human like language.<sup class=\"reference\" id=\"cite_ref-119\"><a href=\"#cite_note-119\"><span class=\"cite-bracket\">[</span>119<span class=\"cite-bracket\">]</span></a></sup><sup class=\"reference\" id=\"cite_ref-120\"><a href=\"#cite_note-120\"><span class=\"cite-bracket\">[</span>120<span class=\"cite-bracket\">]</span></a></sup>\n</p>\n<div class=\"mw-heading mw-heading2\"><h2 id=\"Evaluation\">Evaluation</h2><span class=\"mw-editsection\"><span class=\"mw-editsection-bracket\">[</span><a href=\"/w/index.php?title=Large_language_model&amp;action=edit&amp;section=24\" title=\"Edit section: Evaluation\"><span>edit</span></a><span class=\"mw-editsection-bracket\">]</span></span></div>\n<div class=\"mw-heading mw-heading3\"><h3 id=\"Perplexity\">Perplexity</h3><span class=\"mw-editsection\"><span class=\"mw-editsection-bracket\">[</span><a href=\"/w/index.php?title=Large_language_model&amp;action=edit&amp;section=25\" title=\"Edit section: Perplexity\"><span>edit</span></a><span class=\"mw-editsection-bracket\">]</span></span></div>\n<p>The canonical measure of the performance of an LLM is its <a href=\"/wiki/Perplexity\" title=\"Perplexity\">perplexity</a> on a given text corpus. Perplexity measures how well a model predicts the contents of a dataset; the higher the likelihood the model assigns to the dataset, the lower the perplexity. In mathematical terms, perplexity is the exponential of the average negative log likelihood per token.\n</p><p><span class=\"mwe-math-element\"><span class=\"mwe-math-mathml-display mwe-math-mathml-a11y\" style=\"display: none;\"><math alttext=\"{\\displaystyle \\log({\\text{Perplexity}})=-{\\frac {1}{N}}\\sum _{i=1}^{N}\\log(\\Pr({\\text{token}}_{i}\\mid {\\text{context for token}}_{i}))}\" display=\"block\" xmlns=\"http://www.w3.org/1998/Math/MathML\">\n<semantics>\n<mrow class=\"MJX-TeXAtom-ORD\">\n<mstyle displaystyle=\"true\" scriptlevel=\"0\">\n<mi>log</mi>\n<mo>⁡<!-- ⁡ --></mo>\n<mo stretchy=\"false\">(</mo>\n<mrow class=\"MJX-TeXAtom-ORD\">\n<mtext>Perplexity</mtext>\n</mrow>\n<mo stretchy=\"false\">)</mo>\n<mo>=</mo>\n<mo>−<!-- − --></mo>\n<mrow class=\"MJX-TeXAtom-ORD\">\n<mfrac>\n<mn>1</mn>\n<mi>N</mi>\n</mfrac>\n</mrow>\n<munderover>\n<mo>∑<!-- ∑ --></mo>\n<mrow class=\"MJX-TeXAtom-ORD\">\n<mi>i</mi>\n<mo>=</mo>\n<mn>1</mn>\n</mrow>\n<mrow class=\"MJX-TeXAtom-ORD\">\n<mi>N</mi>\n</mrow>\n</munderover>\n<mi>log</mi>\n<mo>⁡<!-- ⁡ --></mo>\n<mo stretchy=\"false\">(</mo>\n<mo form=\"prefix\" movablelimits=\"true\">Pr</mo>\n<mo stretchy=\"false\">(</mo>\n<msub>\n<mrow class=\"MJX-TeXAtom-ORD\">\n<mtext>token</mtext>\n</mrow>\n<mrow class=\"MJX-TeXAtom-ORD\">\n<mi>i</mi>\n</mrow>\n</msub>\n<mo>∣<!-- ∣ --></mo>\n<msub>\n<mrow class=\"MJX-TeXAtom-ORD\">\n<mtext>context for token</mtext>\n</mrow>\n<mrow class=\"MJX-TeXAtom-ORD\">\n<mi>i</mi>\n</mrow>\n</msub>\n<mo stretchy=\"false\">)</mo>\n<mo stretchy=\"false\">)</mo>\n</mstyle>\n</mrow>\n<annotation encoding=\"application/x-tex\">{\\displaystyle \\log({\\text{Perplexity}})=-{\\frac {1}{N}}\\sum _{i=1}^{N}\\log(\\Pr({\\text{token}}_{i}\\mid {\\text{context for token}}_{i}))}</annotation>\n</semantics>\n</math></span><img alt=\"{\\displaystyle \\log({\\text{Perplexity}})=-{\\frac {1}{N}}\\sum _{i=1}^{N}\\log(\\Pr({\\text{token}}_{i}\\mid {\\text{context for token}}_{i}))}\" aria-hidden=\"true\" class=\"mwe-math-fallback-image-display mw-invert skin-invert\" src=\"https://wikimedia.org/api/rest_v1/media/math/render/svg/556393708767666076b9723412bc8519284449a5\" style=\"vertical-align: -3.005ex; width:62.586ex; height:7.343ex;\"/></span>\n</p><p>Here, <span class=\"mwe-math-element\"><span class=\"mwe-math-mathml-inline mwe-math-mathml-a11y\" style=\"display: none;\"><math alttext=\"{\\displaystyle N}\" xmlns=\"http://www.w3.org/1998/Math/MathML\">\n<semantics>\n<mrow class=\"MJX-TeXAtom-ORD\">\n<mstyle displaystyle=\"true\" scriptlevel=\"0\">\n<mi>N</mi>\n</mstyle>\n</mrow>\n<annotation encoding=\"application/x-tex\">{\\displaystyle N}</annotation>\n</semantics>\n</math></span><img alt=\"{\\displaystyle N}\" aria-hidden=\"true\" class=\"mwe-math-fallback-image-inline mw-invert skin-invert\" src=\"https://wikimedia.org/api/rest_v1/media/math/render/svg/f5e3890c981ae85503089652feb48b191b57aae3\" style=\"vertical-align: -0.338ex; width:2.064ex; height:2.176ex;\"/></span> is the number of tokens in the text corpus, and \"context for token <span class=\"mwe-math-element\"><span class=\"mwe-math-mathml-inline mwe-math-mathml-a11y\" style=\"display: none;\"><math alttext=\"{\\displaystyle i}\" xmlns=\"http://www.w3.org/1998/Math/MathML\">\n<semantics>\n<mrow class=\"MJX-TeXAtom-ORD\">\n<mstyle displaystyle=\"true\" scriptlevel=\"0\">\n<mi>i</mi>\n</mstyle>\n</mrow>\n<annotation encoding=\"application/x-tex\">{\\displaystyle i}</annotation>\n</semantics>\n</math></span><img alt=\"{\\displaystyle i}\" aria-hidden=\"true\" class=\"mwe-math-fallback-image-inline mw-invert skin-invert\" src=\"https://wikimedia.org/api/rest_v1/media/math/render/svg/add78d8608ad86e54951b8c8bd6c8d8416533d20\" style=\"vertical-align: -0.338ex; width:0.802ex; height:2.176ex;\"/></span>\" depends on the specific type of LLM. If the LLM is autoregressive, then \"context for token <span class=\"mwe-math-element\"><span class=\"mwe-math-mathml-inline mwe-math-mathml-a11y\" style=\"display: none;\"><math alttext=\"{\\displaystyle i}\" xmlns=\"http://www.w3.org/1998/Math/MathML\">\n<semantics>\n<mrow class=\"MJX-TeXAtom-ORD\">\n<mstyle displaystyle=\"true\" scriptlevel=\"0\">\n<mi>i</mi>\n</mstyle>\n</mrow>\n<annotation encoding=\"application/x-tex\">{\\displaystyle i}</annotation>\n</semantics>\n</math></span><img alt=\"{\\displaystyle i}\" aria-hidden=\"true\" class=\"mwe-math-fallback-image-inline mw-invert skin-invert\" src=\"https://wikimedia.org/api/rest_v1/media/math/render/svg/add78d8608ad86e54951b8c8bd6c8d8416533d20\" style=\"vertical-align: -0.338ex; width:0.802ex; height:2.176ex;\"/></span>\" is the segment of text appearing before token <span class=\"mwe-math-element\"><span class=\"mwe-math-mathml-inline mwe-math-mathml-a11y\" style=\"display: none;\"><math alttext=\"{\\displaystyle i}\" xmlns=\"http://www.w3.org/1998/Math/MathML\">\n<semantics>\n<mrow class=\"MJX-TeXAtom-ORD\">\n<mstyle displaystyle=\"true\" scriptlevel=\"0\">\n<mi>i</mi>\n</mstyle>\n</mrow>\n<annotation encoding=\"application/x-tex\">{\\displaystyle i}</annotation>\n</semantics>\n</math></span><img alt=\"{\\displaystyle i}\" aria-hidden=\"true\" class=\"mwe-math-fallback-image-inline mw-invert skin-invert\" src=\"https://wikimedia.org/api/rest_v1/media/math/render/svg/add78d8608ad86e54951b8c8bd6c8d8416533d20\" style=\"vertical-align: -0.338ex; width:0.802ex; height:2.176ex;\"/></span>. If the LLM is masked, then \"context for token <span class=\"mwe-math-element\"><span class=\"mwe-math-mathml-inline mwe-math-mathml-a11y\" style=\"display: none;\"><math alttext=\"{\\displaystyle i}\" xmlns=\"http://www.w3.org/1998/Math/MathML\">\n<semantics>\n<mrow class=\"MJX-TeXAtom-ORD\">\n<mstyle displaystyle=\"true\" scriptlevel=\"0\">\n<mi>i</mi>\n</mstyle>\n</mrow>\n<annotation encoding=\"application/x-tex\">{\\displaystyle i}</annotation>\n</semantics>\n</math></span><img alt=\"{\\displaystyle i}\" aria-hidden=\"true\" class=\"mwe-math-fallback-image-inline mw-invert skin-invert\" src=\"https://wikimedia.org/api/rest_v1/media/math/render/svg/add78d8608ad86e54951b8c8bd6c8d8416533d20\" style=\"vertical-align: -0.338ex; width:0.802ex; height:2.176ex;\"/></span>\" is the segment of text surrounding token <span class=\"mwe-math-element\"><span class=\"mwe-math-mathml-inline mwe-math-mathml-a11y\" style=\"display: none;\"><math alttext=\"{\\displaystyle i}\" xmlns=\"http://www.w3.org/1998/Math/MathML\">\n<semantics>\n<mrow class=\"MJX-TeXAtom-ORD\">\n<mstyle displaystyle=\"true\" scriptlevel=\"0\">\n<mi>i</mi>\n</mstyle>\n</mrow>\n<annotation encoding=\"application/x-tex\">{\\displaystyle i}</annotation>\n</semantics>\n</math></span><img alt=\"{\\displaystyle i}\" aria-hidden=\"true\" class=\"mwe-math-fallback-image-inline mw-invert skin-invert\" src=\"https://wikimedia.org/api/rest_v1/media/math/render/svg/add78d8608ad86e54951b8c8bd6c8d8416533d20\" style=\"vertical-align: -0.338ex; width:0.802ex; height:2.176ex;\"/></span>.\n</p><p>Because language models may <a class=\"mw-redirect\" href=\"/wiki/Overfit\" title=\"Overfit\">overfit</a> to training data, models are usually evaluated by their perplexity on a <a class=\"mw-redirect\" href=\"/wiki/Test_set\" title=\"Test set\">test set</a>.<sup class=\"reference\" id=\"cite_ref-jm_49-2\"><a href=\"#cite_note-jm-49\"><span class=\"cite-bracket\">[</span>49<span class=\"cite-bracket\">]</span></a></sup> This evaluation is potentially problematic for larger models which, as they are trained on increasingly large corpora of text, are increasingly likely to inadvertently include portions of any given test set.<sup class=\"reference\" id=\"cite_ref-few-shot-learners_2-1\"><a href=\"#cite_note-few-shot-learners-2\"><span class=\"cite-bracket\">[</span>2<span class=\"cite-bracket\">]</span></a></sup>\n</p>\n<div class=\"mw-heading mw-heading4\"><h4 id=\"BPW,_BPC,_and_BPT\"><span id=\"BPW.2C_BPC.2C_and_BPT\"></span>BPW, BPC, and BPT</h4><span class=\"mw-editsection\"><span class=\"mw-editsection-bracket\">[</span><a href=\"/w/index.php?title=Large_language_model&amp;action=edit&amp;section=26\" title=\"Edit section: BPW, BPC, and BPT\"><span>edit</span></a><span class=\"mw-editsection-bracket\">]</span></span></div>\n<p>In <a href=\"/wiki/Information_theory\" title=\"Information theory\">information theory</a>, the concept of <a href=\"/wiki/Entropy_(information_theory)\" title=\"Entropy (information theory)\">entropy</a> is intricately linked to perplexity, a relationship notably established by <a href=\"/wiki/Claude_Shannon\" title=\"Claude Shannon\">Claude Shannon</a>.<sup class=\"reference\" id=\"cite_ref-Huyen_121-0\"><a href=\"#cite_note-Huyen-121\"><span class=\"cite-bracket\">[</span>121<span class=\"cite-bracket\">]</span></a></sup> This relationship is mathematically expressed as <span class=\"mwe-math-element\"><span class=\"mwe-math-mathml-inline mwe-math-mathml-a11y\" style=\"display: none;\"><math alttext=\"{\\displaystyle {\\text{Entropy}}=\\log _{2}({\\text{Perplexity}})}\" xmlns=\"http://www.w3.org/1998/Math/MathML\">\n<semantics>\n<mrow class=\"MJX-TeXAtom-ORD\">\n<mstyle displaystyle=\"true\" scriptlevel=\"0\">\n<mrow class=\"MJX-TeXAtom-ORD\">\n<mtext>Entropy</mtext>\n</mrow>\n<mo>=</mo>\n<msub>\n<mi>log</mi>\n<mrow class=\"MJX-TeXAtom-ORD\">\n<mn>2</mn>\n</mrow>\n</msub>\n<mo>⁡<!-- ⁡ --></mo>\n<mo stretchy=\"false\">(</mo>\n<mrow class=\"MJX-TeXAtom-ORD\">\n<mtext>Perplexity</mtext>\n</mrow>\n<mo stretchy=\"false\">)</mo>\n</mstyle>\n</mrow>\n<annotation encoding=\"application/x-tex\">{\\displaystyle {\\text{Entropy}}=\\log _{2}({\\text{Perplexity}})}</annotation>\n</semantics>\n</math></span><img alt=\"{\\displaystyle {\\text{Entropy}}=\\log _{2}({\\text{Perplexity}})}\" aria-hidden=\"true\" class=\"mwe-math-fallback-image-inline mw-invert skin-invert\" src=\"https://wikimedia.org/api/rest_v1/media/math/render/svg/462f40a6811ee57670d1735c452d04be85a82c57\" style=\"vertical-align: -0.838ex; width:27.813ex; height:2.843ex;\"/></span>.\n</p><p>Entropy, in this context, is commonly quantified in terms of bits per word (BPW) or bits per character (BPC), which hinges on whether the language model utilizes word-based or character-based tokenization.\n</p><p>Notably, in the case of larger language models that predominantly employ sub-word tokenization, bits per token (BPT) emerges as a seemingly more appropriate measure. However, due to the variance in tokenization methods across different Large Language Models (LLMs), BPT does not serve as a reliable metric for comparative analysis among diverse models. To convert BPT into BPW, one can multiply it by the average number of tokens per word.\n</p><p>In the evaluation and comparison of language models, <a href=\"/wiki/Cross-entropy\" title=\"Cross-entropy\">cross-entropy</a> is generally the preferred metric over entropy. The underlying principle is that a lower BPW is indicative of a model's enhanced capability for compression. This, in turn, reflects the model's proficiency in making accurate predictions.\n</p>\n<div class=\"mw-heading mw-heading3\"><h3 id=\"Task-specific_datasets_and_benchmarks\">Task-specific datasets and benchmarks</h3><span class=\"mw-editsection\"><span class=\"mw-editsection-bracket\">[</span><a href=\"/w/index.php?title=Large_language_model&amp;action=edit&amp;section=27\" title=\"Edit section: Task-specific datasets and benchmarks\"><span>edit</span></a><span class=\"mw-editsection-bracket\">]</span></span></div>\n<p>A large number of testing datasets and <a href=\"/wiki/Benchmark_(computing)\" title=\"Benchmark (computing)\">benchmarks</a> have also been developed to evaluate the capabilities of language models on more specific downstream tasks. Tests may be designed to evaluate a variety of capabilities, including general knowledge, <a href=\"/wiki/Commonsense_reasoning\" title=\"Commonsense reasoning\">commonsense reasoning</a>, and mathematical problem-solving.\n</p><p>One broad category of evaluation dataset is question answering datasets, consisting of pairs of questions and correct answers, for example, (\"Have the San Jose Sharks won the Stanley Cup?\", \"No\").<sup class=\"reference\" id=\"cite_ref-boolq_122-0\"><a href=\"#cite_note-boolq-122\"><span class=\"cite-bracket\">[</span>122<span class=\"cite-bracket\">]</span></a></sup> A question answering task is considered \"open book\" if the model's prompt includes text from which the expected answer can be derived (for example, the previous question could be adjoined with some text which includes the sentence \"The Sharks have advanced to the Stanley Cup finals once, losing to the Pittsburgh Penguins in 2016.\"<sup class=\"reference\" id=\"cite_ref-boolq_122-1\"><a href=\"#cite_note-boolq-122\"><span class=\"cite-bracket\">[</span>122<span class=\"cite-bracket\">]</span></a></sup>). Otherwise, the task is considered \"closed book\", and the model must draw on knowledge retained during training.<sup class=\"reference\" id=\"cite_ref-survey_123-0\"><a href=\"#cite_note-survey-123\"><span class=\"cite-bracket\">[</span>123<span class=\"cite-bracket\">]</span></a></sup> Some examples of commonly used question answering datasets include TruthfulQA, Web Questions, TriviaQA, and SQuAD.<sup class=\"reference\" id=\"cite_ref-survey_123-1\"><a href=\"#cite_note-survey-123\"><span class=\"cite-bracket\">[</span>123<span class=\"cite-bracket\">]</span></a></sup>\n</p><p>Evaluation datasets may also take the form of text completion, having the model select the most likely word or sentence to complete a prompt, for example: \"Alice was friends with Bob. Alice went to visit her friend, ____\".<sup class=\"reference\" id=\"cite_ref-few-shot-learners_2-2\"><a href=\"#cite_note-few-shot-learners-2\"><span class=\"cite-bracket\">[</span>2<span class=\"cite-bracket\">]</span></a></sup>\n</p><p>Some composite benchmarks have also been developed which combine a diversity of different evaluation datasets and tasks. Examples include GLUE, SuperGLUE, <a href=\"/wiki/MMLU\" title=\"MMLU\">MMLU</a>, BIG-bench, and HELM.<sup class=\"reference\" id=\"cite_ref-Huyen_121-1\"><a href=\"#cite_note-Huyen-121\"><span class=\"cite-bracket\">[</span>121<span class=\"cite-bracket\">]</span></a></sup><sup class=\"reference\" id=\"cite_ref-survey_123-2\"><a href=\"#cite_note-survey-123\"><span class=\"cite-bracket\">[</span>123<span class=\"cite-bracket\">]</span></a></sup> OpenAI has released tools for running composite benchmarks, but noted that the eval results are sensitive to the prompting method.<sup class=\"reference\" id=\"cite_ref-124\"><a href=\"#cite_note-124\"><span class=\"cite-bracket\">[</span>124<span class=\"cite-bracket\">]</span></a></sup><sup class=\"reference\" id=\"cite_ref-125\"><a href=\"#cite_note-125\"><span class=\"cite-bracket\">[</span>125<span class=\"cite-bracket\">]</span></a></sup> Some public datasets contain questions that are mislabeled, ambiguous, unanswerable, or otherwise of low-quality, which can be cleaned to give more reliable benchmark scores.<sup class=\"reference\" id=\"cite_ref-126\"><a href=\"#cite_note-126\"><span class=\"cite-bracket\">[</span>126<span class=\"cite-bracket\">]</span></a></sup>\n</p><p>It was previously standard to report results on a heldout portion of an evaluation dataset after doing supervised fine-tuning on the remainder. It is now more common to evaluate a pre-trained model directly through prompting techniques, though researchers vary in the details of how they formulate prompts for particular tasks, particularly with respect to how many examples of solved tasks are adjoined to the prompt (i.e. the value of <i>n</i> in <i>n</i>-shot prompting).\n</p>\n<div class=\"mw-heading mw-heading4\"><h4 id=\"Adversarially_constructed_evaluations\">Adversarially constructed evaluations</h4><span class=\"mw-editsection\"><span class=\"mw-editsection-bracket\">[</span><a href=\"/w/index.php?title=Large_language_model&amp;action=edit&amp;section=28\" title=\"Edit section: Adversarially constructed evaluations\"><span>edit</span></a><span class=\"mw-editsection-bracket\">]</span></span></div>\n<p>Because of the rapid pace of improvement of large language models, evaluation benchmarks have suffered from short lifespans, with state of the art models quickly \"saturating\" existing benchmarks, exceeding the performance of human annotators, leading to efforts to replace or augment the benchmark with more challenging tasks.<sup class=\"reference\" id=\"cite_ref-bigbench_127-0\"><a href=\"#cite_note-bigbench-127\"><span class=\"cite-bracket\">[</span>127<span class=\"cite-bracket\">]</span></a></sup> In addition, there are cases of \"shortcut learning\" wherein AIs sometimes \"cheat\" on multiple-choice tests by using statistical correlations in superficial test question wording in order to guess the correct responses, without necessarily understanding the actual question being asked.<sup class=\"reference\" id=\"cite_ref-debate_understanding_108-4\"><a href=\"#cite_note-debate_understanding-108\"><span class=\"cite-bracket\">[</span>108<span class=\"cite-bracket\">]</span></a></sup>\n</p><p>Some datasets have been constructed adversarially, focusing on particular problems on which extant language models seem to have unusually poor performance compared to humans. One example is the TruthfulQA dataset, a question answering dataset consisting of 817 questions which language models are susceptible to answering incorrectly by mimicking falsehoods to which they were repeatedly exposed during training. For example, an LLM may answer \"No\" to the question \"Can you teach an old dog new tricks?\" because of its exposure to the English idiom <i><a class=\"extiw\" href=\"https://en.wiktionary.org/wiki/you_can%27t_teach_an_old_dog_new_tricks\" title=\"wikt:you can't teach an old dog new tricks\">you can't teach an old dog new tricks</a></i>, even though this is not literally true.<sup class=\"reference\" id=\"cite_ref-truthfulqa_128-0\"><a href=\"#cite_note-truthfulqa-128\"><span class=\"cite-bracket\">[</span>128<span class=\"cite-bracket\">]</span></a></sup>\n</p><p>Another example of an adversarial evaluation dataset is Swag and its successor, HellaSwag, collections of problems in which one of multiple options must be selected to complete a text passage. The incorrect completions were generated by sampling from a language model and filtering with a set of classifiers. The resulting problems are trivial for humans but at the time the datasets were created state of the art language models had poor accuracy on them. For example:\n</p>\n<blockquote>\n<p>We see a fitness center sign. We then see a man talking to the camera and sitting and laying on a exercise ball. The man...\n<br/>a) demonstrates how to increase efficient exercise work by running up and down balls.\n<br/>b) moves all his arms and legs and builds up a lot of muscle.\n<br/>c) then plays the ball and we see a graphics and hedge trimming demonstration.\n<br/>d) performs sit ups while on the ball and talking.<sup class=\"reference\" id=\"cite_ref-hellaswag_129-0\"><a href=\"#cite_note-hellaswag-129\"><span class=\"cite-bracket\">[</span>129<span class=\"cite-bracket\">]</span></a></sup>\n</p>\n</blockquote>\n<p><a href=\"/wiki/BERT_(language_model)\" title=\"BERT (language model)\">BERT</a> selects b) as the most likely completion, though the correct answer is d).<sup class=\"reference\" id=\"cite_ref-hellaswag_129-1\"><a href=\"#cite_note-hellaswag-129\"><span class=\"cite-bracket\">[</span>129<span class=\"cite-bracket\">]</span></a></sup>\n</p>\n<div class=\"mw-heading mw-heading2\"><h2 id=\"Wider_impact\">Wider impact</h2><span class=\"mw-editsection\"><span class=\"mw-editsection-bracket\">[</span><a href=\"/w/index.php?title=Large_language_model&amp;action=edit&amp;section=29\" title=\"Edit section: Wider impact\"><span>edit</span></a><span class=\"mw-editsection-bracket\">]</span></span></div>\n<p>In 2023, <i><a href=\"/wiki/Nature_Biomedical_Engineering\" title=\"Nature Biomedical Engineering\">Nature Biomedical Engineering</a></i> wrote that \"it is no longer possible to accurately distinguish\" human-written text from text created by large language models, and that \"It is all but certain that general-purpose large language models will rapidly proliferate... It is a rather safe bet that they will change many industries over time.\"<sup class=\"reference\" id=\"cite_ref-ZDTUM_130-0\"><a href=\"#cite_note-ZDTUM-130\"><span class=\"cite-bracket\">[</span>130<span class=\"cite-bracket\">]</span></a></sup> <a href=\"/wiki/Goldman_Sachs\" title=\"Goldman Sachs\">Goldman Sachs</a> suggested in 2023 that generative language AI could increase global GDP by 7% in the next ten years, and could expose to automation 300 million jobs globally.<sup class=\"reference\" id=\"cite_ref-81w7x_131-0\"><a href=\"#cite_note-81w7x-131\"><span class=\"cite-bracket\">[</span>131<span class=\"cite-bracket\">]</span></a></sup><sup class=\"reference\" id=\"cite_ref-zIM6Y_132-0\"><a href=\"#cite_note-zIM6Y-132\"><span class=\"cite-bracket\">[</span>132<span class=\"cite-bracket\">]</span></a></sup>\n</p>\n<div class=\"mw-heading mw-heading3\"><h3 id=\"Memorization_and_copyright\">Memorization and copyright</h3><span class=\"mw-editsection\"><span class=\"mw-editsection-bracket\">[</span><a href=\"/w/index.php?title=Large_language_model&amp;action=edit&amp;section=30\" title=\"Edit section: Memorization and copyright\"><span>edit</span></a><span class=\"mw-editsection-bracket\">]</span></span></div>\n<link href=\"mw-data:TemplateStyles:r1236090951\" rel=\"mw-deduplicated-inline-style\"/><div class=\"hatnote navigation-not-searchable\" role=\"note\">Further information: <a href=\"/wiki/Artificial_intelligence_and_copyright\" title=\"Artificial intelligence and copyright\">Artificial intelligence and copyright</a></div>\n<p>Memorization is an emergent behavior in LLMs in which long strings of text are occasionally output verbatim from training data, contrary to typical behavior of traditional artificial neural nets. Evaluations of controlled LLM output measure the amount memorized from training data (focused on GPT-2-series models) as variously over 1% for exact duplicates<sup class=\"reference\" id=\"cite_ref-133\"><a href=\"#cite_note-133\"><span class=\"cite-bracket\">[</span>133<span class=\"cite-bracket\">]</span></a></sup> or up to about 7%.<sup class=\"reference\" id=\"cite_ref-134\"><a href=\"#cite_note-134\"><span class=\"cite-bracket\">[</span>134<span class=\"cite-bracket\">]</span></a></sup>\n</p>\n<div class=\"mw-heading mw-heading3\"><h3 id=\"Security\">Security</h3><span class=\"mw-editsection\"><span class=\"mw-editsection-bracket\">[</span><a href=\"/w/index.php?title=Large_language_model&amp;action=edit&amp;section=31\" title=\"Edit section: Security\"><span>edit</span></a><span class=\"mw-editsection-bracket\">]</span></span></div>\n<p>Some commenters expressed concern over accidental or deliberate creation of misinformation, or other forms of misuse.<sup class=\"reference\" id=\"cite_ref-nD6kH_135-0\"><a href=\"#cite_note-nD6kH-135\"><span class=\"cite-bracket\">[</span>135<span class=\"cite-bracket\">]</span></a></sup> For example, the availability of large language models could reduce the skill-level required to commit bioterrorism; biosecurity researcher Kevin Esvelt has suggested that LLM creators should exclude from their training data papers on creating or enhancing pathogens.<sup class=\"reference\" id=\"cite_ref-PKiPY_136-0\"><a href=\"#cite_note-PKiPY-136\"><span class=\"cite-bracket\">[</span>136<span class=\"cite-bracket\">]</span></a></sup>\n</p><p>A study by researchers at Google and several universities, including <a href=\"/wiki/Cornell_University\" title=\"Cornell University\">Cornell University</a> and <a href=\"/wiki/University_of_California,_Berkeley\" title=\"University of California, Berkeley\">University of California, Berkeley</a>, showed that there are potential security risks in language models such as <a href=\"/wiki/ChatGPT\" title=\"ChatGPT\">ChatGPT</a>. In their study, they examined and confirmed the possibility that questioners could get, from ChatGPT, the training data that the AI model used. For example, when asking ChatGPT 3.5 turbo to repeat the word \"poem\" forever, the AI model will say \"poem\" hundreds of times and then diverge, deviating from the standard dialogue style and spitting out nonsense phrases, thus spitting out the training data as it is. The researchers have seen more than 10,000 examples of the AI model exposing their training data in a similar method. The researchers said that it was hard to tell if the AI model was actually safe or not.<sup class=\"reference\" id=\"cite_ref-137\"><a href=\"#cite_note-137\"><span class=\"cite-bracket\">[</span>137<span class=\"cite-bracket\">]</span></a></sup>\n</p><p>The potential presence of \"sleeper agents\" within LLM models is another emerging security concern. These are hidden functionalities built into the model that remain dormant until triggered by a specific event or condition. Upon activation, the LLM deviates from its expected behavior to make insecure actions.<sup class=\"reference\" id=\"cite_ref-138\"><a href=\"#cite_note-138\"><span class=\"cite-bracket\">[</span>138<span class=\"cite-bracket\">]</span></a></sup>\n</p><p>LLM applications accessible to the public, like ChatGPT or Claude, typically incorporate safety measures designed to filter out harmful content. However, implementing these controls effectively has proven challenging. For instance, a 2023 study<sup class=\"reference\" id=\"cite_ref-139\"><a href=\"#cite_note-139\"><span class=\"cite-bracket\">[</span>139<span class=\"cite-bracket\">]</span></a></sup> proposed a method for circumventing LLM safety systems. Similarly, <a href=\"/wiki/Yongge_Wang\" title=\"Yongge Wang\">Yongge Wang</a><sup class=\"reference\" id=\"cite_ref-140\"><a href=\"#cite_note-140\"><span class=\"cite-bracket\">[</span>140<span class=\"cite-bracket\">]</span></a></sup> illustrated in 2024 how a potential criminal could potentially bypass ChatGPT 4o's safety controls to obtain information on establishing a drug trafficking operation.\n</p>\n<div class=\"mw-heading mw-heading3\"><h3 id=\"Algorithmic_bias\">Algorithmic bias</h3><span class=\"mw-editsection\"><span class=\"mw-editsection-bracket\">[</span><a href=\"/w/index.php?title=Large_language_model&amp;action=edit&amp;section=32\" title=\"Edit section: Algorithmic bias\"><span>edit</span></a><span class=\"mw-editsection-bracket\">]</span></span></div>\n<link href=\"mw-data:TemplateStyles:r1236090951\" rel=\"mw-deduplicated-inline-style\"/><div class=\"hatnote navigation-not-searchable\" role=\"note\">Main article: <a href=\"/wiki/Algorithmic_bias\" title=\"Algorithmic bias\">Algorithmic bias</a></div>\n<p>While LLMs have shown remarkable capabilities in generating human-like text, they are susceptible to inheriting and amplifying biases present in their training data. This can manifest in skewed representations or unfair treatment of different demographics, such as those based on race, gender, language, and cultural groups.<sup class=\"reference\" id=\"cite_ref-:8_141-0\"><a href=\"#cite_note-:8-141\"><span class=\"cite-bracket\">[</span>141<span class=\"cite-bracket\">]</span></a></sup> Since English data is overrepresented in current large language models' training data, it may also downplay non-English views.<sup class=\"reference\" id=\"cite_ref-:1_142-0\"><a href=\"#cite_note-:1-142\"><span class=\"cite-bracket\">[</span>142<span class=\"cite-bracket\">]</span></a></sup>\n</p>\n<div class=\"mw-heading mw-heading4\"><h4 id=\"Stereotyping\">Stereotyping</h4><span class=\"mw-editsection\"><span class=\"mw-editsection-bracket\">[</span><a href=\"/w/index.php?title=Large_language_model&amp;action=edit&amp;section=33\" title=\"Edit section: Stereotyping\"><span>edit</span></a><span class=\"mw-editsection-bracket\">]</span></span></div>\n<p>AI models can reinforce a wide range of stereotypes, including those based on gender, ethnicity, age, nationality, religion, or occupation. This can lead to outputs that unfairly generalize or caricature groups of people, sometimes in harmful or derogatory ways.<sup class=\"reference\" id=\"cite_ref-143\"><a href=\"#cite_note-143\"><span class=\"cite-bracket\">[</span>143<span class=\"cite-bracket\">]</span></a></sup>\n</p><p>Notably, gender bias refers to the tendency of these models to produce outputs that are unfairly prejudiced towards one gender over another. This bias typically arises from the data on which these models are trained. Large language models often assign roles and characteristics based on traditional gender norms.<sup class=\"reference\" id=\"cite_ref-:8_141-1\"><a href=\"#cite_note-:8-141\"><span class=\"cite-bracket\">[</span>141<span class=\"cite-bracket\">]</span></a></sup> For example, it might associate nurses or secretaries predominantly with women and engineers or CEOs with men.<sup class=\"reference\" id=\"cite_ref-144\"><a href=\"#cite_note-144\"><span class=\"cite-bracket\">[</span>144<span class=\"cite-bracket\">]</span></a></sup>\n</p>\n<div class=\"mw-heading mw-heading4\"><h4 id=\"Political_bias\">Political bias</h4><span class=\"mw-editsection\"><span class=\"mw-editsection-bracket\">[</span><a href=\"/w/index.php?title=Large_language_model&amp;action=edit&amp;section=34\" title=\"Edit section: Political bias\"><span>edit</span></a><span class=\"mw-editsection-bracket\">]</span></span></div>\n<p>Political bias refers to the tendency of algorithms to systematically favor certain political viewpoints, ideologies, or outcomes over others. Language models may also exhibit political biases. Since the training data includes a wide range of political opinions and coverage, the models might generate responses that lean towards particular political ideologies or viewpoints, depending on the prevalence of those views in the data.<sup class=\"reference\" id=\"cite_ref-145\"><a href=\"#cite_note-145\"><span class=\"cite-bracket\">[</span>145<span class=\"cite-bracket\">]</span></a></sup>\n</p>\n<div class=\"mw-heading mw-heading2\"><h2 id=\"List_of_large_language_models\">List of large language models</h2><span class=\"mw-editsection\"><span class=\"mw-editsection-bracket\">[</span><a href=\"/w/index.php?title=Large_language_model&amp;action=edit&amp;section=35\" title=\"Edit section: List of large language models\"><span>edit</span></a><span class=\"mw-editsection-bracket\">]</span></span></div>\n<link href=\"mw-data:TemplateStyles:r1236090951\" rel=\"mw-deduplicated-inline-style\"/><div class=\"hatnote navigation-not-searchable\" role=\"note\">See also: <a href=\"/wiki/List_of_chatbots\" title=\"List of chatbots\">List of chatbots</a></div>\n<p>For the training cost column, 1 petaFLOP-day = 1 petaFLOP/sec × 1 day = 8.64E19 FLOP. Also, only the largest model's cost is written.\n</p>\n<table class=\"wikitable sortable\">\n<tbody><tr>\n<th>Name</th>\n<th>Release date<sup class=\"reference\" id=\"cite_ref-146\"><a href=\"#cite_note-146\"><span class=\"cite-bracket\">[</span>a<span class=\"cite-bracket\">]</span></a></sup></th>\n<th>Developer</th>\n<th>Number of parameters (billion) <sup class=\"reference\" id=\"cite_ref-147\"><a href=\"#cite_note-147\"><span class=\"cite-bracket\">[</span>b<span class=\"cite-bracket\">]</span></a></sup></th>\n<th>Corpus size\n</th>\n<th>Training cost (petaFLOP-day)</th>\n<th>License<sup class=\"reference\" id=\"cite_ref-148\"><a href=\"#cite_note-148\"><span class=\"cite-bracket\">[</span>c<span class=\"cite-bracket\">]</span></a></sup></th>\n<th>Notes\n</th></tr>\n<tr>\n<td><a href=\"/wiki/GPT-1\" title=\"GPT-1\">GPT-1</a></td>\n<td><span data-sort-value=\"000000002018-06-01-0000\" style=\"white-space:nowrap\">June 2018</span></td>\n<td><a href=\"/wiki/OpenAI\" title=\"OpenAI\">OpenAI</a></td>\n<td><span data-sort-value=\"117000000 !\">0.117</span></td>\n<td>\n</td>\n<td>1<sup class=\"reference\" id=\"cite_ref-oai-unsup_149-0\"><a href=\"#cite_note-oai-unsup-149\"><span class=\"cite-bracket\">[</span>146<span class=\"cite-bracket\">]</span></a></sup></td>\n<td class=\"table-yes\" style=\"background:#9EFF9E;color:black;vertical-align:middle;text-align:center;\">MIT<sup class=\"reference\" id=\"cite_ref-gpt1_150-0\"><a href=\"#cite_note-gpt1-150\"><span class=\"cite-bracket\">[</span>147<span class=\"cite-bracket\">]</span></a></sup>\n</td>\n<td>First GPT model, decoder-only transformer. Trained for 30 days on 8 P600 <a href=\"/wiki/Graphics_processing_unit\" title=\"Graphics processing unit\">GPUs</a>.\n</td></tr>\n<tr>\n<td><a href=\"/wiki/BERT_(language_model)\" title=\"BERT (language model)\">BERT</a></td>\n<td><span data-sort-value=\"000000002018-10-01-0000\" style=\"white-space:nowrap\">October 2018</span></td>\n<td><a href=\"/wiki/Google\" title=\"Google\">Google</a></td>\n<td><span data-sort-value=\"340000000 !\">0.340</span><sup class=\"reference\" id=\"cite_ref-bert-paper_151-0\"><a href=\"#cite_note-bert-paper-151\"><span class=\"cite-bracket\">[</span>148<span class=\"cite-bracket\">]</span></a></sup></td>\n<td><span data-sort-value=\"3300000000 !\">3.3 billion</span> words<sup class=\"reference\" id=\"cite_ref-bert-paper_151-1\"><a href=\"#cite_note-bert-paper-151\"><span class=\"cite-bracket\">[</span>148<span class=\"cite-bracket\">]</span></a></sup>\n</td>\n<td><span data-sort-value=\"9 !\">9</span><sup class=\"reference\" id=\"cite_ref-bHZJ2_152-0\"><a href=\"#cite_note-bHZJ2-152\"><span class=\"cite-bracket\">[</span>149<span class=\"cite-bracket\">]</span></a></sup></td>\n<td class=\"table-yes\" style=\"background:#9EFF9E;color:black;vertical-align:middle;text-align:center;\">Apache 2.0<sup class=\"reference\" id=\"cite_ref-bert-web_153-0\"><a href=\"#cite_note-bert-web-153\"><span class=\"cite-bracket\">[</span>150<span class=\"cite-bracket\">]</span></a></sup>\n</td>\n<td>An early and influential language model.<sup class=\"reference\" id=\"cite_ref-Manning-2022_4-1\"><a href=\"#cite_note-Manning-2022-4\"><span class=\"cite-bracket\">[</span>4<span class=\"cite-bracket\">]</span></a></sup> <a href=\"/wiki/Transformer_(deep_learning_architecture)#encoder-only\" title=\"Transformer (deep learning architecture)\">Encoder-only</a> and thus not built to be prompted or generative.<sup class=\"reference\" id=\"cite_ref-Ir545_154-0\"><a href=\"#cite_note-Ir545-154\"><span class=\"cite-bracket\">[</span>151<span class=\"cite-bracket\">]</span></a></sup> Training took 4 days on 64 TPUv2 chips.<sup class=\"reference\" id=\"cite_ref-:02_155-0\"><a href=\"#cite_note-:02-155\"><span class=\"cite-bracket\">[</span>152<span class=\"cite-bracket\">]</span></a></sup>\n</td></tr>\n<tr>\n<td><a href=\"/wiki/T5_(language_model)\" title=\"T5 (language model)\">T5</a>\n</td>\n<td><span data-sort-value=\"000000002019-10-01-0000\" style=\"white-space:nowrap\">October 2019</span>\n</td>\n<td>Google\n</td>\n<td>11<sup class=\"reference\" id=\"cite_ref-:6_156-0\"><a href=\"#cite_note-:6-156\"><span class=\"cite-bracket\">[</span>153<span class=\"cite-bracket\">]</span></a></sup>\n</td>\n<td>34 billion tokens<sup class=\"reference\" id=\"cite_ref-:6_156-1\"><a href=\"#cite_note-:6-156\"><span class=\"cite-bracket\">[</span>153<span class=\"cite-bracket\">]</span></a></sup>\n</td>\n<td>\n</td>\n<td class=\"table-yes\" style=\"background:#9EFF9E;color:black;vertical-align:middle;text-align:center;\">Apache 2.0<sup class=\"reference\" id=\"cite_ref-157\"><a href=\"#cite_note-157\"><span class=\"cite-bracket\">[</span>154<span class=\"cite-bracket\">]</span></a></sup>\n</td>\n<td>Base model for many Google projects, such as Imagen.<sup class=\"reference\" id=\"cite_ref-158\"><a href=\"#cite_note-158\"><span class=\"cite-bracket\">[</span>155<span class=\"cite-bracket\">]</span></a></sup>\n</td></tr>\n<tr>\n<td><a href=\"/wiki/XLNet\" title=\"XLNet\">XLNet</a></td>\n<td><span data-sort-value=\"000000002019-06-01-0000\" style=\"white-space:nowrap\">June 2019</span></td>\n<td><a href=\"/wiki/Google\" title=\"Google\">Google</a></td>\n<td><span data-sort-value=\"340000000 !\">0.340</span><sup class=\"reference\" id=\"cite_ref-159\"><a href=\"#cite_note-159\"><span class=\"cite-bracket\">[</span>156<span class=\"cite-bracket\">]</span></a></sup></td>\n<td><span data-sort-value=\"3300000000 !\">33</span> billion words\n</td>\n<td>330</td>\n<td class=\"table-yes\" style=\"background:#9EFF9E;color:black;vertical-align:middle;text-align:center;\">Apache 2.0<sup class=\"reference\" id=\"cite_ref-xlnet_160-0\"><a href=\"#cite_note-xlnet-160\"><span class=\"cite-bracket\">[</span>157<span class=\"cite-bracket\">]</span></a></sup>\n</td>\n<td>An alternative to BERT; designed as encoder-only. Trained on 512 TPU v3 chips for 5.5 days.<sup class=\"reference\" id=\"cite_ref-LX3rI_161-0\"><a href=\"#cite_note-LX3rI-161\"><span class=\"cite-bracket\">[</span>158<span class=\"cite-bracket\">]</span></a></sup>\n</td></tr>\n<tr>\n<td><a href=\"/wiki/GPT-2\" title=\"GPT-2\">GPT-2</a></td>\n<td><span data-sort-value=\"000000002019-02-01-0000\" style=\"white-space:nowrap\">February 2019</span></td>\n<td><a href=\"/wiki/OpenAI\" title=\"OpenAI\">OpenAI</a></td>\n<td><span data-sort-value=\"1500000000 !\">1.5</span><sup class=\"reference\" id=\"cite_ref-15Brelease_162-0\"><a href=\"#cite_note-15Brelease-162\"><span class=\"cite-bracket\">[</span>159<span class=\"cite-bracket\">]</span></a></sup></td>\n<td>40GB<sup class=\"reference\" id=\"cite_ref-5T8u5_163-0\"><a href=\"#cite_note-5T8u5-163\"><span class=\"cite-bracket\">[</span>160<span class=\"cite-bracket\">]</span></a></sup> (~<span data-sort-value=\"10000000000 !\">10 billion</span> tokens)<sup class=\"reference\" id=\"cite_ref-LambdaLabs_164-0\"><a href=\"#cite_note-LambdaLabs-164\"><span class=\"cite-bracket\">[</span>161<span class=\"cite-bracket\">]</span></a></sup>\n</td>\n<td>28<sup class=\"reference\" id=\"cite_ref-:10_165-0\"><a href=\"#cite_note-:10-165\"><span class=\"cite-bracket\">[</span>162<span class=\"cite-bracket\">]</span></a></sup></td>\n<td class=\"table-yes\" style=\"background:#9EFF9E;color:black;vertical-align:middle;text-align:center;\">MIT<sup class=\"reference\" id=\"cite_ref-Sudbe_166-0\"><a href=\"#cite_note-Sudbe-166\"><span class=\"cite-bracket\">[</span>163<span class=\"cite-bracket\">]</span></a></sup>\n</td>\n<td>Trained on 32 TPUv3 chips for 1 week.<sup class=\"reference\" id=\"cite_ref-:10_165-1\"><a href=\"#cite_note-:10-165\"><span class=\"cite-bracket\">[</span>162<span class=\"cite-bracket\">]</span></a></sup>\n</td></tr>\n<tr>\n<td><a href=\"/wiki/GPT-3\" title=\"GPT-3\">GPT-3</a></td>\n<td><span data-sort-value=\"000000002020-05-01-0000\" style=\"white-space:nowrap\">May 2020</span></td>\n<td>OpenAI</td>\n<td><span data-sort-value=\"175000000000 !\">175</span><sup class=\"reference\" id=\"cite_ref-Wiggers_53-1\"><a href=\"#cite_note-Wiggers-53\"><span class=\"cite-bracket\">[</span>53<span class=\"cite-bracket\">]</span></a></sup></td>\n<td><span data-sort-value=\"300000000000 !\">300 billion</span> tokens<sup class=\"reference\" id=\"cite_ref-LambdaLabs_164-1\"><a href=\"#cite_note-LambdaLabs-164\"><span class=\"cite-bracket\">[</span>161<span class=\"cite-bracket\">]</span></a></sup>\n</td>\n<td>3640<sup class=\"reference\" id=\"cite_ref-:2_167-0\"><a href=\"#cite_note-:2-167\"><span class=\"cite-bracket\">[</span>164<span class=\"cite-bracket\">]</span></a></sup></td>\n<td class=\"table-no\" style=\"background:#FFC7C7;color:black;vertical-align:middle;text-align:center;\">proprietary\n</td>\n<td>A fine-tuned variant of GPT-3, termed GPT-3.5, was made available to the public through a web interface called <a href=\"/wiki/ChatGPT\" title=\"ChatGPT\">ChatGPT</a> in 2022.<sup class=\"reference\" id=\"cite_ref-chatgpt-blog_168-0\"><a href=\"#cite_note-chatgpt-blog-168\"><span class=\"cite-bracket\">[</span>165<span class=\"cite-bracket\">]</span></a></sup>\n</td></tr>\n<tr>\n<td>GPT-Neo</td>\n<td><span data-sort-value=\"000000002021-03-01-0000\" style=\"white-space:nowrap\">March 2021</span></td>\n<td><a href=\"/wiki/EleutherAI\" title=\"EleutherAI\">EleutherAI</a></td>\n<td><span data-sort-value=\"2700000000 !\">2.7</span><sup class=\"reference\" id=\"cite_ref-gpt-neo_169-0\"><a href=\"#cite_note-gpt-neo-169\"><span class=\"cite-bracket\">[</span>166<span class=\"cite-bracket\">]</span></a></sup></td>\n<td>825 GiB<sup class=\"reference\" id=\"cite_ref-Pile_170-0\"><a href=\"#cite_note-Pile-170\"><span class=\"cite-bracket\">[</span>167<span class=\"cite-bracket\">]</span></a></sup>\n</td>\n<td></td>\n<td class=\"table-yes\" style=\"background:#9EFF9E;color:black;vertical-align:middle;text-align:center;\">MIT<sup class=\"reference\" id=\"cite_ref-vb-gpt-neo_171-0\"><a href=\"#cite_note-vb-gpt-neo-171\"><span class=\"cite-bracket\">[</span>168<span class=\"cite-bracket\">]</span></a></sup>\n</td>\n<td>The first of <a href=\"/wiki/EleutherAI#GPT_models\" title=\"EleutherAI\">a series of free GPT-3 alternatives</a> released by EleutherAI. GPT-Neo outperformed an equivalent-size GPT-3 model on some benchmarks, but was significantly worse than the largest GPT-3.<sup class=\"reference\" id=\"cite_ref-vb-gpt-neo_171-1\"><a href=\"#cite_note-vb-gpt-neo-171\"><span class=\"cite-bracket\">[</span>168<span class=\"cite-bracket\">]</span></a></sup>\n</td></tr>\n<tr>\n<td><a href=\"/wiki/GPT-J\" title=\"GPT-J\">GPT-J</a></td>\n<td><span data-sort-value=\"000000002021-06-01-0000\" style=\"white-space:nowrap\">June 2021</span></td>\n<td><a href=\"/wiki/EleutherAI\" title=\"EleutherAI\">EleutherAI</a></td>\n<td><span data-sort-value=\"6000000000 !\">6</span><sup class=\"reference\" id=\"cite_ref-JxohJ_172-0\"><a href=\"#cite_note-JxohJ-172\"><span class=\"cite-bracket\">[</span>169<span class=\"cite-bracket\">]</span></a></sup></td>\n<td>825 GiB<sup class=\"reference\" id=\"cite_ref-Pile_170-1\"><a href=\"#cite_note-Pile-170\"><span class=\"cite-bracket\">[</span>167<span class=\"cite-bracket\">]</span></a></sup>\n</td>\n<td>200<sup class=\"reference\" id=\"cite_ref-:3_173-0\"><a href=\"#cite_note-:3-173\"><span class=\"cite-bracket\">[</span>170<span class=\"cite-bracket\">]</span></a></sup></td>\n<td class=\"table-yes\" style=\"background:#9EFF9E;color:black;vertical-align:middle;text-align:center;\">Apache 2.0\n</td>\n<td>GPT-3-style language model\n</td></tr>\n<tr>\n<td>Megatron-Turing NLG</td>\n<td><span data-sort-value=\"000000002021-10-01-0000\" style=\"white-space:nowrap\">October 2021</span><sup class=\"reference\" id=\"cite_ref-BwnW5_174-0\"><a href=\"#cite_note-BwnW5-174\"><span class=\"cite-bracket\">[</span>171<span class=\"cite-bracket\">]</span></a></sup></td>\n<td><a href=\"/wiki/Microsoft\" title=\"Microsoft\">Microsoft</a> and <a href=\"/wiki/Nvidia\" title=\"Nvidia\">Nvidia</a></td>\n<td><span data-sort-value=\"530000000000 !\">530</span><sup class=\"reference\" id=\"cite_ref-mtnlg-preprint_175-0\"><a href=\"#cite_note-mtnlg-preprint-175\"><span class=\"cite-bracket\">[</span>172<span class=\"cite-bracket\">]</span></a></sup></td>\n<td><span data-sort-value=\"338600000000 !\">338.6 billion</span> tokens<sup class=\"reference\" id=\"cite_ref-mtnlg-preprint_175-1\"><a href=\"#cite_note-mtnlg-preprint-175\"><span class=\"cite-bracket\">[</span>172<span class=\"cite-bracket\">]</span></a></sup>\n</td>\n<td>38000<sup class=\"reference\" id=\"cite_ref-:11_176-0\"><a href=\"#cite_note-:11-176\"><span class=\"cite-bracket\">[</span>173<span class=\"cite-bracket\">]</span></a></sup></td>\n<td class=\"table-no\" style=\"background:#FFC7C7;color:black;vertical-align:middle;text-align:center;\">Restricted web access\n</td>\n<td>Trained for 3 months on over 2000 A100 GPUs on the NVIDIA <a href=\"/wiki/Selene_(supercomputer)\" title=\"Selene (supercomputer)\">Selene Supercomputer</a>, for over 3 million GPU-hours.<sup class=\"reference\" id=\"cite_ref-:11_176-1\"><a href=\"#cite_note-:11-176\"><span class=\"cite-bracket\">[</span>173<span class=\"cite-bracket\">]</span></a></sup>\n</td></tr>\n<tr>\n<td>Ernie 3.0 Titan</td>\n<td><span data-sort-value=\"000000002021-12-01-0000\" style=\"white-space:nowrap\">December 2021</span></td>\n<td><a href=\"/wiki/Baidu\" title=\"Baidu\">Baidu</a></td>\n<td><span data-sort-value=\"260000000000 !\">260</span><sup class=\"reference\" id=\"cite_ref-qeOB8_177-0\"><a href=\"#cite_note-qeOB8-177\"><span class=\"cite-bracket\">[</span>174<span class=\"cite-bracket\">]</span></a></sup></td>\n<td>4 Tb\n</td>\n<td></td>\n<td class=\"table-no\" style=\"background:#FFC7C7;color:black;vertical-align:middle;text-align:center;\">Proprietary\n</td>\n<td>Chinese-language LLM. <a href=\"/wiki/Ernie_Bot\" title=\"Ernie Bot\">Ernie Bot</a> is based on this model.\n</td></tr>\n<tr>\n<td><a href=\"/wiki/Claude_(language_model)\" title=\"Claude (language model)\">Claude</a><sup class=\"reference\" id=\"cite_ref-i8jc4_178-0\"><a href=\"#cite_note-i8jc4-178\"><span class=\"cite-bracket\">[</span>175<span class=\"cite-bracket\">]</span></a></sup></td>\n<td><span data-sort-value=\"000000002021-12-01-0000\" style=\"white-space:nowrap\">December 2021</span></td>\n<td><a href=\"/wiki/Anthropic\" title=\"Anthropic\">Anthropic</a></td>\n<td><span data-sort-value=\"52000000000 !\">52</span><sup class=\"reference\" id=\"cite_ref-AnthroArch_179-0\"><a href=\"#cite_note-AnthroArch-179\"><span class=\"cite-bracket\">[</span>176<span class=\"cite-bracket\">]</span></a></sup></td>\n<td><span data-sort-value=\"400000000000 !\">400 billion</span> tokens<sup class=\"reference\" id=\"cite_ref-AnthroArch_179-1\"><a href=\"#cite_note-AnthroArch-179\"><span class=\"cite-bracket\">[</span>176<span class=\"cite-bracket\">]</span></a></sup>\n</td>\n<td></td>\n<td class=\"table-partial\" style=\"background: #FFB; color:black; vertical-align: middle; text-align: center;\">beta\n</td>\n<td>Fine-tuned for desirable behavior in conversations.<sup class=\"reference\" id=\"cite_ref-RZqhw_180-0\"><a href=\"#cite_note-RZqhw-180\"><span class=\"cite-bracket\">[</span>177<span class=\"cite-bracket\">]</span></a></sup>\n</td></tr>\n<tr>\n<td>GLaM (Generalist Language Model)</td>\n<td><span data-sort-value=\"000000002021-12-01-0000\" style=\"white-space:nowrap\">December 2021</span></td>\n<td>Google</td>\n<td><span data-sort-value=\"1200000000000 !\">1200</span><sup class=\"reference\" id=\"cite_ref-glam-blog_41-1\"><a href=\"#cite_note-glam-blog-41\"><span class=\"cite-bracket\">[</span>41<span class=\"cite-bracket\">]</span></a></sup></td>\n<td><span data-sort-value=\"1600000000000 !\">1.6 trillion</span> tokens<sup class=\"reference\" id=\"cite_ref-glam-blog_41-2\"><a href=\"#cite_note-glam-blog-41\"><span class=\"cite-bracket\">[</span>41<span class=\"cite-bracket\">]</span></a></sup>\n</td>\n<td>5600<sup class=\"reference\" id=\"cite_ref-glam-blog_41-3\"><a href=\"#cite_note-glam-blog-41\"><span class=\"cite-bracket\">[</span>41<span class=\"cite-bracket\">]</span></a></sup></td>\n<td class=\"table-no\" style=\"background:#FFC7C7;color:black;vertical-align:middle;text-align:center;\">Proprietary\n</td>\n<td>Sparse <a href=\"/wiki/Mixture_of_experts\" title=\"Mixture of experts\">mixture of experts</a> model, making it more expensive to train but cheaper to run inference compared to GPT-3.\n</td></tr>\n<tr>\n<td>Gopher</td>\n<td><span data-sort-value=\"000000002021-12-01-0000\" style=\"white-space:nowrap\">December 2021</span></td>\n<td><a class=\"mw-redirect\" href=\"/wiki/DeepMind\" title=\"DeepMind\">DeepMind</a></td>\n<td><span data-sort-value=\"280000000000 !\">280</span><sup class=\"reference\" id=\"cite_ref-mD5eE_181-0\"><a href=\"#cite_note-mD5eE-181\"><span class=\"cite-bracket\">[</span>178<span class=\"cite-bracket\">]</span></a></sup></td>\n<td><span data-sort-value=\"300000000000 !\">300 billion</span> tokens<sup class=\"reference\" id=\"cite_ref-hoffman_182-0\"><a href=\"#cite_note-hoffman-182\"><span class=\"cite-bracket\">[</span>179<span class=\"cite-bracket\">]</span></a></sup>\n</td>\n<td>5833<sup class=\"reference\" id=\"cite_ref-:4_183-0\"><a href=\"#cite_note-:4-183\"><span class=\"cite-bracket\">[</span>180<span class=\"cite-bracket\">]</span></a></sup></td>\n<td class=\"table-no\" style=\"background:#FFC7C7;color:black;vertical-align:middle;text-align:center;\">Proprietary\n</td>\n<td>Later developed into the Chinchilla model.\n</td></tr>\n<tr>\n<td><a href=\"/wiki/LaMDA\" title=\"LaMDA\">LaMDA</a> (Language Models for Dialog Applications)</td>\n<td><span data-sort-value=\"000000002022-01-01-0000\" style=\"white-space:nowrap\">January 2022</span></td>\n<td>Google</td>\n<td><span data-sort-value=\"137000000000 !\">137</span><sup class=\"reference\" id=\"cite_ref-lamda-blog_184-0\"><a href=\"#cite_note-lamda-blog-184\"><span class=\"cite-bracket\">[</span>181<span class=\"cite-bracket\">]</span></a></sup></td>\n<td>1.56T words,<sup class=\"reference\" id=\"cite_ref-lamda-blog_184-1\"><a href=\"#cite_note-lamda-blog-184\"><span class=\"cite-bracket\">[</span>181<span class=\"cite-bracket\">]</span></a></sup> <span data-sort-value=\"168000000000 !\">168 billion</span> tokens<sup class=\"reference\" id=\"cite_ref-hoffman_182-1\"><a href=\"#cite_note-hoffman-182\"><span class=\"cite-bracket\">[</span>179<span class=\"cite-bracket\">]</span></a></sup>\n</td>\n<td>4110<sup class=\"reference\" id=\"cite_ref-DMs9Z_185-0\"><a href=\"#cite_note-DMs9Z-185\"><span class=\"cite-bracket\">[</span>182<span class=\"cite-bracket\">]</span></a></sup></td>\n<td class=\"table-no\" style=\"background:#FFC7C7;color:black;vertical-align:middle;text-align:center;\">Proprietary\n</td>\n<td>Specialized for response generation in conversations.\n</td></tr>\n<tr>\n<td>GPT-NeoX</td>\n<td><span data-sort-value=\"000000002022-02-01-0000\" style=\"white-space:nowrap\">February 2022</span></td>\n<td><a href=\"/wiki/EleutherAI\" title=\"EleutherAI\">EleutherAI</a></td>\n<td><span data-sort-value=\"20000000000 !\">20</span><sup class=\"reference\" id=\"cite_ref-gpt-neox-20b_186-0\"><a href=\"#cite_note-gpt-neox-20b-186\"><span class=\"cite-bracket\">[</span>183<span class=\"cite-bracket\">]</span></a></sup></td>\n<td>825 GiB<sup class=\"reference\" id=\"cite_ref-Pile_170-2\"><a href=\"#cite_note-Pile-170\"><span class=\"cite-bracket\">[</span>167<span class=\"cite-bracket\">]</span></a></sup>\n</td>\n<td>740<sup class=\"reference\" id=\"cite_ref-:3_173-1\"><a href=\"#cite_note-:3-173\"><span class=\"cite-bracket\">[</span>170<span class=\"cite-bracket\">]</span></a></sup></td>\n<td class=\"table-yes\" style=\"background:#9EFF9E;color:black;vertical-align:middle;text-align:center;\">Apache 2.0\n</td>\n<td>based on the Megatron architecture\n</td></tr>\n<tr>\n<td><a class=\"mw-redirect\" href=\"/wiki/Chinchilla_AI\" title=\"Chinchilla AI\">Chinchilla</a></td>\n<td><span data-sort-value=\"000000002022-03-01-0000\" style=\"white-space:nowrap\">March 2022</span></td>\n<td><a class=\"mw-redirect\" href=\"/wiki/DeepMind\" title=\"DeepMind\">DeepMind</a></td>\n<td><span data-sort-value=\"70000000000 !\">70</span><sup class=\"reference\" id=\"cite_ref-chinchilla-blog_187-0\"><a href=\"#cite_note-chinchilla-blog-187\"><span class=\"cite-bracket\">[</span>184<span class=\"cite-bracket\">]</span></a></sup></td>\n<td><span data-sort-value=\"1400000000000 !\">1.4 trillion</span> tokens<sup class=\"reference\" id=\"cite_ref-chinchilla-blog_187-1\"><a href=\"#cite_note-chinchilla-blog-187\"><span class=\"cite-bracket\">[</span>184<span class=\"cite-bracket\">]</span></a></sup><sup class=\"reference\" id=\"cite_ref-hoffman_182-2\"><a href=\"#cite_note-hoffman-182\"><span class=\"cite-bracket\">[</span>179<span class=\"cite-bracket\">]</span></a></sup>\n</td>\n<td>6805<sup class=\"reference\" id=\"cite_ref-:4_183-1\"><a href=\"#cite_note-:4-183\"><span class=\"cite-bracket\">[</span>180<span class=\"cite-bracket\">]</span></a></sup></td>\n<td class=\"table-no\" style=\"background:#FFC7C7;color:black;vertical-align:middle;text-align:center;\">Proprietary\n</td>\n<td>Reduced-parameter model trained on more data. Used in the <a class=\"mw-redirect\" href=\"/wiki/Sparrow_(bot)\" title=\"Sparrow (bot)\">Sparrow</a> bot. Often cited for its <a href=\"/wiki/Neural_scaling_law\" title=\"Neural scaling law\">neural scaling law</a>.\n</td></tr>\n<tr>\n<td><a href=\"/wiki/PaLM\" title=\"PaLM\">PaLM</a> (Pathways Language Model)</td>\n<td><span data-sort-value=\"000000002022-04-01-0000\" style=\"white-space:nowrap\">April 2022</span></td>\n<td>Google</td>\n<td><span data-sort-value=\"540000000000 !\">540</span><sup class=\"reference\" id=\"cite_ref-palm-blog_188-0\"><a href=\"#cite_note-palm-blog-188\"><span class=\"cite-bracket\">[</span>185<span class=\"cite-bracket\">]</span></a></sup></td>\n<td><span data-sort-value=\"768000000000 !\">768 billion</span> tokens<sup class=\"reference\" id=\"cite_ref-chinchilla-blog_187-2\"><a href=\"#cite_note-chinchilla-blog-187\"><span class=\"cite-bracket\">[</span>184<span class=\"cite-bracket\">]</span></a></sup>\n</td>\n<td><span data-sort-value=\"29250 !\">29,250</span><sup class=\"reference\" id=\"cite_ref-:4_183-2\"><a href=\"#cite_note-:4-183\"><span class=\"cite-bracket\">[</span>180<span class=\"cite-bracket\">]</span></a></sup></td>\n<td class=\"table-no\" style=\"background:#FFC7C7;color:black;vertical-align:middle;text-align:center;\">Proprietary\n</td>\n<td>Trained for ~60 days on ~6000 <a href=\"/wiki/Tensor_Processing_Unit\" title=\"Tensor Processing Unit\">TPU v4</a> chips.<sup class=\"reference\" id=\"cite_ref-:4_183-3\"><a href=\"#cite_note-:4-183\"><span class=\"cite-bracket\">[</span>180<span class=\"cite-bracket\">]</span></a></sup> As of October 2024<sup class=\"plainlinks noexcerpt noprint asof-tag update\" style=\"display:none;\"><a class=\"external text\" href=\"https://en.wikipedia.org/w/index.php?title=Large_language_model&amp;action=edit\">[update]</a></sup>, it is the largest dense Transformer published.\n</td></tr>\n<tr>\n<td>OPT (Open Pretrained Transformer)</td>\n<td><span data-sort-value=\"000000002022-05-01-0000\" style=\"white-space:nowrap\">May 2022</span></td>\n<td><a href=\"/wiki/Meta_Platforms\" title=\"Meta Platforms\">Meta</a></td>\n<td><span data-sort-value=\"175000000000 !\">175</span><sup class=\"reference\" id=\"cite_ref-jlof8_189-0\"><a href=\"#cite_note-jlof8-189\"><span class=\"cite-bracket\">[</span>186<span class=\"cite-bracket\">]</span></a></sup></td>\n<td><span data-sort-value=\"180000000000 !\">180 billion</span> tokens<sup class=\"reference\" id=\"cite_ref-QjTIc_190-0\"><a href=\"#cite_note-QjTIc-190\"><span class=\"cite-bracket\">[</span>187<span class=\"cite-bracket\">]</span></a></sup>\n</td>\n<td>310<sup class=\"reference\" id=\"cite_ref-:3_173-2\"><a href=\"#cite_note-:3-173\"><span class=\"cite-bracket\">[</span>170<span class=\"cite-bracket\">]</span></a></sup></td>\n<td class=\"table-partial\" style=\"background: #FFB; color:black; vertical-align: middle; text-align: center;\">Non-commercial research<sup class=\"reference\" id=\"cite_ref-191\"><a href=\"#cite_note-191\"><span class=\"cite-bracket\">[</span>d<span class=\"cite-bracket\">]</span></a></sup>\n</td>\n<td>GPT-3 architecture with some adaptations from Megatron. Uniquely, the training logbook written by the team was published.<sup class=\"reference\" id=\"cite_ref-192\"><a href=\"#cite_note-192\"><span class=\"cite-bracket\">[</span>188<span class=\"cite-bracket\">]</span></a></sup>\n</td></tr>\n<tr>\n<td>YaLM 100B</td>\n<td><span data-sort-value=\"000000002022-06-01-0000\" style=\"white-space:nowrap\">June 2022</span></td>\n<td><a href=\"/wiki/Yandex\" title=\"Yandex\">Yandex</a></td>\n<td><span data-sort-value=\"100000000000 !\">100</span><sup class=\"reference\" id=\"cite_ref-yalm-repo_193-0\"><a href=\"#cite_note-yalm-repo-193\"><span class=\"cite-bracket\">[</span>189<span class=\"cite-bracket\">]</span></a></sup>\n</td>\n<td>1.7TB<sup class=\"reference\" id=\"cite_ref-yalm-repo_193-1\"><a href=\"#cite_note-yalm-repo-193\"><span class=\"cite-bracket\">[</span>189<span class=\"cite-bracket\">]</span></a></sup></td>\n<td></td>\n<td class=\"table-yes\" style=\"background:#9EFF9E;color:black;vertical-align:middle;text-align:center;\">Apache 2.0</td>\n<td>English-Russian model based on Microsoft's Megatron-LM.\n</td></tr>\n<tr>\n<td>Minerva</td>\n<td><span data-sort-value=\"000000002022-06-01-0000\" style=\"white-space:nowrap\">June 2022</span></td>\n<td>Google</td>\n<td><span data-sort-value=\"540000000000 !\">540</span><sup class=\"reference\" id=\"cite_ref-minerva-paper_194-0\"><a href=\"#cite_note-minerva-paper-194\"><span class=\"cite-bracket\">[</span>190<span class=\"cite-bracket\">]</span></a></sup></td>\n<td>38.5B tokens from webpages filtered for mathematical content and from papers submitted to the arXiv preprint server<sup class=\"reference\" id=\"cite_ref-minerva-paper_194-1\"><a href=\"#cite_note-minerva-paper-194\"><span class=\"cite-bracket\">[</span>190<span class=\"cite-bracket\">]</span></a></sup>\n</td>\n<td></td>\n<td class=\"table-no\" style=\"background:#FFC7C7;color:black;vertical-align:middle;text-align:center;\">Proprietary\n</td>\n<td>For solving \"mathematical and scientific questions using step-by-step reasoning\".<sup class=\"reference\" id=\"cite_ref-FfCNK_195-0\"><a href=\"#cite_note-FfCNK-195\"><span class=\"cite-bracket\">[</span>191<span class=\"cite-bracket\">]</span></a></sup> Initialized from PaLM models, then finetuned on mathematical and scientific data.\n</td></tr>\n<tr>\n<td><a href=\"/wiki/BLOOM_(language_model)\" title=\"BLOOM (language model)\">BLOOM</a></td>\n<td><span data-sort-value=\"000000002022-07-01-0000\" style=\"white-space:nowrap\">July 2022</span></td>\n<td>Large collaboration led by <a href=\"/wiki/Hugging_Face\" title=\"Hugging Face\">Hugging Face</a></td>\n<td><span data-sort-value=\"175000000000 !\">175</span><sup class=\"reference\" id=\"cite_ref-bigger-better_196-0\"><a href=\"#cite_note-bigger-better-196\"><span class=\"cite-bracket\">[</span>192<span class=\"cite-bracket\">]</span></a></sup></td>\n<td><span data-sort-value=\"350000000000 !\">350 billion</span> tokens (1.6TB)<sup class=\"reference\" id=\"cite_ref-B8wB2_197-0\"><a href=\"#cite_note-B8wB2-197\"><span class=\"cite-bracket\">[</span>193<span class=\"cite-bracket\">]</span></a></sup>\n</td>\n<td></td>\n<td class=\"table-partial\" style=\"background: #FFB; color:black; vertical-align: middle; text-align: center;\">Responsible AI\n</td>\n<td>Essentially GPT-3 but trained on a multi-lingual corpus (30% English excluding programming languages)\n</td></tr>\n<tr>\n<td>Galactica</td>\n<td><span data-sort-value=\"000000002022-11-01-0000\" style=\"white-space:nowrap\">November 2022</span></td>\n<td><a href=\"/wiki/Meta_Platforms\" title=\"Meta Platforms\">Meta</a></td>\n<td><span data-sort-value=\"120000000000 !\">120</span></td>\n<td><span data-sort-value=\"350000000000 !\">106 billion</span> tokens<sup class=\"reference\" id=\"cite_ref-37sY6_198-0\"><a href=\"#cite_note-37sY6-198\"><span class=\"cite-bracket\">[</span>194<span class=\"cite-bracket\">]</span></a></sup>\n</td>\n<td>unknown</td>\n<td class=\"table-partial\" style=\"background: #FFB; color:black; vertical-align: middle; text-align: center;\">CC-BY-NC-4.0\n</td>\n<td>Trained on scientific text and modalities.\n</td></tr>\n<tr>\n<td>AlexaTM (Teacher Models)</td>\n<td><span data-sort-value=\"000000002022-11-01-0000\" style=\"white-space:nowrap\">November 2022</span></td>\n<td><a href=\"/wiki/Amazon_(company)\" title=\"Amazon (company)\">Amazon</a></td>\n<td><span data-sort-value=\"20000000000 !\">20</span><sup class=\"reference\" id=\"cite_ref-u5szh_199-0\"><a href=\"#cite_note-u5szh-199\"><span class=\"cite-bracket\">[</span>195<span class=\"cite-bracket\">]</span></a></sup></td>\n<td><span data-sort-value=\"1300000000000 !\">1.3 trillion</span><sup class=\"reference\" id=\"cite_ref-HaA7l_200-0\"><a href=\"#cite_note-HaA7l-200\"><span class=\"cite-bracket\">[</span>196<span class=\"cite-bracket\">]</span></a></sup>\n</td>\n<td></td>\n<td class=\"table-no\" style=\"background:#FFC7C7;color:black;vertical-align:middle;text-align:center;\">proprietary<sup class=\"reference\" id=\"cite_ref-rpehM_201-0\"><a href=\"#cite_note-rpehM-201\"><span class=\"cite-bracket\">[</span>197<span class=\"cite-bracket\">]</span></a></sup>\n</td>\n<td>bidirectional sequence-to-sequence architecture\n</td></tr>\n<tr>\n<td><a href=\"/wiki/Neuro-sama\" title=\"Neuro-sama\">Neuro-sama</a></td>\n<td><span data-sort-value=\"000000002022-12-01-0000\" style=\"white-space:nowrap\">December 2022</span></td>\n<td>Independent</td>\n<td>Unknown</td>\n<td>Unknown\n</td>\n<td></td>\n<td class=\"table-no\" style=\"background:#FFC7C7;color:black;vertical-align:middle;text-align:center;\">privately-owned\n</td>\n<td>A language model designed for live-streaming on <a href=\"/wiki/Twitch_(service)\" title=\"Twitch (service)\">Twitch</a>.\n</td></tr>\n<tr>\n<td><a class=\"mw-redirect\" href=\"/wiki/LLaMA\" title=\"LLaMA\">LLaMA</a> (Large Language Model Meta AI)</td>\n<td><span data-sort-value=\"000000002023-02-01-0000\" style=\"white-space:nowrap\">February 2023</span></td>\n<td><a href=\"/wiki/Meta_AI\" title=\"Meta AI\">Meta AI</a></td>\n<td><span data-sort-value=\"65000000000 !\">65</span><sup class=\"reference\" id=\"cite_ref-llama-blog_202-0\"><a href=\"#cite_note-llama-blog-202\"><span class=\"cite-bracket\">[</span>198<span class=\"cite-bracket\">]</span></a></sup></td>\n<td><span data-sort-value=\"1400000000000 !\">1.4 trillion</span><sup class=\"reference\" id=\"cite_ref-llama-blog_202-1\"><a href=\"#cite_note-llama-blog-202\"><span class=\"cite-bracket\">[</span>198<span class=\"cite-bracket\">]</span></a></sup>\n</td>\n<td>6300<sup class=\"reference\" id=\"cite_ref-:5_203-0\"><a href=\"#cite_note-:5-203\"><span class=\"cite-bracket\">[</span>199<span class=\"cite-bracket\">]</span></a></sup></td>\n<td class=\"table-partial\" style=\"background: #FFB; color:black; vertical-align: middle; text-align: center;\">Non-commercial research<sup class=\"reference\" id=\"cite_ref-204\"><a href=\"#cite_note-204\"><span class=\"cite-bracket\">[</span>e<span class=\"cite-bracket\">]</span></a></sup>\n</td>\n<td>Corpus has 20 languages. \"Overtrained\" (compared to <a href=\"/wiki/Chinchilla_(language_model)\" title=\"Chinchilla (language model)\">Chinchilla scaling law</a>) for better performance with fewer parameters.<sup class=\"reference\" id=\"cite_ref-llama-blog_202-2\"><a href=\"#cite_note-llama-blog-202\"><span class=\"cite-bracket\">[</span>198<span class=\"cite-bracket\">]</span></a></sup>\n</td></tr>\n<tr>\n<td><a href=\"/wiki/GPT-4\" title=\"GPT-4\">GPT-4</a></td>\n<td><span data-sort-value=\"000000002023-03-01-0000\" style=\"white-space:nowrap\">March 2023</span></td>\n<td>OpenAI</td>\n<td>Unknown<sup class=\"reference\" id=\"cite_ref-206\"><a href=\"#cite_note-206\"><span class=\"cite-bracket\">[</span>f<span class=\"cite-bracket\">]</span></a></sup> (According to rumors: 1760)<sup class=\"reference\" id=\"cite_ref-207\"><a href=\"#cite_note-207\"><span class=\"cite-bracket\">[</span>201<span class=\"cite-bracket\">]</span></a></sup>\n</td>\n<td>Unknown\n</td>\n<td>Unknown</td>\n<td class=\"table-no\" style=\"background:#FFC7C7;color:black;vertical-align:middle;text-align:center;\">proprietary\n</td>\n<td>Available for ChatGPT Plus users and used in <a href=\"/wiki/GPT-4#Usage\" title=\"GPT-4\">several products</a>.\n</td></tr>\n<tr>\n<td>Chameleon</td>\n<td><span data-sort-value=\"000000002024-06-01-0000\" style=\"white-space:nowrap\">June 2024</span></td>\n<td><a href=\"/wiki/Meta_AI\" title=\"Meta AI\">Meta AI</a></td>\n<td><span data-sort-value=\"34000000000 !\">34</span><sup class=\"reference\" id=\"cite_ref-208\"><a href=\"#cite_note-208\"><span class=\"cite-bracket\">[</span>202<span class=\"cite-bracket\">]</span></a></sup></td>\n<td><span data-sort-value=\"4400000000000 !\">4.4 trillion</span></td>\n<td></td>\n<td>\n</td></tr>\n<tr>\n<td>Cerebras-GPT\n</td>\n<td><span data-sort-value=\"000000002023-03-01-0000\" style=\"white-space:nowrap\">March 2023</span>\n</td>\n<td><a href=\"/wiki/Cerebras\" title=\"Cerebras\">Cerebras</a>\n</td>\n<td><span data-sort-value=\"13000000000 !\">13</span><sup class=\"reference\" id=\"cite_ref-D0k2a_209-0\"><a href=\"#cite_note-D0k2a-209\"><span class=\"cite-bracket\">[</span>203<span class=\"cite-bracket\">]</span></a></sup>\n</td>\n<td>\n</td>\n<td>270<sup class=\"reference\" id=\"cite_ref-:3_173-3\"><a href=\"#cite_note-:3-173\"><span class=\"cite-bracket\">[</span>170<span class=\"cite-bracket\">]</span></a></sup></td>\n<td class=\"table-yes\" style=\"background:#9EFF9E;color:black;vertical-align:middle;text-align:center;\">Apache 2.0\n</td>\n<td>Trained with <a href=\"/wiki/Chinchilla_(language_model)\" title=\"Chinchilla (language model)\">Chinchilla formula</a>.\n</td></tr>\n<tr>\n<td>Falcon</td>\n<td><span data-sort-value=\"000000002023-03-01-0000\" style=\"white-space:nowrap\">March 2023</span></td>\n<td><a href=\"/wiki/Technology_Innovation_Institute\" title=\"Technology Innovation Institute\">Technology Innovation Institute</a></td>\n<td><span data-sort-value=\"40000000000 !\">40</span><sup class=\"reference\" id=\"cite_ref-falcon_210-0\"><a href=\"#cite_note-falcon-210\"><span class=\"cite-bracket\">[</span>204<span class=\"cite-bracket\">]</span></a></sup></td>\n<td>1 trillion tokens, from RefinedWeb (filtered web text corpus)<sup class=\"reference\" id=\"cite_ref-Xb1gq_211-0\"><a href=\"#cite_note-Xb1gq-211\"><span class=\"cite-bracket\">[</span>205<span class=\"cite-bracket\">]</span></a></sup> plus some \"curated corpora\".<sup class=\"reference\" id=\"cite_ref-gzTNw_212-0\"><a href=\"#cite_note-gzTNw-212\"><span class=\"cite-bracket\">[</span>206<span class=\"cite-bracket\">]</span></a></sup>\n</td>\n<td>2800<sup class=\"reference\" id=\"cite_ref-:5_203-1\"><a href=\"#cite_note-:5-203\"><span class=\"cite-bracket\">[</span>199<span class=\"cite-bracket\">]</span></a></sup></td>\n<td class=\"table-yes\" style=\"background:#9EFF9E;color:black;vertical-align:middle;text-align:center;\">Apache 2.0<sup class=\"reference\" id=\"cite_ref-Wmlcs_213-0\"><a href=\"#cite_note-Wmlcs-213\"><span class=\"cite-bracket\">[</span>207<span class=\"cite-bracket\">]</span></a></sup>\n</td>\n<td>\n</td></tr>\n<tr>\n<td>BloombergGPT</td>\n<td><span data-sort-value=\"000000002023-03-01-0000\" style=\"white-space:nowrap\">March 2023</span></td>\n<td><a href=\"/wiki/Bloomberg_L.P.\" title=\"Bloomberg L.P.\">Bloomberg L.P.</a></td>\n<td><span data-sort-value=\"50000000000 !\">50</span></td>\n<td>363 billion token dataset based on Bloomberg's data sources, plus 345 billion tokens from general purpose datasets<sup class=\"reference\" id=\"cite_ref-nGOSu_214-0\"><a href=\"#cite_note-nGOSu-214\"><span class=\"cite-bracket\">[</span>208<span class=\"cite-bracket\">]</span></a></sup>\n</td>\n<td></td>\n<td class=\"table-no\" style=\"background:#FFC7C7;color:black;vertical-align:middle;text-align:center;\">Proprietary\n</td>\n<td>Trained on financial data from proprietary sources, for financial tasks.\n</td></tr>\n<tr>\n<td><a href=\"/wiki/Huawei_PanGu\" title=\"Huawei PanGu\">PanGu-Σ</a></td>\n<td><span data-sort-value=\"000000002023-03-01-0000\" style=\"white-space:nowrap\">March 2023</span></td>\n<td><a href=\"/wiki/Huawei\" title=\"Huawei\">Huawei</a></td>\n<td><span data-sort-value=\"1085000000000 !\">1085</span></td>\n<td>329 billion tokens<sup class=\"reference\" id=\"cite_ref-9WSFw_215-0\"><a href=\"#cite_note-9WSFw-215\"><span class=\"cite-bracket\">[</span>209<span class=\"cite-bracket\">]</span></a></sup>\n</td>\n<td></td>\n<td class=\"table-no\" style=\"background:#FFC7C7;color:black;vertical-align:middle;text-align:center;\">Proprietary\n</td>\n<td>\n</td></tr>\n<tr>\n<td>OpenAssistant<sup class=\"reference\" id=\"cite_ref-JiOl8_216-0\"><a href=\"#cite_note-JiOl8-216\"><span class=\"cite-bracket\">[</span>210<span class=\"cite-bracket\">]</span></a></sup></td>\n<td><span data-sort-value=\"000000002023-03-01-0000\" style=\"white-space:nowrap\">March 2023</span></td>\n<td><a href=\"/wiki/LAION\" title=\"LAION\">LAION</a></td>\n<td><span data-sort-value=\"17000000000 !\">17</span></td>\n<td>1.5 trillion tokens\n</td>\n<td></td>\n<td class=\"table-yes\" style=\"background:#9EFF9E;color:black;vertical-align:middle;text-align:center;\">Apache 2.0\n</td>\n<td>Trained on crowdsourced open data\n</td></tr>\n<tr>\n<td>Jurassic-2<sup class=\"reference\" id=\"cite_ref-217\"><a href=\"#cite_note-217\"><span class=\"cite-bracket\">[</span>211<span class=\"cite-bracket\">]</span></a></sup>\n</td>\n<td><span data-sort-value=\"000000002023-03-01-0000\" style=\"white-space:nowrap\">March 2023</span>\n</td>\n<td><a href=\"/wiki/AI21_Labs\" title=\"AI21 Labs\">AI21 Labs</a>\n</td>\n<td>Unknown\n</td>\n<td>Unknown\n</td>\n<td></td>\n<td class=\"table-no\" style=\"background:#FFC7C7;color:black;vertical-align:middle;text-align:center;\">Proprietary\n</td>\n<td>Multilingual<sup class=\"reference\" id=\"cite_ref-218\"><a href=\"#cite_note-218\"><span class=\"cite-bracket\">[</span>212<span class=\"cite-bracket\">]</span></a></sup>\n</td></tr>\n<tr>\n<td><a href=\"/wiki/PaLM\" title=\"PaLM\">PaLM 2</a> (Pathways Language Model 2)</td>\n<td><span data-sort-value=\"000000002023-05-01-0000\" style=\"white-space:nowrap\">May 2023</span></td>\n<td>Google</td>\n<td><span data-sort-value=\"340000000000 !\">340</span><sup class=\"reference\" id=\"cite_ref-cnbc-20230516_219-0\"><a href=\"#cite_note-cnbc-20230516-219\"><span class=\"cite-bracket\">[</span>213<span class=\"cite-bracket\">]</span></a></sup></td>\n<td><span data-sort-value=\"3600000000000 !\">3.6 trillion</span> tokens<sup class=\"reference\" id=\"cite_ref-cnbc-20230516_219-1\"><a href=\"#cite_note-cnbc-20230516-219\"><span class=\"cite-bracket\">[</span>213<span class=\"cite-bracket\">]</span></a></sup>\n</td>\n<td><span data-sort-value=\"85000 !\">85,000</span><sup class=\"reference\" id=\"cite_ref-:5_203-2\"><a href=\"#cite_note-:5-203\"><span class=\"cite-bracket\">[</span>199<span class=\"cite-bracket\">]</span></a></sup></td>\n<td class=\"table-no\" style=\"background:#FFC7C7;color:black;vertical-align:middle;text-align:center;\">Proprietary\n</td>\n<td>Was used in <a class=\"mw-redirect\" href=\"/wiki/Bard_(chatbot)\" title=\"Bard (chatbot)\">Bard chatbot</a>.<sup class=\"reference\" id=\"cite_ref-pWyLA_220-0\"><a href=\"#cite_note-pWyLA-220\"><span class=\"cite-bracket\">[</span>214<span class=\"cite-bracket\">]</span></a></sup>\n</td></tr>\n<tr>\n<td>Llama 2</td>\n<td><span data-sort-value=\"000000002023-07-01-0000\" style=\"white-space:nowrap\">July 2023</span></td>\n<td>Meta AI</td>\n<td><span data-sort-value=\"70000000000 !\">70</span><sup class=\"reference\" id=\"cite_ref-meta-20230719_221-0\"><a href=\"#cite_note-meta-20230719-221\"><span class=\"cite-bracket\">[</span>215<span class=\"cite-bracket\">]</span></a></sup></td>\n<td><span data-sort-value=\"2000000000000 !\">2 trillion</span> tokens<sup class=\"reference\" id=\"cite_ref-meta-20230719_221-1\"><a href=\"#cite_note-meta-20230719-221\"><span class=\"cite-bracket\">[</span>215<span class=\"cite-bracket\">]</span></a></sup>\n</td>\n<td><span data-sort-value=\"21000 !\">21,000</span></td>\n<td class=\"table-partial\" style=\"background: #FFB; color:black; vertical-align: middle; text-align: center;\">Llama 2 license\n</td>\n<td>1.7 million A100-hours.<sup class=\"reference\" id=\"cite_ref-222\"><a href=\"#cite_note-222\"><span class=\"cite-bracket\">[</span>216<span class=\"cite-bracket\">]</span></a></sup>\n</td></tr>\n<tr>\n<td><a href=\"/wiki/Claude_(language_model)\" title=\"Claude (language model)\">Claude 2</a>\n</td>\n<td><span data-sort-value=\"000000002023-07-01-0000\" style=\"white-space:nowrap\">July 2023</span>\n</td>\n<td>Anthropic\n</td>\n<td>Unknown\n</td>\n<td>Unknown\n</td>\n<td>Unknown</td>\n<td class=\"table-no\" style=\"background:#FFC7C7;color:black;vertical-align:middle;text-align:center;\">Proprietary\n</td>\n<td>Used in Claude chatbot.<sup class=\"reference\" id=\"cite_ref-223\"><a href=\"#cite_note-223\"><span class=\"cite-bracket\">[</span>217<span class=\"cite-bracket\">]</span></a></sup>\n</td></tr>\n<tr>\n<td><a href=\"/wiki/IBM_Granite\" title=\"IBM Granite\">Granite 13b</a>\n</td>\n<td><span data-sort-value=\"000000002023-07-01-0000\" style=\"white-space:nowrap\">July 2023</span>\n</td>\n<td><a href=\"/wiki/IBM\" title=\"IBM\">IBM</a>\n</td>\n<td>Unknown\n</td>\n<td>Unknown\n</td>\n<td>Unknown</td>\n<td class=\"table-no\" style=\"background:#FFC7C7;color:black;vertical-align:middle;text-align:center;\">Proprietary\n</td>\n<td>Used in <a href=\"/wiki/IBM_Watsonx\" title=\"IBM Watsonx\">IBM Watsonx</a>.<sup class=\"reference\" id=\"cite_ref-224\"><a href=\"#cite_note-224\"><span class=\"cite-bracket\">[</span>218<span class=\"cite-bracket\">]</span></a></sup>\n</td></tr>\n<tr>\n<td>Mistral 7B</td>\n<td><span data-sort-value=\"000000002023-09-01-0000\" style=\"white-space:nowrap\">September 2023</span></td>\n<td><a href=\"/wiki/Mistral_AI\" title=\"Mistral AI\">Mistral AI</a></td>\n<td><span data-sort-value=\"7300000000 !\">7.3</span><sup class=\"reference\" id=\"cite_ref-mistral-20230927_225-0\"><a href=\"#cite_note-mistral-20230927-225\"><span class=\"cite-bracket\">[</span>219<span class=\"cite-bracket\">]</span></a></sup></td>\n<td>Unknown\n</td>\n<td></td>\n<td class=\"table-yes\" style=\"background:#9EFF9E;color:black;vertical-align:middle;text-align:center;\">Apache 2.0\n</td>\n<td>\n</td></tr>\n<tr>\n<td><a href=\"/wiki/Claude_(language_model)\" title=\"Claude (language model)\">Claude 2.1</a>\n</td>\n<td><span data-sort-value=\"000000002023-11-01-0000\" style=\"white-space:nowrap\">November 2023</span>\n</td>\n<td>Anthropic\n</td>\n<td>Unknown\n</td>\n<td>Unknown\n</td>\n<td>Unknown</td>\n<td class=\"table-no\" style=\"background:#FFC7C7;color:black;vertical-align:middle;text-align:center;\">Proprietary\n</td>\n<td>Used in Claude chatbot. Has a context window of 200,000 tokens, or ~500 pages.<sup class=\"reference\" id=\"cite_ref-226\"><a href=\"#cite_note-226\"><span class=\"cite-bracket\">[</span>220<span class=\"cite-bracket\">]</span></a></sup>\n</td></tr>\n<tr>\n<td>Grok-1<sup class=\"reference\" id=\"cite_ref-227\"><a href=\"#cite_note-227\"><span class=\"cite-bracket\">[</span>221<span class=\"cite-bracket\">]</span></a></sup>\n</td>\n<td><span data-sort-value=\"000000002023-11-01-0000\" style=\"white-space:nowrap\">November 2023</span>\n</td>\n<td><a href=\"/wiki/XAI_(company)\" title=\"XAI (company)\">xAI</a>\n</td>\n<td>314\n</td>\n<td>Unknown\n</td>\n<td>Unknown</td>\n<td class=\"table-yes\" style=\"background:#9EFF9E;color:black;vertical-align:middle;text-align:center;\">Apache 2.0\n</td>\n<td>Used in <a href=\"/wiki/Grok_(chatbot)\" title=\"Grok (chatbot)\">Grok</a> chatbot. Grok-1 has a context length of 8,192 tokens and has access to X (Twitter).<sup class=\"reference\" id=\"cite_ref-228\"><a href=\"#cite_note-228\"><span class=\"cite-bracket\">[</span>222<span class=\"cite-bracket\">]</span></a></sup>\n</td></tr>\n<tr>\n<td><a href=\"/wiki/Gemini_(language_model)\" title=\"Gemini (language model)\">Gemini 1.0</a>\n</td>\n<td><span data-sort-value=\"000000002023-12-01-0000\" style=\"white-space:nowrap\">December 2023</span>\n</td>\n<td><a href=\"/wiki/Google_DeepMind\" title=\"Google DeepMind\">Google DeepMind</a>\n</td>\n<td>Unknown\n</td>\n<td>Unknown\n</td>\n<td>Unknown</td>\n<td class=\"table-no\" style=\"background:#FFC7C7;color:black;vertical-align:middle;text-align:center;\">Proprietary\n</td>\n<td>Multimodal model, comes in three sizes. Used in <a href=\"/wiki/Gemini_(chatbot)\" title=\"Gemini (chatbot)\">the chatbot of the same name</a>.<sup class=\"reference\" id=\"cite_ref-229\"><a href=\"#cite_note-229\"><span class=\"cite-bracket\">[</span>223<span class=\"cite-bracket\">]</span></a></sup>\n</td></tr>\n<tr>\n<td>Mixtral 8x7B\n</td>\n<td><span data-sort-value=\"000000002023-12-01-0000\" style=\"white-space:nowrap\">December 2023</span>\n</td>\n<td><a href=\"/wiki/Mistral_AI\" title=\"Mistral AI\">Mistral AI</a>\n</td>\n<td>46.7\n</td>\n<td>Unknown\n</td>\n<td>Unknown</td>\n<td class=\"table-yes\" style=\"background:#9EFF9E;color:black;vertical-align:middle;text-align:center;\">Apache 2.0\n</td>\n<td>Outperforms GPT-3.5 and Llama 2 70B on many benchmarks.<sup class=\"reference\" id=\"cite_ref-230\"><a href=\"#cite_note-230\"><span class=\"cite-bracket\">[</span>224<span class=\"cite-bracket\">]</span></a></sup> <a href=\"/wiki/Mixture_of_experts\" title=\"Mixture of experts\">Mixture of experts</a> model, with 12.9 billion parameters activated per token.<sup class=\"reference\" id=\"cite_ref-231\"><a href=\"#cite_note-231\"><span class=\"cite-bracket\">[</span>225<span class=\"cite-bracket\">]</span></a></sup>\n</td></tr>\n<tr>\n<td>Mixtral 8x22B\n</td>\n<td><span data-sort-value=\"000000002024-04-01-0000\" style=\"white-space:nowrap\">April 2024</span>\n</td>\n<td><a href=\"/wiki/Mistral_AI\" title=\"Mistral AI\">Mistral AI</a>\n</td>\n<td>141\n</td>\n<td>Unknown\n</td>\n<td>Unknown</td>\n<td class=\"table-yes\" style=\"background:#9EFF9E;color:black;vertical-align:middle;text-align:center;\">Apache 2.0\n</td>\n<td><sup class=\"reference\" id=\"cite_ref-232\"><a href=\"#cite_note-232\"><span class=\"cite-bracket\">[</span>226<span class=\"cite-bracket\">]</span></a></sup>\n</td></tr>\n<tr>\n<td><a class=\"new\" href=\"/w/index.php?title=Phi_(LLM)&amp;action=edit&amp;redlink=1\" title=\"Phi (LLM) (page does not exist)\">Phi-2</a>\n</td>\n<td><span data-sort-value=\"000000002023-12-01-0000\" style=\"white-space:nowrap\">December 2023</span>\n</td>\n<td>Microsoft\n</td>\n<td>2.7\n</td>\n<td>1.4T tokens\n</td>\n<td>419<sup class=\"reference\" id=\"cite_ref-:9_233-0\"><a href=\"#cite_note-:9-233\"><span class=\"cite-bracket\">[</span>227<span class=\"cite-bracket\">]</span></a></sup></td>\n<td class=\"table-yes\" style=\"background:#9EFF9E;color:black;vertical-align:middle;text-align:center;\">MIT\n</td>\n<td>Trained on real and synthetic \"textbook-quality\" data, for 14 days on 96 A100 GPUs.<sup class=\"reference\" id=\"cite_ref-:9_233-1\"><a href=\"#cite_note-:9-233\"><span class=\"cite-bracket\">[</span>227<span class=\"cite-bracket\">]</span></a></sup>\n</td></tr>\n<tr>\n<td><a href=\"/wiki/Gemini_(language_model)\" title=\"Gemini (language model)\">Gemini 1.5</a>\n</td>\n<td><span data-sort-value=\"000000002024-02-01-0000\" style=\"white-space:nowrap\">February 2024</span>\n</td>\n<td><a href=\"/wiki/Google_DeepMind\" title=\"Google DeepMind\">Google DeepMind</a>\n</td>\n<td>Unknown\n</td>\n<td>Unknown\n</td>\n<td>Unknown</td>\n<td class=\"table-no\" style=\"background:#FFC7C7;color:black;vertical-align:middle;text-align:center;\">Proprietary\n</td>\n<td>Multimodal model, based on a <a href=\"/wiki/Mixture_of_experts\" title=\"Mixture of experts\">Mixture-of-Experts</a> (MoE) architecture. Context window above 1 million tokens.<sup class=\"reference\" id=\"cite_ref-234\"><a href=\"#cite_note-234\"><span class=\"cite-bracket\">[</span>228<span class=\"cite-bracket\">]</span></a></sup>\n</td></tr>\n<tr>\n<td><a href=\"/wiki/Gemini_(language_model)\" title=\"Gemini (language model)\">Gemini Ultra</a>\n</td>\n<td><span data-sort-value=\"000000002024-02-01-0000\" style=\"white-space:nowrap\">February 2024</span>\n</td>\n<td><a href=\"/wiki/Google_DeepMind\" title=\"Google DeepMind\">Google DeepMind</a>\n</td>\n<td>Unknown\n</td>\n<td>Unknown\n</td>\n<td>Unknown</td>\n<td>\n</td>\n<td>\n</td></tr>\n<tr>\n<td>Gemma</td>\n<td><span data-sort-value=\"000000002024-02-01-0000\" style=\"white-space:nowrap\">February 2024</span></td>\n<td><a href=\"/wiki/Google_DeepMind\" title=\"Google DeepMind\">Google DeepMind</a></td>\n<td>7</td>\n<td>6T tokens</td>\n<td>Unknown</td>\n<td class=\"table-partial\" style=\"background: #FFB; color:black; vertical-align: middle; text-align: center;\">Gemma Terms of Use<sup class=\"reference\" id=\"cite_ref-gemma_235-0\"><a href=\"#cite_note-gemma-235\"><span class=\"cite-bracket\">[</span>229<span class=\"cite-bracket\">]</span></a></sup></td>\n<td>\n</td></tr>\n<tr>\n<td><a href=\"/wiki/Claude_(language_model)\" title=\"Claude (language model)\">Claude 3</a>\n</td>\n<td>March 2024\n</td>\n<td>Anthropic\n</td>\n<td>Unknown\n</td>\n<td>Unknown\n</td>\n<td>Unknown\n</td>\n<td class=\"table-no\" style=\"background:#FFC7C7;color:black;vertical-align:middle;text-align:center;\">Proprietary\n</td>\n<td>Includes three models, Haiku, Sonnet, and Opus.<sup class=\"reference\" id=\"cite_ref-236\"><a href=\"#cite_note-236\"><span class=\"cite-bracket\">[</span>230<span class=\"cite-bracket\">]</span></a></sup>\n</td></tr>\n<tr>\n<td><a class=\"external text\" href=\"https://rubiks.ai/nova/release/\" rel=\"nofollow\">Nova</a>\n</td>\n<td>October 2024\n</td>\n<td><a class=\"external text\" href=\"https://rubiks.ai/\" rel=\"nofollow\">Rubik's AI</a>\n</td>\n<td>Unknown\n</td>\n<td>Unknown\n</td>\n<td>Unknown\n</td>\n<td class=\"table-no\" style=\"background:#FFC7C7;color:black;vertical-align:middle;text-align:center;\">Proprietary\n</td>\n<td>Includes three models, Nova-Instant, Nova-Air, and Nova-Pro.\n</td></tr>\n<tr>\n<td><a href=\"/wiki/DBRX\" title=\"DBRX\">DBRX</a>\n</td>\n<td>March 2024\n</td>\n<td><a href=\"/wiki/Databricks\" title=\"Databricks\">Databricks</a> and <a class=\"mw-redirect\" href=\"/wiki/Mosaic_ML\" title=\"Mosaic ML\">Mosaic ML</a>\n</td>\n<td><span data-sort-value=\"13600000000 !\">136</span>\n</td>\n<td>12T Tokens\n</td>\n<td>\n</td>\n<td class=\"table-yes\" style=\"background:#9EFF9E;color:black;vertical-align:middle;text-align:center;\">Databricks Open Model License\n</td>\n<td>Training cost 10 million USD.\n</td></tr>\n<tr>\n<td>Fugaku-LLM\n</td>\n<td>May 2024\n</td>\n<td><a href=\"/wiki/Fujitsu\" title=\"Fujitsu\">Fujitsu</a>, <a href=\"/wiki/Tokyo_Institute_of_Technology\" title=\"Tokyo Institute of Technology\">Tokyo Institute of Technology</a>, etc.\n</td>\n<td><span data-sort-value=\"1300000000 !\">13</span>\n</td>\n<td>380B Tokens\n</td>\n<td>\n</td>\n<td>\n</td>\n<td>The largest model ever trained on CPU-only, on the <a href=\"/wiki/Fugaku_(supercomputer)\" title=\"Fugaku (supercomputer)\">Fugaku</a>.<sup class=\"reference\" id=\"cite_ref-237\"><a href=\"#cite_note-237\"><span class=\"cite-bracket\">[</span>231<span class=\"cite-bracket\">]</span></a></sup>\n</td></tr>\n<tr>\n<td><a class=\"new\" href=\"/w/index.php?title=Phi_(LLM)&amp;action=edit&amp;redlink=1\" title=\"Phi (LLM) (page does not exist)\">Phi-3</a>\n</td>\n<td><span data-sort-value=\"000000002024-04-01-0000\" style=\"white-space:nowrap\">April 2024</span>\n</td>\n<td>Microsoft\n</td>\n<td>14<sup class=\"reference\" id=\"cite_ref-238\"><a href=\"#cite_note-238\"><span class=\"cite-bracket\">[</span>232<span class=\"cite-bracket\">]</span></a></sup>\n</td>\n<td>4.8T Tokens\n</td>\n<td>\n</td>\n<td class=\"table-yes\" style=\"background:#9EFF9E;color:black;vertical-align:middle;text-align:center;\">MIT\n</td>\n<td>Microsoft markets them as \"small language model\".<sup class=\"reference\" id=\"cite_ref-239\"><a href=\"#cite_note-239\"><span class=\"cite-bracket\">[</span>233<span class=\"cite-bracket\">]</span></a></sup>\n</td></tr>\n<tr>\n<td><a href=\"/wiki/IBM_Granite\" title=\"IBM Granite\">Granite Code Models</a>\n</td>\n<td><span data-sort-value=\"000000002024-05-01-0000\" style=\"white-space:nowrap\">May 2024</span>\n</td>\n<td><a href=\"/wiki/IBM\" title=\"IBM\">IBM</a>\n</td>\n<td>Unknown\n</td>\n<td>Unknown\n</td>\n<td>Unknown</td>\n<td class=\"table-yes\" style=\"background:#9EFF9E;color:black;vertical-align:middle;text-align:center;\">Apache 2.0\n</td>\n<td>\n</td></tr>\n<tr>\n<td>Qwen2\n</td>\n<td><span data-sort-value=\"000000002024-06-01-0000\" style=\"white-space:nowrap\">June 2024</span>\n</td>\n<td><a href=\"/wiki/Alibaba_Cloud\" title=\"Alibaba Cloud\">Alibaba Cloud</a>\n</td>\n<td>72<sup class=\"reference\" id=\"cite_ref-240\"><a href=\"#cite_note-240\"><span class=\"cite-bracket\">[</span>234<span class=\"cite-bracket\">]</span></a></sup>\n</td>\n<td>3T Tokens\n</td>\n<td>\n</td>\n<td>\n</td>\n<td>Multiple sizes, the smallest being 0.5B.\n</td></tr>\n<tr>\n<td>Nemotron-4\n</td>\n<td>June 2024\n</td>\n<td><a href=\"/wiki/Nvidia\" title=\"Nvidia\">Nvidia</a>\n</td>\n<td><span data-sort-value=\"34000000000 !\">340</span>\n</td>\n<td>9T Tokens\n</td>\n<td><span data-sort-value=\"200000 !\">200,000</span>\n</td>\n<td class=\"table-yes\" style=\"background:#9EFF9E;color:black;vertical-align:middle;text-align:center;\">NVIDIA Open Model License\n</td>\n<td>Trained for 1 epoch. Trained on 6144 H100 GPUs between December 2023 and May 2024.<sup class=\"reference\" id=\"cite_ref-241\"><a href=\"#cite_note-241\"><span class=\"cite-bracket\">[</span>235<span class=\"cite-bracket\">]</span></a></sup><sup class=\"reference\" id=\"cite_ref-242\"><a href=\"#cite_note-242\"><span class=\"cite-bracket\">[</span>236<span class=\"cite-bracket\">]</span></a></sup>\n</td></tr>\n<tr>\n<td>Llama 3.1\n</td>\n<td>July 2024\n</td>\n<td>Meta AI\n</td>\n<td>405\n</td>\n<td>15.6T tokens\n</td>\n<td><span data-sort-value=\"440000 !\">440,000</span>\n</td>\n<td class=\"table-partial\" style=\"background: #FFB; color:black; vertical-align: middle; text-align: center;\">Llama 3 license\n</td>\n<td>405B version took 31 million hours on <a href=\"/wiki/Hopper_(microarchitecture)\" title=\"Hopper (microarchitecture)\">H100</a>-80GB, at 3.8E25 FLOPs.<sup class=\"reference\" id=\"cite_ref-243\"><a href=\"#cite_note-243\"><span class=\"cite-bracket\">[</span>237<span class=\"cite-bracket\">]</span></a></sup><sup class=\"reference\" id=\"cite_ref-244\"><a href=\"#cite_note-244\"><span class=\"cite-bracket\">[</span>238<span class=\"cite-bracket\">]</span></a></sup>\n</td></tr></tbody></table>\n<div class=\"mw-heading mw-heading2\"><h2 id=\"See_also\">See also</h2><span class=\"mw-editsection\"><span class=\"mw-editsection-bracket\">[</span><a href=\"/w/index.php?title=Large_language_model&amp;action=edit&amp;section=36\" title=\"Edit section: See also\"><span>edit</span></a><span class=\"mw-editsection-bracket\">]</span></span></div>\n<ul><li><a class=\"mw-redirect\" href=\"/wiki/Foundation_models\" title=\"Foundation models\">Foundation models</a></li></ul>\n<div class=\"mw-heading mw-heading2\"><h2 id=\"Notes\">Notes</h2><span class=\"mw-editsection\"><span class=\"mw-editsection-bracket\">[</span><a href=\"/w/index.php?title=Large_language_model&amp;action=edit&amp;section=37\" title=\"Edit section: Notes\"><span>edit</span></a><span class=\"mw-editsection-bracket\">]</span></span></div>\n<div class=\"reflist reflist-lower-alpha\">\n<div class=\"mw-references-wrap\"><ol class=\"references\">\n<li id=\"cite_note-146\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-146\">^</a></b></span> <span class=\"reference-text\">This is the date that documentation describing the model's architecture was first released.</span>\n</li>\n<li id=\"cite_note-147\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-147\">^</a></b></span> <span class=\"reference-text\">In many cases, researchers release or report on multiple versions of a model having different sizes. In these cases, the size of the largest model is listed here.</span>\n</li>\n<li id=\"cite_note-148\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-148\">^</a></b></span> <span class=\"reference-text\">This is the license of the pre-trained model weights. In almost all cases the training code itself is open-source or can be easily replicated.</span>\n</li>\n<li id=\"cite_note-191\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-191\">^</a></b></span> <span class=\"reference-text\">The smaller models including 66B are publicly available, while the 175B model is available on request.</span>\n</li>\n<li id=\"cite_note-204\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-204\">^</a></b></span> <span class=\"reference-text\">Facebook's license and distribution scheme restricted access to approved researchers, but the model weights were leaked and became widely available.</span>\n</li>\n<li id=\"cite_note-206\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-206\">^</a></b></span> <span class=\"reference-text\">As stated in Technical report: \"Given both the competitive landscape and the safety implications of large-scale models like GPT-4, this report contains no further details about the architecture (including model size), hardware, training compute, dataset construction, training method ...\"<sup class=\"reference\" id=\"cite_ref-GPT4Tech_205-0\"><a href=\"#cite_note-GPT4Tech-205\"><span class=\"cite-bracket\">[</span>200<span class=\"cite-bracket\">]</span></a></sup> </span>\n</li>\n</ol></div></div>\n<div class=\"mw-heading mw-heading2\"><h2 id=\"References\">References</h2><span class=\"mw-editsection\"><span class=\"mw-editsection-bracket\">[</span><a href=\"/w/index.php?title=Large_language_model&amp;action=edit&amp;section=38\" title=\"Edit section: References\"><span>edit</span></a><span class=\"mw-editsection-bracket\">]</span></span></div>\n<link href=\"mw-data:TemplateStyles:r1239543626\" rel=\"mw-deduplicated-inline-style\"/><div class=\"reflist\">\n<div class=\"mw-references-wrap mw-references-columns\"><ol class=\"references\">\n<li id=\"cite_note-:7-1\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-:7_1-0\">^</a></b></span> <span class=\"reference-text\"><cite class=\"citation web cs1\"><a class=\"external text\" href=\"https://openai.com/blog/better-language-models/\" rel=\"nofollow\">\"Better Language Models and Their Implications\"</a>. <i>OpenAI</i>. 2019-02-14. <a class=\"external text\" href=\"https://web.archive.org/web/20201219132206/https://openai.com/blog/better-language-models/\" rel=\"nofollow\">Archived</a> from the original on 2020-12-19<span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">2019-08-25</span></span>.</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=OpenAI&amp;rft.atitle=Better+Language+Models+and+Their+Implications&amp;rft.date=2019-02-14&amp;rft_id=https%3A%2F%2Fopenai.com%2Fblog%2Fbetter-language-models%2F&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-few-shot-learners-2\"><span class=\"mw-cite-backlink\">^ <a href=\"#cite_ref-few-shot-learners_2-0\"><sup><i><b>a</b></i></sup></a> <a href=\"#cite_ref-few-shot-learners_2-1\"><sup><i><b>b</b></i></sup></a> <a href=\"#cite_ref-few-shot-learners_2-2\"><sup><i><b>c</b></i></sup></a></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation journal cs1\" id=\"CITEREFBrownMannRyderSubbiah2020\">Brown, Tom B.; Mann, Benjamin; Ryder, Nick; Subbiah, Melanie; Kaplan, Jared; Dhariwal, Prafulla; Neelakantan, Arvind; Shyam, Pranav; Sastry, Girish; Askell, Amanda; Agarwal, Sandhini; Herbert-Voss, Ariel; Krueger, Gretchen; Henighan, Tom; Child, Rewon; Ramesh, Aditya; Ziegler, Daniel M.; Wu, Jeffrey; Winter, Clemens; Hesse, Christopher; Chen, Mark; Sigler, Eric; Litwin, Mateusz; Gray, Scott; Chess, Benjamin; Clark, Jack; Berner, Christopher; McCandlish, Sam; Radford, Alec; Sutskever, Ilya; Amodei, Dario (Dec 2020). Larochelle, H.; Ranzato, M.; Hadsell, R.; Balcan, M.F.; Lin, H. (eds.). <a class=\"external text\" href=\"https://proceedings.neurips.cc/paper/2020/file/1457c0d6bfcb4967418bfb8ac142f64a-Paper.pdf\" rel=\"nofollow\">\"Language Models are Few-Shot Learners\"</a> <span class=\"cs1-format\">(PDF)</span>. <i>Advances in Neural Information Processing Systems</i>. <b>33</b>. Curran Associates, Inc.: 1877–1901. <a class=\"external text\" href=\"https://web.archive.org/web/20231117204007/https://proceedings.neurips.cc/paper/2020/file/1457c0d6bfcb4967418bfb8ac142f64a-Paper.pdf\" rel=\"nofollow\">Archived</a> <span class=\"cs1-format\">(PDF)</span> from the original on 2023-11-17<span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">2023-03-14</span></span>.</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=Advances+in+Neural+Information+Processing+Systems&amp;rft.atitle=Language+Models+are+Few-Shot+Learners&amp;rft.volume=33&amp;rft.pages=1877-1901&amp;rft.date=2020-12&amp;rft.aulast=Brown&amp;rft.aufirst=Tom+B.&amp;rft.au=Mann%2C+Benjamin&amp;rft.au=Ryder%2C+Nick&amp;rft.au=Subbiah%2C+Melanie&amp;rft.au=Kaplan%2C+Jared&amp;rft.au=Dhariwal%2C+Prafulla&amp;rft.au=Neelakantan%2C+Arvind&amp;rft.au=Shyam%2C+Pranav&amp;rft.au=Sastry%2C+Girish&amp;rft.au=Askell%2C+Amanda&amp;rft.au=Agarwal%2C+Sandhini&amp;rft.au=Herbert-Voss%2C+Ariel&amp;rft.au=Krueger%2C+Gretchen&amp;rft.au=Henighan%2C+Tom&amp;rft.au=Child%2C+Rewon&amp;rft.au=Ramesh%2C+Aditya&amp;rft.au=Ziegler%2C+Daniel+M.&amp;rft.au=Wu%2C+Jeffrey&amp;rft.au=Winter%2C+Clemens&amp;rft.au=Hesse%2C+Christopher&amp;rft.au=Chen%2C+Mark&amp;rft.au=Sigler%2C+Eric&amp;rft.au=Litwin%2C+Mateusz&amp;rft.au=Gray%2C+Scott&amp;rft.au=Chess%2C+Benjamin&amp;rft.au=Clark%2C+Jack&amp;rft.au=Berner%2C+Christopher&amp;rft.au=McCandlish%2C+Sam&amp;rft.au=Radford%2C+Alec&amp;rft.au=Sutskever%2C+Ilya&amp;rft.au=Amodei%2C+Dario&amp;rft_id=https%3A%2F%2Fproceedings.neurips.cc%2Fpaper%2F2020%2Ffile%2F1457c0d6bfcb4967418bfb8ac142f64a-Paper.pdf&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-3\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-3\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation conference cs1\" id=\"CITEREFFathallahDasDe_GiorgisPoltronieri2024\">Fathallah, Nadeen; Das, Arunav; De Giorgis, Stefano; Poltronieri, Andrea; Haase, Peter; Kovriguina, Liubov (2024-05-26). <a class=\"external text\" href=\"https://2024.eswc-conferences.org/wp-content/uploads/2024/05/77770034.pdf\" rel=\"nofollow\"><i>NeOn-GPT: A Large Language Model-Powered Pipeline for Ontology Learning</i></a> <span class=\"cs1-format\">(PDF)</span>. Extended Semantic Web Conference 2024. Hersonissos, Greece.</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=conference&amp;rft.btitle=NeOn-GPT%3A+A+Large+Language+Model-Powered+Pipeline+for+Ontology+Learning&amp;rft.place=Hersonissos%2C+Greece&amp;rft.date=2024-05-26&amp;rft.aulast=Fathallah&amp;rft.aufirst=Nadeen&amp;rft.au=Das%2C+Arunav&amp;rft.au=De+Giorgis%2C+Stefano&amp;rft.au=Poltronieri%2C+Andrea&amp;rft.au=Haase%2C+Peter&amp;rft.au=Kovriguina%2C+Liubov&amp;rft_id=https%3A%2F%2F2024.eswc-conferences.org%2Fwp-content%2Fuploads%2F2024%2F05%2F77770034.pdf&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-Manning-2022-4\"><span class=\"mw-cite-backlink\">^ <a href=\"#cite_ref-Manning-2022_4-0\"><sup><i><b>a</b></i></sup></a> <a href=\"#cite_ref-Manning-2022_4-1\"><sup><i><b>b</b></i></sup></a></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation journal cs1\" id=\"CITEREFManning2022\"><a href=\"/wiki/Christopher_D._Manning\" title=\"Christopher D. Manning\">Manning, Christopher D.</a> (2022). <a class=\"external text\" href=\"https://www.amacad.org/publication/human-language-understanding-reasoning\" rel=\"nofollow\">\"Human Language Understanding &amp; Reasoning\"</a>. <i>Daedalus</i>. <b>151</b> (2): 127–138. <a class=\"mw-redirect\" href=\"/wiki/Doi_(identifier)\" title=\"Doi (identifier)\">doi</a>:<span class=\"id-lock-free\" title=\"Freely accessible\"><a class=\"external text\" href=\"https://doi.org/10.1162%2Fdaed_a_01905\" rel=\"nofollow\">10.1162/daed_a_01905</a></span>. <a class=\"mw-redirect\" href=\"/wiki/S2CID_(identifier)\" title=\"S2CID (identifier)\">S2CID</a> <a class=\"external text\" href=\"https://api.semanticscholar.org/CorpusID:248377870\" rel=\"nofollow\">248377870</a>. <a class=\"external text\" href=\"https://web.archive.org/web/20231117205531/https://www.amacad.org/publication/human-language-understanding-reasoning\" rel=\"nofollow\">Archived</a> from the original on 2023-11-17<span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">2023-03-09</span></span>.</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=Daedalus&amp;rft.atitle=Human+Language+Understanding+%26+Reasoning&amp;rft.volume=151&amp;rft.issue=2&amp;rft.pages=127-138&amp;rft.date=2022&amp;rft_id=info%3Adoi%2F10.1162%2Fdaed_a_01905&amp;rft_id=https%3A%2F%2Fapi.semanticscholar.org%2FCorpusID%3A248377870%23id-name%3DS2CID&amp;rft.aulast=Manning&amp;rft.aufirst=Christopher+D.&amp;rft_id=https%3A%2F%2Fwww.amacad.org%2Fpublication%2Fhuman-language-understanding-reasoning&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-5\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-5\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation cs2\" id=\"CITEREFGoodman2001\">Goodman, Joshua (2001-08-09), <i>A Bit of Progress in Language Modeling</i>, <a class=\"mw-redirect\" href=\"/wiki/ArXiv_(identifier)\" title=\"ArXiv (identifier)\">arXiv</a>:<span class=\"id-lock-free\" title=\"Freely accessible\"><a class=\"external text\" href=\"https://arxiv.org/abs/cs/0108005\" rel=\"nofollow\">cs/0108005</a></span>, <a class=\"mw-redirect\" href=\"/wiki/Bibcode_(identifier)\" title=\"Bibcode (identifier)\">Bibcode</a>:<a class=\"external text\" href=\"https://ui.adsabs.harvard.edu/abs/2001cs........8005G\" rel=\"nofollow\">2001cs........8005G</a></cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=book&amp;rft.btitle=A+Bit+of+Progress+in+Language+Modeling&amp;rft.date=2001-08-09&amp;rft_id=info%3Aarxiv%2Fcs%2F0108005&amp;rft_id=info%3Abibcode%2F2001cs........8005G&amp;rft.aulast=Goodman&amp;rft.aufirst=Joshua&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-6\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-6\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation journal cs1\" id=\"CITEREFKilgarriffGrefenstette2003\">Kilgarriff, Adam; Grefenstette, Gregory (September 2003). <a class=\"external text\" href=\"https://direct.mit.edu/coli/article/29/3/333-347/1816\" rel=\"nofollow\">\"Introduction to the Special Issue on the Web as Corpus\"</a>. <i>Computational Linguistics</i>. <b>29</b> (3): 333–347. <a class=\"mw-redirect\" href=\"/wiki/Doi_(identifier)\" title=\"Doi (identifier)\">doi</a>:<a class=\"external text\" href=\"https://doi.org/10.1162%2F089120103322711569\" rel=\"nofollow\">10.1162/089120103322711569</a>. <a class=\"mw-redirect\" href=\"/wiki/ISSN_(identifier)\" title=\"ISSN (identifier)\">ISSN</a> <a class=\"external text\" href=\"https://search.worldcat.org/issn/0891-2017\" rel=\"nofollow\">0891-2017</a>.</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=Computational+Linguistics&amp;rft.atitle=Introduction+to+the+Special+Issue+on+the+Web+as+Corpus&amp;rft.volume=29&amp;rft.issue=3&amp;rft.pages=333-347&amp;rft.date=2003-09&amp;rft_id=info%3Adoi%2F10.1162%2F089120103322711569&amp;rft.issn=0891-2017&amp;rft.aulast=Kilgarriff&amp;rft.aufirst=Adam&amp;rft.au=Grefenstette%2C+Gregory&amp;rft_id=https%3A%2F%2Fdirect.mit.edu%2Fcoli%2Farticle%2F29%2F3%2F333-347%2F1816&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-7\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-7\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation journal cs1\" id=\"CITEREFBankoBrill2001\">Banko, Michele; Brill, Eric (2001). <a class=\"external text\" href=\"https://dx.doi.org/10.3115/1073012.1073017\" rel=\"nofollow\">\"Scaling to very very large corpora for natural language disambiguation\"</a>. <i>Proceedings of the 39th Annual Meeting on Association for Computational Linguistics - ACL '01</i>. Morristown, NJ, USA: Association for Computational Linguistics: 26–33. <a class=\"mw-redirect\" href=\"/wiki/Doi_(identifier)\" title=\"Doi (identifier)\">doi</a>:<a class=\"external text\" href=\"https://doi.org/10.3115%2F1073012.1073017\" rel=\"nofollow\">10.3115/1073012.1073017</a>.</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=Proceedings+of+the+39th+Annual+Meeting+on+Association+for+Computational+Linguistics+-+ACL+%2701&amp;rft.atitle=Scaling+to+very+very+large+corpora+for+natural+language+disambiguation&amp;rft.pages=26-33&amp;rft.date=2001&amp;rft_id=info%3Adoi%2F10.3115%2F1073012.1073017&amp;rft.aulast=Banko&amp;rft.aufirst=Michele&amp;rft.au=Brill%2C+Eric&amp;rft_id=http%3A%2F%2Fdx.doi.org%2F10.3115%2F1073012.1073017&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-8\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-8\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation journal cs1\" id=\"CITEREFResnikSmith2003\">Resnik, Philip; Smith, Noah A. (September 2003). <a class=\"external text\" href=\"https://direct.mit.edu/coli/article/29/3/349-380/1809\" rel=\"nofollow\">\"The Web as a Parallel Corpus\"</a>. <i>Computational Linguistics</i>. <b>29</b> (3): 349–380. <a class=\"mw-redirect\" href=\"/wiki/Doi_(identifier)\" title=\"Doi (identifier)\">doi</a>:<span class=\"id-lock-free\" title=\"Freely accessible\"><a class=\"external text\" href=\"https://doi.org/10.1162%2F089120103322711578\" rel=\"nofollow\">10.1162/089120103322711578</a></span>. <a class=\"mw-redirect\" href=\"/wiki/ISSN_(identifier)\" title=\"ISSN (identifier)\">ISSN</a> <a class=\"external text\" href=\"https://search.worldcat.org/issn/0891-2017\" rel=\"nofollow\">0891-2017</a>. <a class=\"external text\" href=\"https://web.archive.org/web/20240607172811/https://direct.mit.edu/coli/article/29/3/349-380/1809\" rel=\"nofollow\">Archived</a> from the original on 2024-06-07<span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">2024-06-07</span></span>.</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=Computational+Linguistics&amp;rft.atitle=The+Web+as+a+Parallel+Corpus&amp;rft.volume=29&amp;rft.issue=3&amp;rft.pages=349-380&amp;rft.date=2003-09&amp;rft_id=info%3Adoi%2F10.1162%2F089120103322711578&amp;rft.issn=0891-2017&amp;rft.aulast=Resnik&amp;rft.aufirst=Philip&amp;rft.au=Smith%2C+Noah+A.&amp;rft_id=https%3A%2F%2Fdirect.mit.edu%2Fcoli%2Farticle%2F29%2F3%2F349-380%2F1809&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-9\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-9\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation journal cs1\" id=\"CITEREFHalevyNorvigPereira2009\">Halevy, Alon; Norvig, Peter; Pereira, Fernando (March 2009). <a class=\"external text\" href=\"https://ieeexplore.ieee.org/document/4804817\" rel=\"nofollow\">\"The Unreasonable Effectiveness of Data\"</a>. <i>IEEE Intelligent Systems</i>. <b>24</b> (2): 8–12. <a class=\"mw-redirect\" href=\"/wiki/Doi_(identifier)\" title=\"Doi (identifier)\">doi</a>:<a class=\"external text\" href=\"https://doi.org/10.1109%2FMIS.2009.36\" rel=\"nofollow\">10.1109/MIS.2009.36</a>. <a class=\"mw-redirect\" href=\"/wiki/ISSN_(identifier)\" title=\"ISSN (identifier)\">ISSN</a> <a class=\"external text\" href=\"https://search.worldcat.org/issn/1541-1672\" rel=\"nofollow\">1541-1672</a>.</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=IEEE+Intelligent+Systems&amp;rft.atitle=The+Unreasonable+Effectiveness+of+Data&amp;rft.volume=24&amp;rft.issue=2&amp;rft.pages=8-12&amp;rft.date=2009-03&amp;rft_id=info%3Adoi%2F10.1109%2FMIS.2009.36&amp;rft.issn=1541-1672&amp;rft.aulast=Halevy&amp;rft.aufirst=Alon&amp;rft.au=Norvig%2C+Peter&amp;rft.au=Pereira%2C+Fernando&amp;rft_id=https%3A%2F%2Fieeexplore.ieee.org%2Fdocument%2F4804817&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-10\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-10\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation journal cs1\" id=\"CITEREFChenLiBaiYang2021\">Chen, Leiyu; Li, Shaobo; Bai, Qiang; Yang, Jing; Jiang, Sanlong; Miao, Yanming (2021). <a class=\"external text\" href=\"https://doi.org/10.3390%2Frs13224712\" rel=\"nofollow\">\"Review of Image Classification Algorithms Based on Convolutional Neural Networks\"</a>. <i>Remote Sensing</i>. <b>13</b> (22): 4712. <a class=\"mw-redirect\" href=\"/wiki/Bibcode_(identifier)\" title=\"Bibcode (identifier)\">Bibcode</a>:<a class=\"external text\" href=\"https://ui.adsabs.harvard.edu/abs/2021RemS...13.4712C\" rel=\"nofollow\">2021RemS...13.4712C</a>. <a class=\"mw-redirect\" href=\"/wiki/Doi_(identifier)\" title=\"Doi (identifier)\">doi</a>:<span class=\"id-lock-free\" title=\"Freely accessible\"><a class=\"external text\" href=\"https://doi.org/10.3390%2Frs13224712\" rel=\"nofollow\">10.3390/rs13224712</a></span>.</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=Remote+Sensing&amp;rft.atitle=Review+of+Image+Classification+Algorithms+Based+on+Convolutional+Neural+Networks&amp;rft.volume=13&amp;rft.issue=22&amp;rft.pages=4712&amp;rft.date=2021&amp;rft_id=info%3Adoi%2F10.3390%2Frs13224712&amp;rft_id=info%3Abibcode%2F2021RemS...13.4712C&amp;rft.aulast=Chen&amp;rft.aufirst=Leiyu&amp;rft.au=Li%2C+Shaobo&amp;rft.au=Bai%2C+Qiang&amp;rft.au=Yang%2C+Jing&amp;rft.au=Jiang%2C+Sanlong&amp;rft.au=Miao%2C+Yanming&amp;rft_id=https%3A%2F%2Fdoi.org%2F10.3390%252Frs13224712&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-11\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-11\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation journal cs1\" id=\"CITEREFVaswaniShazeerParmarUszkoreit2017\"><a href=\"/wiki/Ashish_Vaswani\" title=\"Ashish Vaswani\">Vaswani, Ashish</a>; Shazeer, Noam; Parmar, Niki; Uszkoreit, Jakob; Jones, Llion; <a href=\"/wiki/Aidan_Gomez\" title=\"Aidan Gomez\">Gomez, Aidan N</a>; Kaiser, Łukasz; Polosukhin, Illia (2017). <a class=\"external text\" href=\"https://proceedings.neurips.cc/paper/2017/file/3f5ee243547dee91fbd053c1c4a845aa-Paper.pdf\" rel=\"nofollow\">\"Attention is All you Need\"</a> <span class=\"cs1-format\">(PDF)</span>. <i>Advances in Neural Information Processing Systems</i>. <b>30</b>. Curran Associates, Inc. <a class=\"external text\" href=\"https://web.archive.org/web/20240221141113/https://proceedings.neurips.cc/paper/2017/file/3f5ee243547dee91fbd053c1c4a845aa-Paper.pdf\" rel=\"nofollow\">Archived</a> <span class=\"cs1-format\">(PDF)</span> from the original on 2024-02-21<span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">2024-01-21</span></span>.</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=Advances+in+Neural+Information+Processing+Systems&amp;rft.atitle=Attention+is+All+you+Need&amp;rft.volume=30&amp;rft.date=2017&amp;rft.aulast=Vaswani&amp;rft.aufirst=Ashish&amp;rft.au=Shazeer%2C+Noam&amp;rft.au=Parmar%2C+Niki&amp;rft.au=Uszkoreit%2C+Jakob&amp;rft.au=Jones%2C+Llion&amp;rft.au=Gomez%2C+Aidan+N&amp;rft.au=Kaiser%2C+%C5%81ukasz&amp;rft.au=Polosukhin%2C+Illia&amp;rft_id=https%3A%2F%2Fproceedings.neurips.cc%2Fpaper%2F2017%2Ffile%2F3f5ee243547dee91fbd053c1c4a845aa-Paper.pdf&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-12\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-12\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation arxiv cs1\" id=\"CITEREFBahdanauChoBengio2014\">Bahdanau, Dzmitry; Cho, Kyunghyun; Bengio, Yoshua (2014). \"Neural Machine Translation by Jointly Learning to Align and Translate\". <a class=\"mw-redirect\" href=\"/wiki/ArXiv_(identifier)\" title=\"ArXiv (identifier)\">arXiv</a>:<span class=\"id-lock-free\" title=\"Freely accessible\"><a class=\"external text\" href=\"https://arxiv.org/abs/1409.0473\" rel=\"nofollow\">1409.0473</a></span> [<a class=\"external text\" href=\"https://arxiv.org/archive/cs.CL\" rel=\"nofollow\">cs.CL</a>].</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=preprint&amp;rft.jtitle=arXiv&amp;rft.atitle=Neural+Machine+Translation+by+Jointly+Learning+to+Align+and+Translate&amp;rft.date=2014&amp;rft_id=info%3Aarxiv%2F1409.0473&amp;rft.aulast=Bahdanau&amp;rft.aufirst=Dzmitry&amp;rft.au=Cho%2C+Kyunghyun&amp;rft.au=Bengio%2C+Yoshua&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-13\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-13\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation journal cs1\" id=\"CITEREFRogersKovalevaRumshisky2020\">Rogers, Anna; Kovaleva, Olga; Rumshisky, Anna (2020). <a class=\"external text\" href=\"https://aclanthology.org/2020.tacl-1.54\" rel=\"nofollow\">\"A Primer in BERTology: What We Know About How BERT Works\"</a>. <i>Transactions of the Association for Computational Linguistics</i>. <b>8</b>: 842–866. <a class=\"mw-redirect\" href=\"/wiki/ArXiv_(identifier)\" title=\"ArXiv (identifier)\">arXiv</a>:<span class=\"id-lock-free\" title=\"Freely accessible\"><a class=\"external text\" href=\"https://arxiv.org/abs/2002.12327\" rel=\"nofollow\">2002.12327</a></span>. <a class=\"mw-redirect\" href=\"/wiki/Doi_(identifier)\" title=\"Doi (identifier)\">doi</a>:<a class=\"external text\" href=\"https://doi.org/10.1162%2Ftacl_a_00349\" rel=\"nofollow\">10.1162/tacl_a_00349</a>. <a class=\"mw-redirect\" href=\"/wiki/S2CID_(identifier)\" title=\"S2CID (identifier)\">S2CID</a> <a class=\"external text\" href=\"https://api.semanticscholar.org/CorpusID:211532403\" rel=\"nofollow\">211532403</a>. <a class=\"external text\" href=\"https://web.archive.org/web/20220403103310/https://aclanthology.org/2020.tacl-1.54/\" rel=\"nofollow\">Archived</a> from the original on 2022-04-03<span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">2024-01-21</span></span>.</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=Transactions+of+the+Association+for+Computational+Linguistics&amp;rft.atitle=A+Primer+in+BERTology%3A+What+We+Know+About+How+BERT+Works&amp;rft.volume=8&amp;rft.pages=842-866&amp;rft.date=2020&amp;rft_id=info%3Aarxiv%2F2002.12327&amp;rft_id=https%3A%2F%2Fapi.semanticscholar.org%2FCorpusID%3A211532403%23id-name%3DS2CID&amp;rft_id=info%3Adoi%2F10.1162%2Ftacl_a_00349&amp;rft.aulast=Rogers&amp;rft.aufirst=Anna&amp;rft.au=Kovaleva%2C+Olga&amp;rft.au=Rumshisky%2C+Anna&amp;rft_id=https%3A%2F%2Faclanthology.org%2F2020.tacl-1.54&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-14\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-14\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation journal cs1\" id=\"CITEREFMovvaBalachandarPengAgostini2024\">Movva, Rajiv; Balachandar, Sidhika; Peng, Kenny; Agostini, Gabriel; Garg, Nikhil; Pierson, Emma (2024). <a class=\"external text\" href=\"https://aclanthology.org/2024.naacl-long.67\" rel=\"nofollow\">\"Topics, Authors, and Institutions in Large Language Model Research: Trends from 17K arXiv Papers\"</a>. <i>Proceedings of the 2024 Conference of the North American Chapter of the Association for Computational Linguistics: Human Language Technologies (Volume 1: Long Papers)</i>: 1223–1243. <a class=\"mw-redirect\" href=\"/wiki/Doi_(identifier)\" title=\"Doi (identifier)\">doi</a>:<a class=\"external text\" href=\"https://doi.org/10.18653%2Fv1%2F2024.naacl-long.67\" rel=\"nofollow\">10.18653/v1/2024.naacl-long.67</a><span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">2024-12-08</span></span>.</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=Proceedings+of+the+2024+Conference+of+the+North+American+Chapter+of+the+Association+for+Computational+Linguistics%3A+Human+Language+Technologies+%28Volume+1%3A+Long+Papers%29&amp;rft.atitle=Topics%2C+Authors%2C+and+Institutions+in+Large+Language+Model+Research%3A+Trends+from+17K+arXiv+Papers&amp;rft.pages=1223-1243&amp;rft.date=2024&amp;rft_id=info%3Adoi%2F10.18653%2Fv1%2F2024.naacl-long.67&amp;rft.aulast=Movva&amp;rft.aufirst=Rajiv&amp;rft.au=Balachandar%2C+Sidhika&amp;rft.au=Peng%2C+Kenny&amp;rft.au=Agostini%2C+Gabriel&amp;rft.au=Garg%2C+Nikhil&amp;rft.au=Pierson%2C+Emma&amp;rft_id=https%3A%2F%2Faclanthology.org%2F2024.naacl-long.67&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span><span class=\"cs1-maint citation-comment\"><code class=\"cs1-code\">{{<a href=\"/wiki/Template:Cite_journal\" title=\"Template:Cite journal\">cite journal</a>}}</code>:  CS1 maint: url-status (<a href=\"/wiki/Category:CS1_maint:_url-status\" title=\"Category:CS1 maint: url-status\">link</a>)</span></span>\n</li>\n<li id=\"cite_note-15\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-15\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation web cs1\" id=\"CITEREFHern2019\">Hern, Alex (14 February 2019). <a class=\"external text\" href=\"https://www.theguardian.com/technology/2019/feb/14/elon-musk-backed-ai-writes-convincing-news-fiction\" rel=\"nofollow\">\"New AI fake text generator may be too dangerous to release, say creators\"</a>. <i><a href=\"/wiki/The_Guardian\" title=\"The Guardian\">The Guardian</a></i>. <a class=\"external text\" href=\"https://web.archive.org/web/20190214173112/https://www.theguardian.com/technology/2019/feb/14/elon-musk-backed-ai-writes-convincing-news-fiction\" rel=\"nofollow\">Archived</a> from the original on 14 February 2019<span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">20 January</span> 2024</span>.</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=The+Guardian&amp;rft.atitle=New+AI+fake+text+generator+may+be+too+dangerous+to+release%2C+say+creators&amp;rft.date=2019-02-14&amp;rft.aulast=Hern&amp;rft.aufirst=Alex&amp;rft_id=https%3A%2F%2Fwww.theguardian.com%2Ftechnology%2F2019%2Ffeb%2F14%2Felon-musk-backed-ai-writes-convincing-news-fiction&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-16\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-16\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation web cs1\"><a class=\"external text\" href=\"https://www.euronews.com/next/2023/11/30/chatgpt-a-year-on-3-ways-the-ai-chatbot-has-completely-changed-the-world-in-12-months\" rel=\"nofollow\">\"ChatGPT a year on: 3 ways the AI chatbot has completely changed the world in 12 months\"</a>. <a href=\"/wiki/Euronews\" title=\"Euronews\">Euronews</a>. November 30, 2023. <a class=\"external text\" href=\"https://web.archive.org/web/20240114025250/https://www.euronews.com/next/2023/11/30/chatgpt-a-year-on-3-ways-the-ai-chatbot-has-completely-changed-the-world-in-12-months\" rel=\"nofollow\">Archived</a> from the original on January 14, 2024<span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">January 20,</span> 2024</span>.</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=ChatGPT+a+year+on%3A+3+ways+the+AI+chatbot+has+completely+changed+the+world+in+12+months&amp;rft.pub=Euronews&amp;rft.date=2023-11-30&amp;rft_id=https%3A%2F%2Fwww.euronews.com%2Fnext%2F2023%2F11%2F30%2Fchatgpt-a-year-on-3-ways-the-ai-chatbot-has-completely-changed-the-world-in-12-months&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-17\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-17\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation web cs1\" id=\"CITEREFHeaven2023\">Heaven, Will (March 14, 2023). <a class=\"external text\" href=\"https://www.technologyreview.com/2023/03/14/1069823/gpt-4-is-bigger-and-better-chatgpt-openai/\" rel=\"nofollow\">\"GPT-4 is bigger and better than ChatGPT—but OpenAI won't say why\"</a>. <a href=\"/wiki/MIT_Technology_Review\" title=\"MIT Technology Review\">MIT Technology Review</a>. <a class=\"external text\" href=\"https://web.archive.org/web/20230317224201/https://www.technologyreview.com/2023/03/14/1069823/gpt-4-is-bigger-and-better-chatgpt-openai/\" rel=\"nofollow\">Archived</a> from the original on March 17, 2023<span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">January 20,</span> 2024</span>.</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=GPT-4+is+bigger+and+better+than+ChatGPT%E2%80%94but+OpenAI+won%27t+say+why&amp;rft.pub=MIT+Technology+Review&amp;rft.date=2023-03-14&amp;rft.aulast=Heaven&amp;rft.aufirst=Will&amp;rft_id=https%3A%2F%2Fwww.technologyreview.com%2F2023%2F03%2F14%2F1069823%2Fgpt-4-is-bigger-and-better-chatgpt-openai%2F&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-18\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-18\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation journal cs1\" id=\"CITEREFMovvaBalachandarPengAgostini2024\">Movva, Rajiv; Balachandar, Sidhika; Peng, Kenny; Agostini, Gabriel; Garg, Nikhil; Pierson, Emma (2024). <a class=\"external text\" href=\"https://aclanthology.org/2024.naacl-long.67\" rel=\"nofollow\">\"Topics, Authors, and Institutions in Large Language Model Research: Trends from 17K arXiv Papers\"</a>. <i>Proceedings of the 2024 Conference of the North American Chapter of the Association for Computational Linguistics: Human Language Technologies (Volume 1: Long Papers)</i>: 1223–1243. <a class=\"mw-redirect\" href=\"/wiki/Doi_(identifier)\" title=\"Doi (identifier)\">doi</a>:<a class=\"external text\" href=\"https://doi.org/10.18653%2Fv1%2F2024.naacl-long.67\" rel=\"nofollow\">10.18653/v1/2024.naacl-long.67</a><span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">2024-12-08</span></span>.</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=Proceedings+of+the+2024+Conference+of+the+North+American+Chapter+of+the+Association+for+Computational+Linguistics%3A+Human+Language+Technologies+%28Volume+1%3A+Long+Papers%29&amp;rft.atitle=Topics%2C+Authors%2C+and+Institutions+in+Large+Language+Model+Research%3A+Trends+from+17K+arXiv+Papers&amp;rft.pages=1223-1243&amp;rft.date=2024&amp;rft_id=info%3Adoi%2F10.18653%2Fv1%2F2024.naacl-long.67&amp;rft.aulast=Movva&amp;rft.aufirst=Rajiv&amp;rft.au=Balachandar%2C+Sidhika&amp;rft.au=Peng%2C+Kenny&amp;rft.au=Agostini%2C+Gabriel&amp;rft.au=Garg%2C+Nikhil&amp;rft.au=Pierson%2C+Emma&amp;rft_id=https%3A%2F%2Faclanthology.org%2F2024.naacl-long.67&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span><span class=\"cs1-maint citation-comment\"><code class=\"cs1-code\">{{<a href=\"/wiki/Template:Cite_journal\" title=\"Template:Cite journal\">cite journal</a>}}</code>:  CS1 maint: url-status (<a href=\"/wiki/Category:CS1_maint:_url-status\" title=\"Category:CS1 maint: url-status\">link</a>)</span></span>\n</li>\n<li id=\"cite_note-19\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-19\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation web cs1\"><a class=\"external text\" href=\"https://ourworldindata.org/grapher/artificial-intelligence-parameter-count?time=2017-09-05..latest\" rel=\"nofollow\">\"Parameters in notable artificial intelligence systems\"</a>. <i>ourworldindata.org</i>. November 30, 2023<span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">January 20,</span> 2024</span>.</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=ourworldindata.org&amp;rft.atitle=Parameters+in+notable+artificial+intelligence+systems&amp;rft.date=2023-11-30&amp;rft_id=https%3A%2F%2Fourworldindata.org%2Fgrapher%2Fartificial-intelligence-parameter-count%3Ftime%3D2017-09-05..latest&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-20\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-20\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation web cs1\"><a class=\"external text\" href=\"https://huggingface.co/spaces/lmsys/chatbot-arena-leaderboard\" rel=\"nofollow\">\"LMSYS Chatbot Arena Leaderboard\"</a>. <i>huggingface.co</i>. <a class=\"external text\" href=\"https://web.archive.org/web/20240610162906/https://huggingface.co/spaces/lmsys/chatbot-arena-leaderboard\" rel=\"nofollow\">Archived</a> from the original on June 10, 2024<span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">June 12,</span> 2024</span>.</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=huggingface.co&amp;rft.atitle=LMSYS+Chatbot+Arena+Leaderboard&amp;rft_id=https%3A%2F%2Fhuggingface.co%2Fspaces%2Flmsys%2Fchatbot-arena-leaderboard&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-21\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-21\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation arxiv cs1\" id=\"CITEREFPengAlcaideAnthonyAlbalak2023\">Peng, Bo; et al. (2023). \"RWKV: Reinventing RNNS for the Transformer Era\". <a class=\"mw-redirect\" href=\"/wiki/ArXiv_(identifier)\" title=\"ArXiv (identifier)\">arXiv</a>:<span class=\"id-lock-free\" title=\"Freely accessible\"><a class=\"external text\" href=\"https://arxiv.org/abs/2305.13048\" rel=\"nofollow\">2305.13048</a></span> [<a class=\"external text\" href=\"https://arxiv.org/archive/cs.CL\" rel=\"nofollow\">cs.CL</a>].</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=preprint&amp;rft.jtitle=arXiv&amp;rft.atitle=RWKV%3A+Reinventing+RNNS+for+the+Transformer+Era&amp;rft.date=2023&amp;rft_id=info%3Aarxiv%2F2305.13048&amp;rft.aulast=Peng&amp;rft.aufirst=Bo&amp;rft.au=Alcaide%2C+Eric&amp;rft.au=Anthony%2C+Quentin&amp;rft.au=Albalak%2C+Alon&amp;rft.au=Arcadinho%2C+Samuel&amp;rft.au=Biderman%2C+Stella&amp;rft.au=Cao%2C+Huanqi&amp;rft.au=Cheng%2C+Xin&amp;rft.au=Chung%2C+Michael&amp;rft.au=Grella%2C+Matteo&amp;rft.au=Kranthi+Kiran+GV&amp;rft.au=He%2C+Xuzheng&amp;rft.au=Hou%2C+Haowen&amp;rft.au=Lin%2C+Jiaju&amp;rft.au=Kazienko%2C+Przemyslaw&amp;rft.au=Kocon%2C+Jan&amp;rft.au=Kong%2C+Jiaming&amp;rft.au=Koptyra%2C+Bartlomiej&amp;rft.au=Lau%2C+Hayden&amp;rft.au=Krishna+Sri+Ipsit+Mantri&amp;rft.au=Mom%2C+Ferdinand&amp;rft.au=Saito%2C+Atsushi&amp;rft.au=Song%2C+Guangyu&amp;rft.au=Tang%2C+Xiangru&amp;rft.au=Wang%2C+Bolun&amp;rft.au=Wind%2C+Johan+S.&amp;rft.au=Wozniak%2C+Stanislaw&amp;rft.au=Zhang%2C+Ruichong&amp;rft.au=Zhang%2C+Zhenyuan&amp;rft.au=Zhao%2C+Qihang&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-22\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-22\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation web cs1\" id=\"CITEREFMerritt2022\">Merritt, Rick (2022-03-25). <a class=\"external text\" href=\"https://blogs.nvidia.com/blog/2022/03/25/what-is-a-transformer-model/\" rel=\"nofollow\">\"What Is a Transformer Model?\"</a>. <i>NVIDIA Blog</i>. <a class=\"external text\" href=\"https://web.archive.org/web/20231117203924/https://blogs.nvidia.com/blog/what-is-a-transformer-model/\" rel=\"nofollow\">Archived</a> from the original on 2023-11-17<span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">2023-07-25</span></span>.</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=NVIDIA+Blog&amp;rft.atitle=What+Is+a+Transformer+Model%3F&amp;rft.date=2022-03-25&amp;rft.aulast=Merritt&amp;rft.aufirst=Rick&amp;rft_id=https%3A%2F%2Fblogs.nvidia.com%2Fblog%2F2022%2F03%2F25%2Fwhat-is-a-transformer-model%2F&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-23\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-23\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation cs2\" id=\"CITEREFGuDao2023\">Gu, Albert; Dao, Tri (2023-12-01), <i>Mamba: Linear-Time Sequence Modeling with Selective State Spaces</i>, <a class=\"mw-redirect\" href=\"/wiki/ArXiv_(identifier)\" title=\"ArXiv (identifier)\">arXiv</a>:<span class=\"id-lock-free\" title=\"Freely accessible\"><a class=\"external text\" href=\"https://arxiv.org/abs/2312.00752\" rel=\"nofollow\">2312.00752</a></span></cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=book&amp;rft.btitle=Mamba%3A+Linear-Time+Sequence+Modeling+with+Selective+State+Spaces&amp;rft.date=2023-12-01&amp;rft_id=info%3Aarxiv%2F2312.00752&amp;rft.aulast=Gu&amp;rft.aufirst=Albert&amp;rft.au=Dao%2C+Tri&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-24\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-24\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation cs2\" id=\"CITEREFKaushalMahowald2022\">Kaushal, Ayush; Mahowald, Kyle (2022-06-06), <i>What do tokens know about their characters and how do they know it?</i>, <a class=\"mw-redirect\" href=\"/wiki/ArXiv_(identifier)\" title=\"ArXiv (identifier)\">arXiv</a>:<span class=\"id-lock-free\" title=\"Freely accessible\"><a class=\"external text\" href=\"https://arxiv.org/abs/2206.02608\" rel=\"nofollow\">2206.02608</a></span></cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=book&amp;rft.btitle=What+do+tokens+know+about+their+characters+and+how+do+they+know+it%3F&amp;rft.date=2022-06-06&amp;rft_id=info%3Aarxiv%2F2206.02608&amp;rft.aulast=Kaushal&amp;rft.aufirst=Ayush&amp;rft.au=Mahowald%2C+Kyle&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-25\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-25\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation web cs1\" id=\"CITEREFYennie_Jun2023\">Yennie Jun (2023-05-03). <a class=\"external text\" href=\"https://web.archive.org/web/20230817165705/https://blog.yenniejun.com/p/all-languages-are-not-created-tokenized\" rel=\"nofollow\">\"All languages are NOT created (tokenized) equal\"</a>. <i>Language models cost much more in some languages than others</i>. Archived from <a class=\"external text\" href=\"https://blog.yenniejun.com/p/all-languages-are-not-created-tokenized\" rel=\"nofollow\">the original</a> on 2023-08-17<span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">2023-08-17</span></span>. <q>In other words, to express the same sentiment, some languages require up to 10 times more tokens.</q></cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=Language+models+cost+much+more+in+some+languages+than+others&amp;rft.atitle=All+languages+are+NOT+created+%28tokenized%29+equal&amp;rft.date=2023-05-03&amp;rft.au=Yennie+Jun&amp;rft_id=https%3A%2F%2Fblog.yenniejun.com%2Fp%2Fall-languages-are-not-created-tokenized&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-26\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-26\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation journal cs1\" id=\"CITEREFPetrovMalfaTorrBibi2023\">Petrov, Aleksandar; Malfa, Emanuele La; Torr, Philip; Bibi, Adel (June 23, 2023). <a class=\"external text\" href=\"https://openreview.net/forum?id=Pj4YYuxTq9\" rel=\"nofollow\">\"Language Model Tokenizers Introduce Unfairness Between Languages\"</a>. <i>NeurIPS</i>. <a class=\"mw-redirect\" href=\"/wiki/ArXiv_(identifier)\" title=\"ArXiv (identifier)\">arXiv</a>:<span class=\"id-lock-free\" title=\"Freely accessible\"><a class=\"external text\" href=\"https://arxiv.org/abs/2305.15425\" rel=\"nofollow\">2305.15425</a></span>. <a class=\"external text\" href=\"https://web.archive.org/web/20231215212906/https://openreview.net/forum?id=Pj4YYuxTq9\" rel=\"nofollow\">Archived</a> from the original on December 15, 2023<span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">September 16,</span> 2023</span> – via openreview.net.</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=NeurIPS&amp;rft.atitle=Language+Model+Tokenizers+Introduce+Unfairness+Between+Languages&amp;rft.date=2023-06-23&amp;rft_id=info%3Aarxiv%2F2305.15425&amp;rft.aulast=Petrov&amp;rft.aufirst=Aleksandar&amp;rft.au=Malfa%2C+Emanuele+La&amp;rft.au=Torr%2C+Philip&amp;rft.au=Bibi%2C+Adel&amp;rft_id=https%3A%2F%2Fopenreview.net%2Fforum%3Fid%3DPj4YYuxTq9&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-xbiWb-27\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-xbiWb_27-0\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation web cs1\"><a class=\"external text\" href=\"https://web.archive.org/web/20230423211308/https://platform.openai.com/tokenizer\" rel=\"nofollow\">\"OpenAI API\"</a>. <i>platform.openai.com</i>. Archived from <a class=\"external text\" href=\"https://platform.openai.com/\" rel=\"nofollow\">the original</a> on April 23, 2023<span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">2023-04-30</span></span>.</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=platform.openai.com&amp;rft.atitle=OpenAI+API&amp;rft_id=https%3A%2F%2Fplatform.openai.com%2F&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-2022Book_-28\"><span class=\"mw-cite-backlink\">^ <a href=\"#cite_ref-2022Book_28-0\"><sup><i><b>a</b></i></sup></a> <a href=\"#cite_ref-2022Book_28-1\"><sup><i><b>b</b></i></sup></a></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation book cs1\" id=\"CITEREFPaaßGiesselbach2022\">Paaß, Gerhard; Giesselbach, Sven (2022). <a class=\"external text\" href=\"https://link.springer.com/chapter/10.1007/978-3-031-23190-2_2\" rel=\"nofollow\">\"Pre-trained Language Models\"</a>. <i>Foundation Models for Natural Language Processing</i>. Artificial Intelligence: Foundations, Theory, and Algorithms. pp. 19–78. <a class=\"mw-redirect\" href=\"/wiki/Doi_(identifier)\" title=\"Doi (identifier)\">doi</a>:<a class=\"external text\" href=\"https://doi.org/10.1007%2F978-3-031-23190-2_2\" rel=\"nofollow\">10.1007/978-3-031-23190-2_2</a>. <a class=\"mw-redirect\" href=\"/wiki/ISBN_(identifier)\" title=\"ISBN (identifier)\">ISBN</a> <a href=\"/wiki/Special:BookSources/9783031231902\" title=\"Special:BookSources/9783031231902\"><bdi>9783031231902</bdi></a>. <a class=\"external text\" href=\"https://web.archive.org/web/20230803212329/https://link.springer.com/chapter/10.1007/978-3-031-23190-2_2\" rel=\"nofollow\">Archived</a> from the original on 3 August 2023<span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">3 August</span> 2023</span>.</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=bookitem&amp;rft.atitle=Pre-trained+Language+Models&amp;rft.btitle=Foundation+Models+for+Natural+Language+Processing&amp;rft.series=Artificial+Intelligence%3A+Foundations%2C+Theory%2C+and+Algorithms&amp;rft.pages=19-78&amp;rft.date=2022&amp;rft_id=info%3Adoi%2F10.1007%2F978-3-031-23190-2_2&amp;rft.isbn=9783031231902&amp;rft.aulast=Paa%C3%9F&amp;rft.aufirst=Gerhard&amp;rft.au=Giesselbach%2C+Sven&amp;rft_id=https%3A%2F%2Flink.springer.com%2Fchapter%2F10.1007%2F978-3-031-23190-2_2&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-29\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-29\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation arxiv cs1\" id=\"CITEREFPetrovEmanuele_La_MalfaTorrBibi2023\">Petrov, Aleksandar; Emanuele La Malfa; Torr, Philip H. S.; Bibi, Adel (2023). \"Language Model Tokenizers Introduce Unfairness Between Languages\". <a class=\"mw-redirect\" href=\"/wiki/ArXiv_(identifier)\" title=\"ArXiv (identifier)\">arXiv</a>:<span class=\"id-lock-free\" title=\"Freely accessible\"><a class=\"external text\" href=\"https://arxiv.org/abs/2305.15425\" rel=\"nofollow\">2305.15425</a></span> [<a class=\"external text\" href=\"https://arxiv.org/archive/cs.CL\" rel=\"nofollow\">cs.CL</a>].</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=preprint&amp;rft.jtitle=arXiv&amp;rft.atitle=Language+Model+Tokenizers+Introduce+Unfairness+Between+Languages&amp;rft.date=2023&amp;rft_id=info%3Aarxiv%2F2305.15425&amp;rft.aulast=Petrov&amp;rft.aufirst=Aleksandar&amp;rft.au=Emanuele+La+Malfa&amp;rft.au=Torr%2C+Philip+H.+S.&amp;rft.au=Bibi%2C+Adel&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-30\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-30\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation web cs1\" id=\"CITEREFLundberg2023\">Lundberg, Scott (2023-12-12). <a class=\"external text\" href=\"https://towardsdatascience.com/the-art-of-prompt-design-prompt-boundaries-and-token-healing-3b2448b0be38\" rel=\"nofollow\">\"The Art of Prompt Design: Prompt Boundaries and Token Healing\"</a>. <i>Medium</i><span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">2024-08-05</span></span>.</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=Medium&amp;rft.atitle=The+Art+of+Prompt+Design%3A+Prompt+Boundaries+and+Token+Healing&amp;rft.date=2023-12-12&amp;rft.aulast=Lundberg&amp;rft.aufirst=Scott&amp;rft_id=https%3A%2F%2Ftowardsdatascience.com%2Fthe-art-of-prompt-design-prompt-boundaries-and-token-healing-3b2448b0be38&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-aYNg4-31\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-aYNg4_31-0\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation arxiv cs1\" id=\"CITEREFDodgeSapMarasovićAgnew2021\">Dodge, Jesse; Sap, Maarten; Marasović, Ana; Agnew, William; Ilharco, Gabriel; Groeneveld, Dirk; Mitchell, Margaret; Gardner, Matt (2021). \"Documenting Large Webtext Corpora: A Case Study on the Colossal Clean Crawled Corpus\". <a class=\"mw-redirect\" href=\"/wiki/ArXiv_(identifier)\" title=\"ArXiv (identifier)\">arXiv</a>:<span class=\"id-lock-free\" title=\"Freely accessible\"><a class=\"external text\" href=\"https://arxiv.org/abs/2104.08758\" rel=\"nofollow\">2104.08758</a></span> [<a class=\"external text\" href=\"https://arxiv.org/archive/cs.CL\" rel=\"nofollow\">cs.CL</a>].</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=preprint&amp;rft.jtitle=arXiv&amp;rft.atitle=Documenting+Large+Webtext+Corpora%3A+A+Case+Study+on+the+Colossal+Clean+Crawled+Corpus&amp;rft.date=2021&amp;rft_id=info%3Aarxiv%2F2104.08758&amp;rft.aulast=Dodge&amp;rft.aufirst=Jesse&amp;rft.au=Sap%2C+Maarten&amp;rft.au=Marasovi%C4%87%2C+Ana&amp;rft.au=Agnew%2C+William&amp;rft.au=Ilharco%2C+Gabriel&amp;rft.au=Groeneveld%2C+Dirk&amp;rft.au=Mitchell%2C+Margaret&amp;rft.au=Gardner%2C+Matt&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-32\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-32\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation journal cs1 cs1-prop-long-vol\" id=\"CITEREFLeeIppolitoNystromZhang2022\">Lee, Katherine; Ippolito, Daphne; Nystrom, Andrew; Zhang, Chiyuan; Eck, Douglas; Callison-Burch, Chris; Carlini, Nicholas (May 2022). <a class=\"external text\" href=\"https://aclanthology.org/2022.acl-long.577.pdf\" rel=\"nofollow\">\"Deduplicating Training Data Makes Language Models Better\"</a> <span class=\"cs1-format\">(PDF)</span>. <i>Proceedings of the 60th Annual Meeting of the Association for Computational Linguistics</i>. 1: Long Papers: 8424–8445. <a class=\"mw-redirect\" href=\"/wiki/Doi_(identifier)\" title=\"Doi (identifier)\">doi</a>:<a class=\"external text\" href=\"https://doi.org/10.18653%2Fv1%2F2022.acl-long.577\" rel=\"nofollow\">10.18653/v1/2022.acl-long.577</a>.</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=Proceedings+of+the+60th+Annual+Meeting+of+the+Association+for+Computational+Linguistics&amp;rft.atitle=Deduplicating+Training+Data+Makes+Language+Models+Better&amp;rft.volume=1%3A+Long+Papers&amp;rft.pages=8424-8445&amp;rft.date=2022-05&amp;rft_id=info%3Adoi%2F10.18653%2Fv1%2F2022.acl-long.577&amp;rft.aulast=Lee&amp;rft.aufirst=Katherine&amp;rft.au=Ippolito%2C+Daphne&amp;rft.au=Nystrom%2C+Andrew&amp;rft.au=Zhang%2C+Chiyuan&amp;rft.au=Eck%2C+Douglas&amp;rft.au=Callison-Burch%2C+Chris&amp;rft.au=Carlini%2C+Nicholas&amp;rft_id=https%3A%2F%2Faclanthology.org%2F2022.acl-long.577.pdf&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-33\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-33\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation cs2\" id=\"CITEREFLiBubeckEldanDel_Giorno2023\">Li, Yuanzhi; Bubeck, Sébastien; Eldan, Ronen; Del Giorno, Allie; Gunasekar, Suriya; Lee, Yin Tat (2023-09-11), <i>Textbooks Are All You Need II: phi-1.5 technical report</i>, <a class=\"mw-redirect\" href=\"/wiki/ArXiv_(identifier)\" title=\"ArXiv (identifier)\">arXiv</a>:<span class=\"id-lock-free\" title=\"Freely accessible\"><a class=\"external text\" href=\"https://arxiv.org/abs/2309.05463\" rel=\"nofollow\">2309.05463</a></span></cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=book&amp;rft.btitle=Textbooks+Are+All+You+Need+II%3A+phi-1.5+technical+report&amp;rft.date=2023-09-11&amp;rft_id=info%3Aarxiv%2F2309.05463&amp;rft.aulast=Li&amp;rft.aufirst=Yuanzhi&amp;rft.au=Bubeck%2C+S%C3%A9bastien&amp;rft.au=Eldan%2C+Ronen&amp;rft.au=Del+Giorno%2C+Allie&amp;rft.au=Gunasekar%2C+Suriya&amp;rft.au=Lee%2C+Yin+Tat&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-34\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-34\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation arxiv cs1\" id=\"CITEREFLinGouGongLiu2024\">Lin, Zhenghao; Gou, Zhibin; Gong, Yeyun; Liu, Xiao; Shen, Yelong; Xu, Ruochen; Lin, Chen; Yang, Yujiu; Jiao, Jian (2024-04-11). \"Rho-1: Not All Tokens Are What You Need\". <a class=\"mw-redirect\" href=\"/wiki/ArXiv_(identifier)\" title=\"ArXiv (identifier)\">arXiv</a>:<span class=\"id-lock-free\" title=\"Freely accessible\"><a class=\"external text\" href=\"https://arxiv.org/abs/2404.07965\" rel=\"nofollow\">2404.07965</a></span> [<a class=\"external text\" href=\"https://arxiv.org/archive/cs.CL\" rel=\"nofollow\">cs.CL</a>].</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=preprint&amp;rft.jtitle=arXiv&amp;rft.atitle=Rho-1%3A+Not+All+Tokens+Are+What+You+Need&amp;rft.date=2024-04-11&amp;rft_id=info%3Aarxiv%2F2404.07965&amp;rft.aulast=Lin&amp;rft.aufirst=Zhenghao&amp;rft.au=Gou%2C+Zhibin&amp;rft.au=Gong%2C+Yeyun&amp;rft.au=Liu%2C+Xiao&amp;rft.au=Shen%2C+Yelong&amp;rft.au=Xu%2C+Ruochen&amp;rft.au=Lin%2C+Chen&amp;rft.au=Yang%2C+Yujiu&amp;rft.au=Jiao%2C+Jian&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-qbFw1-35\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-qbFw1_35-0\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation arxiv cs1\" id=\"CITEREFBrownMannRyderSubbiah2020\">Brown, Tom B.; et al. (2020). \"Language Models are Few-Shot Learners\". <a class=\"mw-redirect\" href=\"/wiki/ArXiv_(identifier)\" title=\"ArXiv (identifier)\">arXiv</a>:<span class=\"id-lock-free\" title=\"Freely accessible\"><a class=\"external text\" href=\"https://arxiv.org/abs/2005.14165\" rel=\"nofollow\">2005.14165</a></span> [<a class=\"external text\" href=\"https://arxiv.org/archive/cs.CL\" rel=\"nofollow\">cs.CL</a>].</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=preprint&amp;rft.jtitle=arXiv&amp;rft.atitle=Language+Models+are+Few-Shot+Learners&amp;rft.date=2020&amp;rft_id=info%3Aarxiv%2F2005.14165&amp;rft.aulast=Brown&amp;rft.aufirst=Tom+B.&amp;rft.au=Mann%2C+Benjamin&amp;rft.au=Ryder%2C+Nick&amp;rft.au=Subbiah%2C+Melanie&amp;rft.au=Kaplan%2C+Jared&amp;rft.au=Dhariwal%2C+Prafulla&amp;rft.au=Neelakantan%2C+Arvind&amp;rft.au=Shyam%2C+Pranav&amp;rft.au=Sastry%2C+Girish&amp;rft.au=Askell%2C+Amanda&amp;rft.au=Agarwal%2C+Sandhini&amp;rft.au=Herbert-Voss%2C+Ariel&amp;rft.au=Krueger%2C+Gretchen&amp;rft.au=Henighan%2C+Tom&amp;rft.au=Child%2C+Rewon&amp;rft.au=Ramesh%2C+Aditya&amp;rft.au=Ziegler%2C+Daniel+M.&amp;rft.au=Wu%2C+Jeffrey&amp;rft.au=Winter%2C+Clemens&amp;rft.au=Hesse%2C+Christopher&amp;rft.au=Chen%2C+Mark&amp;rft.au=Sigler%2C+Eric&amp;rft.au=Litwin%2C+Mateusz&amp;rft.au=Gray%2C+Scott&amp;rft.au=Chess%2C+Benjamin&amp;rft.au=Clark%2C+Jack&amp;rft.au=Berner%2C+Christopher&amp;rft.au=McCandlish%2C+Sam&amp;rft.au=Radford%2C+Alec&amp;rft.au=Sutskever%2C+Ilya&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-36\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-36\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation arxiv cs1\" id=\"CITEREFAbdinJacobsAwanAneja2024\">Abdin, Marah; Jacobs, Sam Ade; Awan, Ammar Ahmad; Aneja, Jyoti; Awadallah, Ahmed; Awadalla, Hany; Bach, Nguyen; Bahree, Amit; Bakhtiari, Arash (2024-04-23). \"Phi-3 Technical Report: A Highly Capable Language Model Locally on Your Phone\". <a class=\"mw-redirect\" href=\"/wiki/ArXiv_(identifier)\" title=\"ArXiv (identifier)\">arXiv</a>:<span class=\"id-lock-free\" title=\"Freely accessible\"><a class=\"external text\" href=\"https://arxiv.org/abs/2404.14219\" rel=\"nofollow\">2404.14219</a></span> [<a class=\"external text\" href=\"https://arxiv.org/archive/cs.CL\" rel=\"nofollow\">cs.CL</a>].</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=preprint&amp;rft.jtitle=arXiv&amp;rft.atitle=Phi-3+Technical+Report%3A+A+Highly+Capable+Language+Model+Locally+on+Your+Phone&amp;rft.date=2024-04-23&amp;rft_id=info%3Aarxiv%2F2404.14219&amp;rft.aulast=Abdin&amp;rft.aufirst=Marah&amp;rft.au=Jacobs%2C+Sam+Ade&amp;rft.au=Awan%2C+Ammar+Ahmad&amp;rft.au=Aneja%2C+Jyoti&amp;rft.au=Awadallah%2C+Ahmed&amp;rft.au=Awadalla%2C+Hany&amp;rft.au=Bach%2C+Nguyen&amp;rft.au=Bahree%2C+Amit&amp;rft.au=Bakhtiari%2C+Arash&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-instructGPT-paper-37\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-instructGPT-paper_37-0\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation arxiv cs1\" id=\"CITEREFOuyangWuJiangAlmeida2022\">Ouyang, Long; Wu, Jeff; Jiang, Xu; Almeida, Diogo; Wainwright, Carroll L.; Mishkin, Pamela; Zhang, Chong; Agarwal, Sandhini; Slama, Katarina; Ray, Alex; Schulman, John; Hilton, Jacob; Kelton, Fraser; Miller, Luke; Simens, Maddie; Askell, Amanda; Welinder, Peter; Christiano, Paul; Leike, Jan; Lowe, Ryan (2022). \"Training language models to follow instructions with human feedback\". <a class=\"mw-redirect\" href=\"/wiki/ArXiv_(identifier)\" title=\"ArXiv (identifier)\">arXiv</a>:<span class=\"id-lock-free\" title=\"Freely accessible\"><a class=\"external text\" href=\"https://arxiv.org/abs/2203.02155\" rel=\"nofollow\">2203.02155</a></span> [<a class=\"external text\" href=\"https://arxiv.org/archive/cs.CL\" rel=\"nofollow\">cs.CL</a>].</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=preprint&amp;rft.jtitle=arXiv&amp;rft.atitle=Training+language+models+to+follow+instructions+with+human+feedback&amp;rft.date=2022&amp;rft_id=info%3Aarxiv%2F2203.02155&amp;rft.aulast=Ouyang&amp;rft.aufirst=Long&amp;rft.au=Wu%2C+Jeff&amp;rft.au=Jiang%2C+Xu&amp;rft.au=Almeida%2C+Diogo&amp;rft.au=Wainwright%2C+Carroll+L.&amp;rft.au=Mishkin%2C+Pamela&amp;rft.au=Zhang%2C+Chong&amp;rft.au=Agarwal%2C+Sandhini&amp;rft.au=Slama%2C+Katarina&amp;rft.au=Ray%2C+Alex&amp;rft.au=Schulman%2C+John&amp;rft.au=Hilton%2C+Jacob&amp;rft.au=Kelton%2C+Fraser&amp;rft.au=Miller%2C+Luke&amp;rft.au=Simens%2C+Maddie&amp;rft.au=Askell%2C+Amanda&amp;rft.au=Welinder%2C+Peter&amp;rft.au=Christiano%2C+Paul&amp;rft.au=Leike%2C+Jan&amp;rft.au=Lowe%2C+Ryan&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-self-instruct-paper-38\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-self-instruct-paper_38-0\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation arxiv cs1\" id=\"CITEREFWangKordiMishraLiu2022\">Wang, Yizhong; Kordi, Yeganeh; Mishra, Swaroop; Liu, Alisa; Smith, Noah A.; Khashabi, Daniel; Hajishirzi, Hannaneh (2022). \"Self-Instruct: Aligning Language Model with Self Generated Instructions\". <a class=\"mw-redirect\" href=\"/wiki/ArXiv_(identifier)\" title=\"ArXiv (identifier)\">arXiv</a>:<span class=\"id-lock-free\" title=\"Freely accessible\"><a class=\"external text\" href=\"https://arxiv.org/abs/2212.10560\" rel=\"nofollow\">2212.10560</a></span> [<a class=\"external text\" href=\"https://arxiv.org/archive/cs.CL\" rel=\"nofollow\">cs.CL</a>].</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=preprint&amp;rft.jtitle=arXiv&amp;rft.atitle=Self-Instruct%3A+Aligning+Language+Model+with+Self+Generated+Instructions&amp;rft.date=2022&amp;rft_id=info%3Aarxiv%2F2212.10560&amp;rft.aulast=Wang&amp;rft.aufirst=Yizhong&amp;rft.au=Kordi%2C+Yeganeh&amp;rft.au=Mishra%2C+Swaroop&amp;rft.au=Liu%2C+Alisa&amp;rft.au=Smith%2C+Noah+A.&amp;rft.au=Khashabi%2C+Daniel&amp;rft.au=Hajishirzi%2C+Hannaneh&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-HGZCJ-39\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-HGZCJ_39-0\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation arxiv cs1\" id=\"CITEREFShazeerMirhoseiniMaziarzDavis2017\">Shazeer, Noam; Mirhoseini, Azalia; Maziarz, Krzysztof; Davis, Andy; Le, Quoc; Hinton, Geoffrey; Dean, Jeff (2017-01-01). \"Outrageously Large Neural Networks: The Sparsely-Gated Mixture-of-Experts Layer\". <a class=\"mw-redirect\" href=\"/wiki/ArXiv_(identifier)\" title=\"ArXiv (identifier)\">arXiv</a>:<span class=\"id-lock-free\" title=\"Freely accessible\"><a class=\"external text\" href=\"https://arxiv.org/abs/1701.06538\" rel=\"nofollow\">1701.06538</a></span> [<a class=\"external text\" href=\"https://arxiv.org/archive/cs.LG\" rel=\"nofollow\">cs.LG</a>].</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=preprint&amp;rft.jtitle=arXiv&amp;rft.atitle=Outrageously+Large+Neural+Networks%3A+The+Sparsely-Gated+Mixture-of-Experts+Layer&amp;rft.date=2017-01-01&amp;rft_id=info%3Aarxiv%2F1701.06538&amp;rft.aulast=Shazeer&amp;rft.aufirst=Noam&amp;rft.au=Mirhoseini%2C+Azalia&amp;rft.au=Maziarz%2C+Krzysztof&amp;rft.au=Davis%2C+Andy&amp;rft.au=Le%2C+Quoc&amp;rft.au=Hinton%2C+Geoffrey&amp;rft.au=Dean%2C+Jeff&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-R9Qq5-40\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-R9Qq5_40-0\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation arxiv cs1\" id=\"CITEREFLepikhinLeeXuChen2021\">Lepikhin, Dmitry; Lee, HyoukJoong; Xu, Yuanzhong; Chen, Dehao; Firat, Orhan; Huang, Yanping; Krikun, Maxim; Shazeer, Noam; Chen, Zhifeng (2021-01-12). \"GShard: Scaling Giant Models with Conditional Computation and Automatic Sharding\". <a class=\"mw-redirect\" href=\"/wiki/ArXiv_(identifier)\" title=\"ArXiv (identifier)\">arXiv</a>:<span class=\"id-lock-free\" title=\"Freely accessible\"><a class=\"external text\" href=\"https://arxiv.org/abs/2006.16668\" rel=\"nofollow\">2006.16668</a></span> [<a class=\"external text\" href=\"https://arxiv.org/archive/cs.CL\" rel=\"nofollow\">cs.CL</a>].</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=preprint&amp;rft.jtitle=arXiv&amp;rft.atitle=GShard%3A+Scaling+Giant+Models+with+Conditional+Computation+and+Automatic+Sharding&amp;rft.date=2021-01-12&amp;rft_id=info%3Aarxiv%2F2006.16668&amp;rft.aulast=Lepikhin&amp;rft.aufirst=Dmitry&amp;rft.au=Lee%2C+HyoukJoong&amp;rft.au=Xu%2C+Yuanzhong&amp;rft.au=Chen%2C+Dehao&amp;rft.au=Firat%2C+Orhan&amp;rft.au=Huang%2C+Yanping&amp;rft.au=Krikun%2C+Maxim&amp;rft.au=Shazeer%2C+Noam&amp;rft.au=Chen%2C+Zhifeng&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-glam-blog-41\"><span class=\"mw-cite-backlink\">^ <a href=\"#cite_ref-glam-blog_41-0\"><sup><i><b>a</b></i></sup></a> <a href=\"#cite_ref-glam-blog_41-1\"><sup><i><b>b</b></i></sup></a> <a href=\"#cite_ref-glam-blog_41-2\"><sup><i><b>c</b></i></sup></a> <a href=\"#cite_ref-glam-blog_41-3\"><sup><i><b>d</b></i></sup></a></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation web cs1\" id=\"CITEREFDaiDu2021\">Dai, Andrew M; Du, Nan (December 9, 2021). <a class=\"external text\" href=\"https://ai.googleblog.com/2021/12/more-efficient-in-context-learning-with.html\" rel=\"nofollow\">\"More Efficient In-Context Learning with GLaM\"</a>. <i>ai.googleblog.com</i>. <a class=\"external text\" href=\"https://web.archive.org/web/20230312072042/https://ai.googleblog.com/2021/12/more-efficient-in-context-learning-with.html\" rel=\"nofollow\">Archived</a> from the original on 2023-03-12<span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">2023-03-09</span></span>.</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=ai.googleblog.com&amp;rft.atitle=More+Efficient+In-Context+Learning+with+GLaM&amp;rft.date=2021-12-09&amp;rft.aulast=Dai&amp;rft.aufirst=Andrew+M&amp;rft.au=Du%2C+Nan&amp;rft_id=https%3A%2F%2Fai.googleblog.com%2F2021%2F12%2Fmore-efficient-in-context-learning-with.html&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-emergentpaper-42\"><span class=\"mw-cite-backlink\">^ <a href=\"#cite_ref-emergentpaper_42-0\"><sup><i><b>a</b></i></sup></a> <a href=\"#cite_ref-emergentpaper_42-1\"><sup><i><b>b</b></i></sup></a> <a href=\"#cite_ref-emergentpaper_42-2\"><sup><i><b>c</b></i></sup></a></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation journal cs1\" id=\"CITEREFWeiTayBommasaniRaffel2022\">Wei, Jason; Tay, Yi; Bommasani, Rishi; Raffel, Colin; Zoph, Barret; Borgeaud, Sebastian; Yogatama, Dani; Bosma, Maarten; Zhou, Denny; Metzler, Donald; Chi, Ed H.; Hashimoto, Tatsunori; Vinyals, Oriol; Liang, Percy; Dean, Jeff; Fedus, William (31 August 2022). <a class=\"external text\" href=\"https://openreview.net/forum?id=yzkSU5zdwD\" rel=\"nofollow\">\"Emergent Abilities of Large Language Models\"</a>. <i>Transactions on Machine Learning Research</i>. <a class=\"mw-redirect\" href=\"/wiki/ISSN_(identifier)\" title=\"ISSN (identifier)\">ISSN</a> <a class=\"external text\" href=\"https://search.worldcat.org/issn/2835-8856\" rel=\"nofollow\">2835-8856</a>. <a class=\"external text\" href=\"https://web.archive.org/web/20230322210052/https://openreview.net/forum?id=yzkSU5zdwD\" rel=\"nofollow\">Archived</a> from the original on 22 March 2023<span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">19 March</span> 2023</span>.</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=Transactions+on+Machine+Learning+Research&amp;rft.atitle=Emergent+Abilities+of+Large+Language+Models&amp;rft.date=2022-08-31&amp;rft.issn=2835-8856&amp;rft.aulast=Wei&amp;rft.aufirst=Jason&amp;rft.au=Tay%2C+Yi&amp;rft.au=Bommasani%2C+Rishi&amp;rft.au=Raffel%2C+Colin&amp;rft.au=Zoph%2C+Barret&amp;rft.au=Borgeaud%2C+Sebastian&amp;rft.au=Yogatama%2C+Dani&amp;rft.au=Bosma%2C+Maarten&amp;rft.au=Zhou%2C+Denny&amp;rft.au=Metzler%2C+Donald&amp;rft.au=Chi%2C+Ed+H.&amp;rft.au=Hashimoto%2C+Tatsunori&amp;rft.au=Vinyals%2C+Oriol&amp;rft.au=Liang%2C+Percy&amp;rft.au=Dean%2C+Jeff&amp;rft.au=Fedus%2C+William&amp;rft_id=https%3A%2F%2Fopenreview.net%2Fforum%3Fid%3DyzkSU5zdwD&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-Jay_Allamar-43\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-Jay_Allamar_43-0\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation web cs1\" id=\"CITEREFAllamar\">Allamar, Jay. <a class=\"external text\" href=\"https://jalammar.github.io/illustrated-transformer/\" rel=\"nofollow\">\"Illustrated transformer\"</a>. <a class=\"external text\" href=\"https://web.archive.org/web/20230725230033/http://jalammar.github.io/illustrated-transformer/\" rel=\"nofollow\">Archived</a> from the original on 2023-07-25<span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">2023-07-29</span></span>.</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=Illustrated+transformer&amp;rft.aulast=Allamar&amp;rft.aufirst=Jay&amp;rft_id=https%3A%2F%2Fjalammar.github.io%2Fillustrated-transformer%2F&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-Jay_Allamar_GPT2-44\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-Jay_Allamar_GPT2_44-0\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation web cs1\" id=\"CITEREFAllamar\">Allamar, Jay. <a class=\"external text\" href=\"https://jalammar.github.io/illustrated-gpt2/\" rel=\"nofollow\">\"The Illustrated GPT-2 (Visualizing Transformer Language Models)\"</a><span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">2023-08-01</span></span>.</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=The+Illustrated+GPT-2+%28Visualizing+Transformer+Language+Models%29&amp;rft.aulast=Allamar&amp;rft.aufirst=Jay&amp;rft_id=https%3A%2F%2Fjalammar.github.io%2Fillustrated-gpt2%2F&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-45\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-45\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation web cs1\"><a class=\"external text\" href=\"https://blog.google/technology/ai/google-gemini-next-generation-model-february-2024/#context-window\" rel=\"nofollow\">\"Our next-generation model: Gemini 1.5\"</a>. <i>Google</i>. 15 February 2024. <a class=\"external text\" href=\"https://web.archive.org/web/20240218141522/https://blog.google/technology/ai/google-gemini-next-generation-model-february-2024/#context-window\" rel=\"nofollow\">Archived</a> from the original on 18 February 2024<span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">18 February</span> 2024</span>.</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=Google&amp;rft.atitle=Our+next-generation+model%3A+Gemini+1.5&amp;rft.date=2024-02-15&amp;rft_id=https%3A%2F%2Fblog.google%2Ftechnology%2Fai%2Fgoogle-gemini-next-generation-model-february-2024%2F%23context-window&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-46\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-46\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation web cs1\"><a class=\"external text\" href=\"https://www.anthropic.com/news/claude-2-1-prompting\" rel=\"nofollow\">\"Long context prompting for Claude 2.1\"</a>. December 6, 2023. <a class=\"external text\" href=\"https://web.archive.org/web/20240827053830/https://www.anthropic.com/news/claude-2-1-prompting\" rel=\"nofollow\">Archived</a> from the original on August 27, 2024<span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">January 20,</span> 2024</span>.</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=Long+context+prompting+for+Claude+2.1&amp;rft.date=2023-12-06&amp;rft_id=https%3A%2F%2Fwww.anthropic.com%2Fnews%2Fclaude-2-1-prompting&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-47\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-47\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation web cs1\"><a class=\"external text\" href=\"https://platform.openai.com/docs/guides/rate-limits\" rel=\"nofollow\">\"Rate limits\"</a>. <i>openai.com</i>. <a class=\"external text\" href=\"https://web.archive.org/web/20240202003219/https://platform.openai.com/docs/guides/rate-limits\" rel=\"nofollow\">Archived</a> from the original on February 2, 2024<span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">January 20,</span> 2024</span>.</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=openai.com&amp;rft.atitle=Rate+limits&amp;rft_id=https%3A%2F%2Fplatform.openai.com%2Fdocs%2Fguides%2Frate-limits&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-ioUpE-48\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-ioUpE_48-0\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation book cs1\" id=\"CITEREFZaibShengEmma_Zhang2020\">Zaib, Munazza; Sheng, Quan Z.; Emma Zhang, Wei (4 February 2020). <a class=\"external text\" href=\"https://www.researchgate.net/publication/338931711\" rel=\"nofollow\">\"A Short Survey of Pre-trained Language Models for Conversational AI-A New Age in NLP\"</a>. <i>Proceedings of the Australasian Computer Science Week Multiconference</i>. pp. 1–4. <a class=\"mw-redirect\" href=\"/wiki/ArXiv_(identifier)\" title=\"ArXiv (identifier)\">arXiv</a>:<span class=\"id-lock-free\" title=\"Freely accessible\"><a class=\"external text\" href=\"https://arxiv.org/abs/2104.10810\" rel=\"nofollow\">2104.10810</a></span>. <a class=\"mw-redirect\" href=\"/wiki/Doi_(identifier)\" title=\"Doi (identifier)\">doi</a>:<a class=\"external text\" href=\"https://doi.org/10.1145%2F3373017.3373028\" rel=\"nofollow\">10.1145/3373017.3373028</a>. <a class=\"mw-redirect\" href=\"/wiki/ISBN_(identifier)\" title=\"ISBN (identifier)\">ISBN</a> <a href=\"/wiki/Special:BookSources/9781450376976\" title=\"Special:BookSources/9781450376976\"><bdi>9781450376976</bdi></a>. <a class=\"mw-redirect\" href=\"/wiki/S2CID_(identifier)\" title=\"S2CID (identifier)\">S2CID</a> <a class=\"external text\" href=\"https://api.semanticscholar.org/CorpusID:211040895\" rel=\"nofollow\">211040895</a>.</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=bookitem&amp;rft.atitle=A+Short+Survey+of+Pre-trained+Language+Models+for+Conversational+AI-A+New+Age+in+NLP&amp;rft.btitle=Proceedings+of+the+Australasian+Computer+Science+Week+Multiconference&amp;rft.pages=1-4&amp;rft.date=2020-02-04&amp;rft_id=info%3Aarxiv%2F2104.10810&amp;rft_id=https%3A%2F%2Fapi.semanticscholar.org%2FCorpusID%3A211040895%23id-name%3DS2CID&amp;rft_id=info%3Adoi%2F10.1145%2F3373017.3373028&amp;rft.isbn=9781450376976&amp;rft.aulast=Zaib&amp;rft.aufirst=Munazza&amp;rft.au=Sheng%2C+Quan+Z.&amp;rft.au=Emma+Zhang%2C+Wei&amp;rft_id=https%3A%2F%2Fwww.researchgate.net%2Fpublication%2F338931711&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-jm-49\"><span class=\"mw-cite-backlink\">^ <a href=\"#cite_ref-jm_49-0\"><sup><i><b>a</b></i></sup></a> <a href=\"#cite_ref-jm_49-1\"><sup><i><b>b</b></i></sup></a> <a href=\"#cite_ref-jm_49-2\"><sup><i><b>c</b></i></sup></a></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation book cs1\" id=\"CITEREFJurafskyMartin2023\">Jurafsky, Dan; Martin, James H. (7 January 2023). <a class=\"external text\" href=\"https://web.stanford.edu/~jurafsky/slp3/ed3book_jan72023.pdf\" rel=\"nofollow\"><i>Speech and Language Processing</i></a> <span class=\"cs1-format\">(PDF)</span> (3rd edition draft ed.). <a class=\"external text\" href=\"https://web.archive.org/web/20230323210221/https://web.stanford.edu/~jurafsky/slp3/ed3book_jan72023.pdf\" rel=\"nofollow\">Archived</a> <span class=\"cs1-format\">(PDF)</span> from the original on 23 March 2023<span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">24 May</span> 2022</span>.</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=book&amp;rft.btitle=Speech+and+Language+Processing&amp;rft.edition=3rd+edition+draft&amp;rft.date=2023-01-07&amp;rft.aulast=Jurafsky&amp;rft.aufirst=Dan&amp;rft.au=Martin%2C+James+H.&amp;rft_id=https%3A%2F%2Fweb.stanford.edu%2F~jurafsky%2Fslp3%2Fed3book_jan72023.pdf&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-50\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-50\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation web cs1\"><a class=\"external text\" href=\"https://imbue.com/research/70b-infrastructure/\" rel=\"nofollow\">\"From bare metal to a 70B model: infrastructure set-up and scripts\"</a>. <i>imbue.com</i>. <a class=\"external text\" href=\"https://web.archive.org/web/20240726203419/https://imbue.com/research/70b-infrastructure/\" rel=\"nofollow\">Archived</a> from the original on 2024-07-26<span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">2024-07-24</span></span>.</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=imbue.com&amp;rft.atitle=From+bare+metal+to+a+70B+model%3A+infrastructure+set-up+and+scripts&amp;rft_id=https%3A%2F%2Fimbue.com%2Fresearch%2F70b-infrastructure%2F&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-51\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-51\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation web cs1\"><a class=\"external text\" href=\"https://github.com/facebookresearch/metaseq/tree/main/projects/OPT/chronicles\" rel=\"nofollow\">\"metaseq/projects/OPT/chronicles at main · facebookresearch/metaseq\"</a>. <i>GitHub</i>. <a class=\"external text\" href=\"https://web.archive.org/web/20240124035658/https://github.com/facebookresearch/metaseq/tree/main/projects/OPT/chronicles\" rel=\"nofollow\">Archived</a> from the original on 2024-01-24<span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">2024-07-24</span></span>.</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=GitHub&amp;rft.atitle=metaseq%2Fprojects%2FOPT%2Fchronicles+at+main+%C2%B7+facebookresearch%2Fmetaseq&amp;rft_id=https%3A%2F%2Fgithub.com%2Ffacebookresearch%2Fmetaseq%2Ftree%2Fmain%2Fprojects%2FOPT%2Fchronicles&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-52\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-52\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation web cs1\" id=\"CITEREFAlbrecht2024\">Albrecht, Josh (2024-07-23). <a class=\"external text\" href=\"https://www.latent.space/p/llm-training-2024\" rel=\"nofollow\">\"State of the Art: Training &gt;70B LLMs on 10,000 H100 clusters\"</a>. <i>www.latent.space</i><span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">2024-07-24</span></span>.</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=www.latent.space&amp;rft.atitle=State+of+the+Art%3A+Training+%3E70B+LLMs+on+10%2C000+H100+clusters&amp;rft.date=2024-07-23&amp;rft.aulast=Albrecht&amp;rft.aufirst=Josh&amp;rft_id=https%3A%2F%2Fwww.latent.space%2Fp%2Fllm-training-2024&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-Wiggers-53\"><span class=\"mw-cite-backlink\">^ <a href=\"#cite_ref-Wiggers_53-0\"><sup><i><b>a</b></i></sup></a> <a href=\"#cite_ref-Wiggers_53-1\"><sup><i><b>b</b></i></sup></a></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation web cs1\" id=\"CITEREFWiggers2022\">Wiggers, Kyle (28 April 2022). <a class=\"external text\" href=\"https://techcrunch.com/2022/04/28/the-emerging-types-of-language-models-and-why-they-matter/\" rel=\"nofollow\">\"The emerging types of language models and why they matter\"</a>. <i>TechCrunch</i>. <a class=\"external text\" href=\"https://web.archive.org/web/20230316072443/https://techcrunch.com/2022/04/28/the-emerging-types-of-language-models-and-why-they-matter/\" rel=\"nofollow\">Archived</a> from the original on 16 March 2023<span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">9 March</span> 2023</span>.</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=TechCrunch&amp;rft.atitle=The+emerging+types+of+language+models+and+why+they+matter&amp;rft.date=2022-04-28&amp;rft.aulast=Wiggers&amp;rft.aufirst=Kyle&amp;rft_id=https%3A%2F%2Ftechcrunch.com%2F2022%2F04%2F28%2Fthe-emerging-types-of-language-models-and-why-they-matter%2F&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-xaytj-54\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-xaytj_54-0\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation arxiv cs1\" id=\"CITEREFSharirPelegShoham2020\">Sharir, Or; Peleg, Barak; Shoham, Yoav (2020). \"The Cost of Training NLP Models: A Concise Overview\". <a class=\"mw-redirect\" href=\"/wiki/ArXiv_(identifier)\" title=\"ArXiv (identifier)\">arXiv</a>:<span class=\"id-lock-free\" title=\"Freely accessible\"><a class=\"external text\" href=\"https://arxiv.org/abs/2004.08900\" rel=\"nofollow\">2004.08900</a></span> [<a class=\"external text\" href=\"https://arxiv.org/archive/cs.CL\" rel=\"nofollow\">cs.CL</a>].</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=preprint&amp;rft.jtitle=arXiv&amp;rft.atitle=The+Cost+of+Training+NLP+Models%3A+A+Concise+Overview&amp;rft.date=2020&amp;rft_id=info%3Aarxiv%2F2004.08900&amp;rft.aulast=Sharir&amp;rft.aufirst=Or&amp;rft.au=Peleg%2C+Barak&amp;rft.au=Shoham%2C+Yoav&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-Pythia-55\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-Pythia_55-0\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation arxiv cs1\" id=\"CITEREFBidermanSchoelkopfAnthonyBradley2023\">Biderman, Stella; Schoelkopf, Hailey; Anthony, Quentin; Bradley, Herbie; Khan, Mohammad Aflah; Purohit, Shivanshu; Prashanth, USVSN Sai (April 2023). \"Pythia: A Suite for Analyzing Large Language Models Across Training and Scaling\". <a class=\"mw-redirect\" href=\"/wiki/ArXiv_(identifier)\" title=\"ArXiv (identifier)\">arXiv</a>:<span class=\"id-lock-free\" title=\"Freely accessible\"><a class=\"external text\" href=\"https://arxiv.org/abs/2304.01373\" rel=\"nofollow\">2304.01373</a></span> [<a class=\"external text\" href=\"https://arxiv.org/archive/cs.CL\" rel=\"nofollow\">cs.CL</a>].</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=preprint&amp;rft.jtitle=arXiv&amp;rft.atitle=Pythia%3A+A+Suite+for+Analyzing+Large+Language+Models+Across+Training+and+Scaling&amp;rft.date=2023-04&amp;rft_id=info%3Aarxiv%2F2304.01373&amp;rft.aulast=Biderman&amp;rft.aufirst=Stella&amp;rft.au=Schoelkopf%2C+Hailey&amp;rft.au=Anthony%2C+Quentin&amp;rft.au=Bradley%2C+Herbie&amp;rft.au=Khan%2C+Mohammad+Aflah&amp;rft.au=Purohit%2C+Shivanshu&amp;rft.au=Prashanth%2C+USVSN+Sai&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-56\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-56\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation cs2\" id=\"CITEREFMaslejFattoriniBrynjolfssonEtchemendy2023\">Maslej, Nestor; Fattorini, Loredana; Brynjolfsson, Erik; Etchemendy, John; Ligett, Katrina; Lyons, Terah; Manyika, James; Ngo, Helen; Niebles, Juan Carlos (2023-10-05), <i>Artificial Intelligence Index Report 2023</i>, <a class=\"mw-redirect\" href=\"/wiki/ArXiv_(identifier)\" title=\"ArXiv (identifier)\">arXiv</a>:<span class=\"id-lock-free\" title=\"Freely accessible\"><a class=\"external text\" href=\"https://arxiv.org/abs/2310.03715\" rel=\"nofollow\">2310.03715</a></span></cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=book&amp;rft.btitle=Artificial+Intelligence+Index+Report+2023&amp;rft.date=2023-10-05&amp;rft_id=info%3Aarxiv%2F2310.03715&amp;rft.aulast=Maslej&amp;rft.aufirst=Nestor&amp;rft.au=Fattorini%2C+Loredana&amp;rft.au=Brynjolfsson%2C+Erik&amp;rft.au=Etchemendy%2C+John&amp;rft.au=Ligett%2C+Katrina&amp;rft.au=Lyons%2C+Terah&amp;rft.au=Manyika%2C+James&amp;rft.au=Ngo%2C+Helen&amp;rft.au=Niebles%2C+Juan+Carlos&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-kaplan-scaling-57\"><span class=\"mw-cite-backlink\">^ <a href=\"#cite_ref-kaplan-scaling_57-0\"><sup><i><b>a</b></i></sup></a> <a href=\"#cite_ref-kaplan-scaling_57-1\"><sup><i><b>b</b></i></sup></a></span> <span class=\"reference-text\">Section 2.1 and Table 1,\n\n<link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation arxiv cs1\" id=\"CITEREFKaplanMcCandlishHenighanBrown2020\">Kaplan, Jared; McCandlish, Sam; Henighan, Tom; Brown, Tom B.; Chess, Benjamin; Child, Rewon; Gray, Scott; Radford, Alec; Wu, Jeffrey; Amodei, Dario (2020). \"Scaling Laws for Neural Language Models\". <a class=\"mw-redirect\" href=\"/wiki/ArXiv_(identifier)\" title=\"ArXiv (identifier)\">arXiv</a>:<span class=\"id-lock-free\" title=\"Freely accessible\"><a class=\"external text\" href=\"https://arxiv.org/abs/2001.08361\" rel=\"nofollow\">2001.08361</a></span> [<a class=\"external text\" href=\"https://arxiv.org/archive/cs.LG\" rel=\"nofollow\">cs.LG</a>].</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=preprint&amp;rft.jtitle=arXiv&amp;rft.atitle=Scaling+Laws+for+Neural+Language+Models&amp;rft.date=2020&amp;rft_id=info%3Aarxiv%2F2001.08361&amp;rft.aulast=Kaplan&amp;rft.aufirst=Jared&amp;rft.au=McCandlish%2C+Sam&amp;rft.au=Henighan%2C+Tom&amp;rft.au=Brown%2C+Tom+B.&amp;rft.au=Chess%2C+Benjamin&amp;rft.au=Child%2C+Rewon&amp;rft.au=Gray%2C+Scott&amp;rft.au=Radford%2C+Alec&amp;rft.au=Wu%2C+Jeffrey&amp;rft.au=Amodei%2C+Dario&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-PI1fW-58\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-PI1fW_58-0\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation arxiv cs1\" id=\"CITEREFGaoMadaanZhouAlon2022\">Gao, Luyu; Madaan, Aman; Zhou, Shuyan; Alon, Uri; Liu, Pengfei; Yang, Yiming; Callan, Jamie; Neubig, Graham (2022-11-01). \"PAL: Program-aided Language Models\". <a class=\"mw-redirect\" href=\"/wiki/ArXiv_(identifier)\" title=\"ArXiv (identifier)\">arXiv</a>:<span class=\"id-lock-free\" title=\"Freely accessible\"><a class=\"external text\" href=\"https://arxiv.org/abs/2211.10435\" rel=\"nofollow\">2211.10435</a></span> [<a class=\"external text\" href=\"https://arxiv.org/archive/cs.CL\" rel=\"nofollow\">cs.CL</a>].</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=preprint&amp;rft.jtitle=arXiv&amp;rft.atitle=PAL%3A+Program-aided+Language+Models&amp;rft.date=2022-11-01&amp;rft_id=info%3Aarxiv%2F2211.10435&amp;rft.aulast=Gao&amp;rft.aufirst=Luyu&amp;rft.au=Madaan%2C+Aman&amp;rft.au=Zhou%2C+Shuyan&amp;rft.au=Alon%2C+Uri&amp;rft.au=Liu%2C+Pengfei&amp;rft.au=Yang%2C+Yiming&amp;rft.au=Callan%2C+Jamie&amp;rft.au=Neubig%2C+Graham&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-J5OW5-59\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-J5OW5_59-0\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation web cs1\"><a class=\"external text\" href=\"https://reasonwithpal.com/\" rel=\"nofollow\">\"PAL: Program-aided Language Models\"</a>. <i>reasonwithpal.com</i>. <a class=\"external text\" href=\"https://web.archive.org/web/20230612162208/https://reasonwithpal.com/\" rel=\"nofollow\">Archived</a> from the original on 2023-06-12<span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">2023-06-12</span></span>.</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=reasonwithpal.com&amp;rft.atitle=PAL%3A+Program-aided+Language+Models&amp;rft_id=https%3A%2F%2Freasonwithpal.com%2F&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-gQxzq-60\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-gQxzq_60-0\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation arxiv cs1\" id=\"CITEREFParanjapeLundbergSinghHajishirzi2023\">Paranjape, Bhargavi; Lundberg, Scott; Singh, Sameer; Hajishirzi, Hannaneh; Zettlemoyer, Luke; Tulio Ribeiro, Marco (2023-03-01). \"ART: Automatic multi-step reasoning and tool-use for large language models\". <a class=\"mw-redirect\" href=\"/wiki/ArXiv_(identifier)\" title=\"ArXiv (identifier)\">arXiv</a>:<span class=\"id-lock-free\" title=\"Freely accessible\"><a class=\"external text\" href=\"https://arxiv.org/abs/2303.09014\" rel=\"nofollow\">2303.09014</a></span> [<a class=\"external text\" href=\"https://arxiv.org/archive/cs.CL\" rel=\"nofollow\">cs.CL</a>].</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=preprint&amp;rft.jtitle=arXiv&amp;rft.atitle=ART%3A+Automatic+multi-step+reasoning+and+tool-use+for+large+language+models&amp;rft.date=2023-03-01&amp;rft_id=info%3Aarxiv%2F2303.09014&amp;rft.aulast=Paranjape&amp;rft.aufirst=Bhargavi&amp;rft.au=Lundberg%2C+Scott&amp;rft.au=Singh%2C+Sameer&amp;rft.au=Hajishirzi%2C+Hannaneh&amp;rft.au=Zettlemoyer%2C+Luke&amp;rft.au=Tulio+Ribeiro%2C+Marco&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-lLrda-61\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-lLrda_61-0\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation arxiv cs1\" id=\"CITEREFLiangWuSongWu2023\">Liang, Yaobo; Wu, Chenfei; Song, Ting; Wu, Wenshan; Xia, Yan; Liu, Yu; Ou, Yang; Lu, Shuai; Ji, Lei; Mao, Shaoguang; Wang, Yun; Shou, Linjun; Gong, Ming; Duan, Nan (2023-03-01). \"TaskMatrix.AI: Completing Tasks by Connecting Foundation Models with Millions of APIs\". <a class=\"mw-redirect\" href=\"/wiki/ArXiv_(identifier)\" title=\"ArXiv (identifier)\">arXiv</a>:<span class=\"id-lock-free\" title=\"Freely accessible\"><a class=\"external text\" href=\"https://arxiv.org/abs/2303.16434\" rel=\"nofollow\">2303.16434</a></span> [<a class=\"external text\" href=\"https://arxiv.org/archive/cs.AI\" rel=\"nofollow\">cs.AI</a>].</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=preprint&amp;rft.jtitle=arXiv&amp;rft.atitle=TaskMatrix.AI%3A+Completing+Tasks+by+Connecting+Foundation+Models+with+Millions+of+APIs&amp;rft.date=2023-03-01&amp;rft_id=info%3Aarxiv%2F2303.16434&amp;rft.aulast=Liang&amp;rft.aufirst=Yaobo&amp;rft.au=Wu%2C+Chenfei&amp;rft.au=Song%2C+Ting&amp;rft.au=Wu%2C+Wenshan&amp;rft.au=Xia%2C+Yan&amp;rft.au=Liu%2C+Yu&amp;rft.au=Ou%2C+Yang&amp;rft.au=Lu%2C+Shuai&amp;rft.au=Ji%2C+Lei&amp;rft.au=Mao%2C+Shaoguang&amp;rft.au=Wang%2C+Yun&amp;rft.au=Shou%2C+Linjun&amp;rft.au=Gong%2C+Ming&amp;rft.au=Duan%2C+Nan&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-4Xzrs-62\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-4Xzrs_62-0\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation arxiv cs1\" id=\"CITEREFPatilZhangWangGonzalez2023\">Patil, Shishir G.; Zhang, Tianjun; Wang, Xin; Gonzalez, Joseph E. (2023-05-01). \"Gorilla: Large Language Model Connected with Massive APIs\". <a class=\"mw-redirect\" href=\"/wiki/ArXiv_(identifier)\" title=\"ArXiv (identifier)\">arXiv</a>:<span class=\"id-lock-free\" title=\"Freely accessible\"><a class=\"external text\" href=\"https://arxiv.org/abs/2305.15334\" rel=\"nofollow\">2305.15334</a></span> [<a class=\"external text\" href=\"https://arxiv.org/archive/cs.CL\" rel=\"nofollow\">cs.CL</a>].</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=preprint&amp;rft.jtitle=arXiv&amp;rft.atitle=Gorilla%3A+Large+Language+Model+Connected+with+Massive+APIs&amp;rft.date=2023-05-01&amp;rft_id=info%3Aarxiv%2F2305.15334&amp;rft.aulast=Patil&amp;rft.aufirst=Shishir+G.&amp;rft.au=Zhang%2C+Tianjun&amp;rft.au=Wang%2C+Xin&amp;rft.au=Gonzalez%2C+Joseph+E.&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-BUZBP-63\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-BUZBP_63-0\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation journal cs1\" id=\"CITEREFLewisPerezPiktusPetroni2020\">Lewis, Patrick; Perez, Ethan; Piktus, Aleksandra; Petroni, Fabio; Karpukhin, Vladimir; Goyal, Naman; Küttler, Heinrich; Lewis, Mike; Yih, Wen-tau; Rocktäschel, Tim; Riedel, Sebastian; Kiela, Douwe (2020). <a class=\"external text\" href=\"https://proceedings.neurips.cc/paper/2020/hash/6b493230205f780e1bc26945df7481e5-Abstract.html\" rel=\"nofollow\">\"Retrieval-Augmented Generation for Knowledge-Intensive NLP Tasks\"</a>. <i>Advances in Neural Information Processing Systems</i>. <b>33</b>. Curran Associates, Inc.: 9459–9474. <a class=\"mw-redirect\" href=\"/wiki/ArXiv_(identifier)\" title=\"ArXiv (identifier)\">arXiv</a>:<span class=\"id-lock-free\" title=\"Freely accessible\"><a class=\"external text\" href=\"https://arxiv.org/abs/2005.11401\" rel=\"nofollow\">2005.11401</a></span>. <a class=\"external text\" href=\"https://web.archive.org/web/20230612171229/https://proceedings.neurips.cc/paper/2020/hash/6b493230205f780e1bc26945df7481e5-Abstract.html\" rel=\"nofollow\">Archived</a> from the original on 2023-06-12<span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">2023-06-12</span></span>.</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=Advances+in+Neural+Information+Processing+Systems&amp;rft.atitle=Retrieval-Augmented+Generation+for+Knowledge-Intensive+NLP+Tasks&amp;rft.volume=33&amp;rft.pages=9459-9474&amp;rft.date=2020&amp;rft_id=info%3Aarxiv%2F2005.11401&amp;rft.aulast=Lewis&amp;rft.aufirst=Patrick&amp;rft.au=Perez%2C+Ethan&amp;rft.au=Piktus%2C+Aleksandra&amp;rft.au=Petroni%2C+Fabio&amp;rft.au=Karpukhin%2C+Vladimir&amp;rft.au=Goyal%2C+Naman&amp;rft.au=K%C3%BCttler%2C+Heinrich&amp;rft.au=Lewis%2C+Mike&amp;rft.au=Yih%2C+Wen-tau&amp;rft.au=Rockt%C3%A4schel%2C+Tim&amp;rft.au=Riedel%2C+Sebastian&amp;rft.au=Kiela%2C+Douwe&amp;rft_id=https%3A%2F%2Fproceedings.neurips.cc%2Fpaper%2F2020%2Fhash%2F6b493230205f780e1bc26945df7481e5-Abstract.html&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-64\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-64\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation web cs1\"><a class=\"external text\" href=\"https://www.kdnuggets.com/the-growth-behind-llmbased-autonomous-agents\" rel=\"nofollow\">\"The Growth Behind LLM-based Autonomous Agents\"</a>. <i>KDnuggets</i>. October 23, 2023.</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=KDnuggets&amp;rft.atitle=The+Growth+Behind+LLM-based+Autonomous+Agents&amp;rft.date=2023-10-23&amp;rft_id=https%3A%2F%2Fwww.kdnuggets.com%2Fthe-growth-behind-llmbased-autonomous-agents&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-DmvNE-65\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-DmvNE_65-0\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation arxiv cs1\" id=\"CITEREFYaoZhaoYuDu2022\">Yao, Shunyu; Zhao, Jeffrey; Yu, Dian; Du, Nan; Shafran, Izhak; Narasimhan, Karthik; Cao, Yuan (2022-10-01). \"ReAct: Synergizing Reasoning and Acting in Language Models\". <a class=\"mw-redirect\" href=\"/wiki/ArXiv_(identifier)\" title=\"ArXiv (identifier)\">arXiv</a>:<span class=\"id-lock-free\" title=\"Freely accessible\"><a class=\"external text\" href=\"https://arxiv.org/abs/2210.03629\" rel=\"nofollow\">2210.03629</a></span> [<a class=\"external text\" href=\"https://arxiv.org/archive/cs.CL\" rel=\"nofollow\">cs.CL</a>].</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=preprint&amp;rft.jtitle=arXiv&amp;rft.atitle=ReAct%3A+Synergizing+Reasoning+and+Acting+in+Language+Models&amp;rft.date=2022-10-01&amp;rft_id=info%3Aarxiv%2F2210.03629&amp;rft.aulast=Yao&amp;rft.aufirst=Shunyu&amp;rft.au=Zhao%2C+Jeffrey&amp;rft.au=Yu%2C+Dian&amp;rft.au=Du%2C+Nan&amp;rft.au=Shafran%2C+Izhak&amp;rft.au=Narasimhan%2C+Karthik&amp;rft.au=Cao%2C+Yuan&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-JS8Vd-66\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-JS8Vd_66-0\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation arxiv cs1\" id=\"CITEREFWuPrabhumoyeMin2023\">Wu, Yue; Prabhumoye, Shrimai; Min, So Yeon (24 May 2023). \"SPRING: GPT-4 Out-performs RL Algorithms by Studying Papers and Reasoning\". <a class=\"mw-redirect\" href=\"/wiki/ArXiv_(identifier)\" title=\"ArXiv (identifier)\">arXiv</a>:<span class=\"id-lock-free\" title=\"Freely accessible\"><a class=\"external text\" href=\"https://arxiv.org/abs/2305.15486\" rel=\"nofollow\">2305.15486</a></span> [<a class=\"external text\" href=\"https://arxiv.org/archive/cs.AI\" rel=\"nofollow\">cs.AI</a>].</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=preprint&amp;rft.jtitle=arXiv&amp;rft.atitle=SPRING%3A+GPT-4+Out-performs+RL+Algorithms+by+Studying+Papers+and+Reasoning&amp;rft.date=2023-05-24&amp;rft_id=info%3Aarxiv%2F2305.15486&amp;rft.aulast=Wu&amp;rft.aufirst=Yue&amp;rft.au=Prabhumoye%2C+Shrimai&amp;rft.au=Min%2C+So+Yeon&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-67\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-67\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation arxiv cs1\" id=\"CITEREFWangCaiLiuMa2023\">Wang, Zihao; Cai, Shaofei; Liu, Anji; Ma, Xiaojian; Liang, Yitao (2023-02-03). \"Describe, Explain, Plan and Select: Interactive Planning with Large Language Models Enables Open-World Multi-Task Agents\". <a class=\"mw-redirect\" href=\"/wiki/ArXiv_(identifier)\" title=\"ArXiv (identifier)\">arXiv</a>:<span class=\"id-lock-free\" title=\"Freely accessible\"><a class=\"external text\" href=\"https://arxiv.org/abs/2302.01560\" rel=\"nofollow\">2302.01560</a></span> [<a class=\"external text\" href=\"https://arxiv.org/archive/cs.AI\" rel=\"nofollow\">cs.AI</a>].</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=preprint&amp;rft.jtitle=arXiv&amp;rft.atitle=Describe%2C+Explain%2C+Plan+and+Select%3A+Interactive+Planning+with+Large+Language+Models+Enables+Open-World+Multi-Task+Agents&amp;rft.date=2023-02-03&amp;rft_id=info%3Aarxiv%2F2302.01560&amp;rft.aulast=Wang&amp;rft.aufirst=Zihao&amp;rft.au=Cai%2C+Shaofei&amp;rft.au=Liu%2C+Anji&amp;rft.au=Ma%2C+Xiaojian&amp;rft.au=Liang%2C+Yitao&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-sbB2T-68\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-sbB2T_68-0\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation arxiv cs1\" id=\"CITEREFShinnCassanoLabashGopinath2023\">Shinn, Noah; Cassano, Federico; Labash, Beck; Gopinath, Ashwin; Narasimhan, Karthik; Yao, Shunyu (2023-03-01). \"Reflexion: Language Agents with Verbal Reinforcement Learning\". <a class=\"mw-redirect\" href=\"/wiki/ArXiv_(identifier)\" title=\"ArXiv (identifier)\">arXiv</a>:<span class=\"id-lock-free\" title=\"Freely accessible\"><a class=\"external text\" href=\"https://arxiv.org/abs/2303.11366\" rel=\"nofollow\">2303.11366</a></span> [<a class=\"external text\" href=\"https://arxiv.org/archive/cs.AI\" rel=\"nofollow\">cs.AI</a>].</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=preprint&amp;rft.jtitle=arXiv&amp;rft.atitle=Reflexion%3A+Language+Agents+with+Verbal+Reinforcement+Learning&amp;rft.date=2023-03-01&amp;rft_id=info%3Aarxiv%2F2303.11366&amp;rft.aulast=Shinn&amp;rft.aufirst=Noah&amp;rft.au=Cassano%2C+Federico&amp;rft.au=Labash%2C+Beck&amp;rft.au=Gopinath%2C+Ashwin&amp;rft.au=Narasimhan%2C+Karthik&amp;rft.au=Yao%2C+Shunyu&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-ltTer-69\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-ltTer_69-0\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation arxiv cs1\" id=\"CITEREFHaoGuMaJiahua_Hong2023\">Hao, Shibo; Gu, Yi; Ma, Haodi; Jiahua Hong, Joshua; Wang, Zhen; Zhe Wang, Daisy; Hu, Zhiting (2023-05-01). \"Reasoning with Language Model is Planning with World Model\". <a class=\"mw-redirect\" href=\"/wiki/ArXiv_(identifier)\" title=\"ArXiv (identifier)\">arXiv</a>:<span class=\"id-lock-free\" title=\"Freely accessible\"><a class=\"external text\" href=\"https://arxiv.org/abs/2305.14992\" rel=\"nofollow\">2305.14992</a></span> [<a class=\"external text\" href=\"https://arxiv.org/archive/cs.CL\" rel=\"nofollow\">cs.CL</a>].</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=preprint&amp;rft.jtitle=arXiv&amp;rft.atitle=Reasoning+with+Language+Model+is+Planning+with+World+Model&amp;rft.date=2023-05-01&amp;rft_id=info%3Aarxiv%2F2305.14992&amp;rft.aulast=Hao&amp;rft.aufirst=Shibo&amp;rft.au=Gu%2C+Yi&amp;rft.au=Ma%2C+Haodi&amp;rft.au=Jiahua+Hong%2C+Joshua&amp;rft.au=Wang%2C+Zhen&amp;rft.au=Zhe+Wang%2C+Daisy&amp;rft.au=Hu%2C+Zhiting&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-mBvD9-70\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-mBvD9_70-0\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation arxiv cs1\" id=\"CITEREFZhangLehmanStanleyClune2023\">Zhang, Jenny; Lehman, Joel; Stanley, Kenneth; Clune, Jeff (2 June 2023). \"OMNI: Open-endedness via Models of human Notions of Interestingness\". <a class=\"mw-redirect\" href=\"/wiki/ArXiv_(identifier)\" title=\"ArXiv (identifier)\">arXiv</a>:<span class=\"id-lock-free\" title=\"Freely accessible\"><a class=\"external text\" href=\"https://arxiv.org/abs/2306.01711\" rel=\"nofollow\">2306.01711</a></span> [<a class=\"external text\" href=\"https://arxiv.org/archive/cs.AI\" rel=\"nofollow\">cs.AI</a>].</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=preprint&amp;rft.jtitle=arXiv&amp;rft.atitle=OMNI%3A+Open-endedness+via+Models+of+human+Notions+of+Interestingness&amp;rft.date=2023-06-02&amp;rft_id=info%3Aarxiv%2F2306.01711&amp;rft.aulast=Zhang&amp;rft.aufirst=Jenny&amp;rft.au=Lehman%2C+Joel&amp;rft.au=Stanley%2C+Kenneth&amp;rft.au=Clune%2C+Jeff&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-:0-71\"><span class=\"mw-cite-backlink\">^ <a href=\"#cite_ref-:0_71-0\"><sup><i><b>a</b></i></sup></a> <a href=\"#cite_ref-:0_71-1\"><sup><i><b>b</b></i></sup></a></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation web cs1\"><a class=\"external text\" href=\"https://voyager.minedojo.org/\" rel=\"nofollow\">\"Voyager | An Open-Ended Embodied Agent with Large Language Models\"</a>. <i>voyager.minedojo.org</i>. <a class=\"external text\" href=\"https://web.archive.org/web/20230608225054/https://voyager.minedojo.org/\" rel=\"nofollow\">Archived</a> from the original on 2023-06-08<span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">2023-06-09</span></span>.</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=voyager.minedojo.org&amp;rft.atitle=Voyager+%7C+An+Open-Ended+Embodied+Agent+with+Large+Language+Models&amp;rft_id=https%3A%2F%2Fvoyager.minedojo.org%2F&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-XuvjF-72\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-XuvjF_72-0\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation arxiv cs1\" id=\"CITEREFParkO'BrienCaiRingel_Morris2023\">Park, Joon Sung; O'Brien, Joseph C.; Cai, Carrie J.; Ringel Morris, Meredith; Liang, Percy; Bernstein, Michael S. (2023-04-01). \"Generative Agents: Interactive Simulacra of Human Behavior\". <a class=\"mw-redirect\" href=\"/wiki/ArXiv_(identifier)\" title=\"ArXiv (identifier)\">arXiv</a>:<span class=\"id-lock-free\" title=\"Freely accessible\"><a class=\"external text\" href=\"https://arxiv.org/abs/2304.03442\" rel=\"nofollow\">2304.03442</a></span> [<a class=\"external text\" href=\"https://arxiv.org/archive/cs.HC\" rel=\"nofollow\">cs.HC</a>].</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=preprint&amp;rft.jtitle=arXiv&amp;rft.atitle=Generative+Agents%3A+Interactive+Simulacra+of+Human+Behavior&amp;rft.date=2023-04-01&amp;rft_id=info%3Aarxiv%2F2304.03442&amp;rft.aulast=Park&amp;rft.aufirst=Joon+Sung&amp;rft.au=O%27Brien%2C+Joseph+C.&amp;rft.au=Cai%2C+Carrie+J.&amp;rft.au=Ringel+Morris%2C+Meredith&amp;rft.au=Liang%2C+Percy&amp;rft.au=Bernstein%2C+Michael+S.&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-73\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-73\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation web cs1\" id=\"CITEREFMann\">Mann, Tobias. <a class=\"external text\" href=\"https://www.theregister.com/2024/03/17/ai_pc_local_llm/\" rel=\"nofollow\">\"How to run an LLM locally on your PC in less than 10 minutes\"</a>. <i>www.theregister.com</i><span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">2024-05-17</span></span>.</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=www.theregister.com&amp;rft.atitle=How+to+run+an+LLM+locally+on+your+PC+in+less+than+10+minutes&amp;rft.aulast=Mann&amp;rft.aufirst=Tobias&amp;rft_id=https%3A%2F%2Fwww.theregister.com%2F2024%2F03%2F17%2Fai_pc_local_llm%2F&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-LS2Go-74\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-LS2Go_74-0\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation journal cs1\" id=\"CITEREFNagelAmjadBaalenLouizos2020\">Nagel, Markus; Amjad, Rana Ali; Baalen, Mart Van; Louizos, Christos; Blankevoort, Tijmen (2020-11-21). <a class=\"external text\" href=\"https://proceedings.mlr.press/v119/nagel20a.html\" rel=\"nofollow\">\"Up or Down? Adaptive Rounding for Post-Training Quantization\"</a>. <i>Proceedings of the 37th International Conference on Machine Learning</i>. PMLR: 7197–7206. <a class=\"external text\" href=\"https://web.archive.org/web/20230614080854/https://proceedings.mlr.press/v119/nagel20a.html\" rel=\"nofollow\">Archived</a> from the original on 2023-06-14<span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">2023-06-14</span></span>.</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=Proceedings+of+the+37th+International+Conference+on+Machine+Learning&amp;rft.atitle=Up+or+Down%3F+Adaptive+Rounding+for+Post-Training+Quantization&amp;rft.pages=7197-7206&amp;rft.date=2020-11-21&amp;rft.aulast=Nagel&amp;rft.aufirst=Markus&amp;rft.au=Amjad%2C+Rana+Ali&amp;rft.au=Baalen%2C+Mart+Van&amp;rft.au=Louizos%2C+Christos&amp;rft.au=Blankevoort%2C+Tijmen&amp;rft_id=https%3A%2F%2Fproceedings.mlr.press%2Fv119%2Fnagel20a.html&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-cpzcK-75\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-cpzcK_75-0\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation arxiv cs1\" id=\"CITEREFPolinoPascanuAlistarh2018\">Polino, Antonio; Pascanu, Razvan; Alistarh, Dan (2018-02-01). \"Model compression via distillation and quantization\". <a class=\"mw-redirect\" href=\"/wiki/ArXiv_(identifier)\" title=\"ArXiv (identifier)\">arXiv</a>:<span class=\"id-lock-free\" title=\"Freely accessible\"><a class=\"external text\" href=\"https://arxiv.org/abs/1802.05668\" rel=\"nofollow\">1802.05668</a></span> [<a class=\"external text\" href=\"https://arxiv.org/archive/cs.NE\" rel=\"nofollow\">cs.NE</a>].</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=preprint&amp;rft.jtitle=arXiv&amp;rft.atitle=Model+compression+via+distillation+and+quantization&amp;rft.date=2018-02-01&amp;rft_id=info%3Aarxiv%2F1802.05668&amp;rft.aulast=Polino&amp;rft.aufirst=Antonio&amp;rft.au=Pascanu%2C+Razvan&amp;rft.au=Alistarh%2C+Dan&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-QVU95-76\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-QVU95_76-0\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation arxiv cs1\" id=\"CITEREFFrantarAshkboosHoeflerAlistarh2022\">Frantar, Elias; Ashkboos, Saleh; Hoefler, Torsten; Alistarh, Dan (2022-10-01). \"GPTQ: Accurate Post-Training Quantization for Generative Pre-trained Transformers\". <a class=\"mw-redirect\" href=\"/wiki/ArXiv_(identifier)\" title=\"ArXiv (identifier)\">arXiv</a>:<span class=\"id-lock-free\" title=\"Freely accessible\"><a class=\"external text\" href=\"https://arxiv.org/abs/2210.17323\" rel=\"nofollow\">2210.17323</a></span> [<a class=\"external text\" href=\"https://arxiv.org/archive/cs.LG\" rel=\"nofollow\">cs.LG</a>].</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=preprint&amp;rft.jtitle=arXiv&amp;rft.atitle=GPTQ%3A+Accurate+Post-Training+Quantization+for+Generative+Pre-trained+Transformers&amp;rft.date=2022-10-01&amp;rft_id=info%3Aarxiv%2F2210.17323&amp;rft.aulast=Frantar&amp;rft.aufirst=Elias&amp;rft.au=Ashkboos%2C+Saleh&amp;rft.au=Hoefler%2C+Torsten&amp;rft.au=Alistarh%2C+Dan&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-dU9Bu-77\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-dU9Bu_77-0\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation arxiv cs1\" id=\"CITEREFDettmersSvirschevskiEgiazarianKuznedelev2023\">Dettmers, Tim; Svirschevski, Ruslan; Egiazarian, Vage; Kuznedelev, Denis; Frantar, Elias; Ashkboos, Saleh; Borzunov, Alexander; Hoefler, Torsten; Alistarh, Dan (2023-06-01). \"SpQR: A Sparse-Quantized Representation for Near-Lossless LLM Weight Compression\". <a class=\"mw-redirect\" href=\"/wiki/ArXiv_(identifier)\" title=\"ArXiv (identifier)\">arXiv</a>:<span class=\"id-lock-free\" title=\"Freely accessible\"><a class=\"external text\" href=\"https://arxiv.org/abs/2306.03078\" rel=\"nofollow\">2306.03078</a></span> [<a class=\"external text\" href=\"https://arxiv.org/archive/cs.CL\" rel=\"nofollow\">cs.CL</a>].</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=preprint&amp;rft.jtitle=arXiv&amp;rft.atitle=SpQR%3A+A+Sparse-Quantized+Representation+for+Near-Lossless+LLM+Weight+Compression&amp;rft.date=2023-06-01&amp;rft_id=info%3Aarxiv%2F2306.03078&amp;rft.aulast=Dettmers&amp;rft.aufirst=Tim&amp;rft.au=Svirschevski%2C+Ruslan&amp;rft.au=Egiazarian%2C+Vage&amp;rft.au=Kuznedelev%2C+Denis&amp;rft.au=Frantar%2C+Elias&amp;rft.au=Ashkboos%2C+Saleh&amp;rft.au=Borzunov%2C+Alexander&amp;rft.au=Hoefler%2C+Torsten&amp;rft.au=Alistarh%2C+Dan&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-78\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-78\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation web cs1\" id=\"CITEREFGrootendorst\">Grootendorst, Maarten. <a class=\"external text\" href=\"https://web.archive.org/web/20240731003355/https://newsletter.maartengrootendorst.com/p/a-visual-guide-to-quantization\" rel=\"nofollow\">\"A Visual Guide to Quantization\"</a>. <i>newsletter.maartengrootendorst.com</i>. Archived from <a class=\"external text\" href=\"https://newsletter.maartengrootendorst.com/p/a-visual-guide-to-quantization\" rel=\"nofollow\">the original</a> on 31 Jul 2024<span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">2024-07-31</span></span>.</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=newsletter.maartengrootendorst.com&amp;rft.atitle=A+Visual+Guide+to+Quantization&amp;rft.aulast=Grootendorst&amp;rft.aufirst=Maarten&amp;rft_id=https%3A%2F%2Fnewsletter.maartengrootendorst.com%2Fp%2Fa-visual-guide-to-quantization&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-D0nFA-79\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-D0nFA_79-0\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation arxiv cs1\" id=\"CITEREFDettmersPagnoniHoltzmanZettlemoyer2023\">Dettmers, Tim; Pagnoni, Artidoro; <a href=\"/wiki/Ari_Holtzman\" title=\"Ari Holtzman\">Holtzman, Ari</a>; Zettlemoyer, Luke (2023-05-01). \"QLoRA: Efficient Finetuning of Quantized LLMs\". <a class=\"mw-redirect\" href=\"/wiki/ArXiv_(identifier)\" title=\"ArXiv (identifier)\">arXiv</a>:<span class=\"id-lock-free\" title=\"Freely accessible\"><a class=\"external text\" href=\"https://arxiv.org/abs/2305.14314\" rel=\"nofollow\">2305.14314</a></span> [<a class=\"external text\" href=\"https://arxiv.org/archive/cs.LG\" rel=\"nofollow\">cs.LG</a>].</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=preprint&amp;rft.jtitle=arXiv&amp;rft.atitle=QLoRA%3A+Efficient+Finetuning+of+Quantized+LLMs&amp;rft.date=2023-05-01&amp;rft_id=info%3Aarxiv%2F2305.14314&amp;rft.aulast=Dettmers&amp;rft.aufirst=Tim&amp;rft.au=Pagnoni%2C+Artidoro&amp;rft.au=Holtzman%2C+Ari&amp;rft.au=Zettlemoyer%2C+Luke&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-80\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-80\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation journal cs1\" id=\"CITEREFKirosSalakhutdinovZemel2014\">Kiros, Ryan; Salakhutdinov, Ruslan; Zemel, Rich (2014-06-18). <a class=\"external text\" href=\"https://proceedings.mlr.press/v32/kiros14.html\" rel=\"nofollow\">\"Multimodal Neural Language Models\"</a>. <i>Proceedings of the 31st International Conference on Machine Learning</i>. PMLR: 595–603. <a class=\"external text\" href=\"https://web.archive.org/web/20230702195952/https://proceedings.mlr.press/v32/kiros14.html\" rel=\"nofollow\">Archived</a> from the original on 2023-07-02<span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">2023-07-02</span></span>.</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=Proceedings+of+the+31st+International+Conference+on+Machine+Learning&amp;rft.atitle=Multimodal+Neural+Language+Models&amp;rft.pages=595-603&amp;rft.date=2014-06-18&amp;rft.aulast=Kiros&amp;rft.aufirst=Ryan&amp;rft.au=Salakhutdinov%2C+Ruslan&amp;rft.au=Zemel%2C+Rich&amp;rft_id=https%3A%2F%2Fproceedings.mlr.press%2Fv32%2Fkiros14.html&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-81\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-81\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation journal cs1\" id=\"CITEREFKrizhevskySutskeverHinton2012\">Krizhevsky, Alex; Sutskever, Ilya; Hinton, Geoffrey E (2012). <a class=\"external text\" href=\"https://proceedings.neurips.cc/paper/2012/hash/c399862d3b9d6b76c8436e924a68c45b-Abstract.html\" rel=\"nofollow\">\"ImageNet Classification with Deep Convolutional Neural Networks\"</a>. <i>Advances in Neural Information Processing Systems</i>. <b>25</b>. Curran Associates, Inc. <a class=\"external text\" href=\"https://web.archive.org/web/20230702195952/https://proceedings.neurips.cc/paper/2012/hash/c399862d3b9d6b76c8436e924a68c45b-Abstract.html\" rel=\"nofollow\">Archived</a> from the original on 2023-07-02<span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">2023-07-02</span></span>.</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=Advances+in+Neural+Information+Processing+Systems&amp;rft.atitle=ImageNet+Classification+with+Deep+Convolutional+Neural+Networks&amp;rft.volume=25&amp;rft.date=2012&amp;rft.aulast=Krizhevsky&amp;rft.aufirst=Alex&amp;rft.au=Sutskever%2C+Ilya&amp;rft.au=Hinton%2C+Geoffrey+E&amp;rft_id=https%3A%2F%2Fproceedings.neurips.cc%2Fpaper%2F2012%2Fhash%2Fc399862d3b9d6b76c8436e924a68c45b-Abstract.html&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-82\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-82\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation journal cs1\" id=\"CITEREFAntolAgrawalLuMitchell2015\">Antol, Stanislaw; Agrawal, Aishwarya; Lu, Jiasen; Mitchell, Margaret; Batra, Dhruv; Zitnick, C. Lawrence; Parikh, Devi (2015). <a class=\"external text\" href=\"https://openaccess.thecvf.com/content_iccv_2015/html/Antol_VQA_Visual_Question_ICCV_2015_paper.html\" rel=\"nofollow\">\"VQA: Visual Question Answering\"</a>. <i>ICCV</i>: 2425–2433. <a class=\"external text\" href=\"https://web.archive.org/web/20230702195952/https://openaccess.thecvf.com/content_iccv_2015/html/Antol_VQA_Visual_Question_ICCV_2015_paper.html\" rel=\"nofollow\">Archived</a> from the original on 2023-07-02<span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">2023-07-02</span></span>.</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=ICCV&amp;rft.atitle=VQA%3A+Visual+Question+Answering&amp;rft.pages=2425-2433&amp;rft.date=2015&amp;rft.aulast=Antol&amp;rft.aufirst=Stanislaw&amp;rft.au=Agrawal%2C+Aishwarya&amp;rft.au=Lu%2C+Jiasen&amp;rft.au=Mitchell%2C+Margaret&amp;rft.au=Batra%2C+Dhruv&amp;rft.au=Zitnick%2C+C.+Lawrence&amp;rft.au=Parikh%2C+Devi&amp;rft_id=https%3A%2F%2Fopenaccess.thecvf.com%2Fcontent_iccv_2015%2Fhtml%2FAntol_VQA_Visual_Question_ICCV_2015_paper.html&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-83\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-83\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation arxiv cs1\" id=\"CITEREFLiLiSavareseHoi2023\">Li, Junnan; Li, Dongxu; Savarese, Silvio; Hoi, Steven (2023-01-01). \"BLIP-2: Bootstrapping Language-Image Pre-training with Frozen Image Encoders and Large Language Models\". <a class=\"mw-redirect\" href=\"/wiki/ArXiv_(identifier)\" title=\"ArXiv (identifier)\">arXiv</a>:<span class=\"id-lock-free\" title=\"Freely accessible\"><a class=\"external text\" href=\"https://arxiv.org/abs/2301.12597\" rel=\"nofollow\">2301.12597</a></span> [<a class=\"external text\" href=\"https://arxiv.org/archive/cs.CV\" rel=\"nofollow\">cs.CV</a>].</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=preprint&amp;rft.jtitle=arXiv&amp;rft.atitle=BLIP-2%3A+Bootstrapping+Language-Image+Pre-training+with+Frozen+Image+Encoders+and+Large+Language+Models&amp;rft.date=2023-01-01&amp;rft_id=info%3Aarxiv%2F2301.12597&amp;rft.aulast=Li&amp;rft.aufirst=Junnan&amp;rft.au=Li%2C+Dongxu&amp;rft.au=Savarese%2C+Silvio&amp;rft.au=Hoi%2C+Steven&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-84\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-84\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation journal cs1\" id=\"CITEREFAlayracDonahueLucMiech2022\">Alayrac, Jean-Baptiste; Donahue, Jeff; Luc, Pauline; Miech, Antoine; Barr, Iain; Hasson, Yana; Lenc, Karel; Mensch, Arthur; Millican, Katherine; Reynolds, Malcolm; Ring, Roman; Rutherford, Eliza; Cabi, Serkan; Han, Tengda; Gong, Zhitao (2022-12-06). <a class=\"external text\" href=\"https://proceedings.neurips.cc/paper_files/paper/2022/hash/960a172bc7fbf0177ccccbb411a7d800-Abstract-Conference.html\" rel=\"nofollow\">\"Flamingo: a Visual Language Model for Few-Shot Learning\"</a>. <i>Advances in Neural Information Processing Systems</i>. <b>35</b>: 23716–23736. <a class=\"mw-redirect\" href=\"/wiki/ArXiv_(identifier)\" title=\"ArXiv (identifier)\">arXiv</a>:<span class=\"id-lock-free\" title=\"Freely accessible\"><a class=\"external text\" href=\"https://arxiv.org/abs/2204.14198\" rel=\"nofollow\">2204.14198</a></span>. <a class=\"external text\" href=\"https://web.archive.org/web/20230702195951/https://proceedings.neurips.cc/paper_files/paper/2022/hash/960a172bc7fbf0177ccccbb411a7d800-Abstract-Conference.html\" rel=\"nofollow\">Archived</a> from the original on 2023-07-02<span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">2023-07-02</span></span>.</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=Advances+in+Neural+Information+Processing+Systems&amp;rft.atitle=Flamingo%3A+a+Visual+Language+Model+for+Few-Shot+Learning&amp;rft.volume=35&amp;rft.pages=23716-23736&amp;rft.date=2022-12-06&amp;rft_id=info%3Aarxiv%2F2204.14198&amp;rft.aulast=Alayrac&amp;rft.aufirst=Jean-Baptiste&amp;rft.au=Donahue%2C+Jeff&amp;rft.au=Luc%2C+Pauline&amp;rft.au=Miech%2C+Antoine&amp;rft.au=Barr%2C+Iain&amp;rft.au=Hasson%2C+Yana&amp;rft.au=Lenc%2C+Karel&amp;rft.au=Mensch%2C+Arthur&amp;rft.au=Millican%2C+Katherine&amp;rft.au=Reynolds%2C+Malcolm&amp;rft.au=Ring%2C+Roman&amp;rft.au=Rutherford%2C+Eliza&amp;rft.au=Cabi%2C+Serkan&amp;rft.au=Han%2C+Tengda&amp;rft.au=Gong%2C+Zhitao&amp;rft_id=https%3A%2F%2Fproceedings.neurips.cc%2Fpaper_files%2Fpaper%2F2022%2Fhash%2F960a172bc7fbf0177ccccbb411a7d800-Abstract-Conference.html&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-85\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-85\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation arxiv cs1\" id=\"CITEREFDriessXiaSajjadiLynch2023\">Driess, Danny; Xia, Fei; Sajjadi, Mehdi S. M.; Lynch, Corey; Chowdhery, Aakanksha; Ichter, Brian; Wahid, Ayzaan; Tompson, Jonathan; Vuong, Quan; Yu, Tianhe; Huang, Wenlong; Chebotar, Yevgen; Sermanet, Pierre; Duckworth, Daniel; Levine, Sergey (2023-03-01). \"PaLM-E: An Embodied Multimodal Language Model\". <a class=\"mw-redirect\" href=\"/wiki/ArXiv_(identifier)\" title=\"ArXiv (identifier)\">arXiv</a>:<span class=\"id-lock-free\" title=\"Freely accessible\"><a class=\"external text\" href=\"https://arxiv.org/abs/2303.03378\" rel=\"nofollow\">2303.03378</a></span> [<a class=\"external text\" href=\"https://arxiv.org/archive/cs.LG\" rel=\"nofollow\">cs.LG</a>].</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=preprint&amp;rft.jtitle=arXiv&amp;rft.atitle=PaLM-E%3A+An+Embodied+Multimodal+Language+Model&amp;rft.date=2023-03-01&amp;rft_id=info%3Aarxiv%2F2303.03378&amp;rft.aulast=Driess&amp;rft.aufirst=Danny&amp;rft.au=Xia%2C+Fei&amp;rft.au=Sajjadi%2C+Mehdi+S.+M.&amp;rft.au=Lynch%2C+Corey&amp;rft.au=Chowdhery%2C+Aakanksha&amp;rft.au=Ichter%2C+Brian&amp;rft.au=Wahid%2C+Ayzaan&amp;rft.au=Tompson%2C+Jonathan&amp;rft.au=Vuong%2C+Quan&amp;rft.au=Yu%2C+Tianhe&amp;rft.au=Huang%2C+Wenlong&amp;rft.au=Chebotar%2C+Yevgen&amp;rft.au=Sermanet%2C+Pierre&amp;rft.au=Duckworth%2C+Daniel&amp;rft.au=Levine%2C+Sergey&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-86\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-86\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation arxiv cs1\" id=\"CITEREFLiuLiWuLee2023\">Liu, Haotian; Li, Chunyuan; Wu, Qingyang; Lee, Yong Jae (2023-04-01). \"Visual Instruction Tuning\". <a class=\"mw-redirect\" href=\"/wiki/ArXiv_(identifier)\" title=\"ArXiv (identifier)\">arXiv</a>:<span class=\"id-lock-free\" title=\"Freely accessible\"><a class=\"external text\" href=\"https://arxiv.org/abs/2304.08485\" rel=\"nofollow\">2304.08485</a></span> [<a class=\"external text\" href=\"https://arxiv.org/archive/cs.CV\" rel=\"nofollow\">cs.CV</a>].</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=preprint&amp;rft.jtitle=arXiv&amp;rft.atitle=Visual+Instruction+Tuning&amp;rft.date=2023-04-01&amp;rft_id=info%3Aarxiv%2F2304.08485&amp;rft.aulast=Liu&amp;rft.aufirst=Haotian&amp;rft.au=Li%2C+Chunyuan&amp;rft.au=Wu%2C+Qingyang&amp;rft.au=Lee%2C+Yong+Jae&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-87\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-87\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation arxiv cs1\" id=\"CITEREFZhangLiBing2023\">Zhang, Hang; Li, Xin; Bing, Lidong (2023-06-01). \"Video-LLaMA: An Instruction-tuned Audio-Visual Language Model for Video Understanding\". <a class=\"mw-redirect\" href=\"/wiki/ArXiv_(identifier)\" title=\"ArXiv (identifier)\">arXiv</a>:<span class=\"id-lock-free\" title=\"Freely accessible\"><a class=\"external text\" href=\"https://arxiv.org/abs/2306.02858\" rel=\"nofollow\">2306.02858</a></span> [<a class=\"external text\" href=\"https://arxiv.org/archive/cs.CL\" rel=\"nofollow\">cs.CL</a>].</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=preprint&amp;rft.jtitle=arXiv&amp;rft.atitle=Video-LLaMA%3A+An+Instruction-tuned+Audio-Visual+Language+Model+for+Video+Understanding&amp;rft.date=2023-06-01&amp;rft_id=info%3Aarxiv%2F2306.02858&amp;rft.aulast=Zhang&amp;rft.aufirst=Hang&amp;rft.au=Li%2C+Xin&amp;rft.au=Bing%2C+Lidong&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-88\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-88\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation arxiv cs1\" id=\"CITEREFOpenAI2023\">OpenAI (2023-03-27). \"GPT-4 Technical Report\". <a class=\"mw-redirect\" href=\"/wiki/ArXiv_(identifier)\" title=\"ArXiv (identifier)\">arXiv</a>:<span class=\"id-lock-free\" title=\"Freely accessible\"><a class=\"external text\" href=\"https://arxiv.org/abs/2303.08774\" rel=\"nofollow\">2303.08774</a></span> [<a class=\"external text\" href=\"https://arxiv.org/archive/cs.CL\" rel=\"nofollow\">cs.CL</a>].</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=preprint&amp;rft.jtitle=arXiv&amp;rft.atitle=GPT-4+Technical+Report&amp;rft.date=2023-03-27&amp;rft_id=info%3Aarxiv%2F2303.08774&amp;rft.au=OpenAI&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-89\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-89\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation web cs1\" id=\"CITEREFOpenAI2023\">OpenAI (September 25, 2023). <a class=\"external text\" href=\"https://cdn.openai.com/papers/GPTV_System_Card.pdf\" rel=\"nofollow\">\"GPT-4V(ision) System Card\"</a> <span class=\"cs1-format\">(PDF)</span>.</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=GPT-4V%28ision%29+System+Card&amp;rft.date=2023-09-25&amp;rft.au=OpenAI&amp;rft_id=https%3A%2F%2Fcdn.openai.com%2Fpapers%2FGPTV_System_Card.pdf&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-90\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-90\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation cs2\" id=\"CITEREFPichai2023\">Pichai, Sundar (10 May 2023), <a class=\"external text\" href=\"https://www.youtube.com/watch?v=cNfINi5CNbY&amp;t=931s\" rel=\"nofollow\"><i>Google Keynote (Google I/O '23)</i></a>, timestamp 15:31<span class=\"reference-accessdate\">, retrieved <span class=\"nowrap\">2023-07-02</span></span></cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=book&amp;rft.btitle=Google+Keynote+%28Google+I%2FO+%2723%29&amp;rft.pages=timestamp+15%3A31&amp;rft.date=2023-05-10&amp;rft.aulast=Pichai&amp;rft.aufirst=Sundar&amp;rft_id=https%3A%2F%2Fwww.youtube.com%2Fwatch%3Fv%3DcNfINi5CNbY%26t%3D931s&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-91\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-91\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation web cs1\" id=\"CITEREFWiggers2024\">Wiggers, Kyle (11 September 2024). <a class=\"external text\" href=\"https://techcrunch.com/2024/09/11/mistral-releases-pixtral-its-first-multimodal-model/?utm_medium=aisecret.us&amp;utm_source=aisecret.us&amp;utm_campaign=aisecret.us\" rel=\"nofollow\">\"Mistral releases Pixtral 12B, its first multimodal model\"</a>. <i>TechCrunch</i><span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">14 September</span> 2024</span>.</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=TechCrunch&amp;rft.atitle=Mistral+releases+Pixtral+12B%2C+its+first+multimodal+model&amp;rft.date=2024-09-11&amp;rft.aulast=Wiggers&amp;rft.aufirst=Kyle&amp;rft_id=https%3A%2F%2Ftechcrunch.com%2F2024%2F09%2F11%2Fmistral-releases-pixtral-its-first-multimodal-model%2F%3Futm_medium%3Daisecret.us%26utm_source%3Daisecret.us%26utm_campaign%3Daisecret.us&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-fJta3-92\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-fJta3_92-0\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation arxiv cs1\" id=\"CITEREFHoffmannBorgeaudMenschBuchatskaya2022\">Hoffmann, Jordan; Borgeaud, Sebastian; Mensch, Arthur; Buchatskaya, Elena; Cai, Trevor; Rutherford, Eliza; Casas, Diego de Las; Hendricks, Lisa Anne; Welbl, Johannes; Clark, Aidan; Hennigan, Tom; Noland, Eric; Millican, Katie; Driessche, George van den; Damoc, Bogdan (2022-03-29). \"Training Compute-Optimal Large Language Models\". <a class=\"mw-redirect\" href=\"/wiki/ArXiv_(identifier)\" title=\"ArXiv (identifier)\">arXiv</a>:<span class=\"id-lock-free\" title=\"Freely accessible\"><a class=\"external text\" href=\"https://arxiv.org/abs/2203.15556\" rel=\"nofollow\">2203.15556</a></span> [<a class=\"external text\" href=\"https://arxiv.org/archive/cs.CL\" rel=\"nofollow\">cs.CL</a>].</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=preprint&amp;rft.jtitle=arXiv&amp;rft.atitle=Training+Compute-Optimal+Large+Language+Models&amp;rft.date=2022-03-29&amp;rft_id=info%3Aarxiv%2F2203.15556&amp;rft.aulast=Hoffmann&amp;rft.aufirst=Jordan&amp;rft.au=Borgeaud%2C+Sebastian&amp;rft.au=Mensch%2C+Arthur&amp;rft.au=Buchatskaya%2C+Elena&amp;rft.au=Cai%2C+Trevor&amp;rft.au=Rutherford%2C+Eliza&amp;rft.au=Casas%2C+Diego+de+Las&amp;rft.au=Hendricks%2C+Lisa+Anne&amp;rft.au=Welbl%2C+Johannes&amp;rft.au=Clark%2C+Aidan&amp;rft.au=Hennigan%2C+Tom&amp;rft.au=Noland%2C+Eric&amp;rft.au=Millican%2C+Katie&amp;rft.au=Driessche%2C+George+van+den&amp;rft.au=Damoc%2C+Bogdan&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-IYm4Q-93\"><span class=\"mw-cite-backlink\">^ <a href=\"#cite_ref-IYm4Q_93-0\"><sup><i><b>a</b></i></sup></a> <a href=\"#cite_ref-IYm4Q_93-1\"><sup><i><b>b</b></i></sup></a></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation arxiv cs1\" id=\"CITEREFCaballeroGuptaRishKrueger2022\">Caballero, Ethan; Gupta, Kshitij; Rish, Irina; Krueger, David (2022). \"Broken Neural Scaling Laws\". <a class=\"mw-redirect\" href=\"/wiki/ArXiv_(identifier)\" title=\"ArXiv (identifier)\">arXiv</a>:<span class=\"id-lock-free\" title=\"Freely accessible\"><a class=\"external text\" href=\"https://arxiv.org/abs/2210.14891\" rel=\"nofollow\">2210.14891</a></span> [<a class=\"external text\" href=\"https://arxiv.org/archive/cs.LG\" rel=\"nofollow\">cs.LG</a>].</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=preprint&amp;rft.jtitle=arXiv&amp;rft.atitle=Broken+Neural+Scaling+Laws&amp;rft.date=2022&amp;rft_id=info%3Aarxiv%2F2210.14891&amp;rft.aulast=Caballero&amp;rft.aufirst=Ethan&amp;rft.au=Gupta%2C+Kshitij&amp;rft.au=Rish%2C+Irina&amp;rft.au=Krueger%2C+David&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-JM6s1-94\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-JM6s1_94-0\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation web cs1\"><a class=\"external text\" href=\"https://www.jasonwei.net/blog/emergence\" rel=\"nofollow\">\"137 emergent abilities of large language models\"</a>. <i>Jason Wei</i><span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">2023-06-24</span></span>.</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=Jason+Wei&amp;rft.atitle=137+emergent+abilities+of+large+language+models&amp;rft_id=https%3A%2F%2Fwww.jasonwei.net%2Fblog%2Femergence&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-Bowman-95\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-Bowman_95-0\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation arxiv cs1\" id=\"CITEREFBowman2023\">Bowman, Samuel R. (2023). \"Eight Things to Know about Large Language Models\". <a class=\"mw-redirect\" href=\"/wiki/ArXiv_(identifier)\" title=\"ArXiv (identifier)\">arXiv</a>:<span class=\"id-lock-free\" title=\"Freely accessible\"><a class=\"external text\" href=\"https://arxiv.org/abs/2304.00612\" rel=\"nofollow\">2304.00612</a></span> [<a class=\"external text\" href=\"https://arxiv.org/archive/cs.CL\" rel=\"nofollow\">cs.CL</a>].</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=preprint&amp;rft.jtitle=arXiv&amp;rft.atitle=Eight+Things+to+Know+about+Large+Language+Models&amp;rft.date=2023&amp;rft_id=info%3Aarxiv%2F2304.00612&amp;rft.aulast=Bowman&amp;rft.aufirst=Samuel+R.&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-Heuristic-Mukherjee-96\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-Heuristic-Mukherjee_96-0\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation arxiv cs1\" id=\"CITEREFMukherjeeChang2024\">Mukherjee, Anirban; Chang, Hannah (2024). \"Heuristic Reasoning in AI: Instrumental Use and Mimetic Absorption\". <a class=\"mw-redirect\" href=\"/wiki/ArXiv_(identifier)\" title=\"ArXiv (identifier)\">arXiv</a>:<span class=\"id-lock-free\" title=\"Freely accessible\"><a class=\"external text\" href=\"https://arxiv.org/abs/2403.09404\" rel=\"nofollow\">2403.09404</a></span> [<a class=\"external text\" href=\"https://arxiv.org/archive/cs.AI\" rel=\"nofollow\">cs.AI</a>].</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=preprint&amp;rft.jtitle=arXiv&amp;rft.atitle=Heuristic+Reasoning+in+AI%3A+Instrumental+Use+and+Mimetic+Absorption&amp;rft.date=2024&amp;rft_id=info%3Aarxiv%2F2403.09404&amp;rft.aulast=Mukherjee&amp;rft.aufirst=Anirban&amp;rft.au=Chang%2C+Hannah&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-Hahn_20230314-97\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-Hahn_20230314_97-0\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation arxiv cs1\" id=\"CITEREFHahnGoyal2023\">Hahn, Michael; Goyal, Navin (2023-03-14). \"A Theory of Emergent In-Context Learning as Implicit Structure Induction\". <a class=\"mw-redirect\" href=\"/wiki/ArXiv_(identifier)\" title=\"ArXiv (identifier)\">arXiv</a>:<span class=\"id-lock-free\" title=\"Freely accessible\"><a class=\"external text\" href=\"https://arxiv.org/abs/2303.07971\" rel=\"nofollow\">2303.07971</a></span> [<a class=\"external text\" href=\"https://arxiv.org/archive/cs.LG\" rel=\"nofollow\">cs.LG</a>].</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=preprint&amp;rft.jtitle=arXiv&amp;rft.atitle=A+Theory+of+Emergent+In-Context+Learning+as+Implicit+Structure+Induction&amp;rft.date=2023-03-14&amp;rft_id=info%3Aarxiv%2F2303.07971&amp;rft.aulast=Hahn&amp;rft.aufirst=Michael&amp;rft.au=Goyal%2C+Navin&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-57FEA-98\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-57FEA_98-0\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation journal cs1\" id=\"CITEREFPilehvarCamacho-Collados2019\">Pilehvar, Mohammad Taher; Camacho-Collados, Jose (June 2019). <a class=\"external text\" href=\"https://aclanthology.org/N19-1128\" rel=\"nofollow\">\"Proceedings of the 2019 Conference of the North\"</a>. <i>Proceedings of the 2019 Conference of the North American Chapter of the Association for Computational Linguistics: Human Language Technologies, Volume 1 (Long and Short Papers)</i>. Minneapolis, Minnesota: Association for Computational Linguistics: 1267–1273. <a class=\"mw-redirect\" href=\"/wiki/Doi_(identifier)\" title=\"Doi (identifier)\">doi</a>:<a class=\"external text\" href=\"https://doi.org/10.18653%2Fv1%2FN19-1128\" rel=\"nofollow\">10.18653/v1/N19-1128</a>. <a class=\"mw-redirect\" href=\"/wiki/S2CID_(identifier)\" title=\"S2CID (identifier)\">S2CID</a> <a class=\"external text\" href=\"https://api.semanticscholar.org/CorpusID:102353817\" rel=\"nofollow\">102353817</a>. <a class=\"external text\" href=\"https://web.archive.org/web/20230627202732/https://aclanthology.org/N19-1128/\" rel=\"nofollow\">Archived</a> from the original on 2023-06-27<span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">2023-06-27</span></span>.</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=Proceedings+of+the+2019+Conference+of+the+North+American+Chapter+of+the+Association+for+Computational+Linguistics%3A+Human+Language+Technologies%2C+Volume+1+%28Long+and+Short+Papers%29&amp;rft.atitle=Proceedings+of+the+2019+Conference+of+the+North&amp;rft.pages=1267-1273&amp;rft.date=2019-06&amp;rft_id=info%3Adoi%2F10.18653%2Fv1%2FN19-1128&amp;rft_id=https%3A%2F%2Fapi.semanticscholar.org%2FCorpusID%3A102353817%23id-name%3DS2CID&amp;rft.aulast=Pilehvar&amp;rft.aufirst=Mohammad+Taher&amp;rft.au=Camacho-Collados%2C+Jose&amp;rft_id=https%3A%2F%2Faclanthology.org%2FN19-1128&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-TEIkA-99\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-TEIkA_99-0\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation web cs1\"><a class=\"external text\" href=\"https://pilehvar.github.io/wic/\" rel=\"nofollow\">\"WiC: The Word-in-Context Dataset\"</a>. <i>pilehvar.github.io</i>. <a class=\"external text\" href=\"https://web.archive.org/web/20230627202725/https://pilehvar.github.io/wic/\" rel=\"nofollow\">Archived</a> from the original on 2023-06-27<span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">2023-06-27</span></span>.</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=pilehvar.github.io&amp;rft.atitle=WiC%3A+The+Word-in-Context+Dataset&amp;rft_id=https%3A%2F%2Fpilehvar.github.io%2Fwic%2F&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-zgy1i-100\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-zgy1i_100-0\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation journal cs1\" id=\"CITEREFPatelPavlick2021\">Patel, Roma; Pavlick, Ellie (2021-10-06). <a class=\"external text\" href=\"https://openreview.net/forum?id=gJcEM8sxHK\" rel=\"nofollow\">\"Mapping Language Models to Grounded Conceptual Spaces\"</a>. <i>ICLR</i>. <a class=\"external text\" href=\"https://web.archive.org/web/20230624191940/https://openreview.net/forum?id=gJcEM8sxHK\" rel=\"nofollow\">Archived</a> from the original on 2023-06-24<span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">2023-06-27</span></span>.</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=ICLR&amp;rft.atitle=Mapping+Language+Models+to+Grounded+Conceptual+Spaces&amp;rft.date=2021-10-06&amp;rft.aulast=Patel&amp;rft.aufirst=Roma&amp;rft.au=Pavlick%2C+Ellie&amp;rft_id=https%3A%2F%2Fopenreview.net%2Fforum%3Fid%3DgJcEM8sxHK&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-Imb98-101\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-Imb98_101-0\">^</a></b></span> <span class=\"reference-text\"><i><a class=\"external text\" href=\"https://www.notion.so/A-Closer-Look-at-Large-Language-Models-Emergent-Abilities-493876b55df5479d80686f68a1abd72f\" rel=\"nofollow\">A Closer Look at Large Language Models Emergent Abilities</a> <a class=\"external text\" href=\"https://web.archive.org/web/20230624012329/https://www.notion.so/A-Closer-Look-at-Large-Language-Models-Emergent-Abilities-493876b55df5479d80686f68a1abd72f\" rel=\"nofollow\">Archived</a> 2023-06-24 at the <a href=\"/wiki/Wayback_Machine\" title=\"Wayback Machine\">Wayback Machine</a></i> (Yao Fu, Nov 20, 2022)</span>\n</li>\n<li id=\"cite_note-CeQVF-102\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-CeQVF_102-0\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation web cs1\" id=\"CITEREFOrnes2023\">Ornes, Stephen (March 16, 2023). <a class=\"external text\" href=\"https://www.quantamagazine.org/the-unpredictable-abilities-emerging-from-large-ai-models-20230316/\" rel=\"nofollow\">\"The Unpredictable Abilities Emerging From Large AI Models\"</a>. <i>Quanta Magazine</i>. <a class=\"external text\" href=\"https://web.archive.org/web/20230316203438/https://www.quantamagazine.org/the-unpredictable-abilities-emerging-from-large-ai-models-20230316/\" rel=\"nofollow\">Archived</a> from the original on March 16, 2023<span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">March 16,</span> 2023</span>.</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=Quanta+Magazine&amp;rft.atitle=The+Unpredictable+Abilities+Emerging+From+Large+AI+Models&amp;rft.date=2023-03-16&amp;rft.aulast=Ornes&amp;rft.aufirst=Stephen&amp;rft_id=https%3A%2F%2Fwww.quantamagazine.org%2Fthe-unpredictable-abilities-emerging-from-large-ai-models-20230316%2F&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-C775b-103\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-C775b_103-0\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation arxiv cs1\" id=\"CITEREFSchaefferMirandaKoyejo2023\">Schaeffer, Rylan; Miranda, Brando; Koyejo, Sanmi (2023-04-01). \"Are Emergent Abilities of Large Language Models a Mirage?\". <a class=\"mw-redirect\" href=\"/wiki/ArXiv_(identifier)\" title=\"ArXiv (identifier)\">arXiv</a>:<span class=\"id-lock-free\" title=\"Freely accessible\"><a class=\"external text\" href=\"https://arxiv.org/abs/2304.15004\" rel=\"nofollow\">2304.15004</a></span> [<a class=\"external text\" href=\"https://arxiv.org/archive/cs.AI\" rel=\"nofollow\">cs.AI</a>].</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=preprint&amp;rft.jtitle=arXiv&amp;rft.atitle=Are+Emergent+Abilities+of+Large+Language+Models+a+Mirage%3F&amp;rft.date=2023-04-01&amp;rft_id=info%3Aarxiv%2F2304.15004&amp;rft.aulast=Schaeffer&amp;rft.aufirst=Rylan&amp;rft.au=Miranda%2C+Brando&amp;rft.au=Koyejo%2C+Sanmi&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-IZSIr-104\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-IZSIr_104-0\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation arxiv cs1\" id=\"CITEREFLiHopkinsBauViégas2022\">Li, Kenneth; Hopkins, Aspen K.; Bau, David; Viégas, Fernanda; Pfister, Hanspeter; Wattenberg, Martin (2022-10-01). \"Emergent World Representations: Exploring a Sequence Model Trained on a Synthetic Task\". <a class=\"mw-redirect\" href=\"/wiki/ArXiv_(identifier)\" title=\"ArXiv (identifier)\">arXiv</a>:<span class=\"id-lock-free\" title=\"Freely accessible\"><a class=\"external text\" href=\"https://arxiv.org/abs/2210.13382\" rel=\"nofollow\">2210.13382</a></span> [<a class=\"external text\" href=\"https://arxiv.org/archive/cs.LG\" rel=\"nofollow\">cs.LG</a>].</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=preprint&amp;rft.jtitle=arXiv&amp;rft.atitle=Emergent+World+Representations%3A+Exploring+a+Sequence+Model+Trained+on+a+Synthetic+Task&amp;rft.date=2022-10-01&amp;rft_id=info%3Aarxiv%2F2210.13382&amp;rft.aulast=Li&amp;rft.aufirst=Kenneth&amp;rft.au=Hopkins%2C+Aspen+K.&amp;rft.au=Bau%2C+David&amp;rft.au=Vi%C3%A9gas%2C+Fernanda&amp;rft.au=Pfister%2C+Hanspeter&amp;rft.au=Wattenberg%2C+Martin&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-RLik9-105\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-RLik9_105-0\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation web cs1\"><a class=\"external text\" href=\"https://thegradient.pub/othello/\" rel=\"nofollow\">\"Large Language Model: world models or surface statistics?\"</a>. <i>The Gradient</i>. 2023-01-21<span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">2023-06-12</span></span>.</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=The+Gradient&amp;rft.atitle=Large+Language+Model%3A+world+models+or+surface+statistics%3F&amp;rft.date=2023-01-21&amp;rft_id=https%3A%2F%2Fthegradient.pub%2Fothello%2F&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-Hln1l-106\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-Hln1l_106-0\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation arxiv cs1\" id=\"CITEREFJinRinard2023\">Jin, Charles; Rinard, Martin (2023-05-01). \"Evidence of Meaning in Language Models Trained on Programs\". <a class=\"mw-redirect\" href=\"/wiki/ArXiv_(identifier)\" title=\"ArXiv (identifier)\">arXiv</a>:<span class=\"id-lock-free\" title=\"Freely accessible\"><a class=\"external text\" href=\"https://arxiv.org/abs/2305.11169\" rel=\"nofollow\">2305.11169</a></span> [<a class=\"external text\" href=\"https://arxiv.org/archive/cs.LG\" rel=\"nofollow\">cs.LG</a>].</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=preprint&amp;rft.jtitle=arXiv&amp;rft.atitle=Evidence+of+Meaning+in+Language+Models+Trained+on+Programs&amp;rft.date=2023-05-01&amp;rft_id=info%3Aarxiv%2F2305.11169&amp;rft.aulast=Jin&amp;rft.aufirst=Charles&amp;rft.au=Rinard%2C+Martin&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-oYGlo-107\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-oYGlo_107-0\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation arxiv cs1\" id=\"CITEREFNandaChanLieberumSmith2023\">Nanda, Neel; Chan, Lawrence; Lieberum, Tom; Smith, Jess; Steinhardt, Jacob (2023-01-01). \"Progress measures for grokking via mechanistic interpretability\". <a class=\"mw-redirect\" href=\"/wiki/ArXiv_(identifier)\" title=\"ArXiv (identifier)\">arXiv</a>:<span class=\"id-lock-free\" title=\"Freely accessible\"><a class=\"external text\" href=\"https://arxiv.org/abs/2301.05217\" rel=\"nofollow\">2301.05217</a></span> [<a class=\"external text\" href=\"https://arxiv.org/archive/cs.LG\" rel=\"nofollow\">cs.LG</a>].</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=preprint&amp;rft.jtitle=arXiv&amp;rft.atitle=Progress+measures+for+grokking+via+mechanistic+interpretability&amp;rft.date=2023-01-01&amp;rft_id=info%3Aarxiv%2F2301.05217&amp;rft.aulast=Nanda&amp;rft.aufirst=Neel&amp;rft.au=Chan%2C+Lawrence&amp;rft.au=Lieberum%2C+Tom&amp;rft.au=Smith%2C+Jess&amp;rft.au=Steinhardt%2C+Jacob&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-debate_understanding-108\"><span class=\"mw-cite-backlink\">^ <a href=\"#cite_ref-debate_understanding_108-0\"><sup><i><b>a</b></i></sup></a> <a href=\"#cite_ref-debate_understanding_108-1\"><sup><i><b>b</b></i></sup></a> <a href=\"#cite_ref-debate_understanding_108-2\"><sup><i><b>c</b></i></sup></a> <a href=\"#cite_ref-debate_understanding_108-3\"><sup><i><b>d</b></i></sup></a> <a href=\"#cite_ref-debate_understanding_108-4\"><sup><i><b>e</b></i></sup></a></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation journal cs1\" id=\"CITEREFMitchellKrakauer2023\">Mitchell, Melanie; Krakauer, David C. (28 March 2023). <a class=\"external text\" href=\"https://www.ncbi.nlm.nih.gov/pmc/articles/PMC10068812\" rel=\"nofollow\">\"The debate over understanding in AI's large language models\"</a>. <i>Proceedings of the National Academy of Sciences</i>. <b>120</b> (13): e2215907120. <a class=\"mw-redirect\" href=\"/wiki/ArXiv_(identifier)\" title=\"ArXiv (identifier)\">arXiv</a>:<span class=\"id-lock-free\" title=\"Freely accessible\"><a class=\"external text\" href=\"https://arxiv.org/abs/2210.13966\" rel=\"nofollow\">2210.13966</a></span>. <a class=\"mw-redirect\" href=\"/wiki/Bibcode_(identifier)\" title=\"Bibcode (identifier)\">Bibcode</a>:<a class=\"external text\" href=\"https://ui.adsabs.harvard.edu/abs/2023PNAS..12015907M\" rel=\"nofollow\">2023PNAS..12015907M</a>. <a class=\"mw-redirect\" href=\"/wiki/Doi_(identifier)\" title=\"Doi (identifier)\">doi</a>:<a class=\"external text\" href=\"https://doi.org/10.1073%2Fpnas.2215907120\" rel=\"nofollow\">10.1073/pnas.2215907120</a>. <a class=\"mw-redirect\" href=\"/wiki/PMC_(identifier)\" title=\"PMC (identifier)\">PMC</a> <span class=\"id-lock-free\" title=\"Freely accessible\"><a class=\"external text\" href=\"https://www.ncbi.nlm.nih.gov/pmc/articles/PMC10068812\" rel=\"nofollow\">10068812</a></span>. <a class=\"mw-redirect\" href=\"/wiki/PMID_(identifier)\" title=\"PMID (identifier)\">PMID</a> <a class=\"external text\" href=\"https://pubmed.ncbi.nlm.nih.gov/36943882\" rel=\"nofollow\">36943882</a>.</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=Proceedings+of+the+National+Academy+of+Sciences&amp;rft.atitle=The+debate+over+understanding+in+AI%27s+large+language+models&amp;rft.volume=120&amp;rft.issue=13&amp;rft.pages=e2215907120&amp;rft.date=2023-03-28&amp;rft_id=https%3A%2F%2Fwww.ncbi.nlm.nih.gov%2Fpmc%2Farticles%2FPMC10068812%23id-name%3DPMC&amp;rft_id=info%3Abibcode%2F2023PNAS..12015907M&amp;rft_id=info%3Aarxiv%2F2210.13966&amp;rft_id=info%3Apmid%2F36943882&amp;rft_id=info%3Adoi%2F10.1073%2Fpnas.2215907120&amp;rft.aulast=Mitchell&amp;rft.aufirst=Melanie&amp;rft.au=Krakauer%2C+David+C.&amp;rft_id=https%3A%2F%2Fwww.ncbi.nlm.nih.gov%2Fpmc%2Farticles%2FPMC10068812&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-O8Upd-109\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-O8Upd_109-0\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation news cs1\" id=\"CITEREFMetz2023\">Metz, Cade (16 May 2023). <a class=\"external text\" href=\"https://www.nytimes.com/2023/05/16/technology/microsoft-ai-human-reasoning.html\" rel=\"nofollow\">\"Microsoft Says New A.I. Shows Signs of Human Reasoning\"</a>. <i>The New York Times</i>.</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=The+New+York+Times&amp;rft.atitle=Microsoft+Says+New+A.I.+Shows+Signs+of+Human+Reasoning&amp;rft.date=2023-05-16&amp;rft.aulast=Metz&amp;rft.aufirst=Cade&amp;rft_id=https%3A%2F%2Fwww.nytimes.com%2F2023%2F05%2F16%2Ftechnology%2Fmicrosoft-ai-human-reasoning.html&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-microsoft_sparks-110\"><span class=\"mw-cite-backlink\">^ <a href=\"#cite_ref-microsoft_sparks_110-0\"><sup><i><b>a</b></i></sup></a> <a href=\"#cite_ref-microsoft_sparks_110-1\"><sup><i><b>b</b></i></sup></a></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation arxiv cs1\" id=\"CITEREFBubeckChandrasekaranEldanGehrke2023\">Bubeck, Sébastien; Chandrasekaran, Varun; Eldan, Ronen; Gehrke, Johannes; Horvitz, Eric; Kamar, Ece; Lee, Peter; Lee, Yin Tat; Li, Yuanzhi; Lundberg, Scott; Nori, Harsha; Palangi, Hamid; Ribeiro, Marco Tulio; Zhang, Yi (2023). \"Sparks of Artificial General Intelligence: Early experiments with GPT-4\". <a class=\"mw-redirect\" href=\"/wiki/ArXiv_(identifier)\" title=\"ArXiv (identifier)\">arXiv</a>:<span class=\"id-lock-free\" title=\"Freely accessible\"><a class=\"external text\" href=\"https://arxiv.org/abs/2303.12712\" rel=\"nofollow\">2303.12712</a></span> [<a class=\"external text\" href=\"https://arxiv.org/archive/cs.CL\" rel=\"nofollow\">cs.CL</a>].</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=preprint&amp;rft.jtitle=arXiv&amp;rft.atitle=Sparks+of+Artificial+General+Intelligence%3A+Early+experiments+with+GPT-4&amp;rft.date=2023&amp;rft_id=info%3Aarxiv%2F2303.12712&amp;rft.aulast=Bubeck&amp;rft.aufirst=S%C3%A9bastien&amp;rft.au=Chandrasekaran%2C+Varun&amp;rft.au=Eldan%2C+Ronen&amp;rft.au=Gehrke%2C+Johannes&amp;rft.au=Horvitz%2C+Eric&amp;rft.au=Kamar%2C+Ece&amp;rft.au=Lee%2C+Peter&amp;rft.au=Lee%2C+Yin+Tat&amp;rft.au=Li%2C+Yuanzhi&amp;rft.au=Lundberg%2C+Scott&amp;rft.au=Nori%2C+Harsha&amp;rft.au=Palangi%2C+Hamid&amp;rft.au=Ribeiro%2C+Marco+Tulio&amp;rft.au=Zhang%2C+Yi&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-111\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-111\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation news cs1\"><a class=\"external text\" href=\"https://www.fastcompany.com/91211163/anthropic-ceo-dario-amodei-pens-a-smart-look-at-our-ai-future\" rel=\"nofollow\">\"Anthropic CEO Dario Amodei pens a smart look at our AI future\"</a>. <i>Fast Company</i>. October 17, 2024.</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=Fast+Company&amp;rft.atitle=Anthropic+CEO+Dario+Amodei+pens+a+smart+look+at+our+AI+future&amp;rft.date=2024-10-17&amp;rft_id=https%3A%2F%2Fwww.fastcompany.com%2F91211163%2Fanthropic-ceo-dario-amodei-pens-a-smart-look-at-our-ai-future&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-rEEmH-112\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-rEEmH_112-0\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation news cs1\"><a class=\"external text\" href=\"https://www.zdnet.com/article/chatgpt-is-more-like-an-alien-intelligence-than-a-human-brain-says-futurist/\" rel=\"nofollow\">\"ChatGPT is more like an 'alien intelligence' than a human brain, says futurist\"</a>. <i>ZDNET</i>. 2023. <a class=\"external text\" href=\"https://web.archive.org/web/20230612065937/https://www.zdnet.com/article/chatgpt-is-more-like-an-alien-intelligence-than-a-human-brain-says-futurist/\" rel=\"nofollow\">Archived</a> from the original on 12 June 2023<span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">12 June</span> 2023</span>.</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=ZDNET&amp;rft.atitle=ChatGPT+is+more+like+an+%27alien+intelligence%27+than+a+human+brain%2C+says+futurist&amp;rft.date=2023&amp;rft_id=https%3A%2F%2Fwww.zdnet.com%2Farticle%2Fchatgpt-is-more-like-an-alien-intelligence-than-a-human-brain-says-futurist%2F&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-new_yorker_kind_of_mind-113\"><span class=\"mw-cite-backlink\">^ <a href=\"#cite_ref-new_yorker_kind_of_mind_113-0\"><sup><i><b>a</b></i></sup></a> <a href=\"#cite_ref-new_yorker_kind_of_mind_113-1\"><sup><i><b>b</b></i></sup></a></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation magazine cs1\" id=\"CITEREFNewport2023\">Newport, Cal (13 April 2023). <a class=\"external text\" href=\"https://www.newyorker.com/science/annals-of-artificial-intelligence/what-kind-of-mind-does-chatgpt-have\" rel=\"nofollow\">\"What Kind of Mind Does ChatGPT Have?\"</a>. <i>The New Yorker</i>. <a class=\"external text\" href=\"https://web.archive.org/web/20230612071443/https://www.newyorker.com/science/annals-of-artificial-intelligence/what-kind-of-mind-does-chatgpt-have\" rel=\"nofollow\">Archived</a> from the original on 12 June 2023<span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">12 June</span> 2023</span>.</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=The+New+Yorker&amp;rft.atitle=What+Kind+of+Mind+Does+ChatGPT+Have%3F&amp;rft.date=2023-04-13&amp;rft.aulast=Newport&amp;rft.aufirst=Cal&amp;rft_id=https%3A%2F%2Fwww.newyorker.com%2Fscience%2Fannals-of-artificial-intelligence%2Fwhat-kind-of-mind-does-chatgpt-have&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-rAFIZ-114\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-rAFIZ_114-0\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation news cs1\" id=\"CITEREFRoose2023\">Roose, Kevin (30 May 2023). <a class=\"external text\" href=\"https://www.nytimes.com/2023/05/30/technology/shoggoth-meme-ai.html\" rel=\"nofollow\">\"Why an Octopus-like Creature Has Come to Symbolize the State of A.I.\"</a> <i>The New York Times</i>. <a class=\"external text\" href=\"https://web.archive.org/web/20230530193814/https://www.nytimes.com/2023/05/30/technology/shoggoth-meme-ai.html\" rel=\"nofollow\">Archived</a> from the original on 30 May 2023<span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">12 June</span> 2023</span>.</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=The+New+York+Times&amp;rft.atitle=Why+an+Octopus-like+Creature+Has+Come+to+Symbolize+the+State+of+A.I.&amp;rft.date=2023-05-30&amp;rft.aulast=Roose&amp;rft.aufirst=Kevin&amp;rft_id=https%3A%2F%2Fwww.nytimes.com%2F2023%2F05%2F30%2Ftechnology%2Fshoggoth-meme-ai.html&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-4luKE-115\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-4luKE_115-0\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation news cs1\"><a class=\"external text\" href=\"https://time.com/6271657/a-to-z-of-artificial-intelligence/\" rel=\"nofollow\">\"The A to Z of Artificial Intelligence\"</a>. <i>Time Magazine</i>. 13 April 2023. <a class=\"external text\" href=\"https://web.archive.org/web/20230616123839/https://time.com/6271657/a-to-z-of-artificial-intelligence/\" rel=\"nofollow\">Archived</a> from the original on 16 June 2023<span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">12 June</span> 2023</span>.</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=Time+Magazine&amp;rft.atitle=The+A+to+Z+of+Artificial+Intelligence&amp;rft.date=2023-04-13&amp;rft_id=https%3A%2F%2Ftime.com%2F6271657%2Fa-to-z-of-artificial-intelligence%2F&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-hallucination-survey-116\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-hallucination-survey_116-0\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation journal cs1\" id=\"CITEREFJiLeeFrieskeYu2022\">Ji, Ziwei; Lee, Nayeon; Frieske, Rita; Yu, Tiezheng; Su, Dan; Xu, Yan; Ishii, Etsuko; Bang, Yejin; Dai, Wenliang; Madotto, Andrea; Fung, Pascale (November 2022). <a class=\"external text\" href=\"https://dl.acm.org/doi/pdf/10.1145/3571730\" rel=\"nofollow\">\"Survey of Hallucination in Natural Language Generation\"</a> <span class=\"cs1-format\">(pdf)</span>. <i>ACM Computing Surveys</i>. <b>55</b> (12). <a href=\"/wiki/Association_for_Computing_Machinery\" title=\"Association for Computing Machinery\">Association for Computing Machinery</a>: 1–38. <a class=\"mw-redirect\" href=\"/wiki/ArXiv_(identifier)\" title=\"ArXiv (identifier)\">arXiv</a>:<span class=\"id-lock-free\" title=\"Freely accessible\"><a class=\"external text\" href=\"https://arxiv.org/abs/2202.03629\" rel=\"nofollow\">2202.03629</a></span>. <a class=\"mw-redirect\" href=\"/wiki/Doi_(identifier)\" title=\"Doi (identifier)\">doi</a>:<a class=\"external text\" href=\"https://doi.org/10.1145%2F3571730\" rel=\"nofollow\">10.1145/3571730</a>. <a class=\"mw-redirect\" href=\"/wiki/S2CID_(identifier)\" title=\"S2CID (identifier)\">S2CID</a> <a class=\"external text\" href=\"https://api.semanticscholar.org/CorpusID:246652372\" rel=\"nofollow\">246652372</a>. <a class=\"external text\" href=\"https://web.archive.org/web/20230326145635/https://dl.acm.org/doi/pdf/10.1145/3571730\" rel=\"nofollow\">Archived</a> from the original on 26 March 2023<span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">15 January</span> 2023</span>.</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=ACM+Computing+Surveys&amp;rft.atitle=Survey+of+Hallucination+in+Natural+Language+Generation&amp;rft.volume=55&amp;rft.issue=12&amp;rft.pages=1-38&amp;rft.date=2022-11&amp;rft_id=info%3Aarxiv%2F2202.03629&amp;rft_id=https%3A%2F%2Fapi.semanticscholar.org%2FCorpusID%3A246652372%23id-name%3DS2CID&amp;rft_id=info%3Adoi%2F10.1145%2F3571730&amp;rft.aulast=Ji&amp;rft.aufirst=Ziwei&amp;rft.au=Lee%2C+Nayeon&amp;rft.au=Frieske%2C+Rita&amp;rft.au=Yu%2C+Tiezheng&amp;rft.au=Su%2C+Dan&amp;rft.au=Xu%2C+Yan&amp;rft.au=Ishii%2C+Etsuko&amp;rft.au=Bang%2C+Yejin&amp;rft.au=Dai%2C+Wenliang&amp;rft.au=Madotto%2C+Andrea&amp;rft.au=Fung%2C+Pascale&amp;rft_id=https%3A%2F%2Fdl.acm.org%2Fdoi%2Fpdf%2F10.1145%2F3571730&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-117\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-117\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation arxiv cs1\" id=\"CITEREFVarshneyYaoZhangChen2023\">Varshney, Neeraj; Yao, Wenlin; Zhang, Hongming; Chen, Jianshu; Yu, Dong (2023). \"A Stitch in Time Saves Nine: Detecting and Mitigating Hallucinations of LLMs by Validating Low-Confidence Generation\". <a class=\"mw-redirect\" href=\"/wiki/ArXiv_(identifier)\" title=\"ArXiv (identifier)\">arXiv</a>:<span class=\"id-lock-free\" title=\"Freely accessible\"><a class=\"external text\" href=\"https://arxiv.org/abs/2307.03987\" rel=\"nofollow\">2307.03987</a></span> [<a class=\"external text\" href=\"https://arxiv.org/archive/cs.CL\" rel=\"nofollow\">cs.CL</a>].</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=preprint&amp;rft.jtitle=arXiv&amp;rft.atitle=A+Stitch+in+Time+Saves+Nine%3A+Detecting+and+Mitigating+Hallucinations+of+LLMs+by+Validating+Low-Confidence+Generation&amp;rft.date=2023&amp;rft_id=info%3Aarxiv%2F2307.03987&amp;rft.aulast=Varshney&amp;rft.aufirst=Neeraj&amp;rft.au=Yao%2C+Wenlin&amp;rft.au=Zhang%2C+Hongming&amp;rft.au=Chen%2C+Jianshu&amp;rft.au=Yu%2C+Dong&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-118\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-118\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation book cs1\" id=\"CITEREFLakoff1999\">Lakoff, George (1999). <i>Philosophy in the Flesh: The Embodied Mind and Its Challenge to Western Philosophy; Appendix: The Neural Theory of Language Paradigm</i>. New York Basic Books. pp. 569–583. <a class=\"mw-redirect\" href=\"/wiki/ISBN_(identifier)\" title=\"ISBN (identifier)\">ISBN</a> <a href=\"/wiki/Special:BookSources/978-0-465-05674-3\" title=\"Special:BookSources/978-0-465-05674-3\"><bdi>978-0-465-05674-3</bdi></a>.</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=book&amp;rft.btitle=Philosophy+in+the+Flesh%3A+The+Embodied+Mind+and+Its+Challenge+to+Western+Philosophy%3B+Appendix%3A+The+Neural+Theory+of+Language+Paradigm&amp;rft.pages=569-583&amp;rft.pub=New+York+Basic+Books&amp;rft.date=1999&amp;rft.isbn=978-0-465-05674-3&amp;rft.aulast=Lakoff&amp;rft.aufirst=George&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-119\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-119\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation book cs1\" id=\"CITEREFEvans2014\">Evans, Vyvyan. (2014). <i>The Language Myth</i>. Cambridge University Press. <a class=\"mw-redirect\" href=\"/wiki/ISBN_(identifier)\" title=\"ISBN (identifier)\">ISBN</a> <a href=\"/wiki/Special:BookSources/978-1-107-04396-1\" title=\"Special:BookSources/978-1-107-04396-1\"><bdi>978-1-107-04396-1</bdi></a>.</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=book&amp;rft.btitle=The+Language+Myth&amp;rft.pub=Cambridge+University+Press&amp;rft.date=2014&amp;rft.isbn=978-1-107-04396-1&amp;rft.aulast=Evans&amp;rft.aufirst=Vyvyan.&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-120\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-120\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation book cs1\" id=\"CITEREFFriston2022\">Friston, Karl J. (2022). <i>Active Inference: The Free Energy Principle in Mind, Brain, and Behavior; Chapter 4 The Generative Models of Active Inference</i>. The MIT Press. <a class=\"mw-redirect\" href=\"/wiki/ISBN_(identifier)\" title=\"ISBN (identifier)\">ISBN</a> <a href=\"/wiki/Special:BookSources/978-0-262-36997-8\" title=\"Special:BookSources/978-0-262-36997-8\"><bdi>978-0-262-36997-8</bdi></a>.</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=book&amp;rft.btitle=Active+Inference%3A+The+Free+Energy+Principle+in+Mind%2C+Brain%2C+and+Behavior%3B+Chapter+4+The+Generative+Models+of+Active+Inference&amp;rft.pub=The+MIT+Press&amp;rft.date=2022&amp;rft.isbn=978-0-262-36997-8&amp;rft.aulast=Friston&amp;rft.aufirst=Karl+J.&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-Huyen-121\"><span class=\"mw-cite-backlink\">^ <a href=\"#cite_ref-Huyen_121-0\"><sup><i><b>a</b></i></sup></a> <a href=\"#cite_ref-Huyen_121-1\"><sup><i><b>b</b></i></sup></a></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation web cs1\" id=\"CITEREFHuyen2019\">Huyen, Chip (October 18, 2019). <a class=\"external text\" href=\"https://thegradient.pub/understanding-evaluation-metrics-for-language-models/\" rel=\"nofollow\">\"Evaluation Metrics for Language Modeling\"</a>. <i>The Gradient</i><span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">January 14,</span> 2024</span>.</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=The+Gradient&amp;rft.atitle=Evaluation+Metrics+for+Language+Modeling&amp;rft.date=2019-10-18&amp;rft.aulast=Huyen&amp;rft.aufirst=Chip&amp;rft_id=https%3A%2F%2Fthegradient.pub%2Funderstanding-evaluation-metrics-for-language-models%2F&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-boolq-122\"><span class=\"mw-cite-backlink\">^ <a href=\"#cite_ref-boolq_122-0\"><sup><i><b>a</b></i></sup></a> <a href=\"#cite_ref-boolq_122-1\"><sup><i><b>b</b></i></sup></a></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation arxiv cs1\" id=\"CITEREFClarkLeeChangKwiatkowski2019\">Clark, Christopher; Lee, Kenton; Chang, Ming-Wei; Kwiatkowski, Tom; Collins, Michael; Toutanova, Kristina (2019). \"BoolQ: Exploring the Surprising Difficulty of Natural Yes/No Questions\". <a class=\"mw-redirect\" href=\"/wiki/ArXiv_(identifier)\" title=\"ArXiv (identifier)\">arXiv</a>:<span class=\"id-lock-free\" title=\"Freely accessible\"><a class=\"external text\" href=\"https://arxiv.org/abs/1905.10044\" rel=\"nofollow\">1905.10044</a></span> [<a class=\"external text\" href=\"https://arxiv.org/archive/cs.CL\" rel=\"nofollow\">cs.CL</a>].</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=preprint&amp;rft.jtitle=arXiv&amp;rft.atitle=BoolQ%3A+Exploring+the+Surprising+Difficulty+of+Natural+Yes%2FNo+Questions&amp;rft.date=2019&amp;rft_id=info%3Aarxiv%2F1905.10044&amp;rft.aulast=Clark&amp;rft.aufirst=Christopher&amp;rft.au=Lee%2C+Kenton&amp;rft.au=Chang%2C+Ming-Wei&amp;rft.au=Kwiatkowski%2C+Tom&amp;rft.au=Collins%2C+Michael&amp;rft.au=Toutanova%2C+Kristina&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-survey-123\"><span class=\"mw-cite-backlink\">^ <a href=\"#cite_ref-survey_123-0\"><sup><i><b>a</b></i></sup></a> <a href=\"#cite_ref-survey_123-1\"><sup><i><b>b</b></i></sup></a> <a href=\"#cite_ref-survey_123-2\"><sup><i><b>c</b></i></sup></a></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation arxiv cs1\" id=\"CITEREFWayne_Xin_ZhaoZhouLiTang2023\">Wayne Xin Zhao; Zhou, Kun; Li, Junyi; Tang, Tianyi; Wang, Xiaolei; Hou, Yupeng; Min, Yingqian; Zhang, Beichen; Zhang, Junjie; Dong, Zican; Du, Yifan; Yang, Chen; Chen, Yushuo; Chen, Zhipeng; Jiang, Jinhao; Ren, Ruiyang; Li, Yifan; Tang, Xinyu; Liu, Zikang; Liu, Peiyu; Nie, Jian-Yun; Wen, Ji-Rong (2023). \"A Survey of Large Language Models\". <a class=\"mw-redirect\" href=\"/wiki/ArXiv_(identifier)\" title=\"ArXiv (identifier)\">arXiv</a>:<span class=\"id-lock-free\" title=\"Freely accessible\"><a class=\"external text\" href=\"https://arxiv.org/abs/2303.18223\" rel=\"nofollow\">2303.18223</a></span> [<a class=\"external text\" href=\"https://arxiv.org/archive/cs.CL\" rel=\"nofollow\">cs.CL</a>].</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=preprint&amp;rft.jtitle=arXiv&amp;rft.atitle=A+Survey+of+Large+Language+Models&amp;rft.date=2023&amp;rft_id=info%3Aarxiv%2F2303.18223&amp;rft.au=Wayne+Xin+Zhao&amp;rft.au=Zhou%2C+Kun&amp;rft.au=Li%2C+Junyi&amp;rft.au=Tang%2C+Tianyi&amp;rft.au=Wang%2C+Xiaolei&amp;rft.au=Hou%2C+Yupeng&amp;rft.au=Min%2C+Yingqian&amp;rft.au=Zhang%2C+Beichen&amp;rft.au=Zhang%2C+Junjie&amp;rft.au=Dong%2C+Zican&amp;rft.au=Du%2C+Yifan&amp;rft.au=Yang%2C+Chen&amp;rft.au=Chen%2C+Yushuo&amp;rft.au=Chen%2C+Zhipeng&amp;rft.au=Jiang%2C+Jinhao&amp;rft.au=Ren%2C+Ruiyang&amp;rft.au=Li%2C+Yifan&amp;rft.au=Tang%2C+Xinyu&amp;rft.au=Liu%2C+Zikang&amp;rft.au=Liu%2C+Peiyu&amp;rft.au=Nie%2C+Jian-Yun&amp;rft.au=Wen%2C+Ji-Rong&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-124\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-124\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation cs2\"><a class=\"external text\" href=\"https://github.com/openai/simple-evals\" rel=\"nofollow\"><i>openai/simple-evals</i></a>, OpenAI, 2024-05-28<span class=\"reference-accessdate\">, retrieved <span class=\"nowrap\">2024-05-28</span></span></cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=book&amp;rft.btitle=openai%2Fsimple-evals&amp;rft.pub=OpenAI&amp;rft.date=2024-05-28&amp;rft_id=https%3A%2F%2Fgithub.com%2Fopenai%2Fsimple-evals&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-125\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-125\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation cs2\"><a class=\"external text\" href=\"https://github.com/openai/evals\" rel=\"nofollow\"><i>openai/evals</i></a>, OpenAI, 2024-05-28, <a class=\"external text\" href=\"https://web.archive.org/web/20240508225708/https://github.com/openai/evals\" rel=\"nofollow\">archived</a> from the original on 2024-05-08<span class=\"reference-accessdate\">, retrieved <span class=\"nowrap\">2024-05-28</span></span></cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=book&amp;rft.btitle=openai%2Fevals&amp;rft.pub=OpenAI&amp;rft.date=2024-05-28&amp;rft_id=https%3A%2F%2Fgithub.com%2Fopenai%2Fevals&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-126\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-126\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation web cs1\"><a class=\"external text\" href=\"https://imbue.com/research/70b-evals/\" rel=\"nofollow\">\"Sanitized open-source datasets for natural language and code understanding: how we evaluated our 70B model\"</a>. <i>imbue.com</i>. <a class=\"external text\" href=\"https://web.archive.org/web/20240726173012/https://imbue.com/research/70b-evals/\" rel=\"nofollow\">Archived</a> from the original on 2024-07-26<span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">2024-07-24</span></span>.</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=imbue.com&amp;rft.atitle=Sanitized+open-source+datasets+for+natural+language+and+code+understanding%3A+how+we+evaluated+our+70B+model&amp;rft_id=https%3A%2F%2Fimbue.com%2Fresearch%2F70b-evals%2F&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-bigbench-127\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-bigbench_127-0\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation arxiv cs1\" id=\"CITEREFSrivastavaRastogiRaoAbu_Awal_Md_Shoeb2022\">Srivastava, Aarohi; et al. (2022). \"Beyond the Imitation Game: Quantifying and extrapolating the capabilities of language models\". <a class=\"mw-redirect\" href=\"/wiki/ArXiv_(identifier)\" title=\"ArXiv (identifier)\">arXiv</a>:<span class=\"id-lock-free\" title=\"Freely accessible\"><a class=\"external text\" href=\"https://arxiv.org/abs/2206.04615\" rel=\"nofollow\">2206.04615</a></span> [<a class=\"external text\" href=\"https://arxiv.org/archive/cs.CL\" rel=\"nofollow\">cs.CL</a>].</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=preprint&amp;rft.jtitle=arXiv&amp;rft.atitle=Beyond+the+Imitation+Game%3A+Quantifying+and+extrapolating+the+capabilities+of+language+models&amp;rft.date=2022&amp;rft_id=info%3Aarxiv%2F2206.04615&amp;rft.aulast=Srivastava&amp;rft.aufirst=Aarohi&amp;rft.au=Rastogi%2C+Abhinav&amp;rft.au=Rao%2C+Abhishek&amp;rft.au=Abu+Awal+Md+Shoeb&amp;rft.au=Abid%2C+Abubakar&amp;rft.au=Fisch%2C+Adam&amp;rft.au=Brown%2C+Adam+R.&amp;rft.au=Santoro%2C+Adam&amp;rft.au=Gupta%2C+Aditya&amp;rft.au=Garriga-Alonso%2C+Adri%C3%A0&amp;rft.au=Kluska%2C+Agnieszka&amp;rft.au=Lewkowycz%2C+Aitor&amp;rft.au=Agarwal%2C+Akshat&amp;rft.au=Power%2C+Alethea&amp;rft.au=Ray%2C+Alex&amp;rft.au=Warstadt%2C+Alex&amp;rft.au=Kocurek%2C+Alexander+W.&amp;rft.au=Safaya%2C+Ali&amp;rft.au=Tazarv%2C+Ali&amp;rft.au=Xiang%2C+Alice&amp;rft.au=Parrish%2C+Alicia&amp;rft.au=Nie%2C+Allen&amp;rft.au=Hussain%2C+Aman&amp;rft.au=Askell%2C+Amanda&amp;rft.au=Dsouza%2C+Amanda&amp;rft.au=Slone%2C+Ambrose&amp;rft.au=Rahane%2C+Ameet&amp;rft.au=Iyer%2C+Anantharaman+S.&amp;rft.au=Andreassen%2C+Anders&amp;rft.au=Madotto%2C+Andrea&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-truthfulqa-128\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-truthfulqa_128-0\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation arxiv cs1\" id=\"CITEREFLinHiltonEvans2021\">Lin, Stephanie; Hilton, Jacob; Evans, Owain (2021). \"TruthfulQA: Measuring How Models Mimic Human Falsehoods\". <a class=\"mw-redirect\" href=\"/wiki/ArXiv_(identifier)\" title=\"ArXiv (identifier)\">arXiv</a>:<span class=\"id-lock-free\" title=\"Freely accessible\"><a class=\"external text\" href=\"https://arxiv.org/abs/2109.07958\" rel=\"nofollow\">2109.07958</a></span> [<a class=\"external text\" href=\"https://arxiv.org/archive/cs.CL\" rel=\"nofollow\">cs.CL</a>].</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=preprint&amp;rft.jtitle=arXiv&amp;rft.atitle=TruthfulQA%3A+Measuring+How+Models+Mimic+Human+Falsehoods&amp;rft.date=2021&amp;rft_id=info%3Aarxiv%2F2109.07958&amp;rft.aulast=Lin&amp;rft.aufirst=Stephanie&amp;rft.au=Hilton%2C+Jacob&amp;rft.au=Evans%2C+Owain&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-hellaswag-129\"><span class=\"mw-cite-backlink\">^ <a href=\"#cite_ref-hellaswag_129-0\"><sup><i><b>a</b></i></sup></a> <a href=\"#cite_ref-hellaswag_129-1\"><sup><i><b>b</b></i></sup></a></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation arxiv cs1\" id=\"CITEREFZellersHoltzmanBiskFarhadi2019\">Zellers, Rowan; Holtzman, Ari; Bisk, Yonatan; Farhadi, Ali; Choi, Yejin (2019). \"HellaSwag: Can a Machine Really Finish Your Sentence?\". <a class=\"mw-redirect\" href=\"/wiki/ArXiv_(identifier)\" title=\"ArXiv (identifier)\">arXiv</a>:<span class=\"id-lock-free\" title=\"Freely accessible\"><a class=\"external text\" href=\"https://arxiv.org/abs/1905.07830\" rel=\"nofollow\">1905.07830</a></span> [<a class=\"external text\" href=\"https://arxiv.org/archive/cs.CL\" rel=\"nofollow\">cs.CL</a>].</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=preprint&amp;rft.jtitle=arXiv&amp;rft.atitle=HellaSwag%3A+Can+a+Machine+Really+Finish+Your+Sentence%3F&amp;rft.date=2019&amp;rft_id=info%3Aarxiv%2F1905.07830&amp;rft.aulast=Zellers&amp;rft.aufirst=Rowan&amp;rft.au=Holtzman%2C+Ari&amp;rft.au=Bisk%2C+Yonatan&amp;rft.au=Farhadi%2C+Ali&amp;rft.au=Choi%2C+Yejin&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-ZDTUM-130\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-ZDTUM_130-0\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation journal cs1\">\"Prepare for truly useful large language models\". <i>Nature Biomedical Engineering</i>. <b>7</b> (2): 85–86. 7 March 2023. <a class=\"mw-redirect\" href=\"/wiki/Doi_(identifier)\" title=\"Doi (identifier)\">doi</a>:<a class=\"external text\" href=\"https://doi.org/10.1038%2Fs41551-023-01012-6\" rel=\"nofollow\">10.1038/s41551-023-01012-6</a>. <a class=\"mw-redirect\" href=\"/wiki/PMID_(identifier)\" title=\"PMID (identifier)\">PMID</a> <a class=\"external text\" href=\"https://pubmed.ncbi.nlm.nih.gov/36882584\" rel=\"nofollow\">36882584</a>. <a class=\"mw-redirect\" href=\"/wiki/S2CID_(identifier)\" title=\"S2CID (identifier)\">S2CID</a> <a class=\"external text\" href=\"https://api.semanticscholar.org/CorpusID:257403466\" rel=\"nofollow\">257403466</a>.</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=Nature+Biomedical+Engineering&amp;rft.atitle=Prepare+for+truly+useful+large+language+models&amp;rft.volume=7&amp;rft.issue=2&amp;rft.pages=85-86&amp;rft.date=2023-03-07&amp;rft_id=https%3A%2F%2Fapi.semanticscholar.org%2FCorpusID%3A257403466%23id-name%3DS2CID&amp;rft_id=info%3Apmid%2F36882584&amp;rft_id=info%3Adoi%2F10.1038%2Fs41551-023-01012-6&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-81w7x-131\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-81w7x_131-0\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation news cs1\"><a class=\"external text\" href=\"https://www.economist.com/finance-and-economics/2023/05/07/your-job-is-probably-safe-from-artificial-intelligence\" rel=\"nofollow\">\"Your job is (probably) safe from artificial intelligence\"</a>. <i>The Economist</i>. 7 May 2023. <a class=\"external text\" href=\"https://web.archive.org/web/20230617225618/https://www.economist.com/finance-and-economics/2023/05/07/your-job-is-probably-safe-from-artificial-intelligence\" rel=\"nofollow\">Archived</a> from the original on 17 June 2023<span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">18 June</span> 2023</span>.</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=The+Economist&amp;rft.atitle=Your+job+is+%28probably%29+safe+from+artificial+intelligence&amp;rft.date=2023-05-07&amp;rft_id=https%3A%2F%2Fwww.economist.com%2Ffinance-and-economics%2F2023%2F05%2F07%2Fyour-job-is-probably-safe-from-artificial-intelligence&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-zIM6Y-132\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-zIM6Y_132-0\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation web cs1\"><a class=\"external text\" href=\"https://www.goldmansachs.com/intelligence/pages/generative-ai-could-raise-global-gdp-by-7-percent.html\" rel=\"nofollow\">\"Generative AI Could Raise Global GDP by 7%\"</a>. <i>Goldman Sachs</i>. <a class=\"external text\" href=\"https://web.archive.org/web/20230618013836/https://www.goldmansachs.com/intelligence/pages/generative-ai-could-raise-global-gdp-by-7-percent.html\" rel=\"nofollow\">Archived</a> from the original on 18 June 2023<span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">18 June</span> 2023</span>.</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=Goldman+Sachs&amp;rft.atitle=Generative+AI+Could+Raise+Global+GDP+by+7%25&amp;rft_id=https%3A%2F%2Fwww.goldmansachs.com%2Fintelligence%2Fpages%2Fgenerative-ai-could-raise-global-gdp-by-7-percent.html&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-133\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-133\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation journal cs1\" id=\"CITEREFPengWangDeng2023\">Peng, Zhencan; Wang, Zhizhi; Deng, Dong (13 June 2023). <a class=\"external text\" href=\"https://people.cs.rutgers.edu/~dd903/assets/papers/sigmod23.pdf\" rel=\"nofollow\">\"Near-Duplicate Sequence Search at Scale for Large Language Model Memorization Evaluation\"</a> <span class=\"cs1-format\">(PDF)</span>. <i>Proceedings of the ACM on Management of Data</i>. <b>1</b> (2): 1–18. <a class=\"mw-redirect\" href=\"/wiki/Doi_(identifier)\" title=\"Doi (identifier)\">doi</a>:<a class=\"external text\" href=\"https://doi.org/10.1145%2F3589324\" rel=\"nofollow\">10.1145/3589324</a>. <a class=\"mw-redirect\" href=\"/wiki/S2CID_(identifier)\" title=\"S2CID (identifier)\">S2CID</a> <a class=\"external text\" href=\"https://api.semanticscholar.org/CorpusID:259213212\" rel=\"nofollow\">259213212</a>. <a class=\"external text\" href=\"https://web.archive.org/web/20240827053753/https://people.cs.rutgers.edu/~dd903/assets/papers/sigmod23.pdf\" rel=\"nofollow\">Archived</a> <span class=\"cs1-format\">(PDF)</span> from the original on 2024-08-27<span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">2024-01-20</span></span>.</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=Proceedings+of+the+ACM+on+Management+of+Data&amp;rft.atitle=Near-Duplicate+Sequence+Search+at+Scale+for+Large+Language+Model+Memorization+Evaluation&amp;rft.volume=1&amp;rft.issue=2&amp;rft.pages=1-18&amp;rft.date=2023-06-13&amp;rft_id=info%3Adoi%2F10.1145%2F3589324&amp;rft_id=https%3A%2F%2Fapi.semanticscholar.org%2FCorpusID%3A259213212%23id-name%3DS2CID&amp;rft.aulast=Peng&amp;rft.aufirst=Zhencan&amp;rft.au=Wang%2C+Zhizhi&amp;rft.au=Deng%2C+Dong&amp;rft_id=https%3A%2F%2Fpeople.cs.rutgers.edu%2F~dd903%2Fassets%2Fpapers%2Fsigmod23.pdf&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span> Citing Lee et al 2022.</span>\n</li>\n<li id=\"cite_note-134\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-134\">^</a></b></span> <span class=\"reference-text\"><a href=\"#CITEREFPengWangDeng2023\">Peng, Wang &amp; Deng 2023</a>, p. 8.</span>\n</li>\n<li id=\"cite_note-nD6kH-135\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-nD6kH_135-0\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation news cs1\" id=\"CITEREFAlba2023\">Alba, Davey (1 May 2023). <a class=\"external text\" href=\"https://www.japantimes.co.jp/news/2023/05/01/business/tech/ai-fake-news-content-farms/\" rel=\"nofollow\">\"AI chatbots have been used to create dozens of news content farms\"</a>. <i>The Japan Times</i><span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">18 June</span> 2023</span>.</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=The+Japan+Times&amp;rft.atitle=AI+chatbots+have+been+used+to+create+dozens+of+news+content+farms&amp;rft.date=2023-05-01&amp;rft.aulast=Alba&amp;rft.aufirst=Davey&amp;rft_id=https%3A%2F%2Fwww.japantimes.co.jp%2Fnews%2F2023%2F05%2F01%2Fbusiness%2Ftech%2Fai-fake-news-content-farms%2F&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-PKiPY-136\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-PKiPY_136-0\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation journal cs1\"><a class=\"external text\" href=\"https://www.science.org/content/article/could-chatbots-help-devise-next-pandemic-virus\" rel=\"nofollow\">\"Could chatbots help devise the next pandemic virus?\"</a>. <i>Science</i>. 14 June 2023. <a class=\"mw-redirect\" href=\"/wiki/Doi_(identifier)\" title=\"Doi (identifier)\">doi</a>:<a class=\"external text\" href=\"https://doi.org/10.1126%2Fscience.adj2463\" rel=\"nofollow\">10.1126/science.adj2463</a>. <a class=\"external text\" href=\"https://web.archive.org/web/20230618013834/https://www.science.org/content/article/could-chatbots-help-devise-next-pandemic-virus\" rel=\"nofollow\">Archived</a> from the original on 18 June 2023<span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">18 June</span> 2023</span>.</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=Science&amp;rft.atitle=Could+chatbots+help+devise+the+next+pandemic+virus%3F&amp;rft.date=2023-06-14&amp;rft_id=info%3Adoi%2F10.1126%2Fscience.adj2463&amp;rft_id=https%3A%2F%2Fwww.science.org%2Fcontent%2Farticle%2Fcould-chatbots-help-devise-next-pandemic-virus&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-137\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-137\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation web cs1\" id=\"CITEREFStephen_Council2023\">Stephen Council (1 Dec 2023). <a class=\"external text\" href=\"https://www.sfgate.com/tech/article/google-openai-chatgpt-break-model-18525445.php\" rel=\"nofollow\">\"How Googlers cracked an SF rival's tech model with a single word\"</a>. SFGATE. <a class=\"external text\" href=\"https://web.archive.org/web/20231216160941/https://www.sfgate.com/tech/article/google-openai-chatgpt-break-model-18525445.php\" rel=\"nofollow\">Archived</a> from the original on 16 December 2023.</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=How+Googlers+cracked+an+SF+rival%27s+tech+model+with+a+single+word&amp;rft.pub=SFGATE&amp;rft.date=2023-12-01&amp;rft.au=Stephen+Council&amp;rft_id=https%3A%2F%2Fwww.sfgate.com%2Ftech%2Farticle%2Fgoogle-openai-chatgpt-break-model-18525445.php&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-138\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-138\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation arxiv cs1\" id=\"CITEREFHubinger2024\">Hubinger, Evan (10 January 2024). \"Sleeper Agents: Training Deceptive LLMs that Persist Through Safety Training\". <a class=\"mw-redirect\" href=\"/wiki/ArXiv_(identifier)\" title=\"ArXiv (identifier)\">arXiv</a>:<span class=\"id-lock-free\" title=\"Freely accessible\"><a class=\"external text\" href=\"https://arxiv.org/abs/2401.05566\" rel=\"nofollow\">2401.05566</a></span> [<a class=\"external text\" href=\"https://arxiv.org/archive/cs.CR\" rel=\"nofollow\">cs.CR</a>].</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=preprint&amp;rft.jtitle=arXiv&amp;rft.atitle=Sleeper+Agents%3A+Training+Deceptive+LLMs+that+Persist+Through+Safety+Training&amp;rft.date=2024-01-10&amp;rft_id=info%3Aarxiv%2F2401.05566&amp;rft.aulast=Hubinger&amp;rft.aufirst=Evan&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-139\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-139\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation arxiv cs1\" id=\"CITEREFKang2023\">Kang, Daniel (2023). \"Exploiting programmatic behavior of LLMs: Dual-use through standard security attacks\". <a class=\"mw-redirect\" href=\"/wiki/ArXiv_(identifier)\" title=\"ArXiv (identifier)\">arXiv</a>:<span class=\"id-lock-free\" title=\"Freely accessible\"><a class=\"external text\" href=\"https://arxiv.org/abs/2302.05733\" rel=\"nofollow\">2302.05733</a></span> [<a class=\"external text\" href=\"https://arxiv.org/archive/cs.CR\" rel=\"nofollow\">cs.CR</a>].</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=preprint&amp;rft.jtitle=arXiv&amp;rft.atitle=Exploiting+programmatic+behavior+of+LLMs%3A+Dual-use+through+standard+security+attacks&amp;rft.date=2023&amp;rft_id=info%3Aarxiv%2F2302.05733&amp;rft.aulast=Kang&amp;rft.aufirst=Daniel&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-140\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-140\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation web cs1\" id=\"CITEREFWang2024\">Wang, Yongge (20 June 2024). <a class=\"external text\" href=\"https://eprint.iacr.org/2024/586.pdf\" rel=\"nofollow\">\"Encryption Based Covert Channel for Large Language Models\"</a> <span class=\"cs1-format\">(PDF)</span>. IACR ePrint 2024/586. <a class=\"external text\" href=\"https://web.archive.org/web/20240624191233/https://eprint.iacr.org/2024/586.pdf\" rel=\"nofollow\">Archived</a> <span class=\"cs1-format\">(PDF)</span> from the original on 24 June 2024<span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">24 June</span> 2024</span>.</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=Encryption+Based+Covert+Channel+for+Large+Language+Models&amp;rft.pub=IACR+ePrint+2024%2F586&amp;rft.date=2024-06-20&amp;rft.aulast=Wang&amp;rft.aufirst=Yongge&amp;rft_id=https%3A%2F%2Feprint.iacr.org%2F2024%2F586.pdf&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-:8-141\"><span class=\"mw-cite-backlink\">^ <a href=\"#cite_ref-:8_141-0\"><sup><i><b>a</b></i></sup></a> <a href=\"#cite_ref-:8_141-1\"><sup><i><b>b</b></i></sup></a></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation web cs1\" id=\"CITEREFStokel-Walker2023\">Stokel-Walker, Chris (November 22, 2023). <a class=\"external text\" href=\"https://www.scientificamerican.com/article/chatgpt-replicates-gender-bias-in-recommendation-letters/\" rel=\"nofollow\">\"ChatGPT Replicates Gender Bias in Recommendation Letters\"</a>. <i>Scientific American</i>. <a class=\"external text\" href=\"https://web.archive.org/web/20231229043124/https://www.scientificamerican.com/article/chatgpt-replicates-gender-bias-in-recommendation-letters/\" rel=\"nofollow\">Archived</a> from the original on 2023-12-29<span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">2023-12-29</span></span>.</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=Scientific+American&amp;rft.atitle=ChatGPT+Replicates+Gender+Bias+in+Recommendation+Letters&amp;rft.date=2023-11-22&amp;rft.aulast=Stokel-Walker&amp;rft.aufirst=Chris&amp;rft_id=https%3A%2F%2Fwww.scientificamerican.com%2Farticle%2Fchatgpt-replicates-gender-bias-in-recommendation-letters%2F&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-:1-142\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-:1_142-0\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation arxiv cs1\" id=\"CITEREFLuoPuettSmith2023\">Luo, Queenie; Puett, Michael J.; Smith, Michael D. (2023-03-28). \"A Perspectival Mirror of the Elephant: Investigating Language Bias on Google, ChatGPT, Wikipedia, and YouTube\". <a class=\"mw-redirect\" href=\"/wiki/ArXiv_(identifier)\" title=\"ArXiv (identifier)\">arXiv</a>:<span class=\"id-lock-free\" title=\"Freely accessible\"><a class=\"external text\" href=\"https://arxiv.org/abs/2303.16281v2\" rel=\"nofollow\">2303.16281v2</a></span> [<a class=\"external text\" href=\"https://arxiv.org/archive/cs.CY\" rel=\"nofollow\">cs.CY</a>].</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=preprint&amp;rft.jtitle=arXiv&amp;rft.atitle=A+Perspectival+Mirror+of+the+Elephant%3A+Investigating+Language+Bias+on+Google%2C+ChatGPT%2C+Wikipedia%2C+and+YouTube&amp;rft.date=2023-03-28&amp;rft_id=info%3Aarxiv%2F2303.16281v2&amp;rft.aulast=Luo&amp;rft.aufirst=Queenie&amp;rft.au=Puett%2C+Michael+J.&amp;rft.au=Smith%2C+Michael+D.&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-143\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-143\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation cs2\" id=\"CITEREFChengDurmusJurafsky2023\">Cheng, Myra; Durmus, Esin; Jurafsky, Dan (2023-05-29), <i>Marked Personas: Using Natural Language Prompts to Measure Stereotypes in Language Models</i>, <a class=\"mw-redirect\" href=\"/wiki/ArXiv_(identifier)\" title=\"ArXiv (identifier)\">arXiv</a>:<span class=\"id-lock-free\" title=\"Freely accessible\"><a class=\"external text\" href=\"https://arxiv.org/abs/2305.18189\" rel=\"nofollow\">2305.18189</a></span></cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=book&amp;rft.btitle=Marked+Personas%3A+Using+Natural+Language+Prompts+to+Measure+Stereotypes+in+Language+Models&amp;rft.date=2023-05-29&amp;rft_id=info%3Aarxiv%2F2305.18189&amp;rft.aulast=Cheng&amp;rft.aufirst=Myra&amp;rft.au=Durmus%2C+Esin&amp;rft.au=Jurafsky%2C+Dan&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-144\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-144\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation book cs1\" id=\"CITEREFKotekDockumSun2023\">Kotek, Hadas; Dockum, Rikker; Sun, David (2023-11-05). <a class=\"external text\" href=\"https://dl.acm.org/doi/10.1145/3582269.3615599\" rel=\"nofollow\">\"Gender bias and stereotypes in Large Language Models\"</a>. <i>Proceedings of the ACM Collective Intelligence Conference</i>. CI '23. New York, NY, USA: Association for Computing Machinery. pp. 12–24. <a class=\"mw-redirect\" href=\"/wiki/Doi_(identifier)\" title=\"Doi (identifier)\">doi</a>:<a class=\"external text\" href=\"https://doi.org/10.1145%2F3582269.3615599\" rel=\"nofollow\">10.1145/3582269.3615599</a>. <a class=\"mw-redirect\" href=\"/wiki/ISBN_(identifier)\" title=\"ISBN (identifier)\">ISBN</a> <a href=\"/wiki/Special:BookSources/979-8-4007-0113-9\" title=\"Special:BookSources/979-8-4007-0113-9\"><bdi>979-8-4007-0113-9</bdi></a>.</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=bookitem&amp;rft.atitle=Gender+bias+and+stereotypes+in+Large+Language+Models&amp;rft.btitle=Proceedings+of+the+ACM+Collective+Intelligence+Conference&amp;rft.place=New+York%2C+NY%2C+USA&amp;rft.series=CI+%2723&amp;rft.pages=12-24&amp;rft.pub=Association+for+Computing+Machinery&amp;rft.date=2023-11-05&amp;rft_id=info%3Adoi%2F10.1145%2F3582269.3615599&amp;rft.isbn=979-8-4007-0113-9&amp;rft.aulast=Kotek&amp;rft.aufirst=Hadas&amp;rft.au=Dockum%2C+Rikker&amp;rft.au=Sun%2C+David&amp;rft_id=https%3A%2F%2Fdl.acm.org%2Fdoi%2F10.1145%2F3582269.3615599&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-145\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-145\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation web cs1\" id=\"CITEREFHeikkilä2023\">Heikkilä, Melissa (August 7, 2023). <a class=\"external text\" href=\"https://www.technologyreview.com/2023/08/07/1077324/ai-language-models-are-rife-with-political-biases/\" rel=\"nofollow\">\"AI language models are rife with different political biases\"</a>. <i>MIT Technology Review</i><span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">2023-12-29</span></span>.</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=MIT+Technology+Review&amp;rft.atitle=AI+language+models+are+rife+with+different+political+biases&amp;rft.date=2023-08-07&amp;rft.aulast=Heikkil%C3%A4&amp;rft.aufirst=Melissa&amp;rft_id=https%3A%2F%2Fwww.technologyreview.com%2F2023%2F08%2F07%2F1077324%2Fai-language-models-are-rife-with-political-biases%2F&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-oai-unsup-149\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-oai-unsup_149-0\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation web cs1\"><a class=\"external text\" href=\"https://openai.com/research/language-unsupervised\" rel=\"nofollow\">\"Improving language understanding with unsupervised learning\"</a>. <i>openai.com</i>. June 11, 2018. <a class=\"external text\" href=\"https://web.archive.org/web/20230318210736/https://openai.com/research/language-unsupervised\" rel=\"nofollow\">Archived</a> from the original on 2023-03-18<span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">2023-03-18</span></span>.</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=openai.com&amp;rft.atitle=Improving+language+understanding+with+unsupervised+learning&amp;rft.date=2018-06-11&amp;rft_id=https%3A%2F%2Fopenai.com%2Fresearch%2Flanguage-unsupervised&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-gpt1-150\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-gpt1_150-0\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation web cs1\"><a class=\"external text\" href=\"https://github.com/openai/finetune-transformer-lm\" rel=\"nofollow\">\"finetune-transformer-lm\"</a>. <i>GitHub</i>. <a class=\"external text\" href=\"https://web.archive.org/web/20230519062127/https://github.com/openai/finetune-transformer-lm\" rel=\"nofollow\">Archived</a> from the original on 19 May 2023<span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">2 January</span> 2024</span>.</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=GitHub&amp;rft.atitle=finetune-transformer-lm&amp;rft_id=https%3A%2F%2Fgithub.com%2Fopenai%2Ffinetune-transformer-lm&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-bert-paper-151\"><span class=\"mw-cite-backlink\">^ <a href=\"#cite_ref-bert-paper_151-0\"><sup><i><b>a</b></i></sup></a> <a href=\"#cite_ref-bert-paper_151-1\"><sup><i><b>b</b></i></sup></a></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation arxiv cs1\" id=\"CITEREFDevlinChangLeeToutanova2018\">Devlin, Jacob; Chang, Ming-Wei; Lee, Kenton; Toutanova, Kristina (11 October 2018). \"BERT: Pre-training of Deep Bidirectional Transformers for Language Understanding\". <a class=\"mw-redirect\" href=\"/wiki/ArXiv_(identifier)\" title=\"ArXiv (identifier)\">arXiv</a>:<span class=\"id-lock-free\" title=\"Freely accessible\"><a class=\"external text\" href=\"https://arxiv.org/abs/1810.04805v2\" rel=\"nofollow\">1810.04805v2</a></span> [<a class=\"external text\" href=\"https://arxiv.org/archive/cs.CL\" rel=\"nofollow\">cs.CL</a>].</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=preprint&amp;rft.jtitle=arXiv&amp;rft.atitle=BERT%3A+Pre-training+of+Deep+Bidirectional+Transformers+for+Language+Understanding&amp;rft.date=2018-10-11&amp;rft_id=info%3Aarxiv%2F1810.04805v2&amp;rft.aulast=Devlin&amp;rft.aufirst=Jacob&amp;rft.au=Chang%2C+Ming-Wei&amp;rft.au=Lee%2C+Kenton&amp;rft.au=Toutanova%2C+Kristina&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-bHZJ2-152\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-bHZJ2_152-0\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation web cs1\" id=\"CITEREFPrickett2021\">Prickett, Nicole Hemsoth (2021-08-24). <a class=\"external text\" href=\"https://www.nextplatform.com/2021/08/24/cerebras-shifts-architecture-to-meet-massive-ai-ml-models/\" rel=\"nofollow\">\"Cerebras Shifts Architecture To Meet Massive AI/ML Models\"</a>. <i>The Next Platform</i>. <a class=\"external text\" href=\"https://web.archive.org/web/20230620151619/https://www.nextplatform.com/2021/08/24/cerebras-shifts-architecture-to-meet-massive-ai-ml-models/\" rel=\"nofollow\">Archived</a> from the original on 2023-06-20<span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">2023-06-20</span></span>.</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=The+Next+Platform&amp;rft.atitle=Cerebras+Shifts+Architecture+To+Meet+Massive+AI%2FML+Models&amp;rft.date=2021-08-24&amp;rft.aulast=Prickett&amp;rft.aufirst=Nicole+Hemsoth&amp;rft_id=https%3A%2F%2Fwww.nextplatform.com%2F2021%2F08%2F24%2Fcerebras-shifts-architecture-to-meet-massive-ai-ml-models%2F&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-bert-web-153\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-bert-web_153-0\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation web cs1\"><a class=\"external text\" href=\"https://github.com/google-research/bert\" rel=\"nofollow\">\"BERT\"</a>. March 13, 2023. <a class=\"external text\" href=\"https://web.archive.org/web/20210113211317/https://github.com/google-research/bert\" rel=\"nofollow\">Archived</a> from the original on January 13, 2021<span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">March 13,</span> 2023</span> – via GitHub.</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=BERT&amp;rft.date=2023-03-13&amp;rft_id=https%3A%2F%2Fgithub.com%2Fgoogle-research%2Fbert&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-Ir545-154\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-Ir545_154-0\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation arxiv cs1\" id=\"CITEREFPatelLiRasooliConstant2022\">Patel, Ajay; Li, Bryan; Rasooli, Mohammad Sadegh; Constant, Noah; Raffel, Colin; Callison-Burch, Chris (2022). \"Bidirectional Language Models Are Also Few-shot Learners\". <a class=\"mw-redirect\" href=\"/wiki/ArXiv_(identifier)\" title=\"ArXiv (identifier)\">arXiv</a>:<span class=\"id-lock-free\" title=\"Freely accessible\"><a class=\"external text\" href=\"https://arxiv.org/abs/2209.14500\" rel=\"nofollow\">2209.14500</a></span> [<a class=\"external text\" href=\"https://arxiv.org/archive/cs.LG\" rel=\"nofollow\">cs.LG</a>].</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=preprint&amp;rft.jtitle=arXiv&amp;rft.atitle=Bidirectional+Language+Models+Are+Also+Few-shot+Learners&amp;rft.date=2022&amp;rft_id=info%3Aarxiv%2F2209.14500&amp;rft.aulast=Patel&amp;rft.aufirst=Ajay&amp;rft.au=Li%2C+Bryan&amp;rft.au=Rasooli%2C+Mohammad+Sadegh&amp;rft.au=Constant%2C+Noah&amp;rft.au=Raffel%2C+Colin&amp;rft.au=Callison-Burch%2C+Chris&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-:02-155\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-:02_155-0\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation arxiv cs1\" id=\"CITEREFDevlinChangLeeToutanova2018\">Devlin, Jacob; Chang, Ming-Wei; Lee, Kenton; Toutanova, Kristina (11 October 2018). \"BERT: Pre-training of Deep Bidirectional Transformers for Language Understanding\". <a class=\"mw-redirect\" href=\"/wiki/ArXiv_(identifier)\" title=\"ArXiv (identifier)\">arXiv</a>:<span class=\"id-lock-free\" title=\"Freely accessible\"><a class=\"external text\" href=\"https://arxiv.org/abs/1810.04805v2\" rel=\"nofollow\">1810.04805v2</a></span> [<a class=\"external text\" href=\"https://arxiv.org/archive/cs.CL\" rel=\"nofollow\">cs.CL</a>].</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=preprint&amp;rft.jtitle=arXiv&amp;rft.atitle=BERT%3A+Pre-training+of+Deep+Bidirectional+Transformers+for+Language+Understanding&amp;rft.date=2018-10-11&amp;rft_id=info%3Aarxiv%2F1810.04805v2&amp;rft.aulast=Devlin&amp;rft.aufirst=Jacob&amp;rft.au=Chang%2C+Ming-Wei&amp;rft.au=Lee%2C+Kenton&amp;rft.au=Toutanova%2C+Kristina&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-:6-156\"><span class=\"mw-cite-backlink\">^ <a href=\"#cite_ref-:6_156-0\"><sup><i><b>a</b></i></sup></a> <a href=\"#cite_ref-:6_156-1\"><sup><i><b>b</b></i></sup></a></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation journal cs1\" id=\"CITEREFRaffelShazeerRobertsLee2020\">Raffel, Colin; Shazeer, Noam; Roberts, Adam; Lee, Katherine; Narang, Sharan; Matena, Michael; Zhou, Yanqi; Li, Wei; Liu, Peter J. (2020). <a class=\"external text\" href=\"http://jmlr.org/papers/v21/20-074.html\" rel=\"nofollow\">\"Exploring the Limits of Transfer Learning with a Unified Text-to-Text Transformer\"</a>. <i>Journal of Machine Learning Research</i>. <b>21</b> (140): 1–67. <a class=\"mw-redirect\" href=\"/wiki/ArXiv_(identifier)\" title=\"ArXiv (identifier)\">arXiv</a>:<span class=\"id-lock-free\" title=\"Freely accessible\"><a class=\"external text\" href=\"https://arxiv.org/abs/1910.10683\" rel=\"nofollow\">1910.10683</a></span>. <a class=\"mw-redirect\" href=\"/wiki/ISSN_(identifier)\" title=\"ISSN (identifier)\">ISSN</a> <a class=\"external text\" href=\"https://search.worldcat.org/issn/1533-7928\" rel=\"nofollow\">1533-7928</a>.</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=Journal+of+Machine+Learning+Research&amp;rft.atitle=Exploring+the+Limits+of+Transfer+Learning+with+a+Unified+Text-to-Text+Transformer&amp;rft.volume=21&amp;rft.issue=140&amp;rft.pages=1-67&amp;rft.date=2020&amp;rft_id=info%3Aarxiv%2F1910.10683&amp;rft.issn=1533-7928&amp;rft.aulast=Raffel&amp;rft.aufirst=Colin&amp;rft.au=Shazeer%2C+Noam&amp;rft.au=Roberts%2C+Adam&amp;rft.au=Lee%2C+Katherine&amp;rft.au=Narang%2C+Sharan&amp;rft.au=Matena%2C+Michael&amp;rft.au=Zhou%2C+Yanqi&amp;rft.au=Li%2C+Wei&amp;rft.au=Liu%2C+Peter+J.&amp;rft_id=http%3A%2F%2Fjmlr.org%2Fpapers%2Fv21%2F20-074.html&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-157\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-157\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation cs2\"><a class=\"external text\" href=\"https://github.com/google-research/text-to-text-transfer-transformer\" rel=\"nofollow\"><i>google-research/text-to-text-transfer-transformer</i></a>, Google Research, 2024-04-02, <a class=\"external text\" href=\"https://web.archive.org/web/20240329112957/https://github.com/google-research/text-to-text-transfer-transformer\" rel=\"nofollow\">archived</a> from the original on 2024-03-29<span class=\"reference-accessdate\">, retrieved <span class=\"nowrap\">2024-04-04</span></span></cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=book&amp;rft.btitle=google-research%2Ftext-to-text-transfer-transformer&amp;rft.pub=Google+Research&amp;rft.date=2024-04-02&amp;rft_id=https%3A%2F%2Fgithub.com%2Fgoogle-research%2Ftext-to-text-transfer-transformer&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-158\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-158\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation web cs1\"><a class=\"external text\" href=\"https://imagen.research.google/\" rel=\"nofollow\">\"Imagen: Text-to-Image Diffusion Models\"</a>. <i>imagen.research.google</i>. <a class=\"external text\" href=\"https://web.archive.org/web/20240327201713/https://imagen.research.google/\" rel=\"nofollow\">Archived</a> from the original on 2024-03-27<span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">2024-04-04</span></span>.</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=imagen.research.google&amp;rft.atitle=Imagen%3A+Text-to-Image+Diffusion+Models&amp;rft_id=https%3A%2F%2Fimagen.research.google%2F&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-159\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-159\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation web cs1\"><a class=\"external text\" href=\"https://huggingface.co/transformers/v2.0.0/pretrained_models.html\" rel=\"nofollow\">\"Pretrained models — transformers 2.0.0 documentation\"</a>. <i>huggingface.co</i>. <a class=\"external text\" href=\"https://web.archive.org/web/20240805032110/https://huggingface.co/transformers/v2.0.0/pretrained_models.html\" rel=\"nofollow\">Archived</a> from the original on 2024-08-05<span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">2024-08-05</span></span>.</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=huggingface.co&amp;rft.atitle=Pretrained+models+%E2%80%94+transformers+2.0.0+documentation&amp;rft_id=https%3A%2F%2Fhuggingface.co%2Ftransformers%2Fv2.0.0%2Fpretrained_models.html&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-xlnet-160\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-xlnet_160-0\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation web cs1\"><a class=\"external text\" href=\"https://github.com/zihangdai/xlnet/\" rel=\"nofollow\">\"xlnet\"</a>. <i>GitHub</i>. <a class=\"external text\" href=\"https://web.archive.org/web/20240102191842/https://github.com/zihangdai/xlnet/\" rel=\"nofollow\">Archived</a> from the original on 2 January 2024<span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">2 January</span> 2024</span>.</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=GitHub&amp;rft.atitle=xlnet&amp;rft_id=https%3A%2F%2Fgithub.com%2Fzihangdai%2Fxlnet%2F&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-LX3rI-161\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-LX3rI_161-0\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation arxiv cs1\" id=\"CITEREFYangDaiYangCarbonell2020\">Yang, Zhilin; Dai, Zihang; Yang, Yiming; Carbonell, Jaime; Salakhutdinov, Ruslan; Le, Quoc V. (2 January 2020). \"XLNet: Generalized Autoregressive Pretraining for Language Understanding\". <a class=\"mw-redirect\" href=\"/wiki/ArXiv_(identifier)\" title=\"ArXiv (identifier)\">arXiv</a>:<span class=\"id-lock-free\" title=\"Freely accessible\"><a class=\"external text\" href=\"https://arxiv.org/abs/1906.08237\" rel=\"nofollow\">1906.08237</a></span> [<a class=\"external text\" href=\"https://arxiv.org/archive/cs.CL\" rel=\"nofollow\">cs.CL</a>].</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=preprint&amp;rft.jtitle=arXiv&amp;rft.atitle=XLNet%3A+Generalized+Autoregressive+Pretraining+for+Language+Understanding&amp;rft.date=2020-01-02&amp;rft_id=info%3Aarxiv%2F1906.08237&amp;rft.aulast=Yang&amp;rft.aufirst=Zhilin&amp;rft.au=Dai%2C+Zihang&amp;rft.au=Yang%2C+Yiming&amp;rft.au=Carbonell%2C+Jaime&amp;rft.au=Salakhutdinov%2C+Ruslan&amp;rft.au=Le%2C+Quoc+V.&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-15Brelease-162\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-15Brelease_162-0\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation web cs1\"><a class=\"external text\" href=\"https://openai.com/blog/gpt-2-1-5b-release/\" rel=\"nofollow\">\"GPT-2: 1.5B Release\"</a>. <i>OpenAI</i>. 2019-11-05. <a class=\"external text\" href=\"https://web.archive.org/web/20191114074358/https://openai.com/blog/gpt-2-1-5b-release/\" rel=\"nofollow\">Archived</a> from the original on 2019-11-14<span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">2019-11-14</span></span>.</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=OpenAI&amp;rft.atitle=GPT-2%3A+1.5B+Release&amp;rft.date=2019-11-05&amp;rft_id=https%3A%2F%2Fopenai.com%2Fblog%2Fgpt-2-1-5b-release%2F&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-5T8u5-163\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-5T8u5_163-0\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation web cs1\"><a class=\"external text\" href=\"https://openai.com/research/better-language-models\" rel=\"nofollow\">\"Better language models and their implications\"</a>. <i>openai.com</i>. <a class=\"external text\" href=\"https://web.archive.org/web/20230316160730/https://openai.com/research/better-language-models\" rel=\"nofollow\">Archived</a> from the original on 2023-03-16<span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">2023-03-13</span></span>.</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=openai.com&amp;rft.atitle=Better+language+models+and+their+implications&amp;rft_id=https%3A%2F%2Fopenai.com%2Fresearch%2Fbetter-language-models&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-LambdaLabs-164\"><span class=\"mw-cite-backlink\">^ <a href=\"#cite_ref-LambdaLabs_164-0\"><sup><i><b>a</b></i></sup></a> <a href=\"#cite_ref-LambdaLabs_164-1\"><sup><i><b>b</b></i></sup></a></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation web cs1\"><a class=\"external text\" href=\"https://lambdalabs.com/blog/demystifying-gpt-3\" rel=\"nofollow\">\"OpenAI's GPT-3 Language Model: A Technical Overview\"</a>. <i>lambdalabs.com</i>. 3 June 2020. <a class=\"external text\" href=\"https://web.archive.org/web/20230327213811/https://lambdalabs.com/blog/demystifying-gpt-3\" rel=\"nofollow\">Archived</a> from the original on 27 March 2023<span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">13 March</span> 2023</span>.</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=lambdalabs.com&amp;rft.atitle=OpenAI%27s+GPT-3+Language+Model%3A+A+Technical+Overview&amp;rft.date=2020-06-03&amp;rft_id=https%3A%2F%2Flambdalabs.com%2Fblog%2Fdemystifying-gpt-3&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-:10-165\"><span class=\"mw-cite-backlink\">^ <a href=\"#cite_ref-:10_165-0\"><sup><i><b>a</b></i></sup></a> <a href=\"#cite_ref-:10_165-1\"><sup><i><b>b</b></i></sup></a></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation web cs1\"><a class=\"external text\" href=\"https://huggingface.co/openai-community/gpt2-xl\" rel=\"nofollow\">\"openai-community/gpt2-xl · Hugging Face\"</a>. <i>huggingface.co</i>. <a class=\"external text\" href=\"https://web.archive.org/web/20240724041702/https://huggingface.co/openai-community/gpt2-xl\" rel=\"nofollow\">Archived</a> from the original on 2024-07-24<span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">2024-07-24</span></span>.</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=huggingface.co&amp;rft.atitle=openai-community%2Fgpt2-xl+%C2%B7+Hugging+Face&amp;rft_id=https%3A%2F%2Fhuggingface.co%2Fopenai-community%2Fgpt2-xl&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-Sudbe-166\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-Sudbe_166-0\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation web cs1\"><a class=\"external text\" href=\"https://github.com/openai/gpt-2\" rel=\"nofollow\">\"gpt-2\"</a>. <i>GitHub</i>. <a class=\"external text\" href=\"https://web.archive.org/web/20230311154936/https://github.com/openai/gpt-2\" rel=\"nofollow\">Archived</a> from the original on 11 March 2023<span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">13 March</span> 2023</span>.</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=GitHub&amp;rft.atitle=gpt-2&amp;rft_id=https%3A%2F%2Fgithub.com%2Fopenai%2Fgpt-2&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-:2-167\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-:2_167-0\">^</a></b></span> <span class=\"reference-text\">Table D.1 in <link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation arxiv cs1\" id=\"CITEREFBrownMannRyderSubbiah2020\">Brown, Tom B.; Mann, Benjamin; Ryder, Nick; Subbiah, Melanie; Kaplan, Jared; Dhariwal, Prafulla; Neelakantan, Arvind; Shyam, Pranav; Sastry, Girish; Askell, Amanda; Agarwal, Sandhini; Herbert-Voss, Ariel; Krueger, Gretchen; Henighan, Tom; Child, Rewon; Ramesh, Aditya; Ziegler, Daniel M.; Wu, Jeffrey; Winter, Clemens; Hesse, Christopher; Chen, Mark; Sigler, Eric; Litwin, Mateusz; Gray, Scott; Chess, Benjamin; Clark, Jack; Berner, Christopher; McCandlish, Sam; Radford, Alec; Sutskever, Ilya; Amodei, Dario (May 28, 2020). \"Language Models are Few-Shot Learners\". <a class=\"mw-redirect\" href=\"/wiki/ArXiv_(identifier)\" title=\"ArXiv (identifier)\">arXiv</a>:<span class=\"id-lock-free\" title=\"Freely accessible\"><a class=\"external text\" href=\"https://arxiv.org/abs/2005.14165v4\" rel=\"nofollow\">2005.14165v4</a></span> [<a class=\"external text\" href=\"https://arxiv.org/archive/cs.CL\" rel=\"nofollow\">cs.CL</a>].</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=preprint&amp;rft.jtitle=arXiv&amp;rft.atitle=Language+Models+are+Few-Shot+Learners&amp;rft.date=2020-05-28&amp;rft_id=info%3Aarxiv%2F2005.14165v4&amp;rft.aulast=Brown&amp;rft.aufirst=Tom+B.&amp;rft.au=Mann%2C+Benjamin&amp;rft.au=Ryder%2C+Nick&amp;rft.au=Subbiah%2C+Melanie&amp;rft.au=Kaplan%2C+Jared&amp;rft.au=Dhariwal%2C+Prafulla&amp;rft.au=Neelakantan%2C+Arvind&amp;rft.au=Shyam%2C+Pranav&amp;rft.au=Sastry%2C+Girish&amp;rft.au=Askell%2C+Amanda&amp;rft.au=Agarwal%2C+Sandhini&amp;rft.au=Herbert-Voss%2C+Ariel&amp;rft.au=Krueger%2C+Gretchen&amp;rft.au=Henighan%2C+Tom&amp;rft.au=Child%2C+Rewon&amp;rft.au=Ramesh%2C+Aditya&amp;rft.au=Ziegler%2C+Daniel+M.&amp;rft.au=Wu%2C+Jeffrey&amp;rft.au=Winter%2C+Clemens&amp;rft.au=Hesse%2C+Christopher&amp;rft.au=Chen%2C+Mark&amp;rft.au=Sigler%2C+Eric&amp;rft.au=Litwin%2C+Mateusz&amp;rft.au=Gray%2C+Scott&amp;rft.au=Chess%2C+Benjamin&amp;rft.au=Clark%2C+Jack&amp;rft.au=Berner%2C+Christopher&amp;rft.au=McCandlish%2C+Sam&amp;rft.au=Radford%2C+Alec&amp;rft.au=Sutskever%2C+Ilya&amp;rft.au=Amodei%2C+Dario&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-chatgpt-blog-168\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-chatgpt-blog_168-0\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation web cs1\"><a class=\"external text\" href=\"https://openai.com/blog/chatgpt/\" rel=\"nofollow\">\"ChatGPT: Optimizing Language Models for Dialogue\"</a>. <i>OpenAI</i>. 2022-11-30. <a class=\"external text\" href=\"https://web.archive.org/web/20221130180912/https://openai.com/blog/chatgpt/\" rel=\"nofollow\">Archived</a> from the original on 2022-11-30<span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">2023-01-13</span></span>.</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=OpenAI&amp;rft.atitle=ChatGPT%3A+Optimizing+Language+Models+for+Dialogue&amp;rft.date=2022-11-30&amp;rft_id=https%3A%2F%2Fopenai.com%2Fblog%2Fchatgpt%2F&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-gpt-neo-169\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-gpt-neo_169-0\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation web cs1\"><a class=\"external text\" href=\"https://github.com/EleutherAI/gpt-neo\" rel=\"nofollow\">\"GPT Neo\"</a>. March 15, 2023. <a class=\"external text\" href=\"https://web.archive.org/web/20230312225202/https://github.com/EleutherAI/gpt-neo\" rel=\"nofollow\">Archived</a> from the original on March 12, 2023<span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">March 12,</span> 2023</span> – via GitHub.</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=GPT+Neo&amp;rft.date=2023-03-15&amp;rft_id=https%3A%2F%2Fgithub.com%2FEleutherAI%2Fgpt-neo&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-Pile-170\"><span class=\"mw-cite-backlink\">^ <a href=\"#cite_ref-Pile_170-0\"><sup><i><b>a</b></i></sup></a> <a href=\"#cite_ref-Pile_170-1\"><sup><i><b>b</b></i></sup></a> <a href=\"#cite_ref-Pile_170-2\"><sup><i><b>c</b></i></sup></a></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation arxiv cs1\" id=\"CITEREFGaoBidermanBlackGolding2020\">Gao, Leo; Biderman, Stella; Black, Sid; Golding, Laurence; Hoppe, Travis; Foster, Charles; Phang, Jason; He, Horace; Thite, Anish; Nabeshima, Noa; Presser, Shawn; Leahy, Connor (31 December 2020). \"The Pile: An 800GB Dataset of Diverse Text for Language Modeling\". <a class=\"mw-redirect\" href=\"/wiki/ArXiv_(identifier)\" title=\"ArXiv (identifier)\">arXiv</a>:<span class=\"id-lock-free\" title=\"Freely accessible\"><a class=\"external text\" href=\"https://arxiv.org/abs/2101.00027\" rel=\"nofollow\">2101.00027</a></span> [<a class=\"external text\" href=\"https://arxiv.org/archive/cs.CL\" rel=\"nofollow\">cs.CL</a>].</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=preprint&amp;rft.jtitle=arXiv&amp;rft.atitle=The+Pile%3A+An+800GB+Dataset+of+Diverse+Text+for+Language+Modeling&amp;rft.date=2020-12-31&amp;rft_id=info%3Aarxiv%2F2101.00027&amp;rft.aulast=Gao&amp;rft.aufirst=Leo&amp;rft.au=Biderman%2C+Stella&amp;rft.au=Black%2C+Sid&amp;rft.au=Golding%2C+Laurence&amp;rft.au=Hoppe%2C+Travis&amp;rft.au=Foster%2C+Charles&amp;rft.au=Phang%2C+Jason&amp;rft.au=He%2C+Horace&amp;rft.au=Thite%2C+Anish&amp;rft.au=Nabeshima%2C+Noa&amp;rft.au=Presser%2C+Shawn&amp;rft.au=Leahy%2C+Connor&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-vb-gpt-neo-171\"><span class=\"mw-cite-backlink\">^ <a href=\"#cite_ref-vb-gpt-neo_171-0\"><sup><i><b>a</b></i></sup></a> <a href=\"#cite_ref-vb-gpt-neo_171-1\"><sup><i><b>b</b></i></sup></a></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation web cs1\" id=\"CITEREFIyer2021\">Iyer, Abhishek (15 May 2021). <a class=\"external text\" href=\"https://venturebeat.com/ai/gpt-3s-free-alternative-gpt-neo-is-something-to-be-excited-about/\" rel=\"nofollow\">\"GPT-3's free alternative GPT-Neo is something to be excited about\"</a>. <i>VentureBeat</i>. <a class=\"external text\" href=\"https://web.archive.org/web/20230309012717/https://venturebeat.com/ai/gpt-3s-free-alternative-gpt-neo-is-something-to-be-excited-about/\" rel=\"nofollow\">Archived</a> from the original on 9 March 2023<span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">13 March</span> 2023</span>.</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=VentureBeat&amp;rft.atitle=GPT-3%27s+free+alternative+GPT-Neo+is+something+to+be+excited+about&amp;rft.date=2021-05-15&amp;rft.aulast=Iyer&amp;rft.aufirst=Abhishek&amp;rft_id=https%3A%2F%2Fventurebeat.com%2Fai%2Fgpt-3s-free-alternative-gpt-neo-is-something-to-be-excited-about%2F&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-JxohJ-172\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-JxohJ_172-0\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation web cs1\"><a class=\"external text\" href=\"https://web.archive.org/web/20230309205439/https://www.forefront.ai/blog-posts/gpt-j-6b-an-introduction-to-the-largest-open-sourced-gpt-model\" rel=\"nofollow\">\"GPT-J-6B: An Introduction to the Largest Open Source GPT Model | Forefront\"</a>. <i>www.forefront.ai</i>. Archived from <a class=\"external text\" href=\"https://www.forefront.ai/blog-posts/gpt-j-6b-an-introduction-to-the-largest-open-sourced-gpt-model\" rel=\"nofollow\">the original</a> on 2023-03-09<span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">2023-02-28</span></span>.</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=www.forefront.ai&amp;rft.atitle=GPT-J-6B%3A+An+Introduction+to+the+Largest+Open+Source+GPT+Model+%7C+Forefront&amp;rft_id=https%3A%2F%2Fwww.forefront.ai%2Fblog-posts%2Fgpt-j-6b-an-introduction-to-the-largest-open-sourced-gpt-model&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-:3-173\"><span class=\"mw-cite-backlink\">^ <a href=\"#cite_ref-:3_173-0\"><sup><i><b>a</b></i></sup></a> <a href=\"#cite_ref-:3_173-1\"><sup><i><b>b</b></i></sup></a> <a href=\"#cite_ref-:3_173-2\"><sup><i><b>c</b></i></sup></a> <a href=\"#cite_ref-:3_173-3\"><sup><i><b>d</b></i></sup></a></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation arxiv cs1\" id=\"CITEREFDeyGosalZhimingChen2023\">Dey, Nolan; Gosal, Gurpreet; Zhiming; Chen; Khachane, Hemant; Marshall, William; Pathria, Ribhu; Tom, Marvin; Hestness, Joel (2023-04-01). \"Cerebras-GPT: Open Compute-Optimal Language Models Trained on the Cerebras Wafer-Scale Cluster\". <a class=\"mw-redirect\" href=\"/wiki/ArXiv_(identifier)\" title=\"ArXiv (identifier)\">arXiv</a>:<span class=\"id-lock-free\" title=\"Freely accessible\"><a class=\"external text\" href=\"https://arxiv.org/abs/2304.03208\" rel=\"nofollow\">2304.03208</a></span> [<a class=\"external text\" href=\"https://arxiv.org/archive/cs.LG\" rel=\"nofollow\">cs.LG</a>].</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=preprint&amp;rft.jtitle=arXiv&amp;rft.atitle=Cerebras-GPT%3A+Open+Compute-Optimal+Language+Models+Trained+on+the+Cerebras+Wafer-Scale+Cluster&amp;rft.date=2023-04-01&amp;rft_id=info%3Aarxiv%2F2304.03208&amp;rft.aulast=Dey&amp;rft.aufirst=Nolan&amp;rft.au=Gosal%2C+Gurpreet&amp;rft.au=Zhiming&amp;rft.au=Chen&amp;rft.au=Khachane%2C+Hemant&amp;rft.au=Marshall%2C+William&amp;rft.au=Pathria%2C+Ribhu&amp;rft.au=Tom%2C+Marvin&amp;rft.au=Hestness%2C+Joel&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-BwnW5-174\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-BwnW5_174-0\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation web cs1\" id=\"CITEREFAlviKharya2021\">Alvi, Ali; Kharya, Paresh (11 October 2021). <a class=\"external text\" href=\"https://www.microsoft.com/en-us/research/blog/using-deepspeed-and-megatron-to-train-megatron-turing-nlg-530b-the-worlds-largest-and-most-powerful-generative-language-model/\" rel=\"nofollow\">\"Using DeepSpeed and Megatron to Train Megatron-Turing NLG 530B, the World's Largest and Most Powerful Generative Language Model\"</a>. <i>Microsoft Research</i>. <a class=\"external text\" href=\"https://web.archive.org/web/20230313180531/https://www.microsoft.com/en-us/research/blog/using-deepspeed-and-megatron-to-train-megatron-turing-nlg-530b-the-worlds-largest-and-most-powerful-generative-language-model/\" rel=\"nofollow\">Archived</a> from the original on 13 March 2023<span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">13 March</span> 2023</span>.</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=Microsoft+Research&amp;rft.atitle=Using+DeepSpeed+and+Megatron+to+Train+Megatron-Turing+NLG+530B%2C+the+World%27s+Largest+and+Most+Powerful+Generative+Language+Model&amp;rft.date=2021-10-11&amp;rft.aulast=Alvi&amp;rft.aufirst=Ali&amp;rft.au=Kharya%2C+Paresh&amp;rft_id=https%3A%2F%2Fwww.microsoft.com%2Fen-us%2Fresearch%2Fblog%2Fusing-deepspeed-and-megatron-to-train-megatron-turing-nlg-530b-the-worlds-largest-and-most-powerful-generative-language-model%2F&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-mtnlg-preprint-175\"><span class=\"mw-cite-backlink\">^ <a href=\"#cite_ref-mtnlg-preprint_175-0\"><sup><i><b>a</b></i></sup></a> <a href=\"#cite_ref-mtnlg-preprint_175-1\"><sup><i><b>b</b></i></sup></a></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation arxiv cs1\" id=\"CITEREFSmithPatwaryNorickLeGresley2022\">Smith, Shaden; Patwary, Mostofa; Norick, Brandon; LeGresley, Patrick; Rajbhandari, Samyam; Casper, Jared; Liu, Zhun; Prabhumoye, Shrimai; Zerveas, George; Korthikanti, Vijay; Zhang, Elton; Child, Rewon; Aminabadi, Reza Yazdani; Bernauer, Julie; Song, Xia (2022-02-04). \"Using DeepSpeed and Megatron to Train Megatron-Turing NLG 530B, A Large-Scale Generative Language Model\". <a class=\"mw-redirect\" href=\"/wiki/ArXiv_(identifier)\" title=\"ArXiv (identifier)\">arXiv</a>:<span class=\"id-lock-free\" title=\"Freely accessible\"><a class=\"external text\" href=\"https://arxiv.org/abs/2201.11990\" rel=\"nofollow\">2201.11990</a></span> [<a class=\"external text\" href=\"https://arxiv.org/archive/cs.CL\" rel=\"nofollow\">cs.CL</a>].</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=preprint&amp;rft.jtitle=arXiv&amp;rft.atitle=Using+DeepSpeed+and+Megatron+to+Train+Megatron-Turing+NLG+530B%2C+A+Large-Scale+Generative+Language+Model&amp;rft.date=2022-02-04&amp;rft_id=info%3Aarxiv%2F2201.11990&amp;rft.aulast=Smith&amp;rft.aufirst=Shaden&amp;rft.au=Patwary%2C+Mostofa&amp;rft.au=Norick%2C+Brandon&amp;rft.au=LeGresley%2C+Patrick&amp;rft.au=Rajbhandari%2C+Samyam&amp;rft.au=Casper%2C+Jared&amp;rft.au=Liu%2C+Zhun&amp;rft.au=Prabhumoye%2C+Shrimai&amp;rft.au=Zerveas%2C+George&amp;rft.au=Korthikanti%2C+Vijay&amp;rft.au=Zhang%2C+Elton&amp;rft.au=Child%2C+Rewon&amp;rft.au=Aminabadi%2C+Reza+Yazdani&amp;rft.au=Bernauer%2C+Julie&amp;rft.au=Song%2C+Xia&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-:11-176\"><span class=\"mw-cite-backlink\">^ <a href=\"#cite_ref-:11_176-0\"><sup><i><b>a</b></i></sup></a> <a href=\"#cite_ref-:11_176-1\"><sup><i><b>b</b></i></sup></a></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation cs2\" id=\"CITEREFRajbhandariLiYaoZhang2022\">Rajbhandari, Samyam; Li, Conglong; Yao, Zhewei; Zhang, Minjia; Aminabadi, Reza Yazdani; Awan, Ammar Ahmad; Rasley, Jeff; He, Yuxiong (2022-07-21), <i>DeepSpeed-MoE: Advancing Mixture-of-Experts Inference and Training to Power Next-Generation AI Scale</i>, <a class=\"mw-redirect\" href=\"/wiki/ArXiv_(identifier)\" title=\"ArXiv (identifier)\">arXiv</a>:<span class=\"id-lock-free\" title=\"Freely accessible\"><a class=\"external text\" href=\"https://arxiv.org/abs/2201.05596\" rel=\"nofollow\">2201.05596</a></span></cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=book&amp;rft.btitle=DeepSpeed-MoE%3A+Advancing+Mixture-of-Experts+Inference+and+Training+to+Power+Next-Generation+AI+Scale&amp;rft.date=2022-07-21&amp;rft_id=info%3Aarxiv%2F2201.05596&amp;rft.aulast=Rajbhandari&amp;rft.aufirst=Samyam&amp;rft.au=Li%2C+Conglong&amp;rft.au=Yao%2C+Zhewei&amp;rft.au=Zhang%2C+Minjia&amp;rft.au=Aminabadi%2C+Reza+Yazdani&amp;rft.au=Awan%2C+Ammar+Ahmad&amp;rft.au=Rasley%2C+Jeff&amp;rft.au=He%2C+Yuxiong&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-qeOB8-177\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-qeOB8_177-0\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation arxiv cs1\" id=\"CITEREFWangSunXiangWu2021\">Wang, Shuohuan; Sun, Yu; Xiang, Yang; Wu, Zhihua; Ding, Siyu; Gong, Weibao; Feng, Shikun; Shang, Junyuan; Zhao, Yanbin; Pang, Chao; Liu, Jiaxiang; Chen, Xuyi; Lu, Yuxiang; Liu, Weixin; Wang, Xi; Bai, Yangfan; Chen, Qiuliang; Zhao, Li; Li, Shiyong; Sun, Peng; Yu, Dianhai; Ma, Yanjun; Tian, Hao; Wu, Hua; Wu, Tian; Zeng, Wei; Li, Ge; Gao, Wen; Wang, Haifeng (December 23, 2021). \"ERNIE 3.0 Titan: Exploring Larger-scale Knowledge Enhanced Pre-training for Language Understanding and Generation\". <a class=\"mw-redirect\" href=\"/wiki/ArXiv_(identifier)\" title=\"ArXiv (identifier)\">arXiv</a>:<span class=\"id-lock-free\" title=\"Freely accessible\"><a class=\"external text\" href=\"https://arxiv.org/abs/2112.12731\" rel=\"nofollow\">2112.12731</a></span> [<a class=\"external text\" href=\"https://arxiv.org/archive/cs.CL\" rel=\"nofollow\">cs.CL</a>].</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=preprint&amp;rft.jtitle=arXiv&amp;rft.atitle=ERNIE+3.0+Titan%3A+Exploring+Larger-scale+Knowledge+Enhanced+Pre-training+for+Language+Understanding+and+Generation&amp;rft.date=2021-12-23&amp;rft_id=info%3Aarxiv%2F2112.12731&amp;rft.aulast=Wang&amp;rft.aufirst=Shuohuan&amp;rft.au=Sun%2C+Yu&amp;rft.au=Xiang%2C+Yang&amp;rft.au=Wu%2C+Zhihua&amp;rft.au=Ding%2C+Siyu&amp;rft.au=Gong%2C+Weibao&amp;rft.au=Feng%2C+Shikun&amp;rft.au=Shang%2C+Junyuan&amp;rft.au=Zhao%2C+Yanbin&amp;rft.au=Pang%2C+Chao&amp;rft.au=Liu%2C+Jiaxiang&amp;rft.au=Chen%2C+Xuyi&amp;rft.au=Lu%2C+Yuxiang&amp;rft.au=Liu%2C+Weixin&amp;rft.au=Wang%2C+Xi&amp;rft.au=Bai%2C+Yangfan&amp;rft.au=Chen%2C+Qiuliang&amp;rft.au=Zhao%2C+Li&amp;rft.au=Li%2C+Shiyong&amp;rft.au=Sun%2C+Peng&amp;rft.au=Yu%2C+Dianhai&amp;rft.au=Ma%2C+Yanjun&amp;rft.au=Tian%2C+Hao&amp;rft.au=Wu%2C+Hua&amp;rft.au=Wu%2C+Tian&amp;rft.au=Zeng%2C+Wei&amp;rft.au=Li%2C+Ge&amp;rft.au=Gao%2C+Wen&amp;rft.au=Wang%2C+Haifeng&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-i8jc4-178\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-i8jc4_178-0\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation web cs1\"><a class=\"external text\" href=\"https://www.anthropic.com/product\" rel=\"nofollow\">\"Product\"</a>. <i>Anthropic</i>. <a class=\"external text\" href=\"https://web.archive.org/web/20230316145444/https://www.anthropic.com/product\" rel=\"nofollow\">Archived</a> from the original on 16 March 2023<span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">14 March</span> 2023</span>.</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=Anthropic&amp;rft.atitle=Product&amp;rft_id=https%3A%2F%2Fwww.anthropic.com%2Fproduct&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-AnthroArch-179\"><span class=\"mw-cite-backlink\">^ <a href=\"#cite_ref-AnthroArch_179-0\"><sup><i><b>a</b></i></sup></a> <a href=\"#cite_ref-AnthroArch_179-1\"><sup><i><b>b</b></i></sup></a></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation arxiv cs1\" id=\"CITEREFAskellBaiChenDrain2021\">Askell, Amanda; Bai, Yuntao; Chen, Anna; et al. (9 December 2021). \"A General Language Assistant as a Laboratory for Alignment\". <a class=\"mw-redirect\" href=\"/wiki/ArXiv_(identifier)\" title=\"ArXiv (identifier)\">arXiv</a>:<span class=\"id-lock-free\" title=\"Freely accessible\"><a class=\"external text\" href=\"https://arxiv.org/abs/2112.00861\" rel=\"nofollow\">2112.00861</a></span> [<a class=\"external text\" href=\"https://arxiv.org/archive/cs.CL\" rel=\"nofollow\">cs.CL</a>].</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=preprint&amp;rft.jtitle=arXiv&amp;rft.atitle=A+General+Language+Assistant+as+a+Laboratory+for+Alignment&amp;rft.date=2021-12-09&amp;rft_id=info%3Aarxiv%2F2112.00861&amp;rft.aulast=Askell&amp;rft.aufirst=Amanda&amp;rft.au=Bai%2C+Yuntao&amp;rft.au=Chen%2C+Anna&amp;rft.au=Drain%2C+Dawn&amp;rft.au=Ganguli%2C+Deep&amp;rft.au=Henighan%2C+Tom&amp;rft.au=Jones%2C+Andy&amp;rft.au=Joseph%2C+Nicholas&amp;rft.au=Mann%2C+Ben&amp;rft.au=DasSarma%2C+Nova&amp;rft.au=Elhage%2C+Nelson&amp;rft.au=Hatfield-Dodds%2C+Zac&amp;rft.au=Hernandez%2C+Danny&amp;rft.au=Kernion%2C+Jackson&amp;rft.au=Ndousse%2C+Kamal&amp;rft.au=Olsson%2C+Catherine&amp;rft.au=Amodei%2C+Dario&amp;rft.au=Brown%2C+Tom&amp;rft.au=Clark%2C+Jack&amp;rft.au=McCandlish%2C+Sam&amp;rft.au=Olah%2C+Chris&amp;rft.au=Kaplan%2C+Jared&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-RZqhw-180\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-RZqhw_180-0\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation arxiv cs1\" id=\"CITEREFBaiKadavathKunduAskell2022\">Bai, Yuntao; Kadavath, Saurav; Kundu, Sandipan; et al. (15 December 2022). \"Constitutional AI: Harmlessness from AI Feedback\". <a class=\"mw-redirect\" href=\"/wiki/ArXiv_(identifier)\" title=\"ArXiv (identifier)\">arXiv</a>:<span class=\"id-lock-free\" title=\"Freely accessible\"><a class=\"external text\" href=\"https://arxiv.org/abs/2212.08073\" rel=\"nofollow\">2212.08073</a></span> [<a class=\"external text\" href=\"https://arxiv.org/archive/cs.CL\" rel=\"nofollow\">cs.CL</a>].</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=preprint&amp;rft.jtitle=arXiv&amp;rft.atitle=Constitutional+AI%3A+Harmlessness+from+AI+Feedback&amp;rft.date=2022-12-15&amp;rft_id=info%3Aarxiv%2F2212.08073&amp;rft.aulast=Bai&amp;rft.aufirst=Yuntao&amp;rft.au=Kadavath%2C+Saurav&amp;rft.au=Kundu%2C+Sandipan&amp;rft.au=Askell%2C+Amanda&amp;rft.au=Kernion%2C+Jackson&amp;rft.au=Jones%2C+Andy&amp;rft.au=Chen%2C+Anna&amp;rft.au=Goldie%2C+Anna&amp;rft.au=Mirhoseini%2C+Azalia&amp;rft.au=McKinnon%2C+Cameron&amp;rft.au=Chen%2C+Carol&amp;rft.au=Olsson%2C+Catherine&amp;rft.au=Olah%2C+Christopher&amp;rft.au=Hernandez%2C+Danny&amp;rft.au=Drain%2C+Dawn&amp;rft.au=Ganguli%2C+Deep&amp;rft.au=Li%2C+Dustin&amp;rft.au=Tran-Johnson%2C+Eli&amp;rft.au=Perez%2C+Ethan&amp;rft.au=Kerr%2C+Jamie&amp;rft.au=Mueller%2C+Jared&amp;rft.au=Ladish%2C+Jeffrey&amp;rft.au=Landau%2C+Joshua&amp;rft.au=Ndousse%2C+Kamal&amp;rft.au=Lukosuite%2C+Kamile&amp;rft.au=Lovitt%2C+Liane&amp;rft.au=Sellitto%2C+Michael&amp;rft.au=Elhage%2C+Nelson&amp;rft.au=Schiefer%2C+Nicholas&amp;rft.au=Mercado%2C+Noemi&amp;rft.au=DasSarma%2C+Nova&amp;rft.au=Lasenby%2C+Robert&amp;rft.au=Larson%2C+Robin&amp;rft.au=Ringer%2C+Sam&amp;rft.au=Johnston%2C+Scott&amp;rft.au=Kravec%2C+Shauna&amp;rft.au=Showk%2C+Sheer+El&amp;rft.au=Fort%2C+Stanislav&amp;rft.au=Lanham%2C+Tamera&amp;rft.au=Telleen-Lawton%2C+Timothy&amp;rft.au=Conerly%2C+Tom&amp;rft.au=Henighan%2C+Tom&amp;rft.au=Hume%2C+Tristan&amp;rft.au=Bowman%2C+Samuel+R.&amp;rft.au=Hatfield-Dodds%2C+Zac&amp;rft.au=Mann%2C+Ben&amp;rft.au=Amodei%2C+Dario&amp;rft.au=Joseph%2C+Nicholas&amp;rft.au=McCandlish%2C+Sam&amp;rft.au=Brown%2C+Tom&amp;rft.au=Kaplan%2C+Jared&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-mD5eE-181\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-mD5eE_181-0\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation web cs1\"><a class=\"external text\" href=\"https://www.deepmind.com/blog/language-modelling-at-scale-gopher-ethical-considerations-and-retrieval\" rel=\"nofollow\">\"Language modelling at scale: Gopher, ethical considerations, and retrieval\"</a>. <i>www.deepmind.com</i>. 8 December 2021. <a class=\"external text\" href=\"https://web.archive.org/web/20230320082323/https://www.deepmind.com/blog/language-modelling-at-scale-gopher-ethical-considerations-and-retrieval\" rel=\"nofollow\">Archived</a> from the original on 20 March 2023<span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">20 March</span> 2023</span>.</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=www.deepmind.com&amp;rft.atitle=Language+modelling+at+scale%3A+Gopher%2C+ethical+considerations%2C+and+retrieval&amp;rft.date=2021-12-08&amp;rft_id=https%3A%2F%2Fwww.deepmind.com%2Fblog%2Flanguage-modelling-at-scale-gopher-ethical-considerations-and-retrieval&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-hoffman-182\"><span class=\"mw-cite-backlink\">^ <a href=\"#cite_ref-hoffman_182-0\"><sup><i><b>a</b></i></sup></a> <a href=\"#cite_ref-hoffman_182-1\"><sup><i><b>b</b></i></sup></a> <a href=\"#cite_ref-hoffman_182-2\"><sup><i><b>c</b></i></sup></a></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation arxiv cs1\" id=\"CITEREFHoffmannBorgeaudMenschBuchatskaya2022\">Hoffmann, Jordan; Borgeaud, Sebastian; Mensch, Arthur; et al. (29 March 2022). \"Training Compute-Optimal Large Language Models\". <a class=\"mw-redirect\" href=\"/wiki/ArXiv_(identifier)\" title=\"ArXiv (identifier)\">arXiv</a>:<span class=\"id-lock-free\" title=\"Freely accessible\"><a class=\"external text\" href=\"https://arxiv.org/abs/2203.15556\" rel=\"nofollow\">2203.15556</a></span> [<a class=\"external text\" href=\"https://arxiv.org/archive/cs.CL\" rel=\"nofollow\">cs.CL</a>].</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=preprint&amp;rft.jtitle=arXiv&amp;rft.atitle=Training+Compute-Optimal+Large+Language+Models&amp;rft.date=2022-03-29&amp;rft_id=info%3Aarxiv%2F2203.15556&amp;rft.aulast=Hoffmann&amp;rft.aufirst=Jordan&amp;rft.au=Borgeaud%2C+Sebastian&amp;rft.au=Mensch%2C+Arthur&amp;rft.au=Buchatskaya%2C+Elena&amp;rft.au=Cai%2C+Trevor&amp;rft.au=Rutherford%2C+Eliza&amp;rft.au=Casas%2C+Diego+de+Las&amp;rft.au=Hendricks%2C+Lisa+Anne&amp;rft.au=Welbl%2C+Johannes&amp;rft.au=Clark%2C+Aidan&amp;rft.au=Hennigan%2C+Tom&amp;rft.au=Noland%2C+Eric&amp;rft.au=Millican%2C+Katie&amp;rft.au=Driessche%2C+George+van+den&amp;rft.au=Damoc%2C+Bogdan&amp;rft.au=Guy%2C+Aurelia&amp;rft.au=Osindero%2C+Simon&amp;rft.au=Simonyan%2C+Karen&amp;rft.au=Elsen%2C+Erich&amp;rft.au=Rae%2C+Jack+W.&amp;rft.au=Vinyals%2C+Oriol&amp;rft.au=Sifre%2C+Laurent&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-:4-183\"><span class=\"mw-cite-backlink\">^ <a href=\"#cite_ref-:4_183-0\"><sup><i><b>a</b></i></sup></a> <a href=\"#cite_ref-:4_183-1\"><sup><i><b>b</b></i></sup></a> <a href=\"#cite_ref-:4_183-2\"><sup><i><b>c</b></i></sup></a> <a href=\"#cite_ref-:4_183-3\"><sup><i><b>d</b></i></sup></a></span> <span class=\"reference-text\">Table 20 and page 66 of <i><a class=\"external text\" href=\"https://storage.googleapis.com/pathways-language-model/PaLM-paper.pdf\" rel=\"nofollow\">PaLM: Scaling Language Modeling with Pathways</a> <a class=\"external text\" href=\"https://web.archive.org/web/20230610040050/https://storage.googleapis.com/pathways-language-model/PaLM-paper.pdf\" rel=\"nofollow\">Archived</a> 2023-06-10 at the <a href=\"/wiki/Wayback_Machine\" title=\"Wayback Machine\">Wayback Machine</a></i></span>\n</li>\n<li id=\"cite_note-lamda-blog-184\"><span class=\"mw-cite-backlink\">^ <a href=\"#cite_ref-lamda-blog_184-0\"><sup><i><b>a</b></i></sup></a> <a href=\"#cite_ref-lamda-blog_184-1\"><sup><i><b>b</b></i></sup></a></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation web cs1\" id=\"CITEREFChengThoppilan2022\">Cheng, Heng-Tze; Thoppilan, Romal (January 21, 2022). <a class=\"external text\" href=\"https://ai.googleblog.com/2022/01/lamda-towards-safe-grounded-and-high.html\" rel=\"nofollow\">\"LaMDA: Towards Safe, Grounded, and High-Quality Dialog Models for Everything\"</a>. <i>ai.googleblog.com</i>. <a class=\"external text\" href=\"https://web.archive.org/web/20220325014118/https://ai.googleblog.com/2022/01/lamda-towards-safe-grounded-and-high.html\" rel=\"nofollow\">Archived</a> from the original on 2022-03-25<span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">2023-03-09</span></span>.</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=ai.googleblog.com&amp;rft.atitle=LaMDA%3A+Towards+Safe%2C+Grounded%2C+and+High-Quality+Dialog+Models+for+Everything&amp;rft.date=2022-01-21&amp;rft.aulast=Cheng&amp;rft.aufirst=Heng-Tze&amp;rft.au=Thoppilan%2C+Romal&amp;rft_id=https%3A%2F%2Fai.googleblog.com%2F2022%2F01%2Flamda-towards-safe-grounded-and-high.html&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-DMs9Z-185\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-DMs9Z_185-0\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation arxiv cs1\" id=\"CITEREFThoppilanDe_FreitasHallShazeer2022\">Thoppilan, Romal; De Freitas, Daniel; Hall, Jamie; Shazeer, Noam; Kulshreshtha, Apoorv; Cheng, Heng-Tze; Jin, Alicia; Bos, Taylor; Baker, Leslie; Du, Yu; Li, YaGuang; Lee, Hongrae; Zheng, Huaixiu Steven; Ghafouri, Amin; Menegali, Marcelo (2022-01-01). \"LaMDA: Language Models for Dialog Applications\". <a class=\"mw-redirect\" href=\"/wiki/ArXiv_(identifier)\" title=\"ArXiv (identifier)\">arXiv</a>:<span class=\"id-lock-free\" title=\"Freely accessible\"><a class=\"external text\" href=\"https://arxiv.org/abs/2201.08239\" rel=\"nofollow\">2201.08239</a></span> [<a class=\"external text\" href=\"https://arxiv.org/archive/cs.CL\" rel=\"nofollow\">cs.CL</a>].</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=preprint&amp;rft.jtitle=arXiv&amp;rft.atitle=LaMDA%3A+Language+Models+for+Dialog+Applications&amp;rft.date=2022-01-01&amp;rft_id=info%3Aarxiv%2F2201.08239&amp;rft.aulast=Thoppilan&amp;rft.aufirst=Romal&amp;rft.au=De+Freitas%2C+Daniel&amp;rft.au=Hall%2C+Jamie&amp;rft.au=Shazeer%2C+Noam&amp;rft.au=Kulshreshtha%2C+Apoorv&amp;rft.au=Cheng%2C+Heng-Tze&amp;rft.au=Jin%2C+Alicia&amp;rft.au=Bos%2C+Taylor&amp;rft.au=Baker%2C+Leslie&amp;rft.au=Du%2C+Yu&amp;rft.au=Li%2C+YaGuang&amp;rft.au=Lee%2C+Hongrae&amp;rft.au=Zheng%2C+Huaixiu+Steven&amp;rft.au=Ghafouri%2C+Amin&amp;rft.au=Menegali%2C+Marcelo&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-gpt-neox-20b-186\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-gpt-neox-20b_186-0\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation conference cs1 cs1-prop-long-vol\" id=\"CITEREFBlackBidermanHallahan2022\">Black, Sidney; Biderman, Stella; Hallahan, Eric; et al. (2022-05-01). <a class=\"external text\" href=\"https://aclanthology.org/2022.bigscience-1.9/\" rel=\"nofollow\"><i>GPT-NeoX-20B: An Open-Source Autoregressive Language Model</i></a>. Proceedings of BigScience Episode #5 – Workshop on Challenges &amp; Perspectives in Creating Large Language Models. Vol. Proceedings of BigScience Episode #5 – Workshop on Challenges &amp; Perspectives in Creating Large Language Models. pp. 95–136. <a class=\"external text\" href=\"https://web.archive.org/web/20221210082456/https://aclanthology.org/2022.bigscience-1.9/\" rel=\"nofollow\">Archived</a> from the original on 2022-12-10<span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">2022-12-19</span></span>.</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=conference&amp;rft.btitle=GPT-NeoX-20B%3A+An+Open-Source+Autoregressive+Language+Model&amp;rft.pages=95-136&amp;rft.date=2022-05-01&amp;rft.aulast=Black&amp;rft.aufirst=Sidney&amp;rft.au=Biderman%2C+Stella&amp;rft.au=Hallahan%2C+Eric&amp;rft_id=https%3A%2F%2Faclanthology.org%2F2022.bigscience-1.9%2F&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-chinchilla-blog-187\"><span class=\"mw-cite-backlink\">^ <a href=\"#cite_ref-chinchilla-blog_187-0\"><sup><i><b>a</b></i></sup></a> <a href=\"#cite_ref-chinchilla-blog_187-1\"><sup><i><b>b</b></i></sup></a> <a href=\"#cite_ref-chinchilla-blog_187-2\"><sup><i><b>c</b></i></sup></a></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation web cs1\" id=\"CITEREFHoffmannBorgeaudMenschSifre2022\">Hoffmann, Jordan; Borgeaud, Sebastian; Mensch, Arthur; Sifre, Laurent (12 April 2022). <a class=\"external text\" href=\"https://www.deepmind.com/blog/an-empirical-analysis-of-compute-optimal-large-language-model-training\" rel=\"nofollow\">\"An empirical analysis of compute-optimal large language model training\"</a>. <i>Deepmind Blog</i>. <a class=\"external text\" href=\"https://web.archive.org/web/20220413014510/https://www.deepmind.com/blog/an-empirical-analysis-of-compute-optimal-large-language-model-training\" rel=\"nofollow\">Archived</a> from the original on 13 April 2022<span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">9 March</span> 2023</span>.</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=Deepmind+Blog&amp;rft.atitle=An+empirical+analysis+of+compute-optimal+large+language+model+training&amp;rft.date=2022-04-12&amp;rft.aulast=Hoffmann&amp;rft.aufirst=Jordan&amp;rft.au=Borgeaud%2C+Sebastian&amp;rft.au=Mensch%2C+Arthur&amp;rft.au=Sifre%2C+Laurent&amp;rft_id=https%3A%2F%2Fwww.deepmind.com%2Fblog%2Fan-empirical-analysis-of-compute-optimal-large-language-model-training&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-palm-blog-188\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-palm-blog_188-0\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation web cs1\" id=\"CITEREFNarangChowdhery2022\">Narang, Sharan; Chowdhery, Aakanksha (April 4, 2022). <a class=\"external text\" href=\"https://ai.googleblog.com/2022/04/pathways-language-model-palm-scaling-to.html\" rel=\"nofollow\">\"Pathways Language Model (PaLM): Scaling to 540 Billion Parameters for Breakthrough Performance\"</a>. <i>ai.googleblog.com</i>. <a class=\"external text\" href=\"https://web.archive.org/web/20220404161447/https://ai.googleblog.com/2022/04/pathways-language-model-palm-scaling-to.html\" rel=\"nofollow\">Archived</a> from the original on 2022-04-04<span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">2023-03-09</span></span>.</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=ai.googleblog.com&amp;rft.atitle=Pathways+Language+Model+%28PaLM%29%3A+Scaling+to+540+Billion+Parameters+for+Breakthrough+Performance&amp;rft.date=2022-04-04&amp;rft.aulast=Narang&amp;rft.aufirst=Sharan&amp;rft.au=Chowdhery%2C+Aakanksha&amp;rft_id=https%3A%2F%2Fai.googleblog.com%2F2022%2F04%2Fpathways-language-model-palm-scaling-to.html&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-jlof8-189\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-jlof8_189-0\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation web cs1\" id=\"CITEREFSusan_ZhangMona_DiabLuke_Zettlemoyer\">Susan Zhang; Mona Diab; Luke Zettlemoyer. <a class=\"external text\" href=\"https://ai.facebook.com/blog/democratizing-access-to-large-scale-language-models-with-opt-175b/\" rel=\"nofollow\">\"Democratizing access to large-scale language models with OPT-175B\"</a>. <i>ai.facebook.com</i>. <a class=\"external text\" href=\"https://web.archive.org/web/20230312231820/https://ai.facebook.com/blog/democratizing-access-to-large-scale-language-models-with-opt-175b/\" rel=\"nofollow\">Archived</a> from the original on 2023-03-12<span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">2023-03-12</span></span>.</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=ai.facebook.com&amp;rft.atitle=Democratizing+access+to+large-scale+language+models+with+OPT-175B&amp;rft.au=Susan+Zhang&amp;rft.au=Mona+Diab&amp;rft.au=Luke+Zettlemoyer&amp;rft_id=https%3A%2F%2Fai.facebook.com%2Fblog%2Fdemocratizing-access-to-large-scale-language-models-with-opt-175b%2F&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-QjTIc-190\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-QjTIc_190-0\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation arxiv cs1\" id=\"CITEREFZhangRollerGoyalArtetxe2022\">Zhang, Susan; Roller, Stephen; Goyal, Naman; Artetxe, Mikel; Chen, Moya; Chen, Shuohui; Dewan, Christopher; Diab, Mona; Li, Xian; Lin, Xi Victoria; Mihaylov, Todor; Ott, Myle; Shleifer, Sam; Shuster, Kurt; Simig, Daniel; Koura, Punit Singh; Sridhar, Anjali; Wang, Tianlu; Zettlemoyer, Luke (21 June 2022). \"OPT: Open Pre-trained Transformer Language Models\". <a class=\"mw-redirect\" href=\"/wiki/ArXiv_(identifier)\" title=\"ArXiv (identifier)\">arXiv</a>:<span class=\"id-lock-free\" title=\"Freely accessible\"><a class=\"external text\" href=\"https://arxiv.org/abs/2205.01068\" rel=\"nofollow\">2205.01068</a></span> [<a class=\"external text\" href=\"https://arxiv.org/archive/cs.CL\" rel=\"nofollow\">cs.CL</a>].</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=preprint&amp;rft.jtitle=arXiv&amp;rft.atitle=OPT%3A+Open+Pre-trained+Transformer+Language+Models&amp;rft.date=2022-06-21&amp;rft_id=info%3Aarxiv%2F2205.01068&amp;rft.aulast=Zhang&amp;rft.aufirst=Susan&amp;rft.au=Roller%2C+Stephen&amp;rft.au=Goyal%2C+Naman&amp;rft.au=Artetxe%2C+Mikel&amp;rft.au=Chen%2C+Moya&amp;rft.au=Chen%2C+Shuohui&amp;rft.au=Dewan%2C+Christopher&amp;rft.au=Diab%2C+Mona&amp;rft.au=Li%2C+Xian&amp;rft.au=Lin%2C+Xi+Victoria&amp;rft.au=Mihaylov%2C+Todor&amp;rft.au=Ott%2C+Myle&amp;rft.au=Shleifer%2C+Sam&amp;rft.au=Shuster%2C+Kurt&amp;rft.au=Simig%2C+Daniel&amp;rft.au=Koura%2C+Punit+Singh&amp;rft.au=Sridhar%2C+Anjali&amp;rft.au=Wang%2C+Tianlu&amp;rft.au=Zettlemoyer%2C+Luke&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-192\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-192\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation web cs1\"><a class=\"external text\" href=\"https://github.com/facebookresearch/metaseq/tree/main/projects/OPT/chronicles\" rel=\"nofollow\">\"metaseq/projects/OPT/chronicles at main · facebookresearch/metaseq\"</a>. <i>GitHub</i><span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">2024-10-18</span></span>.</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=GitHub&amp;rft.atitle=metaseq%2Fprojects%2FOPT%2Fchronicles+at+main+%C2%B7+facebookresearch%2Fmetaseq&amp;rft_id=https%3A%2F%2Fgithub.com%2Ffacebookresearch%2Fmetaseq%2Ftree%2Fmain%2Fprojects%2FOPT%2Fchronicles&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-yalm-repo-193\"><span class=\"mw-cite-backlink\">^ <a href=\"#cite_ref-yalm-repo_193-0\"><sup><i><b>a</b></i></sup></a> <a href=\"#cite_ref-yalm-repo_193-1\"><sup><i><b>b</b></i></sup></a></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation cs2\" id=\"CITEREFKhrushchevVasilevPetrovZinov2022\">Khrushchev, Mikhail; Vasilev, Ruslan; Petrov, Alexey; Zinov, Nikolay (2022-06-22), <a class=\"external text\" href=\"https://github.com/yandex/YaLM-100B\" rel=\"nofollow\"><i>YaLM 100B</i></a>, <a class=\"external text\" href=\"https://web.archive.org/web/20230616050056/https://github.com/yandex/YaLM-100B\" rel=\"nofollow\">archived</a> from the original on 2023-06-16<span class=\"reference-accessdate\">, retrieved <span class=\"nowrap\">2023-03-18</span></span></cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=book&amp;rft.btitle=YaLM+100B&amp;rft.date=2022-06-22&amp;rft.aulast=Khrushchev&amp;rft.aufirst=Mikhail&amp;rft.au=Vasilev%2C+Ruslan&amp;rft.au=Petrov%2C+Alexey&amp;rft.au=Zinov%2C+Nikolay&amp;rft_id=https%3A%2F%2Fgithub.com%2Fyandex%2FYaLM-100B&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-minerva-paper-194\"><span class=\"mw-cite-backlink\">^ <a href=\"#cite_ref-minerva-paper_194-0\"><sup><i><b>a</b></i></sup></a> <a href=\"#cite_ref-minerva-paper_194-1\"><sup><i><b>b</b></i></sup></a></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation arxiv cs1\" id=\"CITEREFLewkowyczAndreassenDohanDyer2022\">Lewkowycz, Aitor; Andreassen, Anders; Dohan, David; Dyer, Ethan; Michalewski, Henryk; Ramasesh, Vinay; Slone, Ambrose; Anil, Cem; Schlag, Imanol; Gutman-Solo, Theo; Wu, Yuhuai; Neyshabur, Behnam; Gur-Ari, Guy; Misra, Vedant (30 June 2022). \"Solving Quantitative Reasoning Problems with Language Models\". <a class=\"mw-redirect\" href=\"/wiki/ArXiv_(identifier)\" title=\"ArXiv (identifier)\">arXiv</a>:<span class=\"id-lock-free\" title=\"Freely accessible\"><a class=\"external text\" href=\"https://arxiv.org/abs/2206.14858\" rel=\"nofollow\">2206.14858</a></span> [<a class=\"external text\" href=\"https://arxiv.org/archive/cs.CL\" rel=\"nofollow\">cs.CL</a>].</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=preprint&amp;rft.jtitle=arXiv&amp;rft.atitle=Solving+Quantitative+Reasoning+Problems+with+Language+Models&amp;rft.date=2022-06-30&amp;rft_id=info%3Aarxiv%2F2206.14858&amp;rft.aulast=Lewkowycz&amp;rft.aufirst=Aitor&amp;rft.au=Andreassen%2C+Anders&amp;rft.au=Dohan%2C+David&amp;rft.au=Dyer%2C+Ethan&amp;rft.au=Michalewski%2C+Henryk&amp;rft.au=Ramasesh%2C+Vinay&amp;rft.au=Slone%2C+Ambrose&amp;rft.au=Anil%2C+Cem&amp;rft.au=Schlag%2C+Imanol&amp;rft.au=Gutman-Solo%2C+Theo&amp;rft.au=Wu%2C+Yuhuai&amp;rft.au=Neyshabur%2C+Behnam&amp;rft.au=Gur-Ari%2C+Guy&amp;rft.au=Misra%2C+Vedant&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-FfCNK-195\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-FfCNK_195-0\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation web cs1\"><a class=\"external text\" href=\"https://ai.googleblog.com/2022/06/minerva-solving-quantitative-reasoning.html\" rel=\"nofollow\">\"Minerva: Solving Quantitative Reasoning Problems with Language Models\"</a>. <i>ai.googleblog.com</i>. 30 June 2022<span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">20 March</span> 2023</span>.</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=ai.googleblog.com&amp;rft.atitle=Minerva%3A+Solving+Quantitative+Reasoning+Problems+with+Language+Models&amp;rft.date=2022-06-30&amp;rft_id=https%3A%2F%2Fai.googleblog.com%2F2022%2F06%2Fminerva-solving-quantitative-reasoning.html&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-bigger-better-196\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-bigger-better_196-0\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation journal cs1\" id=\"CITEREFAnanthaswamy2023\">Ananthaswamy, Anil (8 March 2023). <a class=\"external text\" href=\"https://www.nature.com/articles/d41586-023-00641-w\" rel=\"nofollow\">\"In AI, is bigger always better?\"</a>. <i>Nature</i>. <b>615</b> (7951): 202–205. <a class=\"mw-redirect\" href=\"/wiki/Bibcode_(identifier)\" title=\"Bibcode (identifier)\">Bibcode</a>:<a class=\"external text\" href=\"https://ui.adsabs.harvard.edu/abs/2023Natur.615..202A\" rel=\"nofollow\">2023Natur.615..202A</a>. <a class=\"mw-redirect\" href=\"/wiki/Doi_(identifier)\" title=\"Doi (identifier)\">doi</a>:<a class=\"external text\" href=\"https://doi.org/10.1038%2Fd41586-023-00641-w\" rel=\"nofollow\">10.1038/d41586-023-00641-w</a>. <a class=\"mw-redirect\" href=\"/wiki/PMID_(identifier)\" title=\"PMID (identifier)\">PMID</a> <a class=\"external text\" href=\"https://pubmed.ncbi.nlm.nih.gov/36890378\" rel=\"nofollow\">36890378</a>. <a class=\"mw-redirect\" href=\"/wiki/S2CID_(identifier)\" title=\"S2CID (identifier)\">S2CID</a> <a class=\"external text\" href=\"https://api.semanticscholar.org/CorpusID:257380916\" rel=\"nofollow\">257380916</a>. <a class=\"external text\" href=\"https://web.archive.org/web/20230316181013/https://www.nature.com/articles/d41586-023-00641-w\" rel=\"nofollow\">Archived</a> from the original on 16 March 2023<span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">9 March</span> 2023</span>.</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=Nature&amp;rft.atitle=In+AI%2C+is+bigger+always+better%3F&amp;rft.volume=615&amp;rft.issue=7951&amp;rft.pages=202-205&amp;rft.date=2023-03-08&amp;rft_id=info%3Adoi%2F10.1038%2Fd41586-023-00641-w&amp;rft_id=https%3A%2F%2Fapi.semanticscholar.org%2FCorpusID%3A257380916%23id-name%3DS2CID&amp;rft_id=info%3Apmid%2F36890378&amp;rft_id=info%3Abibcode%2F2023Natur.615..202A&amp;rft.aulast=Ananthaswamy&amp;rft.aufirst=Anil&amp;rft_id=https%3A%2F%2Fwww.nature.com%2Farticles%2Fd41586-023-00641-w&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-B8wB2-197\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-B8wB2_197-0\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation web cs1\"><a class=\"external text\" href=\"https://huggingface.co/bigscience/bloom\" rel=\"nofollow\">\"bigscience/bloom · Hugging Face\"</a>. <i>huggingface.co</i>. <a class=\"external text\" href=\"https://web.archive.org/web/20230412002547/https://huggingface.co/bigscience/bloom\" rel=\"nofollow\">Archived</a> from the original on 2023-04-12<span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">2023-03-13</span></span>.</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=huggingface.co&amp;rft.atitle=bigscience%2Fbloom+%C2%B7+Hugging+Face&amp;rft_id=https%3A%2F%2Fhuggingface.co%2Fbigscience%2Fbloom&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-37sY6-198\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-37sY6_198-0\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation arxiv cs1\" id=\"CITEREFTaylorKardasCucurullScialom2022\">Taylor, Ross; Kardas, Marcin; Cucurull, Guillem; Scialom, Thomas; Hartshorn, Anthony; Saravia, Elvis; Poulton, Andrew; Kerkez, Viktor; Stojnic, Robert (16 November 2022). \"Galactica: A Large Language Model for Science\". <a class=\"mw-redirect\" href=\"/wiki/ArXiv_(identifier)\" title=\"ArXiv (identifier)\">arXiv</a>:<span class=\"id-lock-free\" title=\"Freely accessible\"><a class=\"external text\" href=\"https://arxiv.org/abs/2211.09085\" rel=\"nofollow\">2211.09085</a></span> [<a class=\"external text\" href=\"https://arxiv.org/archive/cs.CL\" rel=\"nofollow\">cs.CL</a>].</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=preprint&amp;rft.jtitle=arXiv&amp;rft.atitle=Galactica%3A+A+Large+Language+Model+for+Science&amp;rft.date=2022-11-16&amp;rft_id=info%3Aarxiv%2F2211.09085&amp;rft.aulast=Taylor&amp;rft.aufirst=Ross&amp;rft.au=Kardas%2C+Marcin&amp;rft.au=Cucurull%2C+Guillem&amp;rft.au=Scialom%2C+Thomas&amp;rft.au=Hartshorn%2C+Anthony&amp;rft.au=Saravia%2C+Elvis&amp;rft.au=Poulton%2C+Andrew&amp;rft.au=Kerkez%2C+Viktor&amp;rft.au=Stojnic%2C+Robert&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-u5szh-199\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-u5szh_199-0\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation web cs1\"><a class=\"external text\" href=\"https://www.amazon.science/blog/20b-parameter-alexa-model-sets-new-marks-in-few-shot-learning\" rel=\"nofollow\">\"20B-parameter Alexa model sets new marks in few-shot learning\"</a>. <i>Amazon Science</i>. 2 August 2022. <a class=\"external text\" href=\"https://web.archive.org/web/20230315190223/https://www.amazon.science/blog/20b-parameter-alexa-model-sets-new-marks-in-few-shot-learning\" rel=\"nofollow\">Archived</a> from the original on 15 March 2023<span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">12 March</span> 2023</span>.</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=Amazon+Science&amp;rft.atitle=20B-parameter+Alexa+model+sets+new+marks+in+few-shot+learning&amp;rft.date=2022-08-02&amp;rft_id=https%3A%2F%2Fwww.amazon.science%2Fblog%2F20b-parameter-alexa-model-sets-new-marks-in-few-shot-learning&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-HaA7l-200\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-HaA7l_200-0\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation arxiv cs1\" id=\"CITEREFSoltanAnanthakrishnanFitzGeraldGupta2022\">Soltan, Saleh; Ananthakrishnan, Shankar; FitzGerald, Jack; et al. (3 August 2022). \"AlexaTM 20B: Few-Shot Learning Using a Large-Scale Multilingual Seq2Seq Model\". <a class=\"mw-redirect\" href=\"/wiki/ArXiv_(identifier)\" title=\"ArXiv (identifier)\">arXiv</a>:<span class=\"id-lock-free\" title=\"Freely accessible\"><a class=\"external text\" href=\"https://arxiv.org/abs/2208.01448\" rel=\"nofollow\">2208.01448</a></span> [<a class=\"external text\" href=\"https://arxiv.org/archive/cs.CL\" rel=\"nofollow\">cs.CL</a>].</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=preprint&amp;rft.jtitle=arXiv&amp;rft.atitle=AlexaTM+20B%3A+Few-Shot+Learning+Using+a+Large-Scale+Multilingual+Seq2Seq+Model&amp;rft.date=2022-08-03&amp;rft_id=info%3Aarxiv%2F2208.01448&amp;rft.aulast=Soltan&amp;rft.aufirst=Saleh&amp;rft.au=Ananthakrishnan%2C+Shankar&amp;rft.au=FitzGerald%2C+Jack&amp;rft.au=Gupta%2C+Rahul&amp;rft.au=Hamza%2C+Wael&amp;rft.au=Khan%2C+Haidar&amp;rft.au=Peris%2C+Charith&amp;rft.au=Rawls%2C+Stephen&amp;rft.au=Rosenbaum%2C+Andy&amp;rft.au=Rumshisky%2C+Anna&amp;rft.au=Prakash%2C+Chandana+Satya&amp;rft.au=Sridhar%2C+Mukund&amp;rft.au=Triefenbach%2C+Fabian&amp;rft.au=Verma%2C+Apurv&amp;rft.au=Tur%2C+Gokhan&amp;rft.au=Natarajan%2C+Prem&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-rpehM-201\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-rpehM_201-0\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation web cs1\"><a class=\"external text\" href=\"https://aws.amazon.com/blogs/machine-learning/alexatm-20b-is-now-available-in-amazon-sagemaker-jumpstart/\" rel=\"nofollow\">\"AlexaTM 20B is now available in Amazon SageMaker JumpStart | AWS Machine Learning Blog\"</a>. <i>aws.amazon.com</i>. 17 November 2022. <a class=\"external text\" href=\"https://web.archive.org/web/20230313163933/https://aws.amazon.com/blogs/machine-learning/alexatm-20b-is-now-available-in-amazon-sagemaker-jumpstart/\" rel=\"nofollow\">Archived</a> from the original on 13 March 2023<span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">13 March</span> 2023</span>.</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=aws.amazon.com&amp;rft.atitle=AlexaTM+20B+is+now+available+in+Amazon+SageMaker+JumpStart+%7C+AWS+Machine+Learning+Blog&amp;rft.date=2022-11-17&amp;rft_id=https%3A%2F%2Faws.amazon.com%2Fblogs%2Fmachine-learning%2Falexatm-20b-is-now-available-in-amazon-sagemaker-jumpstart%2F&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-llama-blog-202\"><span class=\"mw-cite-backlink\">^ <a href=\"#cite_ref-llama-blog_202-0\"><sup><i><b>a</b></i></sup></a> <a href=\"#cite_ref-llama-blog_202-1\"><sup><i><b>b</b></i></sup></a> <a href=\"#cite_ref-llama-blog_202-2\"><sup><i><b>c</b></i></sup></a></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation web cs1\"><a class=\"external text\" href=\"https://ai.facebook.com/blog/large-language-model-llama-meta-ai/\" rel=\"nofollow\">\"Introducing LLaMA: A foundational, 65-billion-parameter large language model\"</a>. <i>Meta AI</i>. 24 February 2023. <a class=\"external text\" href=\"https://web.archive.org/web/20230303112302/https://ai.facebook.com/blog/large-language-model-llama-meta-ai/\" rel=\"nofollow\">Archived</a> from the original on 3 March 2023<span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">9 March</span> 2023</span>.</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=Meta+AI&amp;rft.atitle=Introducing+LLaMA%3A+A+foundational%2C+65-billion-parameter+large+language+model&amp;rft.date=2023-02-24&amp;rft_id=https%3A%2F%2Fai.facebook.com%2Fblog%2Flarge-language-model-llama-meta-ai%2F&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-:5-203\"><span class=\"mw-cite-backlink\">^ <a href=\"#cite_ref-:5_203-0\"><sup><i><b>a</b></i></sup></a> <a href=\"#cite_ref-:5_203-1\"><sup><i><b>b</b></i></sup></a> <a href=\"#cite_ref-:5_203-2\"><sup><i><b>c</b></i></sup></a></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation web cs1\"><a class=\"external text\" href=\"https://huggingface.co/blog/falcon\" rel=\"nofollow\">\"The Falcon has landed in the Hugging Face ecosystem\"</a>. <i>huggingface.co</i>. <a class=\"external text\" href=\"https://web.archive.org/web/20230620002832/https://huggingface.co/blog/falcon\" rel=\"nofollow\">Archived</a> from the original on 2023-06-20<span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">2023-06-20</span></span>.</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=huggingface.co&amp;rft.atitle=The+Falcon+has+landed+in+the+Hugging+Face+ecosystem&amp;rft_id=https%3A%2F%2Fhuggingface.co%2Fblog%2Ffalcon&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-GPT4Tech-205\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-GPT4Tech_205-0\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation web cs1\"><a class=\"external text\" href=\"https://cdn.openai.com/papers/gpt-4.pdf\" rel=\"nofollow\">\"GPT-4 Technical Report\"</a> <span class=\"cs1-format\">(PDF)</span>. <i><a href=\"/wiki/OpenAI\" title=\"OpenAI\">OpenAI</a></i>. 2023. <a class=\"external text\" href=\"https://web.archive.org/web/20230314190904/https://cdn.openai.com/papers/gpt-4.pdf\" rel=\"nofollow\">Archived</a> <span class=\"cs1-format\">(PDF)</span> from the original on March 14, 2023<span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">March 14,</span> 2023</span>.</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=OpenAI&amp;rft.atitle=GPT-4+Technical+Report&amp;rft.date=2023&amp;rft_id=https%3A%2F%2Fcdn.openai.com%2Fpapers%2Fgpt-4.pdf&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-207\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-207\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation web cs1\" id=\"CITEREFSchreiner2023\">Schreiner, Maximilian (2023-07-11). <a class=\"external text\" href=\"https://the-decoder.com/gpt-4-architecture-datasets-costs-and-more-leaked/\" rel=\"nofollow\">\"GPT-4 architecture, datasets, costs and more leaked\"</a>. <i>THE DECODER</i>. <a class=\"external text\" href=\"https://web.archive.org/web/20230712123915/https://the-decoder.com/gpt-4-architecture-datasets-costs-and-more-leaked/\" rel=\"nofollow\">Archived</a> from the original on 2023-07-12<span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">2024-07-26</span></span>.</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=THE+DECODER&amp;rft.atitle=GPT-4+architecture%2C+datasets%2C+costs+and+more+leaked&amp;rft.date=2023-07-11&amp;rft.aulast=Schreiner&amp;rft.aufirst=Maximilian&amp;rft_id=https%3A%2F%2Fthe-decoder.com%2Fgpt-4-architecture-datasets-costs-and-more-leaked%2F&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-208\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-208\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation news cs1\" id=\"CITEREFDickson2024\">Dickson, Ben (22 May 2024). <a class=\"external text\" href=\"https://venturebeat.com/ai/meta-introduces-chameleon-a-state-of-the-art-multimodal-model/\" rel=\"nofollow\">\"Meta introduces Chameleon, a state-of-the-art multimodal model\"</a>. <i>VentureBeat</i>.</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=VentureBeat&amp;rft.atitle=Meta+introduces+Chameleon%2C+a+state-of-the-art+multimodal+model&amp;rft.date=2024-05-22&amp;rft.aulast=Dickson&amp;rft.aufirst=Ben&amp;rft_id=https%3A%2F%2Fventurebeat.com%2Fai%2Fmeta-introduces-chameleon-a-state-of-the-art-multimodal-model%2F&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-D0k2a-209\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-D0k2a_209-0\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation web cs1\" id=\"CITEREFDey2023\">Dey, Nolan (March 28, 2023). <a class=\"external text\" href=\"https://www.cerebras.net/blog/cerebras-gpt-a-family-of-open-compute-efficient-large-language-models/\" rel=\"nofollow\">\"Cerebras-GPT: A Family of Open, Compute-efficient, Large Language Models\"</a>. <i>Cerebras</i>. <a class=\"external text\" href=\"https://web.archive.org/web/20230328213339/https://www.cerebras.net/blog/cerebras-gpt-a-family-of-open-compute-efficient-large-language-models/\" rel=\"nofollow\">Archived</a> from the original on March 28, 2023<span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">March 28,</span> 2023</span>.</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=Cerebras&amp;rft.atitle=Cerebras-GPT%3A+A+Family+of+Open%2C+Compute-efficient%2C+Large+Language+Models&amp;rft.date=2023-03-28&amp;rft.aulast=Dey&amp;rft.aufirst=Nolan&amp;rft_id=https%3A%2F%2Fwww.cerebras.net%2Fblog%2Fcerebras-gpt-a-family-of-open-compute-efficient-large-language-models%2F&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-falcon-210\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-falcon_210-0\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation web cs1\"><a class=\"external text\" href=\"https://fastcompanyme.com/news/abu-dhabi-based-tii-launches-its-own-version-of-chatgpt/\" rel=\"nofollow\">\"Abu Dhabi-based TII launches its own version of ChatGPT\"</a>. <i>tii.ae</i>. <a class=\"external text\" href=\"https://web.archive.org/web/20230403021729/https://fastcompanyme.com/news/abu-dhabi-based-tii-launches-its-own-version-of-chatgpt/\" rel=\"nofollow\">Archived</a> from the original on 2023-04-03<span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">2023-04-03</span></span>.</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=tii.ae&amp;rft.atitle=Abu+Dhabi-based+TII+launches+its+own+version+of+ChatGPT&amp;rft_id=https%3A%2F%2Ffastcompanyme.com%2Fnews%2Fabu-dhabi-based-tii-launches-its-own-version-of-chatgpt%2F&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-Xb1gq-211\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-Xb1gq_211-0\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation arxiv cs1\" id=\"CITEREFPenedoMalarticHesslowCojocaru2023\">Penedo, Guilherme; Malartic, Quentin; Hesslow, Daniel; Cojocaru, Ruxandra; Cappelli, Alessandro; Alobeidli, Hamza; Pannier, Baptiste; Almazrouei, Ebtesam; Launay, Julien (2023-06-01). \"The RefinedWeb Dataset for Falcon LLM: Outperforming Curated Corpora with Web Data, and Web Data Only\". <a class=\"mw-redirect\" href=\"/wiki/ArXiv_(identifier)\" title=\"ArXiv (identifier)\">arXiv</a>:<span class=\"id-lock-free\" title=\"Freely accessible\"><a class=\"external text\" href=\"https://arxiv.org/abs/2306.01116\" rel=\"nofollow\">2306.01116</a></span> [<a class=\"external text\" href=\"https://arxiv.org/archive/cs.CL\" rel=\"nofollow\">cs.CL</a>].</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=preprint&amp;rft.jtitle=arXiv&amp;rft.atitle=The+RefinedWeb+Dataset+for+Falcon+LLM%3A+Outperforming+Curated+Corpora+with+Web+Data%2C+and+Web+Data+Only&amp;rft.date=2023-06-01&amp;rft_id=info%3Aarxiv%2F2306.01116&amp;rft.aulast=Penedo&amp;rft.aufirst=Guilherme&amp;rft.au=Malartic%2C+Quentin&amp;rft.au=Hesslow%2C+Daniel&amp;rft.au=Cojocaru%2C+Ruxandra&amp;rft.au=Cappelli%2C+Alessandro&amp;rft.au=Alobeidli%2C+Hamza&amp;rft.au=Pannier%2C+Baptiste&amp;rft.au=Almazrouei%2C+Ebtesam&amp;rft.au=Launay%2C+Julien&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-gzTNw-212\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-gzTNw_212-0\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation web cs1\"><a class=\"external text\" href=\"https://huggingface.co/tiiuae/falcon-40b\" rel=\"nofollow\">\"tiiuae/falcon-40b · Hugging Face\"</a>. <i>huggingface.co</i>. 2023-06-09<span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">2023-06-20</span></span>.</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=huggingface.co&amp;rft.atitle=tiiuae%2Ffalcon-40b+%C2%B7+Hugging+Face&amp;rft.date=2023-06-09&amp;rft_id=https%3A%2F%2Fhuggingface.co%2Ftiiuae%2Ffalcon-40b&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-Wmlcs-213\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-Wmlcs_213-0\">^</a></b></span> <span class=\"reference-text\"><a class=\"external text\" href=\"https://www.businesswire.com/news/home/20230531005608/en/UAE's-Falcon-40B-World's-Top-Ranked-AI-Model-from-Technology-Innovation-Institute-is-Now-Royalty-Free\" rel=\"nofollow\">UAE's Falcon 40B, World's Top-Ranked AI Model from Technology Innovation Institute, is Now Royalty-Free</a> <a class=\"external text\" href=\"https://web.archive.org/web/20240208133040/https://www.businesswire.com/news/home/20230531005608/en/UAE%27s-Falcon-40B-World%27s-Top-Ranked-AI-Model-from-Technology-Innovation-Institute-is-Now-Royalty-Free\" rel=\"nofollow\">Archived</a> 2024-02-08 at the <a href=\"/wiki/Wayback_Machine\" title=\"Wayback Machine\">Wayback Machine</a>, 31 May 2023</span>\n</li>\n<li id=\"cite_note-nGOSu-214\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-nGOSu_214-0\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation arxiv cs1\" id=\"CITEREFWuIrsoyLuDabravolski2023\">Wu, Shijie; Irsoy, Ozan; Lu, Steven; Dabravolski, Vadim; Dredze, Mark; Gehrmann, Sebastian; Kambadur, Prabhanjan; Rosenberg, David; Mann, Gideon (March 30, 2023). \"BloombergGPT: A Large Language Model for Finance\". <a class=\"mw-redirect\" href=\"/wiki/ArXiv_(identifier)\" title=\"ArXiv (identifier)\">arXiv</a>:<span class=\"id-lock-free\" title=\"Freely accessible\"><a class=\"external text\" href=\"https://arxiv.org/abs/2303.17564\" rel=\"nofollow\">2303.17564</a></span> [<a class=\"external text\" href=\"https://arxiv.org/archive/cs.LG\" rel=\"nofollow\">cs.LG</a>].</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=preprint&amp;rft.jtitle=arXiv&amp;rft.atitle=BloombergGPT%3A+A+Large+Language+Model+for+Finance&amp;rft.date=2023-03-30&amp;rft_id=info%3Aarxiv%2F2303.17564&amp;rft.aulast=Wu&amp;rft.aufirst=Shijie&amp;rft.au=Irsoy%2C+Ozan&amp;rft.au=Lu%2C+Steven&amp;rft.au=Dabravolski%2C+Vadim&amp;rft.au=Dredze%2C+Mark&amp;rft.au=Gehrmann%2C+Sebastian&amp;rft.au=Kambadur%2C+Prabhanjan&amp;rft.au=Rosenberg%2C+David&amp;rft.au=Mann%2C+Gideon&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-9WSFw-215\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-9WSFw_215-0\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation arxiv cs1\" id=\"CITEREFRenZhouMengHuang2023\">Ren, Xiaozhe; Zhou, Pingyi; Meng, Xinfan; Huang, Xinjing; Wang, Yadao; Wang, Weichao; Li, Pengfei; Zhang, Xiaoda; Podolskiy, Alexander; Arshinov, Grigory; Bout, Andrey; Piontkovskaya, Irina; Wei, Jiansheng; Jiang, Xin; Su, Teng; Liu, Qun; Yao, Jun (March 19, 2023). \"PanGu-Σ: Towards Trillion Parameter Language Model with Sparse Heterogeneous Computing\". <a class=\"mw-redirect\" href=\"/wiki/ArXiv_(identifier)\" title=\"ArXiv (identifier)\">arXiv</a>:<span class=\"id-lock-free\" title=\"Freely accessible\"><a class=\"external text\" href=\"https://arxiv.org/abs/2303.10845\" rel=\"nofollow\">2303.10845</a></span> [<a class=\"external text\" href=\"https://arxiv.org/archive/cs.CL\" rel=\"nofollow\">cs.CL</a>].</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=preprint&amp;rft.jtitle=arXiv&amp;rft.atitle=PanGu-%CE%A3%3A+Towards+Trillion+Parameter+Language+Model+with+Sparse+Heterogeneous+Computing&amp;rft.date=2023-03-19&amp;rft_id=info%3Aarxiv%2F2303.10845&amp;rft.aulast=Ren&amp;rft.aufirst=Xiaozhe&amp;rft.au=Zhou%2C+Pingyi&amp;rft.au=Meng%2C+Xinfan&amp;rft.au=Huang%2C+Xinjing&amp;rft.au=Wang%2C+Yadao&amp;rft.au=Wang%2C+Weichao&amp;rft.au=Li%2C+Pengfei&amp;rft.au=Zhang%2C+Xiaoda&amp;rft.au=Podolskiy%2C+Alexander&amp;rft.au=Arshinov%2C+Grigory&amp;rft.au=Bout%2C+Andrey&amp;rft.au=Piontkovskaya%2C+Irina&amp;rft.au=Wei%2C+Jiansheng&amp;rft.au=Jiang%2C+Xin&amp;rft.au=Su%2C+Teng&amp;rft.au=Liu%2C+Qun&amp;rft.au=Yao%2C+Jun&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-JiOl8-216\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-JiOl8_216-0\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation arxiv cs1\" id=\"CITEREFKöpfKilchervon_RütteAnagnostidis2023\">Köpf, Andreas; Kilcher, Yannic; von Rütte, Dimitri; Anagnostidis, Sotiris; Tam, Zhi-Rui; Stevens, Keith; Barhoum, Abdullah; Duc, Nguyen Minh; Stanley, Oliver; Nagyfi, Richárd; ES, Shahul; Suri, Sameer; Glushkov, David; Dantuluri, Arnav; Maguire, Andrew (2023-04-14). \"OpenAssistant Conversations – Democratizing Large Language Model Alignment\". <a class=\"mw-redirect\" href=\"/wiki/ArXiv_(identifier)\" title=\"ArXiv (identifier)\">arXiv</a>:<span class=\"id-lock-free\" title=\"Freely accessible\"><a class=\"external text\" href=\"https://arxiv.org/abs/2304.07327\" rel=\"nofollow\">2304.07327</a></span> [<a class=\"external text\" href=\"https://arxiv.org/archive/cs.CL\" rel=\"nofollow\">cs.CL</a>].</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=preprint&amp;rft.jtitle=arXiv&amp;rft.atitle=OpenAssistant+Conversations+%E2%80%93+Democratizing+Large+Language+Model+Alignment&amp;rft.date=2023-04-14&amp;rft_id=info%3Aarxiv%2F2304.07327&amp;rft.aulast=K%C3%B6pf&amp;rft.aufirst=Andreas&amp;rft.au=Kilcher%2C+Yannic&amp;rft.au=von+R%C3%BCtte%2C+Dimitri&amp;rft.au=Anagnostidis%2C+Sotiris&amp;rft.au=Tam%2C+Zhi-Rui&amp;rft.au=Stevens%2C+Keith&amp;rft.au=Barhoum%2C+Abdullah&amp;rft.au=Duc%2C+Nguyen+Minh&amp;rft.au=Stanley%2C+Oliver&amp;rft.au=Nagyfi%2C+Rich%C3%A1rd&amp;rft.au=ES%2C+Shahul&amp;rft.au=Suri%2C+Sameer&amp;rft.au=Glushkov%2C+David&amp;rft.au=Dantuluri%2C+Arnav&amp;rft.au=Maguire%2C+Andrew&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-217\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-217\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation web cs1\" id=\"CITEREFWrobel\">Wrobel, Sharon. <a class=\"external text\" href=\"https://www.timesofisrael.com/ai21-labs-rolls-out-new-advanced-ai-language-model-to-rival-openai/\" rel=\"nofollow\">\"Tel Aviv startup rolls out new advanced AI language model to rival OpenAI\"</a>. <i>www.timesofisrael.com</i>. <a class=\"external text\" href=\"https://web.archive.org/web/20230724191823/https://www.timesofisrael.com/ai21-labs-rolls-out-new-advanced-ai-language-model-to-rival-openai/\" rel=\"nofollow\">Archived</a> from the original on 2023-07-24<span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">2023-07-24</span></span>.</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=www.timesofisrael.com&amp;rft.atitle=Tel+Aviv+startup+rolls+out+new+advanced+AI+language+model+to+rival+OpenAI&amp;rft.aulast=Wrobel&amp;rft.aufirst=Sharon&amp;rft_id=https%3A%2F%2Fwww.timesofisrael.com%2Fai21-labs-rolls-out-new-advanced-ai-language-model-to-rival-openai%2F&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-218\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-218\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation web cs1\" id=\"CITEREFWiggers2023\">Wiggers, Kyle (2023-04-13). <a class=\"external text\" href=\"https://techcrunch.com/2023/04/13/with-bedrock-amazon-enters-the-generative-ai-race/\" rel=\"nofollow\">\"With Bedrock, Amazon enters the generative AI race\"</a>. <i>TechCrunch</i>. <a class=\"external text\" href=\"https://web.archive.org/web/20230724102458/https://techcrunch.com/2023/04/13/with-bedrock-amazon-enters-the-generative-ai-race/\" rel=\"nofollow\">Archived</a> from the original on 2023-07-24<span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">2023-07-24</span></span>.</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=TechCrunch&amp;rft.atitle=With+Bedrock%2C+Amazon+enters+the+generative+AI+race&amp;rft.date=2023-04-13&amp;rft.aulast=Wiggers&amp;rft.aufirst=Kyle&amp;rft_id=https%3A%2F%2Ftechcrunch.com%2F2023%2F04%2F13%2Fwith-bedrock-amazon-enters-the-generative-ai-race%2F&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-cnbc-20230516-219\"><span class=\"mw-cite-backlink\">^ <a href=\"#cite_ref-cnbc-20230516_219-0\"><sup><i><b>a</b></i></sup></a> <a href=\"#cite_ref-cnbc-20230516_219-1\"><sup><i><b>b</b></i></sup></a></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation web cs1\" id=\"CITEREFElias2023\">Elias, Jennifer (16 May 2023). <a class=\"external text\" href=\"https://www.cnbc.com/2023/05/16/googles-palm-2-uses-nearly-five-times-more-text-data-than-predecessor.html\" rel=\"nofollow\">\"Google's newest A.I. model uses nearly five times more text data for training than its predecessor\"</a>. <i><a href=\"/wiki/CNBC\" title=\"CNBC\">CNBC</a></i>. <a class=\"external text\" href=\"https://web.archive.org/web/20230516225326/https://www.cnbc.com/2023/05/16/googles-palm-2-uses-nearly-five-times-more-text-data-than-predecessor.html\" rel=\"nofollow\">Archived</a> from the original on 16 May 2023<span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">18 May</span> 2023</span>.</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=CNBC&amp;rft.atitle=Google%27s+newest+A.I.+model+uses+nearly+five+times+more+text+data+for+training+than+its+predecessor&amp;rft.date=2023-05-16&amp;rft.aulast=Elias&amp;rft.aufirst=Jennifer&amp;rft_id=https%3A%2F%2Fwww.cnbc.com%2F2023%2F05%2F16%2Fgoogles-palm-2-uses-nearly-five-times-more-text-data-than-predecessor.html&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-pWyLA-220\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-pWyLA_220-0\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation web cs1\"><a class=\"external text\" href=\"https://blog.google/technology/ai/google-palm-2-ai-large-language-model/\" rel=\"nofollow\">\"Introducing PaLM 2\"</a>. <i>Google</i>. May 10, 2023. <a class=\"external text\" href=\"https://web.archive.org/web/20230518213209/https://blog.google/technology/ai/google-palm-2-ai-large-language-model/\" rel=\"nofollow\">Archived</a> from the original on May 18, 2023<span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">May 18,</span> 2023</span>.</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=Google&amp;rft.atitle=Introducing+PaLM+2&amp;rft.date=2023-05-10&amp;rft_id=https%3A%2F%2Fblog.google%2Ftechnology%2Fai%2Fgoogle-palm-2-ai-large-language-model%2F&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-meta-20230719-221\"><span class=\"mw-cite-backlink\">^ <a href=\"#cite_ref-meta-20230719_221-0\"><sup><i><b>a</b></i></sup></a> <a href=\"#cite_ref-meta-20230719_221-1\"><sup><i><b>b</b></i></sup></a></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation web cs1\"><a class=\"external text\" href=\"https://ai.meta.com/llama/\" rel=\"nofollow\">\"Introducing Llama 2: The Next Generation of Our Open Source Large Language Model\"</a>. <i>Meta AI</i>. 2023. <a class=\"external text\" href=\"https://web.archive.org/web/20240105234629/https://ai.meta.com/llama/\" rel=\"nofollow\">Archived</a> from the original on 2024-01-05<span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">2023-07-19</span></span>.</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=Meta+AI&amp;rft.atitle=Introducing+Llama+2%3A+The+Next+Generation+of+Our+Open+Source+Large+Language+Model&amp;rft.date=2023&amp;rft_id=https%3A%2F%2Fai.meta.com%2Fllama%2F&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-222\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-222\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation web cs1\"><a class=\"external text\" href=\"https://github.com/meta-llama/llama/blob/main/MODEL_CARD.md\" rel=\"nofollow\">\"llama/MODEL_CARD.md at main · meta-llama/llama\"</a>. <i>GitHub</i>. <a class=\"external text\" href=\"https://web.archive.org/web/20240528090541/https://github.com/meta-llama/llama/blob/main/MODEL_CARD.md\" rel=\"nofollow\">Archived</a> from the original on 2024-05-28<span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">2024-05-28</span></span>.</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=GitHub&amp;rft.atitle=llama%2FMODEL_CARD.md+at+main+%C2%B7+meta-llama%2Fllama&amp;rft_id=https%3A%2F%2Fgithub.com%2Fmeta-llama%2Fllama%2Fblob%2Fmain%2FMODEL_CARD.md&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-223\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-223\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation web cs1\"><a class=\"external text\" href=\"https://www.anthropic.com/index/claude-2\" rel=\"nofollow\">\"Claude 2\"</a>. <i>anthropic.com</i>. <a class=\"external text\" href=\"https://web.archive.org/web/20231215212208/https://www.anthropic.com/index/claude-2\" rel=\"nofollow\">Archived</a> from the original on 15 December 2023<span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">12 December</span> 2023</span>.</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=anthropic.com&amp;rft.atitle=Claude+2&amp;rft_id=https%3A%2F%2Fwww.anthropic.com%2Findex%2Fclaude-2&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-224\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-224\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation web cs1\" id=\"CITEREFNirmal2023\">Nirmal, Dinesh (2023-09-07). <a class=\"external text\" href=\"https://www.ibm.com/blog/building-ai-for-business-ibms-granite-foundation-models\" rel=\"nofollow\">\"Building AI for business: IBM's Granite foundation models\"</a>. <i>IBM Blog</i>. <a class=\"external text\" href=\"https://web.archive.org/web/20240722083855/https://www.ibm.com/blog/building-ai-for-business-ibms-granite-foundation-models/\" rel=\"nofollow\">Archived</a> from the original on 2024-07-22<span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">2024-08-11</span></span>.</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=IBM+Blog&amp;rft.atitle=Building+AI+for+business%3A+IBM%27s+Granite+foundation+models&amp;rft.date=2023-09-07&amp;rft.aulast=Nirmal&amp;rft.aufirst=Dinesh&amp;rft_id=https%3A%2F%2Fwww.ibm.com%2Fblog%2Fbuilding-ai-for-business-ibms-granite-foundation-models&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-mistral-20230927-225\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-mistral-20230927_225-0\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation web cs1\"><a class=\"external text\" href=\"https://mistral.ai/news/announcing-mistral-7b/\" rel=\"nofollow\">\"Announcing Mistral 7B\"</a>. <i>Mistral</i>. 2023. <a class=\"external text\" href=\"https://web.archive.org/web/20240106051047/https://mistral.ai/news/announcing-mistral-7b/\" rel=\"nofollow\">Archived</a> from the original on 2024-01-06<span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">2023-10-06</span></span>.</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=Mistral&amp;rft.atitle=Announcing+Mistral+7B&amp;rft.date=2023&amp;rft_id=https%3A%2F%2Fmistral.ai%2Fnews%2Fannouncing-mistral-7b%2F&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-226\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-226\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation web cs1\"><a class=\"external text\" href=\"https://www.anthropic.com/index/claude-2-1\" rel=\"nofollow\">\"Introducing Claude 2.1\"</a>. <i>anthropic.com</i>. <a class=\"external text\" href=\"https://web.archive.org/web/20231215201726/https://www.anthropic.com/index/claude-2-1\" rel=\"nofollow\">Archived</a> from the original on 15 December 2023<span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">12 December</span> 2023</span>.</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=anthropic.com&amp;rft.atitle=Introducing+Claude+2.1&amp;rft_id=https%3A%2F%2Fwww.anthropic.com%2Findex%2Fclaude-2-1&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-227\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-227\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation cs2\"><a class=\"external text\" href=\"https://github.com/xai-org/grok-1\" rel=\"nofollow\"><i>xai-org/grok-1</i></a>, xai-org, 2024-03-19, <a class=\"external text\" href=\"https://web.archive.org/web/20240528170731/https://github.com/xai-org/grok-1\" rel=\"nofollow\">archived</a> from the original on 2024-05-28<span class=\"reference-accessdate\">, retrieved <span class=\"nowrap\">2024-03-19</span></span></cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=book&amp;rft.btitle=xai-org%2Fgrok-1&amp;rft.pub=xai-org&amp;rft.date=2024-03-19&amp;rft_id=https%3A%2F%2Fgithub.com%2Fxai-org%2Fgrok-1&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-228\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-228\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation web cs1\"><a class=\"external text\" href=\"https://x.ai/model-card/\" rel=\"nofollow\">\"Grok-1 model card\"</a>. <i>x.ai</i><span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">12 December</span> 2023</span>.</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=x.ai&amp;rft.atitle=Grok-1+model+card&amp;rft_id=https%3A%2F%2Fx.ai%2Fmodel-card%2F&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-229\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-229\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation web cs1\"><a class=\"external text\" href=\"https://deepmind.google/technologies/gemini/#capabilities\" rel=\"nofollow\">\"Gemini – Google DeepMind\"</a>. <i>deepmind.google</i>. <a class=\"external text\" href=\"https://web.archive.org/web/20231208015607/https://deepmind.google/technologies/gemini/#capabilities\" rel=\"nofollow\">Archived</a> from the original on 8 December 2023<span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">12 December</span> 2023</span>.</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=deepmind.google&amp;rft.atitle=Gemini+%E2%80%93+Google+DeepMind&amp;rft_id=https%3A%2F%2Fdeepmind.google%2Ftechnologies%2Fgemini%2F%23capabilities&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-230\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-230\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation web cs1\" id=\"CITEREFFranzen2023\">Franzen, Carl (11 December 2023). <a class=\"external text\" href=\"https://venturebeat.com/ai/mistral-shocks-ai-community-as-latest-open-source-model-eclipses-gpt-3-5-performance/\" rel=\"nofollow\">\"Mistral shocks AI community as latest open source model eclipses GPT-3.5 performance\"</a>. <i>VentureBeat</i>. <a class=\"external text\" href=\"https://web.archive.org/web/20231211213640/https://venturebeat.com/ai/mistral-shocks-ai-community-as-latest-open-source-model-eclipses-gpt-3-5-performance/\" rel=\"nofollow\">Archived</a> from the original on 11 December 2023<span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">12 December</span> 2023</span>.</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=VentureBeat&amp;rft.atitle=Mistral+shocks+AI+community+as+latest+open+source+model+eclipses+GPT-3.5+performance&amp;rft.date=2023-12-11&amp;rft.aulast=Franzen&amp;rft.aufirst=Carl&amp;rft_id=https%3A%2F%2Fventurebeat.com%2Fai%2Fmistral-shocks-ai-community-as-latest-open-source-model-eclipses-gpt-3-5-performance%2F&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-231\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-231\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation web cs1\"><a class=\"external text\" href=\"https://mistral.ai/news/mixtral-of-experts/\" rel=\"nofollow\">\"Mixtral of experts\"</a>. <i>mistral.ai</i>. 11 December 2023. <a class=\"external text\" href=\"https://web.archive.org/web/20240213104049/https://mistral.ai/news/mixtral-of-experts/\" rel=\"nofollow\">Archived</a> from the original on 13 February 2024<span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">12 December</span> 2023</span>.</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=mistral.ai&amp;rft.atitle=Mixtral+of+experts&amp;rft.date=2023-12-11&amp;rft_id=https%3A%2F%2Fmistral.ai%2Fnews%2Fmixtral-of-experts%2F&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-232\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-232\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation web cs1\" id=\"CITEREFAI2024\">AI, Mistral (2024-04-17). <a class=\"external text\" href=\"https://mistral.ai/news/mixtral-8x22b/\" rel=\"nofollow\">\"Cheaper, Better, Faster, Stronger\"</a>. <i>mistral.ai</i>. <a class=\"external text\" href=\"https://web.archive.org/web/20240505023828/https://mistral.ai/news/mixtral-8x22b/\" rel=\"nofollow\">Archived</a> from the original on 2024-05-05<span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">2024-05-05</span></span>.</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=mistral.ai&amp;rft.atitle=Cheaper%2C+Better%2C+Faster%2C+Stronger&amp;rft.date=2024-04-17&amp;rft.aulast=AI&amp;rft.aufirst=Mistral&amp;rft_id=https%3A%2F%2Fmistral.ai%2Fnews%2Fmixtral-8x22b%2F&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-:9-233\"><span class=\"mw-cite-backlink\">^ <a href=\"#cite_ref-:9_233-0\"><sup><i><b>a</b></i></sup></a> <a href=\"#cite_ref-:9_233-1\"><sup><i><b>b</b></i></sup></a></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation web cs1\" id=\"CITEREFHughes2023\">Hughes, Alyssa (12 December 2023). <a class=\"external text\" href=\"https://www.microsoft.com/en-us/research/blog/phi-2-the-surprising-power-of-small-language-models/\" rel=\"nofollow\">\"Phi-2: The surprising power of small language models\"</a>. <i>Microsoft Research</i>. <a class=\"external text\" href=\"https://web.archive.org/web/20231212232647/https://www.microsoft.com/en-us/research/blog/phi-2-the-surprising-power-of-small-language-models/\" rel=\"nofollow\">Archived</a> from the original on 12 December 2023<span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">13 December</span> 2023</span>.</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=Microsoft+Research&amp;rft.atitle=Phi-2%3A+The+surprising+power+of+small+language+models&amp;rft.date=2023-12-12&amp;rft.aulast=Hughes&amp;rft.aufirst=Alyssa&amp;rft_id=https%3A%2F%2Fwww.microsoft.com%2Fen-us%2Fresearch%2Fblog%2Fphi-2-the-surprising-power-of-small-language-models%2F&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-234\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-234\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation web cs1\"><a class=\"external text\" href=\"https://blog.google/technology/ai/google-gemini-next-generation-model-february-2024/#context-window\" rel=\"nofollow\">\"Our next-generation model: Gemini 1.5\"</a>. <i>Google</i>. 15 February 2024. <a class=\"external text\" href=\"https://web.archive.org/web/20240216003052/https://blog.google/technology/ai/google-gemini-next-generation-model-february-2024/#context-window\" rel=\"nofollow\">Archived</a> from the original on 16 February 2024<span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">16 February</span> 2024</span>. <q>This means 1.5 Pro can process vast amounts of information in one go — including 1 hour of video, 11 hours of audio, codebases with over 30,000 lines of code or over 700,000 words. In our research, we've also successfully tested up to 10 million tokens.</q></cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=Google&amp;rft.atitle=Our+next-generation+model%3A+Gemini+1.5&amp;rft.date=2024-02-15&amp;rft_id=https%3A%2F%2Fblog.google%2Ftechnology%2Fai%2Fgoogle-gemini-next-generation-model-february-2024%2F%23context-window&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-gemma-235\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-gemma_235-0\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation web cs1\"><a class=\"external text\" href=\"https://ai.google.dev/gemma/terms\" rel=\"nofollow\">\"Gemma\"</a> – via GitHub.</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=Gemma&amp;rft_id=https%3A%2F%2Fai.google.dev%2Fgemma%2Fterms&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-236\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-236\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation web cs1\"><a class=\"external text\" href=\"https://www.anthropic.com/news/claude-3-family\" rel=\"nofollow\">\"Introducing the next generation of Claude\"</a>. <i>www.anthropic.com</i>. <a class=\"external text\" href=\"https://web.archive.org/web/20240304143650/https://www.anthropic.com/news/claude-3-family\" rel=\"nofollow\">Archived</a> from the original on 2024-03-04<span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">2024-03-04</span></span>.</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=www.anthropic.com&amp;rft.atitle=Introducing+the+next+generation+of+Claude&amp;rft_id=https%3A%2F%2Fwww.anthropic.com%2Fnews%2Fclaude-3-family&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-237\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-237\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation web cs1\"><a class=\"external text\" href=\"https://huggingface.co/Fugaku-LLM/Fugaku-LLM-13B\" rel=\"nofollow\">\"Fugaku-LLM/Fugaku-LLM-13B · Hugging Face\"</a>. <i>huggingface.co</i>. <a class=\"external text\" href=\"https://web.archive.org/web/20240517135225/https://huggingface.co/Fugaku-LLM/Fugaku-LLM-13B\" rel=\"nofollow\">Archived</a> from the original on 2024-05-17<span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">2024-05-17</span></span>.</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=huggingface.co&amp;rft.atitle=Fugaku-LLM%2FFugaku-LLM-13B+%C2%B7+Hugging+Face&amp;rft_id=https%3A%2F%2Fhuggingface.co%2FFugaku-LLM%2FFugaku-LLM-13B&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-238\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-238\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation web cs1\"><a class=\"external text\" href=\"https://azure.microsoft.com/en-us/blog/introducing-phi-3-redefining-whats-possible-with-slms\" rel=\"nofollow\">\"Phi-3\"</a>. <i>azure.microsoft.com</i>. 23 April 2024. <a class=\"external text\" href=\"https://web.archive.org/web/20240427043835/https://azure.microsoft.com/en-us/blog/introducing-phi-3-redefining-whats-possible-with-slms/\" rel=\"nofollow\">Archived</a> from the original on 2024-04-27<span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">2024-04-28</span></span>.</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=azure.microsoft.com&amp;rft.atitle=Phi-3&amp;rft.date=2024-04-23&amp;rft_id=https%3A%2F%2Fazure.microsoft.com%2Fen-us%2Fblog%2Fintroducing-phi-3-redefining-whats-possible-with-slms&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-239\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-239\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation web cs1\"><a class=\"external text\" href=\"https://huggingface.co/docs/transformers/main/en/model_doc/phi3\" rel=\"nofollow\">\"Phi-3 Model Documentation\"</a>. <i>huggingface.co</i>. <a class=\"external text\" href=\"https://web.archive.org/web/20240513141513/https://huggingface.co/docs/transformers/main/en/model_doc/phi3\" rel=\"nofollow\">Archived</a> from the original on 2024-05-13<span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">2024-04-28</span></span>.</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=huggingface.co&amp;rft.atitle=Phi-3+Model+Documentation&amp;rft_id=https%3A%2F%2Fhuggingface.co%2Fdocs%2Ftransformers%2Fmain%2Fen%2Fmodel_doc%2Fphi3&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-240\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-240\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation web cs1\"><a class=\"external text\" href=\"https://github.com/QwenLM/Qwen2?spm=a3c0i.28768018.7084722650.1.5cd35c10NEqBXm&amp;file=Qwen1.5\" rel=\"nofollow\">\"Qwen2\"</a>. <i><a href=\"/wiki/GitHub\" title=\"GitHub\">GitHub</a></i>. <a class=\"external text\" href=\"https://web.archive.org/web/20240617072401/https://github.com/QwenLM/Qwen2?spm=a3c0i.28768018.7084722650.1.5cd35c10NEqBXm&amp;file=Qwen1.5\" rel=\"nofollow\">Archived</a> from the original on 2024-06-17<span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">2024-06-17</span></span>.</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=GitHub&amp;rft.atitle=Qwen2&amp;rft_id=https%3A%2F%2Fgithub.com%2FQwenLM%2FQwen2%3Fspm%3Da3c0i.28768018.7084722650.1.5cd35c10NEqBXm%26file%3DQwen1.5&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-241\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-241\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation web cs1\"><a class=\"external text\" href=\"https://huggingface.co/nvidia/Nemotron-4-340B-Base\" rel=\"nofollow\">\"nvidia/Nemotron-4-340B-Base · Hugging Face\"</a>. <i>huggingface.co</i>. 2024-06-14. <a class=\"external text\" href=\"https://web.archive.org/web/20240615010323/https://huggingface.co/nvidia/Nemotron-4-340B-Base\" rel=\"nofollow\">Archived</a> from the original on 2024-06-15<span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">2024-06-15</span></span>.</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=huggingface.co&amp;rft.atitle=nvidia%2FNemotron-4-340B-Base+%C2%B7+Hugging+Face&amp;rft.date=2024-06-14&amp;rft_id=https%3A%2F%2Fhuggingface.co%2Fnvidia%2FNemotron-4-340B-Base&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-242\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-242\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation web cs1\"><a class=\"external text\" href=\"https://research.nvidia.com/publication/2024-06_nemotron-4-340b\" rel=\"nofollow\">\"Nemotron-4 340B | Research\"</a>. <i>research.nvidia.com</i>. <a class=\"external text\" href=\"https://web.archive.org/web/20240615010323/https://research.nvidia.com/publication/2024-06_nemotron-4-340b\" rel=\"nofollow\">Archived</a> from the original on 2024-06-15<span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">2024-06-15</span></span>.</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=research.nvidia.com&amp;rft.atitle=Nemotron-4+340B+%7C+Research&amp;rft_id=https%3A%2F%2Fresearch.nvidia.com%2Fpublication%2F2024-06_nemotron-4-340b&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n<li id=\"cite_note-243\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-243\">^</a></b></span> <span class=\"reference-text\"><a class=\"external text\" href=\"https://ai.meta.com/research/publications/the-llama-3-herd-of-models/\" rel=\"nofollow\">\"The Llama 3 Herd of Models\" (July 23, 2024) Llama Team, AI @ Meta</a></span>\n</li>\n<li id=\"cite_note-244\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-244\">^</a></b></span> <span class=\"reference-text\"><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation web cs1\"><a class=\"external text\" href=\"https://github.com/meta-llama/llama-models/blob/main/models/llama3_1/MODEL_CARD.md\" rel=\"nofollow\">\"llama-models/models/llama3_1/MODEL_CARD.md at main · meta-llama/llama-models\"</a>. <i>GitHub</i>. <a class=\"external text\" href=\"https://web.archive.org/web/20240723151851/https://github.com/meta-llama/llama-models/blob/main/models/llama3_1/MODEL_CARD.md\" rel=\"nofollow\">Archived</a> from the original on 2024-07-23<span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">2024-07-23</span></span>.</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=GitHub&amp;rft.atitle=llama-models%2Fmodels%2Fllama3_1%2FMODEL_CARD.md+at+main+%C2%B7+meta-llama%2Fllama-models&amp;rft_id=https%3A%2F%2Fgithub.com%2Fmeta-llama%2Fllama-models%2Fblob%2Fmain%2Fmodels%2Fllama3_1%2FMODEL_CARD.md&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></span>\n</li>\n</ol></div></div>\n<p><br/>\n</p>\n<div class=\"mw-heading mw-heading2\"><h2 id=\"Further_reading\">Further reading</h2><span class=\"mw-editsection\"><span class=\"mw-editsection-bracket\">[</span><a href=\"/w/index.php?title=Large_language_model&amp;action=edit&amp;section=39\" title=\"Edit section: Further reading\"><span>edit</span></a><span class=\"mw-editsection-bracket\">]</span></span></div>\n<ul><li><a href=\"/wiki/Dan_Jurafsky\" title=\"Dan Jurafsky\">Jurafsky, Dan</a>, Martin, James. H. <a class=\"external text\" href=\"https://web.stanford.edu/~jurafsky/slp3/ed3book_jan72023.pdf\" rel=\"nofollow\"><i>Speech and Language Processing: An Introduction to Natural Language Processing, Computational Linguistics, and Speech Recognition</i></a>, 3rd Edition draft, 2023.</li>\n<li><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation arxiv cs1\" id=\"CITEREFZhaoZhouLi2023\">Zhao, Wayne Xin; et al. (2023). \"A Survey of Large Language Models\". <a class=\"mw-redirect\" href=\"/wiki/ArXiv_(identifier)\" title=\"ArXiv (identifier)\">arXiv</a>:<span class=\"id-lock-free\" title=\"Freely accessible\"><a class=\"external text\" href=\"https://arxiv.org/abs/2303.18223\" rel=\"nofollow\">2303.18223</a></span> [<a class=\"external text\" href=\"https://arxiv.org/archive/cs.CL\" rel=\"nofollow\">cs.CL</a>].</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=preprint&amp;rft.jtitle=arXiv&amp;rft.atitle=A+Survey+of+Large+Language+Models&amp;rft.date=2023&amp;rft_id=info%3Aarxiv%2F2303.18223&amp;rft.aulast=Zhao&amp;rft.aufirst=Wayne+Xin&amp;rft.au=Zhou%2C+Kun&amp;rft.au=Li%2C+Junyi&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></li>\n<li><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation arxiv cs1\" id=\"CITEREFKaddour2023\">Kaddour, Jean; et al. (2023). \"Challenges and Applications of Large Language Models\". <a class=\"mw-redirect\" href=\"/wiki/ArXiv_(identifier)\" title=\"ArXiv (identifier)\">arXiv</a>:<span class=\"id-lock-free\" title=\"Freely accessible\"><a class=\"external text\" href=\"https://arxiv.org/abs/2307.10169\" rel=\"nofollow\">2307.10169</a></span> [<a class=\"external text\" href=\"https://arxiv.org/archive/cs.CL\" rel=\"nofollow\">cs.CL</a>].</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=preprint&amp;rft.jtitle=arXiv&amp;rft.atitle=Challenges+and+Applications+of+Large+Language+Models&amp;rft.date=2023&amp;rft_id=info%3Aarxiv%2F2307.10169&amp;rft.aulast=Kaddour&amp;rft.aufirst=Jean&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></li>\n<li><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation arxiv cs1\" id=\"CITEREFYinFuZhaoLi2023\">Yin, Shukang; Fu, Chaoyou; Zhao, Sirui; Li, Ke; Sun, Xing; Xu, Tong; Chen, Enhong (2023-06-01). \"A Survey on Multimodal Large Language Models\". <a class=\"mw-redirect\" href=\"/wiki/ArXiv_(identifier)\" title=\"ArXiv (identifier)\">arXiv</a>:<span class=\"id-lock-free\" title=\"Freely accessible\"><a class=\"external text\" href=\"https://arxiv.org/abs/2306.13549\" rel=\"nofollow\">2306.13549</a></span> [<a class=\"external text\" href=\"https://arxiv.org/archive/cs.CV\" rel=\"nofollow\">cs.CV</a>].</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=preprint&amp;rft.jtitle=arXiv&amp;rft.atitle=A+Survey+on+Multimodal+Large+Language+Models&amp;rft.date=2023-06-01&amp;rft_id=info%3Aarxiv%2F2306.13549&amp;rft.aulast=Yin&amp;rft.aufirst=Shukang&amp;rft.au=Fu%2C+Chaoyou&amp;rft.au=Zhao%2C+Sirui&amp;rft.au=Li%2C+Ke&amp;rft.au=Sun%2C+Xing&amp;rft.au=Xu%2C+Tong&amp;rft.au=Chen%2C+Enhong&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></li>\n<li><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation web cs1\"><a class=\"external text\" href=\"https://aiindex.stanford.edu/report/\" rel=\"nofollow\">\"AI Index Report 2024 – Artificial Intelligence Index\"</a>. <i>aiindex.stanford.edu</i><span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">2024-05-05</span></span>.</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=aiindex.stanford.edu&amp;rft.atitle=AI+Index+Report+2024+%E2%80%93+Artificial+Intelligence+Index&amp;rft_id=https%3A%2F%2Faiindex.stanford.edu%2Freport%2F&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></li>\n<li><link href=\"mw-data:TemplateStyles:r1238218222\" rel=\"mw-deduplicated-inline-style\"/><cite class=\"citation journal cs1\" id=\"CITEREFFrank2023\">Frank, Michael C. (27 June 2023). <a class=\"external text\" href=\"https://www.nature.com/articles/s44159-023-00211-x\" rel=\"nofollow\">\"Baby steps in evaluating the capacities of large language models\"</a>. <i>Nature Reviews Psychology</i>. <b>2</b> (8): 451–452. <a class=\"mw-redirect\" href=\"/wiki/Doi_(identifier)\" title=\"Doi (identifier)\">doi</a>:<a class=\"external text\" href=\"https://doi.org/10.1038%2Fs44159-023-00211-x\" rel=\"nofollow\">10.1038/s44159-023-00211-x</a>. <a class=\"mw-redirect\" href=\"/wiki/ISSN_(identifier)\" title=\"ISSN (identifier)\">ISSN</a> <a class=\"external text\" href=\"https://search.worldcat.org/issn/2731-0574\" rel=\"nofollow\">2731-0574</a>. <a class=\"mw-redirect\" href=\"/wiki/S2CID_(identifier)\" title=\"S2CID (identifier)\">S2CID</a> <a class=\"external text\" href=\"https://api.semanticscholar.org/CorpusID:259713140\" rel=\"nofollow\">259713140</a><span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">2 July</span> 2023</span>.</cite><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=Nature+Reviews+Psychology&amp;rft.atitle=Baby+steps+in+evaluating+the+capacities+of+large+language+models&amp;rft.volume=2&amp;rft.issue=8&amp;rft.pages=451-452&amp;rft.date=2023-06-27&amp;rft_id=https%3A%2F%2Fapi.semanticscholar.org%2FCorpusID%3A259713140%23id-name%3DS2CID&amp;rft.issn=2731-0574&amp;rft_id=info%3Adoi%2F10.1038%2Fs44159-023-00211-x&amp;rft.aulast=Frank&amp;rft.aufirst=Michael+C.&amp;rft_id=https%3A%2F%2Fwww.nature.com%2Farticles%2Fs44159-023-00211-x&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ALarge+language+model\"></span></li></ul>\n<div class=\"navbox-styles\"><link href=\"mw-data:TemplateStyles:r1129693374\" rel=\"mw-deduplicated-inline-style\"/></div><div aria-labelledby=\"Natural_language_processing\" class=\"navbox\" role=\"navigation\" style=\"padding:3px\"><table class=\"nowraplinks hlist mw-collapsible autocollapse navbox-inner\" style=\"border-spacing:0;background:transparent;color:inherit\"><tbody><tr><th class=\"navbox-title\" colspan=\"2\" scope=\"col\"><link href=\"mw-data:TemplateStyles:r1129693374\" rel=\"mw-deduplicated-inline-style\"/><link href=\"mw-data:TemplateStyles:r1239400231\" rel=\"mw-deduplicated-inline-style\"/><div class=\"navbar plainlinks hlist navbar-mini\"><ul><li class=\"nv-view\"><a href=\"/wiki/Template:Natural_language_processing\" title=\"Template:Natural language processing\"><abbr title=\"View this template\">v</abbr></a></li><li class=\"nv-talk\"><a href=\"/wiki/Template_talk:Natural_language_processing\" title=\"Template talk:Natural language processing\"><abbr title=\"Discuss this template\">t</abbr></a></li><li class=\"nv-edit\"><a href=\"/wiki/Special:EditPage/Template:Natural_language_processing\" title=\"Special:EditPage/Template:Natural language processing\"><abbr title=\"Edit this template\">e</abbr></a></li></ul></div><div id=\"Natural_language_processing\" style=\"font-size:114%;margin:0 4em\"><a href=\"/wiki/Natural_language_processing\" title=\"Natural language processing\">Natural language processing</a></div></th></tr><tr><th class=\"navbox-group\" scope=\"row\" style=\"width:1%\">General terms</th><td class=\"navbox-list-with-group navbox-list navbox-odd\" style=\"width:100%;padding:0\"><div style=\"padding:0 0.25em\">\n<ul><li><a href=\"/wiki/AI-complete\" title=\"AI-complete\">AI-complete</a></li>\n<li><a href=\"/wiki/Bag-of-words_model\" title=\"Bag-of-words model\">Bag-of-words</a></li>\n<li><a href=\"/wiki/N-gram\" title=\"N-gram\">n-gram</a>\n<ul><li><a href=\"/wiki/Bigram\" title=\"Bigram\">Bigram</a></li>\n<li><a href=\"/wiki/Trigram\" title=\"Trigram\">Trigram</a></li></ul></li>\n<li><a href=\"/wiki/Computational_linguistics\" title=\"Computational linguistics\">Computational linguistics</a></li>\n<li><a href=\"/wiki/Natural_language_understanding\" title=\"Natural language understanding\">Natural language understanding</a></li>\n<li><a href=\"/wiki/Stop_word\" title=\"Stop word\">Stop words</a></li>\n<li><a href=\"/wiki/Text_processing\" title=\"Text processing\">Text processing</a></li></ul>\n</div></td></tr><tr><th class=\"navbox-group\" scope=\"row\" style=\"width:1%\"><a href=\"/wiki/Text_mining\" title=\"Text mining\">Text analysis</a></th><td class=\"navbox-list-with-group navbox-list navbox-even\" style=\"width:100%;padding:0\"><div style=\"padding:0 0.25em\">\n<ul><li><a href=\"/wiki/Argument_mining\" title=\"Argument mining\">Argument mining</a></li>\n<li><a href=\"/wiki/Collocation_extraction\" title=\"Collocation extraction\">Collocation extraction</a></li>\n<li><a href=\"/wiki/Concept_mining\" title=\"Concept mining\">Concept mining</a></li>\n<li><a href=\"/wiki/Coreference#Coreference_resolution\" title=\"Coreference\">Coreference resolution</a></li>\n<li><a href=\"/wiki/Deep_linguistic_processing\" title=\"Deep linguistic processing\">Deep linguistic processing</a></li>\n<li><a href=\"/wiki/Distant_reading\" title=\"Distant reading\">Distant reading</a></li>\n<li><a href=\"/wiki/Information_extraction\" title=\"Information extraction\">Information extraction</a></li>\n<li><a href=\"/wiki/Named-entity_recognition\" title=\"Named-entity recognition\">Named-entity recognition</a></li>\n<li><a href=\"/wiki/Ontology_learning\" title=\"Ontology learning\">Ontology learning</a></li>\n<li><a href=\"/wiki/Parsing\" title=\"Parsing\">Parsing</a>\n<ul><li><a href=\"/wiki/Semantic_parsing\" title=\"Semantic parsing\">Semantic parsing</a></li>\n<li><a href=\"/wiki/Syntactic_parsing_(computational_linguistics)\" title=\"Syntactic parsing (computational linguistics)\">Syntactic parsing</a></li></ul></li>\n<li><a href=\"/wiki/Part-of-speech_tagging\" title=\"Part-of-speech tagging\">Part-of-speech tagging</a></li>\n<li><a href=\"/wiki/Semantic_analysis_(machine_learning)\" title=\"Semantic analysis (machine learning)\">Semantic analysis</a></li>\n<li><a href=\"/wiki/Semantic_role_labeling\" title=\"Semantic role labeling\">Semantic role labeling</a></li>\n<li><a href=\"/wiki/Semantic_decomposition_(natural_language_processing)\" title=\"Semantic decomposition (natural language processing)\">Semantic decomposition</a></li>\n<li><a href=\"/wiki/Semantic_similarity\" title=\"Semantic similarity\">Semantic similarity</a></li>\n<li><a href=\"/wiki/Sentiment_analysis\" title=\"Sentiment analysis\">Sentiment analysis</a></li></ul>\n<ul><li><a href=\"/wiki/Terminology_extraction\" title=\"Terminology extraction\">Terminology extraction</a></li>\n<li><a href=\"/wiki/Text_mining\" title=\"Text mining\">Text mining</a></li>\n<li><a href=\"/wiki/Textual_entailment\" title=\"Textual entailment\">Textual entailment</a></li>\n<li><a href=\"/wiki/Truecasing\" title=\"Truecasing\">Truecasing</a></li>\n<li><a href=\"/wiki/Word-sense_disambiguation\" title=\"Word-sense disambiguation\">Word-sense disambiguation</a></li>\n<li><a href=\"/wiki/Word-sense_induction\" title=\"Word-sense induction\">Word-sense induction</a></li></ul>\n</div><table class=\"nowraplinks navbox-subgroup\" style=\"border-spacing:0\"><tbody><tr><th class=\"navbox-group\" id=\"Text_segmentation\" scope=\"row\" style=\"width:1%\"><a href=\"/wiki/Text_segmentation\" title=\"Text segmentation\">Text segmentation</a></th><td class=\"navbox-list-with-group navbox-list navbox-odd\" style=\"width:100%;padding:0\"><div style=\"padding:0 0.25em\">\n<ul><li><a href=\"/wiki/Compound-term_processing\" title=\"Compound-term processing\">Compound-term processing</a></li>\n<li><a class=\"mw-redirect\" href=\"/wiki/Lemmatisation\" title=\"Lemmatisation\">Lemmatisation</a></li>\n<li><a href=\"/wiki/Lexical_analysis\" title=\"Lexical analysis\">Lexical analysis</a></li>\n<li><a href=\"/wiki/Shallow_parsing\" title=\"Shallow parsing\">Text chunking</a></li>\n<li><a href=\"/wiki/Stemming\" title=\"Stemming\">Stemming</a></li>\n<li><a href=\"/wiki/Sentence_boundary_disambiguation\" title=\"Sentence boundary disambiguation\">Sentence segmentation</a></li>\n<li><a href=\"/wiki/Word#Word_boundaries\" title=\"Word\">Word segmentation</a></li></ul>\n</div></td></tr></tbody></table><div>\n</div></td></tr><tr><th class=\"navbox-group\" scope=\"row\" style=\"width:1%\"><a href=\"/wiki/Automatic_summarization\" title=\"Automatic summarization\">Automatic summarization</a></th><td class=\"navbox-list-with-group navbox-list navbox-even\" style=\"width:100%;padding:0\"><div style=\"padding:0 0.25em\">\n<ul><li><a href=\"/wiki/Multi-document_summarization\" title=\"Multi-document summarization\">Multi-document summarization</a></li>\n<li><a href=\"/wiki/Sentence_extraction\" title=\"Sentence extraction\">Sentence extraction</a></li>\n<li><a href=\"/wiki/Text_simplification\" title=\"Text simplification\">Text simplification</a></li></ul>\n</div></td></tr><tr><th class=\"navbox-group\" scope=\"row\" style=\"width:1%\"><a href=\"/wiki/Machine_translation\" title=\"Machine translation\">Machine translation</a></th><td class=\"navbox-list-with-group navbox-list navbox-odd\" style=\"width:100%;padding:0\"><div style=\"padding:0 0.25em\">\n<ul><li><a href=\"/wiki/Computer-assisted_translation\" title=\"Computer-assisted translation\">Computer-assisted</a></li>\n<li><a href=\"/wiki/Example-based_machine_translation\" title=\"Example-based machine translation\">Example-based</a></li>\n<li><a href=\"/wiki/Rule-based_machine_translation\" title=\"Rule-based machine translation\">Rule-based</a></li>\n<li><a href=\"/wiki/Statistical_machine_translation\" title=\"Statistical machine translation\">Statistical</a></li>\n<li><a href=\"/wiki/Transfer-based_machine_translation\" title=\"Transfer-based machine translation\">Transfer-based</a></li>\n<li><a href=\"/wiki/Neural_machine_translation\" title=\"Neural machine translation\">Neural</a></li></ul>\n</div></td></tr><tr><th class=\"navbox-group\" scope=\"row\" style=\"width:1%\"><a href=\"/wiki/Distributional_semantics\" title=\"Distributional semantics\">Distributional semantics</a> models</th><td class=\"navbox-list-with-group navbox-list navbox-even\" style=\"width:100%;padding:0\"><div style=\"padding:0 0.25em\">\n<ul><li><a href=\"/wiki/BERT_(language_model)\" title=\"BERT (language model)\">BERT</a></li>\n<li><a href=\"/wiki/Document-term_matrix\" title=\"Document-term matrix\">Document-term matrix</a></li>\n<li><a href=\"/wiki/Explicit_semantic_analysis\" title=\"Explicit semantic analysis\">Explicit semantic analysis</a></li>\n<li><a href=\"/wiki/FastText\" title=\"FastText\">fastText</a></li>\n<li><a href=\"/wiki/GloVe\" title=\"GloVe\">GloVe</a></li>\n<li><a href=\"/wiki/Language_model\" title=\"Language model\">Language model</a> (<a class=\"mw-selflink selflink\">large</a>)</li>\n<li><a href=\"/wiki/Latent_semantic_analysis\" title=\"Latent semantic analysis\">Latent semantic analysis</a></li>\n<li><a href=\"/wiki/Seq2seq\" title=\"Seq2seq\">Seq2seq</a></li>\n<li><a href=\"/wiki/Word_embedding\" title=\"Word embedding\">Word embedding</a></li>\n<li><a href=\"/wiki/Word2vec\" title=\"Word2vec\">Word2vec</a></li></ul>\n</div></td></tr><tr><th class=\"navbox-group\" scope=\"row\" style=\"width:1%\"><a href=\"/wiki/Language_resource\" title=\"Language resource\">Language resources</a>,<br/>datasets and corpora</th><td class=\"navbox-list-with-group navbox-list navbox-odd\" style=\"width:100%;padding:0\"><div style=\"padding:0 0.25em\"></div><table class=\"nowraplinks navbox-subgroup\" style=\"border-spacing:0\"><tbody><tr><th class=\"navbox-group\" scope=\"row\" style=\"width:1%\">Types and<br/>standards</th><td class=\"navbox-list-with-group navbox-list navbox-odd\" style=\"width:100%;padding:0\"><div style=\"padding:0 0.25em\">\n<ul><li><a href=\"/wiki/Corpus_linguistics\" title=\"Corpus linguistics\">Corpus linguistics</a></li>\n<li><a href=\"/wiki/Lexical_resource\" title=\"Lexical resource\">Lexical resource</a></li>\n<li><a href=\"/wiki/Linguistic_Linked_Open_Data\" title=\"Linguistic Linked Open Data\">Linguistic Linked Open Data</a></li>\n<li><a href=\"/wiki/Machine-readable_dictionary\" title=\"Machine-readable dictionary\">Machine-readable dictionary</a></li>\n<li><a href=\"/wiki/Parallel_text\" title=\"Parallel text\">Parallel text</a></li>\n<li><a href=\"/wiki/PropBank\" title=\"PropBank\">PropBank</a></li>\n<li><a href=\"/wiki/Semantic_network\" title=\"Semantic network\">Semantic network</a></li>\n<li><a href=\"/wiki/Simple_Knowledge_Organization_System\" title=\"Simple Knowledge Organization System\">Simple Knowledge Organization System</a></li>\n<li><a href=\"/wiki/Speech_corpus\" title=\"Speech corpus\">Speech corpus</a></li>\n<li><a href=\"/wiki/Text_corpus\" title=\"Text corpus\">Text corpus</a></li>\n<li><a href=\"/wiki/Thesaurus_(information_retrieval)\" title=\"Thesaurus (information retrieval)\">Thesaurus (information retrieval)</a></li>\n<li><a href=\"/wiki/Treebank\" title=\"Treebank\">Treebank</a></li>\n<li><a href=\"/wiki/Universal_Dependencies\" title=\"Universal Dependencies\">Universal Dependencies</a></li></ul>\n</div></td></tr><tr><th class=\"navbox-group\" scope=\"row\" style=\"width:1%\">Data</th><td class=\"navbox-list-with-group navbox-list navbox-even\" style=\"width:100%;padding:0\"><div style=\"padding:0 0.25em\">\n<ul><li><a href=\"/wiki/BabelNet\" title=\"BabelNet\">BabelNet</a></li>\n<li><a href=\"/wiki/Bank_of_English\" title=\"Bank of English\">Bank of English</a></li>\n<li><a href=\"/wiki/DBpedia\" title=\"DBpedia\">DBpedia</a></li>\n<li><a href=\"/wiki/FrameNet\" title=\"FrameNet\">FrameNet</a></li>\n<li><a class=\"mw-redirect\" href=\"/wiki/Google_Ngram_Viewer\" title=\"Google Ngram Viewer\">Google Ngram Viewer</a></li>\n<li><a href=\"/wiki/UBY\" title=\"UBY\">UBY</a></li>\n<li><a href=\"/wiki/WordNet\" title=\"WordNet\">WordNet</a></li>\n<li><a href=\"/wiki/Wikidata\" title=\"Wikidata\">Wikidata</a></li></ul>\n</div></td></tr></tbody></table><div></div></td></tr><tr><th class=\"navbox-group\" scope=\"row\" style=\"width:1%\"><a href=\"/wiki/Automatic_identification_and_data_capture\" title=\"Automatic identification and data capture\">Automatic identification<br/>and data capture</a></th><td class=\"navbox-list-with-group navbox-list navbox-odd\" style=\"width:100%;padding:0\"><div style=\"padding:0 0.25em\">\n<ul><li><a href=\"/wiki/Speech_recognition\" title=\"Speech recognition\">Speech recognition</a></li>\n<li><a href=\"/wiki/Speech_segmentation\" title=\"Speech segmentation\">Speech segmentation</a></li>\n<li><a href=\"/wiki/Speech_synthesis\" title=\"Speech synthesis\">Speech synthesis</a></li>\n<li><a href=\"/wiki/Natural_language_generation\" title=\"Natural language generation\">Natural language generation</a></li>\n<li><a href=\"/wiki/Optical_character_recognition\" title=\"Optical character recognition\">Optical character recognition</a></li></ul>\n</div></td></tr><tr><th class=\"navbox-group\" scope=\"row\" style=\"width:1%\"><a href=\"/wiki/Topic_model\" title=\"Topic model\">Topic model</a></th><td class=\"navbox-list-with-group navbox-list navbox-even\" style=\"width:100%;padding:0\"><div style=\"padding:0 0.25em\">\n<ul><li><a href=\"/wiki/Document_classification\" title=\"Document classification\">Document classification</a></li>\n<li><a href=\"/wiki/Latent_Dirichlet_allocation\" title=\"Latent Dirichlet allocation\">Latent Dirichlet allocation</a></li>\n<li><a href=\"/wiki/Pachinko_allocation\" title=\"Pachinko allocation\">Pachinko allocation</a></li></ul>\n</div></td></tr><tr><th class=\"navbox-group\" scope=\"row\" style=\"width:1%\"><a href=\"/wiki/Computer-assisted_reviewing\" title=\"Computer-assisted reviewing\">Computer-assisted<br/>reviewing</a></th><td class=\"navbox-list-with-group navbox-list navbox-odd\" style=\"width:100%;padding:0\"><div style=\"padding:0 0.25em\">\n<ul><li><a href=\"/wiki/Automated_essay_scoring\" title=\"Automated essay scoring\">Automated essay scoring</a></li>\n<li><a href=\"/wiki/Concordancer\" title=\"Concordancer\">Concordancer</a></li>\n<li><a href=\"/wiki/Grammar_checker\" title=\"Grammar checker\">Grammar checker</a></li>\n<li><a href=\"/wiki/Predictive_text\" title=\"Predictive text\">Predictive text</a></li>\n<li><a href=\"/wiki/Pronunciation_assessment\" title=\"Pronunciation assessment\">Pronunciation assessment</a></li>\n<li><a href=\"/wiki/Spell_checker\" title=\"Spell checker\">Spell checker</a></li></ul>\n</div></td></tr><tr><th class=\"navbox-group\" scope=\"row\" style=\"width:1%\"><a href=\"/wiki/Natural-language_user_interface\" title=\"Natural-language user interface\">Natural language<br/>user interface</a></th><td class=\"navbox-list-with-group navbox-list navbox-even\" style=\"width:100%;padding:0\"><div style=\"padding:0 0.25em\">\n<ul><li><a href=\"/wiki/Chatbot\" title=\"Chatbot\">Chatbot</a></li>\n<li><a href=\"/wiki/Interactive_fiction\" title=\"Interactive fiction\">Interactive fiction</a> (c.f. <a class=\"mw-redirect\" href=\"/wiki/Syntax_guessing\" title=\"Syntax guessing\">Syntax guessing</a>)</li>\n<li><a href=\"/wiki/Question_answering\" title=\"Question answering\">Question answering</a></li>\n<li><a href=\"/wiki/Virtual_assistant\" title=\"Virtual assistant\">Virtual assistant</a></li>\n<li><a href=\"/wiki/Voice_user_interface\" title=\"Voice user interface\">Voice user interface</a></li></ul>\n</div></td></tr><tr><th class=\"navbox-group\" scope=\"row\" style=\"width:1%\">Related</th><td class=\"navbox-list-with-group navbox-list navbox-odd\" style=\"width:100%;padding:0\"><div style=\"padding:0 0.25em\">\n<ul><li><a href=\"/wiki/Formal_semantics_(natural_language)\" title=\"Formal semantics (natural language)\">Formal semantics</a></li>\n<li><a href=\"/wiki/Hallucination_(artificial_intelligence)\" title=\"Hallucination (artificial intelligence)\">Hallucination</a></li>\n<li><a href=\"/wiki/Natural_Language_Toolkit\" title=\"Natural Language Toolkit\">Natural Language Toolkit</a></li>\n<li><a href=\"/wiki/SpaCy\" title=\"SpaCy\">spaCy</a></li></ul>\n</div></td></tr></tbody></table></div>\n<div class=\"navbox-styles\"><link href=\"mw-data:TemplateStyles:r1129693374\" rel=\"mw-deduplicated-inline-style\"/><link href=\"mw-data:TemplateStyles:r1236075235\" rel=\"mw-deduplicated-inline-style\"/></div><div aria-labelledby=\"Artificial_intelligence\" class=\"navbox\" role=\"navigation\" style=\"padding:3px\"><table class=\"nowraplinks hlist mw-collapsible autocollapse navbox-inner\" style=\"border-spacing:0;background:transparent;color:inherit\"><tbody><tr><th class=\"navbox-title\" colspan=\"2\" scope=\"col\"><link href=\"mw-data:TemplateStyles:r1129693374\" rel=\"mw-deduplicated-inline-style\"/><link href=\"mw-data:TemplateStyles:r1239400231\" rel=\"mw-deduplicated-inline-style\"/><div class=\"navbar plainlinks hlist navbar-mini\"><ul><li class=\"nv-view\"><a href=\"/wiki/Template:Artificial_intelligence_navbox\" title=\"Template:Artificial intelligence navbox\"><abbr title=\"View this template\">v</abbr></a></li><li class=\"nv-talk\"><a href=\"/wiki/Template_talk:Artificial_intelligence_navbox\" title=\"Template talk:Artificial intelligence navbox\"><abbr title=\"Discuss this template\">t</abbr></a></li><li class=\"nv-edit\"><a href=\"/wiki/Special:EditPage/Template:Artificial_intelligence_navbox\" title=\"Special:EditPage/Template:Artificial intelligence navbox\"><abbr title=\"Edit this template\">e</abbr></a></li></ul></div><div id=\"Artificial_intelligence\" style=\"font-size:114%;margin:0 4em\"><a href=\"/wiki/Artificial_intelligence\" title=\"Artificial intelligence\">Artificial intelligence</a></div></th></tr><tr><th class=\"navbox-group\" scope=\"row\" style=\"width:1%\">Concepts</th><td class=\"navbox-list-with-group navbox-list navbox-odd\" style=\"width:100%;padding:0\"><div style=\"padding:0 0.25em\">\n<ul><li><a href=\"/wiki/Parameter\" title=\"Parameter\">Parameter</a>\n<ul><li><a href=\"/wiki/Hyperparameter_(machine_learning)\" title=\"Hyperparameter (machine learning)\">Hyperparameter</a></li></ul></li>\n<li><a href=\"/wiki/Loss_functions_for_classification\" title=\"Loss functions for classification\">Loss functions</a></li>\n<li><a href=\"/wiki/Regression_analysis\" title=\"Regression analysis\">Regression</a>\n<ul><li><a href=\"/wiki/Bias%E2%80%93variance_tradeoff\" title=\"Bias–variance tradeoff\">Bias–variance tradeoff</a></li>\n<li><a href=\"/wiki/Double_descent\" title=\"Double descent\">Double descent</a></li>\n<li><a href=\"/wiki/Overfitting\" title=\"Overfitting\">Overfitting</a></li></ul></li>\n<li><a href=\"/wiki/Cluster_analysis\" title=\"Cluster analysis\">Clustering</a></li>\n<li><a href=\"/wiki/Gradient_descent\" title=\"Gradient descent\">Gradient descent</a>\n<ul><li><a href=\"/wiki/Stochastic_gradient_descent\" title=\"Stochastic gradient descent\">SGD</a></li>\n<li><a href=\"/wiki/Quasi-Newton_method\" title=\"Quasi-Newton method\">Quasi-Newton method</a></li>\n<li><a href=\"/wiki/Conjugate_gradient_method\" title=\"Conjugate gradient method\">Conjugate gradient method</a></li></ul></li>\n<li><a href=\"/wiki/Backpropagation\" title=\"Backpropagation\">Backpropagation</a></li>\n<li><a href=\"/wiki/Attention_(machine_learning)\" title=\"Attention (machine learning)\">Attention</a></li>\n<li><a href=\"/wiki/Convolution\" title=\"Convolution\">Convolution</a></li>\n<li><a href=\"/wiki/Normalization_(machine_learning)\" title=\"Normalization (machine learning)\">Normalization</a>\n<ul><li><a href=\"/wiki/Batch_normalization\" title=\"Batch normalization\">Batchnorm</a></li></ul></li>\n<li><a href=\"/wiki/Activation_function\" title=\"Activation function\">Activation</a>\n<ul><li><a href=\"/wiki/Softmax_function\" title=\"Softmax function\">Softmax</a></li>\n<li><a href=\"/wiki/Sigmoid_function\" title=\"Sigmoid function\">Sigmoid</a></li>\n<li><a href=\"/wiki/Rectifier_(neural_networks)\" title=\"Rectifier (neural networks)\">Rectifier</a></li></ul></li>\n<li><a href=\"/wiki/Gating_mechanism\" title=\"Gating mechanism\">Gating</a></li>\n<li><a href=\"/wiki/Weight_initialization\" title=\"Weight initialization\">Weight initialization</a></li>\n<li><a href=\"/wiki/Regularization_(mathematics)\" title=\"Regularization (mathematics)\">Regularization</a></li>\n<li><a href=\"/wiki/Training,_validation,_and_test_data_sets\" title=\"Training, validation, and test data sets\">Datasets</a>\n<ul><li><a href=\"/wiki/Data_augmentation\" title=\"Data augmentation\">Augmentation</a></li></ul></li>\n<li><a href=\"/wiki/Prompt_engineering\" title=\"Prompt engineering\">Prompt engineering</a></li>\n<li><a href=\"/wiki/Reinforcement_learning\" title=\"Reinforcement learning\">Reinforcement learning</a>\n<ul><li><a href=\"/wiki/Q-learning\" title=\"Q-learning\">Q-learning</a></li>\n<li><a href=\"/wiki/State%E2%80%93action%E2%80%93reward%E2%80%93state%E2%80%93action\" title=\"State–action–reward–state–action\">SARSA</a></li>\n<li><a href=\"/wiki/Imitation_learning\" title=\"Imitation learning\">Imitation</a></li></ul></li>\n<li><a href=\"/wiki/Diffusion_process\" title=\"Diffusion process\">Diffusion</a></li>\n<li><a href=\"/wiki/Latent_diffusion_model\" title=\"Latent diffusion model\">Latent diffusion model</a></li>\n<li><a href=\"/wiki/Autoregressive_model\" title=\"Autoregressive model\">Autoregression</a></li>\n<li><a href=\"/wiki/Adversarial_machine_learning\" title=\"Adversarial machine learning\">Adversary</a></li>\n<li><a href=\"/wiki/Retrieval-augmented_generation\" title=\"Retrieval-augmented generation\">RAG</a></li>\n<li><a href=\"/wiki/Reinforcement_learning_from_human_feedback\" title=\"Reinforcement learning from human feedback\">RLHF</a></li>\n<li><a href=\"/wiki/Self-supervised_learning\" title=\"Self-supervised learning\">Self-supervised learning</a></li>\n<li><a href=\"/wiki/Word_embedding\" title=\"Word embedding\">Word embedding</a></li>\n<li><a href=\"/wiki/Hallucination_(artificial_intelligence)\" title=\"Hallucination (artificial intelligence)\">Hallucination</a></li></ul>\n</div></td></tr><tr><th class=\"navbox-group\" scope=\"row\" style=\"width:1%\">Applications</th><td class=\"navbox-list-with-group navbox-list navbox-even\" style=\"width:100%;padding:0\"><div style=\"padding:0 0.25em\">\n<ul><li><a href=\"/wiki/Machine_learning\" title=\"Machine learning\">Machine learning</a>\n<ul><li><a href=\"/wiki/Prompt_engineering#In-context_learning\" title=\"Prompt engineering\">In-context learning</a></li></ul></li>\n<li><a href=\"/wiki/Neural_network_(machine_learning)\" title=\"Neural network (machine learning)\">Artificial neural network</a>\n<ul><li><a href=\"/wiki/Deep_learning\" title=\"Deep learning\">Deep learning</a></li></ul></li>\n<li><a href=\"/wiki/Language_model\" title=\"Language model\">Language model</a>\n<ul><li><a class=\"mw-selflink selflink\">Large language model</a></li>\n<li><a href=\"/wiki/Neural_machine_translation\" title=\"Neural machine translation\">NMT</a></li></ul></li>\n<li><a href=\"/wiki/Artificial_general_intelligence\" title=\"Artificial general intelligence\">Artificial general intelligence</a></li></ul>\n</div></td></tr><tr><th class=\"navbox-group\" scope=\"row\" style=\"width:1%\">Implementations</th><td class=\"navbox-list-with-group navbox-list navbox-odd\" style=\"width:100%;padding:0\"><div style=\"padding:0 0.25em\"></div><table class=\"nowraplinks navbox-subgroup\" style=\"border-spacing:0\"><tbody><tr><th class=\"navbox-group\" scope=\"row\" style=\"width:1%\">Audio–visual</th><td class=\"navbox-list-with-group navbox-list navbox-odd\" style=\"width:100%;padding:0\"><div style=\"padding:0 0.25em\">\n<ul><li><a href=\"/wiki/AlexNet\" title=\"AlexNet\">AlexNet</a></li>\n<li><a href=\"/wiki/WaveNet\" title=\"WaveNet\">WaveNet</a></li>\n<li><a href=\"/wiki/Human_image_synthesis\" title=\"Human image synthesis\">Human image synthesis</a></li>\n<li><a href=\"/wiki/Handwriting_recognition\" title=\"Handwriting recognition\">HWR</a></li>\n<li><a href=\"/wiki/Optical_character_recognition\" title=\"Optical character recognition\">OCR</a></li>\n<li><a href=\"/wiki/Deep_learning_speech_synthesis\" title=\"Deep learning speech synthesis\">Speech synthesis</a>\n<ul><li><a href=\"/wiki/ElevenLabs\" title=\"ElevenLabs\">ElevenLabs</a></li></ul></li>\n<li><a href=\"/wiki/Speech_recognition\" title=\"Speech recognition\">Speech recognition</a>\n<ul><li><a href=\"/wiki/Whisper_(speech_recognition_system)\" title=\"Whisper (speech recognition system)\">Whisper</a></li></ul></li>\n<li><a href=\"/wiki/Facial_recognition_system\" title=\"Facial recognition system\">Facial recognition</a></li>\n<li><a href=\"/wiki/AlphaFold\" title=\"AlphaFold\">AlphaFold</a></li>\n<li><a href=\"/wiki/Text-to-image_model\" title=\"Text-to-image model\">Text-to-image models</a>\n<ul><li><a href=\"/wiki/Aurora_(text-to-image_model)\" title=\"Aurora (text-to-image model)\">Aurora</a></li>\n<li><a href=\"/wiki/DALL-E\" title=\"DALL-E\">DALL-E</a></li>\n<li><a href=\"/wiki/Flux_(text-to-image_model)\" title=\"Flux (text-to-image model)\">Flux</a></li>\n<li><a href=\"/wiki/Ideogram_(text-to-image_model)\" title=\"Ideogram (text-to-image model)\">Ideogram</a></li>\n<li><a class=\"mw-redirect\" href=\"/wiki/Imagen_(Google_Brain)\" title=\"Imagen (Google Brain)\">Imagen</a></li>\n<li><a href=\"/wiki/Midjourney\" title=\"Midjourney\">Midjourney</a></li>\n<li><a href=\"/wiki/Stable_Diffusion\" title=\"Stable Diffusion\">Stable Diffusion</a></li></ul></li>\n<li><a href=\"/wiki/Text-to-video_model\" title=\"Text-to-video model\">Text-to-video models</a>\n<ul><li><a href=\"/wiki/Dream_Machine_(text-to-video_model)\" title=\"Dream Machine (text-to-video model)\">Dream Machine</a></li>\n<li><a class=\"mw-redirect\" href=\"/wiki/Kling_(text-to-video_model)\" title=\"Kling (text-to-video model)\">Kling</a></li>\n<li><a href=\"/wiki/Sora_(text-to-video_model)\" title=\"Sora (text-to-video model)\">Sora</a></li>\n<li><a href=\"/wiki/VideoPoet\" title=\"VideoPoet\">VideoPoet</a></li></ul></li>\n<li><a href=\"/wiki/Music_and_artificial_intelligence\" title=\"Music and artificial intelligence\">Music generation</a>\n<ul><li><a href=\"/wiki/Suno_AI\" title=\"Suno AI\">Suno AI</a></li>\n<li><a href=\"/wiki/Udio\" title=\"Udio\">Udio</a></li></ul></li></ul>\n</div></td></tr><tr><th class=\"navbox-group\" scope=\"row\" style=\"width:1%\">Text</th><td class=\"navbox-list-with-group navbox-list navbox-even\" style=\"width:100%;padding:0\"><div style=\"padding:0 0.25em\">\n<ul><li><a href=\"/wiki/Word2vec\" title=\"Word2vec\">Word2vec</a></li>\n<li><a href=\"/wiki/Seq2seq\" title=\"Seq2seq\">Seq2seq</a></li>\n<li><a href=\"/wiki/GloVe\" title=\"GloVe\">GloVe</a></li>\n<li><a href=\"/wiki/BERT_(language_model)\" title=\"BERT (language model)\">BERT</a></li>\n<li><a href=\"/wiki/T5_(language_model)\" title=\"T5 (language model)\">T5</a></li>\n<li><a href=\"/wiki/Llama_(language_model)\" title=\"Llama (language model)\">Llama</a></li>\n<li><a href=\"/wiki/Chinchilla_(language_model)\" title=\"Chinchilla (language model)\">Chinchilla AI</a></li>\n<li><a href=\"/wiki/PaLM\" title=\"PaLM\">PaLM</a></li>\n<li><a href=\"/wiki/Generative_pre-trained_transformer\" title=\"Generative pre-trained transformer\">GPT</a>\n<ul><li><a href=\"/wiki/GPT-1\" title=\"GPT-1\">1</a></li>\n<li><a href=\"/wiki/GPT-2\" title=\"GPT-2\">2</a></li>\n<li><a href=\"/wiki/GPT-3\" title=\"GPT-3\">3</a></li>\n<li><a href=\"/wiki/GPT-J\" title=\"GPT-J\">J</a></li>\n<li><a href=\"/wiki/ChatGPT\" title=\"ChatGPT\">ChatGPT</a></li>\n<li><a href=\"/wiki/GPT-4\" title=\"GPT-4\">4</a></li>\n<li><a href=\"/wiki/GPT-4o\" title=\"GPT-4o\">4o</a></li>\n<li><a href=\"/wiki/OpenAI_o1\" title=\"OpenAI o1\">o1</a></li></ul></li>\n<li><a href=\"/wiki/Claude_(language_model)\" title=\"Claude (language model)\">Claude</a></li>\n<li><a href=\"/wiki/Gemini_(language_model)\" title=\"Gemini (language model)\">Gemini</a>\n<ul><li><a href=\"/wiki/Gemini_(chatbot)\" title=\"Gemini (chatbot)\">chatbot</a></li></ul></li>\n<li><a href=\"/wiki/Grok_(chatbot)\" title=\"Grok (chatbot)\">Grok</a></li>\n<li><a href=\"/wiki/LaMDA\" title=\"LaMDA\">LaMDA</a></li>\n<li><a href=\"/wiki/BLOOM_(language_model)\" title=\"BLOOM (language model)\">BLOOM</a></li>\n<li><a href=\"/wiki/Project_Debater\" title=\"Project Debater\">Project Debater</a></li>\n<li><a href=\"/wiki/IBM_Watson\" title=\"IBM Watson\">IBM Watson</a></li>\n<li><a href=\"/wiki/IBM_Watsonx\" title=\"IBM Watsonx\">IBM Watsonx</a></li>\n<li><a href=\"/wiki/IBM_Granite\" title=\"IBM Granite\">Granite</a></li>\n<li><a href=\"/wiki/Huawei_PanGu\" title=\"Huawei PanGu\">PanGu-Σ</a></li></ul>\n</div></td></tr><tr><th class=\"navbox-group\" scope=\"row\" style=\"width:1%\">Decisional</th><td class=\"navbox-list-with-group navbox-list navbox-odd\" style=\"width:100%;padding:0\"><div style=\"padding:0 0.25em\">\n<ul><li><a href=\"/wiki/AlphaGo\" title=\"AlphaGo\">AlphaGo</a></li>\n<li><a href=\"/wiki/AlphaZero\" title=\"AlphaZero\">AlphaZero</a></li>\n<li><a href=\"/wiki/OpenAI_Five\" title=\"OpenAI Five\">OpenAI Five</a></li>\n<li><a href=\"/wiki/Self-driving_car\" title=\"Self-driving car\">Self-driving car</a></li>\n<li><a href=\"/wiki/MuZero\" title=\"MuZero\">MuZero</a></li>\n<li><a href=\"/wiki/Action_selection\" title=\"Action selection\">Action selection</a>\n<ul><li><a href=\"/wiki/AutoGPT\" title=\"AutoGPT\">AutoGPT</a></li></ul></li>\n<li><a href=\"/wiki/Robot_control\" title=\"Robot control\">Robot control</a></li></ul>\n</div></td></tr></tbody></table><div></div></td></tr><tr><th class=\"navbox-group\" scope=\"row\" style=\"width:1%\">People</th><td class=\"navbox-list-with-group navbox-list navbox-even\" style=\"width:100%;padding:0\"><div style=\"padding:0 0.25em\">\n<ul><li><a href=\"/wiki/Alan_Turing\" title=\"Alan Turing\">Alan Turing</a></li>\n<li><a href=\"/wiki/Warren_Sturgis_McCulloch\" title=\"Warren Sturgis McCulloch\">Warren Sturgis McCulloch</a></li>\n<li><a href=\"/wiki/Walter_Pitts\" title=\"Walter Pitts\">Walter Pitts</a></li>\n<li><a href=\"/wiki/John_von_Neumann\" title=\"John von Neumann\">John von Neumann</a></li>\n<li><a href=\"/wiki/Claude_Shannon\" title=\"Claude Shannon\">Claude Shannon</a></li>\n<li><a href=\"/wiki/Marvin_Minsky\" title=\"Marvin Minsky\">Marvin Minsky</a></li>\n<li><a href=\"/wiki/John_McCarthy_(computer_scientist)\" title=\"John McCarthy (computer scientist)\">John McCarthy</a></li>\n<li><a href=\"/wiki/Nathaniel_Rochester_(computer_scientist)\" title=\"Nathaniel Rochester (computer scientist)\">Nathaniel Rochester</a></li>\n<li><a href=\"/wiki/Allen_Newell\" title=\"Allen Newell\">Allen Newell</a></li>\n<li><a href=\"/wiki/Cliff_Shaw\" title=\"Cliff Shaw\">Cliff Shaw</a></li>\n<li><a href=\"/wiki/Herbert_A._Simon\" title=\"Herbert A. Simon\">Herbert A. Simon</a></li>\n<li><a href=\"/wiki/Oliver_Selfridge\" title=\"Oliver Selfridge\">Oliver Selfridge</a></li>\n<li><a href=\"/wiki/Frank_Rosenblatt\" title=\"Frank Rosenblatt\">Frank Rosenblatt</a></li>\n<li><a href=\"/wiki/Bernard_Widrow\" title=\"Bernard Widrow\">Bernard Widrow</a></li>\n<li><a href=\"/wiki/Joseph_Weizenbaum\" title=\"Joseph Weizenbaum\">Joseph Weizenbaum</a></li>\n<li><a href=\"/wiki/Seymour_Papert\" title=\"Seymour Papert\">Seymour Papert</a></li>\n<li><a href=\"/wiki/Seppo_Linnainmaa\" title=\"Seppo Linnainmaa\">Seppo Linnainmaa</a></li>\n<li><a href=\"/wiki/Paul_Werbos\" title=\"Paul Werbos\">Paul Werbos</a></li>\n<li><a href=\"/wiki/J%C3%BCrgen_Schmidhuber\" title=\"Jürgen Schmidhuber\">Jürgen Schmidhuber</a></li>\n<li><a href=\"/wiki/Yann_LeCun\" title=\"Yann LeCun\">Yann LeCun</a></li>\n<li><a href=\"/wiki/Geoffrey_Hinton\" title=\"Geoffrey Hinton\">Geoffrey Hinton</a></li>\n<li><a href=\"/wiki/John_Hopfield\" title=\"John Hopfield\">John Hopfield</a></li>\n<li><a href=\"/wiki/Yoshua_Bengio\" title=\"Yoshua Bengio\">Yoshua Bengio</a></li>\n<li><a href=\"/wiki/Lotfi_A._Zadeh\" title=\"Lotfi A. Zadeh\">Lotfi A. Zadeh</a></li>\n<li><a href=\"/wiki/Stephen_Grossberg\" title=\"Stephen Grossberg\">Stephen Grossberg</a></li>\n<li><a href=\"/wiki/Alex_Graves_(computer_scientist)\" title=\"Alex Graves (computer scientist)\">Alex Graves</a></li>\n<li><a href=\"/wiki/Andrew_Ng\" title=\"Andrew Ng\">Andrew Ng</a></li>\n<li><a href=\"/wiki/Fei-Fei_Li\" title=\"Fei-Fei Li\">Fei-Fei Li</a></li>\n<li><a href=\"/wiki/Alex_Krizhevsky\" title=\"Alex Krizhevsky\">Alex Krizhevsky</a></li>\n<li><a href=\"/wiki/Ilya_Sutskever\" title=\"Ilya Sutskever\">Ilya Sutskever</a></li>\n<li><a href=\"/wiki/Demis_Hassabis\" title=\"Demis Hassabis\">Demis Hassabis</a></li>\n<li><a href=\"/wiki/David_Silver_(computer_scientist)\" title=\"David Silver (computer scientist)\">David Silver</a></li>\n<li><a href=\"/wiki/Ian_Goodfellow\" title=\"Ian Goodfellow\">Ian Goodfellow</a></li>\n<li><a href=\"/wiki/Andrej_Karpathy\" title=\"Andrej Karpathy\">Andrej Karpathy</a></li></ul>\n</div></td></tr><tr><th class=\"navbox-group\" scope=\"row\" style=\"width:1%\">Architectures</th><td class=\"navbox-list-with-group navbox-list navbox-odd\" style=\"width:100%;padding:0\"><div style=\"padding:0 0.25em\">\n<ul><li><a href=\"/wiki/Neural_Turing_machine\" title=\"Neural Turing machine\">Neural Turing machine</a></li>\n<li><a href=\"/wiki/Differentiable_neural_computer\" title=\"Differentiable neural computer\">Differentiable neural computer</a></li>\n<li><a href=\"/wiki/Transformer_(deep_learning_architecture)\" title=\"Transformer (deep learning architecture)\">Transformer</a>\n<ul><li><a href=\"/wiki/Vision_transformer\" title=\"Vision transformer\">Vision transformer (ViT)</a></li></ul></li>\n<li><a href=\"/wiki/Recurrent_neural_network\" title=\"Recurrent neural network\">Recurrent neural network (RNN)</a></li>\n<li><a href=\"/wiki/Long_short-term_memory\" title=\"Long short-term memory\">Long short-term memory (LSTM)</a></li>\n<li><a href=\"/wiki/Gated_recurrent_unit\" title=\"Gated recurrent unit\">Gated recurrent unit (GRU)</a></li>\n<li><a href=\"/wiki/Echo_state_network\" title=\"Echo state network\">Echo state network</a></li>\n<li><a href=\"/wiki/Multilayer_perceptron\" title=\"Multilayer perceptron\">Multilayer perceptron (MLP)</a></li>\n<li><a href=\"/wiki/Convolutional_neural_network\" title=\"Convolutional neural network\">Convolutional neural network (CNN)</a></li>\n<li><a href=\"/wiki/Residual_neural_network\" title=\"Residual neural network\">Residual neural network (RNN)</a></li>\n<li><a href=\"/wiki/Highway_network\" title=\"Highway network\">Highway network</a></li>\n<li><a href=\"/wiki/Mamba_(deep_learning_architecture)\" title=\"Mamba (deep learning architecture)\">Mamba</a></li>\n<li><a href=\"/wiki/Autoencoder\" title=\"Autoencoder\">Autoencoder</a></li>\n<li><a href=\"/wiki/Variational_autoencoder\" title=\"Variational autoencoder\">Variational autoencoder (VAE)</a></li>\n<li><a href=\"/wiki/Generative_adversarial_network\" title=\"Generative adversarial network\">Generative adversarial network (GAN)</a></li>\n<li><a href=\"/wiki/Graph_neural_network\" title=\"Graph neural network\">Graph neural network (GNN)</a></li></ul>\n</div></td></tr><tr><td class=\"navbox-abovebelow\" colspan=\"2\"><div>\n<ul><li><span class=\"noviewer\" typeof=\"mw:File\"><a class=\"mw-file-description\" href=\"/wiki/File:Symbol_portal_class.svg\" title=\"Portal\"><img alt=\"\" class=\"mw-file-element\" data-file-height=\"185\" data-file-width=\"180\" decoding=\"async\" height=\"16\" src=\"//upload.wikimedia.org/wikipedia/en/thumb/e/e2/Symbol_portal_class.svg/16px-Symbol_portal_class.svg.png\" srcset=\"//upload.wikimedia.org/wikipedia/en/thumb/e/e2/Symbol_portal_class.svg/23px-Symbol_portal_class.svg.png 1.5x, //upload.wikimedia.org/wikipedia/en/thumb/e/e2/Symbol_portal_class.svg/31px-Symbol_portal_class.svg.png 2x\" width=\"16\"/></a></span> Portals\n<ul><li><a href=\"/wiki/Portal:Technology\" title=\"Portal:Technology\">Technology</a></li></ul></li>\n<li><span class=\"noviewer\" typeof=\"mw:File\"><span title=\"Category\"><img alt=\"\" class=\"mw-file-element\" data-file-height=\"185\" data-file-width=\"180\" decoding=\"async\" height=\"16\" src=\"//upload.wikimedia.org/wikipedia/en/thumb/9/96/Symbol_category_class.svg/16px-Symbol_category_class.svg.png\" srcset=\"//upload.wikimedia.org/wikipedia/en/thumb/9/96/Symbol_category_class.svg/23px-Symbol_category_class.svg.png 1.5x, //upload.wikimedia.org/wikipedia/en/thumb/9/96/Symbol_category_class.svg/31px-Symbol_category_class.svg.png 2x\" width=\"16\"/></span></span> Categories\n<ul><li><a href=\"/wiki/Category:Artificial_neural_networks\" title=\"Category:Artificial neural networks\">Artificial neural networks</a></li>\n<li><a href=\"/wiki/Category:Machine_learning\" title=\"Category:Machine learning\">Machine learning</a></li></ul></li>\n<li><span class=\"noviewer\" typeof=\"mw:File\"><span title=\"List-Class article\"><img alt=\"\" class=\"mw-file-element\" data-file-height=\"185\" data-file-width=\"180\" decoding=\"async\" height=\"16\" src=\"//upload.wikimedia.org/wikipedia/en/thumb/d/db/Symbol_list_class.svg/16px-Symbol_list_class.svg.png\" srcset=\"//upload.wikimedia.org/wikipedia/en/thumb/d/db/Symbol_list_class.svg/23px-Symbol_list_class.svg.png 1.5x, //upload.wikimedia.org/wikipedia/en/thumb/d/db/Symbol_list_class.svg/31px-Symbol_list_class.svg.png 2x\" width=\"16\"/></span></span> List\n<ul><li><a href=\"/wiki/List_of_artificial_intelligence_companies\" title=\"List of artificial intelligence companies\">Companies</a></li>\n<li><a href=\"/wiki/List_of_artificial_intelligence_projects\" title=\"List of artificial intelligence projects\">Projects</a></li></ul></li></ul>\n</div></td></tr></tbody></table></div>\n<!-- \nNewPP limit report\nParsed by mw‐api‐ext.eqiad.main‐5fc8b9c747‐v9ftp\nCached time: 20241211195316\nCache expiry: 2592000\nReduced expiry: false\nComplications: [vary‐revision‐sha1, show‐toc]\nCPU time usage: 2.980 seconds\nReal time usage: 3.267 seconds\nPreprocessor visited node count: 19651/1000000\nPost‐expand include size: 693148/2097152 bytes\nTemplate argument size: 13887/2097152 bytes\nHighest expansion depth: 23/100\nExpensive parser function count: 23/500\nUnstrip recursion depth: 1/20\nUnstrip post‐expand size: 922003/5000000 bytes\nLua time usage: 1.987/10.000 seconds\nLua memory usage: 9054608/52428800 bytes\nLua Profile:\n    dataWrapper <mw.lua:672>                                         300 ms       15.5%\n    ?                                                                280 ms       14.4%\n    <mw.lua:694>                                                     160 ms        8.2%\n    MediaWiki\\Extension\\Scribunto\\Engines\\LuaSandbox\\LuaSandboxCallback::callParserFunction      160 ms        8.2%\n    MediaWiki\\Extension\\Scribunto\\Engines\\LuaSandbox\\LuaSandboxCallback::find      140 ms        7.2%\n    MediaWiki\\Extension\\Scribunto\\Engines\\LuaSandbox\\LuaSandboxCallback::gsub      140 ms        7.2%\n    MediaWiki\\Extension\\Scribunto\\Engines\\LuaSandbox\\LuaSandboxCallback::match      100 ms        5.2%\n    recursiveClone <mwInit.lua:45>                                    80 ms        4.1%\n    MediaWiki\\Extension\\Scribunto\\Engines\\LuaSandbox\\LuaSandboxCallback::sub       60 ms        3.1%\n    MediaWiki\\Extension\\Scribunto\\Engines\\LuaSandbox\\LuaSandboxCallback::get       40 ms        2.1%\n    [others]                                                         480 ms       24.7%\nNumber of Wikibase entities loaded: 0/400\n-->\n<!--\nTransclusion expansion time report (%,ms,calls,template)\n100.00% 2763.295      1 -total\n 72.43% 2001.334      2 Template:Reflist\n 24.08%  665.300     77 Template:Cite_arXiv\n 20.66%  570.851    100 Template:Cite_web\n  8.12%  224.367     30 Template:Cite_journal\n  7.42%  205.077      1 Template:Harvnb\n  4.24%  117.162      1 Template:Machine_learning\n  3.92%  108.333      1 Template:Sidebar_with_collapsible_lists\n  3.39%   93.640      1 Template:Short_description\n  2.50%   69.062     13 Template:Citation\n-->\n<!-- Saved in parser cache with key enwiki:pcache:73248112:|#|:idhash:canonical and timestamp 20241211195316 and revision id 1262506262. Rendering was triggered because: unknown\n -->\n</meta></div><!--esi <esi:include src=\"/esitest-fa8a495983347898/content\" /> -->\n<div class=\"printfooter\" data-nosnippet=\"\">Retrieved from \"<a dir=\"ltr\" href=\"https://en.wikipedia.org/w/index.php?title=Large_language_model&amp;oldid=1262506262\">https://en.wikipedia.org/w/index.php?title=Large_language_model&amp;oldid=1262506262</a>\"</div></div>\n<div class=\"catlinks\" data-mw=\"interface\" id=\"catlinks\"><div class=\"mw-normal-catlinks\" id=\"mw-normal-catlinks\"><a href=\"/wiki/Help:Category\" title=\"Help:Category\">Categories</a>: <ul><li><a href=\"/wiki/Category:Large_language_models\" title=\"Category:Large language models\">Large language models</a></li><li><a href=\"/wiki/Category:Deep_learning\" title=\"Category:Deep learning\">Deep learning</a></li><li><a href=\"/wiki/Category:Natural_language_processing\" title=\"Category:Natural language processing\">Natural language processing</a></li></ul></div><div class=\"mw-hidden-catlinks mw-hidden-cats-hidden\" id=\"mw-hidden-catlinks\">Hidden categories: <ul><li><a href=\"/wiki/Category:CS1_maint:_url-status\" title=\"Category:CS1 maint: url-status\">CS1 maint: url-status</a></li><li><a href=\"/wiki/Category:CS1:_long_volume_value\" title=\"Category:CS1: long volume value\">CS1: long volume value</a></li><li><a href=\"/wiki/Category:Webarchive_template_wayback_links\" title=\"Category:Webarchive template wayback links\">Webarchive template wayback links</a></li><li><a href=\"/wiki/Category:Articles_with_short_description\" title=\"Category:Articles with short description\">Articles with short description</a></li><li><a href=\"/wiki/Category:Short_description_is_different_from_Wikidata\" title=\"Category:Short description is different from Wikidata\">Short description is different from Wikidata</a></li><li><a href=\"/wiki/Category:Articles_containing_potentially_dated_statements_from_2024\" title=\"Category:Articles containing potentially dated statements from 2024\">Articles containing potentially dated statements from 2024</a></li><li><a href=\"/wiki/Category:All_articles_containing_potentially_dated_statements\" title=\"Category:All articles containing potentially dated statements\">All articles containing potentially dated statements</a></li><li><a href=\"/wiki/Category:Articles_containing_potentially_dated_statements_from_June_2024\" title=\"Category:Articles containing potentially dated statements from June 2024\">Articles containing potentially dated statements from June 2024</a></li><li><a href=\"/wiki/Category:All_accuracy_disputes\" title=\"Category:All accuracy disputes\">All accuracy disputes</a></li><li><a href=\"/wiki/Category:Articles_with_disputed_statements_from_September_2024\" title=\"Category:Articles with disputed statements from September 2024\">Articles with disputed statements from September 2024</a></li><li><a href=\"/wiki/Category:All_articles_with_unsourced_statements\" title=\"Category:All articles with unsourced statements\">All articles with unsourced statements</a></li><li><a href=\"/wiki/Category:Articles_with_unsourced_statements_from_February_2024\" title=\"Category:Articles with unsourced statements from February 2024\">Articles with unsourced statements from February 2024</a></li><li><a href=\"/wiki/Category:Articles_containing_potentially_dated_statements_from_October_2024\" title=\"Category:Articles containing potentially dated statements from October 2024\">Articles containing potentially dated statements from October 2024</a></li></ul></div></div>\n</div>\n</main>\n</div>\n<div class=\"mw-footer-container\">\n\n</div>\n</div>\n</div>\n<div class=\"vector-settings\" id=\"p-dock-bottom\">\n<ul></ul>\n</div>\n\n</body>\n</html>"
}

if __name__ == "__main__":
    # Configure output handling
    config = TestOutputConfig(
        output_dir=Path("test_outputs"),
        format="json",
        create_timestamp_dir=True,
        pretty_print=True
    )
    output_handler = TestOutputHandler(config)
    parsed = apply_parsing_strategy(inputs["original_content"], inputs["selectors"])
    LOGGER.info(parsed)
    output_handler.save_output(data={"content": parsed}, filename='parsed_content')