from typing import TYPE_CHECKING, Callable, List, Tuple, Any

if TYPE_CHECKING:
    from ..authorization import AuthorizationResponse, Policy, Gate as GateObject

class Gate:
    """Gate facade."""

    def define(permission: str, condition: Callable): ...
    def register_policies(policies: List[Tuple[Any, Policy]]) -> "Gate": ...
    def get_policy_for(instance_or_class: "str|Any") -> "None|Policy": ...
    def before(before_callback: Callable): ...
    def after(after_callback: Callable): ...
    def allows(permission: str, *args) -> bool: ...
    def denies(permission, *args) -> bool: ...
    def has(permission: str) -> bool: ...
    def for_user(user: Any) -> GateObject: ...
    def any(permissions: List[str], *args) -> bool:
        """Check that every of those permissions are allowed."""
        ...
    def none(permissions: List[str], *args) -> bool:
        """Check that none of those permissions are allowed."""
        ...
    def authorize(permission: str, *args) -> bool: ...
    def inspect(permission: str, *args) -> "bool|AuthorizationResponse":
        """Get permission checks results for the given user then builds and returns an
        authorization response."""
        ...
    def check(permission: str, *args):
        """The core of the authorization class. Run before() checks, permission check and then
        after() checks."""
        ...
