# noqa: W605
PATTERNS = {
    "AC": {
        "example": "ASCN 1ZZ",
        "pattern": r"^(?:ASCN 1ZZ)$",
    },
    "AD": {
        "example": "AD100",
        "pattern": r"^(?:AD[1-7]0\d)$",
    },
    "AE": {
        "example": None,
        "pattern": None,
    },
    "AF": {
        "example": "1001",
        "pattern": r"^(?:\d{4})$",
    },
    "AG": {
        "example": None,
        "pattern": None,
    },
    "AI": {
        "example": "2640",
        "pattern": r"^(?:(?:AI-)?2640)$",
    },
    "AL": {
        "example": "1001",
        "pattern": r"^(?:\d{4})$",
    },
    "AM": {
        "example": "375010",
        "pattern": r"^(?:(?:37)?\d{4})$",
    },
    "AO": {
        "example": None,
        "pattern": None,
    },
    "AQ": {
        "example": None,
        "pattern": None,
    },
    "AR": {
        "example": "C1070AAM",
        "pattern": r"^(?:((?:[A-HJ-NP-Z])?\d{4})([A-Z]{3})?)$",
    },
    "AS": {
        "example": "96799",
        "pattern": r"^(?:(96799)(?:[ \-](\d{4}))?)$",
    },
    "AT": {
        "example": "1010",
        "pattern": r"^(?:\d{4})$",
    },
    "AU": {
        "example": "2060",
        "pattern": r"^(?:\d{4})$",
    },
    "AW": {
        "example": None,
        "pattern": None,
    },
    "AX": {
        "example": "22150",
        "pattern": r"^(?:22\d{3})$",
    },
    "AZ": {
        "example": "1000",
        "pattern": r"^(?:\d{4})$",
    },
    "BA": {
        "example": "71000",
        "pattern": r"^(?:\d{5})$",
    },
    "BB": {
        "example": "BB23026",
        "pattern": r"^(?:BB\d{5})$",
    },
    "BD": {
        "example": "1340",
        "pattern": r"^(?:\d{4})$",
    },
    "BE": {
        "example": "4000",
        "pattern": r"^(?:\d{4})$",
    },
    "BF": {
        "example": None,
        "pattern": None,
    },
    "BG": {
        "example": "1000",
        "pattern": r"^(?:\d{4})$",
    },
    "BH": {
        "example": "317",
        "pattern": r"^(?:(?:\d|1[0-2])\d{2})$",
    },
    "BI": {
        "example": None,
        "pattern": None,
    },
    "BJ": {
        "example": None,
        "pattern": None,
    },
    "BL": {
        "example": "97100",
        "pattern": r"^(?:9[78][01]\d{2})$",
    },
    "BM": {
        "example": "FL 07",
        "pattern": r"^(?:[A-Z]{2} ?[A-Z0-9]{2})$",
    },
    "BN": {
        "example": "BT2328",
        "pattern": r"^(?:[A-Z]{2} ?\d{4})$",
    },
    "BO": {
        "example": None,
        "pattern": None,
    },
    "BQ": {
        "example": None,
        "pattern": None,
    },
    "BR": {
        "example": "40301-110",
        "pattern": r"^(?:\d{5}-?\d{3})$",
    },
    "BS": {
        "example": None,
        "pattern": None,
    },
    "BT": {
        "example": "11001",
        "pattern": r"^(?:\d{5})$",
    },
    "BV": {
        "example": None,
        "pattern": None,
    },
    "BW": {
        "example": None,
        "pattern": None,
    },
    "BY": {
        "example": "223016",
        "pattern": r"^(?:\d{6})$",
    },
    "BZ": {
        "example": None,
        "pattern": None,
    },
    "CA": {
        "example": "H3Z 2Y7",
        "pattern": r"^(?:[ABCEGHJKLMNPRSTVXY]\d[ABCEGHJ-NPRSTV-Z] ?\d[ABCEGHJ-NPRSTV-Z]\d)$",
    },
    "CC": {
        "example": "6799",
        "pattern": r"^(?:6799)$",
    },
    "CD": {
        "example": None,
        "pattern": None,
    },
    "CF": {
        "example": None,
        "pattern": None,
    },
    "CG": {
        "example": None,
        "pattern": None,
    },
    "CH": {
        "example": "2544",
        "pattern": r"^(?:\d{4})$",
    },
    "CI": {
        "example": None,
        "pattern": None,
    },
    "CK": {
        "example": None,
        "pattern": None,
    },
    "CL": {
        "example": "8340457",
        "pattern": r"^(?:\d{7})$",
    },
    "CM": {
        "example": None,
        "pattern": None,
    },
    "CN": {
        "example": "266033",
        "pattern": r"^(?:\d{6})$",
    },
    "CO": {
        "example": "111221",
        "pattern": r"^(?:\d{6})$",
    },
    "CR": {
        "example": "1000",
        "pattern": r"^(?:\d{4,5}|\d{3}-\d{4})$",
    },
    "CU": {
        "example": "10700",
        "pattern": r"^(?:\d{5})$",
    },
    "CV": {
        "example": "7600",
        "pattern": r"^(?:\d{4})$",
    },
    "CW": {
        "example": None,
        "pattern": None,
    },
    "CX": {
        "example": "6798",
        "pattern": r"^(?:6798)$",
    },
    "CY": {
        "example": "2008",
        "pattern": r"^(?:\d{4})$",
    },
    "CZ": {
        "example": "100 00",
        "pattern": r"^(?:\d{3} ?\d{2})$",
    },
    "DE": {
        "example": "26133",
        "pattern": r"^(?:\d{5})$",
    },
    "DJ": {
        "example": None,
        "pattern": None,
    },
    "DK": {
        "example": "8660",
        "pattern": r"^(?:\d{4})$",
    },
    "DM": {
        "example": None,
        "pattern": None,
    },
    "DO": {
        "example": "11903",
        "pattern": r"^(?:\d{5})$",
    },
    "DZ": {
        "example": "40304",
        "pattern": r"^(?:\d{5})$",
    },
    "EC": {
        "example": "090105",
        "pattern": r"^(?:\d{6})$",
    },
    "EE": {
        "example": "69501",
        "pattern": r"^(?:\d{5})$",
    },
    "EG": {
        "example": "12411",
        "pattern": r"^(?:\d{5})$",
    },
    "EH": {
        "example": "70000",
        "pattern": r"^(?:\d{5})$",
    },
    "ER": {
        "example": None,
        "pattern": None,
    },
    "ES": {
        "example": "28039",
        "pattern": r"^(?:\d{5})$",
    },
    "ET": {
        "example": "1000",
        "pattern": r"^(?:\d{4})$",
    },
    "FI": {
        "example": "00550",
        "pattern": r"^(?:\d{5})$",
    },
    "FJ": {
        "example": None,
        "pattern": None,
    },
    "FK": {
        "example": "FIQQ 1ZZ",
        "pattern": r"^(?:FIQQ 1ZZ)$",
    },
    "FM": {
        "example": "96941",
        "pattern": r"^(?:(9694[1-4])(?:[ \-](\d{4}))?)$",
    },
    "FO": {
        "example": "100",
        "pattern": r"^(?:\d{3})$",
    },
    "FR": {
        "example": "33380",
        "pattern": r"^(?:\d{2} ?\d{3})$",
    },
    "GA": {
        "example": None,
        "pattern": None,
    },
    "GB": {
        "example": "EC1Y 8SY",
        "pattern": r"^(?:GIR ?0AA|(?:(?:AB|AL|B|BA|BB|BD|BF|BH|BL|BN|BR|BS|BT|BX|CA|CB|CF|CH|CM|CO|CR|CT|CV|CW|DA|DD|DE|DG|DH|DL|DN|DT|DY|E|EC|EH|EN|EX|FK|FY|G|GL|GY|GU|HA|HD|HG|HP|HR|HS|HU|HX|IG|IM|IP|IV|JE|KA|KT|KW|KY|L|LA|LD|LE|LL|LN|LS|LU|M|ME|MK|ML|N|NE|NG|NN|NP|NR|NW|OL|OX|PA|PE|PH|PL|PO|PR|RG|RH|RM|S|SA|SE|SG|SK|SL|SM|SN|SO|SP|SR|SS|ST|SW|SY|TA|TD|TF|TN|TQ|TR|TS|TW|UB|W|WA|WC|WD|WF|WN|WR|WS|WV|YO|ZE)(?:\d[\dA-Z]? ?\d[ABD-HJLN-UW-Z]{2}))|BFPO ?\d{1,4})$",
    },
    "GD": {
        "example": None,
        "pattern": None,
    },
    "GE": {
        "example": "0101",
        "pattern": r"^(?:\d{4})$",
    },
    "GF": {
        "example": "97300",
        "pattern": r"^(?:9[78]3\d{2})$",
    },
    "GG": {
        "example": "GY1 1AA",
        "pattern": r"^(?:GY\d[\dA-Z]? ?\d[ABD-HJLN-UW-Z]{2})$",
    },
    "GH": {
        "example": None,
        "pattern": None,
    },
    "GI": {
        "example": "GX11 1AA",
        "pattern": r"^(?:GX11 1AA)$",
    },
    "GL": {
        "example": "3900",
        "pattern": r"^(?:39\d{2})$",
    },
    "GM": {
        "example": None,
        "pattern": None,
    },
    "GN": {
        "example": "001",
        "pattern": r"^(?:\d{3})$",
    },
    "GP": {
        "example": "97100",
        "pattern": r"^(?:9[78][01]\d{2})$",
    },
    "GQ": {
        "example": None,
        "pattern": None,
    },
    "GR": {
        "example": "151 24",
        "pattern": r"^(?:\d{3} ?\d{2})$",
    },
    "GS": {
        "example": "SIQQ 1ZZ",
        "pattern": r"^(?:SIQQ 1ZZ)$",
    },
    "GT": {
        "example": "09001",
        "pattern": r"^(?:\d{5})$",
    },
    "GU": {
        "example": "96910",
        "pattern": r"^(?:(969(?:[12]\d|3[12]))(?:[ \-](\d{4}))?)$",
    },
    "GW": {
        "example": "1000",
        "pattern": r"^(?:\d{4})$",
    },
    "GY": {
        "example": None,
        "pattern": None,
    },
    "HK": {
        "example": None,
        "pattern": None,
    },
    "HM": {
        "example": "7050",
        "pattern": r"^(?:\d{4})$",
    },
    "HN": {
        "example": "31301",
        "pattern": r"^(?:\d{5})$",
    },
    "HR": {
        "example": "10000",
        "pattern": r"^(?:\d{5})$",
    },
    "HT": {
        "example": "6120",
        "pattern": r"^(?:\d{4})$",
    },
    "HU": {
        "example": "1037",
        "pattern": r"^(?:\d{4})$",
    },
    "ID": {
        "example": "40115",
        "pattern": r"^(?:\d{5})$",
    },
    "IE": {
        "example": "A65 F4E2",
        "pattern": r"^(?:[\dA-Z]{3} ?[\dA-Z]{4})$",
    },
    "IL": {
        "example": "9614303",
        "pattern": r"^(?:\d{5}(?:\d{2})?)$",
    },
    "IM": {
        "example": "IM2 1AA",
        "pattern": r"^(?:IM\d[\dA-Z]? ?\d[ABD-HJLN-UW-Z]{2})$",
    },
    "IN": {
        "example": "110034",
        "pattern": r"^(?:\d{6})$",
    },
    "IO": {
        "example": "BBND 1ZZ",
        "pattern": r"^(?:BBND 1ZZ)$",
    },
    "IQ": {
        "example": "31001",
        "pattern": r"^(?:\d{5})$",
    },
    "IR": {
        "example": "11936-12345",
        "pattern": r"^(?:\d{5}-?\d{5})$",
    },
    "IS": {
        "example": "320",
        "pattern": r"^(?:\d{3})$",
    },
    "IT": {
        "example": "00144",
        "pattern": r"^(?:\d{5})$",
    },
    "JE": {
        "example": "JE1 1AA",
        "pattern": r"^(?:JE\d[\dA-Z]? ?\d[ABD-HJLN-UW-Z]{2})$",
    },
    "JM": {
        "example": None,
        "pattern": None,
    },
    "JO": {
        "example": "11937",
        "pattern": r"^(?:\d{5})$",
    },
    "JP": {
        "example": "154-0023",
        "pattern": r"^(?:\d{3}-?\d{4})$",
    },
    "KE": {
        "example": "20100",
        "pattern": r"^(?:\d{5})$",
    },
    "KG": {
        "example": "720001",
        "pattern": r"^(?:\d{6})$",
    },
    "KH": {
        "example": "12203",
        "pattern": r"^(?:\d{5})$",
    },
    "KI": {
        "example": None,
        "pattern": None,
    },
    "KM": {
        "example": None,
        "pattern": None,
    },
    "KN": {
        "example": None,
        "pattern": None,
    },
    "KP": {
        "example": None,
        "pattern": None,
    },
    "KR": {
        "example": "03051",
        "pattern": r"^(?:\d{5})$",
    },
    "KW": {
        "example": "54541",
        "pattern": r"^(?:\d{5})$",
    },
    "KY": {
        "example": "KY1-1100",
        "pattern": r"^(?:KY\d-\d{4})$",
    },
    "KZ": {
        "example": "040900",
        "pattern": r"^(?:\d{6})$",
    },
    "LA": {
        "example": "01160",
        "pattern": r"^(?:\d{5})$",
    },
    "LB": {
        "example": "2038 3054",
        "pattern": r"^(?:(?:\d{4})(?: ?(?:\d{4}))?)$",
    },
    "LC": {
        "example": None,
        "pattern": None,
    },
    "LI": {
        "example": "9496",
        "pattern": r"^(?:948[5-9]|949[0-8])$",
    },
    "LK": {
        "example": "20000",
        "pattern": r"^(?:\d{5})$",
    },
    "LR": {
        "example": "1000",
        "pattern": r"^(?:\d{4})$",
    },
    "LS": {
        "example": "100",
        "pattern": r"^(?:\d{3})$",
    },
    "LT": {
        "example": "04340",
        "pattern": r"^(?:\d{5})$",
    },
    "LU": {
        "example": "4750",
        "pattern": r"^(?:\d{4})$",
    },
    "LV": {
        "example": "LV-1073",
        "pattern": r"^(?:LV-\d{4})$",
    },
    "LY": {
        "example": None,
        "pattern": None,
    },
    "MA": {
        "example": "53000",
        "pattern": r"^(?:\d{5})$",
    },
    "MC": {
        "example": "98000",
        "pattern": r"^(?:980\d{2})$",
    },
    "MD": {
        "example": "2012",
        "pattern": r"^(?:\d{4})$",
    },
    "ME": {
        "example": "81257",
        "pattern": r"^(?:8\d{4})$",
    },
    "MF": {
        "example": "97100",
        "pattern": r"^(?:9[78][01]\d{2})$",
    },
    "MG": {
        "example": "501",
        "pattern": r"^(?:\d{3})$",
    },
    "MH": {
        "example": "96960",
        "pattern": r"^(?:(969[67]\d)(?:[ \-](\d{4}))?)$",
    },
    "MK": {
        "example": "1314",
        "pattern": r"^(?:\d{4})$",
    },
    "ML": {
        "example": None,
        "pattern": None,
    },
    "MM": {
        "example": "11181",
        "pattern": r"^(?:\d{5})$",
    },
    "MN": {
        "example": "65030",
        "pattern": r"^(?:\d{5})$",
    },
    "MO": {
        "example": None,
        "pattern": None,
    },
    "MP": {
        "example": "96950",
        "pattern": r"^(?:(9695[012])(?:[ \-](\d{4}))?)$",
    },
    "MQ": {
        "example": "97220",
        "pattern": r"^(?:9[78]2\d{2})$",
    },
    "MR": {
        "example": None,
        "pattern": None,
    },
    "MS": {
        "example": None,
        "pattern": None,
    },
    "MT": {
        "example": "NXR 01",
        "pattern": r"^(?:[A-Z]{3} ?\d{2,4})$",
    },
    "MU": {
        "example": "42602",
        "pattern": r"^(?:\d{3}(?:\d{2}|[A-Z]{2}\d{3}))$",
    },
    "MV": {
        "example": "20026",
        "pattern": r"^(?:\d{5})$",
    },
    "MW": {
        "example": None,
        "pattern": None,
    },
    "MX": {
        "example": "02860",
        "pattern": r"^(?:\d{5})$",
    },
    "MY": {
        "example": "43000",
        "pattern": r"^(?:\d{5})$",
    },
    "MZ": {
        "example": "1102",
        "pattern": r"^(?:\d{4})$",
    },
    "NA": {
        "example": "10001",
        "pattern": r"^(?:\d{5})$",
    },
    "NC": {
        "example": "98814",
        "pattern": r"^(?:988\d{2})$",
    },
    "NE": {
        "example": "8001",
        "pattern": r"^(?:\d{4})$",
    },
    "NF": {
        "example": "2899",
        "pattern": r"^(?:2899)$",
    },
    "NG": {
        "example": "930283",
        "pattern": r"^(?:\d{6})$",
    },
    "NI": {
        "example": "52000",
        "pattern": r"^(?:\d{5})$",
    },
    "NL": {
        "example": "1234 AB",
        "pattern": r"^(?:\d{4} ?[A-Z]{2})$",
    },
    "NO": {
        "example": "0025",
        "pattern": r"^(?:\d{4})$",
    },
    "NP": {
        "example": "44601",
        "pattern": r"^(?:\d{5})$",
    },
    "NR": {
        "example": None,
        "pattern": None,
    },
    "NU": {
        "example": None,
        "pattern": None,
    },
    "NZ": {
        "example": "6001",
        "pattern": r"^(?:\d{4})$",
    },
    "OM": {
        "example": "133",
        "pattern": r"^(?:(?:PC )?\d{3})$",
    },
    "PA": {
        "example": None,
        "pattern": None,
    },
    "PE": {
        "example": "LIMA 23",
        "pattern": r"^(?:(?:LIMA \d{1,2}|CALLAO 0?\d)|[0-2]\d{4})$",
    },
    "PF": {
        "example": "98709",
        "pattern": r"^(?:987\d{2})$",
    },
    "PG": {
        "example": "111",
        "pattern": r"^(?:\d{3})$",
    },
    "PH": {
        "example": "1008",
        "pattern": r"^(?:\d{4})$",
    },
    "PK": {
        "example": "44000",
        "pattern": r"^(?:\d{5})$",
    },
    "PL": {
        "example": "00-950",
        "pattern": r"^(?:\d{2}-\d{3})$",
    },
    "PM": {
        "example": "97500",
        "pattern": r"^(?:9[78]5\d{2})$",
    },
    "PN": {
        "example": "PCRN 1ZZ",
        "pattern": r"^(?:PCRN 1ZZ)$",
    },
    "PR": {
        "example": "00930",
        "pattern": r"^(?:(00[679]\d{2})(?:[ \-](\d{4}))?)$",
    },
    "PS": {
        "example": None,
        "pattern": None,
    },
    "PT": {
        "example": "2725-079",
        "pattern": r"^(?:\d{4}-\d{3})$",
    },
    "PW": {
        "example": "96940",
        "pattern": r"^(?:(969(?:39|40))(?:[ \-](\d{4}))?)$",
    },
    "PY": {
        "example": "1536",
        "pattern": r"^(?:\d{4})$",
    },
    "QA": {
        "example": None,
        "pattern": None,
    },
    "RE": {
        "example": "97400",
        "pattern": r"^(?:9[78]4\d{2})$",
    },
    "RO": {
        "example": "060274",
        "pattern": r"^(?:\d{6})$",
    },
    "RS": {
        "example": "106314",
        "pattern": r"^(?:\d{5,6})$",
    },
    "RU": {
        "example": "247112",
        "pattern": r"^(?:\d{6})$",
    },
    "RW": {
        "example": None,
        "pattern": None,
    },
    "SA": {
        "example": "11564",
        "pattern": r"^(?:\d{5})$",
    },
    "SB": {
        "example": None,
        "pattern": None,
    },
    "SC": {
        "example": None,
        "pattern": None,
    },
    "SD": {
        "example": "11042",
        "pattern": r"^(?:\d{5})$",
    },
    "SE": {
        "example": "11455",
        "pattern": r"^(?:\d{3} ?\d{2})$",
    },
    "SG": {
        "example": "546080",
        "pattern": r"^(?:\d{6})$",
    },
    "SH": {
        "example": "STHL 1ZZ",
        "pattern": r"^(?:(?:ASCN|STHL) 1ZZ)$",
    },
    "SI": {
        "example": "4000",
        "pattern": r"^(?:\d{4})$",
    },
    "SJ": {
        "example": "9170",
        "pattern": r"^(?:\d{4})$",
    },
    "SK": {
        "example": "010 01",
        "pattern": r"^(?:\d{3} ?\d{2})$",
    },
    "SL": {
        "example": None,
        "pattern": None,
    },
    "SM": {
        "example": "47890",
        "pattern": r"^(?:4789\d)$",
    },
    "SN": {
        "example": "12500",
        "pattern": r"^(?:\d{5})$",
    },
    "SO": {
        "example": "JH 09010",
        "pattern": r"^(?:[A-Z]{2} ?\d{5})$",
    },
    "SR": {
        "example": None,
        "pattern": None,
    },
    "SS": {
        "example": None,
        "pattern": None,
    },
    "ST": {
        "example": None,
        "pattern": None,
    },
    "SV": {
        "example": "CP 1101",
        "pattern": r"^(?:CP [1-3][1-7][0-2]\d)$",
    },
    "SX": {
        "example": None,
        "pattern": None,
    },
    "SY": {
        "example": None,
        "pattern": None,
    },
    "SZ": {
        "example": "H100",
        "pattern": r"^(?:[HLMS]\d{3})$",
    },
    "TA": {
        "example": "TDCU 1ZZ",
        "pattern": r"^(?:TDCU 1ZZ)$",
    },
    "TC": {
        "example": "TKCA 1ZZ",
        "pattern": r"^(?:TKCA 1ZZ)$",
    },
    "TD": {
        "example": None,
        "pattern": None,
    },
    "TF": {
        "example": None,
        "pattern": None,
    },
    "TG": {
        "example": None,
        "pattern": None,
    },
    "TH": {
        "example": "10150",
        "pattern": r"^(?:\d{5})$",
    },
    "TJ": {
        "example": "735450",
        "pattern": r"^(?:\d{6})$",
    },
    "TK": {
        "example": None,
        "pattern": None,
    },
    "TL": {
        "example": None,
        "pattern": None,
    },
    "TM": {
        "example": "744000",
        "pattern": r"^(?:\d{6})$",
    },
    "TN": {
        "example": "1002",
        "pattern": r"^(?:\d{4})$",
    },
    "TO": {
        "example": None,
        "pattern": None,
    },
    "TR": {
        "example": "01960",
        "pattern": r"^(?:\d{5})$",
    },
    "TT": {
        "example": None,
        "pattern": None,
    },
    "TV": {
        "example": None,
        "pattern": None,
    },
    "TW": {
        "example": "104",
        "pattern": r"^(?:\d{3}(?:\d{2,3})?)$",
    },
    "TZ": {
        "example": "6090",
        "pattern": r"^(?:\d{4,5})$",
    },
    "UA": {
        "example": "15432",
        "pattern": r"^(?:\d{5})$",
    },
    "UG": {
        "example": None,
        "pattern": None,
    },
    "UM": {
        "example": "96898",
        "pattern": r"^(?:96898)$",
    },
    "US": {
        "example": "95014",
        "pattern": r"^(?:(\d{5})(?:[ \-](\d{4}))?)$",
    },
    "UY": {
        "example": "11600",
        "pattern": r"^(?:\d{5})$",
    },
    "UZ": {
        "example": "702100",
        "pattern": r"^(?:\d{6})$",
    },
    "VA": {
        "example": "00120",
        "pattern": r"^(?:00120)$",
    },
    "VC": {
        "example": "VC0100",
        "pattern": r"^(?:VC\d{4})$",
    },
    "VE": {
        "example": "1010",
        "pattern": r"^(?:\d{4})$",
    },
    "VG": {
        "example": "VG1110",
        "pattern": r"^(?:VG\d{4})$",
    },
    "VI": {
        "example": "00802-1222",
        "pattern": r"^(?:(008(?:(?:[0-4]\d)|(?:5[01])))(?:[ \-](\d{4}))?)$",
    },
    "VN": {
        "example": "70010",
        "pattern": r"^(?:\d{5}\d?)$",
    },
    "VU": {
        "example": None,
        "pattern": None,
    },
    "WF": {
        "example": "98600",
        "pattern": r"^(?:986\d{2})$",
    },
    "WS": {
        "example": None,
        "pattern": None,
    },
    "XK": {
        "example": "10000",
        "pattern": r"^(?:[1-7]\d{4})$",
    },
    "YE": {
        "example": None,
        "pattern": None,
    },
    "YT": {
        "example": "97600",
        "pattern": r"^(?:976\d{2})$",
    },
    "ZA": {
        "example": "0083",
        "pattern": r"^(?:\d{4})$",
    },
    "ZM": {
        "example": "50100",
        "pattern": r"^(?:\d{5})$",
    },
    "ZW": {
        "example": None,
        "pattern": None,
    },
}
