# # -*- coding: utf-8 -*-
# """Flow_Intelligent_Agent_PraisonAI.ipynb

# Automatically generated by Colab.

# Original file is located at
#     https://colab.research.google.com/drive/1gm6zP1CbGU2d24iAaHhzVxTzWGs2oV43

# # Flow – Intelligent Agent for Daily Efficiency

# # Description

# This agent uses a custom DuckDuckGo search tool to intelligently retrieve and summarize real-time information based on user queries.

# [![Open in Colab](https://colab.research.google.com/assets/colab-badge.svg)](https://colab.research.google.com/github/DhivyaBharathy-web/PraisonAI/blob/main/examples/cookbooks/Flow_Intelligent_Agent_PraisonAI.ipynb)

# ## Tools
# - `praisonaiagents` – Intelligent Agent framework
# - `duckduckgo-search` – Custom search tool
# - `pyyaml` – YAML config
# - `openai` – LLM backend

# # Dependencies
# """

# pip install praisonaiagents duckduckgo-search pyyaml openai

# """# Set your OpenAI API Key securely"""

import os
os.environ['OPENAI_API_KEY'] = 'your api key'  # Replace with your actual OpenAI key

# """## YAML Prompt
# Define multiple agents and their roles.
# """

import yaml

yaml_prompt = '''
agents:
  - name: FlowAgent
    description: Intelligent daily workflow assistant
  - name: ChileAtiendeAI
    description: Government support assistant for Chile
  - name: ClinicalTrialMatcher
    description: Match patients to trials using input medical info
  - name: ChillWorkEmailAgent
    description: Automate email replies and scheduling
'''

config = yaml.safe_load(yaml_prompt)

# """## Main
# Initialize agent with a custom DuckDuckGo tool and simulate a task.
# """

from praisonaiagents import Agent
from duckduckgo_search import DDGS

def internet_search_tool(query: str):
    ddgs = DDGS()
    results = []
    for res in ddgs.text(keywords=query, max_results=3):
        results.append(f"{res['title']} - {res['href']}")
    return "\n".join(results)

# Initialize the main agent (FlowAgent)
flow_config = config['agents'][0]
flow_agent = Agent(
    name=flow_config['name'],
    instructions=flow_config['description'],
    tools=[internet_search_tool]
)

response = flow_agent.start("What's the latest open-source AI agent framework?")
print(response)