# # -*- coding: utf-8 -*-
# """github_repo_analyzer_agent.ipynb

# Automatically generated by Colab.

# Original file is located at
#     https://colab.research.google.com/github/DhivyaBharathy-web/PraisonAI/blob/main/examples/cookbooks/github_repo_analyzer_agent.ipynb

# # 🤖 GitHub Repo Analyzer Agent
# AI agent powered by PraisonAI and OpenAI to analyze GitHub repositories using GitHub API.

# [![Open in Colab](https://colab.research.google.com/assets/colab-badge.svg)](https://colab.research.google.com/github/DhivyaBharathy-web/PraisonAI/blob/main/examples/cookbooks/github_repo_analyzer_agent.ipynb)

# # 📦 Install dependencies
# """

# !pip install praisonaiagents openai requests

# """# Tools Used

# 🧠 praisonaiagents – Smart AI agent

# 🔗 openai – GPT-powered responses

# 📂 requests – GitHub repo analysis

# 🖥️ Python I/O – Interactive CLI in notebook

# # 🔐 Set OpenAI API Key
# """

import os
if not os.getenv("OPENAI_API_KEY"):
    os.environ["OPENAI_API_KEY"] = input("🔐 Enter your OpenAI API key: ")

# """# 🧠 Imports"""

import requests
import openai
from praisonaiagents import Agent

openai.api_key = os.environ["OPENAI_API_KEY"]

# """# 🤖 Create the Agent"""

agent = Agent(instructions="""
You are a GitHub codebase explainer. When given a repo URL, fetch summary of
its files and provide insightful analysis. Be helpful and concise.
""")

# """# 📂 Fetch GitHub repo file names"""

def fetch_repo_files(repo_url):
    api_url = repo_url.replace("https://github.com", "https://api.github.com/repos") + "/contents"
    r = requests.get(api_url)
    return [f["name"] for f in r.json()] if r.status_code == 200 else []

# """# 💬 Ask Agent"""

def ask_agent(repo_url):
    files = fetch_repo_files(repo_url)
    if not files:
        return "❌ Cannot fetch repo contents."
    return agent.start(f"Repo contains files: {files}. Analyze key components and structure.")

# """# 🧪 Run the agent"""

repo = input("🔗 Enter GitHub repository URL: ")
print("\n🧠 Agent Insight:\n", ask_agent(repo))