import gradio as gr
from praisonaiagents import Agent, Tools
from praisonaiagents.tools import duckduckgo

def research(query):
    agent = Agent(instructions="You are a Research Agent", tools=[duckduckgo])
    result = agent.start(query)
    # Format the result with enhanced markdown
    formatted_result = f"""
{result}
----
*Generated by PraisonAI Research Assistant*
    """
    return formatted_result

# Create a simple Gradio interface
demo = gr.Interface(
    fn=research,
    inputs=gr.Textbox(
        label="Research Query",
        placeholder="Enter your research topic...",
        lines=2
    ),
    outputs=gr.Markdown(
        show_copy_button=True,
        height=500,
        container=True
    ),
    title="AI Research Assistant",
    description="Enter your research query below to get started!",
)

if __name__ == "__main__":
    demo.launch()