# Creator Suite Examples

Examples for the PraisonAI Creator Automation Suite - a complete toolkit for AI content creators.

## Quick Start

```bash
# Set your API key
export OPENAI_API_KEY=your_key_here

# Run an example
python news_crawler_example.py
python script_writer_example.py
python hook_generator_example.py
python brief_generator_example.py
```

## Examples

| Example | Description | API Key Required |
|---------|-------------|------------------|
| `news_crawler_example.py` | Crawl AI news from multiple sources | No (HN, arXiv) |
| `script_writer_example.py` | Generate scripts for YouTube, X, LinkedIn | Yes (OpenAI) |
| `hook_generator_example.py` | Generate attention-grabbing hooks | Yes (OpenAI) |
| `brief_generator_example.py` | Generate news briefs | Yes (OpenAI) |

## Environment Variables

Copy `.env.example` to `.env` and fill in your API keys:

```bash
cp .env.example .env
```

## Features Covered

### News Intelligence Layer
- AI News Crawler
- AI News Deduper
- AI Signal Ranker
- AI Context Enricher
- AI Brief Generator

### Script & Story Layer
- AI Script Writer
- AI Angle Generator
- AI Hook Generator
- AI CTA Generator
- AI Fact Checker

### Capture & Screen Automation
- AI Screenshot Capture
- AI Screen Recorder
- AI News Capture Pack

### Video Generation
- AI B-roll Builder
- AI Voiceover Generator
- AI Video Merger

### Publishing & Distribution
- AI Publisher Pack
- AI Content Calendar
- AI Post Copy Generator
- AI Hashtag Optimizer

### Feedback & Learning
- AI Performance Analyzer
- AI Comment Miner
- AI A/B Hook Tester

### Orchestrator
- AI Daily News Show (end-to-end pipeline)

## Documentation

Full documentation: https://docs.praison.ai/docs/ai-tools/creator-suite/
