# Description

<!--
Thank you for contributing to Nuitka!
Before submitting a PR, please review the guidelines:
https://github.com/Nuitka/Nuitka/blob/develop/CONTRIBUTING.md
-->

## ❓ What does this PR do?

<!-- A clear and concise description of the changes. -->

## 🧐 Why was it initiated? Any relevant Issues?

<!-- Link to the issue or explain the motivation. -->

## 🧱 Type of Change

- [ ] 🐛 Bug fix (non-breaking change which fixes an issue)
- [ ] ✨ New feature (non-breaking change which adds functionality)
- [ ] 💥 Breaking change (fix or feature that would cause existing functionality to not work as
  expected)
- [ ] 🧹 Refactoring (no functional changes, no api changes)
- [ ] 🏗️ Build / CI System
- [ ] 📚 Documentation Update

## ✅ PR Checklist

- [ ] **Correct base branch selected**: Should be `develop` branch.
- [ ] **Formatting**: Enabled commit hook or executed `./bin/autoformat-nuitka-source`.
- [ ] **Tests**: All tests still pass. (See
  [Running the Tests](https://nuitka.net/doc/developer-manual.html#running-the-tests)).
  - CI actions cover the basics, but manual verification is encouraged.
- [ ] **New Coverage**: New features or fixed regressions are covered via new tests.
- [ ] **Documentation**: Documentation updates are included for new or changed features.

## 🤖 AI Generated Code Policy

- [ ] **Detection**: This PR contains AI generated code.
  - [ ] **Issue First**: I have created an issue explaining the problem *before* using AI to
    generate a fix, ensuring the direction is correct.
  - [ ] **Documentation**: I have provided the prompts used to generate the code (non-optional).
  - [ ] **Verification**: I have **manually verified** the AI generated code.
    > **Note**: AI generated code is welcome, but it must be peer-reviewed and understood by the
    > submitter. Blindly copying AI output without understanding is not acceptable.
  - [ ] **Evidence**: I have included test evidence that the change is effective.

______________________________________________________________________

<!--
Note: The Nuitka team will review your PR. If you are unsure about something, ask in the comments!
-->
