#     Copyright 2025, Kay Hayen, mailto:kay.hayen@gmail.com find license text at end of file


import numpy as np


def mandelbrot(z, maxiter):
    c = z
    for n in range(maxiter):
        if abs(z) > 2:
            return n
        z = z * z + c
    return maxiter


def mandelbrot_set(xmin, xmax, ymin, ymax, width, height, maxiter):
    r1 = np.linspace(xmin, xmax, width)
    r2 = np.linspace(ymin, ymax, height)
    return [mandelbrot(complex(r, i), maxiter) for r in r1 for i in r2]


if __name__ == "__main__":
    mandelbrot_set(-2.0, 0.5, -1.25, 1.25, 1000, 1000, 80)
    # harder_stmt = 'mandelbrot_set(-0.74877,-0.74872,0.06505,0.06510,1000,1000,2048)'

#     Python test originally created or extracted from other peoples work. The
#     parts from me are licensed as below. It is at least Free Software where
#     it's copied from other people. In these cases, that will normally be
#     indicated.
#
#     Licensed under the Apache License, Version 2.0 (the "License");
#     you may not use this file except in compliance with the License.
#     You may obtain a copy of the License at
#
#         http://www.apache.org/licenses/LICENSE-2.0
#
#     Unless required by applicable law or agreed to in writing, software
#     distributed under the License is distributed on an "AS IS" BASIS,
#     WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#     See the License for the specific language governing permissions and
#     limitations under the License.
