import { ComponentProps } from "react";


export const GamestonkIcon = (props: ComponentProps<"svg">) => (
    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 628 628" {...props}>
        <path fill="none" d="M1 218V1.022h627.916v627.832H1V218m456.713 344.97c.464-.644.927-1.288 2.279-1.967l27.073-3.742-1.806 1.228c1.31.496 2.595 1.138 3.95 1.394.386.072 1.065-.928 1.452-1.537.22-.348.024-1.26.183-1.303 2.764-.751 5.526-1.573 8.344-2.054 9.788-1.67 19.597-3.216 29.616-4.845l-1.455 1.616c.84.409 1.713 1.199 2.51 1.128.974-.087 1.885-.896 2.823-1.392-2.059-2.477 1.215-2.875 1.797-3.148 3.594-1.69 7.361-3.058 11.167-4.217 1.081-.33 2.506.656 3.73.549.895-.079 2.527-1.215 2.455-1.445-1.681-5.318 2.54-2.33 4.24-2.877-.359-.866-.658-1.591-.267-2.357.746-.963 1.492-1.925 2.962-2.997l9.852-8.711c.232.583.054.169-.098-.255-.191-.538-.361-1.083-.54-1.624l1.494.26c4.833-10.25 9.954-20.41 8.343-33.355l4.113 1.977V152.569c-3.067 2.329-3.808.875-3.966-2.187-.219-4.237-.152-8.604-1.224-12.646-.972-3.668-4.79-7.009-4.714-10.435.138-6.225-8.324-7.123-7.14-13.687.24-1.327-3.15-3.309-5.163-5.28l-.575 2.627c-2.717-2.082-5.346-3.646-7.387-5.774-2.64-2.752-4.81-5.956-7.565-9.41l-1.006-.393c.243.564.486 1.128.535 2.394-1.577-1.74-3.764-3.235-4.583-5.279-1.12-2.798-1.976-3.066-4.102-.655-2.186-2.917-4.324-5.77-6.844-9.067l-1.006-.393c.243.564.486 1.128.557 2.376-.896-.47-2.099-.717-2.633-1.451-1.647-2.261-3.04-4.708-4.931-7.548l-1.73-.826-.371.544c.612.532 1.225 1.065 1.657 2.286l-6.51-3.998.936-1.038c-2.95-2.027-5.641-3.878-8.378-6.464l-1.304-3.508c-.634 1.044-1.059 1.743-2.15 2.115-3.588-4.29-7.992-7.64-12.565-11.624-1.007-1.316-.849-4.091-4.415-3.358-.813-.505-1.733-.893-2.42-1.532-3.754-3.495-7.408-7.098-11.195-10.557-1.002-.914-3.265-1.326-3.378-2.177-.449-3.37-1.498-4.165-4.878-2.924-3.597 1.32-6.625-.95-7.046-3.736h-31.4c.909 1.505.792 3.508-2.437 2.926-3.597-.649-7.87 3.456-10.927-1.494-.17-.277-1.936.406-2.943.698-.141.041-.187.409-.28.632.774.213 1.493.41 2.21.609l.104 1.42-15.236 2.528-.188-.74 2.979-1.374h-5.406c-1.023 1.838-1.941 3.735-2.071 3.683-3.511-1.419-7.74 3.2-10.934-1.245-.22-.305-2.663.241-2.814.758-.858 2.947-3.292 3.264-5.577 3.599-9.785 1.43-19.61 2.598-29.377 4.14-3.518.556-6.87 2.105-10.375 2.81-2.994.602-7.886 1.945-8.807.68-2.365-3.247-4.366-1.034-5.793-.833-.306 1.402-1.084 3.168-1.642 3.1-6.803-.815-13.519 3.546-20.394.233-1.331-.642-3.237-.093-4.72-.093l.608 3.676c-.71.134-1.26.423-1.663.284-3.483-1.193-7.715 2.86-10.879-1.584-.294-.414-2.68.661-4.489 1.151l2.562.854.173 1.286-15.239 2.662 2.432-2.225h-3.925c-1.834 1.774-2.793 3.505-4.052 3.761-3.128.636-6.393.6-9.604.848l1.212-1.389h-6.952l.015.417 3.594.562c-1.95.874-3.93 1.934-6.023 2.668-7.72 2.709-16.651-1.808-23.919 3.97-.511.406-1.626.09-2.457.052-4.453-.202-8.905-.422-11.303-.537-1.894 1.765-2.75 3.267-3.815 3.433-4.196.657-8.457.894-13.227 1.176-.095.306-.189.612-.694 1.686-4.334.084-8.667.168-13.036-.364l-2.187-.278-.091.535c.525.116 1.05.231 1.306 1.106-1.432.747-2.8 1.934-4.31 2.156-4.01.588-8.121.504-12.117 1.153-6.843 1.111-13.63 2.578-21.161 3.932-4.378 1.273-8.769 2.503-13.128 3.837-2.491.762-4.46 4.3-7.732 1.386-.123-.11-4.497-.168-2.6 3.236.016.03-.442.325-.876.638l-1.963-2.301-1.432 5.284-1.049-1.234c-2.26 1.447-5.597 2.4-6.537 4.453-1.54 3.365-2.887 4.689-6.464 2.54.954 6.808-5.754 4.6-8.09 7.456.56.623 1.609 1.756 1.59 1.774-4.28 4.098-8.635 8.118-12.974 12.128l2.571.84-6.135 2.543 2.609 1.724-3.35 1.209-.663 6.215-.95-1.28c-.945.369-2.529.548-2.707 1.146-.407 1.362-.124 2.93-.283 4.884 0 0-.116.484-.9.527-.69.748-1.378 1.496-2.066 2.245 3.49 2.811-.349 5.454-.396 8.192-.055 3.167-1.718 6.305-3.458 9.587a283.718 283.718 0 0 0-1.17 4.71c-.04.744-.08 1.487-.819 2.586-.01 1.561-.019 3.123-.18 5.434-.579 1.78-1.157 3.559-1.676 5.39 0 0-.057-.004-.317 1.18.048.805.095 1.61-.011 3.102.01 104.36.017 208.721.068 313.082.001 1.844.544 3.687 1.119 6.234.323 1.42.646 2.84.813 5.042.5 2.467 1 4.934 1.973 8.009 1.851 3.428 4.3 6.677 5.395 10.332 1.218 4.066.681 4.226 4.841 5.643 3.58 3.042 7.159 6.084 10.196 9.303.195.256.39.512 1.016.923 0 0 .455.05.623.574.305.05.609.1 1.666.27 1.842 1.387 3.864 2.593 5.48 4.207 2.153 2.149 3.99 4.614 5.828 7.412.648.068 1.297.136 2.622.52.746.024 1.493.048 2.522.739l4.626 7.587 1.065-.553-.238-2.633.895-.299 5.65 9.325.705-.425-.351-4.093c2.519 3.913 4.205 6.531 6.291 9.615l1.729.827.372-.543c-.613-.532-1.225-1.064-1.66-2.284 4.16.279 5.163 3.016 5.115 6.524 8.552.59 13.121 6.54 17.484 12.868v-2.862c4.444 3.546 4.802 11.088 12.228 10.234.466-.053 1.213-.052 1.403.22 4.526 6.48 12.398 6.317 18.674 9.254 2.513 1.175 5.783.71 8.702 1.046 3.506.404 7.067 1.492 10.492 1.152 4.716-.468 9.327-1.996 14.775-3.254-.88 1.557-1.426 2.39-1.367 2.434 2.556 1.957 3.172-.587 4.913-1.53 3.793-2.051 8.532-2.412 12.92-3.283 1.99-.394 4.063-.476 6.1-.491 5.065-.039 10.13.061 15.195.022.276-.003.545-.773.951-1.39l-7.411-.367c3.522.22 7.32-3.376 10.69.6.348.41 3.09-.227 3.474-1 1.619-3.246 1.466-3.177 3.418-3.441 7.533-1.019 15.062-2.078 22.573-3.25 7.819-1.22 15.614-2.588 24.058-3.739.49-.313.981-.626 2.194-.98 2.212.933 4.324 1.13 6.641.006 1.943-.944 4.116-1.47 6.234-1.985 4.36-1.06 8.808-2.923 13.114-2.67 3.305.194 6.776-3.112 10.3.7 1.9 2.055 1.616-.44 1.171-1.708 2.396-.782 4.749-2.04 7.194-2.257 6.915-.611 13.867-.797 19.65-1.091 2.785-1.244 4.7-2.26 6.728-2.948 1.36-.461 2.886-.403 4.321-.669 6.441-1.19 12.876-2.413 20.023-3.757l-1.822 2.03c1.186.443 2.348 1.101 3.568 1.235.58.064 1.617-.75 1.842-1.38.743-2.084 1.647-3.306 3.14-3.505 7.711-1.03 15.425-2.036 23.131-3.099.38-.052.695-.563 1.865-.902 2.035-.296 4.07-.592 6.907-.985l7.373 2.716c-1.01-4.493 1.035-5.006 4.524-4.746.752-.053 1.505-.107 3.078-.015 2.73-.385 5.46-.77 8.893-1.005M49 304.5V179.886l-.715.004v316.435H49V304.5M445.23 26H433l.085 1.602h17.423l.11-1.024c-1.487-.193-2.975-.385-5.386-.578M154.533 603.063l-.23.646c.23-.071.457-.142.23-.646z"/>
        <path fill="#FEFEFF" d="M489.832 54.001c4.509 3.23 8.913 6.58 12.891 11.35 1.297.87 2.203 1.26 3.109 1.65l8.333 5.728-.935 1.038c2.097 1.288 4.303 2.643 6.775 3.448.37-.696.474-.843.578-.99 1.491 2.376 2.884 4.823 4.53 7.084.535.734 1.738.98 2.895.903.363-.695.467-.843.57-.99l6.462 8.622c2.126-2.411 2.982-2.143 4.102.655.819 2.044 3.006 3.54 4.854 4.722.376-.704.479-.852.582-.999 2.373 3.01 4.543 6.213 7.183 8.965 2.04 2.128 4.67 3.692 7.387 5.774l.575-2.626c2.013 1.97 5.403 3.952 5.164 5.279-1.185 6.564 7.277 7.462 7.139 13.687-.077 3.426 3.742 6.767 4.714 10.435 1.072 4.042 1.005 8.41 1.224 12.646.158 3.062.899 4.516 3.966 2.187v340.727l-4.113-1.977c1.611 12.945-3.51 23.105-8.343 33.355l-1.494-.26c.179.541.349 1.086.54 1.624.152.424.33.838.098.255-3.538 3.128-6.695 5.92-10.23 8.384-1.179-2.108-2.024-3.871-2.771-5.675-1.239-2.987-2.415-6-3.45-9.247.722-.416 1.278-.585 1.974-.434.994 2.03 1.847 3.739 2.7 5.448l1.411.11c.533-1.972 1.12-3.932 1.58-5.921.267-1.158-.096-2.732.556-3.486 4.193-4.844 1.534-10.282 1.612-15.909 0-2.478 0-4.52.35-6.617 1.133-.876 2.426-1.596 2.616-2.537 1.51-7.496 6.462-7.11 12.062-5.55.39.108.91-.254 1.964-.583 0-1.998.386-4.217-.147-6.188-.31-1.147-2.19-2.79-3.2-2.682-7.905.84-11.56-2.066-11.612-10.154-.108-16.812-.124-33.626.003-50.437.072-9.53 3.373-12.023 12.614-10.11.577.12 1.228-.113 1.82-.179v-10.26c-9.406 1.51-13.472.132-13.336-4.582.073-2.552.607-6.648 2.105-7.283 3.331-1.411 7.4-1.082 11.243-1.47v-9.651c-9.519 1.479-13.956-.277-14.434-5.66-.548-6.166-.79-12.87 3.166-17.607 1.89-2.264 7.336-1.56 11.454-2.248v-8.829c-2.148.394-3.89 1.06-5.572.932-1.99-.153-4.942-.394-5.686-1.655-1.713-2.9-3.103-6.405-3.262-9.73-.43-8.968-.274-17.973-.112-26.959.17-9.358 3.43-11.814 12.488-9.857.592.127 1.247-.036 2.007-.07v-10.59c-1.464.342-2.392.605-3.337.773-7.38 1.313-11.1-1.753-11.193-9.207-.014-1.165.098-2.344-.04-3.494-.76-6.365-6.172-10.305-12.1-8.673-.6.165-1.096 1.675-1.134 2.583-.03.697 1.15 1.478 1.072 2.135-.236 1.96-.217 4.518-1.42 5.666-1.88 1.795-3.894.99-4.76-1.855-.146-.48-1.747-.874-2.57-.725-2.744.494-9.828 8.974-10.393 11.82-1.114 1.012-1.89 1.987-3.061 2.971-5.228.614-10.058 1.219-14.61 1.788.703 1.697 1.861 4.496 2.786 7.408-.68.37-1.126.628-1.958.856-.997-.217-1.835-.213-2.183-.624-3.734-4.41-4.081-4.297-6.607.482-.73 1.382-2.587 2.49-4.165 3.034-3.103 1.069-5.995 2.024-6.182 6.11-1.078.336-1.832.645-3.014.942-7.692-.963-14.948-1.985-22.23-2.764-.77-.082-1.69 1.26-2.946 1.929-1.752-.012-3.101-.011-4.468-.405-1.086-1.151-2.153-1.908-3.513-2.646-.68.036-1.07.056-1.643-.231-.607-1.256-1.028-2.205-1.45-3.155 6.162-1.436 2.21-4.937 1.92-7.9 3.24-1.121 6.971-1.175 6.645-6.157-1.329-3.487-2.837-6.591.389-9.69 1.101-.007 1.836-.008 2.963 0 2.152-.99 3.912-1.992 5.987-3.021 1.089-.363 1.86-.699 2.86-.747 2.573 1.083 4.874 2.343 7.272 2.568 3.824.358 5.547-2.939 5.886-9.764.777-.012 1.222-.014 1.941.274 5.255.629 10.363 1.825 15.184 1.102 6.784-1.016 10.518-13.815 6.15-19.293-2.368-2.97-2.973-6.943-.018-8.81 4.72-2.98 5.76-7.6 7.76-11.943.475-1.03 1.037-2.312 1.93-2.804 3.572-1.968 3.144-4.621 1.692-7.963.02-1.103.035-1.84.41-2.644 1.707-3.11 3.057-6.152 4.45-9.287-2.885-2.935-4.548-1.543-6.306 1.38-4.815.323-9.17.646-13.527.56.667-3.133 1.334-5.858 2.4-8.588 2.614-.145 5.32.558 5.558-3.012.015-.01.04-.035.346-.036.438-.99.57-1.978.659-3.32-2.508-4.288-4.336-2.796-5.98.582-.008.239-.002.716-.323.79-.758.035-1.193-.004-1.63-.29-.001-.246-.022-.739-.056-1.06-1.019-.755-2.004-1.187-3.36-1.623-1.115-.003-1.858-.002-2.813-.268-1.075.57-1.937 1.406-3.184 2.253-2.126.342-3.868.673-5.761.702-3.618-2.143-5.769-.031-8.257 2.274-1.467.01-2.533.012-3.641-.292-3.462-1.445-3.092 1.578-4.326 3.268-1.128.023-1.88.03-2.703-.333-1.89-.35-3.741-.534-5.515-.243-1.324.218-2.576 1.58-3.81 1.512-4.532-.249-6.353 2.508-7.904 6.25-1.094.375-1.893.63-2.92.606-3.614-1.5-4.797.106-5.119 3.294-1.435.345-2.53.656-4.037.961-5.71 1.205-11.715.985-14.96 7.015-.768.001-1.207.003-1.93-.295-3.706-.242-7.269-.695-10.462.187-.943.26-.845 4.292-1.22 6.596-.028.163-.035.33-.36.63-1.757.713-3.205 1.292-4.98 1.905-.787.673-1.248 1.314-1.903 2.198-1.872.999-3.562 1.729-5.225 2.514-1.537.725-3.045 1.508-4.744 2.02-1.4.582-2.622 1.409-4.09 2.244-.246.008-.737.021-.736-.365.632-2.177 1.262-3.968 2.248-6.77-6.93 1.51-13.935-1.08-18.268 3.944.413 3.111.677 5.101.565 7.118-3.204 1.01-5.67 1.188-7.865-1.614-1.803-2.303-4.192-1.278-4.226 1.143-.128 9.053-7.84 7.405-12.81 9.422-3.758 1.524-7.786 2.4-11.726 3.445-1.408.373-2.908.543-4.368.556-6.744.059-13.499.258-20.227-.068-3.116-.152-6.475-.824-9.204-2.253-5.911-3.096-13.07-3.638-16.96-.175-5.235 4.661-11.221 6.414-18.16 5.156-1.126-2.449-1.96-4.698-3.31-6.575-.715-.995-2.32-1.865-3.537-1.883-3.124-.047-4.817-1.122-6.57-3.978-1.242-2.024-4.796-2.793-7.47-3.656-.643-.208-2.02 1.316-2.82 2.249-1.292 1.51-2.385 3.19-3.86 4.822-.683-.074-1.068-.17-1.516-.683-.67-.881-1.273-1.742-1.883-1.747-9.4-.09-18.803-.19-28.196.064-1.31.035-2.57 1.926-4.146 3.08-.715.16-1.137.195-1.753-.113-.467-.523-.75-.87-1.012-.853-3.302.2-7.263 2.627-8.882-2.836-.083-.28-3.16-.365-3.509.234-3.41 5.868-9.509 1.902-14.124 3.92-4.123 1.8-9.425.903-14.736 1.229.509 2.747 1.022 4.331 1.05 5.924.05 2.83-.22 5.666-.307 8.501-.144 4.682-.676 9.417-.125 14.02.179 1.495 3.262 2.61 4.957 3.974.616.495 1.139 1.154 1.568 1.826 2.917 4.562 5.697 9.218 8.783 13.662.567.816 2.328.804 3.744 1.172.205-.001.62-.013.673.339.903 1.642 2.748 3.27 2.443 4.167-1.882 5.535.357 8.653 5.34 10.828.034.246-.004.743-.353.83-1.756 3.491.829 8.13 4.383 7.741 4.44-.484 8.78-1.872 13.496-2.866.774.018 1.217.03 1.7.406 2.496 2.978 14.133.983 16.409-2.38 3.15-.027 5.851-.043 8.547.325-.322 2.822-.638 5.262-.98 8.116-.023.69-.017.965-.239 1.29-.54.078-.848.048-1.569-.243-1.34-.273-2.26-.344-3.38-.682-1.063.255-1.928.776-2.959 1.597-1.398.75-2.63 1.2-4.102 1.368-3.35-.696-6.568-2.752-9.388.579-2.133 2.52-4.433 4.9-7.328 8.077 2.018 3.114 4.52 6.973 7.02 10.833l1.503-.41c.145-2.35-.07-4.806.564-7.017.404-1.404 2.07-2.446 3.169-3.651.894 1.15 2.436 2.23 2.571 3.463.64 5.845.232 11.37-6.532 13.896-.664.248-.91 1.615-1.352 2.718 0 .427.001.597-.307.871-.74.091-1.173.079-1.8-.225-1.094-.5-1.99-.706-2.927-1.21-.449-.609-.858-.922-1.266-1.235-.232.517-.464 1.033-1.09 1.558-1.452.011-2.507.015-3.913.042-1.465.991-2.579 1.958-4.153 2.934-4.153.004-7.845-.001-11.574-.346-1.027-1.096-2.017-1.854-3.334-2.611-.761-.008-1.196-.015-1.692-.385-1.593-1.084-3.085-2.279-4.667-2.411-2.068-.174-4.206.492-6.528.691-.483-.3-.666-.556-.797-1.239-1.997-1.886-3.961-3.406-5.463-4.569l2.138-5.228c-2.051-.166-4.1-.354-6.154-.47-.265-.016-.635.28-.815.534-2.394 3.376-5.936 2.892-9.44 3.136-5.091.354-10.144 1.253-15.576 1.852-1.454-3.072-3.464-6.069-3.491-9.083a4392.98 4392.98 0 0 1 .03-82.609c.023-2.426 2.491-4.827 3.824-6.771v41.946c0 13.326-.102 26.654.124 39.976.03 1.765 1.733 3.502 2.661 5.252 1.071-1.773 2.283-3.482 3.15-5.35.382-.822.065-1.969.065-2.968 0-28.651-.074-57.303.075-85.953.024-4.622 1.041-9.239 1.64-14.2 6.998 3.173 9.8 1.33 9.536-4.972-.136-3.244 2.307-5.042 4.8-3.973 4.208 1.804 7.898 4.787 11.901 7.11 1.71.99 4.287 2.709 5.379 2.11 2.87-1.578 5.143-4.245 7.69-6.815 1.674-1.784 3.313-3.23 5.153-4.389.596 1.4 1.544 2.666 1.286 3.597-.953 3.44.997 5.269 3.632 4.9 2.09-.292 4.176-2.425 5.68-4.228.631-.756-.244-2.77-.306-3.24 3.485-3.329 6.852-5.82 9.258-9.03 2.82-3.765 5.935-4.82 10.348-3.772 4.397 1.046 8.894 1.673 13.403 2.494 1.168-4.418-.312-6.058-4.09-6.711-1.595-.276-2.926-2.075-3.912-3.204 5.153-.038 9.84-.053 14.576.27 1.518 2.3 2.447 1.907 3.419-.334 6.822.011 13.176.025 19.53.438-.93 7.242.781 8.678 7.905 7.125 2.684-.585 5.398-1.036 8.42-1.407 3.105 1.429 5.887 2.716 8.671 4.401-.465 8.505-.465 8.505 7.003 6.892-.522 2.926-1.266 5.406-1.474 7.93-.102 1.227.512 2.814 1.363 3.699.46.478 2.6.234 3.12-.395 1.997-2.424 3.444-1.429 5.397.042.872.657 2.522.28 3.819.373-.183-1.298-.17-2.665-.593-3.88-.74-2.128-1.747-4.162-2.519-6.522.372-1.073.622-1.858.877-3.03-1.002-1.803-2.01-3.22-3.311-4.782a25.993 25.993 0 0 1-2.739-4.18c-1.01-.795-1.976-1.24-3.259-1.825a60.255 60.255 0 0 0-3.65-.873c-.026.011-.02-.045-.135-.27-.41-.364-.706-.503-.947-.648.055-.005-.044.043-.036-.307-.916-.845-1.839-1.34-2.802-1.818-.04.018-.056-.069-.06-.425-.023-1.07-.043-1.782-.058-2.862.023-5-1.948-3.44-4.34-1.71-2.138-.314-3.929-.572-6.04-.806-.736-.076-1.15-.176-1.567-.51-.001-.235-.033-.703-.036-1.095.666-1.776 1.335-3.16 2.338-4.55 1.148-.555 1.96-1.106 3.223-1.731 4.443-.082 8.435-.089 12.441.265.683 1.042 1.353 1.722 2.023 2.403.679-.852 1.358-1.704 2.072-2.744.035-.188-.021-.565.288-.546.718.09 1.125.16 1.704.479.736.386 1.3.524 2.017.94.732.496 1.31.713 1.883 1.305-.533 1.878-1.06 3.38-1.835 5.586 4.697-1.527 8.928 5.279 13.227-1.107l4.633 5.364-19.746 2.827.234 1.734c7.48 1.068 15.169 3.704 22.377 2.74 6.5-.869 12.664-1.895 19.14-.133 1.662 1.165 3.508 2.937 4.855 2.616 4.417-1.053 8.592-3.077 12.974-4.328 4.209-1.201 5.43-4.334 6.124-8.018.362-1.925.645-3.865 1.069-5.996.29-.45.533-.616 1.214-.684 1.481-1.022 2.583-2.06 3.795-3.301.32-.447.581-.604 1.3-.665 6.276 1.066 12.145 2.12 18.342 3.232v-5.788l1.3-.37c.667 1.995 1.146 4.083 2.072 5.95.58 1.167 1.835 2 2.814 3.362-.045 1.13-.118 1.883-.528 2.682-2.327 2.229-4.81 4.184-5.988 6.74-.327.71 2.977 3.647 5.05 4.738 1.691.89 4.03.554 6.081.762l-1.037-1.75c.494-2.56.987-5.118 1.526-7.989.671-.792 1.297-1.272 2.123-1.443 4.376 5.339 5.892 5.389 10.681.572 1.622-1.63 3.343-3.21 4.689-5.052.773-1.058.854-2.61 1.303-3.92.55-1.604.696-3.805 1.834-4.658 2.865-2.146 3.924-4.67 3.625-8.222.441-.697.64-1.232 1.204-1.79 1.093-.031 1.823-.041 2.552.36-1.054 6.806 4.373 9.227 7.834 12.655 2.249 2.228 5.548.492 6.112-2.892 1.012-6.07 5.364-11.971 1.224-18.576 1.072-.394 1.924-.549 2.979-.421 1.085.462 1.968.642 3.022 1.051.724-.257 1.277-.743 2.048-1.337.493-.307.68-.569 1.138-.895 1.785-.668 3.214-1.333 5.093-1.997 3.15 0 5.85 0 8.633.387 6.362.462 12.64.538 19.261.611 1.126-.358 1.907-.713 3.017-1.053.765.06 1.2.103 1.693.478 1.4 1.058 2.746 1.783 4.43 2.666 2.057.379 3.776.6 5.5 1.17.01.812.013 1.277-.28 1.957-1.536.741-2.827 1.176-4.005 1.818-.969.528-1.804 1.301-3.078 2.045-2.78 4.98-1.561 9.46 2.75 9.691 6.639.356 13.5 1.013 20.018-2.77 5.13-.525 5.518-.89 4.62-4.26-.21-.718-.412-1.172-.642-2.023-.015-1.193-.003-1.989.244-3.058.29-1.747.345-3.22.508-4.946.369-.74.628-1.225 1.239-1.766 2.448-1.353 4.545-2.65 6.968-3.92 1.442.677 2.558 1.325 3.684 2.354.797 1.098 1.584 1.814 2.37 2.53.54-.97 1.08-1.94 1.94-2.952.775-.679 1.229-1.317 2.026-1.957.802-.016 1.26-.028 1.687-.025-.03.016-.002-.047.097.19.375.43.651.621 1.148.848.222.035.66.132.67.424.043.677.074 1.063.094 1.811.641 1.162 1.293 1.962 1.951 3.135.007 1.12.007 1.868.048 2.936.68.773 1.32 1.226 1.959 2.012 0 .778 0 1.223-.365 1.736-2.623 4.562-1.722 5.869 4.782 6.931 1.805 0 3.194 0 4.797.255 5.027-.325 3.552-4.086 3.752-6.908.149-2.1.519-4.587-2.963-4.787-.597-3.181-1.174-5.924-1.806-9.02-.09-1.073-.122-1.79.104-2.745.367-1.406.475-2.574.849-3.907.46-.739.655-1.313 1.184-1.937.112-1.017-.111-1.984-.378-3.276-1.015-.442-1.985-.559-3.237-.668-.47.023-.656.037-1.09-.127-.756-1.058-1.264-1.938-1.375-2.845 1.591-.8 2.785-1.576 3.98-2.35-.275-.62-.55-1.237-.823-1.856-2.248.487-4.495.975-6.756 1.486-.013.024-.068.028.064-.347.178-.899.223-1.422.28-2.35-.002-2.913-.015-5.423-.028-7.932-2.363.306-4.728.601-7.087.93-.315.045-.605.263-1.125.295-.49-.303-.675-.561-.776-1.254-1.727-3.676-3.361-7.099-8.441-6.632-1.79-.009-3.166-.02-4.632-.423-3.045-.798-5.99-1.362-8.96-1.575-7.18-.515-7.918-1.185-7.834-8.314.427-1.033.736-1.784 1.344-2.586.705-.08 1.11-.109 1.867-.192 2.24-3.822 1.583-5.006-2.638-4.928-.767-.337-1.238-.651-1.752-1.315-1.008-.797-1.973-1.244-2.938-1.692l-.007-.372c-1.013-1.119-2.02-1.865-3.288-2.73-.749-.701-1.235-1.281-1.748-2.206-1.005-1.126-1.983-1.907-2.959-2.69.003-.002 0 .003-.039-.354-1.35-1.117-2.66-1.875-3.965-2.64.007-.007-.007.01-.037-.337-1.341-.784-2.651-1.222-4.38-1.673-6.455-.334-12.493-.654-18.973-.98a724.57 724.57 0 0 1-9.36-1.032l.126-2.228c4.627-.291 9.287-.344 13.866-.978 2.134-.296 5.213-1.25 5.856-2.76.653-1.533-.587-4.757-2.048-6.082-1.777-1.611-4.652-2.01-7.348-2.956-.763-.343-1.228-.665-1.736-1.307-.682-.772-1.322-1.222-2.3-1.726-2.777-1.69-5.217-3.326-7.662-5.33-1.34-2.118-2.674-3.865-4.424-5.613-1.8-.006-3.186-.012-4.627-.365-2.159-1.803-3.72-6.138-7.347-1.634-1.172.588-1.943 1.163-3.102 1.806-1.694.033-3-.002-4.404-.392-.763-1.045-1.428-1.734-2.155-2.779-.864-.684-1.811-1.47-2.447-1.269-4.535 1.432-9.007 3.065-13.91 4.634-2.801.332-5.19.665-7.844.712-3.44-.535-7.467-2.568-8.162 3.279-3.14.643-5.856 1.284-8.614 1.576-1.726-3.644-4.194-5-7.992-4.117-3.144.73-4.393 2.441-4.397 5.542-2.14.003-3.852.004-6.008.004-2.25-.02-4.083.153-5.858-.092-7.291-1.006-13.576 1.713-20.097 5.101-3.127.668-5.865 1.33-8.979 1.99-1.46.653-2.546 1.307-4.085 1.968-4.481.35-8.51.692-12.893 1.037-1.12.658-1.886 1.313-2.66 2.209-.007.24-.006.722-.362.83-1.095.088-1.835.068-2.776-.23-1.085-.463-1.969-.646-2.899-1.2-1.349-2.051-2.633-3.746-3.96-5.407-.864-1.083-1.788-2.117-2.686-3.173-1.099 1.147-2.383 2.174-3.23 3.483-.556.858-.48 2.124-.695 3.25-5.225.31-9.685 1.585-12.798 6.231-4.803.013-9.192.011-13.766-.326-6.011-3.288-10.806-1.367-12.21 4.333-2.383.672-4.34 1.753-6.372 1.925-6.394.542-12.816.742-19.637 1.064-7.093-3.054-12.571 1.944-18.66 2.861-.787.119-1.302 2.044-2.373 3.135-3.143-.33-5.855-.66-8.62-1.331-4.364-2.867-4.74.902-6.23 3.634-4.095.76-7.907 1.233-11.71 1.297.328-2.599.647-4.789.905-6.555-3.17-1.098-5.867-1.554-8.031-2.88-4.617-2.828-7.212-2.029-8.967 2.391 4.205 2.94 8.147 5.698 12.066 8.923-.025.78-.026 1.093-.304 1.474-.823-.064-1.37-.197-2.404-.527-8.141.604-15.844 1.095-23.437 2.284-9.327 1.46-18.562 3.503-27.83 4.914 1.61-5.852 10.683-9.923 15.823-7.783 2.077.865 4.537 1.045 6.832 1.092 2.568.052 5.012-1.107 4.144-4.08-.446-1.528-2.692-3.489-4.218-3.575-6.28-.352-12.597.072-18.895-.067-2.609-.058-5.203-.811-7.804-1.248 6.81-1.317 13.597-2.784 20.44-3.895 3.996-.65 8.108-.565 12.117-1.153 1.51-.222 2.878-1.409 4.63-2.529.318-.372.687-.374.687-.374 4.334-.084 8.667-.168 13.381-.727.598-.636.754-.845.847-1.1 4.237-.393 8.498-.63 12.694-1.287 1.065-.166 1.921-1.668 3.815-3.433 2.398.115 6.85.335 11.303.537.831.037 1.946.354 2.457-.053 7.268-5.777 16.2-1.26 23.919-3.969 2.094-.734 4.074-1.794 6.023-2.668l-3.594-.562-.015-.417h6.952c-.369.422-.79.906-1.211 1.382 3.21-.241 6.475-.205 9.603-.841 1.259-.256 2.218-1.987 4.052-3.76h3.925l-2.432 2.224 15.239-2.662-.173-1.286-2.562-.854c1.808-.49 4.195-1.565 4.49-1.151 3.163 4.444 7.395.391 10.878 1.584.403.139.953-.15 1.663-.284l-.608-3.676c1.483 0 3.389-.549 4.72.093 6.875 3.313 13.591-1.048 20.394-.232.558.067 1.336-1.699 1.642-3.101 1.427-.201 3.428-2.414 5.793.834.92 1.264 5.813-.08 8.807-.681 3.506-.705 6.857-2.254 10.375-2.81 9.767-1.542 19.592-2.71 29.377-4.14 2.285-.335 4.719-.652 5.577-3.6.15-.516 2.594-1.062 2.814-.757 3.195 4.445 7.423-.174 10.934 1.245.13.052 1.048-1.845 2.07-3.683h5.407l-2.98 1.374.189.74 15.236-2.528-.103-1.42-2.211-.61c.093-.222.139-.59.28-.63 1.007-.293 2.772-.976 2.943-.699 3.057 4.95 7.33.845 10.927 1.494 3.229.582 3.346-1.421 2.438-2.926h31.4c.42 2.786 3.448 5.057 7.045 3.736 3.38-1.24 4.43-.447 4.878 2.924.113.851 2.376 1.263 3.378 2.177 3.787 3.459 7.441 7.062 11.196 10.557.686.639 1.606 1.027 2.787 2.043 1.616 1.541 2.863 2.57 4.11 3.6M344.118 219.995c3.493-.988 5.182-4.402 3.699-7.9-1.542-3.638-3.92-.799-5.883-.506-4.539.674-9.027 1.857-13.581 2.172-2.024.14-4.014-.969-4.313 2.137-.292 3.047 1.241 4.174 4.159 4.123 4.994-.087 9.992-.022 15.919-.026M517.32 82.948c-3.104-.588-6.194-1.316-9.326-1.632-.549-.055-1.847 1.673-1.773 2.482.099 1.064 1.025 2.292 1.948 2.97.843.62 2.81.257 3.162.92 4.043 7.63 4.128 1.6 5.15-1.409.31-.912.786-1.766.839-3.331m18.086 21.108c-2.328-.401-4.65-.892-6.994-1.075-.249-.02-1.178 2.299-.869 2.607 1.315 1.31 3.078 3.23 4.484 3.084 1.367-.143 2.5-2.537 3.379-4.616M240.494 69.001l-4.323 2.775c1.309 1.066 2.638 3.004 3.922 2.975 1.587-.036 3.137-1.707 4.702-2.671-1.162-1.025-2.324-2.05-4.301-3.079m254.689 3.573.562-4.204-1.58-.761c-1.042 1.38-2.33 2.653-3.014 4.193-.31.696.582 1.926.928 2.914.924-.484 1.847-.967 3.104-2.142m-117.71 109.495-.032 4.492 3.347-2.335c-.923-.87-1.845-1.738-3.315-2.157m152.731-23.545.974 4.276 2.68-1.29c-.993-1.104-1.987-2.208-3.654-2.986m-167.52 74.824-2.59-1.718-.54 2.154c.946.047 1.891.095 3.13-.436m81.27-38.097.376 2.22 1.25-.231c-.326-.697-.652-1.393-1.626-1.99m-76.277.198.353 2.298 1.32-.25c-.343-.716-.685-1.43-1.673-2.048m-179.493 29.179-.624-2.173-1.171.417c.396.596.793 1.191 1.795 1.756m273.52-56.058.858-.82c-.114-.118-.32-.345-.327-.339-.302.255-.585.532-.532 1.16m-287-84 .858-.82c-.113-.118-.318-.346-.326-.34-.302.255-.585.531-.532 1.16z"/>
        <path fill="#FEFEFF" d="M89.163 551.986c-1.973-2.33-3.81-4.795-5.962-6.944-1.616-1.614-3.638-2.82-5.995-4.44-.747-.428-1.015-.538-1.32-.56 0 0-.454-.051-.674-.365-.22-.313-.254-.785-.254-.785-3.58-3.043-7.159-6.085-10.856-9.877.158-3.198.824-5.675.642-8.088-.778-10.312-2.601-20.603-2.621-30.905-.202-104.043-.106-208.087-.157-312.13-.004-8.037 7.417-14.136 5.609-22.59-.074-.343.993-.835 1.338-1.378 1.793-2.827 1.918-4.947-1.833-6.55-1.737-.744-2.967-2.863-4.204-4.523-.86-1.153-1.339-2.588-1.988-3.897 0 0 .116-.484.56-.768 4.732-2.964 8.812-1.699 11.199.074 3.408-4.316 5.61-9.265 9.388-11.323 4.408-2.4 5.545-6.843 8.92-9.597 1.34-1.092 2.615-3.102 3.98-3.157 3.051-.12 4.511-1.227 5.24-4.109.431-1.711 1.52-3.257 2.315-4.877 3.88-.066 7.089-1.274 10.363-2.26 2.821-.848 3.511-2.548 2.956-5.302-.257-1.277-.335-3.27.411-3.962 5.68-5.275 14.665-2.996 17.489 4.538-2.508 1.074-4.823 1.754-6.902 2.871-1.141.614-1.885 1.965-2.89 3.087-.08.103-.336.045-.8-.02-2.646.354-6.28-1.837-6.06 2.97-.063-.044.082.008-.332-.04-5.8.175-13.36 5.394-14.753 9.885-.023.05-.125.002-.498-.002-4.495-.022-5.84 2.676-6.423 6.1-.03-.05.061.023-.33-.01-1.787.856-3.417 1.519-4.536 2.675-2.806 2.9-4.875 6.94-8.203 8.77-2.733 1.502-3.004 2.892-2.996 5.246.004 1.155.241 2.575-.314 3.426-4.375 6.7-5.459 14.582-8.26 21.775-2.763 7.097-3.302 14.068-3.312 21.167-.143 99.988-.102 199.976-.086 299.964.001 7.982-.958 16.057 3.965 23.326 4.744 7.005 8.793 14.515 17.462 17.621 3.765 1.35 5.33-.13 5.545-3.752.08-1.329.022-2.666.022-3.999.001-105.987-.018-211.974.09-317.961.003-3.67.91-7.453 2.045-10.974 1.149-3.564 1.058-5.86-3.331-6.743-.013-1.103.08-1.843.424-2.736.453-.69.655-1.228 1.214-1.866 1.086-1.873 1.834-3.639 2.54-5.42 1.54-3.88 2.414-8.22 4.743-11.542 3.284-4.683 9.026-7.686 9.292-14.375.021-.544.602-1.149 1.06-1.579 2.39-2.242 4.863-4.396 7.234-6.658 5.368-5.123 9.684-6.17 15.136-3.63.217.101.61-.176.92-.28 1.325-6.128 2.014-6.767 7.565-8.017 2.877-.647 5.638-1.93 8.535-2.344 8.414-1.206 16.871-2.105 25.307-3.157 1.278-.16 3.287-.086 3.674-.808 1.902-3.553 4.935-1.839 7.539-2.003 1.584-.1 3.44.543 4.726-.077 6.022-2.905 12.326-3.534 18.854-3.125.806.05 2.12.086 2.37-.348 2.164-3.76 5.766-2.741 8.85-2.532 4.433.3 8.173-.643 11.516-4.092.774-.076 1.226-.04 1.97.295 8.284-.341 16.287-.87 24.264-1.668 4.288-.429 8.533-1.296 12.791-2.008 2.225-.372 4.458-.742 6.645-1.285 2.767-.687 5.462-1.675 8.242-2.293 1.754-.39 3.63-.198 5.408-.513 4.327-.769 8.77-2.792 12.906-2.266 5.787.735 10.582-4.875 16.386-1.8.267.142.864-.436 1.338-.573 3.591-1.036 7.142-2.311 10.802-2.98 2.978-.545 6.103-.215 9.139-.518 6.857-.686 13.054-4.909 20.398-3.617 1.224.215 2.937-2.349 4.78-3.744 1.1-.095 1.844-.074 2.828.23 3.757.435 7.275.585 10.985.98 3.77-1 7.085-1.55 8.799 3.903-2.006.32-3.691.656-5.393.844-2.46.272-4.737.667-5.032 3.956-4.075 1.09-7.722 2.158-11.643 3.243-1.173-.102-2.072-.22-3.463-.611-3.82.224-7.752-2.783-10.646 1.716-.767.962-1.325 1.647-2.234 2.394a28.296 28.296 0 0 1-4.352-.326c-3.398-.236-6.314-.297-9.397-.587-.735.237-1.302.702-2.24 1.178-1.11.021-1.851.033-2.761-.182-.735.24-1.301.708-2.297 1.186-2.079.09-4.234-.474-5.289.357-4.697 3.704-10.064 2.443-15.417 2.448-.729.254-1.286.736-2.175 1.221-.772.005-1.213.007-1.84-.23-1.08.558-1.974 1.354-3.311 2.176-1.926.045-3.486-.227-4.873.146-2.931.787-5.771 1.91-8.874 3.029-.565.126-.905.12-1.748.03a592.902 592.902 0 0 0-15.349-.05c-.721 1.112-1.075 2.173-1.436 3.225-.008-.01-.024-.028-.431-.133-1.52-.153-2.634-.2-3.817-.583-2.743-3.56-4.987-2.773-7.306.546-3.11 1.316-5.889 2.49-9.058 3.742-1.448.083-2.505.09-3.565-.156a8.21 8.21 0 0 0-.083-1.085c-1.038-.12-2.019.091-3.402.315-3.477 1.269-6.551 2.524-9.923 3.837-1.099.092-1.901.126-2.912.092-.208-.068-.636-.158-.716-.423-.747-.048-1.414.17-2.504.42-3.469.95-6.513 1.867-9.947 2.864-1.447.103-2.506.128-3.855-.125-3.095-.393-5.899-.51-8.96-.907-3.422.572-6.586 1.424-10.124 2.323-2.658.914-4.892 2.32-7.237 2.54-5.088.474-10.233.342-15.696.479-1.137.971-1.934 1.923-3.166 2.892-4.13.365-7.822.713-11.865 1.06-1.135.638-1.919 1.275-3.015 1.958-.774.43-1.235.814-1.895 1.322-.515.25-.818.225-1.545-.063-3.348.529-6.26 1.17-9.512 1.848-.815.955-1.289 1.874-2.13 2.832-1.782 1.309-3.198 2.58-4.815 3.963-.203.112-.661.17-1.064.144-6.695-.757-7.922 5.355-11.43 8.331-1.218 1.033-1.458 3.216-2.215 5.15-.44.669-.812 1.061-1.505 1.5-.685.744-1.048 1.443-1.464 2.078-.054-.064.072.046-.261.025-1.158.62-1.983 1.26-3.164 1.942-1.118 1.348-1.88 2.654-2.983 4.014-.781 2.016-1.221 3.98-1.673 6.27-.052.76-.091 1.195-.347 1.82-.362.74-.507 1.29-.807 2.2-.38 2.457-.603 4.553-.804 7.076-.121 2.126-.264 3.825-.758 5.625-.988 2.734-2.18 5.367-2.183 8-.094 108.081-.075 216.162-.105 324.243 0 3.303-.825 6.671-.38 9.887.284 2.056 2.199 3.887 3.397 5.821.015.003.011.033.088.272.36.396.645.552.925.721-.004.013.018-.006.029.353 2.333 3.117 4.656 5.875 6.82 8.945-1.448 1.733-2.737 3.154-4.097 4.655 2.755.468 4.497.764 6.003 1.338-6.144 2.364-8.72 1.482-7.432-2.15 1.401-3.946-.803-5.372-3.043-7.287-3.735-3.193-8.085-6.072-6.408-12.154.09-.325-.383-.806-.595-1.215l-1.347-.376c-.646 2.034-1.511 4.028-1.895 6.11-.847 4.59-1.452 9.224-2.155 13.84-.746-.024-1.493-.048-2.447-.43-.899-.45-1.59-.54-2.28-.63z"/>
        <path fill="#FFF" d="m555.114 538.042.956 2.316c-1.7.547-5.92-2.44-4.24 2.877.073.23-1.56 1.366-2.454 1.445-1.224.107-2.649-.878-3.73-.549-3.806 1.16-7.573 2.528-11.167 4.217-.582.273-3.856.671-1.797 3.148-.938.496-1.849 1.305-2.824 1.392-.796.07-1.67-.72-2.51-1.128l1.456-1.616c-10.019 1.629-19.828 3.174-29.616 4.845-2.818.481-5.58 1.303-8.344 2.054-.159.043.037.955-.183 1.303-.387.609-1.066 1.61-1.451 1.537-1.356-.256-2.64-.898-3.951-1.394l1.806-1.228c-9.358 1.293-18.216 2.517-27.792 3.745-.902-.003-1.086-.008-1.447-.338-2.061-.773-3.943-1.22-5.883-2.02-5.373-4.212-4.937-6.494 1.331-9.71 1.252-.641 1.835-2.586 3.127-3.932 1.466 0 2.532 0 3.598.428.31 2.736.62 5.046.93 7.349 2.963-2.026 4.84-3.52 6.903-4.682 8.433-4.75 8.69-6.482 1.658-12.412-.5-.422-1.113-.88-1.32-1.45-1.24-3.416-4.056-4.055-7.428-4.346-.754-.37-1.248-.633-1.821-1.274-4.29-1.957-9.184-2.243-11.925-6.984-1.326-1.796-2.649-3.228-3.986-5.06-.331-1.669-.905-2.936-.918-4.21-.046-4.672-3.93-4.903-6.885-5.519-1.014-.21-2.508 2.308-3.915 3.41-.936.732-2.107 1.164-3.223 1.338-1.07-3.103-2.087-5.812-3.056-8.885.841-2.266 1.633-4.169 2.425-6.072-4.474-.203-4.13-4.288-5.664-6.901-.43-.732-1.646-1.676-2.253-1.525-4.868 1.21-7.04-2.234-9.52-5.602 1.286-2.725 2.012-5.873 3.974-7.224 4.082-2.81 5.41-5.39 2.83-9.626-2.27-3.728-4.927-7.22-7.772-11.336 2.093-.521 4.041-.733 5.723-1.515 1.26-.586 2.177-1.908 3.715-2.904 8.486.009 16.504.02 24.525.42.1 4.255 1.698 6.074 5.868 5.214 1.618-.334 3.418.215 5.386.362.25 0 .749.001.81.356.95 1.87 1.907 3.35 2.705 4.911.635 1.245.768 3.383 1.663 3.73 2.119.818 5.026 1.79 6.786.955 6.31-2.996 11.85-1.197 13.624 5.49.774 2.917 1.72 4.088 4.736 2.893 1.026-.406 2.278-.24 3.736-.18 2.169 1.712 3.878 3.307 1.327 5.906-.998 1.913-2.37 3.868-2.13 5.599.747 5.385 2.383 10.645 3.153 16.028.805 5.631.445 11.105-4.205 15.474-2.073 1.948-3.894 4.383-.18 6.867.855.572 1.165 1.959 1.7 3.29-.342 1.107-.659 1.894-1.343 2.752-1.171 1.926-2.27 3.718-2.685 5.657-.32 1.497.22 3.178.379 4.777 1.892-.5 3.783-1.002 6.104-1.503 2.142 0 3.856 0 5.767.275 2.267 2.045 4.082 4.641 6.47 5.379 2.97.917 6.422.453 9.651.288 2.048-.104 4.07-.75 6.103-1.152l-1.634-5.683c1.689 0 3.482-.44 4.93.082 4.28 1.542 6.166-.521 7.601-4.348 2.773-1.054 5.228-1.949 7.736-2.493 5.232 4.805 11.377 6.511 18.06 6.692zM60.496 138.976c1.041 1.287 1.52 2.722 2.38 3.875 1.237 1.66 2.467 3.78 4.204 4.522 3.751 1.604 3.626 3.724 1.833 6.55-.345.544-1.412 1.036-1.338 1.379 1.808 8.454-5.613 14.553-5.61 22.59.052 104.043-.044 208.087.158 312.13.02 10.302 1.843 20.593 2.62 30.905.183 2.413-.483 4.89-.772 7.762-3.91-.34-3.374-.501-4.592-4.567-1.095-3.655-3.544-6.904-5.289-10.832-.57-3.097-1.247-5.695-1.923-8.292-.323-1.42-.646-2.84-.809-4.865.654-5.191 1.575-9.775 1.579-14.36.083-99.535.063-199.07.06-298.605 0-1.663.232-3.399-.182-4.958-.18-.678-1.725-.993-2.65-1.473-.048-.805-.095-1.61.15-2.8.418-.37.543-.359.668-.347l-.703-.501c.578-1.78 1.156-3.558 2.157-5.792.434-2.081.446-3.709.457-5.336.04-.743.08-1.486.548-2.676.79-1.763 1.154-3.079 1.517-4.395.965-3.15 2.628-6.29 2.683-9.456.047-2.738 3.886-5.38.396-8.192.688-.749 1.377-1.497 2.458-2.266z"/>
        <path fill="#FEFEFE" d="M456.001 545.007c-.892 1.345-1.475 3.29-2.727 3.932-6.268 3.215-6.704 5.497-1.68 9.745-1.392 1.973-2.494 3.56-3.595 5.145-.752.053-1.505.107-2.69-.291-3.668-4.703-7.608-1.922-11.31-1.938-2.246-7.402-6.592.008-9.45-2.79l-.893 1.235 2.457 7.001c-.345.297-.66.808-1.04.86-7.706 1.063-15.42 2.07-23.131 3.099-1.493.2-2.397 1.421-3.14 3.504-.225.632-1.263 1.445-1.842 1.381-1.22-.134-2.382-.792-3.568-1.235l1.822-2.03c-7.147 1.344-13.582 2.567-20.023 3.757-1.435.266-2.962.208-4.32.669-2.028.688-3.944 1.704-6.728 2.948-5.784.294-12.736.48-19.65 1.091-2.446.217-4.8 1.475-7.195 2.257.445 1.268.729 3.763-1.17 1.709-3.525-3.813-6.996-.507-10.301-.701-4.306-.253-8.754 1.61-13.114 2.67-2.118.515-4.29 1.041-6.234 1.985-2.317 1.124-4.429.927-7.28 0-.827-.001-1.013-.008-1.244-.4-1.285-1.459-2.363-3.044-3.8-3.5-3.252-1.031-6.78-1.208-10.012-2.286-3.553-1.185-6.72-2.047-10.399-.039-1.818.993-4.514 1.014-6.655.62-2.733-.502-4.025-.131-5.443 2.567-.956 1.82-3.719 3.161-5.91 3.642-.935.206-2.472-2.326-3.353-3.57 2.665.185 4.946.326 7.228.467l.541-2.148c-1.941-1.237-3.822-2.604-5.888-3.579-.332-.157-1.488 1.433-2.627 2.155-1.12-2.354-1.879-4.647-2.303-6.973.925-.954 1.516-1.875 2.107-2.795-1.147-.057-2.294-.114-3.79-.327-7.024-3.304-9.93-2.592-15.374 2.995-.857.879-2.711 1.147-4.083 1.098-5.003-.18-7.536 1.916-7.574 7.02-2.13-.347-3.88-.652-5.773-1.285-1.051-3.112-1.961-5.896-2.608-8.574.762.372 1.261.637 1.938 1.229 3.568 2.65 5.914 2.753 6.213-2.327 6.574-3.138 11.868-7.016 12.242-14.822 4.031.385 6.854 1.315 6.536 5.949-.06.864 1.31 2.377 2.292 2.663 3.293.96 6.71 1.501 10.385 2.266-2.844-4.642-3.043-8.84 3.43-11.048.458.015.641.022.816.336a61.475 61.475 0 0 0-.02 1.861c.598.817 1.187 1.31 1.818 2.19.44 1.792.838 3.195 1.297 4.99.082 1.966.103 3.542.01 5.518.594 1.258 1.303 2.117 2.316 2.979.704.065 1.104.126 1.754.48 4.696.382 9.141.472 13.961.557 1.84-.976 3.307-1.946 5.209-2.935 3.812-.344 7.188-.67 10.6-.638 1.712 2.973 3.201 5.744 5.167 8.121.725.877 2.574.823 3.91 1.194.098-1.52.443-3.083.196-4.545-.138-.816-1.517-1.357-1.88-2.215a12.546 12.546 0 0 1-.963-4.91c5.137-.346 9.808-.672 14.805-1.033.794-.665 1.263-1.295 2.13-1.946 1.467-.022 2.533-.021 3.638.335 2.248 3.91 3.846 3.389 5.297-.443 1.776-.689 3.212-1.315 4.815-1.706.729-.236 1.29-.706 2.276-1.2 3.81-.343 7.195-.661 10.834-.704 2.068-.28 3.882-.835 5.712-1.677.044-.668.072-1.049.459-1.507 1.089-.057 1.82-.036 2.802.243 2.42.08 4.589-.097 6.76.133-.86 5.166 2.57 6.004 5.842 6.092 3.27.088 4.364-1.987 3.37-5.258-.28-.92.493-2.159 1.117-3.274.78-.012 1.227-.002 1.72.37 3.002 3.341 7.91 2.435 10.303-1.83.48-1.011.606-1.662 1.024-2.322.852.083 1.413.174 2.304.69 2.319.61 4.308.8 6.5 1.247 1.743-.565 3.284-1.39 5.23-2.28 3.799-.359 7.193-.651 10.737-.71.733.055 1.316-.126 2.253-.304 1.064.01 1.773.018 2.89.056 2.51.365 4.613.701 6.927 1.287 1.07-1.27 1.928-2.789 3.079-4.434 1.096-.358 1.9-.591 2.914-.56 1.738.092 3.267-.082 5.009.011 1.774 1 3.335 1.734 5.225 2.622.22-1.132.391-2.01.884-2.93.774-.687 1.225-1.332 2.116-1.986 2.78-.012 5.122-.015 7.825-.052.802-1.031 1.242-2.03 1.681-3.417.039-1.427.077-2.464.478-3.574 4.253-6.216 3.507-11.601-1.796-14.004-.972-.748-1.694-1.36-2.488-2.286-.075-.74-.077-1.167.135-1.715.468-.34.657-.606 1.105-.919L447 522c2.737 4.376 7.63 4.662 11.536 6.626-4.741 2.249-5.537 4.677-3 8.93-.08 1.86-.144 3.343-.28 5.185.2.996.473 1.631.745 2.266M234.21 562.033c-.561 3.473-1.409 6.584-5.381 7.965-.878.305-1.025 2.71-1.509 4.147.986-.043 2.3.306 2.9-.198 2.323-1.95 4.419-4.172 7.45-7.12-.59-1.058-1.787-3.2-3.46-4.794m151.743 4.415 4.506-1.656c-.516-1.063-.789-2.705-1.606-3.047-1.12-.469-2.652.05-4.008.146.152 1.398.304 2.797 1.108 4.557z"/>
        <path fill="#FFF" d="M252 586c1.264 1.288 2.8 3.82 3.736 3.614 2.191-.48 4.954-1.822 5.91-3.642 1.418-2.698 2.71-3.069 5.443-2.566 2.141.393 4.837.372 6.655-.62 3.68-2.009 6.846-1.147 10.399.038 3.231 1.078 6.76 1.255 10.012 2.286 1.437.456 2.515 2.041 3.594 3.586-.425.632-.618.853-.743 1.135-7.806 1.304-15.601 2.672-23.42 3.892-7.51 1.172-15.04 2.231-22.573 3.25-1.952.264-1.8.195-3.418 3.441-.385.773-3.126 1.41-3.474 1-3.37-3.976-7.168-.38-10.69-.6l7.411.367c-.406.617-.675 1.387-.95 1.39-5.065.04-10.13-.06-15.195-.022-2.038.015-4.112.097-6.101.491-4.388.87-9.127 1.232-12.92 3.284-1.74.942-2.357 3.486-4.913 1.53-.059-.046.486-.878 1.367-2.435-5.448 1.258-10.059 2.786-14.775 3.254-3.425.34-6.986-.748-10.492-1.152-2.919-.337-6.19.13-8.702-1.046-6.276-2.937-14.148-2.773-18.674-9.253-.19-.273-.937-.274-1.403-.22-7.426.853-7.784-6.689-12.228-10.235v2.862c-4.363-6.328-8.932-12.279-17.484-12.868.048-3.508-.954-6.245-5.38-5.975-.367.694-.472.84-.576.986l-5.891-9.15.351 4.093-.706.425-5.65-9.325-.894.3.238 2.632-1.065.553c-1.542-2.529-3.084-5.058-4.768-7.921.562-4.95 1.167-9.583 2.014-14.173.384-2.082 1.249-4.076 1.895-6.11l1.347.376c.212.409.685.89.595 1.215-1.677 6.082 2.673 8.96 6.408 12.154 2.24 1.915 4.444 3.34 3.043 7.288-1.288 3.63 1.288 4.513 7.73 2.17 1.001.062 1.47.381 1.978 1.062 2.347 1.454 4.653 2.546 6.99 3.984.345 1.449.657 2.552 1.03 4.005 2.752 2.838 4.184 1.715 4.939-1.725 0-1.125 0-1.875.417-2.625 1.805 0 3.194 0 4.614.34 1.01 1.78 1.99 3.22 3.005 5.018 2.331 5.299 6.333 9.594 4.205 15.984-.801 2.404.207 5.558.888 8.244.32 1.266 1.84 3.188 2.772 3.163 3.072-.084 6.722-.048 9.057-1.65 4.78-3.281 8.868-1.875 12.995.43 11.303 6.309 21.854 4.494 32.464-2.529 1.805 0 3.194 0 4.937-.005 1.118-.67 1.882-1.337 2.972-2.008.764-.01 1.2-.014 1.907.107.77.719 1.268 1.312 1.83 2.259 1.574.379 3.99.991 4.427.319 1.263-1.948 1.73-4.411 2.51-6.672-.342-5.147 2.19-7.243 7.194-7.063 1.372.05 3.226-.22 4.083-1.098 5.444-5.587 8.35-6.299 15.398-2.676.69 1.263 1.008 2.05 1.325 2.837.758 2.292 1.516 4.585 2.637 7.314C252 584.5 252 585.25 252 586zM134 98c-3.115-7.323-12.1-9.602-17.78-4.327-.746.693-.668 2.685-.41 3.962.554 2.754-.136 4.454-2.957 5.303-3.274.985-6.482 2.193-10.363 2.259-.794 1.62-1.884 3.166-2.316 4.877-.728 2.882-2.188 3.988-5.238 4.11-1.366.054-2.64 2.064-3.98 3.156-3.376 2.754-4.513 7.197-8.92 9.597-3.778 2.058-5.98 7.007-9.39 11.323-2.386-1.773-6.466-3.038-11.117-.309-.366-1.435-.649-3.003-.242-4.365.178-.598 1.762-.777 2.708-1.147l.949 1.28.663-6.214 3.35-1.21-2.609-1.723 6.135-2.543-2.571-.84c4.339-4.01 8.694-8.03 12.974-12.128.019-.018-1.03-1.15-1.59-1.774 2.336-2.856 9.044-.648 8.09-7.456 3.577 2.149 4.923.825 6.464-2.54.94-2.052 4.277-3.006 6.537-4.453l1.049 1.234 1.432-5.284 1.963 2.301c.434-.313.892-.608.875-.638-1.896-3.404 2.478-3.346 2.6-3.236 3.273 2.914 5.242-.624 7.733-1.386 4.36-1.334 8.75-2.564 13.488-3.855 2.962.418 5.556 1.171 8.165 1.229 6.298.139 12.616-.285 18.895.067 1.526.086 3.772 2.047 4.218 3.575.868 2.973-1.576 4.132-4.144 4.08-2.295-.047-4.755-.227-6.832-1.092-5.14-2.14-14.214 1.93-16.157 7.786-.783.38-1.228.38-1.672.38z"/>
        <path fill="#FCFCFC" d="M50.088 181.08c1.002.137 2.546.452 2.727 1.13.414 1.559.182 3.295.182 4.958.003 99.535.023 199.07-.06 298.605-.004 4.585-.925 9.169-1.721 14.008-.593-1.589-1.136-3.432-1.137-5.276-.051-104.36-.057-208.721.01-313.425z"/>
        <path fill="gray" d="M49 305v191.325h-.715V179.89l.715-.004V305z"/>
        <path fill="#FCFFFE" d="M555.459 538.021c-7.028-.16-13.173-1.866-18.1-6.826 2.067-2.385 3.883-4.264 6.095-6.158 4.937 1.271 5.585-3.76 8.546-5.037 1.202 3.002 2.378 6.015 3.617 9.002.747 1.804 1.592 3.567 2.41 5.73-.731 1.344-1.477 2.306-2.568 3.29zM426.526 567.025c-1.232-2.313-2.051-4.646-2.87-6.98l.893-1.236c2.858 2.799 7.204-4.611 9.415 3.145-.33 1.89-.626 3.026-.922 4.162-2.034.296-4.069.592-6.516.91z"/>
        <path fill="#FFF" d="M433.444 566.067c-.106-1.087.19-2.223.521-3.713 3.736-.738 7.676-3.519 10.974 1.106-2.686.269-4.732.782-3.721 5.275-2.458-.905-4.915-1.81-7.774-2.668z"/>
        <path fill="#FCFFFE" d="M448.41 563.902c.69-1.659 1.792-3.245 3.241-4.866 2.232.412 4.114.86 6.086 1.877-.183 1.016-.455 1.461-.728 1.906-2.73.385-5.46.77-8.6 1.083z"/>
        <path fill="#FFF" d="M445.693 26c1.95.193 3.437.385 4.924.578l-.11 1.024h-17.423L433 26h12.694z"/>
        <path fill="#FCFCFC" d="M52.089 505.39c.754 2.205 1.431 4.803 1.765 7.596-.843-2.271-1.343-4.738-1.765-7.597z"/>
        <path fill="#FCFFFE" d="M489.8 53.625c-1.216-.653-2.463-1.683-3.757-3.049 2.876-1.42 2.718 1.356 3.757 3.049z"/>
        <path fill="#FCFCFC" d="M52.545 166.139c.338 1.45.326 3.077-.032 4.784-.337-1.483-.327-3.045.032-4.784zM54.572 158.956c.024 1.25-.34 2.566-1.054 3.964-.012-1.245.327-2.572 1.054-3.964z"/>
        <path fill="#FCFFFE" d="M505.81 66.633c-.884-.022-1.79-.411-2.753-1.118.367-1.015.792-1.714 1.426-2.758.498 1.34.901 2.424 1.327 3.876z"/>
        <path fill="#F8FEFE" d="M89.096 552.22c.757-.144 1.448-.054 2.009.237-.779.133-1.428.065-2.01-.237z"/>
        <path fill="#FEFEFF" d="M520.095 76.87c-.788-.326-1.4-.859-2.013-1.391l.371-.544c.577.275 1.153.55 1.93 1.058.096.38-.009.526-.288.878z"/>
        <path fill="#F8FEFE" d="M169.744 73.696c.018.308-.351.31-.536.303a35.82 35.82 0 0 1-1.76-.354l.092-.535c.729.093 1.458.186 2.204.586zM457.361 562.894c-.08-.52.193-.965.554-1.656.272-.24.456-.235.914-.214-.189.658-.652 1.302-1.468 1.87z"/>
        <path fill="#FFF" d="M112.904 571.13c.788.327 1.4.859 2.013 1.391l-.372.543c-.576-.275-1.153-.551-1.93-1.06-.095-.378.01-.524.29-.875z"/>
        <path fill="#FEFEFF" d="M544.094 96.87c-.418-.358-.661-.922-.904-1.486.335.13.67.262 1.197.615.088.37-.015.518-.293.87zM528.094 83.87c-.418-.358-.661-.922-.904-1.486.335.13.67.262 1.197.615.088.37-.016.518-.293.87z"/>
        <path fill="#F8FEFE" d="M297.325 589.907c-.194-.358 0-.58.469-.826.392-.08.578-.072 1.043-.051-.212.328-.702.64-1.512.877zM74.687 538.98c.271-.088.305.384.31.62-.19-.02-.386-.276-.31-.62zM75.971 540.303c.22-.24.488-.13.859.24-.166.122-.47.072-.859-.24z"/>
        <path fill="#FFF" d="M154.761 603.28c0 .287-.229.358-.457.43.076-.216.153-.431.457-.43z"/>
        <path fill="#FCFCFC" d="M50.31 177.115c.205.14.439.308.673.475-.125-.012-.25-.024-.538-.244-.163-.21-.106-.205-.135-.231z"/>
        <path fill="#F8FEFE" d="M183.723 72.121c.174.311.018.52-.374.773-.08-.216.013-.522.374-.773z"/>
        <path fill="#FCFFFE" d="M218.996 348.987c.44-.847.687-2.214 1.35-2.462 6.765-2.526 7.172-8.051 6.533-13.896-.135-1.233-1.677-2.313-2.571-3.463-1.1 1.205-2.765 2.247-3.169 3.651-.634 2.211-.42 4.666-.564 7.018l-1.503.409c-2.5-3.86-5.002-7.72-7.02-10.833 2.895-3.177 5.195-5.557 7.328-8.077 2.82-3.331 6.038-1.275 9.146-.31-2.198 1.355-4.394 2.157-6.964 3.097 6.233 4.688 14.665 3.69 20.828-1.942.744-.082 1.17-.111 1.838.118 3.376-.97 6.512-2.2 9.66-3.372.012.059.014-.06.42 0 2.45-.985 4.495-2.028 6.568-3.027.028.043.02-.06.388.001 1.827-.902 3.286-1.866 4.754-2.863.009-.035.074-.007.378.001.722-.38 1.14-.769 1.724-1.409.873-.585 1.582-.92 2.601-.978.35 2.391.39 4.507.42 6.809-.01.185-.198.506-.55.56-2.921 1.403-4.888 2.964-2.46 6.383-.096.726-.194 1.135-.633 1.625-1.023 2.736-1.706 5.392-2.358 8.414-.053 1.096-.137 1.826-.492 2.779-2.078 3.977-2.05 4.062 1.136 4.272.104-.03.527.027.928.148 2.695-5.46 4.99-11.043 7.284-16.632-.001-.008.011-.016.384-.05 5.219-1.848 4.056-6.685 5.513-10.505.18-.643.345-.994.868-1.364 4.534-.73 4.933-3.906 5.142-7.166.066.083-.074-.08.288-.046 4.396-2.061 6.796-5.21 6.793-9.897.016.02-.025-.012.325-.015 4.262-2.955 8.097-6.014 12.11-8.819 2.737-1.912 5.722-3.469 8.91-5.313.985-.195 1.655-.262 2.563.007 1.654.498 3.27 1.178 4.45.725 3.623-1.392 6.998-3.437 10.635-4.779 1.712-.631 3.814-.339 5.708-.153.202.02.198 2.14.037 3.402-.62.123-.988.128-1.79.077-5.37 1.927-10.336 3.84-15.199 5.986-.554.245-.534 1.79-1.07 2.936-2.454 2.114-4.617 4.024-7.17 5.934-7.922.409-9.88 7.821-15.619 10.483l1.554 2.01c4.938-3.883 9.876-7.767 15.153-11.638 2.47-.684 4.697-1.169 6.713-2.108 21.38-9.955 43.771-12.253 66.925-9.055 1.283.177 2.612.022 3.92.022l.264-1.846c-4.158-1.194-8.317-2.388-12.509-3.977-1.541-1.186-2.995-2.502-4.567-2.664-3.57-.367-7.199-.15-10.803-.2-6.74-.095-7.276-.917-4.054-6.876 2.448-.09 4.469-.107 6.783.167 4.12.103 7.946-.086 12.094-.319.75.029 1.176.1 1.713.543 4.936 1.55 9.758 2.745 14.59 3.905 3.75.9 7.51 1.758 11.293 2.61.026-.027.023.046.064.405 1.657 2.517 1.763 6.4 5.994 5.567-.001.003.005.003-.016.387 1.041 2.65.043 6.369 4.152 6.523-.086.097.065-.115-.001.262.633 1.142 1.333 1.907 1.954 2.693-.08.021.079 0 .024.378.982 1.482 2.02 2.586 3.277 3.844.387.657.552 1.16.678 2.057 1.535 3.542 1.223 8.088 6.35 8.88.452.34.585.617.64 1.321 1.505.357 3.62.952 4.315.213 2.005-2.132.281-7.575-2.591-9.457.008-.073.026.073.097-.34-.761-3.413.528-7.372-3.84-8.991-.11-.166-.129-.563-.083-.964-.542-2.155-1.13-3.91-1.76-5.793.946-.714 1.933-1.46 3.342-2.253 2.098.148 3.773.343 5.543.725.292.39.526.538.924.997.98.746 1.813 1.412 2.682 1.462 7.099.407 14.205.699 21.308 1.025.627 2.822 4.578 6.323-1.583 7.759.421.95.842 1.9 1.207 3.372-1.6.349-3.144.175-4.672-.006.014-.006-.013.006-.072-.18-.28-.028-.503.13-.873.55.294 1.932.736 3.601 1.224 5.547.33.504.616.731.988 1.087.087.129.114.439.028.815 1.863 1.945 3.812 3.514 5.76 5.087-.003.003.003-.002.042.349.803.608 1.567.866 2.366 1.167.035.043.141.076-.06.494-3.901.941-7.62 1.367-11.293 2.047-1.073.2-2.012 1.121-3.013 1.711.642 1.087 1.284 2.173 1.94 3.247.015-.012-.011.015-.027.372.686 1.11 1.387 1.862 2.315 2.695.48.319.582.611.295 1.196 1.248 3.089 2.735 5.937 4.326 9.098.08.747.056 1.183-.25 1.923-1.525 6.406-.085 12.614-3.235 18.864-2.731 5.42 1.279 8.962 9.675 10.742-.09.058.076-.078.053.272 3.365 2.749 6.752 5.147 10.015 7.642-.124.097.127-.105.063.258 2.911 3.196 5.886 6.03 8.828 8.897-.033.034.022-.04-.004.334 3.206 6.551 6.566 12.664 9.635 18.92 3.11 6.34 5.275 12.935 3.867 20.861l-8.033-8.262-1.345.406c0 3.124-.133 6.259.127 9.36.046.541 1.753.942 2.705 1.41.013.004.001.028-.025.444.132 1.396.245 2.386.457 3.354 1.185 5.391 2.776 10.728 3.47 16.18.529 4.148-1.82 6.824-6.345 5.97-3.329-.629-6.48-2.432-9.807-2.769-4.068-.411-5.27-2.611-5.767-6.084-.486-3.389-1.229-6.741-1.926-10.5-.042-1.448-.016-2.505.29-3.86.675-5.8 1.681-11.436-3.2-16.152-.091-1.087-.104-1.817.147-2.795-.864-3.115-1.993-5.982-3.194-9.081-.07-.233-.086-.72-.058-1.136-1.049-4.147-1.981-7.93-3.312-11.568-.306-.838-2.23-1.858-2.961-1.587-1.12.415-2.778 2.093-2.6 2.864 1.326 5.75.722 12.219 5.743 17.127.107 1.43.137 2.475-.115 3.769 1.143 11.893 2.76 23.533.659 35.433-5.026-.685-7.85-2.568-7.606-8.284.26-6.074-.337-12.218-1.006-18.282-.231-2.096-1.802-4.044-2.9-6.305-.383-.752-.626-1.258-.742-2.02-3.417-1.668-4.623.236-5.15 3.343-.289 1.707-.481 3.604-1.367 5.005-2.41 3.814-2.392 6.92.517 10.725 1.4 1.83.97 5.267.87 7.957-.06 1.582-1.1 3.128-1.843 5.067-7.305-.741-15.397-1.824-23.525-2.3-6.264-.369-12.79-.999-18.818.286-13.94 2.97-28.468.692-42.149 5.235-2.914.968-5.812 1.988-8.724 2.974-.008-.01.008.008-.45-.035-3.261-.006-6.119-.284-8.842.198-1.356.24-2.465 1.872-3.7 2.85-.015-.023.027.015-.314-.03-1.135.29-1.928.627-3.037 1.044-.748.078-1.18.076-1.832-.202-2.784.801-5.349 1.88-8.262 3.05-1.068.123-1.787.155-2.72-.076-2.44.83-4.664 1.923-7.203 3.087-.744.085-1.173.1-1.951.07-1.142.322-1.936.687-2.877 1.136-.147.083-.484.075-.85.01-1.26.514-2.154 1.092-3.354 1.746-.724.113-1.142.15-1.792-.076-3.762 1.269-7.292 2.8-10.931 4.428-.109.1-.402.107-.824.012-4.662 1.803-8.902 3.702-13.384 5.725-.598.175-.954.226-1.727.206-5.5 1.09-10.778 1.855-14.324 6.797-.696.144-1.103.184-1.668-.101-1.72-2.519-3.28-4.713-4.912-7.289-.094-1.419-.117-2.455.153-3.758.294-7.94.294-15.613.294-23.478-4.468.003-6.556 1.137-6.499 4.827.052 3.314.027 6.628.042 10.404.018 6.066.03 11.67-.028 17.702-.347 2.902-.626 5.376-.921 7.809-.016-.04-.022.046-.408-.01-3.033.706-5.68 1.467-8.125 2.17-2.823-20.228 1.558-39.461 6.646-58.585.685-2.574 1.116-4.844-2.022-5.333-2.617-.408-5.047 4.58-4.05 8.066-.126.727-.247 1.135-.74 1.565-4.236 1.114-4.21 3.347-2.184 6.482-.095.72-.18 1.127-.59 1.69-1.26 1.438-2.742 2.61-3.029 4.024-1.074 5.297-1.899 10.656-2.553 16.023a385.65 385.65 0 0 0-1.845 19.218c-.132 1.857.508 3.77.85 5.978-.002.75-.061 1.18-.43 1.789-2.367 3.46-4.423 6.74-6.549 9.983-.069-.038.07.022-.33-.036-2.37.63-4.295 1.516-6.319 1.953-2.387.516-4.858.642-7.373.587-.141-1.066-.203-1.781-.165-2.877.092-1.164.083-1.948.375-3.018.115-4.442-.07-8.598-.243-13.14-.048-1.151-.108-1.916-.109-2.91.06-.227.222-.67.482-.888 3.073-6.135 5.887-12.052 9.204-19.027-9.528 2.44-9.681 11.939-17.222 16.74 1.11-3.496 1.79-5.672 2.49-7.841 1.698-5.256 3.404-10.51 5.124-15.986.018-.222.226-.616.57-.674 1.296-.943 2.476-1.68 3.15-2.74 1.67-2.628 2.927-5.528 4.683-8.09 2.864-4.182 6.069-8.13 8.983-12.278 2.053-2.924 3.894-6 5.776-9.04 3.195-5.163 6.428-10.225 14.18-8.805 1.113.118 1.853.21 2.696.655 7.01 4.055 14.206 2.53 21.203 1.026 1.816-.39 3.112-3.194 4.71-4.862.061.027-.062-.011.33.04 3.245-.033 4.048-1.585 3.484-4.16.075.006-.054-.074.318 0 3.182-.784 3.769-2.346 1.898-4.708.016-.017-.03-.023-.094-.286-.383-.389-.702-.515-1.163-.586-.142.055-.44 0-.854-.07-2.75-.292-4.166.45-3.936 3.414-3.06 1.408-5.845 2.95-8.817 3.537-7.15 1.41-13.993.386-20.122-3.99-.01-.074-.157-.051-.272-.353-3.62-4.155-5.677-8.503-5.115-13.895.13-1.234-.414-2.538-.547-4.17 0-.816-.102-1.273.076-1.93 2.684-9.188 5.087-18.174 7.495-27.175-.76.324-2.14.914-3.786 1.522-.476.292-.685.564-.872.885.021.048-.042-.038-.384-.043-1.104.672-1.864 1.35-2.603 2.062.02.033-.03-.03-.43-.042-2.484-.747-5.59 3.5-6.673-1.61 3.921-4.183 8.442-7.535 10.266-13.396-7.756 3.242-14.852 6.207-22.243 9.134-.494-.048-.692-.058-.89-.068m192.019 9.009s.02.07.723.101c1.1-1.03 2.2-2.06 3.89-3.413 2.756-3.263 6.05-6.213 8.164-9.85 5.613-9.652 2.134-19.928-5.687-26.05-5.681-4.446-20.18-4.453-28.592 1.973-14.541 11.109-26.347 24.8-35.744 40.5-3.098 5.177-2.516 5.828 3.497 6.067 11.924.473 23.321-2.337 35.521-5.153 3.657-.04 7.232-3.594 11.031-.257.189.166 1.296-.716 2.593-1.2.506-.349 1.01-.697 2.19-.92.82-.581 1.64-1.162 2.414-1.798m-94.525 18.983c.501.023 1.002.046 2.016.605 5.267-1.163 10.56-2.23 15.774-3.593.785-.205 1.206-1.8 2.4-2.962.424-.004.85-.008 1.674.47A1155 1155 0 0 1 343 368s-.005-.009.686-.079c2.044-4.733-1.218-6.388-4.866-8.156 0 0-.043-.312.047-1.105-1.106-.813-2.211-1.626-3.685-2.57-.232-.153-.367-.367-.279-1.421-5.26-8.011-12.583-13.17-21.833-15.695 0 0-.014-.083-.122-.788-2.368-1.555-4.548-3.636-7.14-4.562-6.348-2.27-13.1-1.491-19.07.699-3.223 1.183-8.284 2.44-8.74 7.68 0 0 .052.042-.713.004-1.056 1.37-2.111 2.739-3.257 3.982 0 0 .102.12-.63.147-.811 1.933-1.621 3.867-2.464 6.324-.054.166-.108.332-.851.65-1.028 2.464-2.804 4.883-2.958 7.4-.832 13.63 6.923 19.22 18.359 22.221 5.62 1.476 11.171-.453 16.208-4.937.722-.071 1.444-.142 2.969.105 1.442 0 2.883.001 4.754.561 2.188-.5 4.377-1 6.367-1.594 0 0 .031-.216.71.113z"/>
        <path fill="#03D299" d="M235.988 109c-.451-.036-.903-.072-2.097-.082-4.658.701-8.573 1.377-12.488 2.05-15.633 2.688-31.268 5.367-46.9 8.065-9.76 1.685-19.594 3.044-29.254 5.186-13.094 2.904-24.005 10.038-34.131 18.867-3.32-2.304-5.262-1.993-7.548 1.387-4.233 6.259-6.55 13.79-12.458 18.935-.359.312-.777.83-.771 1.246.054 3.964.33 7.929.248 11.888-.038 1.837-.538 3.727-1.156 5.478-1.848 5.24-5.664 9.309-5.642 15.757.307 90.912.179 181.824.252 272.736.008 9.781.634 19.562.936 29.343.067 2.161.173 4.357-.14 6.477-.135.907-1.171 1.874-2.047 2.393-.419.247-1.85-.29-2.089-.809-2.198-4.79-7.281-8.394-5.788-14.75.52-2.209.44-4.873-2.993-5.662.002-6.467.01-12.468.37-18.538 2.447-1.799 2.45-3.153-.367-4.467-.004-6.466.005-12.465.368-18.533 2.446-1.799 2.45-3.153-.368-4.468-.004-6.799.005-13.132.356-19.522 2.375-1.566 1.9-2.493-.356-3.477-.004-6.8.005-13.132.356-19.523 2.375-1.566 1.9-2.493-.356-3.477-.004-6.8.005-13.132.356-19.523 2.375-1.566 1.9-2.493-.356-3.477-.004-6.8.005-13.132.356-19.523 2.375-1.566 1.9-2.493-.356-3.477-.004-6.8.005-13.132.356-19.523 2.375-1.566 1.9-2.493-.356-3.477-.004-6.799.005-13.132.368-19.533 2.446-1.799 2.45-3.153-.368-4.467-.003-6.466.005-12.465.368-18.533 2.446-1.799 2.45-3.153-.368-4.467-.003-6.466.005-12.465.368-18.533 2.446-1.798 2.45-3.153-.367-4.467-.004-6.466.004-12.465.367-18.533 2.446-1.799 2.45-3.153-.367-4.467-.004-6.466.004-12.465.367-18.533 2.446-1.799 2.45-3.153-.367-4.463-.004-4.798.005-9.134.367-13.53 3.797-3.58 5.767-7.117 2.81-12.24-1.101-1.907-1.158-5.574-.02-7.394 3.16-5.052.898-8.179-2.716-11.682 3.722-9.265 7.058-18.412 11.503-26.984 2.918-5.627 7.44-10.422 11.242-15.59 0 0-.09-.073.278-.065 2.398-2.013 4.428-4.033 6.457-6.053 0 0 .102.049.475.021 5.188-3.305 10.002-6.583 14.817-9.86 0 0-.145-.052.292-.007 2.341-.939 4.246-1.922 6.15-2.906 0 0 .256.058.734-.03 16.902-3.446 33.333-6.762 49.741-10.188 4.603-.961 9.138-2.245 13.705-3.38.546.132 1.093.265 2.267.444 19.037-3.258 37.428-6.671 55.862-9.837 17.621-3.025 35.301-5.703 52.924-8.717 7.124-1.219 14.164-2.926 21.242-4.411.74.02 1.479.039 2.997.044a734.198 734.198 0 0 0 16.943-2.747c15.495-2.684 30.978-5.431 46.482-8.059 7.156-1.212 14.35-2.203 21.733-3.046 1.095-.01 1.984-.268 3.116-.671.614-.189.985-.233 1.597.115 3.292.474 6.376.881 9.389.578 10.177-1.024 20.194-5.59 30.579-1.32 3.747 1.541 7.401 3.305 11.117 4.971.02.005.036.041.022.404 2.313 3.445 4.64 6.526 6.58 9.746-7.59 1.235-14.81 2.222-21.988 3.45a4760.773 4760.773 0 0 0-48.828 8.596c-3.666.667-7.234 1.874-11.242 2.788-1.439.08-2.483.204-3.937.25-4.489.876-8.568 1.831-12.648 2.786-.744-.02-1.488-.04-3.014-.057-9.264 1.382-17.747 2.758-26.229 4.14-15.165 2.473-30.344 4.868-45.492 7.45-12.85 2.19-25.674 4.544-38.49 6.93-7.605 1.414-15.171 3.03-22.755 4.557z"/>
        <path fill="#04D198" d="M301.925 177.868c-.408-.07-.815-.14-1.682-.573-7.09-.024-13.72.316-20.756.622-1.758.034-3.112.1-4.73.132-.52.192-.774.42-1.37.71-.997.274-1.652.487-2.629.618-.758-.036-1.196.01-1.948-.028-1.249.425-2.182.933-3.454 1.417-1.012.049-1.686.121-2.572.028-1.18.295-2.147.755-3.312 1.44.381 2.066.96 3.906 1.182 5.79-1.998-.091-3.64-.228-5.639-.667-4.984-1.47-9.628-2.905-14.272.47-.596-.032-.934-.098-1.609-.374-.591-.279-.845-.348-1.445-.572-2.35-.673-4.667-2.37-5.589 1.212-.008-.019-.042.006-.328-.016-.757.244-1.228.51-2.096.887-7.675 2.611-15.387 4.285-22.123 7.82-8.939 4.69-17.114 10.834-26.07 16.647.552-3.043.98-6.07 1.674-9.036.694-2.97 1.653-5.879 2.495-8.815l-.935-1.166c-4.283 2.173-8.565 4.346-13.068 6.512-.22-.007-.612.19-.973.143-5.215 3.196-10.07 6.438-14.787 9.76.138.08-.128-.097-.471-.077-1.513 1.032-2.683 2.045-4.023 3.088-.17.03-.38.304-.632.313-.41.288-.566.568-.745.844-.023-.002-.013.042-.361.102-2.396 1.573-4.443 3.087-7.403 5.276-.194-2.684-.675-4.319-.357-5.78 1.634-7.515 3.473-14.986 5.521-22.629 1.073-1.405 1.864-2.653 2.935-4.038 1.068-1.067 1.857-1.998 2.949-3.067 2.162-1.987 4.023-3.835 6.243-5.731 3.355-1.446 6.223-3.342 9.37-4.141 7.192-1.827 14.52-3.118 21.793-4.625 7.102-1.471 14.204-2.94 21.702-4.358 1.448-.027 2.502-.106 3.97-.107 4.821-.927 9.228-1.932 13.96-2.874.758-.004 1.192-.072 2.043-.039 13.768-2.242 27.11-4.638 40.473-6.913 17.617-3 35.265-5.828 52.872-8.89 6.81-1.185 13.543-2.81 20.677-4.177 1.097-.01 1.83-.077 2.991-.062 16.374-2.703 32.309-5.552 48.267-8.26 20.375-3.457 40.784-6.714 61.147-10.238 7.117-1.232 14.14-3 21.576-4.481 1.104-.023 1.84-.087 3.005-.07 7.416-1.099 14.369-2.59 21.4-3.367 6.626-.733 13.334-.875 20.01-.986 8.25-.138 14.374 5.008 21.03 9.196.487.588.907.907 1.38 1.436.219.508.466.618.915.706.119.167.511.282.592.6 1.01 1.167 1.94 2.015 2.869 2.863 0 0 .055-.004.072.276.2.642.383 1.005.555 1.613.164.587.44.72.792.669-.023.025.022.076.058.393.096.947.156 1.576.144 2.622.284 3.838.64 7.26.995 10.684l-1.68.804-14.383-7.733c.413 2.01.637 3.102.516 4.228-1.79-.577-3.238-1.19-4.637-1.822.047-.02.033-.12-.086-.457-2.587-1.264-5.055-2.193-7.755-3.409-4.863-1.104-9.495-1.921-14.126-2.738l-.539 1.6c1.99 2.125 3.98 4.25 6.066 6.647.511.657.926 1.043 1.383 1.632.043.203.24.569.226.83.249.464.513.664.793.84.016-.024-.03.012-.038.37.946 2.2 1.9 4.042 2.886 6.162.148.63.264.982.318 1.73.369 1.815.8 3.232 1.23 4.649-.013.795-.025 1.59-.445 2.874-1.573.38-2.74.27-3.92.175-.014.014.02-.004-.024-.274-.367-.38-.692-.49-1.346-.704-1.767-.737-3.203-1.37-4.78-2.197-.322-.467-.554-.683-.853-.831-.014.012.02.008.023-.34-2.04-1.39-4.082-2.431-6.327-3.55-.204-.078-.638-.108-.827-.41-5.404-2.007-10.619-3.712-16.18-5.472-1.277-.066-2.207-.077-3.427-.288-8.685-2.513-17.038-2.381-25.654.21-.71.013-1.116.055-1.79-.006-.453-.15-.639-.195-.893-.582-3.537-1.594-9.46.549-10.904 3.532-.033-.034.057-.003-.299-.022-1.122.376-1.89.77-2.643 1.106.013-.058.113.005-.275-.045-2.71-.139-5.032-.227-7.61-.574-5.916-.921-11.5-1.09-16.946 2.247-7.349 2.425-14.307 4.82-21.623 7.19-1.925.879-3.492 1.78-5.222 2.725-.161.042-.427.245-.786.252-2.46 1.342-4.562 2.676-6.645 4.03.019.02-.017-.022-.382-.022-4.794 2.997-9.223 5.993-13.98 9.035-1.748 1.376-3.167 2.707-4.602 4.023-.017-.015.013.018-.3.102-1.138.994-1.964 1.904-2.757 2.85.034.036-.023-.042-.365-.008-2.793 2.703-5.243 5.37-7.785 8.151-.092.113-.133.4-.474.49-2.641 3.06-5.06 4.034-8.597 1.598-2.633-1.814-5.81-2.839-8.88-4.315-.135-.1-.466-.161-.565-.494-1.521-.985-2.944-1.637-4.538-2.378-.17-.087-.551-.134-.675-.457-7.11-3.069-14.095-5.815-21.08-8.558-.001.005.007.002-.166-.297-1.066-.408-1.96-.518-3.218-.7-1.109-.066-1.852-.06-2.78-.21-.762-.079-1.337 0-1.912.08z"/>
        <path fill="#FDFEFD" d="M137 561c-1.389 0-2.778 0-4.69-.26-.786-.752-1.048-1.246-1.31-2.115 0-1.125 0-1.875.297-2.919.432-1.605.68-2.915.687-4.227.351-74.529.627-149.059 1.043-223.587.166-29.624.783-59.245.906-88.87.055-13.12-.585-26.246-.98-39.368-.027-.9-.642-1.781-.98-3.04.669-1.788 1.335-3.207 2.36-4.563 2.136 3.362 3.915 6.662 5.69 10.429-.005 6.809-.007 13.15-.056 19.88-.02 6.806.006 13.223.033 19.64-1.333 2.413-3.8 4.814-3.825 7.24a4392.98 4392.98 0 0 0-.029 82.609c.027 3.014 2.037 6.01 3.49 9.464.372 1.21.38 1.973.387 3.201.004 71.47.007 142.473-.314 213.518-1.12 1.018-1.914 1.993-2.709 2.968z"/>
        <path fill="#FCFFFE" d="M532.995 277.995c.226-2.811 7.31-11.291 10.053-11.785.824-.149 2.425.245 2.571.725.866 2.845 2.88 3.65 4.76 1.855 1.203-1.148 1.184-3.705 1.42-5.666.079-.657-1.102-1.438-1.072-2.135.038-.908.535-2.418 1.133-2.583 5.929-1.632 11.34 2.308 12.102 8.673.137 1.15.025 2.329.04 3.494.092 7.454 3.813 10.52 11.192 9.207.945-.168 1.873-.431 3.337-.774v10.59c-.76.035-1.415.198-2.007.07-9.058-1.956-12.318.5-12.488 9.858-.162 8.986-.317 17.991.112 26.96.16 3.324 1.55 6.829 3.262 9.73.744 1.26 3.695 1.5 5.686 1.654 1.682.129 3.424-.538 5.572-.932v8.83c-4.118.687-9.564-.017-11.454 2.247-3.955 4.737-3.714 11.44-3.166 17.606.478 5.384 4.915 7.14 14.434 5.661v9.65c-3.844.389-7.912.06-11.243 1.471-1.498.635-2.032 4.731-2.105 7.283-.136 4.714 3.93 6.092 13.335 4.582v10.26c-.591.066-1.242.299-1.82.18-9.24-1.914-12.54.58-12.613 10.109a3599.304 3599.304 0 0 0-.003 50.437c.052 8.088 3.707 10.994 11.612 10.154 1.01-.108 2.89 1.535 3.2 2.682.533 1.97.147 4.19.147 6.188-1.054.329-1.574.691-1.964.583-5.6-1.56-10.552-1.946-12.062 5.55-.19.941-1.483 1.66-2.87 2.537-.775.054-.945.055-1.127-.413 0-30.824.01-61.178.39-91.606 2.332-2.302 2.727-4.335-.384-6.394-.004-5.823.005-11.178.384-16.605 2.333-2.303 2.727-4.335-.384-6.396-.017-10.1-.023-19.73-.022-29.36 0-24.575.038-49.149-.076-73.723-.006-1.469-1.213-2.932-1.86-4.398-1.066.921-2.131 1.843-3.512 2.88-3.17 2.875-6.022 5.636-8.874 8.398l-.825-2.07c-2.07.12-4.351-.267-6.159.485-2.372.987-4.371 2.87-6.56 4.34l-.092-.09zM140 242.469c-.027-6.886-.053-13.303.285-19.962 6.287.978 7.488-3.912 9.72-7.468 0 0-.01-.044.23-.112.518-.233.698-.471.78-.783 0 0 .21-.274.786-.247 1.704-1.037 2.832-2.1 3.96-3.165 0 0 .266.177.517.177 3.174-1.49 6.245-2.754 8.97-4.545 2.15-1.413 3.875-3.474 5.789-5.248 0 0 .393-.197.893-.118.693.107.884.135 1.074.535 1.193 4.278 1.59 8.794 6.99 9.864.001 6.583 3.904 4.18 6.992 3.572-2.512 2.233-4.784 4.9-7.655 6.477-1.092.6-3.67-1.118-5.379-2.11-4.003-2.322-7.693-5.305-11.9-7.11-2.494-1.068-4.937.73-4.8 3.974.263 6.302-2.54 8.145-9.536 4.972-.6 4.961-1.617 9.578-1.641 14.2-.15 28.65-.075 57.302-.075 85.953 0 1 .317 2.146-.065 2.969-.867 1.867-2.079 3.576-3.15 5.349-.928-1.75-2.63-3.487-2.66-5.252-.227-13.322-.125-26.65-.125-39.976v-41.946zM385.026 83.271c1.044-.123 2.088-.247 3.583.037 1.77 3.437 3.693 3.072 6.04 1.564 1.638-1.052 3.395-2.234 5.245-2.584 6.7-1.27 13.462-2.207 20.199-3.28 14.424-2.3 28.854-4.565 43.264-6.95 2.545-.42 4.966-1.699 7.511-1.98 7.002-.777 7.582-1.749 4.124-8.074 2.4.924 5.274 1.323 7.05 2.934 1.462 1.325 2.702 4.549 2.049 6.083-.643 1.51-3.722 2.463-5.856 2.759-4.58.634-9.24.687-13.866.978l-.127 2.228c2.973.34 5.946.682 9.263 1.417-2.605.966-5.675 1.19-8.476 2.176-7.151 2.517-14.356 4.292-22.36 3.494-.77 1.041-1.185 2.037-1.585 2.992.016-.041.03.045-.441-.015-3.699-.053-6.956-.293-10.14.085-1.272.151-2.381 1.668-3.874 2.685-.966.196-1.622.27-2.645.27-1.24.225-2.113.522-3.348.917-1.11.077-1.856.055-2.881-.265-5.77.215-11.263.729-16.927 1.018-.732.25-1.293.725-2.282 1.207-4.14.681-7.852 1.355-11.922 2.031-1.432.31-2.504.617-3.84.933-.438.004-.614-.001-.79-.006-.132-3.267 2.144-3.662 4.605-3.934 1.702-.188 3.387-.524 5.393-.844-1.714-5.452-5.03-4.903-8.668-4.183.526-1.582 1.114-2.637 1.702-3.693z"/>
        <path fill="#DAFDF9" d="M140.033 557.99c-.003-71.003-.006-142.007.337-213.521 1.747-.211 3.275-.174 4.524.435 4.567 2.226 9.03 4.666 13.58 6.926.275.136.978-.59.492-.276-.508-3.22-2.052-6.934-1.046-7.85 2.39-2.177 5.457-1.176 8.5.715 2.3 1.43 5.667 1.146 8.56 1.624.098.317.281.572.861 1.263 3.928.895 7.543 1.294 11.159 1.692.435.008.87.015 1.676.36 1.356 1.097 2.34 1.855 3.325 2.613 3.693.006 7.385.01 11.926.014 1.938-.99 3.026-1.978 4.115-2.965 1.056-.003 2.11-.007 3.896-.017 1.173-.013 1.618-.02 2.063-.028.896.208 1.793.415 2.888 1.114.197.492.176.891-.216.957-20.153 5.758-38.842 1.246-57.763-5.495l8.666 10.146-.516 1.23c-8.58-1.805-16.44-5.68-24.683-10.627-.284 2.94-.66 5.025-.662 7.111-.041 65.127-.198 130.255.084 195.38.05 11.61 4.505 21.974 14.134 29.735.157.63.26.986-.009 1.367-2.39-1.574-4.703-2.919-6.363-4.831-2.435-2.807-4.402-6.02-6.565-9.455-.656-1.812-1.314-3.23-1.976-4.98-.33-1.102-.658-1.87-.987-2.637z"/>
        <path fill="#FCFFFE" d="M189.153 289.921c-1.21-.37-2.971-.358-3.538-1.174-3.086-4.444-5.866-9.1-8.783-13.662-.43-.672-.952-1.33-1.568-1.826-1.695-1.363-4.778-2.479-4.957-3.974-.551-4.603-.019-9.338.125-14.02.087-2.835.357-5.67.307-8.5-.028-1.594-.541-3.178-1.05-5.925 5.31-.326 10.613.572 14.736-1.23 4.615-2.017 10.714 1.949 14.124-3.919.349-.6 3.426-.513 3.51-.234 1.618 5.463 5.58 3.036 8.88 2.836.262-.016.546.33.817 1.072-.904.928-1.804 1.294-3.11 1.625-1.483.04-2.562.116-4.036.106-2.096.371-3.796.826-5.879 1.21-1.135.06-1.889.191-2.942.163-1.197.366-2.095.891-3.405 1.403-5.733 1.052-11.054 2.117-16.72 3.168-2.437 1.03-3.125 2.757-.294 2.847 4.012.129 8.06-.909 12.495-1.41 2.823.02 5.244 0 7.927.27 7.597.534 14.933.779 22.662 1.071 1.45.1 2.505.152 3.517.567-2.365 1.421-4.687 2.479-7.43 3.603-13.163 2.45-25.906 4.832-38.648 7.217-3.108.582-3.347 2.359-1.723 4.605 4.31 5.967 8.711 11.87 13.015 18.173.615 2.23 1.291 4.084 1.968 5.938zM277.089 247.92c6.863.904 12.849-.849 18.084-5.51 3.89-3.463 11.049-2.921 16.96.175 2.729 1.43 6.088 2.101 9.204 2.253 6.728.326 13.483.127 20.227.068 1.46-.013 2.96-.183 4.368-.556 3.94-1.045 7.968-1.92 11.725-3.445 4.97-2.017 12.683-.369 12.81-9.422.035-2.42 2.424-3.446 4.227-1.143 2.196 2.802 4.661 2.624 7.955 1.7.466.059.65.227.67.45.021.22.036.666-.242.725-.583.282-.889.506-1.538.798-2.514 1.473-4.519 3.336-6.887 4.203-8.484 3.104-17.091 5.871-26.011 8.701-1.454.335-2.547.733-4.075 1.061-14.009-.735-27.583-1.4-41.158-2.065 3.595 4.478 8.73 5.45 13.606 7.018 3.805 1.223 7.53 2.695 10.85 4.048-8.334.376-16.31 1.648-24.1.92-9.593-.898-18.991-3.567-26.825-9.822.05-.054.15-.157.15-.157zM391.985 164.942s.266-.203.812-.13c2.096-.89 3.646-1.853 5.195-2.816 6.958-2.395 13.916-4.79 21.67-7.114 2.131.178 3.468.286 5.155.422-.798 1.469-1.363 2.507-2.22 3.72-5.04 4.446-9.788 8.717-14.887 13.024-.813.997-1.274 1.96-1.722 2.937.013.014-.021-.004-.271.078-.388.39-.524.7-.688.975-.028-.033.044.015-.315.058-1.054 1.47-1.75 2.896-2.477 4.48-.031.155-.223.409-.543.464-.826.692-1.33 1.328-1.836 1.964-.952-.983-2.207-1.817-2.787-2.985-.926-1.866-1.405-3.954-2.073-5.948l-1.3.37v5.787c-6.196-1.112-12.065-2.166-18.186-3.542 1.26-1.265 2.864-2.089 4.264-3.176 1.814-1.408 3.466-3.025 5.188-4.553 0 0 .036.042.393.045 2.448-1.352 4.538-2.706 6.628-4.06zM525.97 209.944c1.455 2.975 1.883 5.628-1.689 7.596-.893.492-1.455 1.774-1.93 2.804-2 4.343-3.04 8.963-7.76 11.943-2.955 1.867-2.35 5.84.018 8.81 4.368 5.478.634 18.277-6.15 19.293-4.82.723-9.929-.473-15.184-1.434-.27-1.063-.265-1.506-.035-2.183 1.05-.487 1.874-.739 2.862-.707 2.19-1.17 4.219-2.624 6.842-4.504-5.181-2.63-3.807-6.254-3.02-9.7.079.036-.078-.02.298.034 1.101-.675 1.825-1.404 2.662-2.014.112.12-.117-.116.242-.074 3.51-3.955 6.662-7.95 9.879-12.278a58.788 58.788 0 0 1 3.398-5.552c.471-.311.618-.58.634-.946-.017-.036.031.029.389-.02.733-1.094 1.109-2.139 1.528-3.498.431-1.026.818-1.738 1.607-2.473.948-1.59 1.493-3.158 2.027-4.832-.013-.107.026-.318.445-.282 1.258.03 2.098.023 2.938.017z"/>
        <path fill="#11CD9B" d="M243.988 322.039c-.427.029-.854.058-1.965.08-2.322.138-3.959.284-6.8.539l4.406-3.985c.301.09.609.12 1.424.126 1.995-.888 3.487-1.81 4.981-2.76.002-.027.03.02.384.047 2.098-1.003 3.841-2.033 5.587-3.072.002-.01.02 0 .361.015 1.792-.99 3.243-1.996 4.98-3.04.729-.376 1.173-.716 1.944-1.055.871-.604 1.414-1.209 2.22-1.863.696-.336 1.13-.623 1.908-.955 2.875-2.323 5.407-4.6 8.638-7.507-2.261 0-3.165 0-4.005-.329 1.873-1.103 3.636-2.207 5.513-2.455.582-.077 1.503 2.152 2.213 3.359 1.022 1.737 1.861 3.597 3.013 5.24 2.68 3.82 3.758-.092 5.482-1.166.462-.288 1.276-.013 1.89.328-.138.969-.236 1.613-.333 2.256 0 0 .14.164-.264.132-1.99 2.357-3.576 4.746-5.163 7.134-.164.351-.329.702-.818 1.516-2.076 3.765-3.826 7.067-5.577 10.368l-.302.205c-2.658 5.572-5.026 10.947-7.394 16.322 0 0-.423-.057-.643-.386-.396-1.598-.572-2.867-.748-4.137.083-.73.167-1.459.49-2.787.97-3.153 1.7-5.708 2.43-8.263.097-.41.195-.818.583-1.724 1.033-2.416 1.777-4.337 2.52-6.257 0 0 .188-.32.49-.71 1.697-3.182 3.094-5.973 4.491-8.765l-.925-.901-4.589 2.786c-.708.334-1.417.668-2.588 1.263-.886.637-1.308 1.014-1.73 1.391 0 0-.065-.028-.421-.03-1.829.945-3.301 1.892-4.774 2.839 0 0 .007.103-.39.036-2.466.953-4.536 1.972-6.605 2.991 0 0-.002.119-.408.035-3.44.99-6.473 2.065-9.506 3.139z"/>
        <path fill="#DAFDF9" d="M514.161 100.179c-.309.75-.618 1.5-1.39 2.567-1.566.627-2.668.94-4.07 1.269-.768.333-1.239.649-2.041.968-.774.003-1.216.003-1.978-.138a31.21 31.21 0 0 0-4.057-.793c-10.737 4.122-21.694 4.99-33.03 6-3.401.799-6.417 1.542-9.374 2.476-1.04.328-2.38 1.863-2.828 1.593-6.058-3.641-10.483.89-15.805 2.856-1.455 0-2.514-.002-3.834-.28-1.402-.365-2.58-.686-3.674-.506-6.09 1.004-11.586 5.306-18.286 3.264-.319-.097-1.195 1.637-2.264 2.521-3.477.005-6.502.007-9.903.009a94.832 94.832 0 0 0-2.973.038c-1.448.346-2.551.661-3.992.978-1.116.327-1.895.652-2.97 1-.764.335-1.234.647-2.102.963-1.463.008-2.527.013-4.02.018-4.148.997-7.866 1.994-11.915 2.992-.772.006-1.214.012-2.015.01-1.143-.686-1.928-1.366-2.461-2.32 14.507-2.938 28.74-5.74 43.026-8.23 20.02-3.49 40.094-6.678 60.122-10.133 13.823-2.384 27.606-5 41.517-7.417.108.095.317.295.317.295z"/>
        <path fill="#ECFEFD" d="M319.854 67.816c-6.876 1.764-13.916 3.471-21.04 4.69-17.623 3.014-35.303 5.692-52.924 8.717-18.434 3.166-36.825 6.58-55.585 9.77-.35-.429-.349-.741.026-1.524 1.472-.803 2.57-1.136 3.669-1.47 3.811-.471 7.623-.943 12.06-1.739A889.815 889.815 0 0 0 212 83c2.713.332 5.425.663 8.965.994 7.119-1.374 13.42-2.71 19.688-4.186.563-.132.91-1.18 1.358-1.801 6.41-.333 12.833-.533 19.227-1.075 2.033-.172 3.989-1.253 6.793-1.925 4.534-1.337 8.254-2.667 11.974-3.997 4.39.001 8.778.003 13.949-.045 7.716-4.121 15.777-1.812 23.047-3.979.884.184 1.768.367 2.853.83z"/>
        <path fill="#DAFDF9" d="M173.006 201.16c-.192-.027-.383-.055-.856-.155 4.002-2.245 8.284-4.418 12.567-6.591l.935 1.166c-.842 2.936-1.8 5.845-2.495 8.815-.693 2.966-1.122 5.993-1.675 9.036 8.957-5.813 17.132-11.957 26.07-16.647 6.737-3.535 14.45-5.209 22.406-7.772 1.153-.346 1.627-.63 2.1-.913 0 0 .034-.025.456.049 2.097-.038 3.773-.15 5.71-.202.59-.056.92-.17 1.248-.283.337.066.675.132 1.65.274 5.175-.041 9.712-.16 14.248-.278 1.643.137 3.286.274 5.631.544 7.094 2.364 13.485 4.595 19.456 6.842-5.433-1.33-10.446-2.676-15.46-4.021-6.353-.014-12.707-.028-19.904-.041-1.593 0-2.342-.001-3.092-.002-4.688.015-9.375.03-14.866.188-8.697 3.606-16.753 6.752-24.42 10.66-3.938 2.007-7.184 5.374-10.743 8.127-1.638 1.446-3.277 2.892-4.951 4.676-3.123.944-7.026 3.348-7.02-3.666.013-1.652-.044-2.482.033-3.3.783-8.288.789-8.288-7.028-6.506z"/>
        <path fill="#0BCD98" d="M512.031 185.96c.436.038.871.077 1.984.148 2.112.636 3.547 1.24 4.982 1.843 0 0-.024.025-.443.051-6.028 1.382-11.79 2.3-17.207 4.2-7.24 2.54-14.212 5.84-21.318 8.8-.019-.013-.031.03-.277-.012-.246-.043-.714.13-1.011.103-.712.327-1.126.683-1.84 1.141-.802.475-1.306.847-2.046 1.16-.585.036-.805.258-1.163.651-.524.282-.782.522-1.336.77-.646.186-.996.363-1.56.534-.53.118-.659.347-.879.863-.835.555-1.388.93-2.135 1.259-.448.088-.605.295-.7.558-.035-.018-.04.058-.353.072-.715.118-1.118.222-1.578-.077a95.359 95.359 0 0 0-1.54-4.142c-3.587 0-6.127 0-8.613-.199.055-.198.043-.61.34-.602.766-.323 1.233-.654 2.06-.998 1.988-.88 3.615-1.745 5.49-2.612.586-.073.866-.24 1.464-.505 5.813-2.325 11.25-4.648 17.011-6.952.746-.064 1.168-.148 1.97-.176 2.836-.878 5.293-1.813 8.112-2.725 1.08-.079 1.798-.18 2.94-.19 6.165-.928 11.906-1.946 17.646-2.964z"/>
        <path fill="#FCFFFE" d="M336.393 190.722s.33.06.503.513c2.49 2.212 4.809 3.974 7.117 5.748l-.033.038c-6.43-1.411-12.593-.385-19.094.484-7.208.964-14.898-1.672-22.377-2.74l-.234-1.734 19.746-2.827-4.633-5.364c-4.299 6.386-8.53-.42-13.227 1.107.775-2.206 1.302-3.708 2.052-5.69.498-.668.687-.922 1.164-1.222 1.128 0 1.88-.019 2.631-.037 0 0-.008.003.043.366a191.002 191.002 0 0 0 14.376 6.483c2.18.876 4.514 1.366 6.778 2.03 0 0 .38.047.624.495 1.683 1.083 3.123 1.716 4.564 2.35zM192.174 210.243c3.357-3.04 6.603-6.407 10.541-8.414 7.667-3.908 15.723-7.054 23.955-10.637 1.789.986 3.12 2.785 4.714 3.06 3.779.654 5.26 2.294 4.091 6.712-4.51-.82-9.006-1.448-13.403-2.494-4.413-1.049-7.527.007-10.348 3.772-2.406 3.21-5.773 5.701-9.258 9.03.062.47.937 2.484.306 3.24-1.504 1.803-3.59 3.936-5.68 4.228-2.635.369-4.585-1.46-3.632-4.9.258-.931-.69-2.197-1.286-3.597z"/>
        <path fill="#ECFEFD" d="M408.004 54.039c-7.176 1.091-14.37 2.082-21.526 3.294-15.504 2.628-30.987 5.375-46.482 8.059-5.384.932-10.775 1.823-16.587 2.64-.423-.094-.424-.576-.096-.836a745.275 745.275 0 0 0 2.693-2.193c4.029-.341 8.058-.683 12.888-1.025 1.905-.659 3.008-1.317 4.112-1.975 2.738-.661 5.476-1.323 8.863-1.71 2.548.152 4.55.376 6.326-.157 4.95-1.487 9.534-4.357 15.183-2.425 1.106.378 3.064-1.74 4.63-2.706l6.008-.004c4.578-.36 8.283-.719 11.988-1.078 2.715-.641 5.43-1.282 8.967-1.923 3.223-.999 5.627-1.997 8.031-2.996 2.389-.332 4.778-.665 7.838-.717 2.243.23 3.892.465 5.373.071 3.637-.966 7.196-2.221 10.787-3.36.665.689 1.33 1.378 1.745 2.529-2.334.914-4.414 1.385-6.503 1.815-6.518 1.34-13.04 2.666-19.56 3.997l-1.599.188c-1.35.208-2.215.36-3.079.512zM474.695 61.982c3.755 6.347 3.175 7.32-3.827 8.095-2.545.282-4.966 1.56-7.511 1.982-14.41 2.384-28.84 4.649-43.264 6.948-6.737 1.074-13.5 2.011-20.199 3.28-1.85.351-3.607 1.533-5.245 2.585-2.347 1.508-4.27 1.873-5.646-1.52 3.558-1.322 7.126-2.53 10.792-3.196a4760.773 4760.773 0 0 1 48.828-8.596c7.179-1.228 14.398-2.215 22.364-3.404 3.453-.469 3.953-1.792 1.897-3.51-2.826-2.359-5.882-4.443-8.84-6.645 0 0-.016-.036-.137-.332-1.13-1.33-2.138-2.363-3.057-3.497.09-.102.274-.3.585-.261.73.052 1.148.064 1.567.076 2.44 1.636 4.88 3.273 7.7 5.282 1.019.824 1.66 1.275 2.3 1.726.465.322.93.644 1.693.987z"/>
        <path fill="#10CB9A" d="M280.878 195.028a2687.721 2687.721 0 0 1-19.522-6.87c-.925-2.018-1.503-3.858-1.64-5.643 1.775.264 3.11.474 4.765.796 1.886.124 3.453.137 5.23.438 1.591.575 2.971.862 4.678 1.263 1.437.362 2.547.61 3.656.857.415.1.83.2 1.75.574 3.756 1.996 7.007 3.716 10.257 5.436 0 0 .015.087.181.351 1 .805 1.835 1.346 2.67 1.886 0 0 .098-.048.108.215.34.38.668.498.997.615 0 0-.006.056.123.364 1.84 2.024 3.705 3.616 5.227 5.485 2.333 2.865 4.995 5.738 3.082 9.894-.66-.285-1.097-.481-1.527-.984a7.217 7.217 0 0 0-1.722-1.972c-.128.022.118-.066.055-.357-.816-.933-1.568-1.575-2.303-2.267.018-.05-.088-.067-.115-.32-.3-.381-.573-.51-1.012-.758-.165-.12-.574-.126-.693-.38-.435-.432-.752-.61-1.192-1.071-1.002-.742-1.88-1.202-2.917-1.975-3.448-2.05-6.738-3.786-10.042-5.562-.014-.04-.094-.015-.094-.015z"/>
        <path fill="#FCFFFE" d="M468.004 110.07c10.927-1.028 21.884-1.896 32.63-5.637 1.713 1.087 3.04 1.827 4.616 2.567.417 0 .584 0 .812.355 5.292 2.428 1.868-2.206 2.938-3.357a83.916 83.916 0 0 1 3.653-.97c.38 6.814 1.116 7.484 8.297 7.999 2.97.213 5.915.777 8.492 1.577-13.571-.83-26.455 1.933-39.415 3.099.339-1.116.656-1.91 1.419-2.703 1.434 0 2.46.17 3.403-.036 1.947-.426 3.85-1.054 5.771-1.599-.33-.896-.605-2.537-.999-2.566-2.17-.16-4.397-.094-6.545.259-.778.128-1.389 1.265-2.514 1.942-3.335.438-6.229.914-9.133 1.306-4.697.634-9.613 2.483-13.425-2.235zM472.652 204.806c.258-.24.516-.479 1.27-.75.817-.107 1.042-.297 1.17-.602.503-.373 1.007-.745 2.12-1.205 1.025-.13 1.438-.173 2.06-.326.48-.307.652-.566.726-.89 0 0 .012-.044.393 0 1.817.11 3.72.811 4.616.149 8.357-6.174 18.716-6.672 27.993-10.178-.666 2.724-1.333 5.45-2.34 8.764-3.152 1.141-6.012 1.52-8.763 2.289-3.318.927-7.53-.79-9.968 3.3-.127.09-.438.07-.737-.014-.605.162-.91.408-1.56.758a20.419 20.419 0 0 1-3.615.053c-1.28-.117-2.142-.124-3.35-.138-1.152.609-1.958 1.224-2.988 1.884-.225.045-.682.098-.915.206-.415.39-.597.673-.913 1.054-.134.099-.466.087-.856-.017-.923-.135-1.457-.166-2.14-.516a207.613 207.613 0 0 0-2.203-3.821zM174.947 345.677c-2.86-.112-6.226.172-8.527-1.258-3.043-1.89-6.11-2.892-8.5-.714-1.006.915.538 4.63 1.046 7.849.486-.314-.217.412-.491.276-4.551-2.26-9.014-4.7-13.581-6.926-1.25-.609-2.777-.646-4.524-.9-.354-.718-.362-1.48-.37-2.624 5.07-1.047 10.122-1.946 15.212-2.3 3.505-.244 7.047.24 9.441-3.136.18-.253.55-.55.815-.535 2.053.117 4.103.305 6.154.47l-2.138 5.23c1.502 1.162 3.466 2.682 5.463 4.568z"/>
        <path fill="#DAFDF9" d="M443.023 84.027c7.65.844 14.855-.93 22.006-3.448 2.801-.987 5.871-1.21 8.917-2.168 6.137-.067 12.175.253 18.82.853 1.813.771 3.016 1.262 4.22 1.754 0 0 .014-.017.151.286 1.378 1.102 2.619 1.902 3.86 2.701 0 0 .003-.005.035.337 1.005 1.126 1.978 1.91 2.95 2.695.487.58.973 1.16 1.86 2.138a197.344 197.344 0 0 0 3.157 2.826s.001-.001.142.287c1.04.777 1.94 1.265 2.84 1.753.47.315.94.629 1.865 1.271 1.012 1.778 1.57 3.228 2.13 4.678-.406.028-.811.056-1.516.137-.299.052-.508-.148-.732-.546-4.91-4.48-10.187-8.061-14.15-12.753-7.209-8.538-15.693-6.873-24.842-5.027-10.5 2.117-21.158 3.452-31.746 4.764.012-1.088.023-1.813.033-2.538z"/>
        <path fill="#FCFFFE" d="M197.782 305.005c-4.95-1.927-7.19-5.045-5.307-10.58.305-.897-1.54-2.525-2.212-4.418 2.004-.385 3.828-.168 5.672.035.02-.013.015.033.066.39 4.053 2.087 8.055 3.819 12.372 5.556.727.072 1.14.138 1.634.534 1.596 1.396 3.11 2.463 5.76 4.332-3.783.877-6.56 1.43-9.28 2.188-1.55.431-3.006 1.199-4.838 1.856-.779.004-1.224-.034-1.816-.312-.782-.02-1.416.2-2.05.42zM429.002 166.004c.54 3.39-.518 5.914-3.383 8.06-1.138.853-1.284 3.054-1.834 4.658-.45 1.31-.53 2.862-1.303 3.92-1.346 1.843-3.067 3.421-4.689 5.052-4.79 4.817-6.305 4.767-10.634-.905 2.053-2.727 4.363-4.713 6.441-6.917 4.561-4.836 9.005-9.783 13.692-14.807.194-.123.639-.247.751.004.395.48.677.707.96.935zM465.999 269.981c-2.859 3.096-1.351 6.2-.373 9.671-1.053.307-1.754.246-2.571-.166-4.26-4.173-9.903-4.483-16.576-1.197-1.057-.055-1.759-.151-2.617-.572-1.877-1.137-3.526-2.224-5.335-2.699-2.664-.698-3.984-2.025-3.08-4.893 1.426-.137 2.465-.221 3.926-.236 1.847.017 3.271-.035 5.104.007 2.088.065 3.767.036 5.731.313 5.454.128 10.622-.05 15.79-.228z"/>
        <path fill="#05CA90" d="m539 143.864-.86-4.193 14.382 7.733 1.68-.804c-.355-3.423-.71-6.846-.744-10.423 2.076 3.183 3.83 6.52 5.584 9.856.033.717.066 1.434.068 2.973-.03 5.224-.03 9.627-.03 14.03-1.879-1.3-2.67-2.72-3.65-3.998-1.068-1.392-2.31-2.65-3.451-3.998.025-.032-.048 0-.06-.333-.965-1.142-1.918-1.952-2.895-2.734-.024.027.03-.022-.026-.348-.724-.71-1.392-1.093-2.06-1.478 0 0-.438-.097-.74-.382-.59-.468-.879-.651-1.167-.835 0 0-.029.063-.04-.326-2.004-1.84-3.997-3.29-5.99-4.74z"/>
        <path fill="#FCFFFE" d="M343.651 219.997c-5.461.002-10.459-.063-15.453.024-2.918.051-4.451-1.076-4.159-4.123.299-3.106 2.289-1.997 4.313-2.137 4.554-.315 9.042-1.498 13.58-2.172 1.965-.293 4.342-3.132 5.884.505 1.483 3.5-.206 6.913-4.165 7.903z"/>
        <path fill="#ECFEFD" d="M187.273 90.418c-4.079 1.333-8.614 2.617-13.217 3.578-16.408 3.426-32.84 6.742-49.66 10.085.526-1.034 1.27-2.385 2.41-2.999 2.08-1.117 4.395-1.797 6.903-2.871.735-.211 1.18-.211 1.958-.214 9.607-1.792 18.842-3.835 28.169-5.295 7.593-1.189 15.296-1.68 23.437-2.284z"/>
        <path fill="#DAFDF9" d="M490.005 116.025c12.982-1.488 25.866-4.252 39.526-3.027 1.845.008 3.222.018 5.059.371 3.106 2.448 5.75 4.554 8.395 6.66.099.32.285.58.923 1.178.864 1.356 1.36 2.309 1.858 3.262-6.591-3.919-12.714-9.065-20.965-8.927-6.676.111-13.384.253-20.01.986-7.031.777-13.984 2.268-21.334 3.009 1.94-1.463 4.244-2.488 6.548-3.512z"/>
        <path fill="#FCFFFE" d="M249.743 238.522c1.178-1.609 2.271-3.29 3.564-4.8.799-.932 2.176-2.456 2.82-2.248 2.673.863 6.227 1.632 7.47 3.656 1.752 2.856 3.445 3.93 6.569 3.978 1.217.018 2.822.888 3.538 1.883 1.35 1.877 2.183 4.126 3.308 6.575.077.354-.024.457-.44.488-2.051-.725-3.639-1.612-5.33-2.209-4.737-1.672-9.518-3.224-14.38-4.956-.446-.295-.74-.239-1.205-.057-.542-.187-.862-.193-1.295-.361-.885-.389-1.657-.528-2.712-.771-.682-.104-1.081-.103-1.51-.298-.208-.393-.33-.621-.397-.88zM447.95 155.838c4.36 6.366.008 12.268-1.004 18.337-.564 3.384-3.863 5.12-6.112 2.892-3.46-3.428-8.888-5.849-7.618-12.892.726-.233 1.674.178 1.68.6.062 4.945 3.895 5.658 8.258 7.809-.84-5.317-1.5-9.498-1.95-13.689.21-.01.63 0 .943.14 3.832 1.861 3.675-1.574 5.104-3.135.233-.024.698-.062.698-.062z"/>
        <path fill="#11CF9F" d="M460.76 54.273c1.009 1.033 2.017 2.066 3.128 3.39-3.595-1.37-7.25-3.133-10.996-4.673-10.385-4.27-20.402.295-30.579 1.319-3.013.303-6.097-.104-9.39-.578 6.28-1.723 12.801-3.048 19.319-4.389 2.089-.43 4.17-.901 6.6-1.46 1.655-.07 2.961-.036 4.991.037 6.125 2.143 11.526 4.249 16.927 6.354z"/>
        <path fill="#D7FDFA" d="M455.041 203.073s.012.412-.31.62c-.461.318-.601.428-1.084.607-7.109 3.599-13.876 7.128-20.978 10.627-1.113.375-1.89.779-3.026 1.13-2.455.997-4.55 2.048-6.97 3.036-1.144.51-1.965 1.084-3.16 1.695-2.197 1.052-4.02 2.066-6.193 3.107-3.645 1.423-6.94 2.819-10.318 4.122-.082-.093-.25-.276-.165-.553.116-.664.148-1.05.18-1.435 1.522-.758 3.03-1.541 4.567-2.266 1.663-.785 3.353-1.515 5.546-2.556.979-.92 1.443-1.555 1.908-2.19 1.449-.579 2.897-1.158 5.035-1.875 5.065-1.456 9.255-3.07 11.945-7.109.439-.002.878-.004 1.849.241 5.412-2.253 10.291-4.754 15.171-7.254 1.094-.312 2.188-.623 3.93-.946 1.124.327 1.599.663 2.073 1z"/>
        <path fill="#FAFFFE" d="M506.067 154.978s.434.03.706.448c2.267 1.465 4.262 2.512 6.257 3.558 0 0-.035.004.005.267.35.425.659.588.967.75 1.437.633 2.873 1.266 4.757 2.214.651.596.926.746 1.273.763 0 0-.034.018-.02.34 1.677.777 3.342 1.231 5.006 1.685.889 3.107.501 3.472-4.86 3.724-2.101-.908-4.17-1.136-4.944-2.258-2.019-2.924-4.08-2.718-6.78-1.273-1.272.681-2.839.794-4.248 1.241-4.067 1.29-6.007-.333-5.775-4.437 1.829.18 3.256.55 4.66.475 1.071-.056 2.112-.675 3.166-1.044L505 158c-.003-.464-.006-.929.119-1.943.39-.744.664-.92.948-1.079z"/>
        <path fill="#FCFFFE" d="M263.074 306.162c-.434.286-.868.573-1.907.897-1.139.651-1.672 1.263-2.204 1.875-.444.34-.888.679-2.004 1.013-2.092 1.02-3.513 2.043-4.934 3.067 0 0-.018-.01-.419-.038-2.64.14-5.36-.489-5.541 3.082 0 0-.03-.046-.401-.07-1.788.326-3.204.675-4.62 1.023.315-2.44.631-4.88 1.282-7.842 3.252-1.437 6.219-2.224 9.07-3.312 1.945-.743 3.729-1.907 5.59-2.872.006.01-.009-.007.33.035 1.129-.288 1.92-.618 3.012-1.034.719-.104 1.136-.12 1.712.206.45 1.552.742 2.761 1.034 3.97z"/>
        <path fill="#12CC9B" d="M217.065 350.98s.021-.4.02-.6c.43-.187.862-.175 1.888-.263.8-.408 1.004-.716 1.21-1.023l21.947-9.173c-1.824 5.86-6.345 9.213-10.604 13.472-2.824 1.799-5.144 3.238-7.449 4.323 1.667-2.415 3.318-4.475 5.13-6.736h-12.142z"/>
        <path fill="#FCFFFE" d="M497.621 162.08c.558 4.024 2.498 5.647 6.565 4.357 1.41-.447 2.976-.56 4.249-1.24 2.7-1.446 4.76-1.652 6.78 1.272.774 1.122 2.842 1.35 4.553 2.258-5.897 4.056-12.758 3.399-19.396 3.043-4.312-.23-5.532-4.71-2.75-9.69zM354.677 193.51s.04-.287.46-.515c2.88-2.842 5.34-5.456 7.8-8.07 0 0 .057.078.396.066 1.124-.993 1.91-1.975 2.697-2.958 0 0-.03-.033.352-.016 1.108-.046 1.834-.11 2.56-.174-.318 1.934-.6 3.874-.963 5.8-.694 3.683-1.915 6.816-6.124 8.017-4.382 1.251-8.557 3.275-12.974 4.328-1.347.321-3.193-1.45-4.856-2.616-.045-.351-.022-.376.385-.344 7.13 2.126 9.056 1.432 10.267-3.518zM194.008 87.592c-1.106.74-2.205 1.074-3.653 1.409-4.293-2.755-8.235-5.512-12.44-8.453 1.755-4.42 4.35-5.22 8.967-2.39 2.164 1.325 4.86 1.781 8.03 2.879a327.607 327.607 0 0 0-.904 6.555zM300.906 210.011c.437.197.873.393 1.882.744 1.448-.159 2.323-.473 3.199-.786.895 2.072 1.903 4.106 2.642 6.233.423 1.216.41 2.583.593 3.881-1.297-.092-2.947.284-3.819-.373-1.953-1.471-3.4-2.466-5.397-.042-.52.63-2.66.873-3.12.395-.85-.885-1.465-2.472-1.363-3.7.208-2.523.952-5.003 1.479-7.934.003-.434.012-.443.4-.45.894-.11 1.4-.21 1.907-.312 0 0-.247.088-.196.404.63.857 1.212 1.399 1.793 1.94zM383.025 232.013c-.354-2.076-.618-4.066-1.031-7.177 4.333-5.024 11.337-2.434 18.268-3.945-.986 2.803-1.616 4.594-2.406 7.063-1.96 2.693-2.682 1.572-3.094-.679-.628-.863-1.767-1.938-1.887-1.834-1.455 1.26-2.76 2.691-4.342 4.178-.345.232-.453.365-.817.532-.67.328-1.084.622-1.575.884-.077-.03-.13.126-.367.144-.565.177-.707.438-.964.864-.704.117-1.108.17-1.512.224 0 0-.183-.168-.273-.254zM519.203 145.92s-.198-.365-.187-.925c.006-1.04 0-1.52.33-2.17a139.597 139.597 0 0 1 9.117-1.832c2.115.342 3.852.653 5.59.963 0 0 .013.101-.028.513A615.47 615.47 0 0 1 533 149c-2.097 1.297-4.194 2.594-6.645 3.552-1.386-1.408-2.418-2.478-3.515-3.879-1.008-.767-1.948-1.203-2.889-1.639 0 0 .046-.036.019-.261-.17-.557-.417-.766-.767-.852zM316.955 66.616c-7.224 2.537-15.285.228-22.588 4.335 2.332-4.597 6.792-5.872 12.017-6.182.215-1.126.139-2.392.694-3.25.848-1.31 2.132-2.336 3.231-3.483.898 1.056 1.822 2.09 2.686 3.173 1.327 1.661 2.611 3.356 3.96 5.407zM404.944 188.877l-1.481 7.677 1.037 1.75c-2.052-.208-4.39.129-6.082-.762-2.072-1.091-5.376-4.027-5.049-4.738 1.178-2.556 3.66-4.511 6.19-6.701.539-.009.941-.056 1.026.27.202.757.319 1.19.64 1.912 1.377.39 2.548.491 3.72.592z"/>
        <path fill="#D3FDFA" d="M466.366 269.977c-5.536.182-10.704.36-15.922.002 1.19-.895 2.43-1.255 4.035-1.584 1.091-.074 1.815-.18 2.88-.247 1.148-.33 1.955-.697 3.17-1.055 8.426-2.4 16.445-4.809 24.79-7.171.768.043 1.209.04 1.617.415-1.308 1.143-2.574 1.925-3.86 2.671-1.701.986-3.418 1.944-5.129 2.914-.771.336-1.542.672-2.974 1-3.793-1.351-5.397-.002-6.037 3.046-.734.002-1.469.003-2.57.01z"/>
        <path fill="#FCFFFE" d="M562 500c-.078 5.19 2.58 10.628-1.612 15.472-.652.754-.289 2.328-.556 3.486-.46 1.989-1.047 3.949-1.58 5.92l-1.41-.11c-.854-1.708-1.707-3.418-2.48-5.718 5.126-2.816 1-5.606.514-8.39-.036-.221.165-.622.489-.666 1.077-1.035 1.83-2.026 2.945-3.047 2.985-1.083 3.501-2.703 1.684-5.288.048-.785.098-1.233.458-1.67A104 104 0 0 0 562 500z"/>
        <path fill="#C5FAF4" d="M239.21 318.472c-.656 1.173-1.73 2.145-3.988 4.186 2.842-.255 4.48-.401 6.484-.487-5.479 5.64-13.91 6.638-20.144 1.95 2.57-.94 4.766-1.742 7.203-2.814 1.474-.72 2.707-1.17 4.44-1.938 1.274-.648 2.049-.98 2.824-1.312.92.071 1.84.142 3.18.415z"/>
        <path fill="#FCFFFE" d="M497.001 300.029c-.138-4.06 2.754-5.015 5.857-6.084 1.578-.544 3.435-1.652 4.165-3.034 2.526-4.78 2.873-4.892 6.607-.482.348.411 1.186.407 2.089.962-4.732 6.143-12.283 6.106-18.718 8.638z"/>
        <path fill="#D7FDFA" d="M513.4 190.998c-9.677 3.512-20.036 4.01-28.393 10.184-.896.662-2.8-.038-4.597-.137 6.725-3.003 13.697-6.304 20.937-8.842 5.418-1.9 11.18-2.819 17.192-4.19.181 3.543-2.525 2.84-5.14 2.985zM492.057 205.268c2.31-4.002 6.522-2.284 9.84-3.211 2.751-.769 5.611-1.148 8.763-1.88 4.696-.505 9.052-.828 13.87-.759.474 1.444.486 2.494.22 3.433-.825-.324-1.374-.535-2.352-.753-10.4 1.052-20.37 2.111-30.341 3.17z"/>
        <path fill="#FAFFFE" d="m440.994 158.905 2.16 13.679c-4.363-2.151-8.196-2.864-8.259-7.808-.005-.423-.953-.834-1.679-1.013-.945.248-1.675.258-2.822.235-.418-.033-.52-.143-.394-.459 2.327-1.778 4.526-3.24 7.15-4.656 1.565.038 2.705.03 3.844.022z"/>
        <path fill="#D3FDFA" d="M463.171 279.837c.7.06 1.402.122 2.453.199.68 4.614-3.052 4.668-6.291 5.79a665.838 665.838 0 0 1-21.645-.885c-.87-.05-1.703-.716-2.585-1.56-.032-.463.156-.661.563-.65 2.04.042 3.672.072 5.7.177 1.471.05 2.545.027 4.08.105 4.938.07 9.433.23 13.887-.121 1.212-.096 2.303-1.732 3.546-2.761.096-.099.292-.294.292-.294z"/>
        <path fill="#B8FBF3" d="M404.99 188.565c-1.217.211-2.388.11-3.42-.326 3.667-3.94 7.005-7.758 10.77-11.093 4.736-4.193 9.822-7.99 14.757-11.958-4.492 4.901-8.936 9.848-13.497 14.684-2.078 2.204-4.388 4.19-6.64 6.607-.674.814-1.3 1.294-1.97 2.086z"/>
        <path fill="#B4F8EA" d="M453.933 297.098c1.543.174 3.086.348 4.872.305.63-.236 1.02-.256 1.748.027a224.317 224.317 0 0 0 3.483 2.722c1.349-.001 2.698-.002 4.53.385 1.993 1.085 3.489 2.344 5.013 2.381 6.406.155 12.82-.056 19.337-.015.106.119.32.354.096.663-6.153.648-12.082.989-18.422 1.263-7.159-2.621-13.908-5.176-20.657-7.731z"/>
        <path fill="#FCFFFE" d="M517.493 83.29c-.226 1.223-.703 2.077-1.012 2.989-1.022 3.01-1.107 9.039-5.15 1.41-.352-.664-2.319-.3-3.162-.92-.923-.68-1.85-1.907-1.948-2.971-.074-.81 1.224-2.537 1.773-2.482 3.132.316 6.222 1.044 9.5 1.974zM492.81 302.785c-6.411.077-12.825.288-19.23.133-1.525-.037-3.02-1.296-4.61-2.368.771-1.057 1.693-2.399 2.462-2.317 7.282.78 14.538 1.8 22.117 3.016-.036.688-.388 1.112-.74 1.536zM264.998 191.423c5.013.946 10.026 2.292 15.46 3.622.42-.017.5-.042.509.317.017.785.025 1.211.033 1.637-2.7.513-5.413.964-8.097 1.549-7.124 1.553-8.835.117-7.905-7.125z"/>
        <path fill="#B4F8EA" d="M492.916 302.903c.245-.542.597-.966 1.062-1.642.866-.561 1.62-.87 2.698-1.205 6.76-2.559 14.311-2.522 19.428-8.636.54-.595.987-.853 2.064-1.233 1.69-.14 2.75-.159 3.685.138-8.765 6.455-17.797 11.714-28.618 12.932l-.32-.354z"/>
        <path fill="#FCFFFE" d="M213.998 239.136c1.283-1.031 2.543-2.922 3.853-2.957 9.393-.253 18.797-.154 28.196-.064.61.005 1.213.866 1.416 1.792-4.879.386-9.365.08-13.827.293-4.705.225-9.386.946-14.228 1.421-.15-.03-.397.159-.783.056-1.442-.012-2.497.08-3.697.008-.43-.245-.691-.374-.93-.549zM478.176 266.21c1.482-1.258 3.199-2.216 4.9-3.202 1.286-.746 2.552-1.528 3.866-2.657.039-.363.021-.383.375-.359 1.078-.41 1.803-.844 2.521-1.296-.006-.019-.032-.05.253.087.494.17.702.206.91.242-.006 6.814-1.729 10.11-5.553 9.753-2.398-.225-4.7-1.485-7.272-2.568zM215.009 310.954c-4.383.998-8.724 2.386-13.164 2.87-3.554.388-6.14-4.25-4.155-7.432 2.843 1.005 5.071 1.948 7.39 2.528 3.274.819 6.616 1.369 9.929 2.034zM377.564 55.003c-1.122.968-3.08 3.086-4.186 2.708-5.65-1.932-10.232.938-15.183 2.425-1.775.533-3.778.309-5.937.15 5.872-3.662 12.157-6.381 19.448-5.375 1.775.245 3.608.071 5.858.092zM521.976 290.01c-1.058.018-2.117.036-3.574.065-1.556-2.79-2.714-5.59-3.417-7.286 4.552-.57 9.382-1.174 14.635-1.762.422.015.473.067.413.404-1.363 1.546-2.722 2.7-3.952 3.978-1.414 1.468-2.715 3.046-4.071 4.588-.006.01-.034.013-.034.013zM431.733 209.733c-2.405 4.338-6.595 5.953-11.351 7.275-.365-.162-.358-.329-.33-.492.375-2.304.277-6.336 1.22-6.596 3.193-.882 6.756-.43 10.461-.187z"/>
        <path fill="#C5FAF4" d="M256.98 302.975c-1.855.975-3.64 2.14-5.584 2.882-2.851 1.088-5.818 1.875-9.065 2.93-3.03.154-5.73.17-9.346.193-2.447-.138-3.979-.284-5.262-.733 8.32-1.85 16.393-3.399 24.864-4.972 1.73-.116 3.062-.208 4.394-.3z"/>
        <path fill="#FAFFFE" d="M533.326 149.028c.002-2.068.33-4.107.652-6.54 1.44.222 2.887.834 4.678 1.411 2.338 1.415 4.331 2.866 6.366 4.69-.416.385-.874.397-1.997.453-1.118.68-1.572 1.32-2.425 1.958H537c-1.116-.648-2.232-1.296-3.674-1.972z"/>
        <path fill="#C5FAF4" d="M215.34 310.958c-3.644-.67-6.986-1.22-10.26-2.038-2.319-.58-4.547-1.523-7.042-2.614-.227-.31-.19-.807-.223-1.053.602-.467 1.236-.687 2.095-.264 4.125 1.467 7.993 2.603 11.937 3.034 4.693.513 9.453.42 13.993.929-3.074.91-5.957 1.48-8.84 2.05-.442-.013-.885-.026-1.66-.044z"/>
        <path fill="#B3FBF5" d="M441.204 158.895c-1.35.018-2.489.026-3.884-.32 2.124-2.04 4.502-3.728 6.88-5.416 0 0-.099-.063.239-.007 1.108-.324 1.878-.705 2.648-1.085 0 0-.09-.03.326-.015 3.808-1.047 7.199-2.11 10.59-3.172.185.045.371.09.758.528-.47 1.087-1.14 1.782-2.168 2.5-2.122 1.012-3.885 2-5.647 2.988-.852.154-1.704.31-2.776.703-.22.24-.686.277-1.304.3-2.09 1.014-3.56 2.005-5.032 2.996 0 0-.42-.01-.63 0z"/>
        <path fill="#FAFFFE" d="M463.976 198.966c-.222.264-.502.432-1.4.303-.902-.546-1.241-.891-1.58-1.236 1.255-3.623 3.076-6.38 7.608-6.131 1.234.068 2.486-1.294 3.81-1.512 1.774-.29 3.626-.106 5.194.387-3.785 2.054-7.383 3.471-10.821 5.205-1.147.578-1.885 1.966-2.81 2.984z"/>
        <path fill="#2DD9AF" d="M219.558 239.65c4.692-.504 9.373-1.225 14.078-1.45 4.462-.214 8.948.093 13.89.125.852.05 1.237.146 1.92.22.363.236.486.464.646 1.024-.02.363-.217.65-.671.602-10.257-.205-20.06-.363-29.863-.52z"/>
        <path fill="#FAFFFE" d="M551 162c0-.444 0-.889-.041-1.987-.68-1.107-1.32-1.56-1.959-2.013 0-.747 0-1.494.018-2.64.02-.397.07-.447.424-.426 1.065.049 1.777.077 2.489.105 0 0 .073-.03.039.367 1.51 3.19 2.821 6.16 4.728 8.678.662.874 2.802.629 4.511 1.068-.24 1.398-.725 2.623-1.209 3.849-1.389 0-2.778 0-4.637-.346-1.768-2.449-3.065-4.552-4.363-6.655z"/>
        <path fill="#F8FEFE" d="M554.91 510.88c.452 2.564 4.578 5.354-.688 7.85-.777.44-1.333.61-2.055 1.025-3.128 1.522-3.776 6.553-8.778 5.211-.46-.055-.588-.198-.443-.51 3.688-4.42 7.23-8.527 11.067-12.652.45-.35.604-.683.812-1.02.053-.005.086.097.086.097z"/>
        <path fill="#FCFFFE" d="M241.601 77.996c-.038.633-.385 1.68-.948 1.812-6.268 1.477-12.57 2.812-19.258 4.184.244-1.09.759-3.016 1.546-3.135 6.089-.917 11.567-5.915 18.66-2.861zM395.96 53.574c-3.661.708-7.366 1.067-11.516 1.425-.868-3.101.381-4.811 3.525-5.542 3.798-.882 6.266.473 7.992 4.117zM486.56 149.116c.93.01 1.861.022 3.122.5.337.745.346 1.02.342 1.644-.017.813-.02 1.277-.024 1.74-6.277-.075-12.555-.151-18.498-.623 4.395-1.091 8.457-1.787 12.968-2.517.996-.27 1.543-.507 2.09-.744z"/>
        <path fill="#B4F8EA" d="M560.964 164.979c-1.464-.266-3.604-.02-4.266-.895-1.907-2.518-3.218-5.488-4.754-8.646a21.815 21.815 0 0 1 3.486 3.6c.98 1.277 1.771 2.698 3.65 3.998 0-4.403 0-8.806.087-13.676.662 2.276 1.239 5.019 1.819 8.637-.004 2.91-.013 4.946-.022 6.982z"/>
        <path fill="#FCFFFE" d="M279.82 70.674c-3.535 1.666-7.255 2.996-11.398 4.325.592-5.692 5.387-7.613 11.398-4.325zM545.832 124.738c-.563-1.222-1.06-2.175-1.706-3.425.153-.434.443-.652.758-.696 2.36-.33 4.724-.625 7.087-.931.013 2.51.026 5.019-.294 7.786-1.236.069-2.138-.12-3.04-.31 0 0-.392-.115-.596-.463-.376-.57-.603-.7-.883-.736-.42-.318-.84-.637-1.326-1.225z"/>
        <path fill="#D7FDFA" d="M512.03 185.713c-5.74 1.264-11.48 2.282-17.584 2.896.611-1.133 1.586-1.862 2.56-2.591 1.743-.331 3.485-.662 5.932-1.027 1.496-.676 2.286-1.32 3.075-1.963.743 0 1.486-.002 2.745.288 1.428.745 2.339 1.201 3.25 1.657 0 0 .02.493.022.74z"/>
        <path fill="#FCFFFE" d="M535.584 104.393c-1.058 1.742-2.19 4.136-3.557 4.279-1.406.147-3.169-1.775-4.484-3.084-.309-.308.62-2.627.869-2.607 2.345.183 4.666.674 7.172 1.412z"/>
        <path fill="#ECFEFD" d="M460.85 54.172c-5.49-2.004-10.892-4.11-16.63-6.32.436-.682 1.207-1.257 2.755-1.839 2.86.655 4.943 1.315 7.026 1.976 1.386.005 2.771.011 4.609.367 1.14 2.071 1.827 3.793 2.514 5.515l-.274.3z"/>
        <path fill="#FCFFFE" d="M295.242 203.905s.409.005.66.326c.426.567.66.731.953.811 0 0 .106.017.089.42.012 1.111.04 1.818.07 2.524L297 208c-7.47 2.047-7.47 2.047-6.71-6.51.49-.491.686-.532.882-.572.878.46 1.757.92 2.844 1.942.547.722.886.884 1.226 1.045z"/>
        <path fill="#FAFFFE" d="M484.02 149.894c-4.061.696-8.123 1.392-12.603 2.097-3.118.01-5.817.01-8.967-.318-.451-.763-.452-1.2-.003-1.66 3.079-.28 5.71-.76 8.338-.738 4.413.038 8.824.396 13.236.62z"/>
        <path fill="#DAFDF9" d="M306.11 209.68c-.999.602-1.874.916-3.098 1.164 1.341-4.311-1.32-7.184-3.654-10.049-1.522-1.87-3.386-3.46-5.2-5.496.998-.07 2.1.178 3.66.854 1.36.914 2.261 1.4 3.163 1.886.8 1.229 1.601 2.457 2.706 4.196 1.301 1.941 2.297 3.372 3.294 4.803a95.99 95.99 0 0 1-.871 2.643z"/>
        <path fill="#FCFFFE" d="M240.901 69.003c1.57 1.027 2.732 2.052 3.894 3.077-1.565.964-3.115 2.635-4.702 2.671-1.284.03-2.613-1.909-3.922-2.975 1.44-.925 2.882-1.85 4.73-2.773zM525.028 202.963l-.039-3.545c1.296-3.315 2.959-4.707 5.843-1.772-1.392 3.135-2.742 6.176-4.544 9.075-.617-.422-.852-.614-1.177-1.098-.04-1.14-.061-1.9-.083-2.66zM217.042 311.364c2.841-.932 5.724-1.502 9.036-2.469.429-.396.915-.423.915-.423l.481.078c1.532.146 3.064.292 5.06.443-1.36 3.354-12.997 5.35-15.492 2.37z"/>
        <path fill="#D7FDFA" d="M464.352 198.966c.55-1.018 1.288-2.406 2.435-2.984 3.438-1.734 7.036-3.151 10.892-4.836 1.073-.15 1.825-.157 2.962.081.39.42.394.593.4.767-5.438 2.324-10.876 4.647-16.69 6.972z"/>
        <path fill="#B3FBF5" d="M490.037 150.912c-.009-.276-.018-.551-.01-1.24 5.232 1.292 10.447 2.997 15.85 5.004-.094.461-.368.637-.764 1.032-1.853-.019-3.572-.24-5.713-.949-1.748-1.214-3.075-1.94-4.402-2.668-.436-.043-.872-.087-1.851-.398a26.365 26.365 0 0 0-3.11-.781z"/>
        <path fill="#FCFFFE" d="M448.624 203.013c-4.466 2.507-9.345 5.008-14.428 7.262 2.713-6.277 8.717-6.057 14.428-7.262zM436.938 44.642c-3.529 1.495-7.088 2.75-10.725 3.716-1.481.394-3.13.16-4.961-.07 4.232-1.85 8.704-3.483 13.239-4.915.636-.2 1.583.585 2.447 1.27z"/>
        <path fill="#9AF9F1" d="M279.891 177.95c6.631-.34 13.262-.679 20.042-.675.15.343.206.72-.23.809-1.525.085-2.616.082-3.707.08-3.993.006-7.985.013-12.83.025a52.118 52.118 0 0 1-3.275-.239z"/>
        <path fill="#FCFFFE" d="M271.08 179.46c.655-.214 1.31-.427 2.614-.589.865.076 1.082.1 1.686.133 1.802.337 3.216.664 4.63.99-.668 1.385-1.337 2.77-2.31 4.422-1.478-.257-2.65-.782-4.174-1.341-1.06-.086-1.768-.136-2.488-.53.005-1.258.024-2.172.042-3.086zM561.209 165.152c-.236-2.209-.227-4.244-.202-6.716 3.478-.676 3.108 1.811 2.959 3.911-.2 2.822 1.275 6.583-3.752 6.908.27-1.48.755-2.705.995-4.103z"/>
        <path fill="#B4F8EA" d="M559.301 145.795c-2.013-3.099-3.767-6.435-5.771-10.033-.31-.892-.37-1.521-.16-2.485.676-.295 1.081-.255 1.487-.216.508.88 1.016 1.76 1.807 3.17 1.262 2.294 2.24 4.058 3.22 5.822-.108 1.168-.216 2.336-.583 3.742z"/>
        <path fill="#D7FDFA" d="M394.725 227.611c.449 1.915 1.17 3.036 3.129.73.159-.293.65-.306 1.276-.318 1.625-.102 2.624-.192 3.623-.282 0 0 .167.183.056.555a57.838 57.838 0 0 1-8.18 4.77c-1.407-.163-2.435-.256-4.415-.434l4.51-5.02z"/>
        <path fill="#AAFAF1" d="M384.599 168.957c-1.357 1.528-3.01 3.145-4.823 4.553-1.4 1.087-3.004 1.911-4.671 3.163-.467.384-.728.541-1.383 1.013-1.097.37-1.75.509-2.496.55l-.279-.29c4.429-2.996 8.858-5.992 13.652-8.989z"/>
        <path fill="#FCFFFE" d="M495.016 72.92c-1.09.83-2.013 1.312-2.937 1.796-.346-.988-1.237-2.218-.928-2.914.684-1.54 1.972-2.812 3.014-4.193l1.58.76c-.187 1.402-.375 2.803-.729 4.55zM412.737 48.72c-2.139 1.283-4.543 2.281-7.342 3.278-.125-5.847 3.901-3.814 7.342-3.279zM186.94 348.636a54.892 54.892 0 0 1-10.884-1.224c2.01-.695 4.148-1.361 6.216-1.187 1.582.132 3.074 1.327 4.667 2.411zM504.705 158.216c.707.928 1.12 2.071 1.532 3.215-1.054.369-2.095.988-3.165 1.044-1.405.074-2.832-.296-4.661-.475.484-.665 1.32-1.438 2.288-1.966 1.178-.642 2.469-1.077 4.006-1.818z"/>
        <path fill="#DAFDF9" d="M290.048 191.523c-3.246-1.364-6.497-3.084-9.932-5.103 1.605-.04 3.396.217 5.728.788a98.184 98.184 0 0 0 4.14 1.82c.02.713.04 1.426.064 2.495z"/>
        <path fill="#B8FBF3" d="M195.915 290.056c-1.824-.217-3.648-.434-5.704-.401-.232.25-.647.263-.852.264-.883-1.852-1.559-3.707-1.849-5.813 3.06 1.816 5.732 3.883 8.405 5.95z"/>
        <path fill="#FCFFFE" d="M550.635 162.07c1.663 2.033 2.96 4.136 4.311 6.585-6.033-.717-6.934-2.024-4.311-6.586z"/>
        <path fill="#D7FDFA" d="M491.082 189.09c-2.456.935-4.913 1.87-7.704 2.433.317-1.42.97-2.47 1.622-3.518a241.31 241.31 0 0 1 3.911.017c1.199.372 1.685.72 2.171 1.068z"/>
        <path fill="#FCFFFE" d="M542.983 119.657c-2.643-1.734-5.287-3.84-7.98-6.29 4.619-.809 6.253 2.614 7.98 6.29zM555.254 133.035c-.803-.013-1.208-.053-1.92-.075-.306.017-.351-.034-.398-.258-.203-.476-.424-.64-.712-.715-.182-.363-.365-.726-.551-1.392 2.243-.791 4.49-1.279 6.738-1.766l.822 1.855c-1.194.775-2.388 1.55-3.979 2.351zM377.747 181.844c1.196.644 2.118 1.513 3.04 2.382l-3.346 2.335c.01-1.498.022-2.995.306-4.717z"/>
        <path fill="#FAFFFE" d="M491.445 189.113c-.85-.371-1.335-.72-2.134-1.1 1.776-2.328 3.927-4.44 7.545-2.297-.824 1.03-1.799 1.76-2.834 2.802-.779.415-1.497.516-2.577.595z"/>
        <path fill="#DAFDF9" d="M291.014 200.605c-.038.353-.234.394-.726.487-3.078-1.235-5.86-2.522-8.965-3.95-.33-.569-.339-.995-.342-1.74 3.295 1.417 6.585 3.154 10.033 5.203z"/>
        <path fill="#FCFFFE" d="M530.541 158.362c1.33.94 2.324 2.044 3.317 3.148l-2.68 1.29c-.325-1.425-.65-2.85-.637-4.438z"/>
        <path fill="#FAFFFE" d="M455.339 203.081c-.772-.344-1.247-.68-2.028-1.04-.328-3.177.855-4.783 4.338-2.984-.137 1.398-.374 2.218-.61 3.04-.468.33-.935.661-1.7.984z"/>
        <path fill="#FCFFFE" d="M461.998 150.037c0 .437 0 .873.002 1.636-1.429.991-2.858 1.656-4.645 1.972-.374-.819-.389-1.289-.404-1.76.67-.695 1.34-1.39 2.077-2.374.473-.33.878-.372 1.732-.198.677.44.94.609 1.238.724z"/>
        <path fill="#FAFFFE" d="M522.906 149.005c1.032 1.07 2.063 2.139 3.097 3.603-.256.88-.515 1.366-1.185 2.108-.81.229-1.21.2-1.61.172-.115-.352-.23-.705-.3-1.758.031-1.842.015-2.984-.002-4.125zM456.593 151.909c.373.447.388.917.405 1.74-.099.674-.286.936-1.077 1.264-.985.448-1.453.768-1.921 1.087-.883-.18-1.766-.36-2.851-.822 1.56-1.27 3.322-2.258 5.444-3.27z"/>
        <path fill="#F8FEFE" d="M562 499.563c-.413.436-.826.436-1.802.41-.73-.023-.899-.023-1.072-.427.063-1.753.13-3.1.485-4.515.65-.722 1.01-1.376 1.37-2.03l.765-.001c.255 2.042.254 4.085.254 6.563z"/>
        <path fill="#FCFFFE" d="M469.33 269.979c.246-3.059 1.85-4.408 5.326-3.03-1.415 1.037-3.175 2.039-5.327 3.03z"/>
        <path fill="#FAFFFE" d="M560.15 141.888c-1.245-1.6-2.224-3.363-3.239-5.478.152-.366.339-.38 1.013-.14 1.35.413 2.213.572 3.076 1.105v2.626c-.195.574-.39 1.148-.85 1.887z"/>
        <path fill="#FCFFFE" d="M211.948 82.66c-1.72 1.32-3.492 2.298-5.605 3.312.865-2.41 1.24-6.178 5.605-3.311zM453.946 47.641c-2.028-.313-4.112-.973-6.57-1.64 2.85-4.498 4.411-.163 6.57 1.64z"/>
        <path fill="#FAFFFE" d="M513.992 184.973c1.635-3.14 3.463-4.63 5.541-.34-2.105.351-3.823.346-5.541.34z"/>
        <path fill="#FCFFFE" d="M516.327 99.935c-.91-1.395-1.47-2.845-2.185-4.6 3.768-.406 4.426.778 2.185 4.6zM461.435 53.911c-.998-1.762-1.686-3.484-2.41-5.555 1.298 1.398 2.632 3.145 3.972 5.262-.414.357-.832.345-1.562.293z"/>
        <path fill="#D7FDFA" d="M457.399 202.083c-.124-.808.113-1.628.479-2.748.929-.553 1.728-.808 2.822-1.183.635.226.974.571 1.627 1.118-1.314 1.068-2.941 1.934-4.928 2.813z"/>
        <path fill="#FAFFFE" d="M484.958 187.698c-.61 1.356-1.263 2.405-1.96 3.768-.467.4-.889.484-1.635.548-.328-.194-.333-.368-.346-.802.849-1.936.479-4.959 3.94-3.514z"/>
        <path fill="#AAFAF1" d="M525.009 164.74a15.675 15.675 0 0 1-4.983-1.436c1.167-.227 2.333-.118 3.934-.099.637.363.838.817 1.049 1.534z"/>
        <path fill="#FCFFFE" d="M362.537 233.637c-1.092.242-2.037.194-2.983.147l.54-2.154c.863.573 1.726 1.146 2.443 2.007z"/>
        <path fill="#D7FDFA" d="M525.13 206.002c.306.105.541.297.8.788.078.948.062 1.684.043 2.787-.842.373-1.682.38-2.962-.036-.166-1.416.11-2.41.673-3.42.675-.05 1.06-.085 1.446-.119z"/>
        <path fill="#FCFFFE" d="M306.987 206.652c-1.003-1.045-1.999-2.476-3.007-4.272.997 1.05 2.005 2.468 3.007 4.272zM296.01 178.524c1.077-.358 2.168-.355 3.659-.252-.279.951-.958 1.803-1.637 2.655-.67-.68-1.34-1.361-2.023-2.403zM537.01 151.381c1.057-.381 2.123-.381 3.59-.381-.14.97-.68 1.94-1.22 2.911-.786-.716-1.573-1.432-2.37-2.53z"/>
        <path fill="#AAFAF1" d="M369.048 181.646c-.832.26-1.558.325-2.65.386 1.054-1.333 2.473-2.664 4.22-4.04.33-.046.515.148.47.507-.433 1.056-.82 1.752-1.206 2.448-.301.083-.544.25-.834.699z"/>
        <path fill="#FCFFFE" d="M289.99 188.66c-1.205-.134-2.404-.636-3.798-1.396 1.85-2.044 3.821-3.602 3.798 1.397z"/>
        <path fill="#D7FDFA" d="M513.984 185.212c1.726-.233 3.444-.228 5.591-.225.298.985.167 1.974-.27 2.963-1.743-.603-3.178-1.206-4.968-1.915-.356-.107-.362-.584-.353-.823z"/>
        <path fill="#DAFDF9" d="M280.345 179.99c-1.749-.322-3.163-.649-4.958-1.213-.38-.238-.366-.693-.366-.693 1.354-.066 2.708-.133 4.466-.167a95.47 95.47 0 0 1 3.23.346c-.412.62-1.224 1.172-2.372 1.727z"/>
        <path fill="#AAFAF1" d="M523.147 155.285c.461-.369.861-.34 1.562-.315.247 1.47.192 2.942-.098 4.689-.665-1.143-1.095-2.56-1.464-4.374z"/>
        <path fill="#FCFFFE" d="M464.018 299.757c-1.03-.412-2.078-1.218-3.173-2.345 1.02.437 2.087 1.194 3.173 2.345zM207.692 349.044c-.739.963-1.827 1.95-3.304 2.932.725-.974 1.84-1.94 3.304-2.932zM370.262 180.962c.007-.711.393-1.407.919-2.366.791-.401 1.444-.54 2.431-.705-.767 1.012-1.869 2.049-3.35 3.07zM402.837 227.464c-1.083.367-2.082.457-3.46.551.841-.823 2.064-1.65 3.463-2.231.145.63.113 1.016-.003 1.68z"/>
        <path fill="#2DD9AF" d="M213.705 239.26c.532.051.793.18.987.748-1.94.662-3.79.839-5.64 1.016.9-.365 1.8-.73 2.898-1.315.618-.255 1.04-.29 1.755-.45z"/>
        <path fill="#FCFFFE" d="M496.956 80.671c-1.174-.145-2.377-.636-3.771-1.393 1.12.171 2.43.61 3.77 1.393z"/>
        <path fill="#C5FAF4" d="M241.016 317.425c1.444-.762 2.86-1.11 4.646-1.409-1.122.973-2.614 1.895-4.382 2.734-.28-.36-.286-.636-.264-1.325z"/>
        <path fill="#B8FBF3" d="M400.5 186.047s-.402.047-.604.01c-.129-.792-.056-1.545-.011-2.675.478-1.014.983-1.65 1.818-1.96-.182 1.76-.692 3.192-1.203 4.625z"/>
        <path fill="#FAFFFE" d="M505.8 182.761c-.576.91-1.366 1.554-2.478 2.22a6.94 6.94 0 0 1 2.479-2.22z"/>
        <path fill="#FCFFFE" d="M444.278 195.2c.65.647.976 1.343 1.303 2.04l-1.251.23c-.126-.74-.25-1.48-.052-2.27z"/>
        <path fill="#FAFFFE" d="M495.054 152.423c1.27.395 2.598 1.122 4.008 2.179-1.262-.396-2.607-1.121-4.008-2.179z"/>
        <path fill="#FCFFFE" d="M368 195.4c.665.665 1.007 1.38 1.35 2.095l-1.32.251c-.117-.766-.235-1.532-.03-2.347zM500.958 83.648c-1.202-.442-2.443-1.242-3.828-2.338 1.168.463 2.479 1.221 3.828 2.338z"/>
        <path fill="#FAFFFE" d="M511.974 184.651c-.877-.134-1.788-.59-2.844-1.332.84.146 1.825.578 2.844 1.332z"/>
        <path fill="#FCFFFE" d="M530.017 281.017c.75-1 1.525-1.975 2.639-2.986.34-.036.4.023.38.382-.994 1.133-1.969 1.907-2.943 2.68l-.076-.076zM503.956 86.692c-.946-.44-1.919-1.224-2.926-2.349.943.442 1.921 1.223 2.926 2.35zM191.965 351.632c-.949-.419-1.933-1.177-2.963-2.273.946.42 1.936 1.177 2.963 2.273z"/>
        <path fill="#DAFDF9" d="M548.718 127.48c.821-.129 1.723.06 2.947.396.277.67.232 1.193.054 2.092-1.062-.473-1.991-1.321-3.001-2.487z"/>
        <path fill="#FCFFFE" d="M342.63 62.003c-.728.658-1.831 1.316-3.283 1.966.737-.66 1.823-1.314 3.283-1.966z"/>
        <path fill="#DAFDF9" d="M273.877 183.11c1.173.524 2.345 1.049 3.826 1.698.307.124.339.592.34.827-1.107-.013-2.217-.261-3.69-.921-.402-.81-.439-1.207-.476-1.604z"/>
        <path fill="#FCFFFE" d="M187.881 224.642c-.7-.58-1.096-1.175-1.492-1.77.39-.14.78-.28 1.171-.418.208.724.416 1.448.321 2.188zM560.956 136.675c-.82.167-1.683.008-2.75-.413.765-.146 1.735-.029 2.75.413zM508.992 91.628c-.912-.436-1.831-1.245-2.888-2.332.869.467 1.875 1.213 2.888 2.332z"/>
        <path fill="#DAFDF9" d="M307.001 179.016c-.101.32-.29.573-.783.867-.795-.114-1.373-.331-2.094-1.034-.143-.486-.103-.904-.103-.904.744-.006 1.487-.012 2.602.29.371.309.378.781.378.781z"/>
        <path fill="#FCFFFE" d="M561.334 139.95c-.334-.7-.334-1.45-.334-2.575.223.592.446 1.56.334 2.576z"/>
        <path fill="#D3FDFA" d="M491.334 259.014c-.54-.025-.749-.06-1.113-.527.828-.78 1.81-1.13 2.794-1.48-.005.443-.01.886-.015 1.66-.444.333-.889.335-1.666.347z"/>
        <path fill="#FAFFFE" d="M549.013 154.987c-.678-.775-1.33-1.575-1.639-2.704.789-.33 1.234-.33 1.68-.332 0 0-.054.049-.046.394.031 1.086.055 1.827.08 2.568l-.075.074zM490.024 151.26c.869-.177 1.725-.006 2.794.417-.567.608-1.348.963-2.474 1.321-.34-.461-.337-.925-.32-1.738z"/>
        <path fill="#FCFFFE" d="M242.05 191.318c.7-.336 1.45-.335 2.575-.333-.13 2.241-1.058 2.633-2.576.333zM235.83 317.79c-.576.599-1.35.93-2.46 1.28.531-.504 1.396-1.025 2.46-1.28zM511.937 93.692c-.856-.139-1.756-.627-2.797-1.403.824.159 1.789.606 2.797 1.403z"/>
        <path fill="#DAFDF9" d="M292.91 193.766c-.842-.19-1.677-.73-2.636-1.553.797.213 1.72.708 2.636 1.553z"/>
        <path fill="#FCFFFE" d="M300.937 197.69c-.858-.137-1.76-.623-2.802-1.398.826.156 1.792.602 2.802 1.398zM325.652 65.007c-.435.64-1.223 1.285-2.332 1.948.446-.635 1.212-1.29 2.332-1.948z"/>
        <path fill="#B4F8EA" d="M548.998 151.625c-.39.327-.835.328-1.612.296-.364-.419-.395-.805-.437-1.482.657.093 1.325.477 2.049 1.186z"/>
        <path fill="#9AF9F1" d="M303.836 177.788c.185.157.145.575.134.782-.574.07-1.138-.068-1.874-.454.404-.327.98-.406 1.74-.328z"/>
        <path fill="#FCFFFE" d="M461.534 168.392c.116-.45.4-.727.701-.982.008-.006.213.221.327.34-.286.273-.573.546-1.028.642z"/>
        <path fill="#FAFFFE" d="M429.244 165.842c-.524-.066-.806-.293-1.072-1.037.578-.66 1.14-.805 1.702-.95 0 0 .102.11.156.165a5.74 5.74 0 0 1-.786 1.822z"/>
        <path fill="#FCFFFE" d="M213.96 348.68c-.404.303-.849.31-1.627.316-.102-.519.13-1.035.362-1.552.408.313.817.626 1.266 1.235z"/>
        <path fill="#FFF" d="M174.533 84.392c.117-.45.4-.727.702-.982.008-.006.213.222.326.34-.286.273-.572.546-1.028.642z"/>
        <path fill="#FCFFFE" d="M549.041 158.32c.598.133 1.237.586 1.918 1.36-.598-.133-1.237-.586-1.918-1.36zM454.171 156.23c.297-.55.765-.87 1.531-1.21-.254.466-.807.952-1.53 1.21zM541.32 150.959c.133-.598.587-1.236 1.361-1.914-.132.597-.586 1.235-1.36 1.914zM414.712 219.05c-.139.602-.603 1.236-1.389 1.913.14-.598.602-1.239 1.389-1.912zM472.959 60.675c-.598-.13-1.238-.582-1.92-1.353.598.13 1.238.581 1.92 1.353z"/>
        <path fill="#DAFDF9" d="M293.893 194.721c-.214.108-.542-.01-.936-.385.23-.118.526.021.936.385z"/>
        <path fill="#FAFFFE" d="M545.13 149.167c.19-.053.477.13.846.564-.195.057-.47-.135-.846-.564z"/>
        <path fill="#DAFDF9" d="M219.887 349.055c.09.346-.115.654-.604.959-.287-.174-.289-.344-.288-.77.2-.247.398-.237.892-.189z"/>
        <path fill="#05D299" d="M442.988 86.928c10.59-1.675 21.248-3.01 31.748-5.127 9.149-1.846 17.633-3.51 24.843 5.027 3.962 4.692 9.24 8.273 14.04 12.658a1310.951 1310.951 0 0 1-41.292 7.815c-20.028 3.455-40.101 6.642-60.122 10.133-14.287 2.49-28.519 5.292-43.388 8.196-1.335.334-2.057.427-3.216.438-3.835.387-7.262.707-10.626 1.355-7.354 1.416-14.676 2.998-22.38 4.458-1.102.038-1.835.13-2.986.139-6.302.854-12.201 1.706-18.068 2.744-13.344 2.362-26.66 4.894-40.012 7.212-15.8 2.742-31.635 5.287-47.44 8.003-8.95 1.538-17.862 3.303-26.808 4.864-11.233 1.961-22.616 3.26-33.686 5.891-9.41 2.236-17.923 6.809-23.732 15.127.14.128-.143-.123-.447 0-2.249 3.147-4.194 6.171-6.251 9.426-.125.401-.138.572-.439.93-1.528 2.796-2.768 5.406-4.268 7.998-.188.28-.116.579.002 1.282-.32 1.677-.684 2.949-1.17 3.873-.283-.618-.425-.904-.617-1.151-.071-.092-.258-.095-.393-.138-.094 1.649-.272 3.298-.272 4.947-.013 112.806-.03 225.612.058 338.417.003 3.905-.26 7.438-3.343 10.341-5.119-3.644-9.907-7.224-14.695-10.805 0 0-.022.019-.091-.234-.356-.408-.642-.564-.929-.72 0 0 .004-.03-.058-.447-.322-2.378-.806-4.34-.807-6.3-.03-51.987-.066-103.975.016-155.962.097-61.792.302-123.584.46-185.376.143-1.699.286-3.398.678-5.748.877-2.842 1.504-5.032 2.287-7.529.204-.756.253-1.207.563-1.816.416-.728.571-1.298.875-2.068.313-.514.336-.839.518-1.364 1.061-1.904 1.82-3.616 2.569-5.333-.012-.005.016.027.306-.134 1.101-1.72 1.911-3.276 2.722-4.833 0 0-.126-.11.23-.117.733-.689 1.109-1.37 1.485-2.053.37-.393.741-.785 1.504-1.564 4.837-4.705 9.281-9.025 13.726-13.345 0 0 .458-.058.996-.148 2.355-1.346 4.171-2.603 6.24-3.895.385-.14.519-.243 1.004-.338 3.338-1.433 6.326-2.876 9.313-4.318.292.174.595.199 1.352.095 1.66-.428 2.88-.876 4.534-1.324 5.251-.958 10.068-1.915 15.048-2.835.163.035.443-.148.888-.104 8.728-1.254 17.028-2.45 25.286-3.888 5.449-.949 10.836-2.245 16.251-3.385 1.058-.024 2.117-.049 3.972-.075 4.853-.959 8.91-1.915 12.967-2.87.803-.034 1.605-.068 3.064-.074 4.787-.948 8.919-1.924 13.05-2.9 1.058-.007 2.115-.014 3.99-.013 7.265-1.223 13.713-2.454 20.161-3.684 0 0 .016.018.22.081.203.064.558-.14 1.002-.145 5.66-1.004 10.875-2.002 16.09-3 .34.006.68.013 1.689-.056 5.802-1.056 10.937-2.037 16.266-2.998.196.02.525-.196.966-.149 8.526-1.228 16.636-2.375 24.691-3.824 5.569-1.002 11.062-2.422 16.59-3.655a666.2 666.2 0 0 0 4.21.246c4.481-.908 8.271-1.847 12.333-2.867.413-.409.556-.736.698-1.063.899.118 1.798.236 3.152.621 4.613-.67 8.77-1.605 13.244-2.5 1.377-.054 2.435-.148 3.86-.133 3.135-.33 5.92-.676 8.666-1.225 7.395-1.479 14.773-3.044 22.158-4.575.747.022 1.494.044 2.956.054 1.597-.318 2.479-.624 3.361-.93.657-.074 1.313-.148 2.706-.267 5.176-.96 9.617-1.873 14.057-2.787 0 0-.013-.086.295.007.732 0 1.156-.094 1.58-.189z"/>
        <path fill="#01CF93" d="M71.927 487.97c3.427.324 3.507 2.988 2.988 5.197-1.493 6.356 3.59 9.96 5.788 14.75.238.52 1.67 1.056 2.089.809.876-.519 1.912-1.486 2.046-2.393.314-2.12.208-4.316.141-6.477-.302-9.781-.928-19.562-.936-29.343-.073-90.912.055-181.824-.252-272.736-.022-6.448 3.794-10.517 5.642-15.757.618-1.75 1.118-3.64 1.156-5.478.083-3.959-.194-7.924-.248-11.888-.006-.417.412-.934.771-1.246 5.908-5.145 8.225-12.676 12.458-18.935 2.286-3.38 4.228-3.691 7.417-1.063-9.171 9.946-15.823 20.856-17.721 34.473-.417.361-.483.642-.431 1.325.022.843.086 1.322.15 1.801-.093.74-.186 1.481-.368 2.777-.273 1.071-.456 1.588-.9 2.1-.43.034-.6.07-1.163.206-.778 2.106-1.5 4.115-1.502 6.124-.06 68.574-.05 137.147-.05 205.721-.001 31.79-.027 63.58.027 95.37.009 4.772.507 9.54.564 14.313.035 2.963-.95 6.062-.357 8.862.67 3.161-.264 4.709-3.232 5.83-7.813-5.276-13.779-11.603-14.938-21.548.407-4.522.634-8.659.861-12.795z"/>
        <path fill="#ECFEFD" d="M91.979 185.89c.182-.516.365-1.033.744-1.742 4.478.328 4.569 2.624 3.42 6.188-1.135 3.52-2.042 7.304-2.046 10.974-.107 105.987-.088 211.974-.09 317.961 0 1.333.059 2.67-.02 3.999-.217 3.623-1.78 5.102-5.546 3.752-8.67-3.106-12.718-10.616-17.462-17.621-4.923-7.269-3.964-15.344-3.965-23.326-.016-99.988-.057-199.976.086-299.964.01-7.099.55-14.07 3.312-21.167 2.801-7.193 3.885-15.075 8.26-21.775.555-.851.318-2.27.314-3.426-.008-2.354.263-3.744 2.996-5.246 3.328-1.83 5.397-5.87 8.203-8.77 1.119-1.156 2.749-1.819 4.537-2.674-3.413 5.199-7.934 9.994-10.852 15.62-4.445 8.573-7.78 17.72-11.66 27.338-.095 1.482-.12 2.248-.428 3.232-.435 1.396-.586 2.575-.822 4.08-.069.775-.052 1.224-.176 2.06-.373 5.202-.805 10.014-.807 14.826-.039 101.71-.034 203.42.01 305.13 0 1.937.586 3.874.899 5.81 1.34 9.56 7.305 15.887 15.287 21.49 1.967.998 3.427 1.668 5.213 2.071.487-2.241.79-4.217.79-6.192.037-109.053.05-218.107.051-327.16 0-1.823-.162-3.645-.248-5.468z"/>
        <path fill="#DAFDF9" d="M128.719 194.233c1.24-2.61 2.479-5.22 4.033-7.636.617 1.926.92 3.659 1.223 5.391-.667 1.419-1.333 2.838-2.291 4.86-1.09 4.955-2.581 9.308-2.586 13.662-.128 114.828-.103 229.655-.363 344.594-.752.384-1.245.657-2.113.917-4.118-2.025-7.861-4.036-11.604-6.047-2.323-2.759-4.646-5.517-6.98-8.634 4.778 3.222 9.566 6.802 14.935 10.7 1.557 1.17 2.534 2.023 4.18 3.46v-8.175c-.004-110.547-.013-221.095-.002-331.642 0-5.322.17-10.643.261-15.965.364-1.272.728-2.544 1.186-4.414.093-.597.12-1.071.12-1.071zM106.268 192.043c.193 61.691-.012 123.483-.11 185.275-.08 51.987-.045 103.975-.015 155.962 0 1.96.485 3.922.792 6.297-1.136-1.517-3.05-3.348-3.335-5.404-.445-3.216.38-6.584.38-9.887.03-108.08.011-216.162.105-324.242.002-2.634 1.195-5.267 2.183-8.001z"/>
        <path fill="#ECFEFD" d="M93.457 177.765c1.707-13.5 8.359-24.41 17.875-34.212 9.912-9.296 20.823-16.43 33.917-19.334 9.66-2.142 19.494-3.501 29.254-5.186 15.632-2.698 31.267-5.377 46.9-8.065 3.915-.673 7.83-1.349 12.165-1.938-2.6 3.423-6.34 4.366-10.772 4.066-3.085-.21-6.687-1.227-8.852 2.532-.25.434-1.563.398-2.369.348-6.528-.41-12.832.22-18.854 3.125-1.286.62-3.142-.023-4.726.077-2.604.164-5.637-1.55-7.539 2.003-.387.722-2.396.649-3.674.808-8.436 1.052-16.893 1.951-25.307 3.156-2.897.415-5.658 1.698-8.535 2.345-5.551 1.25-6.24 1.89-7.565 8.018-.31.103-.703.38-.92.28-5.452-2.542-9.768-1.494-15.136 3.63-2.37 2.261-4.844 4.415-7.234 6.657-.458.43-1.039 1.035-1.06 1.58-.266 6.688-6.008 9.69-9.292 14.374-2.33 3.322-3.202 7.662-4.742 11.541-.707 1.782-1.455 3.548-2.597 5.369-.413.047-.525-.055-.591-.348-.16-.47-.253-.648-.346-.826zM236.28 109.3c7.292-1.826 14.858-3.443 22.463-4.858 12.816-2.385 25.64-4.74 38.49-6.93 15.148-2.58 30.327-4.976 45.492-7.448 8.482-1.383 16.965-2.759 25.873-4.026-1.061 1.391-2.774 3.955-3.998 3.74-7.344-1.292-13.541 2.931-20.398 3.617-3.036.303-6.161-.027-9.139.517-3.66.67-7.21 1.945-10.802 2.981-.474.137-1.07.715-1.338.573-5.804-3.075-10.6 2.535-16.386 1.8-4.136-.526-8.58 1.497-12.906 2.266-1.778.315-3.654.124-5.408.513-2.78.618-5.475 1.606-8.242 2.293-2.187.543-4.42.913-6.645 1.285-4.258.712-8.503 1.579-12.791 2.008-7.977.797-15.98 1.327-24.264 1.668z"/>
        <path fill="#DAFDF9" d="M214.703 125.621c-5.124 1.417-10.511 2.713-15.96 3.662-8.258 1.438-16.558 2.634-25.289 3.501-.441-1.204-.434-1.976-.427-2.749 5.122-.116 10.267.016 15.355-.459 2.345-.219 4.58-1.625 7.678-2.535 3.857-.71 6.898-1.379 9.94-2.047 2.804.117 5.608.234 8.703.627zM349.229 102.363c-5.045 1.406-10.538 2.826-16.107 3.828-8.055 1.45-16.165 2.596-24.693 3.495-.438-.815-.434-1.254-.43-1.692.441-.003.882-.005 1.955-.024 1.103-.338 1.575-.659 2.046-.98 5.18-.232 10.548 1.03 15.245-2.675 1.055-.831 3.21-.267 5.591-.36 1.21-.33 1.687-.643 2.164-.956l2.895-.047c1.15-.324 1.627-.636 2.105-.948 2.915.062 5.831.123 9.229.359z"/>
        <path fill="#FCFFFE" d="M114.858 550.285c3.903 1.7 7.646 3.711 11.806 6.088 1.723 1.12 3.03 1.873 4.335 2.627.263.494.525.988.894 1.74.107 1.01.107 1.76-.258 2.923-1.789.722-3.212 1.03-4.635 1.337l-1.121-3.964c-2.416-1.782-4.648-2.91-6.879-4.036-.468-.32-.936-.64-1.702-.98-2.04-.316-3.781-.612-6.536-1.08 1.36-1.501 2.649-2.922 4.096-4.655z"/>
        <path fill="#DAFDF9" d="M133.68 146.012c-4.043 4.346-8.487 8.666-13.254 13.095.365-1.548.605-3.731 1.822-4.764 3.509-2.976 4.736-9.088 11.432-8.33z"/>
        <path fill="#ECFEFD" d="M116.725 107.078c-4.4 3.326-9.215 6.604-14.38 9.858 1.02-4.463 8.58-9.682 14.38-9.858zM384.616 83.193c-.178 1.134-.766 2.19-1.485 3.525-3.648.13-7.166-.019-10.923-.453 3.84-1.24 7.92-2.195 12.408-3.072z"/>
        <path fill="#DAFDF9" d="M271.791 116.177c-6.041 1.335-12.49 2.566-19.364 3.712 2.352-1.258 5.131-2.433 8.68-3.747 2.826-.163 4.881-.188 6.937-.213 1.113.048 2.226.095 3.747.248zM289.007 113.136c-4.712 1.08-9.928 2.078-15.477 2.759-.058-1.166.219-2.013.496-2.86 4.826.006 9.653.012 14.981.1zM248.045 119.726c-4.13 1.229-8.261 2.205-12.752 3.095 2.716-1.341 5.79-2.596 9.65-3.847 1.547.002 2.311 0 3.075-.003.008.167.017.335.027.755zM307.27 110.144c-5.134.981-10.269 1.962-15.846 2.886 2.434-1.043 5.274-2.167 8.205-2.954 1.387-.373 2.947-.1 5.261-.114 1.348.065 1.864.123 2.38.182zM383.031 96.931c-4.157.937-8.313 1.873-12.652 2.526 3.466-1.352 7.113-2.42 11.188-3.51.603-.017.779-.012 1.213.237.256.411.254.58.251.747zM172.406 133.239c-4.817.956-9.634 1.913-14.933 2.806-.483-.063-.58-.193-.43-.417.421-.69.692-1.155.962-1.62 3.693-.347 7.385-.695 11.926-1.03 1.39.096 1.933.178 2.475.26z"/>
        <path fill="#ECFEFD" d="M205.743 124.714c-2.785.948-5.826 1.616-9.31 2.28 2.724-.856 5.888-1.708 9.31-2.28z"/>
        <path fill="#DAFDF9" d="M231.725 122.885a192.139 192.139 0 0 1-12.37 2.858c2.637-.994 5.681-1.911 9.512-2.83 1.265-.062 1.744-.124 2.222-.186 0 0 .428.09.636.158zM365.984 99.997c-3.79.938-7.581 1.877-11.712 2.724.218-.779.776-1.464 1.994-2.43 3.679-.285 6.698-.29 9.718-.294zM151.2 137.225a43.313 43.313 0 0 1-8.876 4.105c-.33-.988-.313-1.64-.295-2.293 2.912-.641 5.823-1.283 9.17-1.812z"/>
        <path fill="#ECFEFD" d="M366.255 99.915c-3.29.086-6.31.091-9.78.1 2.234-4.22 6.166-1.212 9.986-1.436.35.6.207.927-.206 1.336zM101.474 116.962c-1.656 2.024-3.686 4.044-6.054 6.107.213-3.43 1.56-6.13 6.054-6.107zM267.974 115.594c-1.986.36-4.041.385-6.536.407 1.549-3.18 3.793-3.968 6.536-.407zM111.24 173.608c.118.334.095.659-.531 1.173-.879.205-1.296.21-1.714.214.44-1.964.88-3.927 1.667-5.94.347-.048.358-.04.354.417.072 1.683.148 2.91.223 4.136zM123.116 104.149c-1.44 1.049-3.344 2.032-5.622 3.014-.657-4.85 2.977-2.66 5.622-3.014z"/>
        <path fill="#DAFDF9" d="M141.066 142.03c-1.817 1.257-3.633 2.514-5.785 3.749 1.08-1.294 2.495-2.565 4.563-3.832.842.03 1.032.057 1.222.083zM109.428 178.971c-.627 2.19-1.254 4.381-2.153 6.796-.048-1.872.176-3.968.796-6.426.396-.363.877-.379.877-.379l.48.009zM116.804 163.096a12.33 12.33 0 0 1-2.436 4.466c-.35-1.005-.361-1.785-.372-2.566.825-.64 1.65-1.28 2.808-1.9z"/>
        <path fill="#ECFEFD" d="M113.64 165.038c.367.739.378 1.519.437 2.686.048.387.02.355-.3.35-1.131.31-1.944.626-2.757.94l-.016-.011c.756-1.31 1.518-2.617 2.636-3.965zM172.57 133.275a41.08 41.08 0 0 0-2.203-.314c.385-.982 1.182-1.934 2.32-2.905.333.752.326 1.524.322 2.684.003.387-.277.57-.44.535zM307.465 110.164c-.711-.079-1.227-.137-2.131-.227.505-.829 1.4-1.625 2.48-2.183.181.678.177 1.117.175 1.885.001.329-.328.545-.524.525z"/>
        <path fill="#DAFDF9" d="M157.039 136.046c-1.171.512-2.391.96-3.853 1.263.219-.53.68-.913 1.778-1.328 1.069-.064 1.5-.096 1.93-.129l.145.194z"/>
        <path fill="#ECFEFD" d="M141.317 141.995c-.441.009-.631-.017-1.106-.086.188-.962.662-1.881 1.477-2.836.323.617.305 1.27.285 2.248-.136.43-.27.535-.656.674zM247.962 118.641c-.708.332-1.472.335-2.617.32a5.823 5.823 0 0 1 2.617-.32zM157.044 135.628c-.58.257-1.011.29-1.767.306.46-.651 1.243-1.288 2.378-1.925.08.464-.19.93-.611 1.62zM273.658 113.085c.09.797-.186 1.644-.572 2.815-.11.323-.465.527-.661.473a7.864 7.864 0 0 1 1.233-3.288zM311.828 106.763c-.3.548-.77.87-1.543 1.204.257-.468.814-.95 1.543-1.204zM339.832 101.776c-.31.54-.787.852-1.567 1.166.265-.464.832-.929 1.567-1.166zM334.83 102.772c-.307.54-.784.854-1.564 1.171.264-.463.83-.931 1.565-1.171zM109.584 178.665c-.156.306-.636.297-.636.297s-.48.016-.722.018c-.096-.548.05-1.097.669-1.812.646-.164.818-.162.99-.16-.048.45-.097.9-.3 1.657z"/>
        <path fill="#DAFDF9" d="M110.147 176.849c-.434.157-.606.155-1.036.128-.218-.46-.179-.894-.127-1.655.429-.332.846-.336 1.576-.34.158.57.003 1.139-.413 1.867zM118.53 160.993c-.054.636-.43 1.318-1.109 2.07.06-.627.423-1.326 1.108-2.07z"/>
        <path fill="#ECFEFD" d="M231.009 122.462c-.398.327-.877.389-1.718.419.304-.25.97-.467 1.718-.42zM93.236 180.857c-.315-.327-.38-.806-.154-1.602.454-.335.62-.353.787-.37 0 0 .112.101.168.154a5.474 5.474 0 0 1-.801 1.818z"/>
        <path fill="#DAFDF9" d="M107.085 540.266c.21-.083.496.073.856.469-.21.083-.495-.073-.856-.469z"/>
        <path fill="#F8FEFE" d="M410 483c2.481 2.977 4.653 6.42 9.521 5.21.607-.15 1.823.794 2.253 1.526 1.534 2.613 1.19 6.698 5.664 6.901-.792 1.903-1.584 3.806-2.727 6.063-.554.373-.755.39-1.244.237-4.501-6.972-9.139-13.332-16.874-16.655 3.386 8.466 6.405 16.631 3.447 25.668-.1.003-.116.2-.298.22-.182.018-.368.332-.368.332s.183.316.032.697c-.219 1.197-.287 2.013-.637 2.95-.42.693-.56 1.265-.892 2.113-1.134 2.023-2.076 3.771-3.258 5.647-.401.44-.563.752-.898 1.207-.368.373-.54.617-1.06.873-.862-.004-1.353-.002-1.833-.464-.038-4.79-.087-9.116-.014-13.779-.411-1.27-.945-2.206-1.503-3.505-3.567-10.456-12.202-18.173-18.572-16.725 1.147 2.495 2.278 4.957 3.451 7.663.177.552.377.811.652 1.38.278 1.017.545 1.674.713 2.542-.062.555.117.793.438 1.284.062 1.075.125 1.791.072 2.97-.116 4.454-.116 8.447-.116 12.829-2.24-.482-3.65-.786-5.437-1.179-4.858-1.127-9.291-2.68-13.83-3.112-18.123-1.722-33.414 4.673-46.174 17.304-2.707 2.68-3.699 2.059-4.526-1.513.015-1.842-.001-3.26.372-4.678 4.05 1.077 7.072.667 9.296-2.988.642-1.055 2.411-1.536 3.755-2.032 5.999-2.216 10.793-7.88 18.1-6.357 2.795-4.582 7.234-2.282 11.037-2.625 2.137-.193 4.299-.586 6.415-.427 3.62.271 7.25.721 10.799 1.462 1.85.387 3.539 1.553 6.513 2.928-.22-4.717.838-9.023-.716-10.416-5.024-4.505-5.074-8.947-2.805-14.657 1.87-4.708 4.366-6.219 8.946-4.226 1.067.464 2.675 1.062 3.438.604 3.042-1.824 4.928-.19 6.908 2.09 1.086 2.962 3.01 4.717 5.585 3.026 2.41-1.583 1.816-3.835-.625-5.721 0-.778 0-1.223.313-1.822A870.118 870.118 0 0 1 410 483zM542.993 524.982a107.648 107.648 0 0 1-5.688 5.862 289.627 289.627 0 0 1-8.376 3.044c-3.72.349-6.761.271-9.734.688-4.457.626-8.869 1.58-13.293 2.43-3.306.636-6.602 1.329-9.902 1.996-1.714 0-3.428 0-5.956-.052-4.898-2.18-2.303-5.984-3.045-8.95a29.84 29.84 0 0 1 1.286-2.841c.446-1.893.544-3.308.673-4.72.132-1.445-.21-3.244.522-4.273 5.184-7.294 3.61-15.482 3.122-23.41-.305-4.953-1.698-9.84-2.603-14.756 2.189-2.538.48-4.133-1.689-6.273-.624-3.165-.939-5.75-1.253-8.334l-1.343-.014-3.41 5.59-2.144-9.32c-5.919 3.128-10.446-6.645-15.912-1.41l-9.25-4.238s-.499 0-.744-.436c-.173-1.302-.1-2.169.339-2.963 2.042.445 3.718.818 5.728 1.374 9.453 3.134 18.595 6.02 27.665 9.116 1.124.384 2.55 1.797 2.683 2.876 1.697 13.692 3.332 27.396 4.617 41.132.31 3.323-.44 6.83-1.174 10.15-1.431 6.467-3.196 12.861-5.01 20.02 2.847-.713 5.399-1.566 8.02-1.968 8.168-1.254 16.433-1.988 24.523-3.613 5.038-1.012 9.825-3.27 15.1-5.017 2.268-.666 4.162-1.285 6.056-1.904l.192.214z"/>
        <path fill="#FCFFFE" d="M410 482.609c-2.124 1.287-4.249 2.184-6.935 3.035-.18-1.726.2-3.408.58-5.08l-4.849-4.584c3.113-3.343 5.32-6.2-.924-7.364-.378-.07-.585-1.055-.446-1.615 2.951.547 5.509.979 7.995 1.67 4.2 1.166 8.216-.575 7.348-3.457-1.12-3.714-2.37-7.864-7.726-7.537.892-1.739 2.454-3.04-.148-4.506-.932-.525-1.281-2.082-1.46-3.168 5.147 0 9.857.002 14.567.003-1.07.994-1.986 2.316-3.246 2.902-1.682.782-3.63.994-5.723 1.515 2.845 4.116 5.501 7.608 7.771 11.336 2.58 4.236 1.253 6.815-2.829 9.626-1.962 1.351-2.688 4.499-3.975 7.224zM455.06 456.356c2.857.982 5.775 2.319 9.188 3.882 5.466-5.234 9.993 4.54 15.912 1.412l2.145 9.32 3.41-5.591 1.342.014c.314 2.584.629 5.169.943 8.18-1.148.522-2.4.356-3.426.762-3.015 1.195-3.962.024-4.736-2.893-1.774-6.687-7.314-8.486-13.624-5.49-1.76.835-4.667-.137-6.786-.956-.895-.346-1.028-2.484-1.663-3.729-.798-1.561-1.755-3.041-2.705-4.911zM496.197 539.277c3.103-.942 6.399-1.635 9.705-2.27 4.424-.851 8.836-1.805 13.293-2.43 2.973-.418 6.015-.34 9.415-.53-.727 3.623-2.614 5.686-6.893 4.144-1.448-.522-3.241-.082-4.93-.082l1.634 5.683c-2.034.403-4.055 1.048-6.103 1.152-3.229.165-6.68.629-9.65-.288-2.389-.738-4.204-3.334-6.47-5.38z"/>
        <path fill="#FEFEFE" d="M461.001 530c3.113.184 5.929.823 7.17 4.24.206.569.82 1.027 1.32 1.449 7.03 5.93 6.774 7.663-1.659 12.412-2.064 1.162-3.94 2.656-6.903 4.682-.31-2.303-.62-4.613-.67-7.55.444-1.47.629-2.312 1.163-3.243 4.237-4.323 1.703-8.143-.42-11.99z"/>
        <path fill="#F8FEFE" d="M418.47 450.004c-5.178 0-9.888 0-15.463-.002-2.577.002-4.29.005-6.467.004-4.524-.45-8.584-.898-12.377-1.596 2.788-.644 5.31-1.038 8.264-1.363 2.478-.02 4.522-.108 7.03-.133 8.826.014 17.185-.034 25.982.018 3.114.109 5.792.116 8.606.245.357.217.586.288 1.16.616 1.488.253 2.64.224 4.163.236 2.185.579 4.001 1.116 5.458 1.746-.85.147-1.342.203-1.834.258-8.017-.01-16.035-.02-24.521-.029zM428.12 511.987c1.065-.567 2.236-.999 3.172-1.731 1.407-1.102 2.9-3.62 3.915-3.41 2.955.616 6.839.847 6.885 5.52.013 1.273.587 2.54.907 4.22.005.41-.017.428-.276.317a31.508 31.508 0 0 1-1.754-.867c.016-.02-.033-.01-.003-.383-.782-2.089-1.372-3.985-2.536-5.414-.374-.46-2.262.313-3.496.924-.062 1.209-.084 2.016-.258 2.92-.035.377.082.655.263 1.394.02 5.14-.022 9.818-.33 14.729-.968 3.144-1.672 6.056-2.421 8.993-.047.025.058.024-.35-.038-.954-.106-1.502-.149-2.103-.513-.006-.75.042-1.18.414-1.885.45-5.687.809-11.11.568-16.507-.08-1.8-1.7-3.53-2.72-5.555-.147-.638-.187-1.013-.122-1.714.152-.552.198-.776.245-1z"/>
        <path fill="#FCFFFE" d="M489.637 480.06c1.267 4.857 2.66 9.743 2.965 14.696.488 7.928 2.062 16.116-3.122 23.41-.731 1.029-.39 2.828-.522 4.273-.129 1.412-.227 2.827-.648 4.4-.87-.851-1.18-2.238-2.035-2.81-3.714-2.484-1.893-4.92.18-6.867 4.65-4.37 5.01-9.843 4.205-15.474-.77-5.383-2.406-10.643-3.153-16.028-.24-1.73 1.132-3.686 2.13-5.6z"/>
        <path fill="#F8FEFE" d="M460.742 529.893c2.383 3.954 4.917 7.774.594 12.021-.436.012-.612-.136-.629-.548-.157-3.593.455-7.046-2.944-9.757l-2.21 5.57c-2.554-3.876-1.758-6.304 3.062-8.175.88.256 1.373.52 2.127.89z"/>
        <path fill="#FCFFFE" d="M486.632 530.07c1.11 2.896-1.486 6.7 2.983 8.88-1.506.553-3.397 1.054-5.289 1.555-.158-1.599-.698-3.28-.379-4.777.414-1.939 1.514-3.731 2.685-5.657zM442.996 450.424c.488-.446.98-.502 1.808-.637.337-.08.38-.076.327.318 1.378 4.797 2.256 4.938 6.117 1.255.416-.169.579-.246.98-.207.414.084.589.051.967.12.203.1.648.01.649-.053 0-.061-.105.003-.034.226.283.472.398.758.417 1.083-.073.867-.146 1.734-.223 3.036-1.722.288-3.522-.261-5.14.073-4.17.86-5.768-.959-5.868-5.214z"/>
        <path fill="#BEFBF5" d="M428.069 511.594c.004.617-.042.841-.457 1.188-1.053-1.214-1.736-2.551-2.586-4.227-.535-2.042-.903-3.745-1.271-5.447.201-.018.402-.035.906-.044 1.321 2.718 2.339 5.427 3.408 8.53z"/>
        <path fill="#F8FEFE" d="M460.986 542.002a9.238 9.238 0 0 1-.727 2.805c-1.326.2-2.392.198-3.858.199-.672-.634-.945-1.269-.8-2.202 1.985-.54 3.554-.783 5.123-1.026 0 0 .176.148.262.224zM446.996 521.635c-.429.367-.861.369-1.678.03-1.035-1.777-1.685-3.214-2.336-4.651l.032-.028c1.333 1.42 2.656 2.853 3.982 4.649z"/>
        <path fill="#FFF" d="M397 467.001c.287.56.494 1.544.872 1.615 6.244 1.165 4.037 4.02.924 7.364 1.673 1.58 3.254 3.076 4.848 4.583-.379 1.673-.76 3.355-.892 5.237.248.644.248 1.089-.01 2.067-.741 3.905-2.982 2.345-4.742 2.133-1.94-1.918-3.826-3.552-6.868-1.728-.763.458-2.371-.14-3.438-.604-4.58-1.993-7.075-.482-8.946 4.226-2.27 5.71-2.219 10.152 2.805 14.657 1.554 1.393.497 5.7.716 10.416-2.974-1.375-4.662-2.541-6.513-2.928-3.55-.74-7.18-1.19-10.799-1.462-2.116-.159-4.278.234-6.415.427-3.803.343-8.242-1.957-11.037 2.625-7.307-1.524-12.101 4.14-18.1 6.357-1.344.496-3.113.977-3.755 2.032-2.224 3.655-5.246 4.065-9.346 2.585a77.84 77.84 0 0 1 .064-13.643c1.1-1.376 1.842-2.71 2.582-4.466.024-2.111.05-3.8.471-5.492 1.767-.995 3.14-1.987 4.512-2.98-1.12-1.226-2.019-2.913-3.407-3.574-2.251-1.073-4.182-.37-4.867 2.619-2.784 2.69-5.225 5.312-7.986 8.073-1.247 1.284-5.462.403-2.641 4.24-.034 1.107-.047 1.846-.113 2.83-.119.397-.185.55-.55.754-1.295.724-2.291 1.399-3.707 2.062-3.85-.35-7.278-.691-10.703-1.43.015-1.467.024-2.533.308-3.814.308-2.128 3.646-4.349-.32-6.233-1.564.06-3.46.02-4.48.945-2.428 2.2-4.158 6.582-6.678 6.997-6.842 1.127-4.581 4.905-3.766 8.988-.38 1.74-.712 3.13-1.4 4.557-3.527 1.829-6.17 3.835-3.598 8.347-.029 1.12-.059 1.865-.432 2.668-1.762 2.549-3.025 5.148-4.659 7.489-.951 1.365-2.458 2.362-3.782 3.443-1.328 1.083-2.74 2.064-4.12 3.322-.003.232-.024.696-.394.765-.793 1.69-1.216 3.31-1.639 4.93-6.197 2.215-5.998 6.414-3.154 11.056-3.676-.765-7.092-1.306-10.385-2.266-.981-.286-2.352-1.799-2.292-2.663.318-4.634-2.505-5.564-6.536-5.949-.374 7.806-5.668 11.684-12.503 14.646-1.477-.724-2.303-1.274-3.129-2.224 0-1.467 0-2.533.285-3.866.095-8.067-.094-15.869-.286-23.67-.04-1.657-.352-3.359-.078-4.96.494-2.885 1.234-5.74 2.087-8.542.317-1.041 1.842-1.935 1.787-2.833-.356-5.819 3.414-5.927 7.5-5.726 3.595.177 5.417-1.25 5.888-5.08.177-1.447 2.526-2.54 3.643-3.98 1.156-1.49 2.018-3.208 3.01-4.826-1.656-.636-3.276-1.6-4.98-1.787-1.053-.115-2.235.957-4.08 1.84-.315-2.13-.541-3.664-.418-5.233 1.127-1.3 1.905-2.566 2.826-3.95.142-.12.512-.124.852-.09.894-.552 1.449-1.138 2.185-1.834.182-.11.607-.135 1.045-.11 2.63.538 4.801 1.314 7.022 1.5 2.55.211 5.144-.1 7.718-.184l-.338-5.234c4.296-1.986 9.195-3.487 13.175-6.293 4.59-3.235 9.289-2.654 14.273-2.965 3.485-.217 7.534-1.776 10.054-4.113 2.456-2.278 3.289-6.307 5.114-9.73.704-.206 1.129-.252 1.747.012 2.401-.04 4.6-.515 6.822-.675.833-.06 2.111.398 2.46 1.024.304.544-.143 2.052-.728 2.459-4.185 2.911-8.49 5.65-13.246 8.764v3.898c3.176.78 6.03 1.567 8.925 2.143 1.049.209 3.035.201 3.177-.203 1.973-5.642 6.072-3.43 10.014-2.583v-5.637c2.89 1.16 5.084 2.117 7.334 2.914 1.192.422 2.846 1.199 3.664.727 3.352-1.932 6.545-4.176 9.6-6.557.713-.555.654-2.1 1.237-3.328.705-.163 1.124-.186 1.792.13 6.22 2.122 11.787 2.177 17.793-.697 4.534-2.169 10.048-2.291 15.29-3.01.86.665 1.666 1.442 2.233 1.296 4.407-1.14 8.287-1.447 11.21 3.232.994 1.59 3.48 2.38 4.743-.882 2.118-1.68 3.883-3.32 5.982-4.96H397m-28.774 5.24-4.77-.288c1.858 3.351 3.663 4.327 4.77.288z"/>
        <path fill="#03D198" d="M304.667 514.913c.067-.153.133-.306.557-.843 1.062-1.634 1.767-2.883 2.577-4.341.106-.208.228-.659.576-.716 2.316-1.72 4.284-3.383 6.253-5.046l1.123.904c-.995 3.66-1.912 7.342-3.002 10.972-1.807 6.014-.372 11.337 3.2 16.266.858 3.147 1.85 3.768 4.557 1.088 12.76-12.631 28.051-19.026 46.174-17.304 4.539.431 8.972 1.985 13.933 3.467 2.614 2.327 6.062 4.66 6.948.918.977-4.122-.804-8.896-1.383-13.386-.062-.716-.125-1.432-.14-2.718.021-.88-.123-1.118-.386-1.283a11.678 11.678 0 0 1-.774-2.603c-.226-.872-.478-1.112-.731-1.353l-3.41-7.42c6.37-1.447 15.005 6.27 18.49 17.055.45 1.633.957 2.573 1.463 3.512.05 4.327.098 8.653-.135 13.594a19.813 19.813 0 0 0-.614 3.002l3.088-2.684c.15-.26.322-.505.973-.954.59-.566.722-.912.855-1.259.942-1.748 1.884-3.496 3.303-5.546.615-.936.752-1.572.889-2.207.068-.816.136-1.632.457-2.913.368-.612.422-.778.416-.964 0 0 .017-.198.475-.188 4.624-3.869 9.452-4.663 14.793-3.069.684 1.337 1.367 2.674 2.315 4.215.303.58.343.954.447 2.025.666 7.766 1.269 14.835 1.871 21.904-.048.43-.096.86-.293 1.9-.93 3.432-1.71 6.254-2.821 9.064-.766.061-1.2.134-2.054.137-6.616.954-12.832 1.869-19.002 3.03-7.125 1.34-14.208 2.898-21.31 4.361-.562-.092-1.123-.183-2.223-.374-4.755.922-8.971 1.942-13.547 2.916-1.078.004-1.798.054-2.94.029-4.833.947-9.243 1.97-13.653 2.994-.73-.02-1.461-.042-2.972-.088a6265.428 6265.428 0 0 0-62.515 10.636c-2.662.466-5.249 1.362-8.145 2.043-.624.094-.973.202-1.75.238-2.904-.44-6.636 1.459-6.902-3.11-.334-5.713-.501-11.456-.32-17.172.136-4.237.943-8.452 1.517-12.99.08-.741.092-1.168.327-1.64.222-.045.67-.102 1.02-.113.635-1.37.92-2.73 1.277-4.317.072-.227.358-.608.753-.61 2.45-3.971 4.519-7.932 6.508-11.933.083-.167-.577-.705-.898-1.376.315-.785.637-1.263 1.38-1.707 4.584 1.03 2.036 4.397 2.742 6.613 1.03 3.235-1.16 7.757 3.918 9.65.142.398.144.573-.135.977-.56 5.67 4.41 10.953 10.8 11.507.61-5.994.851-11.882 1.169-18.13.092-1.099.108-1.836.374-2.827 1.68-4.114 3.108-7.973 4.537-11.833z"/>
        <path fill="#0BCF96" d="m434.874 529.973.135-14.757c-.056-.892-.119-1.061-.18-1.23.021-.807.043-1.614.44-2.716 2.14 1.389 3.903 3.072 5.667 4.756 0 0 .049-.01.017.376 1.014 2.471 2.06 4.558 3.105 6.644.003.427.005.854.023 2.005.646 5.59 1.446 10.445 1.803 15.332.102 1.398-.836 3.956-1.717 4.159-4.17.96-8.485 1.289-12.991 1.874l1.07-7.193s-.105.001.255-.21c1.03-3.153 1.701-6.097 2.373-9.04z"/>
        <path fill="#DAFDF9" d="M211.963 587.968a439.248 439.248 0 0 1-4.39.025c-2.144.003-3.86.007-5.98.008-3.471.992-6.536 1.988-10.068 2.986-5.82.005-11.172.008-16.864-.025-2.125-1.318-3.91-2.601-5.277-3.93 10.185 2.697 19.914 1.845 30.05-.297 1.221-.143 2.022-.34 2.91-.435.086.103.288-.074.288-.074s-.207-.174-.027-.212c.18-.037.366-.355.719-.264 1.793-.176 3.234-.444 5.076-.675 3.781-.285 4.542-1.833 3.05-4.926-1.612-3.342-2.895-6.843-4.384-10.65-.658-3.799-1.254-7.222-1.496-10.56 1.363.749 2.372 1.414 3.391 2.493.017 1.8.024 3.185.027 4.97.008 1.465.018 2.53.056 3.926.995 1.441 1.964 2.552 2.932 3.663.91 2.785 1.82 5.57 2.865 8.929.135.575.13 1.07-.131 1.259-1.09 1.39-1.918 2.59-2.747 3.79z"/>
        <path fill="#BEFBF5" d="M278.624 573.701c2.622-.696 5.21-1.592 7.871-2.058 20.57-3.6 41.155-7.118 62.156-10.558.394.483.366.864-.077 1.548-2.132.664-3.849 1.025-5.566 1.386-3.386.318-6.771.636-10.878.991-1.196.342-1.671.648-2.146.953-1.436.626-2.872 1.252-5.064 1.936-2.144.07-3.532.08-4.92.093-1.066-.001-2.132-.002-3.922.05-1.193.684-1.663 1.318-2.132 1.951-4.672.326-9.343.652-14.841.996-2.585.678-4.345 1.338-6.104 1.998-3.377.327-6.753.653-10.99.995-1.703-.083-2.545-.182-3.387-.28z"/>
        <path fill="#15CC96" d="M263.016 576.07c-.4-.062-.8-.123-1.569-.52-.958-1.24-1.547-2.144-2.136-3.048a221.836 221.836 0 0 1-.022-5.546c-.367-3.537-.777-6.255-1.158-9.366.031-1.448.033-2.502.386-3.528 1.714 1.678 3.075 3.327 4.43 5.268.27.785.547 1.278.85 2.146 1.669 4.55 3.313 8.723 4.936 12.846l-5.717 1.748z"/>
        <path fill="#BEFBF5" d="M263.266 576.361c1.252-.75 2.753-1.21 5.467-2.039-1.623-4.123-3.267-8.296-4.502-12.88 1.205-2.04 2.267-3.597 2.75-5.317 1.406-5.019 2.581-10.102 3.847-15.16-.507 4.225-1.314 8.44-1.45 12.677-.181 5.716-.014 11.46.32 17.172.266 4.569 3.998 2.67 6.894 3.477.367 1.172.314 1.903.261 2.634-4.446-.091-8.891-.181-13.587-.564zM431.839 539.16c.097 2.144-.212 4.226-.663 7.256 4.506-.585 8.821-.914 12.991-1.874.88-.203 1.819-2.76 1.717-4.16-.357-4.886-1.157-9.74-1.731-15.018.78.201 1.5.814 2.544 1.941.67 4.91 1.016 9.304 1.362 13.698-.038 1.037-.076 2.074-.45 3.586-.792 1.438-1.25 2.402-1.708 3.365l-7.796.01c-1.216.008-1.66.014-2.532.013-2.142.018-3.856.044-5.94.055-1.11-.016-1.85-.017-2.59-.018.78-2.822 1.56-5.644 2.543-8.755.75-.247 1.298-.204 2.253-.098zM384.674 555.953c6.773-1.886 13.856-3.443 20.98-4.784a218.54 218.54 0 0 1 18.99-2.733c.39.764.37 1.16.35 1.556a75.07 75.07 0 0 1-3.038.824c-1.07.135-1.515.146-2.369.15-2.844.984-5.277 1.976-7.71 2.967a13.834 13.834 0 0 1-2.646-.237c-1.091-.049-1.666.116-2.24.282-3.394.292-6.788.584-10.957.94-2.204.717-3.633 1.37-5.062 2.024-1.99-.189-3.98-.377-6.298-.989z"/>
        <path fill="#F8FEFE" d="M366.057 558.176c.72-.05 1.44-.1 2.536.134.377.283.395.759.395.759-.29 1.092-1.062 2.332-.782 3.251.994 3.27-.1 5.346-3.37 5.258-3.272-.088-6.701-.926-5.453-6.127 2.483-1.388 4.579-2.331 6.674-3.275zM293.035 573.346c1.725-1.019 3.485-1.68 5.605-2.337.818 1.64 1.133 3.338 1.79 4.892.362.858 1.741 1.399 1.88 2.215.246 1.462-.099 3.025-.197 4.545-1.336-.37-3.185-.317-3.91-1.194-1.966-2.377-3.455-5.148-5.168-8.121z"/>
        <path fill="#22C9A4" d="M460.707 541.366c-1.552.655-3.12.897-5.035 1.077-.28-1.544-.215-3.026-.135-4.887.66-2 1.304-3.622 2.226-5.947 3.4 2.711 2.787 6.164 2.944 9.757z"/>
        <path fill="#FDFEFD" d="M234.448 561.759c1.435 1.868 2.632 4.01 3.223 5.067-3.032 2.95-5.128 5.17-7.451 7.121-.6.504-1.914.155-2.9.198.484-1.438.631-3.842 1.509-4.147 3.972-1.381 4.82-4.492 5.619-8.24z"/>
        <path fill="#F8FEFE" d="M212.239 574.098c-1.231-1.218-2.2-2.329-2.818-3.775l5.908-5.693L217 567c0 1.067 0 2.133-.006 3.956-1.002 1.852-1.998 2.948-2.995 4.044-.499-.265-.998-.53-1.76-.902z"/>
        <path fill="#FDFEFD" d="M252.383 586.044c-.383-.794-.383-1.544-.383-2.669.776-1.158 1.932-2.748 2.264-2.59 2.066.974 3.947 2.34 5.888 3.578l-.54 2.148c-2.283-.14-4.564-.282-7.23-.467zM214.97 583.99s.006-.495.012-.743c1.757.058 3.508.363 5.638.71-.4 2.304-.867 4.767-2.13 6.715-.436.672-2.853.06-4.07-.36 3.7-2.229 3.363-4.222.55-6.322z"/>
        <path fill="#F8FEFE" d="M385.627 566.267c-.478-1.58-.63-2.978-.782-4.376 1.356-.096 2.888-.615 4.008-.146.817.342 1.09 1.984 1.606 3.047-1.502.552-3.004 1.104-4.832 1.475zM448.422 540.93c-.71-4.321-1.056-8.715-1.474-13.488 4.981 1.887 5.727 7.272 1.474 13.488z"/>
        <path fill="#BEFBF5" d="M365.635 558.1c-1.673 1.02-3.769 1.963-6.254 2.943-2.558.213-4.726.39-7.147.31 4.158-1.281 8.568-2.305 13.4-3.252zM369.323 559.046c-.335.023-.353-.453-.37-.69 4.198-1.258 8.414-2.278 12.878-3.19.121.758-.006 1.409-.913 2.425-3.827.732-6.875 1.098-9.922 1.464-.446-.01-.893-.021-1.673-.009z"/>
        <path fill="#F8FEFE" d="M371.043 559.415c3-.726 6.048-1.092 9.523-1.462-1.614 3.898-6.52 4.804-9.523 1.462zM412.283 553.963c2.027-1.021 4.46-2.013 7.303-2.644.077 1.468-.254 2.574-.586 3.681-2.103-.336-4.207-.672-6.717-1.037z"/>
        <path fill="#FDFEFD" d="M214.177 575.327c.819-1.423 1.815-2.52 2.818-3.971.831.194 1.657.744 2.744 1.469.352 5.255-1.994 5.152-5.562 2.502z"/>
        <path fill="#FCFFFE" d="M430.004 548.047c1.713-.026 3.427-.052 5.569.266.427.791.427 1.24.427 1.687l-.562 2.889c-1.89-.888-3.451-1.622-5.225-2.948-.211-1.026-.21-1.46-.21-1.894z"/>
        <path fill="#BEFBF5" d="M444.273 522.925c-1.26-1.965-2.306-4.052-3.335-6.504.52-.12 1.023.126 1.785.482.91 1.548 1.56 2.985 2.27 4.764-.063.652-.252.918-.72 1.258z"/>
        <path fill="#F8FEFE" d="M258.165 554.034c-.001 1.054-.003 2.108-.368 3.561-.808.414-1.253.428-1.697.442-.184-.007-.367-.014-.826-.029.148-1.628.57-3.248 1.498-4.706.801.353 1.097.542 1.393.732zM320.04 568.347c1.348-.367 2.736-.379 4.54-.386-.695 3.775-2.293 4.296-4.54.386z"/>
        <path fill="#BEFBF5" d="M256.091 558.344c.453-.32.898-.335 1.677-.355.744 2.712 1.154 5.43 1.46 8.576-.5-.975-.899-2.378-1.34-4.488-.638-1.203-1.233-1.7-1.828-2.196l.031-1.537z"/>
        <path fill="#F8FEFE" d="M429.633 548.032c.37.449.369.883.368 1.642-1.53.5-3.059.674-4.797.583-.19-.66-.17-1.057-.139-1.75.446-.37.88-.444 1.646-.505 1.071.013 1.811.014 2.922.03z"/>
        <path fill="#FDFEFD" d="M249.334 575.966c-.651-.753-.968-1.54-1.31-2.647 1.123-.262 2.27-.205 3.417-.148-.59.92-1.182 1.84-2.107 2.795z"/>
        <path fill="#F8FEFE" d="M277.227 576.92c-.321-.726-.268-1.457-.207-2.556.357-.476.706-.584 1.33-.678 1.116.114 1.958.213 3.225.314-1.041.973-2.507 1.943-4.348 2.92zM343.261 564.294c1.464-.636 3.181-.997 5.297-1.374-1.415.539-3.23 1.094-5.297 1.374zM391.174 557.201c1.227-.913 2.656-1.566 4.455-2.218a16.907 16.907 0 0 1-4.455 2.218z"/>
        <path fill="#FCFFFE" d="M419.211 555.25c.12-1.357.452-2.463.785-3.924.445-.364.89-.375 1.668-.385a13.823 13.823 0 0 1-2.453 4.31z"/>
        <path fill="#F8FEFE" d="M446.263 547.921c.096-.93.554-1.894 1.347-2.943-.105.913-.545 1.912-1.347 2.943z"/>
        <path fill="#BEFBF5" d="M259.196 572.903c.704.503 1.293 1.407 1.946 2.643-.643-.526-1.352-1.385-1.946-2.643z"/>
        <path fill="#F8FEFE" d="M256.07 560.205c.585.173 1.18.669 1.776 1.484-.588-.175-1.177-.667-1.776-1.484zM330.151 566.198c.308-.54.783-.846 1.554-1.164-.264.458-.825.928-1.554 1.164zM407.14 554.212c.425-.4 1-.565 1.737-.519-.42.392-1.003.573-1.736.519zM314.271 569.958c.144-.598.614-1.232 1.407-1.895-.144.6-.613 1.23-1.407 1.895zM436.322 549.958c-.322-.406-.322-.854-.321-1.637.444-.343.888-.35 1.665-.347-.119.653-.57 1.298-1.344 1.984z"/>
        <path fill="#FEFEFF" d="M191.992 590.985c3.065-.996 6.13-1.992 9.6-2.652.408.78.408 1.223.409 1.667-10.194 7.023-20.745 8.838-32.048 2.528-4.127-2.304-8.216-3.71-12.995-.43-2.335 1.603-5.985 1.567-9.057 1.651-.932.025-2.451-1.897-2.772-3.163-.68-2.686-1.69-5.84-.888-8.244 2.128-6.39-1.874-10.685-3.955-15.984.214-.358.714-.358 1.046-.358l1.66.002c2.167 3.04 4.134 6.253 6.57 9.06 1.659 1.912 3.972 3.257 6.605 4.929 1.007.418 1.401.764 1.797 1.426.01.74.016 1.161-.241 1.798-1.453 2.084-2.642 3.953-4.24 6.466 4.206-1.475 7.337-2.573 10.733-3.397 1.266.35 2.266.426 3.524.477.581.088.904.203 1.227.317 1.784 1.283 3.569 2.566 5.762 4.256 5.553 3.752 13.848 3.38 17.263-.35m-42.665-8.291c.31-.905.62-1.81.928-2.715l-2.529.003c.31.904.621 1.808 1.601 2.712z"/>
        <path fill="#FCFFFE" d="M141 566h-.75c-1.23-1.44-2.208-2.88-3.219-4.66a13.09 13.09 0 0 1 2.677-3.308c.654.726.982 1.493 1.304 3.016-.008 2.154-.01 3.553-.012 4.952z"/>
        <path fill="#F8FEFE" d="M214.71 584.179c3.073 1.91 3.41 3.904-.352 5.78-.857-.553-1.355-1.146-2.125-1.865.559-1.326 1.388-2.526 2.477-3.915z"/>
        <path fill="#FEFEFF" d="M119.041 557.36c2.19.767 4.422 1.894 6.806 3.33a37.01 37.01 0 0 1-6.806-3.33zM127.062 565.35c1.361-.658 2.784-.965 4.572-1.312-.39 3.027-1.82 4.15-4.572 1.312z"/>
        <path fill="#F8FEFE" d="M202.417 590c-.417-.444-.417-.887-.418-1.663 1.715-.337 3.43-.341 5.467-.084.059.757-.204 1.252-.466 1.747h-4.583z"/>
        <path fill="#FDFEFD" d="M207.354 589.995c-.092-.49.17-.985.54-1.74.55-.262.995-.264 1.772-.265-.43.668-1.194 1.334-2.312 2.005z"/>
        <path fill="#01D297" d="M542.946 524.456c-2.04.931-3.933 1.55-6.398 1.853-1.936-.347-3.483-.814-4.638-.336-7.442 3.085-15.078 4.147-23.12 3.486-2.258-.186-4.642 1.355-6.992 2.02-2.035.576-4.104 1.034-6.558 1.644 1.447-7.108 7.082-12.72 1.915-19.543 4.203-3.522 3.105-7.578 1.127-11.708-.423-.884-1.178-1.782-1.175-2.672.028-10.305.172-20.61.288-30.915.013-1.119.161-2.25.05-3.355-.917-9.107-1.153-18.06 5.088-25.429l-1.65-6.401 6.635.807-3.37-7.171c-1.008 1.629-1.518 2.453-2.219 2.905-2.121-9.188-3.484-18.18-6.147-26.768-2.52-8.128-6.324-15.881-12.717-21.943 0 0-.055.075-.097-.295-2.925-3.222-5.807-6.073-8.689-8.924 0 0-.251.202-.23-.21-3.283-2.833-6.586-5.255-9.889-7.677 0 0-.166.136-.136-.273-8.315-5.726-7.936-5.644-5.638-16.2.92-4.22-.244-8.893-.46-13.36.024-.435.048-.87.024-1.992-1.412-3.445-2.778-6.204-4.143-8.964.048-.345-.055-.637-.599-1.27-.938-1.176-1.586-1.957-2.234-2.738 0 0 .026-.027-.048-.4-1.673-3.224.276-2.784 2.017-2.693 5.985.314 11.971.575 18.338.906a42.927 42.927 0 0 0 3.72-1.102v-10.843c5.929-.34 11.858-.68 18.01-1.33 11.045-1.526 20.077-6.785 28.842-13.24.123-.315.15-.317.509-.35 6.39-4.78 12.423-9.53 19.529-15.123l-3.947 9.578.961.796c5.631-5.447 11.262-10.894 17.26-16.145.85 2.366 1.754 4.537 1.757 6.71.074 70.8.055 141.601.1 212.402.001 1.913.552 3.827.946 6.037.184.488.27.679.354.87-.067 1.346-.133 2.693-.475 4.669-1.451 3.842-2.629 7.055-3.806 10.269 0 0-.2.4-.165.622.035.22.002.119-.298.208-.487.377-.674.666-.861.954-3.542 4.107-7.083 8.214-10.77 12.634M479.59 306.548c1.87 3.201 1.96 3.202 5.17-.388-1.784 0-3.182 0-5.17.388z"/>
        <path fill="#02D298" d="M202.257 586.196c-.801.198-1.602.396-2.948.174-4.096-.683-7.708-1.494-11.184-1.102-8.604.97-16.958 1.239-24.725-3.485-.937-.57-2.213-.58-3.393-1.202-1-1.869-1.063-5.187-4.13-2.33-9.573-7.486-14.028-17.85-14.078-29.46-.282-65.125-.125-130.253-.084-195.38.002-2.086.378-4.171.662-7.111 8.243 4.948 16.103 8.822 24.683 10.626l.516-1.23-8.666-10.145c18.921 6.74 37.61 11.253 57.763 5.495 4.288-.066 8.183-.066 12.534-.066-1.812 2.26-3.463 4.32-5.138 6.719-.024.337-.006.352-.337.367-.76.449-1.187.883-1.666 1.597.277 1.009.605 1.737 1.006 2.81 2.002.456 3.943.467 5.858.691 5.653.664 7.116-.472 8.266-6.612.613-.243 1-.294 1.493.14.12 7.399.134 14.313.149 21.227.101.456.202.913-.137 1.783-5.347 3.726-2.967 8.057-1.553 11.773 1.242 3.264 2.418 7.565 7.67 6.54 0 0 .148-.023.114.397-1.252 1.214-2.478 2.698-3.687 2.684-5.084-.057-8.37 3.06-7.715 7.801-.05.036-.153.105-.445.172-.491.71-.69 1.352-.984 2.329-3.869 5.728-7.85 10.992-11.368 16.549-4.376 6.913-8.369 14.069-12.527 21.12 0 0-.208.394-.558.73-6.494 11.003-9.447 22.6-11.416 34.484l1.364.527 9.19-14.073 1.338 5.28s-.163.443-.505.865c-.619 1.44-.896 2.458-1.204 3.911-.006 4.24.02 8.045-.074 12.203.4 1.282.919 2.21 1.438 3.14.062.715.124 1.43.176 2.827-.01 2.015-.01 3.35-.01 5.144 1.884-.686 2.922-1.065 4.123-1.135 1.289.915 2.417 1.521 2.63 1.635-2.51 3.565-4.657 5.826-5.868 8.51-2.069 4.588-3.605 9.423-5.172 14.218-.118.36 1.302 1.222 1.935 2.166-.238.714-.405 1.112-.926 1.567-1.784 4.14-3.245 8.21-4.605 12.313-.185.56.11 1.292.225 1.936.564 3.157 1.316 6.292 1.672 9.471.492 4.393.79 8.814.98 13.232.158 3.702 1.97 3.103 4.19 1.857 1.426 3.431 2.71 6.932 4.321 10.274 1.492 3.093.731 4.64-3.273 4.652-2.15.079-3.678.468-5.206.858 0 0-.186.318-.387.383-.202.065-.327.154-.327.154m6.157-80.713s.109-.065 0 0z"/>
        <path fill="#03D298" d="M208.646 240.99c2.256-.143 4.106-.32 6.192-.82 1.29-.413 2.345-.505 3.839-.1 1.374.923 2.321 1.737 3.242 1.708 4.1-.127 8.19-.531 12.289-.766 5.22-.3 10.445-.532 15.667-.794 0 0 .197-.286.246-.453.448-.168.847-.169 1.739.242 1.2.513 1.906.613 2.613.713.322-.081.642-.075 1.45.183.672.148.855.133 1.037.118 4.764 1.6 9.545 3.152 14.283 4.824 1.69.597 3.278 1.484 5.28 2.262 8.25 6.225 17.648 8.894 27.242 9.791 7.789.729 15.765-.543 24.435-.9 1.856-.054 2.936-.136 5.638-.34l-9.104-5.962c4.03-.313 8.087.706 12.097.548 2.806-.11 7.13 2.005 8.169-3.195 1.094-.399 2.187-.797 3.694-.79 2.506.042 4.967-1.208 6.625-.52 5.392 2.234 8.388-3.025 13.002-3.556 5.372-.617 10.5-3.363 15.957-4.906 5.032 1.006 8.26-1.332 10.73-5.14 2.563-1.49 5.127-2.98 7.883-4.748 3.489-1.675 6.784-3.07 10.86-4.457 3.17-.037 6.064.76 6.136-3.182.82-.573 1.642-1.146 2.843-1.348 2.678-.85 4.975-2.071 7.272-3.293.777-.403 1.554-.807 2.712-.85 1.143.519 2.084 1.046 2.638.777 5.28-2.565 10.565-5.143 15.682-8.012 1.29-.722 1.987-2.5 2.956-3.793.14-.11.28-.22.687-.34 2.807-.01 5.347-.01 8.933-.01.235.591.86 2.165 1.412 4.345-.306.852-.593.982-.99.662-.794-.57-1.84-1.242-2.216-.974-3.071 2.188-6.117 4.437-8.955 6.914-1.197 1.045-2.458 2.62-2.615 4.07-.134 1.234 1.767 3.851 1.931 3.785 5.55-2.241 11.018-4.69 16.424-7.265.405-.193.257-1.546.443-2.592.076-.232.265-.68.553-.645.657-.062 1.026-.159 1.683-.235.728-.32 1.17-.66 1.956-1.01.791-.118 1.237-.225 1.99-.287.924-.437 1.541-.92 2.159-1.402 0 0 .332.012.723-.002.565-.059.74-.104 1.244-.106 1.087-.361 1.846-.765 2.614-1.157.01.012.02-.02.388.019 1.606-.554 2.844-1.146 4.082-1.737.952-.02 1.903-.04 3.488-.122.944-.28 1.255-.497 1.567-.714 0 0 .311.02.438-.07 10.098-1.149 20.069-2.208 30.577-2.865.655 1.482.772 2.564.89 3.645-.276.994-.55 1.987-.804 3.367.022.386-.017.597-.21.813-.192.216-.403.631-.65.804-.468.721-.687 1.269-1.105 2.031-.29.78-.379 1.346-.468 1.911a31.288 31.288 0 0 1-1.524 2.565c-.765 1.43-1.166 2.431-1.567 3.432 0 0-.048-.065-.302.006-.36.386-.466.702-.572 1.017-1.041 1.704-2.082 3.409-3.505 5.563-3.561 4.34-6.742 8.23-9.922 12.12 0 0 .23.234-.189.17-1.19.593-1.96 1.249-2.732 1.905 0 0 .157.056-.254.1-7.263 4.3-14.116 8.556-21.16 12.933.68.314 1.633.755 2.82 1.439 2.018.093 3.801-.056 5.91-.234l-2.17 3.796c-8.018 2.408-16.037 4.816-24.819 7.176-1.56.32-2.358.69-3.155 1.059-.724.105-1.448.21-2.742-.04-3.783.339-6.995 1.035-10.208 1.73-1.424.053-2.848.105-4.984-.163-6.101-1.287-11.49-2.253-17.067-3.253-.413 2.024-.673 3.3-1.189 4.767.654 1.662 1.563 3.135 2.683 4.951-.349.485-.974 1.355-1.9 2.17-.703-.024-1.108.008-1.69-.261-7.132-1.759-1.487 2.99-2.885 5.017-2.114-1.314-4.255-2.645-6.653-4.16-1.644-.723-3.03-1.26-4.417-1.798 0 0 .003-.073-.214-.34-8.493-3.399-16.612-7.162-25.803-6.591a54.093 54.093 0 0 1-1.953-.366c-4.46-.026-8.248.098-12.036.22-2.021.018-4.042.034-6.908.045-2.153.176-3.495.23-4.763.562-12.439 3.26-24.865 6.568-37.518 9.89-.303.16-.48.325-.447.414.093.254.271.476.417.666.001-.045-.087-.066-.087-.066-.67.066-1.34.133-2.714.3-9.05 2.5-16.55 6.118-20.981 14.163 0 0 .041.032-.304.07-1.804 1.683-3.264 3.33-4.938 5.092-.477.339-.624.622-.678.925-.025-.04.058.003-.19.106-.404.415-.56.727-.69 1.045.024.006.042.055.042.055-.653-.016-1.467-.291-1.93-.003-1.723 1.074-2.8 4.987-5.48 1.166-1.153-1.643-1.992-3.503-3.014-5.24-.71-1.207-1.631-3.436-2.213-3.36-1.877.249-3.64 1.353-5.838 2.544-.837.444-1.283.473-1.8.16-1.335-.518-3.448-1.233-3.73-.787-2.72 4.291-6.741 3.103-10.968 2.706l.96 2.853c-8.072 1.548-16.144 3.096-24.465 4.947-.249.303-.73.225-.73.225s-.486.027-.724.083c-4.969-.112-9.729-.02-14.422-.532-3.944-.43-7.812-1.567-11.79-2.794.368-.365.813-.327 2.037-.252 8.142-1.118 15.505-2.273 22.867-3.428l-.1-1.629-14.936-3.727c-.413-.067-.825-.133-1.753-.487-4.417-2.069-8.32-3.85-12.222-5.631 0 0 .005-.046-.015-.033-2.693-2.053-5.365-4.12-8.363-6.31a660.481 660.481 0 0 1-13.402-17.922c-1.624-2.246-1.385-4.023 1.723-4.605 12.742-2.385 25.485-4.768 39.114-7.13 9.034.02 17.181.02 25.329.02l.123-1.647c-2.476-.5-4.953-.999-7.579-1.702-.467-.254-.783-.305-1.532-.444-3.4-.153-6.366-.217-9.333-.28-1.056-.052-2.112-.105-3.835-.468-7.995-.572-15.322-.834-22.65-1.096-2.42.02-4.842.039-8.12-.137-3.464-.031-6.072.282-8.672.219-.921-.023-1.82-.964-2.729-1.486 5.321-1.065 10.642-2.13 16.706-3.118 1.62-.385 2.497-.847 3.374-1.308.753-.131 1.507-.262 2.89-.112 2.428-.258 4.227-.797 6.027-1.335a79.483 79.483 0 0 1 3.64-.191z"/>
        <path fill="#04D198" d="M407.928 359.669c-.505.348-1.01.696-2.09.949a6.739 6.739 0 0 1 .474-3.92c.63-1.405 1.566-2.672 2.479-4.18-4.578 2.672-8.535 5.005-12.517 7.294-1.4.804-2.86 1.5-4.293 2.245-11.393 2.93-22.79 5.74-34.714 5.267-6.013-.239-6.595-.89-3.497-6.066 9.397-15.702 21.203-29.392 35.744-40.5 8.413-6.427 22.911-6.42 28.592-1.973 7.821 6.121 11.3 16.397 5.687 26.05-2.114 3.636-5.408 6.586-8.795 10.02-1.741 1.183-2.852 2.197-3.962 3.21 0 0-.02-.07-.31-.073-1.127.557-1.962 1.117-2.798 1.677zM303.859 377.581c-.723.071-1.445.142-2.948.192-3.339-.104-5.898-.188-8.642-.466-.523-.31-.86-.427-1.358-.804-1.268-1.232-2.377-2.204-3.486-3.177l-1.072 1.292c1.51 1.163 3.022 2.327 4.662 3.62.129.128.437.322.6.676-.35.956-.805 2.019-1.383 2.091-8.473 1.059-19.098-6.062-20.437-14.505-.691-4.353.588-9.018.977-13.542.054-.166.108-.332.453-.955a242.258 242.258 0 0 0 2.905-5.894s-.102-.12.254-.152c1.459-1.326 2.563-2.619 3.666-3.912 0 0-.051-.043.322-.059 6.708-4.713 13.625-8.135 21.686-7.015 4.428.616 8.671 2.57 12.998 3.92 0 0 .014.083.23.334 7.308 5.574 14.4 10.898 21.492 16.221.037.277.172.491.67 1.046 1.287 1.255 2.308 2.108 3.33 2.961 0 0 .042.312.19.756 1.442 2.89 2.734 5.337 4.027 7.782 0 0 .005.009-.336.045-1.795 1.018-3.25 2-4.704 2.982-.425.003-.85.007-1.961.072-5.747 1.413-10.806 2.766-16.227 4.053-1.559.458-2.756.982-3.954 1.507 0 0-.031.216-.354.131-2.375-.023-4.427.04-6.725-.125-1.788.157-3.332.54-4.875.925z"/>
        <path fill="#06CE95" d="m502.12 430.013 2.028-3.277 3.37 7.171-6.635-.807 1.65 6.401c-6.24 7.368-6.005 16.322-5.088 25.43.111 1.105-.037 2.235-.05 3.354-.116 10.305-.26 20.61-.288 30.915-.003.89.752 1.788 1.175 2.672 1.978 4.13 3.076 8.186-1.127 11.708 5.167 6.822-.468 12.435-1.915 19.543 2.454-.61 4.523-1.068 6.558-1.644 2.35-.665 4.734-2.206 6.992-2.02 8.042.661 15.678-.401 23.12-3.486 1.155-.478 2.702-.011 4.264.383-4.704 2.063-9.491 4.32-14.53 5.333-8.089 1.625-16.354 2.36-24.523 3.613-2.62.402-5.172 1.255-8.018 1.968 1.813-7.159 3.578-13.553 5.01-20.02.734-3.32 1.484-6.827 1.173-10.15-1.285-13.736-2.92-27.44-4.617-41.132-.134-1.079-1.56-2.492-2.683-2.876-9.07-3.096-18.212-5.982-27.738-9.459-2.44-1.154-4.475-1.782-6.51-2.41 0 0 .106-.064.084-.212-.292-.045-.561.058-.831.16-.174.033-.349.066-.889-.251-.688-.462-1.01-.573-1.293-.697.039-.012-.05.028-.04-.17-.25-.128-.511-.057-1.1.056-1.108-.332-1.885-.707-2.739-1.452-2.642-1.86-5.207-3.372-7.932-.67-1.152.03-2.305.06-3.916-.328-.675-.562-.913-.625-1.173-.604-2.678-.007-5.356-.014-8.574-.502-4.273-1.083-8.006-1.685-11.739-2.287l.087-1.534c6.653 0 13.307 0 20.137-.13.178-.129.615-.16.615-.16s.411.15.635.495c2.462.244 4.7.145 7.282-.015 1.464-1.015 2.583-1.969 4.066-2.917 1.769.334 3.173.662 4.662 1.344 1.03 1.18 1.975 2.004 3 3.178 2.871 2.405 5.746 3.635 9.18 1.025.416-1.003.64-1.776 1.226-2.637 2.016-2.565 2.697-4.94-.411-7.293-.02-1.119.021-1.866.426-2.708 2.766-1.403-.175-6.563 4.909-6.046.218.051.652.166.652.166-.026 1.056-.052 2.113-.113 4.017.107 4.825-.036 8.842.53 12.757.232 1.61 1.68 3.793 3.107 4.35 5.361 2.091 10.906 3.754 16.473 5.237 1.029.274 3.189-.707 3.624-1.66 4.551-9.942 1.53-18.995-3.687-27.707 0 0 .012-.024.015-.428.138-1.519.272-2.634.547-4.916 3.682 4.606 6.489 8.19 9.43 11.66.242.287 1.4-.202 2.132-.331z"/>
        <path fill="#0BCD99" d="M205.665 529.183c-.705-.628-2.125-1.49-2.007-1.85 1.567-4.795 3.103-9.63 5.172-14.219 1.21-2.683 3.358-4.944 5.867-8.509a9.637 9.637 0 0 1-2.44-1.906c3.31-2.57 6.595-4.56 9.88-6.55 0 0-.14-.061.298-.034 5.472-1.572 8.147-4.574 6.489-10.151.06-.43.12-.86.315-1.956.32-1.47.568-2.264.676-3.077 1.493-11.31 2.967-22.623 4.81-33.932 1.343.001 2.323-.001 3.325.409-3.031 11.504-3.049 38.1.135 41.485l8.888-5.781s.006-.087.382-.043c4.149-2.604 1.361-5.454.629-8.24-.01-5.604-.022-11.208.192-17.35.224-.539.712-.533.985-.302a44.953 44.953 0 0 1 2.986 4.172 656.546 656.546 0 0 0 1.667 4.72c.023 1.036.046 2.072.058 3.9 1.35 3.48-.862 7.956 4.033 9.286.445 1.57.888 2.734 1.21 4.232-1.38 1.078-2.626 1.843-3.897 2.563-5.826 3.3-11.66 6.587-17.49 9.878 0 0-.425.024-.927.114-1.07.667-1.637 1.244-2.205 1.821 0 0-.37.004-.825.114-1.342.861-2.23 1.613-3.33 2.402-.211.038-.527.328-.875.291-.847.392-1.346.82-2.058 1.282-.212.034-.557.29-.874.273-.941.515-1.564 1.047-2.441 1.609-.618.366-.983.702-1.69 1.077-2.163 1.313-3.985 2.587-6.138 3.923-1.697 1.1-3.063 2.137-4.448 3.168-.02-.007-.014.033-.27.089-.364.346-.474.638-.711 1.227-.158.725-.188 1.152-.532 1.75-1 2.436-1.686 4.702-2.47 7.274-.109.73-.121 1.156-.412 1.762-.838 1.814-1.398 3.446-1.957 5.08z"/>
        <path fill="#12CC9B" d="M259.336 483.153c-.443-1.164-.886-2.329-1.14-4.074.435-1.022.681-1.464.928-1.906.407-.04.814-.079 1.878-.19 5.228-2.3 9.8-4.53 14.373-6.759.356-.051.712-.102 1.683-.268 4.887-1.955 9.16-3.797 13.433-5.639 0 0 .293-.008.796-.077 3.925-1.444 7.348-2.82 10.77-4.197.417-.036.835-.072 1.908-.126 1.56-.592 2.466-1.166 3.371-1.74 0 0 .337.008.825.005 1.287-.392 2.085-.782 2.884-1.172.43-.014.86-.029 1.967-.06 2.803-.972 4.928-1.925 7.052-2.879.72-.031 1.44-.063 2.883-.137 3.185-.97 5.645-1.896 8.105-2.823.432.002.865.004 1.954.003 1.45-.36 2.243-.718 3.037-1.076 0 0-.042-.038.386.003 4.48-.98 8.534-2.001 12.587-3.023 0 0-.016-.018.425.02 9.464-1.276 18.487-2.589 27.306-3.651-1.75 1.212-3.298 2.176-4.68 3.035 1.013.709 1.976 1.383 2.553 2.23-5.165 1.161-9.945 2.15-15.044 3.057-.738.023-1.158.127-1.99.134-12.973 2.754-25.629 5.248-38.059 8.584-7.74 2.078-15.138 5.43-22.69 8.21-.424.045-.849.091-1.923.267-8.596 3.49-16.518 6.905-24.496 10.183-3.637 1.494-7.384 2.72-11.082 4.066z"/>
        <path fill="#16CE9D" d="M312.883 295.968c2.163-1.91 4.326-3.82 7.134-5.93 5.88-3.09 11.114-5.98 16.35-8.87.367-.005.735-.01 1.742-.11 4.96-1.042 9.291-2.827 13.595-2.76 9.083.138 18.15 1.246 27.224 1.956l12.475 3.582-.265 1.846c-1.307 0-2.636.155-3.92-.022-23.153-3.198-45.544-.9-66.924 9.055-2.016.94-4.244 1.424-6.746 1.873-.372-.247-.665-.62-.665-.62z"/>
        <path fill="#C4FCF6" d="M376.95 443.137c-9.022 1.312-18.045 2.625-27.501 3.91 2.471-1.023 5.369-2.043 8.283-3.01 13.681-4.544 28.209-2.266 42.149-5.236 6.027-1.285 12.554-.655 18.818-.287 8.128.477 16.22 1.56 23.525 2.3.743-1.938 1.783-3.484 1.842-5.066.101-2.69.53-6.127-.869-7.957-2.909-3.804-2.927-6.91-.517-10.725.886-1.4 1.078-3.298 1.367-5.005.527-3.107 1.733-5.011 4.838-3.147-.547 4.346-.655 8.243-.82 12.576-.707 6.46-1.359 12.484-2.01 18.509-1.12.954-2.239 1.908-4.077 2.846-2.856-.095-4.994-.173-7.132-.252l-.411-.15s-.437.03-.844-.194c-2.32-.532-4.247-1.165-6.148-1.097-15.151.541-30.298 1.216-45.864 1.797a102.84 102.84 0 0 0-4.629.188z"/>
        <path fill="#0DCE98" d="M233.58 408.861c-.706-4.705 2.58-7.822 7.665-7.765 1.209.014 2.435-1.47 3.696-2.61 6.163 3.956 13.006 4.98 20.156 3.57 2.972-.586 5.756-2.13 9.153-3.591 1.689-1.333 2.851-2.312 4.013-3.29 0 0 .3.055.58.195.526.35.795.521 1.088.654 0 0 .046.006-.04.348-.79 1.665-1.495 2.987-2.2 4.31 0 0 .13.08-.211.236-1.43 1.42-2.52 2.683-3.61 3.946 0 0 .122.038-.301.047-2.594 1.076-4.751 2.17-6.938 3.204-6.196 2.928-12.46 1.485-18.716.244-.74-.093-1.48-.185-2.797-.591-4.66-3.193-8.422-3.568-11.538 1.093z"/>
        <path fill="#D3FDFA" d="M378.894 279.86c-9.04-.316-18.107-1.424-27.19-1.563-4.304-.066-8.636 1.719-13.342 2.643-.48-1.167-.475-3.287-.677-3.307-1.894-.186-3.996-.478-5.708.153-3.637 1.342-7.012 3.387-10.635 4.78-1.18.452-2.796-.228-4.45-.726-.238-.335-.15-.314-.07-.555.111-.434.141-.628.172-.822 12.43-3.294 24.856-6.601 37.295-9.862 1.268-.333 2.61-.386 4.336-.489-2.377 5.966-1.842 6.788 4.9 6.882 3.603.051 7.232-.166 10.802.201 1.572.162 3.026 1.478 4.567 2.664z"/>
        <path fill="#0CCE97" d="m410.64 279.054 6.396 3.975c1.398-2.028-4.247-6.776 2.761-4.722 2.41 4.363 4.762 8.13 7.114 11.897 0 0 .019.397.072.936 1.311 3.37 2.569 6.2 3.826 9.031 0 0-.018-.146-.041.337.263 2.258.898 4.072.701 5.79-.11.972-1.589 1.788-2.45 2.673-.015-.333-.148-.61-.635-1.309-2.25-3.29-4.263-6.102-6.275-8.914a21.591 21.591 0 0 0-.753-1.998c-1.233-1.622-2.21-2.755-3.187-3.889 0 0-.158.022-.08-.342-.577-1.151-1.232-1.94-1.887-2.727 0 0-.151.212-.065-.235-1.32-2.484-2.725-4.52-4.131-6.557 0 0-.006 0-.008-.356-.454-1.434-.906-2.512-1.358-3.59z"/>
        <path fill="#D1FDF8" d="M501.93 429.64c-.542.502-1.7.99-1.942.704-2.941-3.47-5.748-7.054-9.43-11.66-.275 2.282-.41 3.397-.56 4.913-.955-.065-2.662-.466-2.708-1.006-.26-3.102-.127-6.237-.127-9.361l1.345-.406 8.033 8.262c1.408-7.926-.756-14.522-3.867-20.861-3.07-6.256-6.43-12.369-9.635-18.92 6.419 5.687 10.223 13.44 12.743 21.568 2.663 8.588 4.026 17.58 6.147 26.768m-4.516-6.946.653.88.56-.537c-.283-.23-.566-.461-1.213-.343z"/>
        <path fill="#CAFCF8" d="M208.384 475.797c-.598-1.113-.935-2.445-1.598-5.062l-9.19 14.073-1.364-.527c1.969-11.884 4.922-23.48 11.398-34.262-1.37 5.14-3.076 10.394-4.773 15.65-.7 2.17-1.381 4.345-2.49 7.842 7.54-4.802 7.693-14.3 17.22-16.741-3.316 6.975-6.13 12.892-9.203 19.027z"/>
        <path fill="#09CC94" d="M474.59 304.829c.41 3.343.41 6.62.41 10.909-.437.15-1.887.65-3.709.752-2.827-1.9-5.283-3.4-7.739-4.9 0 0-.106-.034-.234-.364-.857-.63-1.584-.93-2.312-1.23 0 0-.006.004-.094-.32-1.92-1.931-3.752-3.537-5.583-5.142 0 0-.027-.31-.134-.727-.409-.637-.711-.857-1.014-1.076-.442-1.669-.884-3.338-.975-5.235.352-.229.729-.399.729-.399l.013-.006c6.734 2.562 13.483 5.117 20.642 7.738z"/>
        <path fill="#CAFCF8" d="M246.687 483.056c-2.588 1.99-5.562 3.925-8.502 5.837-3.184-3.385-3.166-29.981.003-41.837a2555.412 2555.412 0 0 1 4.716-20.597l-.99-.418-2.773 3.013c-1.002-3.166 1.428-8.154 4.045-7.746 3.138.49 2.707 2.759 2.022 5.333-5.088 19.124-9.47 38.357-6.646 58.585 2.445-.703 5.092-1.464 8.125-2.17z"/>
        <path fill="#0BC897" d="M469.192 426.816c-4.866-.465-1.925 4.695-4.755 5.634-1.406-8.421-2.385-16.472-3.363-24.523-.03-1.045-.06-2.09-.103-3.91-1.132-5.068-2.252-9.36-3.372-13.65l1.853-.588c1.52 2.736 3.038 5.473 4.557 8.209 0 0 .016.486.024 1.102 1.003 3.392 1.997 6.17 2.992 8.946.013.73.026 1.46.043 2.965.71 5.788 1.417 10.801 2.124 15.815z"/>
        <path fill="#D1FDF8" d="M460.792 408.176c1.26 7.802 2.239 15.853 3.281 24.368.023 1.212-.017 1.96-.062 3.513.034 2.853.073 4.9.112 6.947-.223.772-.447 1.545-1.257 2.499-3.347-.32-6.106-.823-8.865-1.326-.946-.824-1.891-1.649-2.832-3.254-.045-7.492-.095-14.203-.097-21.334-.3-3.148-.647-5.877-.994-8.605.959 2.015 2.53 3.963 2.76 6.06.67 6.063 1.267 12.207 1.007 18.28-.245 5.717 2.58 7.6 7.606 8.285 2.101-11.9.484-23.54-.66-35.433z"/>
        <path fill="#CAFCF8" d="M233.53 408.897c3.166-4.697 6.928-4.322 11.215-1.154-7.175-1.107-10.408 3.955-13.603 9.117-1.882 3.041-3.723 6.117-5.776 9.04-2.914 4.15-6.12 8.097-8.983 12.279-1.756 2.562-3.013 5.462-4.683 8.09-.674 1.06-1.854 1.797-3.15 2.74 3.814-6.993 7.807-14.149 12.183-21.062 3.518-5.557 7.5-10.821 11.64-16.713.58-1.076.792-1.654 1.004-2.232 0 0 .103-.069.153-.105z"/>
        <path fill="#D1FDF8" d="M489.97 424.444c5.242 8.296 8.264 17.349 3.713 27.292-.435.952-2.595 1.933-3.624 1.659-5.567-1.483-11.112-3.146-16.473-5.237-1.427-.557-2.875-2.74-3.107-4.35-.566-3.915-.423-7.932-.462-12.366.732 2.912 1.475 6.264 1.96 9.653.498 3.473 1.7 5.673 5.768 6.084 3.326.337 6.478 2.14 9.807 2.768 4.524.855 6.874-1.821 6.345-5.97-.694-5.451-2.285-10.788-3.47-16.179-.212-.968-.325-1.958-.457-3.354z"/>
        <path fill="#0CCE97" d="m421.912 278.329 1.599-2.226c-1.12-1.816-2.029-3.289-2.322-4.945 1.341-.192 2.067-.2 2.828-.202.035.006.042.078.083.43.824.7 1.606 1.049 2.66 1.385.61.109.948.23 1.44.576.664.374 1.173.523 1.73.654.047-.02.087.073.269.317.765.371 1.348.498 2.255.77 2.746.848 5.167 1.55 7.696 2.412.299.35.528.457 1.178.548 1.152.04 1.92.017 2.69-.006.702.096 1.404.192 2.44.447.335.16.37.56.087.717-.708 1.34-1.134 2.522-1.56 3.705-1.074.024-2.148.048-3.855-.235-2.438-.49-4.243-.675-6.336-.772-.46.188-.633.29-.806.39-1.676-.194-3.351-.389-5.475-.726-.447-.142-.603-.49-.45-.54.052-.018-.05.015-.487-.036a198.594 198.594 0 0 1-5.664-2.663z"/>
        <path fill="#CCFDF9" d="M270.427 353.034c-.044 4.448-1.323 9.113-.632 13.466 1.34 8.443 11.964 15.564 20.437 14.505.578-.072 1.033-1.135 1.64-2.35.258-.793.42-.973.582-1.153 2.559.083 5.118.167 8.103.348-3.902 4.428-9.454 6.357-15.073 4.881-11.436-3.001-19.191-8.592-18.36-22.22.155-2.518 1.931-4.937 3.303-7.477z"/>
        <path fill="#0DCE98" d="M239.117 377.718c-.294-6.713-.308-13.627-.363-21.233.087-.963.161-1.248.182-1.547 0 0 .052.064.359.06 1.077-.698 1.847-1.392 2.617-2.086 0 0 .063.086.303.012.452-.341.665-.61.878-.878l3.519-1.503c-2.408 9-4.811 17.987-7.495 27.175z"/>
        <path fill="#CCFDF9" d="M313.002 338.539c-4.273-.998-8.516-2.952-12.944-3.568-8.06-1.12-14.978 2.302-21.664 7.041.06-5.25 5.121-6.506 8.344-7.689 5.97-2.19 12.722-2.969 19.07-.7 2.592.927 4.772 3.008 7.194 4.916z"/>
        <path fill="#CAFCF8" d="M234.361 446.996c-1.479 11.312-2.953 22.625-4.446 33.935-.108.813-.356 1.606-.733 2.755-.48-1.54-1.12-3.453-.987-5.31a385.65 385.65 0 0 1 1.845-19.218c.654-5.367 1.479-10.726 2.553-16.023.287-1.414 1.768-2.586 3.085-3.643-.183 2.652-.75 5.078-1.317 7.504z"/>
        <path fill="#D1FDF8" d="M457.644 334.296c.498 4.162 1.661 8.835.742 13.055-2.298 10.556-2.677 10.474 5.728 16.142-8.426-1.371-12.436-4.914-9.705-10.333 3.15-6.25 1.71-12.458 3.235-18.864zM464.037 397.571c-1.547-2.32-3.066-5.056-4.585-7.792l-1.853.587c1.12 4.292 2.24 8.583 3.296 13.265-5.009-4.132-4.405-10.6-5.73-16.351-.179-.771 1.479-2.449 2.599-2.864.731-.271 2.655.75 2.961 1.587 1.33 3.638 2.263 7.421 3.312 11.568z"/>
        <path fill="#B3FBF5" d="M463.352 312.007c2.656 1.083 5.112 2.583 7.558 4.434-5.996.068-11.982-.193-17.967-.507-1.74-.091-3.69-.53-2.032 2.705-.582-.701-1.224-1.787-1.866-2.874 1-.59 1.94-1.512 3.013-1.71 3.673-.68 7.392-1.107 11.294-2.048z"/>
        <path fill="#C4FCF6" d="M254.207 465.802c-.815-1.197-1.336-2.661-1.897-4.919-.038-5.836-.038-10.878-.038-15.92l-1.343-.04-1.941 12.023s-.488-.006-.72.07c-.24-3.237-.214-6.551-.266-9.865-.057-3.69 2.03-4.824 6.499-4.827 0 7.865 0 15.538-.294 23.478z"/>
        <path fill="#22C9A4" d="M234.725 447c.203-2.43.77-4.856 1.28-7.664.028-.788.112-1.195.515-2.076.961-2.43 1.604-4.387 2.248-6.343.12-.408.242-.816.368-1.543.93-1.325 1.854-2.329 2.778-3.333l.99.418c-1.534 6.612-3.067 13.223-4.74 20.185-1.116.354-2.096.356-3.439.355z"/>
        <path fill="#0DCE98" d="M244.703 397.713c-5.137 1.327-6.313-2.974-7.555-6.238-1.414-3.716-3.794-8.047 1.452-11.413.574 1.218 1.117 2.522.988 3.756-.562 5.392 1.495 9.74 5.115 13.895z"/>
        <path fill="#9AF9F1" d="M238.537 354.927c.378.31.304.595.112 1.073-.452.258-.84.31-1.792.713-4.996 2.04-9.427 3.728-13.858 5.415-.328-.728-.656-1.456-.636-2.555a38.115 38.115 0 0 1 1.7-1.522s-.018-.015-.01.002c2.33-1.422 4.65-2.861 7.307-4.377 1.587 4.75 4.693.504 7.177 1.251z"/>
        <path fill="#CCFDF9" d="M334.84 355.058c-7.154-4.935-14.246-10.259-21.523-15.861 9.003 2.303 16.327 7.46 21.523 15.86z"/>
        <path fill="#CCF1EB" d="M312.493 295.968c.39 0 .683.373.716.608-4.905 4.118-9.843 8.002-14.781 11.885l-1.554-2.01c5.739-2.662 7.697-10.074 15.619-10.483z"/>
        <path fill="#CFFCF8" d="M293.31 295.965c4.08-8.042 11.58-11.66 20.316-14.031-2.485 1.743-5.47 3.3-8.207 5.212-4.013 2.805-7.848 5.864-12.11 8.819z"/>
        <path fill="#D3FDFA" d="M380.06 270.51c9.08-.94 17.2 2.822 25.666 6.246-3.565-.583-7.326-1.44-11.077-2.34-4.83-1.16-9.653-2.355-14.59-3.906z"/>
        <path fill="#CAFCF8" d="M248.018 408.711c6.154.89 12.417 2.332 18.613-.596 2.187-1.033 4.344-2.128 6.876-3.231-1.174 1.659-2.47 4.463-4.286 4.853-6.997 1.504-14.193 3.03-21.203-1.026z"/>
        <path fill="#4FEAD1" d="M392.385 362.114c1.029-.802 2.49-1.498 3.889-2.302 3.982-2.289 7.939-4.622 12.517-7.294-.913 1.508-1.85 2.775-2.479 4.18-.533 1.192-.712 2.543-.782 3.965-.415.535-1.522 1.417-1.71 1.251-3.8-3.337-7.375.218-11.435.2z"/>
        <path fill="#D3FDFA" d="M427.91 281.079s.156.347.182.536c-.962.935-1.95 1.68-2.895 2.395.63 1.884 1.218 3.638 1.76 5.793-2.398-3.366-4.75-7.133-6.98-11.195.526-.327.93-.36 1.635-.335 2.076.915 3.852 1.774 6.002 2.678.374.044.296.128.296.128z"/>
        <path fill="#CCFDF9" d="M320.128 375.209c5.06-1.353 10.12-2.706 15.563-4.015-.204.997-.625 2.592-1.41 2.797-5.215 1.364-10.507 2.43-15.87 3.088.508-.96 1.112-1.415 1.717-1.87z"/>
        <path fill="#D3FDFA" d="M335.931 281.112c-4.8 2.946-10.034 5.836-15.624 8.722-.108-.946-.128-2.491.426-2.736 4.863-2.145 9.828-4.059 15.198-5.986z"/>
        <path fill="#CAFCF8" d="M221.736 496.09c-2.884 2.049-6.168 4.039-9.641 6.3-1.228.65-2.266 1.029-4.15 1.715 0-1.795 0-3.129.09-4.794 2.524-.626 4.995-.752 7.382-1.268 2.024-.437 3.95-1.323 6.32-1.953zM206.46 492.64c-.025-3.804-.051-7.609.214-11.908.636-.58.98-.665 1.326-.75.185 4.155.37 8.311 0 12.707-.882.144-1.21.048-1.54-.049z"/>
        <path fill="#D1FDF8" d="M469.41 426.868c-.925-5.066-1.632-10.08-2.265-15.51 4.878 3.941 3.872 9.577 3.197 15.377-.28.299-.714.184-.932.133z"/>
        <path fill="#CFFCF8" d="M266.712 341.64c1.967-5.496 4.335-10.871 6.994-16.436-2.004 5.393-4.299 10.975-6.994 16.436z"/>
        <path fill="#44C0A8" d="M449.939 410.738c.486 2.974.834 5.703.834 8.94-1.115.797-1.884 1.087-2.652 1.376.109-3.897.217-7.794.637-11.886.555.312.798.818 1.18 1.57z"/>
        <path fill="#CFFCF8" d="M287.932 301.014c1.46-1.646 2.919-3.293 4.707-4.997.348 4.65-2.052 7.799-6.448 9.86-.265-.678-.167-1.322-.03-2.29.04-.326.022-.375.26-.465.383-.414.53-.739.676-1.064 0 0-.083-.043.172-.107.39-.355.526-.646.663-.937z"/>
        <path fill="#D3FDFA" d="M429.058 309.342c.822-1.256 2.3-2.072 2.411-3.043.197-1.719-.438-3.533-.71-5.717 2.896 1.398 4.62 6.841 2.615 8.973-.696.74-2.81.144-4.316-.213z"/>
        <path fill="#C4FCF6" d="M274.958 470.153c-4.156 2.3-8.728 4.53-13.667 6.726 2.889-4.871 8.168-5.635 13.667-6.726z"/>
        <path fill="#D1FDF8" d="M464.137 364.174c3.326 2.072 6.63 4.494 10.036 7.23a103.542 103.542 0 0 1-10.036-7.23z"/>
        <path fill="#C4FCF6" d="M258.966 476.849c-.089.766-.335 1.208-.772 1.825-5.084-.75-2.872-5.224-4.15-8.323 1.642 1.785 3.202 3.98 4.922 6.498zM290.07 464.222c-3.852 1.937-8.125 3.779-12.77 5.61a155.692 155.692 0 0 1 12.77-5.61z"/>
        <path fill="#CAFCF8" d="M228.614 486.143c1.968 5.398-.707 8.4-6.11 10.01 1.688-3.27 3.744-6.55 6.11-10.01z"/>
        <path fill="#D1FDF8" d="M474.215 372.074c2.946 2.488 5.828 5.34 8.785 8.526a101.15 101.15 0 0 1-8.785-8.526z"/>
        <path fill="#C4FCF6" d="M348.557 446.975c-3.594 1.065-7.647 2.086-12.114 3.09.808-1.02 1.917-2.652 3.273-2.892 2.723-.482 5.58-.204 8.841-.198z"/>
        <path fill="#D3FDFA" d="M366.253 270.286c3.495-.414 7.282-.538 11.42-.468-3.474.382-7.3.571-11.42.468z"/>
        <path fill="#C5FAF4" d="M270.721 310.65c1.219-1.204 2.749-2.133 4.278-3.061l.925.901c-1.397 2.792-2.794 5.583-4.482 8.579-.33-1.912-.37-4.028-.72-6.42z"/>
        <path fill="#D3FDFA" d="M410.383 278.869c.709 1.263 1.16 2.34 1.616 3.772-4.23 1.19-4.335-2.694-5.992-5.21 1.346.178 2.732.715 4.376 1.438z"/>
        <path fill="#CFFCF8" d="M274.38 324.957c1.378-3.266 3.128-6.568 5.188-10.04-1.132 3.356.03 8.193-5.188 10.04z"/>
        <path fill="#D1FDF8" d="M453.568 323.275c1.604 2.52 2.97 5.279 4.279 8.412a54.84 54.84 0 0 1-4.28-8.412z"/>
        <path fill="#C4FCF6" d="M301.824 459.782c-3.19 1.637-6.612 3.014-10.428 4.36 3.136-1.56 6.666-3.091 10.428-4.36z"/>
        <path fill="#D3FDFA" d="M422.069 299.141c2.052 2.419 4.065 5.23 6.113 8.4-4.89-.312-4.578-4.858-6.113-8.4z"/>
        <path fill="#C5FAF4" d="M244.228 322.297c2.793-1.332 5.826-2.406 9.253-3.455-2.741 1.254-5.877 2.484-9.253 3.455z"/>
        <path fill="#CFFCF8" d="M280.76 313.09c1.229-2.37 2.815-4.76 4.74-7.199.194 3.292-.205 6.468-4.74 7.198z"/>
        <path fill="#D1FDF8" d="M467.29 407.788c-1.26-2.529-2.254-5.306-3.186-8.466a51.607 51.607 0 0 1 3.185 8.466z"/>
        <path fill="#CCFDF9" d="M343.34 367.956c-1.638-2.41-2.93-4.856-4.248-7.65 3.376 1.227 6.638 2.882 4.249 7.65z"/>
        <path fill="#C4FCF6" d="M330.833 450.835c-2.241 1.203-4.701 2.13-7.537 3.007a41.972 41.972 0 0 1 7.537-3.007z"/>
        <path fill="#D3FDFA" d="M430.88 299.759c-1.328-2.419-2.586-5.25-3.786-8.454 4.314 1.081 3.025 5.04 3.786 8.454z"/>
        <path fill="#CAFCF8" d="M238.396 430.939c-.272 1.934-.915 3.891-1.866 6.008-2.344-2.661-2.37-4.894 1.866-6.008z"/>
        <path fill="#CFFCF8" d="M267.498 326.027c-.389 2.474-1.119 5.029-2.118 7.815a43.054 43.054 0 0 1 2.118-7.815zM270.591 318.02c-.391 1.865-1.135 3.786-2.17 5.885-2.718-2.922-.751-4.483 2.17-5.886z"/>
        <path fill="#D3FDFA" d="M411.985 283.384c1.427 1.653 2.832 3.69 4.238 6.076-4.195.293-3.197-3.426-4.238-6.076z"/>
        <path fill="#C5FAF4" d="M254.308 318.924c1.663-1.078 3.733-2.097 6.17-3.093-1.675 1.066-3.72 2.11-6.17 3.093z"/>
        <path fill="#C4FCF6" d="M319.85 453.81c-1.91 1.215-4.035 2.168-6.524 3.068a32.65 32.65 0 0 1 6.524-3.069z"/>
        <path fill="#B3FBF5" d="M455.243 304.91c1.917 1.23 3.749 2.835 5.67 4.762a34.417 34.417 0 0 1-5.67-4.762z"/>
        <path fill="#CAFCF8" d="M248.016 475.257c.8 2.358 3.588 5.208-.546 7.853-.08-2.477.2-4.95.546-7.853z"/>
        <path fill="#CCFDF9" d="M338.155 371.259c1.254-1.223 2.71-2.205 4.5-3.226a21.49 21.49 0 0 1-4.5 3.226zM273.764 346.122c-.505 1.8-1.377 3.612-2.523 5.62a25.331 25.331 0 0 1 2.523-5.62z"/>
        <path fill="#CAFCF8" d="M277.85 395.105c-.749 1.048-1.911 2.027-3.41 3.06-.756-2.61.66-3.352 3.41-3.06z"/>
        <path fill="#CCFDF9" d="M308.979 376.883c2.053-.063 4.105-.125 6.58-.056-1.767.632-3.956 1.133-6.35 1.1-.214-.704-.222-.874-.23-1.044z"/>
        <path fill="#64F6DC" d="M308.734 376.656c.253.397.261.567.26.99-1.45.254-2.891.253-4.734.094 1.142-.543 2.686-.927 4.474-1.084z"/>
        <path fill="#C5FAF4" d="M261.264 315.899c1.106-1.008 2.578-1.955 4.399-2.866-1.113 1-2.572 1.964-4.4 2.866z"/>
        <path fill="#CCFDF9" d="M277.668 342.026c-.721 1.312-1.825 2.605-3.239 3.994.745-1.274 1.8-2.644 3.239-3.994z"/>
        <path fill="#CAFCF8" d="M278.063 400.754c.333-1.395 1.037-2.717 1.812-4.365 1.957 2.02 1.37 3.582-1.812 4.365zM274.26 404.915c.7-1.314 1.79-2.577 3.144-4.004.905 2.42.102 3.97-3.143 4.004z"/>
        <path fill="#4FEAD1" d="M411.387 358.081c.76-1.03 1.87-2.043 3.316-3.066-.764 1.022-1.864 2.052-3.316 3.066z"/>
        <path fill="#CFFCF8" d="M264.648 337.22c.448 1.046.624 2.315.917 3.943-2.968.119-2.995.034-.917-3.943z"/>
        <path fill="#D3FDFA" d="M418.114 293.24c1.032.755 2.01 1.888 3.021 3.356-1.002-.77-2.039-1.874-3.021-3.356z"/>
        <path fill="#CCFDF9" d="M338.822 359.056c-1.066-.456-2.087-1.31-3.19-2.499 1.024.477 2.13 1.29 3.19 2.5z"/>
        <path fill="#4FEAD1" d="M206.341 492.994c.448-.257.777-.16 1.36-.019.261.83.27 1.614.178 2.778-.619-.548-1.138-1.477-1.538-2.76z"/>
        <path fill="#D3FDFA" d="M416.136 290.169c.721.41 1.376 1.199 2.032 2.33-.7-.423-1.399-1.188-2.032-2.33z"/>
        <path fill="#64F6DC" d="M319.767 375.143c-.244.52-.848.976-1.613 1.668-.66.214-1.162.191-2.002.004.859-.69 2.056-1.214 3.615-1.672z"/>
        <path fill="#C4FCF6" d="M306.97 458.113c-.54.638-1.444 1.212-2.699 1.727.545-.636 1.44-1.214 2.7-1.727z"/>
        <path fill="#B3FBF5" d="M450.958 319.384c.664.424 1.312 1.205 2.024 2.3-.637-.438-1.338-1.19-2.024-2.3z"/>
        <path fill="#4FEAD1" d="M208.011 479.595c-.356.472-.701.557-1.306.702.018-.96.295-1.978.855-3.19.343.572.403 1.337.451 2.488zM408.265 359.731c.499-.622 1.334-1.182 2.484-1.71-.507.611-1.327 1.192-2.484 1.71z"/>
        <path fill="#9AF9F1" d="M241.57 352.907c-.428.699-1.198 1.393-2.296 2.057.432-.707 1.192-1.385 2.296-2.057z"/>
        <path fill="#B3FBF5" d="M461.045 310.346c.689-.05 1.416.25 2.237.838-.67.028-1.434-.23-2.237-.838z"/>
        <path fill="#C4FCF6" d="M335.702 449.993c-.453.403-1.246.76-2.38 1.041.452-.414 1.245-.75 2.38-1.041zM310.697 456.966c-.45.434-1.25.824-2.39 1.133.454-.446 1.248-.811 2.39-1.133z"/>
        <path fill="#C5FAF4" d="M266.396 313.037c.118-.385.54-.762 1.26-1.148-.12.38-.538.768-1.26 1.148z"/>
        <path fill="#CAFCF8" d="M279.867 395.76c-.23.131-.498-.04-.882-.445.18-.069.499.057.882.446z"/>
        <path fill="#9AF9F1" d="M242.826 352.065c.054.25-.159.518-.633.811-.052-.247.157-.52.633-.81z"/>
        <path fill="#B3FBF5" d="M454.227 303.008c.257-.058.559.162.881.67-.265.061-.55-.166-.881-.67z"/>
        <path fill="#B4F8EA" d="M453.876 296.91c.059.187-.318.357-.522.323.02-.192.241-.35.522-.322z"/>
        <path fill="#D3FDFA" d="M434.082 282.482c.079-.288.252-.39.735-.348.31.143.442.586.442.586s-.188.198-.285.296c-.366.004-.6-.144-.892-.534z"/>
        <path fill="#2DD9AF" d="M71.066 500.764c-.493-1.551-1.078-3.488-1.079-5.426-.044-101.71-.049-203.42-.01-305.13.002-4.811.434-9.623 1.09-14.52.574 7.06.724 14.203.873 21.346-.009 4.336-.018 8.672-.027 13.877.01 1.954.018 3.04.026 4.124l-.026 18.872c.01 1.958.018 3.043.026 4.128l-.026 18.872c.01 1.958.018 3.043.026 4.128-.009 6-.017 12-.025 18.872.008 1.958.017 3.043.025 4.128-.009 6-.017 12-.025 18.872.008 1.958.017 3.043.025 4.128-.009 6.333-.018 12.666-.026 19.849.009 1.617.017 2.383.026 3.15-.01 6.334-.018 12.667-.026 19.85.009 1.617.017 2.383.026 3.15-.01 6.334-.018 12.667-.026 19.85.01 1.617.017 2.384.026 3.15-.01 6.334-.018 12.667-.026 19.85.01 1.617.017 2.384.026 3.15-.01 6.334-.018 12.667-.026 19.85.01 1.617.017 2.384.026 3.15-.01 6.333-.018 12.666-.026 19.873.009 1.958.017 3.043.026 4.128-.01 6-.018 12-.026 18.872.009 1.958.017 3.043.026 4.128-.008 6.002-.015 12.003-.017 18.47-.222 4.6-.449 8.737-.856 13.259z"/>
        <path fill="#01CF93" d="M72.293 196.974c-.502-7.083-.652-14.226-1.085-21.674-.3-.753-.317-1.202.038-2.127.522-1.7.671-2.924.82-4.147.025-.767.05-1.533.23-2.654 3.685 2.79 5.947 5.916 2.787 10.968-1.138 1.82-1.081 5.487.02 7.393 2.957 5.124.987 8.661-2.81 12.24z"/>
        <path fill="#11CF9F" d="M464.03 58.364c2.972 1.84 6.028 3.923 8.854 6.283 2.056 1.717 1.556 3.04-1.508 3.371-2.704-3.128-5.032-6.21-7.345-9.654z"/>
        <path fill="#01CF93" d="M72.293 306.967c-.362-1.017-.37-2.102-.367-3.594 2.817.441 2.813 1.795.367 3.594zM72.293 468.967c-.363-1.017-.371-2.102-.367-3.594 2.816.441 2.813 1.795.367 3.594zM72.293 283.967c-.362-1.017-.37-2.102-.367-3.594 2.817.441 2.813 1.795.367 3.594zM72.293 237.967c-.362-1.017-.37-2.102-.367-3.594 2.816.441 2.813 1.795.367 3.594zM72.293 260.967c-.362-1.017-.37-2.102-.367-3.594 2.817.441 2.813 1.796.367 3.594zM72.293 214.967c-.362-1.017-.37-2.102-.367-3.594 2.816.441 2.813 1.795.367 3.594zM72.293 445.967c-.363-1.017-.371-2.102-.367-3.594 2.816.441 2.813 1.795.367 3.594zM72.28 421.977c-.35-.71-.358-1.476-.354-2.627 2.255.134 2.73 1.06.355 2.627zM72.28 375.977c-.35-.71-.358-1.476-.354-2.627 2.255.134 2.73 1.06.355 2.627zM72.28 352.977c-.35-.71-.358-1.476-.354-2.627 2.254.134 2.73 1.06.355 2.627zM72.28 398.977c-.35-.71-.358-1.476-.354-2.627 2.255.134 2.73 1.06.355 2.627zM72.28 329.977c-.35-.71-.358-1.476-.354-2.627 2.255.134 2.73 1.06.355 2.627z"/>
        <path fill="#11CF9F" d="M408.21 54.287c.658-.4 1.523-.552 2.63-.615-.645.347-1.534.605-2.63.615z"/>
        <path fill="#FEFDFE" d="M215.966 165.82c-1.054.08-2.108.159-3.834-.094-4.532.194-8.46.43-12.24 1.302-11.885 2.742-24.584 1.298-36.044 6.675-1.635-1.737-3.915-2.875-1.933-5.504 1.543-2.045 2.475-4.435 6.172-3.557 1.668.396 3.924-1.687 6.282-2.69 1.908-.984 3.345-2.446 5.003-2.769 6.453-1.254 12.943-2.543 19.48-3.078 8.923-.73 17.77-1.321 26.436-3.995 6.529-2.015 13.453-1.62 20.281-3.538 10.33-2.901 21.567-2.573 32.463-3.237.018 2.81-.007 5.241-.47 7.675-4.117.984-7.743 2.373-11.487 2.866-9.545 1.259-19.167 1.94-28.697 3.283-1.94.273-3.615 2.436-5.413 3.727-.433.067-.867.135-1.84-.141-4.473-1.996-10.644-.447-14.16 3.075z"/>
        <path fill="#FDFEFD" d="M490.027 115.703c-2.326 1.346-4.63 2.37-7 3.754-.8.421-1.537.485-2.826.194-2.37-.507-4.259-1.06-5.991-.747-8.758 1.58-17.476 3.384-26.244 4.759-2.685-2.464-5.333-4.576-7.982-6.688 4.926-1.964 9.351-6.495 15.409-2.854.449.27 1.788-1.265 2.828-1.593 2.957-.934 5.973-1.677 9.374-2.476 4.22 4.737 9.137 2.888 13.834 2.254 2.904-.392 5.798-.868 9.133-.973.438.778.438 1.223.438 1.667-.317.793-.634 1.587-.973 2.703z"/>
        <path fill="#DAFDF9" d="M448.003 124.014c8.731-1.726 17.449-3.53 26.207-5.11 1.732-.313 3.621.24 5.622.707-6.881 1.836-13.905 3.603-21.022 4.835-20.363 3.524-40.772 6.781-61.147 10.238-15.958 2.708-31.893 5.557-48.209 7.944.607-1.134 1.584-1.869 2.933-2.61 1.785-.342 3.199-.68 4.982-1.02 1.79-.33 3.21-.658 4.957-.98.762.01 1.197.013 1.87.278 2.749 1.196 4.398.56 5.267-2.272 2.13-.01 3.833-.02 5.987-.025 3.083-.055 6.355.858 8.223-.368 4.587-3.01 9.457-2.385 14.695-2.656 1.793-.649 3.215-1.308 5.015-2.008 3.12-.674 5.862-1.307 8.87-1.661 1.556.397 2.891.788 4.13.588a536.118 536.118 0 0 0 17.928-3.226c.652-.128 1.143-1.072 2.141-1.644 4.138-.34 7.844-.675 11.55-1.01z"/>
        <path fill="#0BCB95" d="M430 163.54c-.688.46-1.25.605-1.94 1.013-.13.265-.574.39-.768.512-5.13 4.091-10.216 7.888-14.952 12.081-3.765 3.335-7.103 7.153-10.975 10.802-.461-.386-.578-.818-.78-1.575.426-1.759.936-3.192 1.438-5.006-.009-.382.183-.636.516-.941 1.067-1.661 1.8-3.017 2.534-4.373 0 0-.072-.048.197-.113.412-.362.554-.66.697-.959 0 0 .034.018.33-.088.786-1.032 1.275-1.956 1.765-2.88 4.747-4.272 9.494-8.543 14.902-12.962 4.94-2.183 9.217-4.22 13.495-6.257 2.322.088 4.644.176 7.354.315-1.99 1.738-4.369 3.426-6.917 5.42-2.37 1.77-4.57 3.232-6.896 5.01z"/>
        <path fill="#DAFDF9" d="M232.383 162.986c1.38-1.391 3.054-3.554 4.995-3.827 9.53-1.343 19.152-2.024 28.697-3.283 3.744-.493 7.37-1.882 11.92-2.864 9.25-1.666 17.63-3.331 26.422-5.049 5.136-.684 9.86-1.316 14.994-1.951 8.135-1.669 15.862-3.335 23.962-5 1.12.005 1.866.008 2.62.332l.047 1.605c-6.769 1.424-13.502 3.049-20.312 4.233-17.607 3.063-35.255 5.89-52.872 8.89-13.363 2.276-26.705 4.672-40.473 6.914zM164.005 174.011c11.303-5.685 24.002-4.24 35.887-6.983 3.78-.872 7.708-1.108 11.845-1.354-6.825 1.75-13.927 3.219-21.03 4.69-7.272 1.507-14.6 2.798-21.792 4.625-3.147.799-6.015 2.695-9.47 4.043-.459-.05-.656-.246-.588-.535.096-.686.123-1.083.46-1.617 1.77-1.047 3.23-1.958 4.688-2.869zM149.657 215.099c-1.884 3.496-3.085 8.386-9.325 7.019-.316-6.488-.314-12.83-.035-19.842 2.35-3.938 4.421-7.204 6.58-10.39l.26.237c-1.767 7.486-3.606 14.957-5.24 22.472-.318 1.461.163 3.096.357 5.78 2.96-2.19 5.007-3.703 7.403-5.276z"/>
        <path fill="#AAFAF1" d="M436.202 152.535c-4.02 2.296-8.299 4.333-12.944 6.343.196-1.067.76-2.105 1.559-3.574-1.687-.136-3.024-.244-4.765-.452 4.651-3.406 10.235-3.238 16.15-2.317z"/>
        <path fill="#B3FBF5" d="M462.447 150.013c-.747-.091-1.01-.26-1.381-.671 8.167-2.807 16.52-2.939 25.205-.426-.258.437-.805.674-1.8.944-4.862-.189-9.273-.547-13.686-.585-2.627-.022-5.259.459-8.338.738z"/>
        <path fill="#AAFAF1" d="m517.482 143.448-5.969-6.375.539-1.6c4.631.817 9.263 1.634 14.01 2.882.117.43-.113.715-.551.69-2.967-.026-5.497-.026-8.387-.026.435 1.755.7 2.823.813 4.026l-.455.403z"/>
        <path fill="#B3FBF5" d="M331.08 187.554c-2.14-.341-4.474-.83-6.653-1.707a189.336 189.336 0 0 1-14.375-6.487c6.934 2.379 13.92 5.125 21.029 8.194z"/>
        <path fill="#DAFDF9" d="M170.676 201.07c-1.553 1.82-3.277 3.881-5.428 5.294-2.725 1.79-5.796 3.054-9.108 4.465 4.466-3.322 9.32-6.564 14.536-9.76z"/>
        <path fill="#B8FBF3" d="M354.336 193.6c-.87 4.86-2.795 5.554-9.916 3.415-2.715-1.806-5.033-3.568-7.389-5.68 2.898 1.024 6.075 2.049 8.708 3.863 3.536 2.436 5.956 1.462 8.597-1.598z"/>
        <path fill="#DAFDF9" d="M216.38 165.899c3.101-3.601 9.272-5.15 13.42-3.217-4.192 1.285-8.599 2.29-13.42 3.217z"/>
        <path fill="#2DD9AF" d="M255.015 187.357c-4.181.42-8.718.539-13.635.546 4.007-3.451 8.651-2.017 13.635-.546z"/>
        <path fill="#DAFDF9" d="M270.758 179.377c.304.996.285 1.91-.117 3.289-.636.574-.888.684-1.14.795-1.567-.013-3.134-.026-5.122-.38-.742-.934-1.062-1.528-1.382-2.121.673-.073 1.347-.145 2.708-.11 1.598-.4 2.509-.909 3.42-1.417a9.359 9.359 0 0 1 1.633-.056z"/>
        <path fill="#0BCB95" d="M457.934 148.538c-3.322 1.405-6.713 2.467-10.487 3.548 1.027-3 6.95-5.142 10.487-3.548z"/>
        <path fill="#AAFAF1" d="M362.595 184.96c-2.118 2.579-4.579 5.193-7.366 7.922a100.379 100.379 0 0 1 7.366-7.923z"/>
        <path fill="#FCFFFE" d="M346.405 143.006c-.378-.485-.39-.913-.205-1.944 2.071-.748 3.943-.893 5.816-1.038-.978.735-1.955 1.47-2.99 2.521-.791.384-1.524.45-2.621.461z"/>
        <path fill="#AAFAF1" d="M533.933 141.62c-1.618.026-3.355-.285-5.635-.866a27.854 27.854 0 0 1-2.349-1.684l.345-.428c2.584.785 5.052 1.714 7.64 2.978z"/>
        <path fill="#DAFDF9" d="M159.086 179.08a64.88 64.88 0 0 1-5.85 5.715c-.369.074-.502-.056-.419-.396 2.046-2.097 4.009-3.855 5.972-5.613 0 0 .197.197.297.294z"/>
        <path fill="#AAFAF1" d="M522.84 148.673c.083 1.473.1 2.615.037 4.18-1.034-1.419-1.988-3.261-2.934-5.461.949.078 1.89.514 2.897 1.281z"/>
        <path fill="#B3FBF5" d="M513.032 158.636c-1.997-.698-3.992-1.745-6.055-3.132 1.973.701 4.015 1.742 6.055 3.132z"/>
        <path fill="#AAFAF1" d="M391.626 164.95c-1.731 1.346-3.821 2.7-6.288 4.032 1.726-1.357 3.827-2.69 6.288-4.033z"/>
        <path fill="#9AF9F1" d="M262.784 180.794c.533.76.853 1.353 1.275 2.176-1.234.02-2.568-.19-4.146-.681.724-.74 1.69-1.2 2.87-1.495z"/>
        <path fill="#AAFAF1" d="M397.634 161.972c-1.191.987-2.74 1.95-4.675 2.798 1.183-1.017 2.75-1.92 4.675-2.798z"/>
        <path fill="#10CB9A" d="M237.962 187.887c-1.675.112-3.35.223-5.44.28.5-3.657 2.817-1.959 5.15-1.074.327.368.29.794.29.794z"/>
        <path fill="#DAFDF9" d="M155.418 210.752c-.785 1.044-1.913 2.108-3.447 3.115.764-1.07 1.934-2.083 3.447-3.115z"/>
        <path fill="#B3FBF5" d="M336.294 190.39c-1.342-.302-2.782-.935-4.295-1.93 1.35.292 2.774.944 4.295 1.93z"/>
        <path fill="#DAFDF9" d="M150.073 188.065c-.791 1.248-1.582 2.496-2.655 3.901-.28.157-.454-.001-.479-.407.34-1.454.704-2.501 1.365-3.56.685-.084 1.073-.156 1.537-.154l.232.22z"/>
        <path fill="#AAFAF1" d="M365.718 182.117c-.475.899-1.26 1.88-2.42 2.84.455-.936 1.281-1.846 2.42-2.84z"/>
        <path fill="#DAFDF9" d="M152.933 184.935a24.21 24.21 0 0 1-2.58 2.993c-.28.137-.435-.01-.435-.417.939-1.196 1.878-1.984 2.816-2.772l.2.196z"/>
        <path fill="#9AF9F1" d="M268.81 179.35c-.596.591-1.507 1.1-2.767 1.524.585-.592 1.518-1.1 2.767-1.524z"/>
        <path fill="#0BCB95" d="M446.731 152.048c-.414.4-1.184.78-2.305 1.162.416-.393 1.183-.786 2.305-1.162z"/>
        <path fill="#B3FBF5" d="M307.377 179.035c-.376-.019-.383-.491-.389-.727.888-.127 1.781-.017 2.847.39-.578.318-1.33.337-2.458.337z"/>
        <path fill="#10CB9A" d="M231.772 188.077c-.187.305-.661.59-1.417.825.19-.315.66-.58 1.417-.825z"/>
        <path fill="#AAFAF1" d="M519.011 142.996c.005.48.01.96-.038 1.796-.468-.03-.883-.415-1.394-1.072-.097-.272.207-.54.587-.639.38-.099.845-.085.845-.085z"/>
        <path fill="#DAFDF9" d="M150.763 214.153c.17.303-.01.541-.505.777-.061-.21.096-.489.505-.777z"/>
        <path fill="#2DD9AF" d="M238.224 187.946c-.262-.059-.225-.485-.207-.697.272-.144.526-.075 1.117.204.01.323-.32.437-.91.493z"/>
        <path fill="#DAFDF9" d="M547.212 126.174c.226-.175.453-.045.71.358-.245.26-.492.15-.71-.358z"/>
        <path fill="#B3FBF5" d="M513.861 159.807c-.167.032-.476-.13-.812-.568.259-.115.491.1.812.568z"/>
        <path fill="#AAFAF1" d="M519.988 162.708c-.303.253-.578.103-.899-.389.207-.101.532.009.9.389zM519.188 146.183c.365-.176.612.033.766.614-.253.05-.517-.151-.766-.614z"/>
        <path fill="#DAFDF9" d="M552.214 132.232c.298-.17.52-.006.745.446-.306.274-.581.14-.745-.446z"/>
        <path fill="#9AF9F1" d="M274.756 178.049c.265.035.252.49.244.718-.224.203-.44.18-.964.043-.053-.341.201-.57.72-.761z"/>
        <path fill="#FCFFFE" d="M128.994 554.993c.001-114.828-.024-229.655.104-344.483.005-4.354 1.496-8.707 2.583-13.294.63.657 1.245 1.539 1.272 2.438.395 13.122 1.035 26.247.98 39.369-.123 29.624-.74 59.245-.906 88.869-.416 74.528-.692 149.058-1.043 223.587-.006 1.312-.255 2.622-.986 4.206-1.065-.048-1.535-.37-2.004-.692zM148.007 188.01c-.364 1.048-.728 2.095-1.154 3.469a204.132 204.132 0 0 1-6.553 10.33c-2.052-3.096-3.83-6.396-5.967-9.758-.661-1.795-.964-3.528-1.293-5.64-.013-.552 0-.723.418-1.16 1.118-.595 1.83-.925 2.687-.953 1.13 1.063 2.114 1.825 3.098 2.587l1.01-1.492a103.994 103.994 0 0 1-3.493-2.584c.864-2.498 1.912-4.785 2.96-7.071 0 0 .283.251.518.18 2.084-1.077 4.143-1.826 5.747-3.134 8.183-6.67 16.964-11.633 28.015-10.788-1.989.959-4.245 3.042-5.913 2.646-3.697-.878-4.63 1.512-6.172 3.557-1.982 2.629.298 3.767 1.933 5.504a12.902 12.902 0 0 1-4.534 2.772c-.017-6.25-4.98-3.727-6.912-4.805-1.52 1.381-2.513 2.542-3.738 3.35-4.757 3.133-5.131 9.74-.657 12.99z"/>
        <path fill="#F8FEFE" d="M128.735 555.104c.728.211 1.198.533 1.966.875.298.771.298 1.521.298 2.646-1.306-.379-2.612-1.133-3.96-2.239.451-.625.944-.898 1.696-1.282z"/>
        <path fill="#B4F8EA" d="M559.611 495.03c-.374-.121-.459-.312-.57-1.258-.024-76.288-.024-151.82-.024-227.64-1.29.519-2.028.815-2.874 1.005a73.236 73.236 0 0 1-.322-.322l3.195-2.764c.648 1.466 1.855 2.93 1.861 4.398.114 24.574.077 49.148.076 73.723 0 9.63.005 19.26.008 29.788.01 2.611.02 4.325.029 6.04-.01 5.355-.02 10.71-.029 16.96.01 2.611.02 4.325.03 6.04-.011 30.355-.022 60.71-.022 91.533-.348 1.122-.708 1.776-1.358 2.498z"/>
        <path fill="#B4F8EA" d="m555.799 268.886-16.894 16.34-.961-.796 3.947-9.578c-7.106 5.594-13.139 10.342-19.523 15.112.998-1.509 2.299-3.087 3.713-4.555 1.23-1.278 2.589-2.432 3.952-3.978 1.034-1.111 2.009-1.885 3.033-2.988 2.21-1.828 4.209-3.712 6.581-4.7 1.808-.75 4.089-.364 6.159-.483l.825 2.069c2.852-2.762 5.705-5.523 8.874-8.399.316-.115.53.1.583.486-.062.747-.175 1.108-.29 1.47z"/>
        <path fill="#F8FEFE" d="M561.359 377.928c-.379-1.643-.388-3.357-.384-5.5 3.11 1.165 2.717 3.197.384 5.5zM561.36 400.927c-.38-1.642-.39-3.356-.385-5.499 3.111 1.164 2.716 3.197.384 5.5z"/>
        <path fill="#FEFDFE" d="M173.004 201.533c7.819-2.155 7.813-2.155 7.03 6.133-.077.818-.02 1.648-.033 2.903-5.406-.242-5.804-4.758-6.997-9.036z"/>
        <path fill="#DAFDF9" d="M417.755 90.742c-7.107 1.83-14.485 3.394-21.88 4.873-2.745.549-5.531.895-8.627.79-.307-.831-.286-1.12-.265-1.409 3.711-.674 7.422-1.348 11.865-2.037 1.205-.334 1.678-.654 2.152-.974 5.492-.514 10.984-1.028 16.755-1.243zM440.643 87.05c-3.97.974-8.41 1.888-13.278 2.725.757-.972 1.866-2.489 3.138-2.64 3.184-.378 6.441-.138 10.14-.085z"/>
        <path fill="#ECFEFD" d="M442.99 86.565c-.426.458-.85.552-1.598.593.092-1.048.507-2.044 1.277-3.085.344.68.333 1.404.321 2.492z"/>
        <path fill="#FEFEFF" d="M386.624 94.998c.338.287.317.576.257 1.299-1.097.528-2.155.622-3.532.676-.315-.21-.313-.378-.306-.798 1.077-.56 2.15-.868 3.58-1.177z"/>
        <path fill="#ECFEFD" d="M400.828 91.76c-.302.545-.775.865-1.551 1.193.258-.468.819-.943 1.551-1.193z"/>
        <path fill="#DAFDF9" d="M423.984 90.09c-.516.38-1.398.686-2.633.906.52-.384 1.393-.68 2.633-.905z"/>
        <path fill="#10CB9A" d="M155.933 578.526c3.011-3.132 3.074.186 4.01 2.127-.003.424-.129.57-.438.535-.72-.052-1.131-.07-1.543-.087-.394-.346-.788-.692-1.425-1.135-.345-.454-.447-.81-.604-1.44z"/>
        <path fill="#F8FEFE" d="M141.332 566c-.33-1.399-.328-2.798-.317-4.618.667.996 1.325 2.413 1.98 4.225-.446.395-.888.394-1.663.393z"/>
        <path fill="#99FDF9" d="M221.971 250.385c3.01-.3 5.978-.236 9.543.089.874.464 1.18.535 1.516.476l7.429 1.498-.123 1.647c-8.148 0-16.295 0-24.908-.087 1.856-1.144 4.178-2.202 6.543-3.623z"/>
        <path fill="#49E0C5" d="M195.792 248.747c7.066-.027 14.393.235 21.994.76a302.376 302.376 0 0 1-21.994-.76zM175.663 247.04c1.255.536 2.154 1.477 3.075 1.5 2.6.063 5.208-.25 8.269-.258-3.577.696-7.625 1.734-11.637 1.605-2.83-.09-2.143-1.817.293-2.847z"/>
        <path fill="#2DD9AF" d="M204.61 241.096c-1.404.623-3.203 1.162-5.25 1.491 1.454-.665 3.154-1.12 5.25-1.49zM195.79 242.469c-.578.62-1.454 1.082-2.663 1.48.567-.589 1.465-1.114 2.662-1.48z"/>
        <path fill="#10CB9A" d="M344.566 247.978c-.604 5.27-4.93 3.155-7.735 3.266-4.01.158-8.067-.861-12.097-.548l9.104 5.963c-2.702.203-3.782.285-5.199.348-4.096-1.38-7.82-2.853-11.625-4.076-4.877-1.568-10.011-2.54-13.606-7.018 13.575.665 27.15 1.33 41.158 2.065zM384.055 237.998c-5.234 1.822-10.362 4.568-15.734 5.185-4.614.53-7.61 5.79-13.002 3.556-1.658-.688-4.12.562-6.266.584 8.508-3.236 17.115-6.003 25.599-9.107 2.368-.867 4.373-2.73 7.114-4.176.91-.322 1.25-.603 1.59-.884 0 0-.016-.445-.037-.667.383-.275.787-.33 1.689-.522.744-.303.912-.525 1.003-.806 0 0 .053-.156.396-.147.75-.293 1.158-.595 1.566-.897.107-.133.215-.266.686-.184-1.292 2.831-2.948 5.448-4.604 8.065z"/>
        <path fill="#22C9A4" d="M383.077 233.215c-.062.222-.402.503-.968.757.079-.251.385-.475.968-.757z"/>
        <path fill="#B8FBF3" d="M404.714 176.096c-.375 1.313-1.108 2.669-2.144 4.174.394-1.278 1.09-2.705 2.144-4.174zM407.71 172.048c-.138.89-.627 1.813-1.425 2.83.151-.87.612-1.833 1.425-2.83zM405.717 175.063c.107.216-.035.515-.42.91-.104-.21.032-.52.42-.91z"/>
        <path fill="#C4FCF6" d="m481.019 256.07-2.587-1.195c7.044-4.377 13.897-8.634 21.082-12.97-.377 3.403-1.751 7.026 3.43 9.657-2.623 1.88-4.651 3.334-6.705 4.157-.136-1.353-.247-2.075-.357-2.798l-14.863 3.15z"/>
        <path fill="#22C9A4" d="M481.253 256.314c4.72-1.293 9.674-2.343 14.629-3.393.11.723.22 1.445.194 2.514-.962.6-1.786.851-2.836 1.338-1.208.584-2.191.934-3.305 1.578-.13.296-.103.326-.437.311-1.068.425-1.801.866-2.535 1.306 0 0 .018.02.011.006-.446-.011-.887-.009-1.655-.052.366-1.258 1.059-2.47 1.844-3.842-2.11.178-3.893.327-5.91.234z"/>
        <path fill="#C4FCF6" d="M503.126 239.808c2.821-3.932 6.002-7.822 9.497-11.829-2.835 3.879-5.987 7.874-9.497 11.829z"/>
        <path fill="#D7FDFA" d="M520.56 215.041c-.312-.542-.222-1.107.372-1.998.685-.914.866-1.504 1.047-2.094 0 0 .211-.415.416-.524-.34 1.458-.886 3.026-1.834 4.616z"/>
        <path fill="#9AF9F1" d="M517.426 221.012c.043-.952.444-1.953 1.165-3.069-.056.93-.432 1.975-1.165 3.07z"/>
        <path fill="#C4FCF6" d="M500.222 241.896c.395-.71 1.166-1.366 2.244-2.078-.419.674-1.143 1.403-2.244 2.078z"/>
        <path fill="#9AF9F1" d="M516.403 221.978c-.103-.21.003-.525.38-.876.238.296.091.565-.38.876z"/>
        <path fill="#C5FAF4" d="M265.996 298.87a17.16 17.16 0 0 0 1.665-.174c1.23-.087 2.134-.087 4.395-.087-3.231 2.907-5.763 5.184-8.638 7.507-.636-1.163-.927-2.372-1.225-4.215 1.263-1.433 2.533-2.232 3.803-3.031zM246.418 316.086c-.173-3.599 2.548-2.97 5.186-3.1-1.345 1.067-3.088 2.097-5.186 3.1zM252.366 313.029c1.08-1.039 2.501-2.062 4.308-3.044-1.065 1.048-2.516 2.053-4.308 3.044zM259.29 308.934c.205-.612.738-1.224 1.614-1.825-.2.616-.743 1.221-1.614 1.825z"/>
        <path fill="#FCFFFE" d="M343 141.01c-7.727 1.667-15.454 3.333-23.64 4.656-3.43-2.458-6.402-4.574-9.16-6.97 2.787-.913 5.414-1.38 7.92-2.213 4.011-1.333 7.942-2.908 11.907-4.38.733-.092 1.466-.184 2.847.08 1.614.506 2.628.925 3.542.766 9.386-1.63 18.76-3.327 28.119-5.111.586-.112 1.005-1.105 1.502-1.688a30.951 30.951 0 0 1 2.529-.246c1.146.714 1.93 1.394 3.04 2.428-1.787 4.053-3.896 7.31-8.757 3.388-.973-.786-3.112-.354-4.666-.139-2.22.307-4.449 1.5-6.581 1.306-5.136-.47-8.588 2.26-12.195 4.883l3.593 3.24z"/>
        <path fill="#FEFEFF" d="M343.373 141.012c-1.473-.994-2.573-1.986-3.966-3.242 3.607-2.623 7.06-5.353 12.195-4.883 2.132.195 4.36-1 6.58-1.306 1.555-.215 3.694-.647 4.667.139 4.861 3.922 6.97.665 9.117-3.38.475-.354.917-.36 1.918-.092 2.078.767 3.597 1.26 4.965 2.06-1.384 2.1-2.617 3.893-3.849 5.687-1.704.009-3.407.018-5.813-.08-2.21.636-3.72 1.378-5.229 2.12-.435-.004-.87-.008-1.692-.369-3.078-2.865-4.506-1.732-5.266 1.333-1.414.338-2.828.677-4.613 1.02-2.244.15-4.116.295-6.195.722-.953.28-1.7.276-2.819.271z"/>
        <path fill="#FDFEFD" d="M436.02 125.031c-.566.565-1.057 1.509-1.709 1.637a536.118 536.118 0 0 1-17.927 3.226c-1.24.2-2.575-.191-4.091-.942.713-2.76 3.091-4.909-.311-6.978.617-.882 1.493-2.616 1.812-2.52 6.7 2.043 12.196-2.26 18.286-3.263 1.095-.18 2.272.14 3.485.847-1.614 1.066-3.348 1.39-4.975 1.999-1.529.573-2.945 1.447-4.41 2.188 1.276.931 2.432 2.198 3.86 2.71 1.881.676 3.976.759 5.98 1.096z"/>
        <path fill="#FEFEFE" d="M375.45 136c.782-1.799 2.015-3.592 3.77-5.697 2.607-1.982 4.693-3.652 6.78-5.321 1.063-.005 2.127-.01 3.63.343 2.141 1.761 3.89 3.114 5.53 4.586 1.03.924 1.898 2.03 2.838 3.053-4.868.282-9.738-.343-14.325 2.667-1.868 1.226-5.14.313-8.223.368z"/>
        <path fill="#FEFEFF" d="M436.452 125.024c-2.436-.33-4.53-.413-6.413-1.089-1.427-.512-2.583-1.779-3.86-2.71 1.466-.741 2.882-1.615 4.411-2.188 1.627-.61 3.36-.933 5.237-1.723 1.247-.339 2.306-.336 3.76-.337a76.442 76.442 0 0 1 8.38 6.686c-3.67.686-7.377 1.02-11.515 1.361z"/>
        <path fill="#FCFCFC" d="M411.53 121.976c3.854 2.067 1.476 4.215.498 6.697-2.783.987-5.525 1.62-8.866 2.022-4.162-1.076-6.198-2.763-3.807-6.7 1.119-.673 1.883-1.341 2.648-2.01 3.025-.002 6.05-.004 9.527-.009z"/>
        <path fill="#FDFEFD" d="M399 124c-2.036 3.932 0 5.619 3.785 6.736-1.202.931-2.624 1.59-4.417 2.239-1.31-1.035-2.179-2.14-3.209-3.064-1.64-1.472-3.388-2.825-5.13-4.59.43-.673.899-.985 1.862-1.06 1.366-.263 2.237-.762 3.109-1.261 1.103-.316 2.206-.631 3.654-.642.346.75.346 1.196.346 1.642z"/>
        <path fill="#FCFFFE" d="M385.57 124.982c-1.657 1.67-3.743 3.339-6.2 5.013-1.889-.488-3.408-.98-5.155-1.748 3.49-1.271 7.207-2.268 11.354-3.265z"/>
        <path fill="#FEFEFF" d="M508.702 104.015c-.772 1.134 2.652 5.768-2.393 3.17.351-1.083.517-1.644.683-2.205.47-.316.94-.632 1.71-.965zM505 107c-1.326-.74-2.653-1.48-3.989-2.6 1.11-.153 2.231.075 3.67.78.319.925.319 1.372.319 1.82z"/>
        <path fill="#FCFFFE" d="M394.662 123c-.534.499-1.405.998-2.475 1.238.58-.585 1.359-.91 2.475-1.237z"/>
        <path fill="#FEFEFE" d="M399.355 123.995c-.355-.44-.355-.886-.355-1.666.75-.338 1.501-.342 2.627-.344-.389.669-1.153 1.337-2.272 2.01z"/>
        <path fill="#FDFEFD" d="M505.25 107c-.25-.448-.25-.895-.25-1.678.444-.336.886-.336 1.66-.34.166.559 0 1.12-.412 1.85-.414.169-.58.168-.998.168z"/>
        <path fill="#D7FDFA" d="M474.919 210.605c-.446.106-.892.213-1.97.337-1.074.34-1.515.661-1.956.983-.37.097-.739.194-1.757.216-1.14.352-1.63.78-2.38 1.42-1.746.647-3.232 1.085-5.006 1.32-.484-1.104-.682-2.004-.866-2.892.014.012-.007-.015.213-.07.501-.204.7-.425 1.081-.858.784-.434 1.303-.73 2.165-1.02 1.095-.647 1.847-1.3 2.598-1.954 0 0 .006-.076.21-.1.428-.114.601-.263.725-.47a49.13 49.13 0 0 1 2.112-1.369c.674-.372.83-.556.921-.794.35-.176.701-.353 1.347-.539.981 1.158 1.666 2.325 2.487 4.089.116.964.096 1.333.076 1.7z"/>
        <path fill="#B3FBF5" d="M466.73 208.1c-.44.64-1.192 1.294-2.3 1.738-.356-.21-.34-.616-.34-.616.339-.014.626-.144.989-.592.532-.307.935-.411 1.65-.53zM479.063 202.034c-.413.042-.826.085-1.55.112.102-.37.516-.726 1.23-.825.3.256.32.713.32.713z"/>
        <path fill="#D7FDFA" d="M479.273 201.923c-.21.11-.23-.346-.233-.574-.002-.228.466-.402.712-.36.172.368 0 .627-.48.934z"/>
        <path fill="#B3FBF5" d="M467.782 207.47c.07.254-.103.403-.496.535-.11-.239.048-.446.496-.534zM470.796 205.349c.121.243-.034.427-.425.619-.234-.272-.106-.501.425-.62zM474.855 203.395c.109.364-.116.554-.667.619-.138-.362.082-.584.667-.62z"/>
        <path fill="#9AF9F1" d="M269.711 183.75c.042-.4.294-.51.943-.741 1.104-.07 1.813-.02 2.872.066.388.432.425.83.499 1.524-1.343.012-2.723-.275-4.314-.85z"/>
        <path fill="#DAFDF9" d="M297.401 207.979c-.416-.7-.445-1.406-.475-2.466.752.288 1.504.93 2.32 1.863-.444.392-.95.494-1.845.603zM300.913 209.705c-.588-.235-1.17-.777-1.671-1.657.612.225 1.145.788 1.671 1.657zM295.123 203.652c-.22.092-.56-.07-.984-.511.232-.1.55.078.984.51zM296.828 204.79c-.265.172-.5.008-.761-.438.188-.072.461.056.761.437z"/>
        <path fill="#FEFEFF" d="M491.446 113c-.446-.444-.446-.889-.446-1.667.687-1.01 1.298-2.147 2.076-2.275 2.148-.353 4.375-.42 6.545-.26.394.03.67 1.67 1 2.567-1.922.545-3.825 1.173-5.772 1.6-.943.206-1.969.035-3.403.035z"/>
        <path fill="#B3FBF5" d="M486.017 206.154c-.819.701-2.057 1.293-3.546 1.598.014-.769.278-1.25.543-1.73.861.008 1.723.015 3.003.132z"/>
        <path fill="#D7FDFA" d="M482.667 206.016c.082.487-.182.967-.564 1.697-.117.25-.126.28-.478.245a63.715 63.715 0 0 0-1.72-.104c.804-.614 1.61-1.23 2.762-1.838z"/>
        <path fill="#B3FBF5" d="M475.226 210.65c-.287-.413-.267-.782-.235-1.427.547-.246 1.08-.215 2.004-.08-.228.586-.845 1.069-1.77 1.506zM479.679 207.9c.681-.023 1.138-.001 1.936.045-.417.429-1.176.833-2.277.92-.341-.5-.341-.684-.34-.867 0 0 .456-.053.68-.098z"/>
        <path fill="#D7FDFA" d="M478.764 208.106c.233.075.233.258.246.716-.162.32-.337.364-.769.324-.074-.367.108-.65.523-1.04z"/>
        <path fill="#B3FBF5" d="M491.192 205.343c-.013.302-.324.519-.926.695.015-.287.321-.533.926-.695z"/>
        <path fill="#B8FBF3" d="M210.007 296.522c4.896.913 9.875 2.156 14.854 3.398l.1 1.629c-7.362 1.155-14.725 2.31-22.533 3.387 1.053-.695 2.509-1.463 4.058-1.894 2.72-.758 5.498-1.31 9.28-2.188-2.65-1.87-4.163-2.936-5.759-4.332zM196.001 290.431c3.852 1.425 7.754 3.206 11.857 5.27a116.57 116.57 0 0 1-11.857-5.27z"/>
        <path fill="#D3FDFA" d="M428.047 273.122c-.339-.121-.677-.242-1.451-.624a326.746 326.746 0 0 0-2.537-1.464s-.007-.072.193-.43c3.735-.38 7.27-.404 10.805-.427-.514 2.816.806 4.143 3.47 4.841 1.81.475 3.458 1.562 5.335 2.7-.613.347-1.382.37-2.586.112-.643-.573-.909-.643-1.233-.49-2.422-.702-4.843-1.404-7.74-2.527-1.08-.527-1.683-.633-2.286-.739 0 0-.04-.092-.241-.3-.71-.357-1.22-.505-1.729-.652zM446.828 279.049s-.035-.4-.015-.6c6.339-3.446 11.981-3.136 16.242 1.037.116.35-.08.546-.624.643-5.564-.296-10.583-.688-15.603-1.08z"/>
        <path fill="#22C9A4" d="M435.446 270.125c-3.924.075-7.459.099-11.23.473-.96.36-1.686.368-2.772.37-.1-1.282.16-2.559.573-4.583 5.577 1 10.966 1.966 16.644 3.183-.75.336-1.788.42-3.215.557zM444.477 269.896c2.804-.79 6.016-1.486 9.432-1.857-1.036.685-2.275 1.045-3.75 1.634-1.915.259-3.594.288-5.682.223z"/>
        <path fill="#B4F8EA" d="M549.442 154.934c-.379-.762-.403-1.503-.41-2.616.97.437 1.922 1.247 2.887 2.389-.7.304-1.412.276-2.477.227z"/>
        <path fill="#2DD9AF" d="M254.362 240.47c-.596.15-1.303.05-2.22-.358.563-.169 1.335-.03 2.22.359zM256.861 240.89c-.083.146-.266.161-.714.105-.025-.345.269-.4.714-.106z"/>
        <path fill="#FAFFFE" d="M442.147 159.035c1.158-1.13 2.63-2.122 4.486-3.112-.81 1.538-.654 4.973-4.486 3.112z"/>
        <path fill="#0BCD98" d="M453.647 204.3c-.626 1.224-1.324 3.002-2.613 3.724-5.117 2.87-10.401 5.447-15.682 8.012-.554.27-1.495-.258-2.302-.748 6.721-3.86 13.488-7.39 20.597-10.988zM429.643 216.056a35.863 35.863 0 0 1-6.589 3.41c2.039-1.36 4.134-2.412 6.589-3.41zM419.513 220.788c.302 3.904-2.592 3.107-5.414 3.117 1.394-1.051 3.217-2.065 5.414-3.117z"/>
        <path fill="#11CD9B" d="M265.926 298.528c-1.2 1.14-2.47 1.94-3.893 3.03-.57.307-.986.324-2.038.347-1.43.362-2.224.717-3.018 1.073 0 0 .015.017.01.007-1.338.082-2.67.174-4.4.29-.688-.834-.977-1.693-1.359-2.828 4.227.397 8.249 1.585 10.967-2.706.283-.446 2.396.269 3.73.787z"/>
        <path fill="#C5FAF4" d="M257.316 303.02c.455-.398 1.249-.753 2.377-1.028-.458.41-1.248.74-2.377 1.027z"/>
        <path fill="#22C9A4" d="M384.278 238.277c1.433-2.896 3.089-5.513 4.618-8.443a24.831 24.831 0 0 1 3.98-4.393c.12-.104 1.258.97 1.886 1.834-1.361 1.81-2.685 3.283-4.548 5.357 1.98.178 3.008.271 4.415.434-2.091 3.879-5.319 6.217-10.351 5.211zM387.716 230.151c-.15.268-.558.57-1.232.894.148-.272.562-.566 1.232-.894zM385.774 231.179c.146.263-.022.485-.465.725-.242-.287-.1-.548.465-.725z"/>
        <path fill="#FAFFFE" d="M519.346 142.825c-.335.171-.8.157-1.028.121-.494-1.104-.759-2.172-1.194-3.927 2.89 0 5.42 0 8.387.026 1.04.497 1.642.968 2.409 1.679-2.636.802-5.438 1.366-8.574 2.1z"/>
        <path fill="#22C9A4" d="M457.359 268.148c.456-.406 1.254-.775 2.406-1.104-.451.407-1.258.774-2.406 1.104z"/>
        <path fill="#B4F8EA" d="M555.365 509.994c.853-3.17 2.03-6.383 3.487-9.82.447-.224.615-.224 1.037-.21.203.462.153.91-.174 1.898-.774 2.065-1.27 3.59-1.767 5.115-.753.991-1.506 1.982-2.583 3.017z"/>
        <path fill="#F8FEFE" d="M558.31 506.947c.134-1.495.631-3.02 1.407-4.748 2.094 2.045 1.578 3.665-1.407 4.748z"/>
        <path fill="#9AF9F1" d="M523.684 206.121c-.406-1.064-.523-2.146-.749-3.622.441-.183.99.028 1.816.352.299.872.32 1.632.36 2.772-.367.413-.752.447-1.427.498z"/>
        <path fill="#22C9A4" d="M446.545 279.206c5.303.235 10.322.627 15.79 1.022-.7.932-1.79 2.568-3.002 2.664-4.454.352-8.949.192-13.888.121-.034-1.285.392-2.467 1.1-3.807zM435.666 282.732c-.407-.012-.539-.455-.562-.685 1.783-.046 3.588.138 5.63.554-1.396.202-3.029.172-5.068.13z"/>
        <path fill="#01BB90" d="M249.42 240.17c-4.767.31-9.992.542-15.212.842-4.098.235-8.189.64-12.289.766-.92.029-1.868-.785-2.855-1.605-.053-.393.193-.582.344-.552 9.953.187 19.756.345 30.013.55z"/>
        <path fill="#D3FDFA" d="M487.317 259.992c.38-.464 1.113-.905 2.187-1.311-.384.467-1.109.901-2.187 1.311z"/>
        <path fill="#B4F8EA" d="M554.013 511.804c-.109-.27.078-.559.512-.931.092.248-.062.58-.512.931z"/>
        <path fill="#DAFDF9" d="M329.609 132.02c-3.547 1.555-7.478 3.13-11.489 4.463-2.506.833-5.133 1.3-8.25 2.216-.987.289-1.428.293-2.335.295-10.876-1.513-19.867 3.905-29.547 5.961-10.852 1.044-22.089.716-32.419 3.617-6.828 1.917-13.752 1.523-20.281 3.538-8.666 2.674-17.513 3.265-26.436 3.995-6.537.535-13.027 1.824-19.48 3.078-1.658.323-3.095 1.785-5.003 2.769-11.42-.801-20.201 4.162-28.384 10.832-1.604 1.308-3.663 2.057-5.887 3.007 5.574-8.248 14.087-12.821 23.497-15.057 11.07-2.63 22.453-3.93 33.686-5.89 8.946-1.562 17.857-3.327 26.807-4.865 15.806-2.716 31.64-5.261 47.441-8.003 13.353-2.318 26.668-4.85 40.012-7.212 5.867-1.038 11.766-1.89 18.068-2.744z"/>
        <path fill="#01BB90" d="M127.29 199.37c.031 5.67-.139 10.991-.14 16.313-.01 110.547-.001 221.095.004 331.642v8.175c-1.647-1.437-2.624-2.29-3.85-3.396 2.503-3.22 2.765-6.754 2.762-10.659-.088-112.805-.071-225.611-.058-338.417 0-1.65.178-3.298.272-4.947.135.043.322.046.393.138.192.247.334.533.618 1.151z"/>
        <path fill="#DAFDF9" d="M365.6 126.068c-.06.665-.479 1.658-1.065 1.77a1734.687 1734.687 0 0 1-28.119 5.111c-.914.159-1.928-.26-3.174-.713 7.057-1.815 14.379-3.397 21.733-4.813 3.364-.648 6.79-.968 10.626-1.355zM135.999 183.996c-.712.33-1.423.66-2.428 1.025 1.651-2.989 3.596-6.013 5.845-9.16-.744 2.163-1.792 4.45-2.755 7.16-.108.683-.357.868-.662.975zM111.016 169.472c.817-.772 1.63-1.087 2.773-1.392-.428 1.721-1.188 3.433-2.249 5.337-.376-1.036-.452-2.262-.524-3.945z"/>
        <path fill="#01BB90" d="M128.458 194.215c.26.018.233.492.095.684-.21-.105-.283-.403-.095-.684z"/>
        <path fill="#01C18E" d="M91.06 524.977c-1.46-.67-2.92-1.34-4.548-2.337 2.46-1.45 3.394-2.997 2.724-6.158-.594-2.8.392-5.9.357-8.862-.057-4.773-.555-9.541-.564-14.312-.054-31.79-.028-63.58-.028-95.37 0-68.575-.008-137.148.05-205.722.002-2.01.725-4.018 1.536-5.656.426 3.2.428 6.03.429 8.859l.044 329.558z"/>
        <path fill="#64F6DC" d="M91.386 524.71c-.34-109.586-.356-219.439-.37-329.291 0-2.83-.003-5.66-.037-8.957.137-.505.307-.542.739-.576.347 1.827.51 3.65.51 5.472-.003 109.053-.015 218.107-.052 327.16 0 1.975-.303 3.95-.79 6.192zM93.803 178.591c-.1.311-.267.329-.68.3-.34-.366-.274-.647.143-1.008.284.06.378.237.537.708z"/>
        <path fill="#03D299" d="M71.782 169.243c.135 1.006-.014 2.23-.45 3.603-.136-1.028.015-2.207.45-3.603z"/>
        <path fill="#0BCF96" d="M425.026 508.555c-5.175-1.255-10.003-.46-14.528 3.404 2.5-9.046-.519-17.211-3.905-25.677 7.735 3.323 12.373 9.683 16.874 16.655.656 1.873 1.024 3.576 1.559 5.618z"/>
        <path fill="#C8FCF6" d="M315.982 531.684c-3.603-4.504-5.038-9.827-3.231-15.841 1.09-3.63 2.007-7.313 3.002-10.972l-1.123-.904c-1.969 1.663-3.937 3.326-6.27 4.702-.365-.748-.366-1.208-.368-1.668 2.442-2.622 4.883-5.244 7.983-7.793 1.456 1.315 2.254 2.556 3.052 3.797-.027 1.689-.053 3.378-.428 5.55a151.89 151.89 0 0 0-2.59 4.446c-.047 4.4-.095 8.8-.094 13.604.066 1.82.082 3.237.067 5.08z"/>
        <path fill="#4FEAD1" d="M386.065 507.354c.694 4.028 2.475 8.802 1.498 12.924-.886 3.741-4.334 1.41-6.572-.83 1.308-.05 2.718.254 4.958.736 0-4.382 0-8.375.116-12.83z"/>
        <path fill="#FCFFFE" d="M398.04 490.362c1.72-.15 3.961 1.41 4.701-2.162 2.7 1.353 3.294 3.605.884 5.188-2.575 1.69-4.5-.064-5.585-3.026z"/>
        <path fill="#49E0C5" d="M402.66 525.989c-.658.9-1.687 1.794-2.717 2.69.11-.797.22-1.593.602-2.54.763-.152 1.254-.154 2.116-.15zM400.814 511.746c-.628-.603-1.135-1.543-1.56-2.812.615.606 1.149 1.542 1.56 2.812z"/>
        <path fill="#0BCF96" d="M408.77 516.149c.144.514.007 1.15-.414 1.811-.146-.546-.007-1.118.413-1.811z"/>
        <path fill="#4FEAD1" d="M385.555 503.101c.362-.045.506.193.484.714-.367.08-.546-.159-.484-.714z"/>
        <path fill="#0BCF96" d="M409.742 512.17c.188.167.134.333-.083.564-.102.084-.285-.232-.285-.232s.186-.314.368-.333z"/>
        <path fill="#49E0C5" d="M404.62 523.91c.106.218-.027.564-.443.986-.121-.235.04-.547.442-.987z"/>
        <path fill="#4FEAD1" d="M384.19 499.179c.212-.003.464.237.679.75-.302.061-.502-.198-.679-.75z"/>
        <path fill="#12CC9B" d="M453.81 451.446a27.94 27.94 0 0 1 6.105 2.004c-1.604-.03-3.28-.403-5.322-.848-.385-.398-.5-.684-.783-1.156z"/>
        <path fill="#F8FEFE" d="M297.03 468.946c7.359-3.09 14.757-6.441 22.497-8.519 12.43-3.336 25.086-5.83 38.053-8.177-.926 1.585-2.106 3.167-3.628 3.633-2.482.76-5.242.58-7.775 1.225-1.242.316-2.24 1.594-3.348 2.436l.879 1.266c6.958-1.293 13.915-2.588 20.874-3.877 1.243-.23 2.52-.725 3.732-.601 4.291.438 8.943 2.44 12.752 1.36 6.268-1.778 11.986-1.448 18.364.304l5.568-.002c5.4-.644 6.652 3.506 7.77 7.22.87 2.882-3.147 4.623-7.347 3.456-2.486-.69-5.044-1.122-7.995-1.67l-2.478.001c-4.38-.34-5.409 2.073-6.324 4.994-4.446-3.776-9.606-5.057-14.44-6.559 11.639-1.14 22.938-2.03 34.475-2.938-16.23-10.532-96.586 3.148-111.357 19.238 4.505-.838 8.915-2.129 13.36-3.28 8.437-2.184 16.893-4.287 25.341-6.424-.296 1.089-.237 2.633-.95 3.188-3.055 2.38-6.248 4.625-9.6 6.557-.818.472-2.472-.305-3.664-.727-2.25-.797-4.444-1.754-7.334-2.914v5.637c-3.942-.848-8.041-3.059-10.014 2.583-.142.404-2.128.412-3.177.203-2.895-.576-5.749-1.364-8.925-2.143v-3.898c4.756-3.114 9.061-5.853 13.246-8.764.585-.407 1.032-1.915.728-2.459-.349-.626-1.627-1.083-2.46-1.024-2.221.16-4.42.635-6.822.675z"/>
        <path fill="#FFF" d="M405.043 457.677c-1.758.318-3.471.319-5.653-.051-1.108-2.787-1.747-5.202-2.386-7.617 1.713-.002 3.426-.005 5.566-.006 1.044 1.086 1.393 2.643 2.325 3.168 2.602 1.466 1.04 2.767.148 4.506z"/>
        <path fill="#FCFFFE" d="M396.54 450.006c1.103 2.418 1.742 4.833 2.421 7.619-5.909-1.381-11.627-1.71-17.895.067-3.809 1.08-8.46-.922-12.752-1.36-1.211-.124-2.489.37-3.732.6-6.959 1.29-13.916 2.585-20.874 3.878l-.879-1.266c1.108-.842 2.106-2.12 3.348-2.436 2.533-.645 5.293-.464 7.775-1.225 1.522-.466 2.702-2.048 4.04-3.537.426-.51.846-.614 1.848-.31 4.949.406 9.314.406 13.873.406 1.441-.946 3.37-2.212 5.55-3.657.418-.302.584-.425 1.11-.385 1.414.195 2.469.228 3.523.26 4.06.448 8.12.896 12.644 1.346z"/>
        <path fill="#12CC9B" d="M381.998 443.002c15.147-.634 30.294-1.309 45.445-1.85 1.901-.068 3.827.565 5.971 1.226-6.424.354-13.078.354-19.731.354l-.087 1.534c3.733.602 7.466 1.204 11.303 2.185-8.257.429-16.616.477-25.441.08-.888-5.242-4.291-3.572-7.02-3.52-3.48.067-6.96 0-10.44-.01M406.72 443l-2.268.896.188.626h5.744l.119-.915c-1.002-.204-2.003-.409-3.783-.607z"/>
        <path fill="#06CE95" d="M381.58 442.95c3.898.061 7.379.128 10.857.061 2.73-.052 6.133-1.722 6.555 3.457-2.043.47-4.087.56-6.844.297-4.52.257-8.328.865-12.135 1.472-.166.123-.332.246-1.141.435-1.718-.02-2.792-.106-3.866-.193l-2.938-2.057c1.381-.86 2.929-1.823 4.68-3.035 1.606-.33 3.01-.41 4.831-.438z"/>
        <path fill="#12CC9B" d="M380.373 448.4a82.028 82.028 0 0 1 11.34-1.703c-2.24.675-4.762 1.07-7.55 1.713-1.321.218-2.376.185-3.79-.01zM439.368 448.029c2.355-2.744 4.92-1.232 7.368.783-.596.65-1.074.774-1.552.9 0 0-.043-.005-.02-.017-1.795-.55-3.61-1.087-5.796-1.666zM434.045 447.177c.124-.143.362-.08.7.2-.114.088-.343.017-.7-.2z"/>
        <path fill="#BEFBF5" d="M430.15 536.763c-.927-6.794-1.53-13.863-2.09-21.365.958 1.328 2.576 3.059 2.657 4.858.241 5.397-.119 10.82-.568 16.507zM440.966 515.653c-1.794-1.31-3.558-2.994-5.657-4.785.86-.316 2.747-1.089 3.12-.63 1.165 1.43 1.755 3.326 2.537 5.415zM434.61 530.206c-.408 2.71-1.079 5.654-2.063 8.783.39-2.727 1.094-5.639 2.062-8.783zM434.676 514.084c.214.07.277.24.27.67-.188-.016-.305-.294-.27-.67z"/>
        <path fill="#F8FEFE" d="M445.131 450.105c.531-.519 1.01-.644 1.682-.923.971.22 1.748.595 3.028 1.046.502.075.917.023.917.023s.09-.04.087.28c.048.52.098.72.149.92-3.607 3.592-4.485 3.451-5.863-1.346z"/>
        <path fill="#12CC9B" d="M451.248 451.36c-.305-.109-.355-.31-.442-.818.286-.195.608-.084 1.057.261-.036.311-.199.388-.615.557zM453.195 451.272c.066-.203.335-.306.627-.2.021.21-.424.3-.627.2z"/>
        <path fill="#FDFEFD" d="M227.051 502.243s.345-.257.904-.28c1.06-.433 1.559-.845 2.059-1.256 0 0 .316-.29.596.08.32.642.36.914.399 1.186l.767 5.198c1.845-.884 3.027-1.956 4.08-1.84 1.704.185 3.324 1.15 4.98 1.786-.992 1.618-1.854 3.336-3.01 4.826-1.117 1.44-3.466 2.533-3.643 3.98-.471 3.83-2.293 5.257-5.888 5.08-4.086-.201-7.856-.093-7.5 5.726.055.898-1.47 1.792-1.787 2.833-.853 2.802-1.593 5.657-2.087 8.541-.274 1.602.038 3.304.078 4.96.192 7.802.381 15.604.286 23.671-.902-.61-1.518-1.484-1.956-2.104-1.921 1.852-3.74 3.605-5.936 5.363-.387-1.06-.397-2.126-.042-3.658 2.092-2.396 2.792-4.164-.4-5.317-1.01-.665-2.018-1.33-3.429-2.42-.36-1.11-.317-1.793.148-2.512 6.76-1.287 6.432-6.756 7.245-11.262.649-3.6-1.313-5.959-4.914-7.193-.34-1.458-.678-2.549-.979-3.993.684-2.115 1.33-3.876 2.334-5.674 4.62-1.22 6.085-4.618 7.374-8.259-1.837-.67-3.293-1.202-4.752-2.086-.39-1.143-.775-1.932-1.161-2.721.03-.428.061-.855.42-1.685.571-.606.717-.864.766-1.178 0 0-.005-.04.38-.023 1.791-.335 3.197-.686 4.765-.721 1.8 2.202 3.438 4.087 5.389 6.334 1.41-.167 3.564-.2 5.574-.753.96-.265 1.647-1.518 2.458-2.323-.955-.436-1.894-1.18-2.87-1.232-1.34-.071-2.708.383-4.723.723 0-2.503 0-4.282.012-6.05.012.01-.01-.013.29-.041.633-.421.967-.813 1.3-1.206-.499-.25-.999-.5-1.52-1.031a13.592 13.592 0 0 0-.112-.84c.364-.336.729-.672 1.694-.993 1.204-.535 1.808-1.086 2.411-1.636z"/>
        <path fill="#13CB9C" d="M336.29 471.892c-8.735 2.277-17.191 4.38-25.627 6.564-4.446 1.151-8.856 2.442-13.361 3.28 14.77-16.09 95.128-29.77 111.357-19.238-11.537.909-22.836 1.799-34.836 2.883-1.408.36-2.114.527-3.266.618-6.173.608-11.943 1.05-17.615 2.047-5.092.895-10.077 2.401-15.108 3.638-.42.022-.839.045-1.544.208z"/>
        <path fill="#F8FEFE" d="M259.214 483.487c3.82-1.68 7.567-2.906 11.204-4.4 7.978-3.278 15.9-6.694 24.216-10.022-1.175 3.292-2.008 7.32-4.464 9.6-2.52 2.336-6.57 3.895-10.054 4.112-4.984.31-9.684-.27-14.273 2.965-3.98 2.806-8.879 4.307-13.175 6.293l.338 5.234c-2.574.084-5.168.395-7.718.183-2.22-.185-4.392-.96-7.022-1.5 5.393-3.315 11.226-6.602 17.052-9.902 1.271-.72 2.517-1.485 3.896-2.563zM299.88 527c-.016.737-.032 1.474-.49 2.707-.764 4.043-.92 7.618-1.483 11.127-.244 1.515-1.33 2.895-2.018 4.326.015-.011-.014-.011-.017-.358-.687-.778-1.372-1.208-2.021-1.714.035-.075.007.09-.042-.18-.35-.447-.652-.625-.884-.821.07-.018-.053.056-.032-.302-.953-1.495-1.926-2.63-2.898-3.774.002-.007-.013-.01-.002-.323-.37-.748-.752-1.185-1.103-1.608.03.015-.03.048.041-.424.389-6.868.706-13.265 1.023-19.661 3.43.34 6.859.68 10.691 1.435.014 3.466-.375 6.518-.764 9.57zM338.082 472.022c4.783-1.575 9.768-3.08 14.86-3.976 5.672-.997 11.442-1.439 17.615-1.726.445.824.444 1.252.443 1.68-5.077 1.034-10.59 1.156-15.125 3.325-6.006 2.874-11.573 2.82-17.793.697zM270.895 540.651c-1.333 5.372-2.508 10.455-3.915 15.474-.482 1.72-1.544 3.277-2.775 4.942-.71-.46-.988-.952-.982-1.975.632-6.028-.387-7.05-6.186-7.02 1.375-1.025 2.787-2.006 4.115-3.09 1.324-1.08 2.83-2.077 3.782-3.442 1.634-2.341 2.897-4.94 4.786-7.264.74.372 1.01.576 1.28.781-.013.427-.026.854-.105 1.594zM275.071 522.127c-.863-3.731-3.124-7.51 3.718-8.636 2.52-.415 4.25-4.797 6.678-6.997 1.02-.925 2.916-.884 4.135-.876-1.07 1.667-1.861 2.927-2.853 4.275-.202.089-.637.162-.992.163-.842.956-1.328 1.91-1.784 2.89.03.027-.05.01-.384.07-.636.797-.937 1.535-1.251 2.18-.012-.093-.035.094-.339.14-.442.409-.58.772-.724 1.286-.007.15-.188.392-.555.44-1.04 1.523-1.715 2.998-2.423 4.609-.034.134-.234.327-.609.332-1.122.044-1.87.084-2.617.124z"/>
        <path fill="#C8FCF6" d="M289.96 515.595c-.323 6.796-.64 13.193-1.233 20.05-.275.46-.66.322-.66.322-.001-.175-.003-.35-.223-1.134-2.115-8.163-1.97-15.599 1.342-22.858l.806.022c-.01 1.066-.018 2.132-.033 3.598z"/>
        <path fill="#FCFFFE" d="M371.165 468.315c-.164-.743-.163-1.171-.162-1.92.706-.487 1.412-.654 2.48-.765 5.535 1.308 10.695 2.589 15.141 6.365-.535 3.227-3.022 2.437-4.015.848-2.924-4.68-6.804-4.372-11.211-3.232-.567.146-1.373-.631-2.233-1.296z"/>
        <path fill="#F8FEFE" d="M319.421 503.002c-1.192-1.238-1.99-2.479-3.104-3.861.027-3.063 1.958-3.766 4.21-2.693 1.387.661 2.287 2.348 3.406 3.574-1.373.993-2.745 1.985-4.512 2.98z"/>
        <path fill="#C8FCF6" d="M300.13 526.746c.14-2.798.529-5.85.935-9.305 1.013-1.078 2.009-1.753 3.303-2.477-1.13 3.809-2.559 7.668-4.238 11.782z"/>
        <path fill="#BEFBF5" d="M257.033 552.305c5.803-.263 6.822.759 6.196 6.496-1.637-1.412-2.998-3.061-4.712-4.739-.648-.218-.944-.407-1.375-.83-.134-.231-.113-.695-.11-.927zM290.267 511.782c-.454.21-.633.206-1.054-.155-.915-.846-1.589-1.334-2.263-1.822.791-1.26 1.582-2.52 2.718-3.849 4.245 1.477.907 3.698.599 5.826zM271.222 539.012c-.492-.16-.762-.364-1.159-.793-.097-.971-.067-1.717.223-3.046 1.342-2.173 2.425-3.762 3.628-5.252.12.099.361.295.315.671-.148 1.378-.25 2.38-.352 3.382 0 0-.286.38-.618.795-.676 1.657-1.021 2.899-1.366 4.14 0 0-.45.058-.671.103z"/>
        <path fill="#F8FEFE" d="M273.793 529.822c-1.082 1.589-2.165 3.178-3.508 4.977-2.832-3.928-.189-5.934 3.346-7.407.295 1.021.229 1.725.162 2.43z"/>
        <path fill="#BEFBF5" d="M273.914 529.92c-.054-.803.012-1.507.072-2.567.325-1.745.657-3.134 1.037-4.874.795-.392 1.543-.432 2.653-.11-.891 2.856-2.146 5.352-3.4 7.847l-.362-.295z"/>
        <path fill="#F8FEFE" d="M368.427 472.517c-1.308 3.763-3.113 2.787-4.971-.564 1.59.096 3.18.192 4.97.564z"/>
        <path fill="#FCFFFE" d="M389.351 471.961c.188-2.887 1.217-5.3 5.264-4.96-1.38 1.64-3.146 3.28-5.264 4.96z"/>
        <path fill="#F8FEFE" d="M307.673 507.14c.32.321.322.781.34 1.586.016.344-.106.795-.498 1.042-1.082.579-1.772.91-2.462 1.243-2.842-3.468 1.373-2.587 2.62-3.871zM316.368 512.96c.389-1.28 1.136-2.6 2.234-3.983-.392 1.273-1.134 2.607-2.234 3.983z"/>
        <path fill="#DAFDF9" d="M231.358 501.938c-.389-.237-.428-.51-.536-1.19.819-1.158 1.707-1.91 2.907-2.652-.466 1.275-1.244 2.54-2.371 3.841z"/>
        <path fill="#C8FCF6" d="M305.032 511.38c.71-.701 1.401-1.033 2.377-1.404-.418 1.21-1.123 2.46-2.133 3.85-.29-.6-.278-1.339-.244-2.446z"/>
        <path fill="#DAFDF9" d="M235.036 497.897c.228-.61.795-1.188 1.683-1.744-.234.606-.789 1.192-1.683 1.744z"/>
        <path fill="#12CC9B" d="M286.749 509.893c.875.4 1.549.888 2.195 1.725-3.07 7.616-3.215 15.052-1.24 22.992-4.86-1.284-2.67-5.806-3.7-9.041-.706-2.216 1.842-5.582-2.67-6.928-.318-.775-.283-1.201-.247-1.627 0 0 .181-.241.443-.507.432-.582.603-.9.773-1.217 0 0 .023-.187.322-.204.633-.72.966-1.425 1.299-2.13 0 0 .079.017.333-.15.788-1.03 1.321-1.89 1.855-2.751 0 0 .435-.073.637-.162zM274.229 530.592c1.301-2.871 2.556-5.367 3.822-8.228.012-.366.212-.559.517-.753.643-.344.982-.493 1.321-.642.314.365.974.903.89 1.07-1.988 4-4.057 7.962-6.507 11.932-.293-1-.191-2.001-.043-3.379z"/>
        <path fill="#C8FCF6" d="M295.873 545.17c.704-1.441 1.79-2.821 2.034-4.336.563-3.51.719-7.084 1.407-10.766.124 5.753-.117 11.64-.896 17.391-1.206-.854-1.875-1.571-2.545-2.288z"/>
        <path fill="#12CC9B" d="M295.889 545.16c.654.728 1.323 1.445 2.16 2.406-5.852-.417-10.822-5.7-10.262-11.37.28-.229.665-.092.87-.08.203.012.263-.021.196.275.333.734.731 1.172 1.13 1.61 0 0 .014.003.028.351.963 1.496 1.912 2.644 2.861 3.791 0 0 .123-.074.115.206.286.462.578.645.871.828 0 0 .028-.164.04.231.666.844 1.322 1.292 1.977 1.74 0 0 .029 0 .014.012zM272.242 538.899c-.004-1.231.34-2.473.946-3.902-.025 1.172-.31 2.531-.946 3.902z"/>
        <path fill="#BEFBF5" d="M279.882 520.663c-.332.455-.67.604-1.28.813.403-1.416 1.077-2.891 2.118-4.414.331.378.296.804.19 1.545-.391.793-.713 1.271-1.028 2.056z"/>
        <path fill="#0BCD99" d="M205.247 556.12a32.455 32.455 0 0 0-.079 2.393c.644 3.764 1.24 7.187 1.898 10.986-2.157 1.622-3.969 2.22-4.128-1.481-.19-4.418-.487-8.84-.979-13.232-.356-3.18-1.108-6.314-1.672-9.47-.115-.645-.41-1.377-.225-1.937 1.36-4.103 2.821-8.173 4.646-11.933.437 1.08.478 1.839.441 2.956-.029 1.087.02 1.816-.066 2.951-.12 5.836-.106 11.266-.157 16.96.063.778.192 1.292.32 1.807z"/>
        <path fill="#10CB9A" d="M160.004 581.005c1.183.197 2.46.208 3.396.778 7.767 4.724 16.121 4.456 24.725 3.485 3.476-.392 7.088.419 10.763 1.046-9.59 2.563-19.32 3.415-29.504.718-.74-.068-1.063-.183-1.781-.6-1.439-.775-2.48-1.245-3.705-1.889-.51-.197-.84-.22-1.356-.474-1.035-1.103-1.881-1.975-2.728-2.847l.19-.217z"/>
        <path fill="#F8FEFE" d="M191.525 590.987c-2.948 3.727-11.243 4.1-16.456.383 5.284-.375 10.637-.378 16.456-.383z"/>
        <path fill="#FFF" d="M208.961 561.432c3.182.74 2.482 2.507.392 4.503-.368-1.318-.375-2.703-.392-4.503z"/>
        <path fill="#10CB9A" d="M203.324 585.75c1.175-.48 2.703-.87 4.453-.986-1.219.542-2.66.81-4.453.986zM202.343 586.3c-.086-.104.04-.193.06-.22.022-.028.229.146.229.146s-.202.177-.289.074z"/>
        <path fill="#F8FEFE" d="M162.73 584.299c.328.023.657.047 1.126.567.124.712.11.928.095 1.144l-10.469 3.671c1.599-2.513 2.788-4.382 4.576-6.298 1.957.274 3.314.595 4.671.916zM148.992 582.693c-.645-.904-.955-1.808-1.266-2.712l2.53-.003c-.31.905-.62 1.81-1.264 2.715z"/>
        <path fill="#DAFDF9" d="M162.542 584.069c-1.17-.091-2.527-.412-4.22-.9-.342-.59-.349-1.013-.358-1.752.41-.299.82-.281 1.541-.23 1.156.907 2.002 1.78 3.037 2.882zM164.216 586.284c-.25-.49-.236-.706-.179-1.245 1.085.148 2.127.618 3.308 1.418-.863.253-1.863.177-3.129-.173z"/>
        <path fill="#00B581" d="M556.164 269.08c-.251-.556-.138-.917.031-1.557.794-.576 1.532-.872 2.822-1.39 0 75.818 0 151.351-.075 227.342-.368-1.455-.919-3.369-.92-5.282-.045-70.801-.026-141.602-.1-212.403-.003-2.172-.908-4.343-1.758-6.71z"/>
        <path fill="#09CC94" d="M479.886 306.354c1.693-.194 3.091-.194 4.875-.194-3.21 3.59-3.3 3.59-4.875.194z"/>
        <path fill="#0DCE98" d="M223.072 362.474c4.358-2.033 8.79-3.72 13.56-5.57-.586 5.788-2.05 6.924-7.702 6.26-1.915-.224-3.856-.235-5.858-.69z"/>
        <path fill="#DAFDF9" d="M205.227 534.043c-.04-.758-.082-1.517-.164-2.655.125-.777.292-1.175.53-1.889.631-1.949 1.19-3.581 2.318-5.166.74 1.255.914 2.46 1.088 3.667-.647 1.762-1.293 3.523-2.27 5.646-.72.373-1.11.385-1.502.397z"/>
        <path fill="#0DCE98" d="M233.085 409.069c.08.511-.132 1.09-.617 1.83-.073-.478.126-1.12.617-1.83z"/>
        <path fill="#12CC9B" d="M223.732 358.066c-.12.369-.57.752-1.318 1.226.131-.343.559-.777 1.318-1.226z"/>
        <path fill="#0BCD99" d="M208.468 505.45c.055-.032-.054.033 0 0z"/>
        <path fill="#0BCD98" d="M464.032 208.888c.058.334.042.74.055.944-.506.5-1.025.795-2.053 1.229-.818.307-1 .566-1.057.913 0 0 .02.027-.325.097-2.363 1.828-4.38 3.585-6.398 5.341l.686 1.235 7.198-3.563c1.486-.438 2.972-.876 5.029-1.574.98-.325 1.39-.389 1.8-.453-.109.815.039 2.168-.366 2.361-5.406 2.575-10.874 5.024-16.424 7.265-.164.066-2.065-2.551-1.931-3.784.157-1.45 1.418-3.026 2.615-4.07 2.838-2.478 5.884-4.727 8.955-6.915.376-.268 1.422.405 2.216.974z"/>
        <path fill="#B3FBF5" d="M469.044 212.826c-.487.295-.897.359-1.619.473.18-.377.672-.806 1.524-1.194.36.04.17.49.095.72z"/>
        <path fill="#9AF9F1" d="M521.731 211.122c.067.417-.114 1.007-.6 1.707-.086-.438.133-.986.6-1.707z"/>
        <path fill="#B3FBF5" d="M471.28 211.946c.154-.343.595-.665 1.324-.993-.154.333-.596.673-1.324.993z"/>
        <path fill="#49E0C5" d="M232.88 250.746c-.186.263-.492.192-.934-.183.15-.122.467-.071.934.183z"/>
        <path fill="#11CD9B" d="M286.849 302.161c.102.222-.045.547-.454.955-.106-.228.05-.54.454-.955zM287.717 301.13c.078.175-.058.466-.424.86-.2-.238-.053-.521.424-.86z"/>
        <path fill="#CFFCF8" d="M316.771 280.492c.192.165.162.359.05.838-.226.051-.404-.171-.497-.425-.033-.089.144-.255.447-.413z"/>
        <path fill="#64F6DC" d="m290.886 378.11-4.533-3.492 1.072-1.292c1.109.973 2.218 1.945 3.447 3.515.085.821.05 1.045.014 1.268z"/>
        <path fill="#CCFDF9" d="M291.015 378.238c-.094-.352-.058-.576.017-1.137.376-.221.714-.105 1.237.206.023.375-.139.555-.559.994-.258.259-.566.065-.695-.063z"/>
        <path fill="#0BC897" d="M448.066 421.49c.823-.725 1.592-1.015 2.659-1.392.349 6.622.4 13.333.36 20.47-1.494.1-2.898-.229-4.667-.563.288-6.03.94-12.055 1.648-18.515zM464.486 442.915c-.402-1.958-.44-4.005-.415-6.487 3.112 1.548 2.43 3.922.415 6.487zM454.08 444.527c2.68.153 5.439.655 8.593 1.207-2.847 2.428-5.722 1.198-8.592-1.207z"/>
        <path fill="#12CC9B" d="M435.07 442.937c1.914-.265 4.052-.187 6.564-.031-1.864.176-4.102.275-6.564.03zM450.768 450.053c-.01.198-.425.25-.597.132.087-.189.347-.26.597-.132z"/>
        <path fill="#F8FEFE" d="M209.356 527.964c-.53-1.17-.704-2.376-1.167-3.812-.276-.654-.264-1.08.205-1.827 1.5-1.666 2.544-3.01 3.587-4.353l4.75 1.733c-1.29 3.641-2.754 7.04-7.375 8.26z"/>
        <path fill="#01BB90" d="M249.261 457.177c.374-4.238 1.02-8.246 1.668-12.253l1.343.039c0 5.042 0 10.084-.064 15.592-.934-.738-1.804-1.943-2.947-3.378z"/>
        <path fill="#DAFDF9" d="M211.978 517.619c-1.04 1.696-2.083 3.04-3.486 4.4.326-2.249 1.013-4.515 2.012-6.951.699.619 1.085 1.408 1.474 2.55zM222.604 504.91c.372.148.403.334.421 1.132-.023 1.053-.035 1.494-.047 1.935 0 0 .022.023-.361.056-2.07.403-3.757.774-5.54 1.043l-.282-.304c1.823-1.274 3.645-2.548 5.809-3.861zM216.987 510.974c-1.407.352-2.813.703-4.585 1.045 1-1.048 2.366-2.085 4.063-3.185.33-.062.518.142.552.537.013.798-.009 1.2-.03 1.603zM226.734 502.225c-.286.568-.89 1.119-1.84 1.625.276-.578.899-1.11 1.84-1.625zM229.666 500.67c-.152.448-.652.86-1.499 1.26.153-.44.652-.868 1.5-1.26zM211.748 512.09c.206.26.06.517-.385.826-.09-.187.02-.479.385-.825z"/>
        <path fill="#F8FEFE" d="M374.62 448.652c1.46-.086 2.534 0 4 .2-1.538 1.378-3.466 2.644-4.907 3.59-4.559 0-8.924 0-13.554-.326 4.516-1.315 9.296-2.303 14.461-3.464z"/>
        <path fill="#FCFFFE" d="M497.595 422.52c.465.057.748.287 1.03.518l-.559.536c-.217-.293-.435-.586-.471-1.053z"/>
        <path fill="#22C9A4" d="M424.1 271.386c.66.049 1.36.45 2.224 1.124-.618-.075-1.4-.423-2.224-1.124zM428.2 273.347c.356-.078.866.07 1.53.445-.357.078-.866-.071-1.53-.445zM430.199 274.318c.421-.138 1.025-.032 1.78.35-.432.148-1.015.021-1.78-.35zM427.95 281.036c.063.007.165-.026.113-.009-.153.052-.075-.032-.113.01zM440.15 277.5c.217-.313.483-.243.744.265-.216.192-.445.084-.744-.265z"/>
        <path fill="#FCFFFE" d="M278.032 145.335c9.636-2.436 18.627-7.854 29.432-5.971-3.838 1.84-8.07 3.309-12.3 4.777 1.491 1.376 3.091 1.45 4.573 1.906 1.485.457 2.851 1.297 4.27 1.969-8.381 1.665-16.762 3.33-25.575 4.993-.407-2.433-.382-4.864-.4-7.674zM364.195 138.296c1.272-1.003 2.781-1.745 4.566-2.379-.167 2.939-1.816 3.575-4.566 2.38zM357.37 138.998c.39-3.064 1.818-4.197 4.57-1.338-1.36.68-2.781 1.008-4.57 1.338z"/>
        <path fill="#FEFEFF" d="M304.417 147.963c-1.829-.62-3.195-1.459-4.68-1.916-1.482-.456-3.082-.53-4.573-1.906 4.23-1.468 8.462-2.937 12.764-4.775.514-.374.955-.378 1.728-.386 3.302 2.112 6.273 4.228 9.295 6.689-4.673.978-9.398 1.61-14.534 2.294z"/>
        <path fill="#FEFDFE" d="M148.304 187.999c-4.771-3.24-4.397-9.846.36-12.98 1.225-.807 2.217-1.968 3.738-3.349 1.932 1.078 6.895-1.444 6.602 4.942-.024.802-.051 1.2-.147 1.885-2.031 2.047-3.994 3.805-6.04 5.902-1.021 1.128-1.96 1.916-2.976 3.039-.464.405-.852.477-1.537.56zM136.145 184.298c.16-.41.408-.594.7-1.066 1.202.579 2.305 1.37 3.409 2.161l-1.011 1.492c-.984-.762-1.967-1.524-3.098-2.587z"/>
        <path fill="#B3FBF5" d="M461.85 214.88c-2.111 1.392-4.51 2.58-6.91 3.767l-.686-1.235c2.017-1.756 4.035-3.513 6.385-5.352.53.817.727 1.717 1.211 2.82zM461.197 211.919c-.163-.292.02-.55.572-.72.128.295-.07.516-.572.72z"/>
        <path fill="#06CE95" d="M407.11 442.996c1.39.201 2.392.406 3.394.61l-.119.915h-5.744l-.188-.626c.756-.3 1.512-.598 2.657-.9z"/>
        <path fill="#F8FEFE" d="M205.67 556.086c-.552-.48-.68-.995-.353-1.87 1.193-5.642 1.929-10.922 2.67-16.207l.015-.011c3.6.867 5.562 3.226 4.913 6.826-.813 4.506-.486 9.975-7.245 11.262zM217.148 511.29c-.14-.718-.118-1.121-.036-1.818 1.748-.665 3.435-1.036 5.493-1.45.371 1.736.371 3.515.371 6.018 2.015-.34 3.383-.794 4.723-.723.976.052 1.915.796 2.87 1.232-.81.805-1.498 2.058-2.458 2.323-2.01.553-4.163.586-5.574.753-1.951-2.247-3.589-4.132-5.389-6.334zM205.15 534.402c.468-.371.859-.383 1.542-.403.631 1.083.97 2.174 1.31 3.632 0 .367-.01.374-.29.261a367.81 367.81 0 0 0-2.493-.945c-.05-.729-.099-1.458-.07-2.545zM223.277 507.949c-.287-.413-.275-.854-.23-1.625.532-.08 1.032.17 1.532.42-.334.392-.668.784-1.302 1.205z"/>
        <path fill="#C8FCF6" d="M292.893 541.785c-.97-.79-1.92-1.937-2.884-3.425.958.795 1.931 1.93 2.884 3.425zM295.872 544.802c-.652-.102-1.308-.55-2.01-1.318.638.11 1.323.54 2.01 1.318zM289.993 537.688c-.409-.125-.807-.563-1.17-1.311.418.126.8.563 1.17 1.311zM293.81 542.908c-.245.086-.537-.097-.892-.542.24-.083.54.095.891.542z"/>
        <path fill="#BEFBF5" d="M285.757 510.056c-.179.86-.712 1.72-1.53 2.723.202-.813.688-1.767 1.53-2.723zM283.589 513.016c.002.645-.331 1.35-.951 2.163.014-.628.315-1.366.95-2.163zM282 515.336c.133.271-.038.589-.464 1.02-.117-.248.02-.611.463-1.02z"/>
        <path fill="#DAFDF9" d="M205.083 537.353c.873-.129 1.61.149 2.624.543-.461 5.398-1.197 10.678-2.324 16.056-.406-5.333-.42-10.763-.3-16.599z"/>
    </svg>
    );
