"""FMP Literal Definitions."""

# pylint: disable=too-many-lines

from typing import Literal

Sectors = Literal[
    "consumer_cyclical",
    "energy",
    "technology",
    "industrials",
    "financial_services",
    "basic_materials",
    "communication_services",
    "consumer_defensive",
    "healthcare",
    "real_estate",
    "utilities",
    "industrial_goods",
    "financial",
    "services",
]

SECTORS = [
    "consumer_cyclical",
    "energy",
    "technology",
    "industrials",
    "financial_services",
    "basic_materials",
    "communication_services",
    "consumer_defensive",
    "healthcare",
    "real_estate",
    "utilities",
    "industrial_goods",
    "financial",
    "services",
]

EXCHANGES = [
    "amex",
    "ams",
    "ase",
    "asx",
    "ath",
    "bme",
    "bru",
    "bud",
    "bue",
    "cai",
    "cnq",
    "cph",
    "dfm",
    "doh",
    "etf",
    "euronext",
    "hel",
    "hkse",
    "ice",
    "iob",
    "ist",
    "jkt",
    "jnb",
    "jpx",
    "kls",
    "koe",
    "ksc",
    "kuw",
    "lse",
    "mex",
    "nasdaq",
    "neo",
    "nse",
    "nyse",
    "nze",
    "osl",
    "otc",
    "pnk",
    "pra",
    "ris",
    "sao",
    "sau",
    "set",
    "sgo",
    "shh",
    "shz",
    "six",
    "sto",
    "tai",
    "tlv",
    "tsx",
    "two",
    "vie",
    "wse",
    "xetra",
]

Exchanges = Literal[
    "amex",
    "ams",
    "ase",
    "asx",
    "ath",
    "bme",
    "bru",
    "bud",
    "bue",
    "cai",
    "cnq",
    "cph",
    "dfm",
    "doh",
    "etf",
    "euronext",
    "hel",
    "hkse",
    "ice",
    "iob",
    "ist",
    "jkt",
    "jnb",
    "jpx",
    "kls",
    "koe",
    "ksc",
    "kuw",
    "lse",
    "mex",
    "nasdaq",
    "neo",
    "nse",
    "nyse",
    "nze",
    "osl",
    "otc",
    "pnk",
    "pra",
    "ris",
    "sao",
    "sau",
    "set",
    "sgo",
    "shh",
    "shz",
    "six",
    "sto",
    "tai",
    "tlv",
    "tsx",
    "two",
    "vie",
    "wse",
    "xetra",
]

MARKETS = Literal[
    "amex",
    "ams",
    "ase",
    "asx",
    "ath",
    "bme",
    "bru",
    "bud",
    "bue",
    "cai",
    "cnq",
    "commodity",
    "cph",
    "crypto",
    "dfm",
    "doh",
    "dus",
    "etf",
    "euronext",
    "forex",
    "hel",
    "hkse",
    "ice",
    "iob",
    "index",
    "ist",
    "jkt",
    "jnb",
    "jpx",
    "kls",
    "koe",
    "ksc",
    "kuw",
    "lse",
    "mex",
    "mil",
    "mutual_fund",
    "nasdaq",
    "neo",
    "nse",
    "nyse",
    "nze",
    "osl",
    "otc",
    "pnk",
    "pra",
    "ris",
    "sao",
    "sau",
    "ses",
    "set",
    "sgo",
    "shh",
    "shz",
    "six",
    "sto",
    "tai",
    "tlv",
    "tsx",
    "two",
    "vie",
    "wse",
    "xetra",
]

TRANSACTION_TYPES = Literal[
    "award",
    "conversion",
    "return",
    "expire_short",
    "in_kind",
    "gift",
    "expire_long",
    "discretionary",
    "other",
    "small",
    "exempt",
    "otm",
    "purchase",
    "sale",
    "tender",
    "will",
    "itm",
    "trust",
]

TRANSACTION_TYPES_DICT = {
    "award": "A-Award",
    "conversion": "C-Conversion",
    "return": "D-Return",
    "expire_short": "E-ExpireShort",
    "in_kind": "F-InKind",
    "gift": "G-Gift",
    "expire_long": "H-ExpireLong",
    "discretionary": "I-Discretionary",
    "other": "J-Other",
    "small": "L-Small",
    "exempt": "M-Exempt",
    "otm": "O-OutOfTheMoney",
    "purchase": "P-Purchase",
    "sale": "S-Sale",
    "tender": "U-Tender",
    "will": "W-Will",
    "itm": "X-InTheMoney",
    "trust": "Z-Trust",
}

FinancialPeriods = Literal[
    "q1",
    "q2",
    "q3",
    "q4",
    "fy",
    "annual",
    "quarter",
]

FinancialStatementPeriods = Literal[
    "q1",
    "q2",
    "q3",
    "q4",
    "fy",
    "ttm",
    "annual",
    "quarter",
]

IndustryChoices = [
    {"label": "Advertising Agencies", "value": "advertising_agencies"},
    {"label": "Aerospace & Defense", "value": "aerospace_defense"},
    {
        "label": "Agricultural - Commodities/Milling",
        "value": "agricultural_commodities_milling",
    },
    {"label": "Agricultural Farm Products", "value": "agricultural_farm_products"},
    {"label": "Agricultural Inputs", "value": "agricultural_inputs"},
    {"label": "Agricultural - Machinery", "value": "agricultural_machinery"},
    {
        "label": "Airlines, Airports & Air Services",
        "value": "airlines_airports_air_services",
    },
    {"label": "Aluminum", "value": "aluminum"},
    {
        "label": "Apparel - Footwear & Accessories",
        "value": "apparel_footwear_accessories",
    },
    {"label": "Apparel - Manufacturers", "value": "apparel_manufacturers"},
    {"label": "Apparel - Retail", "value": "apparel_retail"},
    {"label": "Asset Management", "value": "asset_management"},
    {"label": "Asset Management - Bonds", "value": "asset_management_bonds"},
    {
        "label": "Asset Management - Cryptocurrency",
        "value": "asset_management_cryptocurrency",
    },
    {"label": "Asset Management - Global", "value": "asset_management_global"},
    {"label": "Asset Management - Income", "value": "asset_management_income"},
    {"label": "Asset Management - Leveraged", "value": "asset_management_leveraged"},
    {"label": "Auto - Dealerships", "value": "auto_dealerships"},
    {"label": "Auto - Manufacturers", "value": "auto_manufacturers"},
    {"label": "Auto - Parts", "value": "auto_parts"},
    {"label": "Auto - Recreational Vehicles", "value": "auto_recreational_vehicles"},
    {"label": "Banks", "value": "banks"},
    {"label": "Banks - Diversified", "value": "banks_diversified"},
    {"label": "Banks - Regional", "value": "banks_regional"},
    {"label": "Beverages - Alcoholic", "value": "beverages_alcoholic"},
    {"label": "Beverages - Non-Alcoholic", "value": "beverages_non-alcoholic"},
    {
        "label": "Beverages - Wineries & Distilleries",
        "value": "beverages_wineries_distilleries",
    },
    {"label": "Biotechnology", "value": "biotechnology"},
    {"label": "Broadcasting", "value": "broadcasting"},
    {"label": "Business Equipment & Supplies", "value": "business_equipment_supplies"},
    {"label": "Chemicals", "value": "chemicals"},
    {"label": "Chemicals - Specialty", "value": "chemicals_specialty"},
    {"label": "Coal", "value": "coal"},
    {"label": "Communication Equipment", "value": "communication_equipment"},
    {"label": "Computer Hardware", "value": "computer_hardware"},
    {"label": "Conglomerates", "value": "conglomerates"},
    {"label": "Construction", "value": "construction"},
    {"label": "Construction Materials", "value": "construction_materials"},
    {"label": "Consulting Services", "value": "consulting_services"},
    {"label": "Consumer Electronics", "value": "consumer_electronics"},
    {"label": "Copper", "value": "copper"},
    {"label": "Department Stores", "value": "department_stores"},
    {"label": "Discount Stores", "value": "discount_stores"},
    {"label": "Diversified Utilities", "value": "diversified_utilities"},
    {"label": "Drug Manufacturers - General", "value": "drug_manufacturers_general"},
    {
        "label": "Drug Manufacturers - Specialty & Generic",
        "value": "drug_manufacturers_specialty_generic",
    },
    {"label": "Education & Training Services", "value": "education_training_services"},
    {"label": "Electrical Equipment & Parts", "value": "electrical_equipment_parts"},
    {
        "label": "Electronic Gaming & Multimedia",
        "value": "electronic_gaming_multimedia",
    },
    {"label": "Engineering & Construction", "value": "engineering_construction"},
    {"label": "Entertainment", "value": "entertainment"},
    {"label": "Environmental Services", "value": "environmental_services"},
    {"label": "Financial - Capital Markets", "value": "financial_capital_markets"},
    {"label": "Financial - Conglomerates", "value": "financial_conglomerates"},
    {"label": "Financial - Credit Services", "value": "financial_credit_services"},
    {
        "label": "Financial - Data & Stock Exchanges",
        "value": "financial_data_stock_exchanges",
    },
    {"label": "Financial - Diversified", "value": "financial_diversified"},
    {"label": "Financial - Mortgages", "value": "financial_mortgages"},
    {"label": "Food Confectioners", "value": "food_confectioners"},
    {"label": "Food Distribution", "value": "food_distribution"},
    {
        "label": "Furnishings, Fixtures & Appliances",
        "value": "furnishings_fixtures_appliances",
    },
    {"label": "Gambling, Resorts & Casinos", "value": "gambling_resorts_casinos"},
    {"label": "General Transportation", "value": "general_transportation"},
    {"label": "General Utilities", "value": "general_utilities"},
    {"label": "Gold", "value": "gold"},
    {"label": "Grocery Stores", "value": "grocery_stores"},
    {"label": "Hardware, Equipment & Parts", "value": "hardware_equipment_parts"},
    {"label": "Home Improvement", "value": "home_improvement"},
    {"label": "Household & Personal Products", "value": "household_personal_products"},
    {"label": "Independent Power Producers", "value": "independent_power_producers"},
    {"label": "Industrial - Capital Goods", "value": "industrial_capital_goods"},
    {"label": "Industrial - Distribution", "value": "industrial_distribution"},
    {
        "label": "Industrial - Infrastructure Operations",
        "value": "industrial_infrastructure_operations",
    },
    {"label": "Industrial - Machinery", "value": "industrial_machinery"},
    {"label": "Industrial Materials", "value": "industrial_materials"},
    {
        "label": "Industrial - Pollution & Treatment Controls",
        "value": "industrial_pollution_treatment_controls",
    },
    {"label": "Industrial - Specialties", "value": "industrial_specialties"},
    {
        "label": "Information Technology Services",
        "value": "information_technology_services",
    },
    {"label": "Insurance - Brokers", "value": "insurance_brokers"},
    {"label": "Insurance - Diversified", "value": "insurance_diversified"},
    {"label": "Insurance - Life", "value": "insurance_life"},
    {
        "label": "Insurance - Property & Casualty",
        "value": "insurance_property_casualty",
    },
    {"label": "Insurance - Reinsurance", "value": "insurance_reinsurance"},
    {"label": "Insurance - Specialty", "value": "insurance_specialty"},
    {
        "label": "Integrated Freight & Logistics",
        "value": "integrated_freight_logistics",
    },
    {
        "label": "Internet Content & Information",
        "value": "internet_content_information",
    },
    {
        "label": "Investment - Banking & Investment Services",
        "value": "investment_banking_investment_services",
    },
    {"label": "Leisure", "value": "leisure"},
    {"label": "Luxury Goods", "value": "luxury_goods"},
    {
        "label": "Manufacturing - Metal Fabrication",
        "value": "manufacturing_metal_fabrication",
    },
    {"label": "Manufacturing - Miscellaneous", "value": "manufacturing_miscellaneous"},
    {"label": "Manufacturing - Textiles", "value": "manufacturing_textiles"},
    {
        "label": "Manufacturing - Tools & Accessories",
        "value": "manufacturing_tools_accessories",
    },
    {"label": "Marine Shipping", "value": "marine_shipping"},
    {"label": "Media & Entertainment", "value": "media_entertainment"},
    {"label": "Medical - Care Facilities", "value": "medical_care_facilities"},
    {"label": "Medical - Devices", "value": "medical_devices"},
    {
        "label": "Medical - Diagnostics & Research",
        "value": "medical_diagnostics_research",
    },
    {"label": "Medical - Distribution", "value": "medical_distribution"},
    {"label": "Medical - Equipment & Services", "value": "medical_equipment_services"},
    {
        "label": "Medical - Healthcare Information Services",
        "value": "medical_healthcare_information_services",
    },
    {"label": "Medical - Healthcare Plans", "value": "medical_healthcare_plans"},
    {
        "label": "Medical - Instruments & Supplies",
        "value": "medical_instruments_supplies",
    },
    {"label": "Medical - Pharmaceuticals", "value": "medical_pharmaceuticals"},
    {"label": "Medical - Specialties", "value": "medical_specialties"},
    {"label": "Oil & Gas Drilling", "value": "oil_gas_drilling"},
    {"label": "Oil & Gas Energy", "value": "oil_gas_energy"},
    {"label": "Oil & Gas Equipment & Services", "value": "oil_gas_equipment_services"},
    {
        "label": "Oil & Gas Exploration & Production",
        "value": "oil_gas_exploration_production",
    },
    {"label": "Oil & Gas Integrated", "value": "oil_gas_integrated"},
    {"label": "Oil & Gas Midstream", "value": "oil_gas_midstream"},
    {"label": "Oil & Gas Refining & Marketing", "value": "oil_gas_refining_marketing"},
    {"label": "Other Precious Metals", "value": "other_precious_metals"},
    {"label": "Packaged Foods", "value": "packaged_foods"},
    {"label": "Packaging & Containers", "value": "packaging_containers"},
    {
        "label": "Paper, Lumber & Forest Products",
        "value": "paper_lumber_forest_products",
    },
    {"label": "Personal Products & Services", "value": "personal_products_services"},
    {"label": "Publishing", "value": "publishing"},
    {"label": "Railroads", "value": "railroads"},
    {"label": "Real Estate - Development", "value": "real_estate_development"},
    {"label": "Real Estate - Diversified", "value": "real_estate_diversified"},
    {"label": "Real Estate - General", "value": "real_estate_general"},
    {"label": "Real Estate - Services", "value": "real_estate_services"},
    {"label": "Regulated Electric", "value": "regulated_electric"},
    {"label": "Regulated Gas", "value": "regulated_gas"},
    {"label": "Regulated Water", "value": "regulated_water"},
    {"label": "REIT - Diversified", "value": "reit_diversified"},
    {"label": "REIT - Healthcare Facilities", "value": "reit_healthcare_facilities"},
    {"label": "REIT - Hotel & Motel", "value": "reit_hotel_motel"},
    {"label": "REIT - Industrial", "value": "reit_industrial"},
    {"label": "REIT - Mortgage", "value": "reit_mortgage"},
    {"label": "REIT - Office", "value": "reit_office"},
    {"label": "REIT - Residential", "value": "reit_residential"},
    {"label": "REIT - Retail", "value": "reit_retail"},
    {"label": "REIT - Specialty", "value": "reit_specialty"},
    {"label": "Renewable Utilities", "value": "renewable_utilities"},
    {"label": "Rental & Leasing Services", "value": "rental_leasing_services"},
    {"label": "Residential Construction", "value": "residential_construction"},
    {"label": "Restaurants", "value": "restaurants"},
    {
        "label": "Security & Protection Services",
        "value": "security_protection_services",
    },
    {"label": "Semiconductors", "value": "semiconductors"},
    {"label": "Shell Companies", "value": "shell_companies"},
    {"label": "Silver", "value": "silver"},
    {"label": "Software - Application", "value": "software_application"},
    {"label": "Software - Infrastructure", "value": "software_infrastructure"},
    {"label": "Software - Services", "value": "software_services"},
    {"label": "Solar", "value": "solar"},
    {"label": "Specialty Business Services", "value": "specialty_business_services"},
    {"label": "Specialty Retail", "value": "specialty_retail"},
    {
        "label": "Staffing & Employment Services",
        "value": "staffing_employment_services",
    },
    {"label": "Steel", "value": "steel"},
    {"label": "Technology Distributors", "value": "technology_distributors"},
    {"label": "Telecommunications Services", "value": "telecommunications_services"},
    {"label": "Tobacco", "value": "tobacco"},
    {"label": "Travel Lodging", "value": "travel_lodging"},
    {"label": "Travel Services", "value": "travel_services"},
    {"label": "Trucking", "value": "trucking"},
    {"label": "Uranium", "value": "uranium"},
    {"label": "Waste Management", "value": "waste_management"},
]

Countries = Literal[
    "ae",
    "ai",
    "ar",
    "at",
    "au",
    "ax",
    "az",
    "bb",
    "bd",
    "be",
    "bg",
    "bh",
    "bm",
    "br",
    "bs",
    "bw",
    "ca",
    "ch",
    "ci",
    "ck",
    "cl",
    "cn",
    "co",
    "cr",
    "cw",
    "cy",
    "cz",
    "de",
    "dk",
    "do",
    "ee",
    "eg",
    "es",
    "fi",
    "fk",
    "fr",
    "ga",
    "gb",
    "ge",
    "gf",
    "gg",
    "gi",
    "gl",
    "gr",
    "hk",
    "hu",
    "id",
    "ie",
    "il",
    "im",
    "in",
    "is",
    "it",
    "je",
    "jo",
    "jp",
    "ke",
    "kg",
    "kh",
    "kr",
    "kw",
    "ky",
    "kz",
    "li",
    "lt",
    "lu",
    "lv",
    "ma",
    "mc",
    "me",
    "mk",
    "mm",
    "mn",
    "mo",
    "mq",
    "mt",
    "mu",
    "mx",
    "my",
    "mz",
    "na",
    "ng",
    "nl",
    "no",
    "nz",
    "pa",
    "pe",
    "pg",
    "ph",
    "pk",
    "pl",
    "pr",
    "pt",
    "qa",
    "re",
    "ro",
    "ru",
    "sa",
    "se",
    "sg",
    "si",
    "sk",
    "sn",
    "sr",
    "tc",
    "th",
    "tr",
    "tw",
    "tz",
    "ua",
    "uk",
    "us",
    "uy",
    "vg",
    "vn",
    "za",
    "zm",
]

AvailableExchanges = {
    "AMEX": {
        "name": "New York Stock Exchange Arca",
        "timezone": "America/New_York",
        "session": "0930-1600",
        "delay": "Real-time",
        "symbol_suffix": None,
        "country_name": "United States of America",
        "country_code": "US",
    },
    "AMS": {
        "name": "Euronext Amsterdam",
        "timezone": "Europe/Amsterdam",
        "session": "0900-1730",
        "delay": "Real-time",
        "symbol_suffix": ".AS",
        "country_name": "Netherlands",
        "country_code": "NL",
    },
    "AQS": {
        "name": "Aquis Stock Exchange",
        "timezone": "Europe/London",
        "session": "0800-1630",
        "delay": None,
        "symbol_suffix": ".AQ",
        "country_name": "United Kingdom",
        "country_code": "UK",
    },
    "ASE": {
        "name": "American Stock Exchange",
        "timezone": "America/New_York",
        "session": "0930-1600",
        "delay": None,
        "symbol_suffix": None,
        "country_name": "United States of America",
        "country_code": "US",
    },
    "ASX": {
        "name": "Australian Securities Exchange",
        "timezone": "Australia/Sydney",
        "session": "1000-1600",
        "delay": "20 min",
        "symbol_suffix": ".AX",
        "country_name": "Australia",
        "country_code": "AU",
    },
    "ATH": {
        "name": "Athens Stock Exchange",
        "timezone": "Europe/Athens",
        "session": "1015-1720",
        "delay": "15 min",
        "symbol_suffix": ".AT",
        "country_name": "Greece",
        "country_code": "GR",
    },
    "BER": {
        "name": "Berlin Stock Exchange",
        "timezone": "Europe/Berlin",
        "session": "0800-2200",
        "delay": "15 min",
        "symbol_suffix": ".BE",
        "country_name": "Germany",
        "country_code": "DE",
    },
    "BME": {
        "name": "Madrid Stock Exchange",
        "timezone": "Europe/Madrid",
        "session": "0900-1730",
        "delay": "15 min",
        "symbol_suffix": ".MC",
        "country_name": "Spain",
        "country_code": "ES",
    },
    "BRU": {
        "name": "Euronext Brussels",
        "timezone": "Europe/Brussels",
        "session": "0900-1730",
        "delay": "15 min",
        "symbol_suffix": ".BR",
        "country_name": "Belgium",
        "country_code": "BE",
    },
    "BSE": {
        "name": "Bombay Stock Exchange",
        "timezone": "Asia/Kolkata",
        "session": "0915-1530",
        "delay": "15 min",
        "symbol_suffix": ".BO",
        "country_name": "India",
        "country_code": "IN",
    },
    "BUD": {
        "name": "Budapest Stock Exchange",
        "timezone": "Europe/Budapest",
        "session": "0900-1700",
        "delay": "15 min",
        "symbol_suffix": ".BD",
        "country_name": "Hungary",
        "country_code": "HU",
    },
    "BUE": {
        "name": "Buenos Aires Stock Exchange",
        "timezone": "America/Argentina/Buenos_Aires",
        "session": "1100-1700",
        "delay": "20 min",
        "symbol_suffix": ".BA",
        "country_name": "Argentina",
        "country_code": "AR",
    },
    "BVC": {
        "name": "Colombia Stock Exchange",
        "timezone": "America/Bogota",
        "session": "0930-1600",
        "delay": "15 min",
        "symbol_suffix": ".CL",
        "country_name": "Colombia",
        "country_code": "CO",
    },
    "CAI": {
        "name": "Egyptian Exchange",
        "timezone": "Africa/Cairo",
        "session": "1000-1415",
        "delay": "15 min",
        "symbol_suffix": ".CA",
        "country_name": "Egypt",
        "country_code": "EG",
    },
    "CBOE": {
        "name": "Chicago Board Options Exchange",
        "timezone": "America/New_York",
        "session": "0930-1600",
        "delay": "Real-time",
        "symbol_suffix": None,
        "country_name": "United States of America",
        "country_code": "US",
    },
    "CNQ": {
        "name": "Canadian Securities Exchange",
        "timezone": "America/Toronto",
        "session": "0930-1600",
        "delay": "Real-time",
        "symbol_suffix": ".CN",
        "country_name": "Canada",
        "country_code": "CA",
    },
    "CPH": {
        "name": "NASDAQ Copenhagen",
        "timezone": "Europe/Copenhagen",
        "session": "0900-1700",
        "delay": "Real-time",
        "symbol_suffix": ".CO",
        "country_name": "Denmark",
        "country_code": "DK",
    },
    "DFM": {
        "name": "Dubai Financial Market",
        "timezone": "Asia/Dubai",
        "session": "1000-1445",
        "delay": "15 min",
        "symbol_suffix": ".AE",
        "country_name": "United Arab Emirates",
        "country_code": "AE",
    },
    "DOH": {
        "name": "Qatar Stock Exchange",
        "timezone": "Asia/Qatar",
        "session": "0930-1315",
        "delay": "15 min",
        "symbol_suffix": ".QA",
        "country_name": "Qatar",
        "country_code": "QA",
    },
    "DUB": {
        "name": "Euronext Dublin",
        "timezone": "Europe/Dublin",
        "session": "0800-1630",
        "delay": None,
        "symbol_suffix": ".IR",
        "country_name": "Ireland",
        "country_code": "IE",
    },
    "DUS": {
        "name": "Dusseldorf Stock Exchange",
        "timezone": "Europe/Berlin",
        "session": "0800-2200",
        "delay": "15 min",
        "symbol_suffix": ".DU",
        "country_name": "Germany",
        "country_code": "DE",
    },
    "DXE": {
        "name": "CBOE Europe",
        "timezone": "Europe/London",
        "session": "0800-1630",
        "delay": None,
        "symbol_suffix": ".XD",
        "country_name": "United Kingdom",
        "country_code": "UK",
    },
    "ETF": {
        "name": "Chicago Board Options Exchange",
        "timezone": "America/New_York",
        "session": "0930-1600",
        "delay": "Real-time",
        "symbol_suffix": None,
        "country_name": "United States of America",
        "country_code": "US",
    },
    "EURONEXT": {
        "name": "Euronext",
        "timezone": "Europe/Paris",
        "session": "0900-1730",
        "delay": "15 min",
        "symbol_suffix": "",
        "country_name": "",
        "country_code": "",
    },
    "HAM": {
        "name": "Hamburg Stock Exchange",
        "timezone": "Europe/Berlin",
        "session": "0800-2200",
        "delay": "15 min",
        "symbol_suffix": ".HM",
        "country_name": "Germany",
        "country_code": "DE",
    },
    "HEL": {
        "name": "NASDAQ Helsinki",
        "timezone": "Europe/Helsinki",
        "session": "1000-1830",
        "delay": "Real-time",
        "symbol_suffix": ".HE",
        "country_name": "Finland",
        "country_code": "FI",
    },
    "HKSE": {
        "name": "Hong Kong Stock Exchange",
        "timezone": "Asia/Hong_Kong",
        "session": "0930-1600",
        "delay": "15 min",
        "symbol_suffix": ".HK",
        "country_name": "Hong Kong",
        "country_code": "HK",
    },
    "HOSE": {
        "name": "Ho Chi Minh Stock Exchange",
        "timezone": "Asia/Ho_Chi_Minh",
        "session": "0900-1130|1300-1500",
        "delay": "15 min",
        "symbol_suffix": ".VN",
        "country_name": "Vietnam",
        "country_code": "VN",
    },
    "ICE": {
        "name": "NASDAQ Iceland",
        "timezone": "Atlantic/Reykjavik",
        "session": "0930-1530",
        "delay": "Real-time",
        "symbol_suffix": ".IC",
        "country_name": "Iceland",
        "country_code": "IS",
    },
    "IOB": {
        "name": "International Order Book",
        "timezone": "Europe/London",
        "session": "0800-1635",
        "delay": "15 min",
        "symbol_suffix": ".IL",
        "country_name": "United Kingdom",
        "country_code": "UK",
    },
    "IST": {
        "name": "Istanbul Stock Exchange",
        "timezone": "Europe/Istanbul",
        "session": "1000-1800",
        "delay": "15 min",
        "symbol_suffix": ".IS",
        "country_name": "Turkey",
        "country_code": "TR",
    },
    "JKT": {
        "name": "Indonesia Stock Exchange",
        "timezone": "Asia/Jakarta",
        "session": "0930-1130|1330-1500",
        "delay": "10 min",
        "symbol_suffix": ".JK",
        "country_name": "Indonesia",
        "country_code": "ID",
    },
    "JNB": {
        "name": "Johannesburg Stock Exchange",
        "timezone": "Africa/Johannesburg",
        "session": "0900-1700",
        "delay": "15 min",
        "symbol_suffix": ".JO",
        "country_name": "South Africa",
        "country_code": "ZA",
    },
    "JPX": {
        "name": "Tokyo Stock Exchange",
        "timezone": "Asia/Tokyo",
        "session": "0900-1130|1230-1530",
        "delay": "20 min",
        "symbol_suffix": ".T",
        "country_name": "Japan",
        "country_code": "JP",
    },
    "KLS": {
        "name": "Malaysian Stock Exchange",
        "timezone": "Asia/Kuala_Lumpur",
        "session": "0930-1230|1430-1700",
        "delay": "15 min",
        "symbol_suffix": ".KL",
        "country_name": "Malaysia",
        "country_code": "MY",
    },
    "KOE": {
        "name": "KOSDAQ",
        "timezone": "Asia/Seoul",
        "session": "0930-1530",
        "delay": "20 min",
        "symbol_suffix": ".KQ",
        "country_name": "South Korea",
        "country_code": "KR",
    },
    "KSC": {
        "name": "Korea Exchange",
        "timezone": "Asia/Seoul",
        "session": "0900-1530",
        "delay": "20 min",
        "symbol_suffix": ".KS",
        "country_name": "South Korea",
        "country_code": "KR",
    },
    "KUW": {
        "name": "Kuwait Stock Exchange",
        "timezone": "Asia/Kuwait",
        "session": "0900-1230",
        "delay": None,
        "symbol_suffix": ".KW",
        "country_name": "Kuwait",
        "country_code": "KW",
    },
    "LIS": {
        "name": "Euronext Lisbon",
        "timezone": "Europe/Lisbon",
        "session": "0800-1630",
        "delay": "15 min",
        "symbol_suffix": ".LS",
        "country_name": "Portugal",
        "country_code": "PT",
    },
    "LSE": {
        "name": "London Stock Exchange",
        "timezone": "Europe/London",
        "session": "0800-1630",
        "delay": "15 min",
        "symbol_suffix": ".L",
        "country_name": "United Kingdom",
        "country_code": "UK",
    },
    "MCX": {
        "name": "Moscow Stock Exchange",
        "timezone": "Europe/Moscow",
        "session": "1000-1840",
        "delay": "15 min",
        "symbol_suffix": ".ME",
        "country_name": "Russia",
        "country_code": "RU",
    },
    "MEX": {
        "name": "Mexican Stock Exchange",
        "timezone": "America/Mexico_City",
        "session": "0730-1400",
        "delay": "20 min",
        "symbol_suffix": ".MX",
        "country_name": "Mexico",
        "country_code": "MX",
    },
    "MIL": {
        "name": "Italian Stock Exchange",
        "timezone": "Europe/Rome",
        "session": "0900-1730",
        "delay": "15 min",
        "symbol_suffix": ".MI",
        "country_name": "Italy",
        "country_code": "IT",
    },
    "MUN": {
        "name": "Munich Stock Exchange",
        "timezone": "Europe/Berlin",
        "session": "0800-2200",
        "delay": "15 min",
        "symbol_suffix": ".MU",
        "country_name": "Germany",
        "country_code": "DE",
    },
    "NASDAQ": {
        "name": "NASDAQ",
        "timezone": "America/New_York",
        "session": "0930-1600",
        "delay": "Real-time",
        "symbol_suffix": None,
        "country_name": "United States of America",
        "country_code": "US",
    },
    "NEO": {
        "name": "CBOE CA",
        "timezone": "America/Toronto",
        "session": "0930-1600",
        "delay": "Real-time",
        "symbol_suffix": ".NE",
        "country_name": "Canada",
        "country_code": "CA",
    },
    "NSE": {
        "name": "National Stock Exchange of India",
        "timezone": "Asia/Kolkata",
        "session": "0915-1530",
        "delay": "15 min",
        "symbol_suffix": ".NS",
        "country_name": "India",
        "country_code": "IN",
    },
    "NYSE": {
        "name": "New York Stock Exchange",
        "timezone": "America/New_York",
        "session": "0930-1600",
        "delay": "Real-time",
        "symbol_suffix": None,
        "country_name": "United States of America",
        "country_code": "US",
    },
    "NZE": {
        "name": "New Zealand Exchange",
        "timezone": "Pacific/Auckland",
        "session": "1000-1645",
        "delay": "15 min",
        "symbol_suffix": ".NZ",
        "country_name": "New Zealand",
        "country_code": "NZ",
    },
    "OSL": {
        "name": "Oslo Stock Exchange",
        "timezone": "Europe/Oslo",
        "session": "0900-1620",
        "delay": "15 min",
        "symbol_suffix": ".OL",
        "country_name": "Norway",
        "country_code": "NO",
    },
    "OTC": {
        "name": "Other OTC",
        "timezone": "America/New_York",
        "session": "0930-1600",
        "delay": "Real-time",
        "symbol_suffix": None,
        "country_name": "United States of America",
        "country_code": "US",
    },
    "PAR": {
        "name": "Euronext Paris",
        "timezone": "Europe/Paris",
        "session": "0900-1730",
        "delay": "15 min",
        "symbol_suffix": ".PA",
        "country_name": "France",
        "country_code": "FR",
    },
    "PNK": {
        "name": "OTC Markets US Pink Slips",
        "timezone": "America/New_York",
        "session": "0930-1600",
        "delay": "Real-time",
        "symbol_suffix": None,
        "country_name": "United States of America",
        "country_code": "US",
    },
    "PRA": {
        "name": "Prague Stock Exchange",
        "timezone": "Europe/Prague",
        "session": "0900-1610",
        "delay": "15 min",
        "symbol_suffix": ".PR",
        "country_name": "Czech Republic",
        "country_code": "CZ",
    },
    "RIS": {
        "name": "NASDAQ Riga",
        "timezone": "Europe/Riga",
        "session": "1000-1600",
        "delay": "Real-time",
        "symbol_suffix": ".RG",
        "country_name": "Latvia",
        "country_code": "LV",
    },
    "SAO": {
        "name": "B3 S.A.",
        "timezone": "America/Sao_Paulo",
        "session": "1000-1655",
        "delay": "15 min",
        "symbol_suffix": ".SA",
        "country_name": "Brazil",
        "country_code": "BR",
    },
    "SAU": {
        "name": "Saudi Exchange",
        "timezone": "Asia/Riyadh",
        "session": "1000-1520",
        "delay": "15 min",
        "symbol_suffix": ".SS",
        "country_name": "Saudi Arabia",
        "country_code": "SA",
    },
    "SES": {
        "name": "Stock Exchange of Singapore",
        "timezone": "Asia/Singapore",
        "session": "0900-1200|1300-1700",
        "delay": "10 min",
        "symbol_suffix": ".SI",
        "country_name": "Singapore",
        "country_code": "SG",
    },
    "SET": {
        "name": "Stock Exchange of Thailand",
        "timezone": "Asia/Bangkok",
        "session": "1000-1230|1400-1640",
        "delay": "15 min",
        "symbol_suffix": ".BK",
        "country_name": "Thailand",
        "country_code": "TH",
    },
    "SGO": {
        "name": "Santiago Stock Exchange",
        "timezone": "America/Santiago",
        "session": "0930-1600",
        "delay": "20 min",
        "symbol_suffix": ".SN",
        "country_name": "Chile",
        "country_code": "CL",
    },
    "SHH": {
        "name": "Shanghai Stock Exchange",
        "timezone": "Asia/Shanghai",
        "session": "0930-1130|1300-1500",
        "delay": "15 min",
        "symbol_suffix": ".SS",
        "country_name": "China",
        "country_code": "CN",
    },
    "SHZ": {
        "name": "Shenzhen Stock Exchange",
        "timezone": "Asia/Shanghai",
        "session": "0930-1130|1300-1500",
        "delay": "15 min",
        "symbol_suffix": ".SZ",
        "country_name": "China",
        "country_code": "CN",
    },
    "SIX": {
        "name": "Swiss Exchange",
        "timezone": "Europe/Zurich",
        "session": "0900-1730",
        "delay": "15 min",
        "symbol_suffix": ".SW",
        "country_name": "Switzerland",
        "country_code": "CH",
    },
    "STO": {
        "name": "Stockholm Stock Exchange",
        "timezone": "Europe/Stockholm",
        "session": "0900-1730",
        "delay": "Real-time",
        "symbol_suffix": ".ST",
        "country_name": "Sweden",
        "country_code": "SE",
    },
    "STU": {
        "name": "Stuttgart Stock Exchange",
        "timezone": "Europe/Berlin",
        "session": "0800-2200",
        "delay": "15 min",
        "symbol_suffix": ".SG",
        "country_name": "Germany",
        "country_code": "DE",
    },
    "TAI": {
        "name": "Taipei Exchange",
        "timezone": "Asia/Taipei",
        "session": "0900-1330",
        "delay": "20 min",
        "symbol_suffix": ".TW",
        "country_name": "Taiwan",
        "country_code": "TW",
    },
    "TAL": {
        "name": "NASDAQ Tallinn",
        "timezone": "Europe/Tallinn",
        "session": "1000-1555",
        "delay": None,
        "symbol_suffix": ".TL",
        "country_name": "Estonia",
        "country_code": "EE",
    },
    "TLV": {
        "name": "Tel Aviv Stock Exchange",
        "timezone": "Asia/Tel_Aviv",
        "session": "CLOSED",
        "delay": "15 min",
        "symbol_suffix": ".TA",
        "country_name": "Israel",
        "country_code": "IL",
    },
    "TSX": {
        "name": "Toronto Stock Exchange",
        "timezone": "America/Toronto",
        "session": "0930-1600",
        "delay": "15 min",
        "symbol_suffix": ".TO",
        "country_name": "Canada",
        "country_code": "CA",
    },
    "TSXV": {
        "name": "Toronto Stock Exchange Ventures",
        "timezone": "America/Toronto",
        "session": "0930-1600",
        "delay": "Real-time",
        "symbol_suffix": ".V",
        "country_name": "Canada",
        "country_code": "CA",
    },
    "TWO": {
        "name": "Taiwan Stock Exchange",
        "timezone": "Asia/Taipei",
        "session": "0900-1330",
        "delay": "20 min",
        "symbol_suffix": ".TWO",
        "country_name": "Taiwan",
        "country_code": "",
    },
    "VIE": {
        "name": "Vienna Stock Exchange",
        "timezone": "Europe/Vienna",
        "session": "0855-1735",
        "delay": "15 min",
        "symbol_suffix": ".VI",
        "country_name": "Austria",
        "country_code": "AT",
    },
    "WSE": {
        "name": "Warsaw Stock Exchange",
        "timezone": "Europe/Warsaw",
        "session": "0900-1650",
        "delay": "Real-time",
        "symbol_suffix": ".WA",
        "country_name": "Poland",
        "country_code": "PL",
    },
    "XETRA": {
        "name": "Deutsche Börse",
        "timezone": "Europe/Berlin",
        "session": "0900-1730",
        "delay": "15 min",
        "symbol_suffix": ".F",
        "country_name": "Germany",
        "country_code": "DE",
    },
}
