"""IMF Constants."""

from typing import Literal

# pylint: disable=line-too-long
# flake8: noqa: E501

DAILY_TRADE_BASE_URL = "https://services9.arcgis.com/weJ1QsnbMYJlCHdG/arcgis/rest/services/Daily_Trade_Data/FeatureServer/0/query?"

CHOKEPOINTS_BASE_URL = "https://services9.arcgis.com/weJ1QsnbMYJlCHdG/arcgis/rest/services/Daily_Chokepoints_Data/FeatureServer/0/query?"

CHOKEPOINTS_ID_MAP = {
    "chokepoint1": "Suez Canal",
    "chokepoint2": "Panama Canal",
    "chokepoint3": "Bosporus Strait",
    "chokepoint4": "Bab el-Mandeb Strait",
    "chokepoint5": "Malacca Strait",
    "chokepoint6": "Strait of Hormuz",
    "chokepoint7": "Cape of Good Hope",
    "chokepoint8": "Gibraltar Strait",
    "chokepoint9": "Dover Strait",
    "chokepoint10": "Oresund Strait",
    "chokepoint11": "Taiwan Strait",
    "chokepoint12": "Korea Strait",
    "chokepoint13": "Tsugaru Strait",
    "chokepoint14": "Luzon Strait",
    "chokepoint15": "Lombok Strait",
    "chokepoint16": "Ombai Strait",
    "chokepoint17": "Bohai Strait",
    "chokepoint18": "Torres Strait",
    "chokepoint19": "Sunda Strait",
    "chokepoint20": "Makassar Strait",
    "chokepoint21": "Magellan Strait",
    "chokepoint22": "Yucatan Channel",
    "chokepoint23": "Windward Passage",
    "chokepoint24": "Mona Passage",
}

CHOKEPOINTS_NAME_TO_ID = {
    v.replace(" ", "_").lower(): k for k, v in CHOKEPOINTS_ID_MAP.items()
}

ChokepointsNames = Literal[
    "suez_canal",
    "panama_canal",
    "bosporus_strait",
    "bab_el_mandeb_strait",
    "malacca_strait",
    "strait_of_hormuz",
    "cape_of_good_hope",
    "gibraltar_strait",
    "dover_strait",
    "oresund_strait",
    "taiwan_strait",
    "korea_strait",
    "tsugaru_strait",
    "luzon_strait",
    "lombok_strait",
    "ombai_strait",
    "bohai_strait",
    "torres_strait",
    "sunda_strait",
    "makassar_strait",
    "magellan_strait",
    "yucatan_channel",
    "windward_passage",
    "mona_passage",
]


PORT_CONTINENTS = [
    {"label": "North America", "value": "north_america"},
    {"label": "Europe", "value": "europe"},
    {"label": "Asia & Pacific", "value": "asia_pacific"},
    {"label": "South America", "value": "south_america"},
    {"label": "Africa", "value": "africa"},
]

PortContinents = Literal[
    "north_america",
    "europe",
    "asia_pacific",
    "south_america",
    "africa",
]

PORT_COUNTRIES: dict = {
    "Albania": "ALB",
    "Algeria": "DZA",
    "American Samoa": "ASM",
    "Angola": "AGO",
    "Anguilla": "AIA",
    "Antigua and Barbuda": "ATG",
    "Argentina": "ARG",
    "Aruba": "ABW",
    "Australia": "AUS",
    "Azerbaijan": "AZE",
    "Bahrain": "BHR",
    "Bangladesh": "BGD",
    "Barbados": "BRB",
    "Belgium": "BEL",
    "Belize": "BLZ",
    "Benin": "BEN",
    "Bonaire, Saint Eustatius and Saba": "BES",
    "Brazil": "BRA",
    "British Virgin Islands": "VGB",
    "Brunei Darussalam": "BRN",
    "Bulgaria": "BGR",
    "Cabo Verde": "CPV",
    "Cambodia": "KHM",
    "Cameroon": "CMR",
    "Canada": "CAN",
    "Cayman Islands": "CYM",
    "Chile": "CHL",
    "China": "CHN",
    "Colombia": "COL",
    "Comoros": "COM",
    "Cook Islands": "COK",
    "Costa Rica": "CRI",
    "Croatia": "HRV",
    "Cuba": "CUB",
    "Curaçao": "CUW",
    "Cyprus": "CYP",
    "Côte d'Ivoire": "CIV",
    "Democratic Republic of the Congo": "COD",
    "Denmark": "DNK",
    "Djibouti": "DJI",
    "Dominica": "DMA",
    "Dominican Republic": "DOM",
    "Ecuador": "ECU",
    "Egypt": "EGY",
    "El Salvador": "SLV",
    "Equatorial Guinea": "GNQ",
    "Eritrea": "ERI",
    "Estonia": "EST",
    "Faroe Islands": "FRO",
    "Fiji": "FJI",
    "Finland": "FIN",
    "France": "FRA",
    "French Guiana": "GUF",
    "French Polynesia": "PYF",
    "Gabon": "GAB",
    "Georgia": "GEO",
    "Germany": "DEU",
    "Ghana": "GHA",
    "Gibraltar": "GIB",
    "Greece": "GRC",
    "Grenada": "GRD",
    "Guadeloupe": "GLP",
    "Guam": "GUM",
    "Guatemala": "GTM",
    "Guinea": "GIN",
    "Guinea-Bissau": "GNB",
    "Guyana": "GUY",
    "Haiti": "HTI",
    "Honduras": "HND",
    "Hong Kong SAR": "HKG",
    "Iceland": "ISL",
    "India": "IND",
    "Indonesia": "IDN",
    "Iran": "IRN",
    "Iraq": "IRQ",
    "Ireland": "IRL",
    "Israel": "ISR",
    "Italy": "ITA",
    "Jamaica": "JAM",
    "Japan": "JPN",
    "Jordan": "JOR",
    "Kazakhstan": "KAZ",
    "Kenya": "KEN",
    "Kiribati": "KIR",
    "Korea": "KOR",
    "Kuwait": "KWT",
    "Latvia": "LVA",
    "Lebanon": "LBN",
    "Liberia": "LBR",
    "Libya": "LBY",
    "Lithuania": "LTU",
    "Macao SAR": "MAC",
    "Madagascar": "MDG",
    "Malaysia": "MYS",
    "Maldives": "MDV",
    "Malta": "MLT",
    "Marshall Islands": "MHL",
    "Martinique": "MTQ",
    "Mauritania": "MRT",
    "Mauritius": "MUS",
    "Mayotte": "MYT",
    "Mexico": "MEX",
    "Micronesia": "FSM",
    "Moldova": "MDA",
    "Montenegro": "MNE",
    "Montserrat": "MSR",
    "Morocco": "MAR",
    "Mozambique": "MOZ",
    "Myanmar": "MMR",
    "Namibia": "NAM",
    "Nauru": "NRU",
    "New Caledonia": "NCL",
    "New Zealand": "NZL",
    "Nicaragua": "NIC",
    "Nigeria": "NGA",
    "Northern Mariana Islands": "MNP",
    "Norway": "NOR",
    "Oman": "OMN",
    "Pakistan": "PAK",
    "Palau": "PLW",
    "Panama": "PAN",
    "Papua New Guinea": "PNG",
    "Peru": "PER",
    "Philippines": "PHL",
    "Poland": "POL",
    "Portugal": "PRT",
    "Puerto Rico": "PRI",
    "Qatar": "QAT",
    "Republic of Congo": "COG",
    "Romania": "ROU",
    "Russian Federation": "RUS",
    "Réunion": "REU",
    "Saint Martin": "MAF",
    "Saint-Barthélemy": "BLM",
    "Samoa": "WSM",
    "Saudi Arabia": "SAU",
    "Senegal": "SEN",
    "Seychelles": "SYC",
    "Sierra Leone": "SLE",
    "Singapore": "SGP",
    "Sint Maarten": "SXM",
    "Slovenia": "SVN",
    "Solomon Islands": "SLB",
    "Somalia": "SOM",
    "South Africa": "ZAF",
    "Spain": "ESP",
    "Sri Lanka": "LKA",
    "St. Kitts and Nevis": "KNA",
    "St. Lucia": "LCA",
    "St. Vincent and the Grenadines": "VCT",
    "Sudan": "SDN",
    "Suriname": "SUR",
    "Sweden": "SWE",
    "Syria": "SYR",
    "São Tomé and Príncipe": "STP",
    "Taiwan Province of China": "TWN",
    "Tanzania": "TZA",
    "Thailand": "THA",
    "The Bahamas": "BHS",
    "The Gambia": "GMB",
    "The Netherlands": "NLD",
    "Timor-Leste": "TLS",
    "Togo": "TGO",
    "Tonga": "TON",
    "Trinidad and Tobago": "TTO",
    "Tunisia": "TUN",
    "Turkmenistan": "TKM",
    "Turks and Caicos Islands": "TCA",
    "Tuvalu": "TUV",
    "Türkiye": "TUR",
    "Ukraine": "UKR",
    "United Arab Emirates": "ARE",
    "United Kingdom": "GBR",
    "United States": "USA",
    "United States Virgin Islands": "VIR",
    "Uruguay": "URY",
    "Vanuatu": "VUT",
    "Venezuela": "VEN",
    "Vietnam": "VNM",
    "Yemen": "YEM",
}

PORT_COUNTRIES_CHOICES = [
    {"label": key, "value": value} for key, value in PORT_COUNTRIES.items()
]

PortCountries = Literal[
    "ABW",
    "AGO",
    "AIA",
    "ALB",
    "ARE",
    "ARG",
    "ASM",
    "ATG",
    "AUS",
    "AZE",
    "BEL",
    "BEN",
    "BES",
    "BGD",
    "BGR",
    "BHR",
    "BHS",
    "BLM",
    "BLZ",
    "BRA",
    "BRB",
    "BRN",
    "CAN",
    "CHL",
    "CHN",
    "CIV",
    "CMR",
    "COD",
    "COG",
    "COK",
    "COL",
    "COM",
    "CPV",
    "CRI",
    "CUB",
    "CUW",
    "CYM",
    "CYP",
    "DEU",
    "DJI",
    "DMA",
    "DNK",
    "DOM",
    "DZA",
    "ECU",
    "EGY",
    "ERI",
    "ESP",
    "EST",
    "FIN",
    "FJI",
    "FRA",
    "FRO",
    "FSM",
    "GAB",
    "GBR",
    "GEO",
    "GHA",
    "GIB",
    "GIN",
    "GLP",
    "GMB",
    "GNB",
    "GNQ",
    "GRC",
    "GRD",
    "GTM",
    "GUF",
    "GUM",
    "GUY",
    "HKG",
    "HND",
    "HRV",
    "HTI",
    "IDN",
    "IND",
    "IRL",
    "IRN",
    "IRQ",
    "ISL",
    "ISR",
    "ITA",
    "JAM",
    "JOR",
    "JPN",
    "KAZ",
    "KEN",
    "KHM",
    "KIR",
    "KNA",
    "KOR",
    "KWT",
    "LBN",
    "LBR",
    "LBY",
    "LCA",
    "LKA",
    "LTU",
    "LVA",
    "MAC",
    "MAF",
    "MAR",
    "MDA",
    "MDG",
    "MDV",
    "MEX",
    "MHL",
    "MLT",
    "MMR",
    "MNE",
    "MNP",
    "MOZ",
    "MRT",
    "MSR",
    "MTQ",
    "MUS",
    "MYS",
    "MYT",
    "NAM",
    "NCL",
    "NGA",
    "NIC",
    "NLD",
    "NOR",
    "NRU",
    "NZL",
    "OMN",
    "PAK",
    "PAN",
    "PER",
    "PHL",
    "PLW",
    "PNG",
    "POL",
    "PRI",
    "PRT",
    "PYF",
    "QAT",
    "REU",
    "ROU",
    "RUS",
    "SAU",
    "SDN",
    "SEN",
    "SGP",
    "SLB",
    "SLE",
    "SLV",
    "SOM",
    "STP",
    "SUR",
    "SVN",
    "SWE",
    "SXM",
    "SYC",
    "SYR",
    "TCA",
    "TGO",
    "THA",
    "TKM",
    "TLS",
    "TON",
    "TTO",
    "TUN",
    "TUR",
    "TUV",
    "TWN",
    "TZA",
    "UKR",
    "URY",
    "USA",
    "VCT",
    "VEN",
    "VGB",
    "VIR",
    "VNM",
    "VUT",
    "WSM",
    "YEM",
    "ZAF",
]


FREQUENCY_DICT = {
    "month": "M",
    "quarter": "Q",
    "annual": "A",
}
REF_SECTORS_DICT = {
    "government_ex_social_security": "S1311",
    "central_bank": "S121",
    "monetary_authorities": "S1X",
    "all_sectors": "",
}

SECTOR_MAP = {v: k for k, v in REF_SECTORS_DICT.items()}

UNIT_MULTIPLIERS_MAP = {
    "0": "Units",
    "2": "Hundreds",
    "3": "Thousands",
    "6": "Millions",
    "9": "Billions",
    "12": "Trillions",
    "N15": "Quadrillionths",
    "N14": "Hundred Trillionths",
    "N13": "Ten Trillionths",
    "N12": "Trillionths",
    "N11": "Hundred Billionths",
    "N10": "Ten Billionths",
    "N9": "Billionths",
    "N8": "Hundred Millionths",
    "N7": "Ten Millionths",
    "N6": "Millionths",
    "N5": "Hundred Thousandths",
    "N4": "Ten Thousandths",
    "N3": "Thousandths",
    "N2": "Hundredths",
    "N1": "Tenths",
    "1": "Tens",
    "4": "Ten Thousands",
    "5": "Hundred Thousands",
    "7": "Ten Millions",
    "8": "Hundred Millions",
    "10": "Ten Billions",
    "11": "Hundred Billions",
    "13": "Ten Trillions",
    "14": "Hundred Trillions",
    "15": "Quadrillions",
}

TIME_FORMAT_MAP = {
    "P1Y": "Annual",
    "P6M": "Bi-annual",
    "P3M": "Quarterly",
    "P1M": "Monthly",
    "P7D": "Weekly",
    "P1D": "Daily",
}

REF_SECTOR_MAP = {
    "S1311": "Central government excluding social security",
    "S121": "Central Bank",
    "S1X": "Monetary Authorities",
    "1C_AS": "All Sectors",
    "AllSectorsIncludingAllSectors": "All Sectors Including All Sectors",
}

PRESENTATION_TABLES: dict[str, str] = {
    "bop_standard": "BOP::H_BOP_BOP_AGG_STANDARD_PRESENTATION",
    "bop_analytic": "BOP::H_BOP_BOP_AGG_ANALYTIC_PRESENTATION",
    "bop_international_transactions": "BOP_AGG::H_BOP_AGG_SUMMARY_OF_INTERNATIONAL_TRANSACTIONS",
    "bop_global_discrepancies": "BOP_AGG::H_BOP_AGG_GLOBAL_DISCREPANCIES",
    "bop_global_discrepancies_percent": "BOP_AGG::H_BOP_AGG_GLOBAL_DISCREPANCIES_PERCENTAGE",
    "dip": "DIP::H_DIP_INDICATOR",
    "iip_aggregated": "IIP::H_BOP_IIP_AGG",
    "iip_currency_composition": "IIPCC::H_BOP_IIPCC_CURRENCY_COMPOSITION",
    "eer": "EER::H_EER_INDICATOR_HIERARCHY",
    "irfcl_reserve_assets": "IRFCL::H_CL_IRFCL_INDICATOR_DEFAULT_PUB:CL_IRFCL_DEFAULT_INDICATOR_PUB2_1",
    "irfcl_predetermined_drains": "IRFCL::H_CL_IRFCL_INDICATOR_DEFAULT_PUB:CL_IRFCL_DEFAULT_INDICATOR_PUB2_29",
    "irfcl_contingent_drains": "IRFCL::H_CL_IRFCL_INDICATOR_DEFAULT_PUB:CL_IRFCL_DEFAULT_INDICATOR_PUB2_91",
    "irfcl_memorandum": "IRFCL::H_CL_IRFCL_INDICATOR_DEFAULT_PUB:CL_IRFCL_DEFAULT_INDICATOR_PUB2_273",
    "fsi_core_and_additional": "FSIC::H_FSIC_INDICATOR",
    "fsi_indicators_and_underlying": "FSIC::H_FSIC_FSD",
    "fsi_concentration_distribution_measures": "FSICDM::H_FSI_FSICDM_CDM",
    "mfs_monetary_aggs": "MFS_MA::H_CL_MFS_MA_INDICATOR_5SR",
    "mfs_central_bank": "MFS_CBS::H_CL_MFS_CBS_SRFS_1SG_VIEW",
    "mfs_other_depository_corps": "MFS_ODC::H_CL_MFS_ODC_SRFS_2SG_VIEW",
    "mfs_depository_corps": "MFS_DC::H_CL_MFS_DCS_SRFS_3SG_VIEW",
    "mfs_other_financial_corps": "MFS_OFC::H_CL_MFS_OFC_SRFS_4SG_VIEW",
    "mfs_financial_corps": "MFS_FC::H_CL_MFS_FCS_SRFS_5SG_VIEW",
    "gfs_balance": "GFS_BS::H_GFS_BS",
    "gfs_operations": "GFS_SOO::H_GFS_SOO",
    "gfs_expenditures": "GFS_COFOG::H_GFS_COFOG",
    "gfs_stocks_and_flows": "GFS_SFCP::H_GFS_SFCP",
    "gfs_sources_and_uses": "GFS_SSUC::H_GFS_SSUC",
    "qgfs_balance": "QGFS::H_QGFS_BALANCE",
    "qgfs_operations": "QGFS::H_QGFS_STATGO",
    "qgfs_sources_and_uses": "QGFS::H_QGFS_GSUC",
    "gdp_annual_expenditure": "ANEA::H_NEA_GDP_BY_EXPENDITURE",
    "gdp_quarterly_expenditure": "QNEA::H_NEA_GDP_BY_EXPENDITURE",
    "cpi": "CPI::H_CPI_BY_COMPONENT",
    "fas_indicator_by_country": "FAS::H_FAS_INDICATOR_BY_COUNTRY",
    "fas_data_by_country": "FAS::H_FAS_BY_COUNTRY",
    "isora_indicators_by_topic": "ISORA_LATEST_DATA_PUB::H_CL_INDICATORS_BY_TOPIC",
}

table_dataflow_map: dict[str, list[str]] = {
    "bop": [
        "bop_standard",
        "bop_analytic",
        "bop_international_transactions",
        "bop_global_discrepancies",
        "bop_global_discrepancies_percent",
    ],
    "dip": ["dip"],
    "iip": ["iip_aggregated", "iip_currency_composition"],
    "eer": ["eer"],
    "irfcl": [
        "irfcl_reserve_assets",
        "irfcl_predetermined_drains",
        "irfcl_contingent_drains",
        "irfcl_memorandum",
    ],
    "fsi": [
        "fsi_core_and_additional",
        "fsi_indicators_and_underlying",
        "fsi_concentration_distribution_measures",
    ],
    "mfs": [
        "mfs_monetary_aggs",
        "mfs_central_bank",
        "mfs_other_depository_corps",
        "mfs_depository_corps",
        "mfs_other_financial_corps",
        "mfs_financial_corps",
    ],
    "gfs": [
        "gfs_balance",
        "gfs_operations",
        "gfs_expenditures",
        "gfs_stocks_and_flows",
        "gfs_sources_and_uses",
    ],
    "qgfs": ["qgfs_balance", "qgfs_operations", "qgfs_sources_and_uses"],
    "gdp": ["gdp_annual_expenditure", "gdp_quarterly_expenditure"],
    "cpi": ["cpi"],
    "fas": ["fas_indicator_by_country", "fas_data_by_country"],
    "isora": ["isora_indicators_by_topic"],
}

table_dataflow_choices: list[dict[str, str]] = [
    {"label": "Balance of Payments", "value": "bop"},
    {"label": "Direct Investment Position", "value": "dip"},
    {"label": "Effective Exchange Rates", "value": "eer"},
    {"label": "International Investment Position", "value": "iip"},
    {
        "label": "International Reserves and Foreign Currency Liquidity",
        "value": "irfcl",
    },
    {"label": "Financial Soundness Indicators", "value": "fsi"},
    {"label": "Monetary and Financial Statistics", "value": "mfs"},
    {"label": "Government Finance Statistics", "value": "gfs"},
    {"label": "Quarterly Government Finance Statistics", "value": "qgfs"},
    {"label": "Gross Domestic Product", "value": "gdp"},
    {"label": "Consumer Price Index", "value": "cpi"},
    {"label": "Financial Access Survey", "value": "fas"},
    {"label": "ISORA Indicators", "value": "isora"},
]

table_name_map: dict[str, str] = {
    "bop_standard": "Standard Presentation",
    "bop_analytic": "Analytic Presentation",
    "bop_international_transactions": "Summary of International Transactions",
    "bop_global_discrepancies": "Global Discrepancies",
    "bop_global_discrepancies_percent": "Global Discrepancies Percentage",
    "dip": "Direct Investment Position",
    "iip_aggregated": "Aggregated International Investment Position",
    "iip_currency_composition": "Currency Composition of International Investment Position",
    "eer": "Effective Exchange Rates",
    "irfcl_reserve_assets": "Reserve Assets",
    "irfcl_predetermined_drains": "Predetermined Drains",
    "irfcl_contingent_drains": "Contingent Drains",
    "irfcl_memorandum": "Memorandum Items",
    "fsi_core_and_additional": "Core and Additional Financial Soundness Indicators",
    "fsi_indicators_and_underlying": "Financial Soundness Indicators and Underlying Data",
    "fsi_concentration_distribution_measures": "Concentration and Distribution Measures",
    "mfs_monetary_aggs": "Monetary Aggregates",
    "mfs_central_bank": "Central Bank",
    "mfs_other_depository_corps": "Other Depository Corporations",
    "mfs_depository_corps": "Depository Corporations",
    "mfs_financial_corps": "Financial Corporations",
    "mfs_other_financial_corps": "Other Financial Corporations",
    "gfs_balance": "Government Balance Sheet",
    "gfs_operations": "Statement of Government Operations",
    "gfs_expenditures": "Expenditures by Function (COFOG)",
    "gfs_stocks_and_flows": "Stocks and Flows of Central Government",
    "gfs_sources_and_uses": "Sources and Uses of Central Government Funds",
    "qgfs_balance": "Quarterly Government Finance Statistics Balance Sheet",
    "qgfs_operations": "Quarterly Government Finance Statistics Statement of Operations",
    "qgfs_sources_and_uses": "Quarterly Government Finance Statistics Sources and Uses of Funds",
    "gdp_annual_expenditure": "Annual GDP by Expenditure",
    "gdp_quarterly_expenditure": "Quarterly GDP by Expenditure",
    "cpi": "Consumer Price Index by Component",
    "fas_indicator_by_country": "Financial Access Survey Indicators by Country",
    "fas_data_by_country": "Financial Access Survey Data by Country",
    "isora_indicators_by_topic": "ISORA Indicators by Topic",
}
