# Contributing to XAgent 🚀

Welcome to the XAgent project, where your contributions matter greatly. We're delighted that you're interested in joining our mission to enhance this project.

## How You Can Contribute 🌟

Your contributions can take many forms:

- **Reporting Bugs 🐞**: Help us identify and address issues (you can go ahead with issues!).
- **Suggesting Enhancements 🚀**: Share your ideas for improving XAgent (by making issues.).
- **Adding New Features 💡**: Contribute your expertise by introducing exciting new features.
- **Improving Documentation 📚**: Enhance the clarity and completeness of our documentation.
- **Providing Support 👋**: Assist other users with their issues.

## Getting Started 🚀

To get started with your contributions, follow these steps:

1. **Fork the [XAgent repository](https://github.com/OpenBMB/XAgent)** by clicking the "Fork" button in the top-right corner of the repository page.

2. **Clone your forked repository** to your local machine:

   ```shell
   git clone https://github.com/YourUsername/XAgent.git
   ```

3. Create a **new branch** for your changes:

   ```shell
   git checkout -b feature/your-feature
   ```

## Making Changes 🌈

With your environment set up, you're ready to make your contributions:

1. Make your changes and **commit them to your branch**:

   ```shell
   git commit -m "Your descriptive commit message"
   ```

2. **Push your changes** to your forked repository:

   ```shell
   git push origin feature/your-feature
   ```

3. Create a **pull request (PR)** by navigating to the [XAgent repository](https://github.com/OpenBMB/XAgent) and clicking the "New Pull Request" button.

4. Provide a **descriptive title and details** in the PR, and make sure to **link your PR to any relevant issues**.

5. **Submit the pull request**, and our maintainers will review your changes.

## Code of Conduct 📜

Please adhere to our [Code of Conduct](LICENSE) while contributing to this project.

We sincerely appreciate your contributions, and we look forward to working together to make XAgent even better for everyone!

Happy Contributing! 🌟
