# FunctionDef to_hash
**to_hash函数**：该函数的功能是将给定的vocabulary、regex_str和eos_token拼接成一个字符串，并返回该字符串的哈希值。

该函数接受三个参数：
- vocabulary：表示词汇表，是一个列表，包含了所有的词汇。
- regex_str：表示正则表达式的字符串。
- eos_token：表示结束标记。

函数内部首先使用f-string将vocabulary、regex_str和eos_token拼接成一个字符串。然后使用hash函数计算该字符串的哈希值，并将结果返回。

需要注意的是，该函数的返回值是一个整数。

**注意**：在使用该函数时，需要确保传入的参数类型正确，并且vocabulary和regex_str的取值符合预期。

**输出示例**：假设传入的参数分别为["apple", "banana", "orange"], "[a-z]+", "<eos>"，则函数的返回值可能为-123456789。
***
# ClassDef XRegex
**XRegex函数**：这个类的功能是创建一个正则表达式的有限状态机。

这个类继承自`Regex`类，它有以下参数：
- `model`：一个模型对象，用于生成文本。
- `regex_string`：一个字符串，表示正则表达式的模式。
- `max_tokens`：一个可选的整数，表示生成的文本的最大长度。
- `sampler`：一个可选的`sampler`对象，用于控制生成文本的采样方式。
- `stop`：一个字符串或字符串列表，表示生成文本时的停止条件。
- `allow_empty_tokens`：一个布尔值，表示是否允许生成空的token。
- `initial_state`：一个可选的整数，表示有限状态机的初始状态。
- `final_states`：一个可选的整数集合，表示有限状态机的终止状态。
- `states_to_token_maps`：一个可选的字典，表示状态到token的映射关系。
- `empty_token_ids`：一个可选的整数集合，表示空token的id。

在初始化函数中，首先通过`model.tokenizer.vocabulary`获取模型的词汇表，并将词汇表按照词汇表中的索引进行排序。然后使用`to_hash`函数生成一个哈希键，该键由排序后的词汇表、正则表达式模式和模型的结束标记组成。

接下来，通过检查哈希键是否存在于`pstate_to_vocab_path_cache`缓存中，如果存在，则从缓存中获取有限状态机、状态到token的映射关系和空token的id。如果不存在，则使用`interegular.parse_pattern`函数解析正则表达式模式，并将其转换为有限状态机。然后使用`make_deterministic_fsm`函数将有限状态机转换为确定性有限状态机，并使用`reduce`方法对其进行优化。接着，使用`create_fsm_index_tokenizer`函数生成状态到token的映射关系和空token的id。最后，将有限状态机的初始状态、终止状态、状态到token的映射关系和空token的id保存到`pstate_to_vocab_path_cache`缓存中。

最后，调用父类`Regex`的初始化函数，传入相应的参数，完成对象的初始化。

**注意**：在使用`XRegex`类时，需要传入一个模型对象和一个正则表达式模式。可以通过调用`multi_regex`函数来创建一个包含多个正则表达式模式的有限状态机。
## FunctionDef __init__
**__init__函数**：这个函数的功能是初始化一个对象。

在这个函数中，我们首先获取了模型的词汇表，并对其进行排序。然后，我们使用排序后的词汇表、正则表达式字符串和模型的结束标记来生成一个哈希键。如果这个哈希键在缓存中已经存在，我们就从缓存中获取对应的正则有限状态机、状态到标记的映射和空标记的ID。否则，我们使用正则表达式字符串解析出正则模式，并将其转换为确定性有限状态机。然后，我们创建状态到标记的映射和空标记的ID，并将初始状态和终止状态设置为正则有限状态机的初始状态和终止状态。最后，我们将正则有限状态机、状态到标记的映射和空标记的ID存储到缓存中。

在初始化对象时，我们调用了父类的__init__函数，并传入了模型、正则表达式字符串、最大标记数、采样器、停止标记、是否允许空标记、初始状态、终止状态、状态到标记的映射和空标记的ID。

**注意**：使用这段代码时需要注意以下几点：
- 需要提供一个模型对象和一个正则表达式字符串作为参数。
- 可以选择性地提供最大标记数、采样器、停止标记、是否允许空标记、初始状态、终止状态、状态到标记的映射和空标记的ID作为参数。
- 如果缓存中已经存在相同的哈希键，将直接使用缓存中的正则有限状态机、状态到标记的映射和空标记的ID，而不会重新生成。
- 如果缓存中不存在相同的哈希键，将根据正则表达式字符串生成正则有限状态机，并将其存储到缓存中供以后使用。
***
# FunctionDef multi_regex
**multi_regex函数**：该函数的功能是根据给定的选择列表，生成一个正则表达式匹配模式。

该函数接受以下参数：
- model: 一个模型对象，用于生成正则表达式匹配模式。
- choices: 一个字符串列表，包含了多个选择项，用于构建正则表达式的匹配模式。
- max_tokens: 可选参数，用于限制生成的正则表达式的最大长度。
- sampler: 可选参数，一个采样器对象，用于生成正则表达式的匹配模式。
- allow_empty_tokens: 可选参数，一个布尔值，指示是否允许生成的正则表达式中包含空的匹配模式。

该函数首先将选择项列表转换为一个正则表达式字符串，然后使用该字符串和其他参数创建一个XRegex对象，并将其作为结果返回。

**注意**：在使用该函数时需要注意以下几点：
- 参数model必须是一个有效的模型对象。
- 参数choices不能为空列表。
- 参数max_tokens必须是一个正整数。
- 参数sampler必须是一个有效的采样器对象。

**输出示例**：假设choices列表为["abc", "def", "ghi"]，max_tokens为10，返回的XRegex对象将具有以下属性：
- model: 传入的模型对象。
- regex_str: 生成的正则表达式字符串为"(abc|def|ghi)"。
- max_tokens: 传入的max_tokens值。
- sampler: 传入的采样器对象。
- allow_empty_tokens: 传入的allow_empty_tokens值。
***
