The Paradox of Progress: Navigating the Ethical and Cognitive Implications of AI
A little more than a year ago, I penned an article on AI ethics, which was the inaugural piece for the GPT4All-webui repository, the precursor to lollms. In that article, I explored potential futures with AI, both utopian and dystopian, without passing judgment. Fast forward to today, and the rapid advancements in AI have prompted me to revisit these issues with renewed curiosity.

Last week, I had an epiphany while observing two girls on the tramway. One said, “You know, the homework we had, I did it using ChatGPT.” The other replied, “Same for me. Why bother doing things ourselves when we have a tool like that?” This seemingly mundane exchange struck me like a philosophical lightning bolt. Are we, as humans, inherently lazy? Or are we simply pragmatic, always seeking the path of least resistance?

One could argue that this behavior is akin to our reliance on calculators. Calculators have undoubtedly made us more efficient, but they’ve also eroded certain skills. A few generations ago, people excelled at mental arithmetic. Today, while a human with a calculator is formidable, a human without one often feels lost. Technology augments us, but it also diminishes us in subtle ways.

While the reliance on calculators might seem trivial, the stakes are exponentially higher when it comes to outsourcing our thinking to AI. Imagine a world where AI handles all our cognitive tasks. This could enable us to achieve feats previously deemed impossible. However, if we suddenly remove that AI, we might find ourselves more helpless than ever before. At least animals think and have evolved to react to their environment. In nature, it’s a case of “use it or lose it.” If something is not useful, it degrades. If AI starts to think for us, then as Agent Smith from “The Matrix” ominously noted, “It is no longer our civilization, but theirs.”

Consider the history of humanity. Formal schooling is a relatively recent development. In the past, most people didn’t attend school; they learned through apprenticeships and acquired only the skills necessary for work and life, primarily manual skills. Only a privileged few had access to a broader education in philosophy, mathematics, literature, and the like.

We have since evolved into a society where literacy is widespread, and we are exposed to a vast array of knowledge. However, with the advent of advanced AI, we risk reverting to a state where learning becomes unnecessary because AI is becoming increasingly intelligent and may soon surpass the IQ of most humans. This raises a critical question: If AI can perform most tasks better than humans, what is left for us to do?

The ethical and societal implications of this shift are profound. As AI continues to evolve, it will likely take over many tasks that humans currently perform, from routine jobs to complex problem-solving. This could lead to widespread unemployment and economic disparity if not managed properly. Moreover, the reliance on AI for decision-making could erode our critical thinking skills and make us overly dependent on machines.

One area that will be significantly impacted is education. If students use AI to complete their homework, they may not develop the necessary skills to think critically and solve problems independently. This could create a generation of individuals who are adept at using technology but lack the fundamental skills to innovate and adapt in the absence of AI.

On the flip side, AI has the potential to significantly enhance human capabilities. By automating mundane tasks, AI can free up time for humans to focus on more creative and meaningful pursuits. It can also assist in areas like healthcare, where AI can analyze vast amounts of data to provide insights that humans might miss. The key is to find a balance where AI acts as a tool to augment human abilities rather than replace them.

To further illustrate the potential consequences of over-reliance on technology, let’s look at examples from the movies “Idiocracy,” “Wall-E,” and “The Matrix.”

In “Idiocracy,” society has devolved into a state of extreme intellectual laziness and incompetence. People rely heavily on automated systems and have lost the ability to think critically or solve basic problems. This dystopian future serves as a cautionary tale about the dangers of neglecting education and critical thinking in favor of convenience and entertainment. The film portrays a world where the pursuit of ease has led to a collective intellectual decline, raising the question: Are we sacrificing our cognitive abilities for the sake of comfort?

Similarly, in “Wall-E,” humans have become entirely dependent on technology, living in a spaceship where robots cater to their every need. As a result, they have become physically and mentally inactive, losing their ability to engage with the world around them. The film highlights the importance of maintaining a balance between technological convenience and human engagement with the environment. It prompts us to ask: What happens to our humanity when we no longer need to strive, struggle, or even move?

“The Matrix” offers a more complex and layered exploration of these themes. In the film, humans are unknowingly trapped in a simulated reality created by intelligent machines. This raises profound questions about the nature of reality and the essence of human existence. Agent Smith’s words resonate deeply with our current predicament:

“Did you know that the first Matrix was designed to be a perfect human world? Where none suffered, where everyone would be happy. It was a disaster. No one would accept the program. Entire crops were lost. Some believed we lacked the programming language to describe your perfect world. But I believe that, as a species, human beings define their reality through suffering and misery. The perfect world was a dream that your primitive cerebrum kept trying to wake up from. Which is why the Matrix was redesigned to this: the peak of your civilization. I say ‘your civilization’ because as soon as we started thinking for you, it really became our civilization, which is, of course, what this is all about. Evolution, Morpheus. Evolution. Like the dinosaur. Look out that window. You had your time. The future is our world, Morpheus. The future is our time.”

Agent Smith’s words underscore a fundamental truth about human nature: our growth and development are often driven by challenges and adversity. If AI begins to think for us, we risk losing our civilization to the very tools we created. This raises profound questions about the essence of being human. Is it our ability to think, adapt, and innovate that defines us? Or is it our capacity to experience and overcome suffering that shapes our reality?

However, there is hope. The vision of humanity’s future as depicted in “Star Trek” offers an inspiring counterpoint. In the “Star Trek” universe, humanity has transcended the limitations of its past. Technology is not a crutch but a catalyst for exploration, curiosity, and self-improvement. Money and wealth have become irrelevant, and people are driven by a desire to better themselves and contribute to the greater good. Freed from the burdens of mundane work, they seek more noble objectives, such as exploring the cosmos, understanding new cultures, and pushing the boundaries of knowledge.

This optimistic vision reminds us that technology, including AI, can be a powerful tool for human advancement if used wisely. It can free us from repetitive and menial tasks, allowing us to focus on what truly makes us human: our creativity, our curiosity, and our capacity for empathy and understanding. By embracing these values, we can ensure that AI serves as a partner in our journey toward a brighter future, rather than a replacement for our own cognitive abilities.

In conclusion, the moment I witnessed on the tramway serves as a microcosm of a larger existential dilemma. As we continue to integrate AI into our lives, we must remain vigilant about preserving our cognitive and critical thinking abilities. After all, the essence of being human lies not in our reliance on tools, but in our capacity to think, adapt, and innovate. And with the right approach, we can harness the power of AI to elevate our civilization to new heights, much like the hopeful future envisioned in “Star Trek.”

By ParisNeo
2022