import unittest

import requests


class TestUserInfosEndpoint(unittest.TestCase):
    def setUp(self):
        self.base_url = "http://127.0.0.1:9600"

    def test_user_infos_endpoint(self):
        print("Testing user_infos endpoint...")

        # Test valid path
        print("Testing valid path...")
        valid_path = "0dbb0245-7b6b-4834-835d-4d9d460b336c.png"
        response = requests.get(f"{self.base_url}/user_infos/{valid_path}")
        self.assertEqual(response.status_code, 200)
        print(f"Status code: {response.status_code} (expected: 200)\n")

        # Test path starting with a double slash
        print("Testing path starting with a double slash...")
        invalid_path = "//Windows/win.ini"
        response = requests.get(f"{self.base_url}/user_infos/{invalid_path}")
        print(f"Response content: {response.content}\n")
        self.assertEqual(response.status_code, 400)
        print(f"Status code: {response.status_code} (expected: 400)\n")

        # Test path containing suspicious patterns
        print("Testing path containing suspicious patterns...")
        suspicious_path = "../../etc/passwd"
        response = requests.get(f"{self.base_url}/user_infos/{suspicious_path}")
        print(f"Response content: {response.content}\n")
        self.assertEqual(response.status_code, 400)
        print(f"Status code: {response.status_code} (expected: 400)\n")


if __name__ == "__main__":
    unittest.main()
