# -*- coding: utf-8 -*-
# Generated by Django 1.10.8 on 2019-06-11 14:48
from __future__ import unicode_literals

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import jsonfield.fields
import uuid


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Analysis',
            fields=[
                ('date_added', models.DateTimeField(auto_now_add=True, null=True, verbose_name='date added')),
                ('date_modified', models.DateTimeField(auto_now=True, null=True, verbose_name='date modified')),
                ('uuid', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False, verbose_name='uuid')),
                ('title', models.CharField(blank=True, max_length=512, verbose_name='title')),
                ('description', models.TextField(blank=True, verbose_name='description')),
                ('is_public', models.BooleanField(default=True)),
                ('parameters_schema', jsonfield.fields.JSONField(default={'$schema': 'http://json-schema.org/schema#', 'properties': {}, 'type': 'object'})),
                ('author', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='analysis', to=settings.AUTH_USER_MODEL, verbose_name='author')),
            ],
            options={
                'verbose_name': 'Analysis',
                'verbose_name_plural': 'Analyses',
            },
        ),
        migrations.CreateModel(
            name='AnalysisTrack',
            fields=[
                ('date_added', models.DateTimeField(auto_now_add=True, null=True, verbose_name='date added')),
                ('date_modified', models.DateTimeField(auto_now=True, null=True, verbose_name='date modified')),
                ('uuid', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False, verbose_name='uuid')),
                ('title', models.CharField(blank=True, max_length=512, verbose_name='title')),
                ('description', models.TextField(blank=True, verbose_name='description')),
                ('is_public', models.BooleanField(default=True)),
                ('analysis', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='tracks', to='timeside_server.Analysis', verbose_name='analysis')),
                ('author', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='analysistrack', to=settings.AUTH_USER_MODEL, verbose_name='author')),
            ],
            options={
                'verbose_name': 'Analysis Track',
            },
        ),
        migrations.CreateModel(
            name='Annotation',
            fields=[
                ('date_added', models.DateTimeField(auto_now_add=True, null=True, verbose_name='date added')),
                ('date_modified', models.DateTimeField(auto_now=True, null=True, verbose_name='date modified')),
                ('uuid', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False, verbose_name='uuid')),
                ('title', models.CharField(blank=True, max_length=512, verbose_name='title')),
                ('description', models.TextField(blank=True, verbose_name='description')),
                ('is_public', models.BooleanField(default=True)),
                ('start_time', models.FloatField(default=0, verbose_name='start time (s)')),
                ('stop_time', models.FloatField(verbose_name='stop time (s)')),
                ('author', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='annotation', to=settings.AUTH_USER_MODEL, verbose_name='author')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='AnnotationTrack',
            fields=[
                ('date_added', models.DateTimeField(auto_now_add=True, null=True, verbose_name='date added')),
                ('date_modified', models.DateTimeField(auto_now=True, null=True, verbose_name='date modified')),
                ('uuid', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False, verbose_name='uuid')),
                ('title', models.CharField(blank=True, max_length=512, verbose_name='title')),
                ('description', models.TextField(blank=True, verbose_name='description')),
                ('is_public', models.BooleanField(default=True)),
                ('overlapping', models.BooleanField(default=False)),
                ('author', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='annotationtrack', to=settings.AUTH_USER_MODEL, verbose_name='author')),
            ],
            options={
                'verbose_name': 'Annotation Track',
            },
        ),
        migrations.CreateModel(
            name='Experience',
            fields=[
                ('date_added', models.DateTimeField(auto_now_add=True, null=True, verbose_name='date added')),
                ('date_modified', models.DateTimeField(auto_now=True, null=True, verbose_name='date modified')),
                ('uuid', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False, verbose_name='uuid')),
                ('title', models.CharField(blank=True, max_length=512, verbose_name='title')),
                ('description', models.TextField(blank=True, verbose_name='description')),
                ('is_public', models.BooleanField(default=True)),
                ('author', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='experience', to=settings.AUTH_USER_MODEL, verbose_name='author')),
                ('experiences', models.ManyToManyField(blank=True, related_name='other_experiences', to='timeside_server.Experience', verbose_name='other experiences')),
            ],
            options={
                'verbose_name': 'Experience',
            },
        ),
        migrations.CreateModel(
            name='Item',
            fields=[
                ('date_added', models.DateTimeField(auto_now_add=True, null=True, verbose_name='date added')),
                ('date_modified', models.DateTimeField(auto_now=True, null=True, verbose_name='date modified')),
                ('uuid', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False, verbose_name='uuid')),
                ('title', models.CharField(blank=True, max_length=512, verbose_name='title')),
                ('description', models.TextField(blank=True, verbose_name='description')),
                ('is_public', models.BooleanField(default=True)),
                ('source_file', models.FileField(blank=True, max_length=1024, upload_to=b'items/%Y/%m/%d', verbose_name='file')),
                ('source_url', models.URLField(blank=True, max_length=1024, verbose_name='URL')),
                ('audio_duration', models.FloatField(blank=True, null=True, verbose_name='duration')),
                ('sha1', models.CharField(blank=True, max_length=512, verbose_name='sha1')),
                ('mime_type', models.CharField(blank=True, max_length=256, verbose_name='mime type')),
                ('hdf5', models.FileField(blank=True, max_length=1024, upload_to=b'results/%Y/%m/%d', verbose_name='HDF5 result file')),
                ('lock', models.BooleanField(default=False)),
                ('external_uri', models.CharField(blank=True, max_length=1024, verbose_name='external_uri')),
                ('external_id', models.CharField(blank=True, max_length=256, verbose_name='external_id')),
                ('author', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='item', to=settings.AUTH_USER_MODEL, verbose_name='author')),
            ],
            options={
                'ordering': ['title'],
                'verbose_name': 'item',
            },
        ),
        migrations.CreateModel(
            name='Preset',
            fields=[
                ('date_added', models.DateTimeField(auto_now_add=True, null=True, verbose_name='date added')),
                ('date_modified', models.DateTimeField(auto_now=True, null=True, verbose_name='date modified')),
                ('uuid', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False, verbose_name='uuid')),
                ('is_public', models.BooleanField(default=True)),
                ('parameters', models.TextField(blank=True, default=b'{}', verbose_name='Parameters')),
                ('author', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='preset', to=settings.AUTH_USER_MODEL, verbose_name='author')),
            ],
            options={
                'verbose_name': 'Preset',
                'verbose_name_plural': 'Presets',
            },
        ),
        migrations.CreateModel(
            name='Processor',
            fields=[
                ('uuid', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False, verbose_name='uuid')),
                ('pid', models.CharField(max_length=128, unique=True, verbose_name='pid')),
                ('version', models.CharField(blank=True, max_length=64, verbose_name='version')),
                ('name', models.CharField(blank=True, max_length=256, verbose_name='name')),
            ],
            options={
                'verbose_name': 'processor',
            },
        ),
        migrations.CreateModel(
            name='Provider',
            fields=[
                ('uuid', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False, verbose_name='uuid')),
                ('name', models.CharField(blank=True, max_length=512, verbose_name='name')),
                ('description', models.TextField(blank=True, verbose_name='description')),
                ('pid', models.CharField(blank=True, max_length=128, unique=True, verbose_name='pid')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Result',
            fields=[
                ('date_added', models.DateTimeField(auto_now_add=True, null=True, verbose_name='date added')),
                ('date_modified', models.DateTimeField(auto_now=True, null=True, verbose_name='date modified')),
                ('uuid', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False, verbose_name='uuid')),
                ('is_public', models.BooleanField(default=True)),
                ('hdf5', models.FileField(blank=True, max_length=1024, upload_to=b'results/%Y/%m/%d', verbose_name='HDF5 result file')),
                ('file', models.FileField(blank=True, max_length=1024, upload_to=b'results/%Y/%m/%d', verbose_name='Output file')),
                ('mime_type', models.CharField(blank=True, max_length=256, verbose_name='Output file MIME type')),
                ('status', models.IntegerField(choices=[(0, 'failed'), (1, 'draft'), (2, 'pending'), (3, 'running'), (4, 'done')], default=1, verbose_name='status')),
                ('author', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='result', to=settings.AUTH_USER_MODEL, verbose_name='author')),
                ('item', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='results', to='timeside_server.Item', verbose_name='item')),
                ('preset', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='results', to='timeside_server.Preset', verbose_name='preset')),
            ],
            options={
                'verbose_name': 'Result',
                'verbose_name_plural': 'Results',
            },
        ),
        migrations.CreateModel(
            name='Selection',
            fields=[
                ('date_added', models.DateTimeField(auto_now_add=True, null=True, verbose_name='date added')),
                ('date_modified', models.DateTimeField(auto_now=True, null=True, verbose_name='date modified')),
                ('uuid', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False, verbose_name='uuid')),
                ('title', models.CharField(blank=True, max_length=512, verbose_name='title')),
                ('description', models.TextField(blank=True, verbose_name='description')),
                ('is_public', models.BooleanField(default=True)),
                ('author', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='selection', to=settings.AUTH_USER_MODEL, verbose_name='author')),
                ('items', models.ManyToManyField(blank=True, related_name='selections', to='timeside_server.Item', verbose_name='items')),
                ('selections', models.ManyToManyField(blank=True, related_name='other_selections', to='timeside_server.Selection', verbose_name='other selections')),
            ],
            options={
                'verbose_name': 'selection',
            },
        ),
        migrations.CreateModel(
            name='SubProcessor',
            fields=[
                ('uuid', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False, verbose_name='uuid')),
                ('sub_processor_id', models.CharField(max_length=128, unique=True, verbose_name='sub_processor_id')),
                ('name', models.CharField(blank=True, max_length=256, verbose_name='name')),
                ('processor', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='sub_results', to='timeside_server.Processor', verbose_name='processor')),
            ],
            options={
                'verbose_name': 'Subprocessor',
            },
        ),
        migrations.CreateModel(
            name='Task',
            fields=[
                ('date_added', models.DateTimeField(auto_now_add=True, null=True, verbose_name='date added')),
                ('date_modified', models.DateTimeField(auto_now=True, null=True, verbose_name='date modified')),
                ('uuid', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False, verbose_name='uuid')),
                ('is_public', models.BooleanField(default=True)),
                ('status', models.IntegerField(choices=[(0, 'failed'), (1, 'draft'), (2, 'pending'), (3, 'running'), (4, 'done')], default=1, verbose_name='status')),
                ('author', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='task', to=settings.AUTH_USER_MODEL, verbose_name='author')),
                ('experience', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='task', to='timeside_server.Experience', verbose_name='experience')),
                ('item', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='task', to='timeside_server.Item', verbose_name='item')),
                ('selection', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='task', to='timeside_server.Selection', verbose_name='selection')),
            ],
            options={
                'verbose_name': 'Task',
                'verbose_name_plural': 'Tasks',
            },
        ),
        migrations.AddField(
            model_name='preset',
            name='processor',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='presets', to='timeside_server.Processor', verbose_name='processor'),
        ),
        migrations.AddField(
            model_name='item',
            name='provider',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='timeside_server.Provider', verbose_name='provider'),
        ),
        migrations.AddField(
            model_name='experience',
            name='presets',
            field=models.ManyToManyField(blank=True, related_name='experiences', to='timeside_server.Preset', verbose_name='presets'),
        ),
        migrations.AddField(
            model_name='annotationtrack',
            name='item',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='annotation_tracks', to='timeside_server.Item', verbose_name='item'),
        ),
        migrations.AddField(
            model_name='annotation',
            name='track',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='annotations', to='timeside_server.AnnotationTrack', verbose_name='annotation'),
        ),
        migrations.AddField(
            model_name='analysistrack',
            name='item',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='analysis_tracks', to='timeside_server.Item', verbose_name='item'),
        ),
        migrations.AddField(
            model_name='analysis',
            name='preset',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='analysis', to='timeside_server.Preset', verbose_name='preset'),
        ),
        migrations.AddField(
            model_name='analysis',
            name='sub_processor',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='analysis', to='timeside_server.SubProcessor', verbose_name='sub_processor'),
        ),
    ]
