# Generated by Django 2.2 on 2020-02-05 15:18

from django.db import migrations, models
from django.utils.translation import ugettext_lazy as _

import django.db.models.deletion

from inspect import cleandoc

_FAILED, _DRAFT, _PENDING, _RUNNING, _DONE = 0, 1, 2, 3, 4

class Migration(migrations.Migration):

    dependencies = [
        ('timeside_server', '0007_auto_20191204_1146'),
    ]

    operations = [
        migrations.AlterField(
            model_name='experience',
            name='experiences',
            field=models.ManyToManyField(
                blank=True,
                help_text=_("Include other experiences in an experience."),
                related_name='other_experiences',
                to='timeside_server.Experience',
                verbose_name='other experiences'),
        ),
        migrations.AlterField(
            model_name='item',
            name='audio_duration',
            field=models.FloatField(
                blank=True,
                help_text=_("Duration of audio track."),
                null=True,
                verbose_name='duration'),
        ),
        migrations.AlterField(
            model_name='item',
            name='external_id',
            field=models.CharField(
                blank=True,
                help_text=_(cleandoc("""
                    Provider's id of the audio source.\n
                    e.g. for Deezer preview: 4763165\n
                    e.g. for YouTube: oRdxUFDoQe0
                    """)),
                max_length=256,
                verbose_name='external_id'),
        ),
        migrations.AlterField(
            model_name='item',
            name='external_uri',
            field=models.CharField(
                blank=True,
                help_text=_(cleandoc("""
                    Provider's URI of the audio source.\n
                    e.g. for Deezer preview: http://www.deezer.com/track/4763165\n
                    e.g. for YouTube: https://www.youtube.com/watch?v=oRdxUFDoQe0
                    """)),
                max_length=1024,
                verbose_name='external_uri'),
        ),
        migrations.AlterField(
            model_name='item',
            name='provider',
            field=models.ForeignKey(
                blank=True,
                help_text=_("Audio provider (e.g. Deezer, Youtube, etc.)"),
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                to='timeside_server.Provider',
                verbose_name='provider'),
        ),
        migrations.AlterField(
            model_name='item',
            name='source_file',
            field=models.FileField(
                blank=True,
                help_text=_("Audio file to process."),
                max_length=1024,
                upload_to='items/%Y/%m/%d',
                verbose_name='file'),
        ),
        migrations.AlterField(
            model_name='item',
            name='source_url',
            field=models.URLField(
                blank=True,
                help_text=_("URL of a streamable audio source to process."),
                max_length=1024,
                verbose_name='URL'),
        ),
        migrations.AlterField(
            model_name='provider',
            name='source_access',
            field=models.BooleanField(
                default=False,
                help_text=_(
                    "Whether or not the audio is "
                    "freely available from the provider."
                    ),
            ),
        ),
        migrations.AlterField(
            model_name='result',
            name='file',
            field=models.FileField(
                blank=True,
                help_text=_(cleandoc("""
                    Non numerical result stored in a file
                    (image, transcoded audio, etc.)
                    """)),
                max_length=1024,
                upload_to='results/%Y/%m/%d',
                verbose_name='Output file'),
        ),
        migrations.AlterField(
            model_name='result',
            name='hdf5',
            field=models.FileField(
                blank=True,
                help_text=_(
                    "Numerical result of the processing "
                    "stored in an hdf5 file."
                    ),
                max_length=1024,
                upload_to='results/%Y/%m/%d',
                verbose_name='HDF5 result file'),
        ),
        migrations.AlterField(
            model_name='result',
            name='item',
            field=models.ForeignKey(
                blank=True,
                help_text=_("Item on which a preset has been applied."),
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name='results',
                to='timeside_server.Item',
                verbose_name='item'),
        ),
        migrations.AlterField(
            model_name='result',
            name='preset',
            field=models.ForeignKey(
                blank=True,
                help_text=_("Preset applied on an item."),
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name='results',
                to='timeside_server.Preset',
                verbose_name='preset'),
        ),
        migrations.AlterField(
            model_name='result',
            name='run_time',
            field=models.DurationField(
                blank=True,
                help_text=_("Duration of the result computing."),
                null=True,
                verbose_name='Run time'),
        ),
        migrations.AlterField(
            model_name='result',
            name='status',
            field=models.IntegerField(
                choices=[
                    (0,
                     'failed'),
                    (1,
                     'draft'),
                    (2,
                     'pending'),
                    (3,
                     'running'),
                    (4,
                     'done')],
                default=1,
                help_text=_(cleandoc(f"""
                    Status of the task giving the result:\n
                    failed: {_FAILED}\n
                    draft: {_DRAFT}\n
                    pending: {_PENDING}\n
                    running: {_RUNNING}\n
                    done: {_DONE}
                    """)),
                verbose_name='status'),
        ),
        migrations.AlterField(
            model_name='selection',
            name='selections',
            field=models.ManyToManyField(
                blank=True,
                help_text=_("Include other selections in an selection."),
                related_name='other_selections',
                to='timeside_server.Selection',
                verbose_name='other selections'),
        ),
        migrations.AlterField(
            model_name='task',
            name='experience',
            field=models.ForeignKey(
                blank=True,
                help_text=_("Experience prossessed in the task."),
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name='task',
                to='timeside_server.Experience',
                verbose_name='experience'),
        ),
        migrations.AlterField(
            model_name='task',
            name='item',
            field=models.ForeignKey(
                blank=True,
                help_text=_("Single item prossessed in the task."),
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name='task',
                to='timeside_server.Item',
                verbose_name='item'),
        ),
        migrations.AlterField(
            model_name='task',
            name='selection',
            field=models.ForeignKey(
                blank=True,
                help_text=_("Selection prossessed in the task."),
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name='task',
                to='timeside_server.Selection',
                verbose_name='selection'),
        ),
        migrations.AlterField(
            model_name='task',
            name='status',
            field=models.IntegerField(
                choices=[
                    (0,
                     'failed'),
                    (1,
                     'draft'),
                    (2,
                     'pending'),
                    (3,
                     'running'),
                    (4,
                     'done')],
                default=1,
                help_text=_(cleandoc(f"""
                    Task's status:\n
                    failed: {_FAILED}\n
                    draft: {_DRAFT}\n
                    pending: {_PENDING}\n
                    running: {_RUNNING}\n
                    done: {_DONE}
                    """)),
                verbose_name='status'),
        ),
    ]
