#!/usr/bin/env bash
# This is the default entrypoint for the official Prefect Docker image

set -e

if [ -f ~/.bashrc ]; then
  . ~/.bashrc
fi

if [ ! -z "$EXTRA_PIP_PACKAGES" ]; then
  echo "+uv pip install $EXTRA_PIP_PACKAGES"
  uv pip install --system $EXTRA_PIP_PACKAGES > /tmp/pip_install.log 2>&1 || {
    uv_exit_code=$?
    cat /tmp/pip_install.log
    python -m prefect._internal.send_entrypoint_logs /tmp/pip_install.log
    exit $uv_exit_code
  }
fi

if [ -z "$*" ]; then
  echo "\
  ___ ___ ___ ___ ___ ___ _____ 
 | _ \ _ \ __| __| __/ __|_   _|
 |  _/   / _|| _|| _| (__  | |  
 |_| |_|_\___|_| |___\___| |_|  

"
  exec bash --login
else
  exec "$@"
fi
