import {
	rand,
	randAlphaNumeric,
	randPastDate,
	randUuid,
	randWord,
} from "@ngneat/falso";
import type { FlowRun } from "@/api/flow-runs";

export const createMockFlowRun = (overrides?: Partial<FlowRun>): FlowRun => ({
	id: randUuid(),
	created: randPastDate().toISOString(),
	updated: randPastDate().toISOString(),
	name: `${randWord()}-${randAlphaNumeric({ length: 6 }).join("").toLowerCase()}`,
	flow_id: randUuid(),
	state_id: randUuid(),
	deployment_id: randUuid(),
	work_queue_id: randUuid(),
	flow_version: "1.0.0",
	parameters: {},
	idempotency_key: randUuid(),
	context: {},
	empirical_policy: {
		max_retries: 0,
		retry_delay_seconds: 0,
		retries: 0,
		retry_delay: 0,
		pause_keys: [],
		resuming: false,
	},
	tags: [],
	parent_task_run_id: null,
	state_type: rand(["SCHEDULED", "PENDING", "RUNNING", "COMPLETED", "FAILED"]),
	run_count: 0,
	expected_start_time: randPastDate().toISOString(),
	next_scheduled_start_time: randPastDate().toISOString(),
	start_time: randPastDate().toISOString(),
	end_time: randPastDate().toISOString(),
	total_run_time: 0,
	estimated_run_time: 0,
	estimated_start_time_delta: 0,
	auto_scheduled: false,
	infrastructure_document_id: randUuid(),
	infrastructure_pid: null,
	created_by: null,
	state: {
		id: randUuid(),
		type: "COMPLETED",
		name: "Completed",
		timestamp: randPastDate().toISOString(),
		message: null,
		data: null,
		state_details: {
			flow_run_id: randUuid(),
			task_run_id: null,
			child_flow_run_id: null,
			scheduled_time: null,
			cache_key: null,
			cache_expiration: null,
			untrackable_result: false,
			pause_timeout: null,
			pause_reschedule: false,
			pause_key: null,
			refresh_cache: null,
			deferred: false,
		},
	},
	job_variables: null,
	...overrides,
});
