# Utils Directory

This directory contains utility functions and helper code.

## Utility Guidelines

- Keep utility functions pure and testable
- Focus on single responsibility
- Use TypeScript for type safety
- Use `lodash` utilities for string manipulation when appropriate

## Common Patterns

- Data formatting and transformation
- Validation helpers
- Common calculation functions
- Type guards and predicates
- Configuration and constants

## Code Style

- Avoid side effects in utility functions
- Make functions composable where possible
- Include comprehensive tests for utility functions
- Export utilities through `index.ts` files