---
name: Bug report
about: Create a report to help us improve LocalGPT
title: '[BUG] '
labels: 'bug'
assignees: ''

---

## 🐛 Bug Description
A clear and concise description of what the bug is.

## 🔄 Steps to Reproduce
1. Go to '...'
2. Click on '...'
3. Scroll down to '...'
4. See error

## ✅ Expected Behavior
A clear and concise description of what you expected to happen.

## ❌ Actual Behavior
A clear and concise description of what actually happened.

## 📸 Screenshots
If applicable, add screenshots to help explain your problem.

## 🖥️ Environment Information
**Desktop/Server:**
- OS: [e.g. macOS 13.4, Ubuntu 20.04, Windows 11]
- Python Version: [e.g. 3.11.5]
- Node.js Version: [e.g. 23.10.0]
- Ollama Version: [e.g. 0.9.5]
- Docker Version: [e.g. 24.0.6] (if using Docker)

**Browser (if web interface issue):**
- Browser: [e.g. Chrome, Safari, Firefox]
- Version: [e.g. 118.0.0.0]

## 📋 System Health Check
Please run `python system_health_check.py` and paste the output:

```
[Paste system health check output here]
```

## 📝 Error Logs
Please include relevant error messages or logs:

```
[Paste error logs here]
```

## 🔧 Configuration
- Deployment method: [Docker / Direct Python]
- Models used: [e.g. qwen3:0.6b, qwen3:8b]
- Document types: [e.g. PDF, DOCX, TXT]

## 📎 Additional Context
Add any other context about the problem here.

## 🤔 Possible Solution
If you have ideas for fixing the issue, please share them here. 