# awesome-fantasy [![Awesome](https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg)](https://github.com/sindresorhus/awesome)

> Fantasy literature worth reading

_Inspired by the [awesome](https://github.com/sindresorhus/awesome) list thing. For science fiction books, see [awesome-scifi](https://github.com/sindresorhus/awesome-scifi)._

_Please read the [Contributing Guidelines](contributing.md) before contributing._

## Contents

- [Novels](#novels)
  - [Epic Fantasy](#epic-fantasy)
  - [Standard Fantasy](#standard-fantasy)
  - [Allegory](#allegory)
  - [Satire](#satire)
  - [Horror](#horror)
  - [Children's Books](#childrens-books)
- [Comic books](#comic-books)
- [Movies](#movies)
- [TV Series](#tv-series)

## Novels

:star2: means that it's a classic.

:fire: means that it has more than 100,000 ratings on Goodreads.

_The [number] at the end is the rounded version of the rating on Goodreads. If a series is not available as an individual book, the first book in the series is used for the rating._

### Epic Fantasy

#### [A Song of Ice and Fire](https://www.goodreads.com/series/43790-a-song-of-ice-and-fire) _by [George R.R. Martin](https://en.wikipedia.org/wiki/George_R._R._Martin)_ [4.4] :fire:

Incredibly detailed books, with a very realistic world. I can't get enough of it. Awesome in the scale and breadth of intricacy. - [@RichardLitt](https://github.com/RichardLitt)

Books:

- [A Game of Thrones](http://www.goodreads.com/book/show/13496.A_Game_of_Thrones) :fire:
- [A Clash of Kings](http://www.goodreads.com/book/show/10572.A_Clash_of_Kings) :fire:
- [A Storm of Swords](http://www.goodreads.com/book/show/62291.A_Storm_of_Swords) :fire:
- [A Feast for Crows](http://www.goodreads.com/book/show/13497.A_Feast_for_Crows) :fire:
- [A Dance with Dragons](http://www.goodreads.com/book/show/10664113-a-dance-with-dragons) :fire:
- [Winds of Winter](http://www.goodreads.com/book/show/12111823-the-winds-of-winter) _forthcoming_

> Summers span decades. Winter can last a lifetime. And the struggle for the Iron Throne has begun.
>
> As Warden of the north, Lord Eddard Stark counts it a curse when King Robert bestows on him the office of the Hand. His honour weighs him down at court where a true man does what he will, not what he must … and a dead enemy is a thing of beauty.
>
> The old gods have no power in the south, Stark’s family is split and there is treachery at court. Worse, the vengeance-mad heir of the deposed Dragon King has grown to maturity in exile in the Free Cities. He claims the Iron Throne.

#### [Art of the Adept](https://www.goodreads.com/series/269818-art-of-the-adept) (2019) _by [Michael G. Manning](https://www.goodreads.com/author/show/5021072.Michael_G_Manning)_ [4.4]

A unique system of magic that follows the MC's learning journey so you discover all the wonder as well. - [@depperm](https://github.com/depperm)

Books:

- [The Choice of Magic](https://www.goodreads.com/book/show/51279226-the-choice-of-magic)
- [Secrets of Spellcraft](https://www.goodreads.com/book/show/52748703-secrets-and-spellcraft)
- [Scholar of Magic](https://www.goodreads.com/book/show/53497057-scholar-of-magic)
- [Disciple of War](https://www.goodreads.com/book/show/56329571-disciple-of-war)
- [The Wizard's Crown](https://www.goodreads.com/book/show/61167144-the-wizard-s-crown)

> The ancient magic of wizards was anything but dark. It was the enlightenment that lifted humanity from the squalor of superstition, and the worship of fell spirits and capricious gods, but those days are gone. The shining glory of the sorcerers burned away the subtlety of wisdom, replacing it with easy power, held only in the hands of the elite—a new age built upon the elemental supremacy of aristocrats and the ignorance of the masses.
>
>But this will change, for the greatest power comes with knowledge, and the deeper teachings of wizardry have not been utterly lost. The last wizard of the old tradition still survives in solitude, nursing tired grudges and waiting for death.
>
>His passing might have gone unnoticed, but for the imposition of a youth too stubborn to accept his refusal to take an apprentice. With a new student comes new hope, and that hope has caused old powers to stir again. That the world will change is inevitable, but the shape of the future is anything but certain.

#### [Black Company](https://www.goodreads.com/book/show/140671) (1984) _by [Glen Cook](https://en.wikipedia.org/wiki/Glen_Cook)_ [4]

This is my favorite dark fantasy series and the first book is awesome. These are written so differently than any fantasy-esque book I've ever read. It is difficult to describe, but as a veteran, it just feels like you're reading a fantasy book written by a former soldier that's been there, crude jokes, blood and all. I highly recommend this. - [@PeerRails](https://github.com/PeerRails)

> The series follows an elite mercenary unit, The Black Company, last of the Free Companies of Khatovar, through roughly forty years of its approximately four hundred-year history. Cook mixes fantasy with military fiction in gritty, down-to-earth portrayals of the Company‘s chief personalities and its struggles.

Books:

- [The Black Company](https://www.goodreads.com/book/show/140671.The_Black_Company) [3.96]
- [Shadows Linger](https://www.goodreads.com/book/show/400881.Shadows_Linger) [4.16]
- [The White Rose](https://www.goodreads.com/book/show/400906.The_White_Rose) [4.19]
- [Shadow Games](https://www.goodreads.com/book/show/113540.Shadow_Games) [4.09]
- [Dreams of Steel](https://www.goodreads.com/book/show/400900.Dreams_of_Steel) [4.09]
- [Bleak Seasons](https://www.goodreads.com/book/show/400911.Bleak_Seasons) [3.95]
- [She Is The Darkness](https://www.goodreads.com/book/show/400897.She_is_the_Darkness) [4.10]
- [Water Sleeps](https://www.goodreads.com/book/show/349470.Water_Sleeps) [4.07]
- [Soldiers Live](https://www.goodreads.com/book/show/400899.Soldiers_Live) [4.22]
- _1 last book coming_

#### [Children of Húrin](http://www.goodreads.com/book/show/821431.The_Children_of_H_rin) _by [J.R.R. Tolkien](https://en.wikipedia.org/wiki/J._R._R._Tolkien)_ [3.9]

The Lord of the Rings is a quest; the Hobbit a children's tale; the Silmarillion a history. This is one of the few novels, a story that shows the life of a tortured individual. This story borrows heavily from Scandinavian lore, and presents Turin as one of the most tragic of all of Tolkien's creations. It is my favourite story from all of his books, and I think it has the most advanced and beautiful look into the world of Middle Earth as a whole. - [@RichardLitt](https://github.com/RichardLitt)

> There are tales of Middle-earth from times long before The Lord of the Rings, and the story told in this book is set in the great country that lay beyond the Grey Havens in the West: lands where Treebeard once walked, but which were drowned in the great cataclysm that ended the First Age of the World.
>
> In that remote time Morgoth, the first Dark Lord, dwelt in the vast fortress of Angband, the Hells of Iron, in the North; and the tragedy of Túrin and his sister Nienor unfolded within the shadow of the fear of Angband and the war waged by Morgoth against the lands and secret cities of the Elves.
>
> Their brief and passionate lives were dominated by the elemental hatred that Morgoth bore them as the children of Húrin, the man who had dared to defy and to scorn him to his face. Against them he sent his most formidable servant, Glaurung, a powerful spirit in the form of a huge wingless dragon of fire. Into this story of brutal conquest and flight, of forest hiding-places and pursuit, of resistance with lessening hope, the Dark Lord and the Dragon enter in direly articulate form. Sardonic and mocking, Glaurung manipulated the fates of Túrin and Nienor by lies of diabolic cunning and guile, and the curse of Morgoth was fulfilled.
>
> The earliest versions of this story by J.R.R. Tolkien go back to the end of the First World War and the years that followed; but long afterwards, when The Lord of the Rings was finished, he wrote it anew and greatly enlarged it in complexities of motive and character: it became the dominant story in his later work on Middle-earth. But he could not bring it to a final and finished form. In this book Christopher Tolkien has constructed, after long study of the manuscripts, a coherent narrative without any editorial invention.

#### [Chronicles of the Unhewn Throne](https://www.goodreads.com/series/116397-chronicle-of-the-unhewn-throne) (2014) _by [Brian Staveley](https://en.wikipedia.org/wiki/Brian_Staveley)_ [4.1]

An assassin, a monk, and an heiress. While only one of these characters interested me from the description, each story pulled me in. - [@depperm](https://github.com/depperm)

Books:

- [The Emperor's Blades](https://www.goodreads.com/book/show/17910124-the-emperor-s-blades)
- [The Providence of Fire](https://www.goodreads.com/book/show/24450384-the-providence-of-fire)
- [The Last Mortal Bond](https://www.goodreads.com/book/show/27565716-the-last-mortal-bond)

> The circle is closing. The stakes are high. And old truths will live again...
>
>The Emperor has been murdered, leaving the Annurian Empire in turmoil. Now his progeny must bury their grief and prepare to unmask a conspiracy.
>
>His son Valyn, training for the empire’s deadliest fighting force, hears the news an ocean away. He expected a challenge, but after several ‘accidents’ and a dying soldier’s warning, he realizes his life is also in danger. Yet before Valyn can take action, he must survive the mercenaries’ brutal final initiation.
>
>Meanwhile, the Emperor’s daughter, Minister Adare, hunts her father’s murderer in the capital itself. Court politics can be fatal, but she needs justice. And Kaden, heir to an empire, studies in a remote monastery. Here, the Blank God’s disciples teach their harsh ways – which Kaden must master to unlock their ancient powers. When an imperial delegation arrives, he’s learnt enough to perceive evil intent. But will this keep him alive, as long-hidden powers make their move?

#### [Codex Alera](https://www.goodreads.com/series/45545-codex-alera) (2005) _by [Jim Butcher](https://en.wikipedia.org/wiki/Jim_Butcher)_ [4.28] 🔥

A great series that is a little different from your typical epic fantasy. In this world, everyone has powers, or elemental furies attached to them, except for Tavi, the main character. - [@cary-williams](https://github.com/cary-williams)

Books:

1. [Furies of Calderon](https://www.goodreads.com/book/show/29396.Furies_of_Calderon) [4.10] 🔥
2. [Academ's Fury](https://www.goodreads.com/book/show/133664.Academ_s_Fury) [4.22]
3. [Cursor's Fury](https://www.goodreads.com/book/show/29394.Cursor_s_Fury) [4.31]
4. [Captain's Fury](https://www.goodreads.com/book/show/346087.Captain_s_Fury) [4.31]
5. [Princeps' Fury](https://www.goodreads.com/book/show/2903736-princeps-fury) [4.37]
6. [First Lord's Fury](https://www.goodreads.com/book/show/6316821-first-lord-s-fury) [4.39]

> Welcome to the Realm of Alera, traveler. Written by the #1 New York Times bestselling author Jim Butcher, the Codex Alera follows the adventures—and misadventures!—of a young man, Tavi of Calderon. In a land where everyone has access to great powers called furies, being the only one without a fury to his name can be tricky, but Tavi proves time and time again that it is not all about your furies.

#### [Cradle](https://www.goodreads.com/series/192821-cradle) (2016) _by [Will Wight](https://en.wikipedia.org/wiki/Will_Wight)_ [4.1]

While many western themed novels have superheroes or powerful magicians, equally pleasing to read is eastern style novels with cultivators. If you're interested in seeing how it compares with _standard fantasy_ this is a great series to get started with. - [@depperm](https://github.com/depperm)

> Sacred artists follow a thousand Paths to power, using their souls to control the forces of the natural world.
>
>Lindon is Unsouled, forbidden to learn the sacred arts of his clan.
>
>When faced with a looming fate he cannot ignore, he must defy his family's rules...and forge his own Path.

#### [Deltora Quest Series](https://www.goodreads.com/series/41221-deltora-quest) (2000) _by [Emily Rodda](https://www.goodreads.com/author/show/3995.Emily_Rodda)_ [3.98]

My favorite book series and one of the best series I've ever read. The books are exceptionally well written, easy and fast to read. Great for readers in the 12 to 15 age group, but it can also catch the eye of older readers, just like mine. I'm look forward to reading your sequels: Deltora Shadowlands and Dragons of Deltora. - [@AmandaPita] (https://github.com/AmandaPita)

Books:

- [The Forests of Silence](https://www.goodreads.com/book/show/155238.The_Forests_of_Silence)
- [The Lake of Tears](https://www.goodreads.com/book/show/119494.The_Lake_of_Tears)
- [City of the Rats](https://www.goodreads.com/book/show/119493.City_of_the_Rats)
- [The Shifting Sands](https://www.goodreads.com/book/show/119490.The_Shifting_Sands)
- [Dread Mountain](https://www.goodreads.com/book/show/119495.Dread_Mountain)
- [The Maze of the Beast](https://www.goodreads.com/book/show/119489.The_Maze_of_the_Beast)
- [The Valley of the Lost](https://www.goodreads.com/book/show/119492.The_Valley_of_the_Lost)
- [Return to Del](https://www.goodreads.com/book/show/119491.Return_to_Del)

> For centuries, the evil Shadow Lord has been plotting to invade Deltora and enslave its people. All that stands in his way is the magic Belt of Deltora with its seven gems of great and mysterious power. Now, Leif, Barda, and Jasmine must unite to find the seven gems and save Deltora from an eternity of darkness.

#### [Dune](https://www.goodreads.com/series/45935-dune-chronicles) _by [Frank Herbert](https://en.wikipedia.org/wiki/Frank_Herbert)_

There's elements of fantasy in here, although it is mostly science fiction. The elements they have - the power of words, the _bene gesserit_, the worms - are all, indubitably, awesome. - [@RichardLitt](https://github.com/RichardLitt)

Books:

- [Dune](https://www.goodreads.com/book/show/234225.Dune) [4.2]
- [Dune Messiah](https://www.goodreads.com/book/show/106.Dune_Messiah) [3.8]
- [Children of Dune](https://www.goodreads.com/book/show/112.Children_of_Dune) [3.9]
- _And others that I haven't read..._

#### [Earthsea](https://en.wikipedia.org/wiki/Earthsea) _by [Ursula K. Le Guin](https://en.wikipedia.org/wiki/Ursula_K._Le_Guin)_

This is fantasy and magic done exceedingly well. These read like children stories - not in their style or content, which are very adult - but in the massive expanse of the world that you start to imagine, the way the stories run off the page and away with you. I can't praise it enough. - [@RichardLitt](https://github.com/RichardLitt)

Books:

- [A Wizard of Earthsea](https://www.goodreads.com/book/show/13642.A_Wizard_of_Earthsea) [4.0]
- [The Tombs of Atuan](https://www.goodreads.com/book/show/13662.The_Tombs_of_Atuan) [4.1]
- [The Farthest Shore](https://www.goodreads.com/book/show/13667.The_Farthest_Shore) [4.1]
- [Tehanu: The Last Book of Earthsea](https://www.goodreads.com/book/show/13661.Tehanu) [3.8]
- [Tales from Earthsea](https://www.goodreads.com/book/show/13659.Tales_from_Earthsea) [4.0]
- [The Other Wind](https://www.goodreads.com/book/show/13658.The_Other_Wind) [4.0]

#### [Elantris](https://www.goodreads.com/book/show/68427.Elantris) (2005) _by [Brandon Sanderson](https://en.wikipedia.org/wiki/Brandon_Sanderson)_ [4.17] 🔥

This is a beautiful but somewhat slow paced book with really good world building that we have come to expect and love from Brandon Sanderson. If you are not sure to read it because it's his first book, have no fear!!! Go ahead and read it, I can assure you, you will not regret it. - [@Shadeslayer234](https://github.com/Shadeslayer234)

> Elantris was the capital of Arelon: gigantic, beautiful, literally radiant, filled with benevolent beings who used their powerful magical abilities for the benefit of all. Yet each of these demigods was once an ordinary person until touched by the mysterious transforming power of the Shaod. Ten years ago, without warning, the magic failed. Elantrians became wizened, leper-like, powerless creatures, and Elantris itself dark, filthy, and crumbling.
> Arelon's new capital, Kae, crouches in the shadow of Elantris. Princess Sarene of Teod arrives for a marriage of state with Crown Prince Raoden, hoping—based on their correspondence—to also find love. She finds instead that Raoden has died and she is considered his widow. Both Teod and Arelon are under threat as the last remaining holdouts against the imperial ambitions of the ruthless religious fanatics of Fjordell. So Sarene decides to use her new status to counter the machinations of Hrathen, a Fjordell high priest who has come to Kae to convert Arelon and claim it for his emperor and his god.
> But neither Sarene nor Hrathen suspect the truth about Prince Raoden. Stricken by the same curse that ruined Elantris, Raoden was secretly exiled by his father to the dark city. His struggle to help the wretches trapped there begins a series of events that will bring hope to Arelon, and perhaps reveal the secret of Elantris itself.
> A rare epic fantasy that doesn't recycle the classics and that is a complete and satisfying story in one volume, Elantris is fleet and fun, full of surprises and characters to care about. It's also the wonderful debut of a welcome new star in the constellation of fantasy.

#### [Harry Potter](https://en.wikipedia.org/wiki/Harry_Potter) _by [J.K. Rowling](https://en.wikipedia.org/wiki/J._K._Rowling)_

These are amusing, and relevant for their cultural impact if not for the caliber of the writing. - [@RichardLitt](https://github.com/RichardLitt)

Books:

1. [Harry Potter and the Philosopher's Stone](https://www.goodreads.com/book/show/3.Harry_Potter_and_the_Sorcerer_s_Stone) [4.4]
2. [Harry Potter and the Chamber of Secrets](https://www.goodreads.com/book/show/15881.Harry_Potter_and_the_Chamber_of_Secrets) [4.3]
3. [Harry Potter and the Prisoner of Azkaban](https://www.goodreads.com/book/show/5.Harry_Potter_and_the_Prisoner_of_Azkaban) [4.5]
4. [Harry Potter and the Goblet of Fire](https://www.goodreads.com/book/show/6.Harry_Potter_and_the_Goblet_of_Fire) [4.5]
5. [Harry Potter and the Order of the Phoenix](https://www.goodreads.com/book/show/2.Harry_Potter_and_the_Order_of_the_Phoenix) [4.4]
6. [Harry Potter and the Half-Blood Prince](https://www.goodreads.com/book/show/1.Harry_Potter_and_the_Half_Blood_Prince) [4.5]
7. [Harry Potter and the Deathly Hallows](https://www.goodreads.com/book/show/136251.Harry_Potter_and_the_Deathly_Hallows) [4.6]

> The novels revolve around Harry Potter, an orphan who discovers at the age of 11 that he is a wizard, who lives within the ordinary world of non-magical people, known as Muggles. The wizarding world is secret from the Muggle world, presumably to avoid persecution of witches and wizards. His ability is inborn, and such children are invited to attend an exclusive magic school that teaches the necessary skills to succeed in the wizarding world. Harry becomes a student at Hogwarts School of Witchcraft and Wizardry, and it is here where most of the events in the series take place. As Harry develops through his adolescence, he learns to overcome the problems that face him: magical, social and emotional, including ordinary teenage challenges such as friendships, infatuation and exams, and the greater test of preparing himself for the confrontation in the real world that lies ahead.
>
> Each book chronicles one year in Harry's life with the main narrative being set in the years 1991–98. The books also contain many flashbacks, which are frequently experienced by Harry viewing the memories of other characters in a device called a Pensieve.
>
> The environment Rowling created is completely separate from reality yet also intimately connected to it. While the fantasy land of Narnia is an alternative universe and the Lord of the Rings‍ '​ Middle-earth a mythic past, the wizarding world of Harry Potter exists in parallel within the real world and contains magical versions of the ordinary elements of everyday life. Many of its institutions and locations are recognizable, such as London. It comprises a fragmented collection of overlooked hidden streets, ancient pubs, lonely country manors and secluded castles that remain invisible to the Muggle population.

#### [Temeraire](https://www.goodreads.com/series/43272-temeraire) (2006) _by [Naomi Novik](https://en.wikipedia.org/wiki/Naomi_Novik)_ [4.06]

Historical fiction is an interesting niche. It brings in names, places, and events I've heard of but adds in dragons without completely annihilating the history. If you are a fan of Powder Mage series, this has a similar feel but with less magic and more dragons. - [@depperm](https://github.com/depperm)

Books:

- His Majesty's Dragon
- Throne of Jade
- Black Powder War
- Empire of Ivory
- Victory of Eagles
- Tongues of Serpents
- Crucible of Gold
- Blood of Tyrants
- League of Dragons

> Aerial combat brings a thrilling new dimension to the Napoleonic Wars as valiant warriors ride mighty fighting dragons, bred for size or speed. When HMS Reliant captures a French frigate and seizes the precious cargo, an unhatched dragon egg, fate sweeps Captain Will Laurence from his seafaring life into an uncertain future – and an unexpected kinship with a most extraordinary creature. Thrust into the rarified world of the Aerial Corps as master of the dragon Temeraire, he will face a crash course in the daring tactics of airborne battle. For as France’s own dragon-borne forces rally to breach British soil in Bonaparte’s boldest gambit, Laurence and Temeraire must soar into their own baptism of fire.

#### [Mistborn](https://en.wikipedia.org/wiki/Mistborn_series) _by [Brandon Sanderson](https://en.wikipedia.org/wiki/Brandon_Sanderson)_ [4.4]

The Mistborn trilogy (well, he plans on doing a trilogy of trilogies, and the last 2 of the 2nd trilogy are due out in the next year or so) is probably his best known and a great read, too. I would recommend all of his stuff, but I think the original Mistborn is probably the best place to start (for one, they're much shorter!). - [@CWSpear](https://github.com/CWSpear)

I've only read the first trilogy at this point, but I loved it; the magic system is pretty well done, the characters are convincing, we've got some strong female leads, and there's a good amount of intrigue and plot setting. Brandon Sanderson is fairly good at turning tropes on their head, as well, which was fun to read - a lot of my original complaints have now turned into praises for the books. I'm looking forward to reading more. - [@RichardLitt](https://github.com/RichardLitt)

I have read the first six books and will continue reading every book in this series...and probably everything Sanderson writes. The Mistborn stories are well crafted and interesting. There is so much going on as they also fit into Sanderson's Cosmere which means characters from other worlds occasionally interact with those from Scadrial - the world where these novels are based. I find every story to be expertly paced, never leaving a lull in the momentum, I have had friends say they found the sixth book, Bands of Mourning, to be a little slow but I didn't have the same view. Every novel is well rounded, leaving plenty unsaid and undiscovered but never robbing the reader of a complete or resolved story.

The first trilogy introduces us to a strange and spectacular world: one where there is magic, intrigue, social/economic inequality and, possibly my favorite thing, different races of people that inhabit this world.

The second trilogy takes place some 300 years after the events of the first, and many of these events have filtered through into the 'modern' day Scadrial (it has a very old western feel to the whole setting); such as cities named after hero's, religions based on characters and many little secrets that are still unanswered from the first trilogy. We are introduced to a whole batch of new characters and some not so new characters - I won't say more otherwise I may give too much away.

Would recommend this entire series and the whole Cosmere to any fantasy fan. - [@SeanSWatkins](https://github.com/SeanSWatkins)

> The first three books are a trilogy to be read together.
>
> Mistborn is an epic fantasy trilogy and a heist story of political intrigue, surprises and magical martial-arts action. The saga dares to turn a genre on its head by asking a simple question: What if the hero of prophecy fails? What kind of world results when the Dark Lord is in charge?
>
> Books 4-7 are sequels that take place 300 years later.

Books:

- [The Final Empire](https://www.goodreads.com/book/show/68428.The_Final_Empire) [4.4]
- [The Well of Ascension](https://www.goodreads.com/book/show/68429.The_Well_of_Ascension) [4.3]
- [The Hero of Ages](https://www.goodreads.com/book/show/2767793-the-hero-of-ages) [4.4]
- [The Alloy of Law](https://www.goodreads.com/book/show/10803121-the-alloy-of-law) [4.2]
- [Shadows of Self](https://www.goodreads.com/book/show/16065004-shadows-of-self) [4.2]
- [The Bands of Mourning](https://www.goodreads.com/book/show/18739426-the-bands-of-mourning) [4.2]
- [The Lost Metal](https://www.goodreads.com/book/show/23947089-the-lost-metal) [4.5]

#### [Mother of Learning](https://www.goodreads.com/series/336405-mother-of-learning) (2021) _by [Domagoj Kurmaic](https://www.goodreads.com/author/show/14128815.Domagoj_Kurmai_)_ [4.5]

Ground hog day combined with magician school turns out to be pretty interesting. Throw in some mind spiders, liches, and magical beasts and things get more interesting. - [@depperm](https://github.com/depperm)

> A teenage mage of humble birth and slightly above-average skill, Zorian is attending his third year of education at Cyoria's magical academy. A driven and quiet young man, he is consumed by a desire to ensure his own future and free himself of the influence of his family, resenting the Kazinskis for favoring his brothers over him. Consequently, Zorian has no time for pointless distractions, much less other people's problems.
>
>As it happens, though, time is something he is about to get plenty of.
>
>On the eve of Cyoria's annual summer festival, Zorian is murdered, then abruptly brought back to the beginning of the month, just before he was about to take the train to school. Finding himself trapped in a time loop with no clear end or exit, he will have to look both within and without to unravel the mystery set before him. He does have to unravel it, too, because the loop clearly wasn’t made for his sake, and in a world of magic even a time traveler isn't safe from those who wish him ill.

#### [Percy Jackson](https://en.wikipedia.org/wiki/Percy_Jackson_%26_the_Olympians) _by [Rick Riordan](https://en.wikipedia.org/wiki/Rick_Riordan)_

These are really amazing and fun to read, especially the characters and how it relates with Greek mythology. - [@ankush1024](https://github.com/ankush1024)

Books:

1. [The Lightning Thief](https://www.goodreads.com/book/show/28187.The_Lightning_Thief) [4.3]
2. [The Sea of Monsters](https://www.goodreads.com/book/show/28186.The_Sea_of_Monsters) [4.4]
3. [The Titan's Curse](https://www.goodreads.com/book/show/561456.The_Titan_s_Curse) [4.4]
4. [The Battle of the Labyrinth](https://www.goodreads.com/book/show/2120932.The_Battle_of_the_Labyrinth) [4.4]
5. [The Last Olympian](https://www.goodreads.com/book/show/4556058-the-last-olympian) [4.5]

> The novels revolves around Percy Jackson, who is a demigod whose father is Poseidon, God of the Sea and the quests he follows to save the world from the war between gods.
>
> The series feel fresh and new from the eyes of these young modern heroes. From the first novel, the plot is engaging and exciting, appealing to anyone who's ever felt like they didn't belong. Between all of the action, magic and riddles, it's a truly heart-warming story about finding friends who eventually become family, and houses that eventually become homes.

#### [Redwall](https://www.goodreads.com/series/40340-redwall) (1986) _by [Brian Jacques](https://en.wikipedia.org/wiki/Brian_Jacques)_ [4.1] :fire:

While targeted towards a slightly younger audience, this series has length and depth that many other fantasy series lack. Characters are animals living in a medievalesque world that works quite well. - [@depperm](https://github.com/depperm)

The best descriptions of food in any books ever. - [@RichardLitt](https://github.com/RichardLitt)

Books:

- [Redwall](https://www.goodreads.com/book/show/20209935-redwall) [4.1] :fire:
- [Mossflower](https://www.goodreads.com/book/show/19473270-mossflower) [4.1]
- [Mattimeo](https://www.goodreads.com/book/show/19300221-mattimeo) [4.1]
- [Mariel](https://www.goodreads.com/book/show/20189089-mariel-of-redwall) [4.1]
- ... 21 total

> Redwall Abbey, tranquil home to a community of peace-loving mice, is threatened by the evil, one-eyed rat warlord Cluny the Scourge and his battle-hardened horde of predators.
>
>Cluny is certain that Redwall will fall easily to his fearsome army but he hasn't bargained for the courage and strength of the Redwall mice and their loyal woodland friends

#### [The Belgariad](https://www.goodreads.com/book/show/44660.The_Belgariad_Boxed_Set?ac=1&from_search=true&qid=wv9xaSskqn&rank=3) _by [David Eddings](https://en.wikipedia.org/wiki/David_Eddings)_ [4.3] :star2:

The Belgariad was my first foray into an epic series and I was hooked from the start because of the characters, humor, and adventure created by David and Leigh Eddings. The series starts with Pawn of Prophecy and spans a total of 16 novels each as well developed as the one before. Inspired by the continued printing of Lord of the Rings, Eddings created the Belgariad as a trilogy, but was eventually convinced by the publisher to print it as a series of five books. The story continues on in the equally as developed 5-book series known as the [Mallorean](https://www.goodreads.com/series/42429-the-malloreon). - [@codercarly](https://github.com/codercarly)

Books:

- [Pawn of Prophecy](https://www.goodreads.com/book/show/44659.Pawn_of_Prophecy)
- [Queen of Sorcery](https://www.goodreads.com/book/show/587582.Queen_of_Sorcery)
- [Magician's Gambit](https://www.goodreads.com/book/show/44688.Magician_s_Gambit)
- [Castle of Wizardry](https://www.goodreads.com/book/show/645023.Castle_of_Wizardry)
- [Enchanters End Game](https://www.goodreads.com/book/show/44687.Enchanters_End_Game)

> It all begins with the theft of the Orb that for so long protected the West from an evil god. As long as the Orb was at Riva, the prophecy went, its people would be safe from this corrupting power. Garion, a simple farm boy, is familiar with the legend of the Orb, but skeptical in matters of magic. Until, through a twist of fate, he learns not only that the story of the Orb is true, but that he must set out on a quest of unparalleled magic and danger to help recover it. For Garion is a child of destiny, and fate itself is leading him far from his home, sweeping him irrevocably toward a distant tower-and a cataclysmic confrontation with a master of the darkest magic. The quest may be nearing its end, but the danger continues. After discovering a shocking secret about himself he never could have imagined-all in pursuit of the legendary Orb-Garion and his fellow adventurers must escape a crumbling enemy fortress and flee across a vast desert filled with ruthless soldiers whose only aim is to destroy them. But even when the quest is complete, Garion's destiny is far from fulfilled. For the evil God Torak is about to awaken and seek dominion. Somehow, Garion has to face the God, to kill or be killed. On the outcome of this dread duel rests the future of the world. But how can one man destroy an immortal God?

#### [The Book of the New Sun](https://www.goodreads.com/series/41474-the-book-of-the-new-sun) _by [Gene Wolfe](https://en.wikipedia.org/wiki/Gene_Wolfe)_ [4.1] :star2:

My favourite book series of all time. Severian is an unreliable narrator, as he remembers everything. But he lies to you, and you slowly start to realise it. The fifth book, which was added later to the other four (mostly sold as two books), has the most unexpected revelations that make a rereading entirely necessary. This series is incredible. - [@RichardLitt](https://github.com/RichardLitt)

Books:

- [Shadow and Claw](http://www.goodreads.com/book/show/40992.Shadow_Claw)
- [Sword and Citadel](http://www.goodreads.com/book/show/40995.Sword_and_Citadel)
- [Urth of the New Sun](http://www.goodreads.com/book/show/60215.The_Urth_of_the_New_Sun)

> Recently voted the greatest fantasy of all time, after The Lord of the Rings and The Hobbit, Gene Wolfe's The Book of the New Sun is an extraordinary epic, set a million years in the future, on an Earth transformed in mysterious and wondrous ways, in a time when our present culture is no longer even a memory. Severian, the central character, is a torturer, exiled from his guild after falling in love with one of his victims, and journeying to the distant city of Thrax, armed with his ancient executioner's sword, Terminus Est. This edition contains the second two volumes of this four volume novel, The Sword of the Lictor and The Citadel of the Autarch.

#### [The Chronicles of Amber](https://www.goodreads.com/book/show/5367.The_Great_Book_of_Amber) _by [Roger Zelazny](https://en.wikipedia.org/wiki/Roger_Zelazny)_ [4.3]

In truth, this is ten books, but they aren't stand-alone. I would call this two series: the Corwin series of the first five books, and the Merlin series of the second.

Like most high fantasy, I didn't so much read these books as devour them. The series was excellent. Corwin's story is the story within all of us; a desire to be loved, to make sense of the world, to win back the castle from the evil usurper. Amber - the city upon which all other cities are but a shadow. Like CS Lewis, this earth is only a shadow of the real earth. Corwin is one of my favourite characters from a fantasy series; it's not often that you get to talk to someone who was a soldier in Napolean's army, who knew Van Gogh, who remembers Paris at the turn of the century (his section on the chestnuts is exquisite).

There is so much good writing, so many beautiful places, that it is almost impossible to remember it all. Reading this book wasn't so much reading as being transported to faery for a day. I remember feeling totally at a loss after reading one afternoon, as if I had been transported; the next day, on top of a mountain, I had the exact same feeling, that I was somewhere else. Reading these books gave me the greatest joy that a book can give - being lost in another world. - [@RichardLitt](https://github.com/RichardLitt)

> Roger Zelazny's chronicles of Amber have earned their place as all-time classics of imaginative literature. Now, here are all ten novels, together in one magnificent omnibus volume. Witness the titanic battle for supremacy waged on Earth, in the Courts of Chaos, and on a magical world of mystery, adventure and romance.

#### [The Chronicles of Prydain](https://en.wikipedia.org/wiki/The_Chronicles_of_Prydain) 1964 _by [Lloyd Alexander](https://en.wikipedia.org/wiki/Lloyd_Alexander)_ [4.42]

The Chronicles of Prydain encapsulates what I deem to be a perfect fantasy series for young adults. The overarching theme of the series is the triumph of good over evil as the protagonist grapples with pain, betrayal, love, and other classic tropes in fantasy literature. Alexander's profound compassion is what makes "The Chronicles of Prydain" such an enduring thrill. The action is engaging enough for young children, but the principles it reveals are profound enough to resound with the reader at every stage of life. - [@lin-dsey](https://github.com/lin-dsey)

Books:

- [The Book of Three](https://www.goodreads.com/book/show/24780.The_Book_of_Three)
- [The Black Cauldron](https://www.goodreads.com/book/show/24784.The_Black_Cauldron)
- [The Castle of Llyr](https://www.goodreads.com/book/show/24779.The_Castle_of_Llyr)
- [Taran Wanderer](https://www.goodreads.com/book/show/24782.Taran_Wanderer)
- [The High King](https://www.goodreads.com/book/show/24781.The_High_King)

> The five novels take place in Prydain, a fictional country ruled by a High King who oversees several minor kingdoms. The setting is based on Wales and inhabited by creatures and characters inspired by Welsh mythology and folklore. The series follows the protagonist Taran, a youth of unknown parentage living on a farm with an old enchanter named Dallben and a farmer named Coll. Taran, who dreams of being a great hero, is named "Assistant Pig-Keeper" and tasked with helping to care for and protect Hen Wen, a white oracular pig magically empowered with clairvoyance. Taran has a series of adventures wherein he helps protect the land of Prydain from various threats, chief among them the evil Arawn, whose forces include an undead army known as the Cauldron-Born. Throughout the novels, Taran's major companions are the Princess Eilonwy, the bard Fflewddur Fflam, the wild beast-man Gurgi, and the dwarf Doli. The heroes frequently work alongside the Fair Folk (a society of elves and similar beings) and the warriors known as the Sons of Don. Along with various battles against forces of evil, the novels focus on Taran's journey of maturity.

#### [The Daevabad Trilogy](https://www.goodreads.com/series/211584-the-daevabad-trilogy) 2017 _by[S. A. Chakraborty](https://en.wikipedia.org/wiki/S._A._Chakraborty)_[4.3]

This series is sumptuous. It follows Nahri as she leaves her hum-drum life in Egypt for a life of adventure, danger, and romance. It all starts when she plays with magic she doesn't understand and ends up summoning a djinn. This is truly an epic work as it spans three books, the final volume weighing in at nearly 800 pages. The world building is wonderful and reading a fantasy based on eastern magic and mythology was a welcome change for me among so many fantasies that seem more European-based. I looked forward to both sequels as they came out and finished reading the final installment without even realizing I had read over 700 pages because I read it on a Kindle! 

One of my favorite parts of the books was the unique perspective brought by each of the characters. Although the story starts off with Nahri and I would call her THE main character, it is written with other views as well. Each character had a distinctive voice. I find this to be a sprawling story in the best sense. - [@novemberhaiku](https://github.com/novemberhaiku)

Books:

- [The City of Brass](https://www.goodreads.com/book/show/32718027-the-city-of-brass)
- [The Kingdom of Copper](https://www.goodreads.com/book/show/39988431-the-kingdom-of-copper)
- [The Empire of Gold](https://www.goodreads.com/book/show/52166786-the-empire-of-gold)

>In the Daevabad Trilogy, S. A. Chakraborty builds an astounding world full of magic and conflict. Nahri begins as a grifter in Egypt, but accidentally summons a djinn who unwillingly introduces her to a world of magic and the city he once called home. Its history is dark and its future uncertain as Nahri discovers who she really is and how she can change the world of the djinn.

#### [The Deed of Paksenarrion](https://www.goodreads.com/book/show/96281.The_Deed_of_Paksenarrion) _by [Elizabeth Moon](https://en.wikipedia.org/wiki/Elizabeth_Moon)_ [4.3]

This omnibus edition of 3 books describes the origin and deeds of a female Paladin named Paksenarrion. The Deed of Paksenarrion contemplates justice, true courage and the forces of good and evil in a way that is refreshing. I don't think I ever really understood the fantasy class of Paladin until reading this either, Elizabeth Moon's depiction will now forever be my etched on my brain as what a Paladin is.

It has all the usual trappings of high fantasy including dwarves and elves, but what really stands out is the balance of gender and the role of women. Throughout the books women are respected as equals and Paksenarrion develops a courageous, head-strong and loyal character that is engrossing and convincing. - [@samueljseay](https://github.com/samueljseay)

Books:

- [Sheepfarmer's Daughter](https://www.goodreads.com/book/show/96278.Sheepfarmer_s_Daughter)
- [Divided Allegiance](https://www.goodreads.com/book/show/887858.Divided_Allegiance)
- [Oath of Gold](https://www.goodreads.com/book/show/17316.Oath_of_Gold)

> Paksenarrion-—Paks for short-—was somebody special. Never could she have followed her father's orders and married the pig farmer down the road. Better a soldier's life than a pigfarmer's wife, and so though she knew that she could never go home again, Paks ran away to be a soldier. And so began an adventure destined to transform a simple Sheepfarmer's Daughter into a hero fit to be chosen by the gods

#### [The Demon Cycle](https://www.goodreads.com/series/46817-the-demon-cycle) (2008) _by [Peter V. Brett](https://en.wikipedia.org/wiki/Peter_V._Brett)_ [4.2] :fire:

This a darker fantasy series that weaves the story from different people who are not necessarily allies but allied towards a similar end goal. Different beliefs and an intricate magic system keep things interesting. - [@depperm](https://github.com/depperm)

Books:

- [The Warded Man](https://www.goodreads.com/book/show/24809182-o-protegido) :fire:
- [The Desert Spear](https://www.goodreads.com/book/show/17411982-pustinjsko-koplje)
- [The Daylight War](https://www.goodreads.com/book/show/16163983-the-daylight-war)
- [The Skull Throne](https://www.goodreads.com/book/show/24516043-the-skull-throne)
- [The Core](https://www.goodreads.com/book/show/36179561-the-core)

> As darkness falls after sunset, the corelings rise—demons who possess supernatural powers and burn with a consuming hatred of humanity. For hundreds of years the demons have terrorized the night, slowly culling the human herd that shelters behind magical wards—symbols of power whose origins are lost in myth and whose protection is terrifyingly fragile.
>
>It was not always this way. Once, men and women battled the corelings on equal terms, but those days are gone. Night by night the demons grow stronger, while human numbers dwindle under their relentless assault.
>
>Now, with hope for the future fading, three young survivors of vicious demon attacks will do the unthinkable, stepping beyond the crumbling safety of the wards to risk everything in a desperate quest to regain the secrets of the past.
>
>Arlen Bales will pay any price, embrace any sacrifice, for freedom, and his grim journey will take him beyond the bounds of human power. Crippled by the demons that killed his parents, Rojer Inn seeks solace in music, only to discover that his instrument can be a weapon as well as a refuge. Wanting to cure the sick and injured, Leesha Paper overcomes great hardship to become a guardian of old world science, learning that what heals can also harm. Together, they will stand against the night.

#### [The Farseer Trilogy](https://www.goodreads.com/series/41452-farseer-trilogy) _by [Robin Hobb](https://en.wikipedia.org/wiki/Robin_Hobb)_ [4.1] :fire:

I devoured these books; the magic system is great and the world is well worked through. There's a fantastic amount of detail that never gets onerous, amazingly. The characters grow with the story, unlike most fantasy novels. The writing of characters who are under spells is also fantastic - Hobb never tells you directly that they have been befuddled until after, which makes for some very fun and enjoyable surprises. - [@RichardLitt](https://github.com/RichardLitt)

Books:

- [Assassin's Apprentice](http://www.goodreads.com/book/show/45107.Assassin_s_Apprentice) [4.1]
- [Royal Assassin](https://www.goodreads.com/book/show/68487.Royal_Assassin) [4.2]
- [Assassin's Quest](https://www.goodreads.com/book/show/45112.Assassin_s_Quest) [4.2]

> In a faraway land where members of the royal family are named for the virtues they embody, one young boy will become a walking enigma. Born on the wrong side of the sheets, Fitz, son of Chivalry Farseer, is a royal bastard, cast out into the world, friendless and lonely. Only his magical link with animals - the old art known as the Wit - gives him solace and companionship. But the Wit, if used too often, is a perilous magic, and one abhorred by the nobility. So when Fitz is finally adopted into the royal household, he must give up his old ways and embrace a new life of weaponry, scribing, courtly manners; and how to kill a man secretly, as he trains to become a royal assassin.

#### [The First Law Trilogy](https://en.wikipedia.org/wiki/The_First_Law) (2006) _by [Joe Abercrombie](https://en.wikipedia.org/wiki/Joe_Abercrombie)_ [4.2] :fire:

The First Law is a grimdark epic fantasy trilogy that is very character driven. The characters in this book are not particularly _likable_ but despite that I found them all very lovable. The first book is a slow burn, and for a time I wasn't sure I would continue, but by the time I was half way I realised I loved seeing these characters go through their hardships, and on their adventures. This is the kind of series you feel sad about finishing because you want to spend more time with these characters. Fortunately there are standalone books and a second trilogy to read if you enjoy the original trilogy!

The magic in this series isn't front and center. Despite this I would say this is a series every lover of fantasy needs to read. - [@Darknessflowers](https://github.com/Darknessflowers)

Books:

Original trilogy:

- [The Blade Itself](https://www.goodreads.com/book/show/944073.The_Blade_Itself) [4.2] :fire:
- [Before They Are Hanged](https://www.goodreads.com/book/show/902715.Before_They_Are_Hanged) [4.3] :fire:
- [Last Argument of Kings](https://www.goodreads.com/book/show/944076.Last_Argument_of_Kings) [4.3] :fire:

Standalone Novels:

- [Best Served Cold](https://www.goodreads.com/book/show/2315892.Best_Served_Cold) [4.2]
- [The Heroes](https://www.goodreads.com/book/show/9300768-the-heroes) [4.3]
- [Red Country](https://www.goodreads.com/book/show/13521459-red-country) [4.3]

Short Story anthology:

- [Sharp Ends](https://www.goodreads.com/book/show/26030742-sharp-ends) [4.2]

The Age of Madness Trilogy:

- [A Little Hatred](https://www.goodreads.com/book/show/35606041-a-little-hatred) [4.5]
- [The Trouble With Peace](https://www.goodreads.com/book/show/40701777-the-trouble-with-peace) [4.7]
- The Wisdom of Crowds - _to be released 2021_

> Logen Ninefingers, infamous barbarian, has finally run out of luck. Caught in one feud too many, he’s on the verge of becoming a dead barbarian – leaving nothing behind him but bad songs, dead friends, and a lot of happy enemies.
>
> Nobleman Captain Jezal dan Luthar, dashing officer, and paragon of selfishness, has nothing more dangerous in mind than fleecing his friends at cards and dreaming of glory in the fencing circle. But war is brewing, and on the battlefields of the frozen North they fight by altogether bloodier rules.
>
> Inquisitor Glokta, cripple turned torturer, would like nothing better than to see Jezal come home in a box. But then Glokta hates everyone: cutting treason out of the Union one confession at a time leaves little room for friendship. His latest trail of corpses may lead him right to the rotten heart of government, if he can stay alive long enough to follow it.
>
> Enter the wizard, Bayaz. A bald old man with a terrible temper and a pathetic assistant, he could be the First of the Magi, he could be a spectacular fraud, but whatever he is, he's about to make the lives of Logen, Jezal, and Glokta a whole lot more difficult.
>
> Murderous conspiracies rise to the surface, old scores are ready to be settled, and the line between hero and villain is sharp enough to draw blood.

#### [The Inheritance Trilogy](<https://en.wikipedia.org/wiki/The_Inheritance_Trilogy_(N.K._Jemisin)>) _by [N.K. Jemisin](https://en.wikipedia.org/wiki/N._K._Jemisin)_

Dealing with racial and sexual discrimination in a high fantasy setting, the novel is excellent. - [@SeanSWatkins](https://github.com/SeanSWatkins)

Books:

1. [The Hundred Thousand Kingdoms](http://www.goodreads.com/book/show/6437061-the-hundred-thousand-kingdoms) [4.2]

> The first novel centers around Yeine a Darr woman who has been called back to the city Sky for reasons unbeknown to her. The current leader of Sky, who also rules the world at large, is nearing the end of his life and, in true Arameri fashion, makes a game of his succession. Yeine is soon caught up in schemes that she does not fully understand, involving gods she cannot fully comprehend. She must sift through lies and half-truths she is told to try and uncover what is really going on in the capital of the world, all the while trying to navigate a fragile and deceptive political atmosphere. The story is told from the first-person viewpoint of the main protagonist, Yeine. It's written as a retelling of a story, where she is walking you through her time in Sky and all the events that lead up to the climax of the story. The story does seems to jump around quite a bit without becoming confusing.

#### [The Kingkiller Chronicle](http://en.wikipedia.org/wiki/The_Kingkiller_Chronicle) _by [Patrick Rothfuss](https://en.wikipedia.org/wiki/Patrick_Rothfuss)_

These are exceptionally well written, humorous, and display a surprising lack of non-ironic tropes. There's a good sense of humor, the magic is well fleshed out, and the main character, Kvothe, is just great to read about and very easy to be sympathetic towards. Loved 'em, can't wait for the final third. - [@RichardLitt](https://github.com/RichardLitt)

Books:

- [The Name of the Wind](https://www.goodreads.com/book/show/186074.The_Name_of_the_Wind) [4.55]
- [The Wise Man's Fear](https://www.goodreads.com/book/show/1215032.The_Wise_Man_s_Fear) [4.56]

> The Kingkiller Chronicle is a fantasy trilogy by Patrick Rothfuss, telling the autobiography of Kvothe, an adventurer and famous musician.
>
> The plot is divided into two different action threads: the present, where Kvothe tells the story of his life to Devan Lochees (known as Chronicler) in the main room of his inn, and Kvothe's past, the story in question, which makes up the majority of the books. The present-day interludes are in the third person from the perspective of multiple characters, while the story of Kvothe's life is told entirely in the first person from his own perspective.
>
> The series also contains many meta-fictional stories-within-stories from varying perspectives, most of which are recounted by Kvothe, having been heard from other characters in his past.

#### [The Lightbringer Series](https://www.goodreads.com/series/49673-lightbringer) _by [Brent Weeks](https://en.wikipedia.org/wiki/Brent_Weeks)_

The Lightbringer Series has one of the most intricately fleshed-out magic systems that I have ever seen in high fantasy, where the use of magic has interesting implications on characters' lifespan and personality. The storyline, character development, and plot twists make it a binge-worthy series. On top of that, Weeks does an excellent job of bringing the reader through each characters' strengths and weaknesses in personality, magical ability, and circumstances that shape how they end up fitting in to the larger picture. Through the development of his characters, his books address larger societal and philosophical issues from slavery and discrimination to theology and theism/atheism. It is incredibly well-thought out, and I can't wait to see what he does in the last and final installment of the series. The fifth book [The Burning White](https://www.goodreads.com/book/show/30169100-the-burning-white) is expected to come out sometime in 2019! - [@ciarrapeters](https://github.com/ciarrapeters)

Books:

- [The Black Prism](https://www.goodreads.com/book/show/7165300-the-black-prism) (2010) [4.24]
- [The Blinding Knife](https://www.goodreads.com/book/show/12499290-the-blinding-knife) (2012) (4.45)
- [The Broken Eye](https://www.goodreads.com/book/show/12652457-the-broken-eye) (2014) [4.47]
- [The Blood Mirror](https://www.goodreads.com/book/show/29467232-the-blood-mirror) (2016) [4.32]

> Guile is the Prism, the most powerful man in the world. He is high priest and emperor, a man whose power, wit, and charm are all that preserves a tenuous peace. Yet Prisms never last, and Guile knows exactly how long he has left to live.
>
> When Guile discovers he has a son, born in a far kingdom after the war that put him in power, he must decide how much he's willing to pay to protect a secret that could tear his world apart.

#### [The Lord of the Rings](https://en.wikipedia.org/wiki/The_Lord_of_the_Rings) _by [J.R.R. Tolkien](https://en.wikipedia.org/wiki/J._R._R._Tolkien)_ [4.4] :star2: :fire:

No comment. - [@RichardLitt](https://github.com/RichardLitt)

Books:

- [The Fellowship of the Ring](http://www.goodreads.com/book/show/34.The_Fellowship_of_the_Ring) :fire: :star2:
- [The Two Towers](http://www.goodreads.com/book/show/15241.The_Two_Towers) :fire: :star2:
- [The Return of the King](http://www.goodreads.com/book/show/18512.The_Return_of_the_King) :fire: :star2:

> A fantastic starter set for new Tolkien fans or readers interested in rediscovering the magic of Middle-earth, this three-volume box set features paperback editions of the complete trilogy -- The Fellowship of the Ring, The Two Towers, and The Return of the King -- each with art from the New Line Productions feature film on the cover.
>
> J.R.R. Tolkien's The Lord of the Rings trilogy is a genuine masterpiece. The most widely read and influential fantasy epic of all time, it is also quite simply one of the most memorable and beloved tales ever told. Originally published in 1954, The Lord of the Rings set the framework upon which all epic/quest fantasy since has been built. Through the urgings of the enigmatic wizard Gandalf, young hobbit Frodo Baggins embarks on an urgent, incredibly treacherous journey to destroy the One Ring. This ring -- created and then lost by the Dark Lord, Sauron, centuries earlier -- is a weapon of evil, one that Sauron desperately wants returned to him. With the power of the ring once again his own, the Dark Lord will unleash his wrath upon all of Middle-earth. The only way to prevent this horrible fate from becoming reality is to return the Ring to Mordor, the only place it can be destroyed. Unfortunately for our heroes, Mordor is also Sauron's lair. The Lord of the Rings trilogy is essential reading not only for fans of fantasy but for lovers of classic literature as well...

#### [The Lost Years of Merlin](https://www.goodreads.com/series/40391) by _[T.A. Barron](https://en.wikipedia.org/wiki/T._A._Barron)_ [4.0]

These books are amazing just for the imaginative power of the author, who grabs random snippets from old folklore and tries to make a story out of them. They're nothing like the actual Merlin, but they're pretty fun to read. The writing style is more aimed at young adults, however, and they don't age well. - [@RichardLitt](https://github.com/RichardLitt)

Books:

- [The Lost Years of Merlin](http://www.goodreads.com/book/show/18392.The_Lost_Years)
- [The Seven Songs of Merlin](http://www.goodreads.com/book/show/18396.The_Seven_Songs_of_Merlin)
- [The Fires of Merlin](http://www.goodreads.com/book/show/18393.The_Fires_of_Merlin)
- [The Mirror of Merlin](http://www.goodreads.com/book/show/18394.The_Mirror_of_Merlin)
- [The Wings of Merlin](http://www.goodreads.com/book/show/18395.The_Wings_of_Merlin)

> When Merlin, suffering from a case of severe amnesia, discovers his strange powers, he becomes determined to discover his identity and flees to Fincayra where he fulfills his destiny, saving Fincayra from certain destruction and claiming his birthright and true name.

#### [The Malazan Book Of The Fallen](https://www.goodreads.com/series/43493-the-malazan-book-of-the-fallen) (1999) _by [Steven Erikson](https://en.wikipedia.org/wiki/Steven_Erikson)_ [3.8]

Mixing the grittiness of Glen Cook's books with the modern fantasy elements, this series is more brutal than any before it. Lots of philosophical questions stems from reading even the less important chapters and a huge amount of characters makes it for a very long and deep read. As Erikson himself points out, people either "love it or hate it". The author is writing a prequel series right now and will add a sequel trilogy after it, making for a total of 16 books. - [@Donearm](https://github.com/Donearm)

Books:

- [Gardens of the Moon](https://www.goodreads.com/book/show/55399.Gardens_of_the_Moon) [3.8]
- [Deadhous Gates](https://www.goodreads.com/book/show/55401.Deadhouse_Gates) [4.2]
- [Memories of Ice](https://www.goodreads.com/book/show/175983.Memories_of_Ice) [4.4]
- [House of Chains](https://www.goodreads.com/book/show/55398.House_of_Chains) [4.3]
- [Midnight Tides](https://www.goodreads.com/book/show/345299.Midnight_Tides) [4.3]
- [The Bonehunters](https://www.goodreads.com/book/show/478951.The_Bonehunters) [4.4]
- [Reaper's Gale](https://www.goodreads.com/book/show/459064.Reaper_s_Gale) [4.3]
- [Toll the Hounds](https://www.goodreads.com/book/show/938544.Toll_the_Hounds) [4.3]
- [Dust of Dreams](https://www.goodreads.com/book/show/4703427-dust-of-dreams) [4.3]
- [The Crippled God](https://www.goodreads.com/book/show/8447255-the-crippled-god) [4.4]

> Steven Erikson draws on twenty years of experience as an anthropologist and archaeologist. Vast legions of gods, mages, humans, dragons and all manner of creatures play out the fate of the Malazan Empire, with brutal action and battle scenes
>
> The world building is done on an unprecedented scale and Erikson has left a lifetime's worth of novels on the table in the world of the Malazan Empire. So what is left to talk about? It's simple, the writing. I can tell that Steven Erikson's writing is filled with wit, charm, philosophical brilliance and a sense of imagination that would humble the most creative of authors. You will be hard-pressed to find his equal in any genre.

#### [The Riftwar Saga](https://en.wikipedia.org/wiki/The_Riftwar_Saga) _by [Raymond E. Feist](https://en.wikipedia.org/wiki/Raymond_E._Feist)_ [4.3]

This reads like someone decided to put some characters in their Dungeons and Dragons world, which is exactly how they were formed. For all that, they are amusing. - [@RichardLitt](https://github.com/RichardLitt)

Books:

- [Magician: Apprentice](http://www.goodreads.com/book/show/43915.Magician)
- [Magician: Master](http://www.goodreads.com/book/show/8320534-raymond-e-feist-s-magician-master)
- [Silverthorn](http://www.goodreads.com/book/show/149302.Silverthorn)
- [A Darkness at Sethanon](http://www.goodreads.com/book/show/13813.A_Darkness_At_Sethanon)

> To the forest on the shore of the Kingdom of the Isles, the orphan Pug came to study with the master magician Kulgan. His courage won him a place at court and the heart of a lovely Princess, but he was ill at ease with normal wizardry. Yet his strange magic may save two worlds from dark beings who opened space-time to renew the age-old battle between Order and Chaos.

#### [The Riyria Chronicles](https://www.goodreads.com/series/175806-the-riyria-chronicles) (2013) _by [Michael J. Sullivan](https://en.wikipedia.org/wiki/Michael_J._Sullivan_(author))_ [4.3]

Writing a good prequel is hard, but this series masterfully introduces the main characters. If you're reading by publishing year, it fills in the blanks in much of Royce and Hadrian's origin story that is hinted at later on. - [@depperm](https://github.com/depperm)

> A warrior with nothing to fight for is paired with a thieving assassin with nothing to lose. Together they must steal a treasure that no one can reach. The Crown Tower is the impregnable remains of the grandest fortress ever built and home to the realm’s most valuable possessions. But it isn’t gold or jewels the old wizard is after, and this prize can only be obtained by the combined talents of two remarkable men. Now if Arcadius can just keep Hadrian and Royce from killing each other, they just might succeed.

#### [The Riyria Revelations](https://www.goodreads.com/series/96465-the-riyria-revelations) (2008) _by [Michael J. Sullivan](https://en.wikipedia.org/wiki/Michael_J._Sullivan_(author))_ [4.2]

Chronologically this is second, but this series was published first. This series is what pulled me into reading all of Michael J Sullivan's other writings. Dynamic duos make a great story, and it's the same for this set of series. - [@depperm](https://github.com/depperm)

> There is no ancient evil to defeat, no orphan destined for greatness, just two guys in the wrong place at the wrong time. Royce Melborn, a skilled thief, and his mercenary partner, Hadrian Blackwater make a profitable living carrying out dangerous assignments for conspiring nobles until they become the unwitting scapegoats in a plot to murder the king. Sentenced to death, they have only one way out...and so begins this tale of treachery and adventure, sword fighting and magic, myth and legend.

#### [The Silmarillion](http://www.goodreads.com/book/show/7332.The_Silmarillion) _by [J.R.R. Tolkien](https://en.wikipedia.org/wiki/J._R._R._Tolkien)_ [3.8] :fire:

This is one of the most ridiculous forays into world building, ever. At times, it reads like a textbook, but there are sections that are extremely powerful and characters that are gripping. The Silmarillion takes a bit more imagination and fortitude than the Lord of the Rings, but is worth the effort, especially if you've already read his other books a few times and want more. - [@RichardLitt](https://github.com/RichardLitt)

> Designed to take fans of The Hobbit and The Lord of the Rings deeper into the myths and legends of Middle-Earth, The Silmarillion is an account of the Elder Days, of the First Age of Tolkien's world. It is the ancient drama to which the characters in The Lord of the Rings look back, and in whose events some of them such as Elrond and Galadriel took part. The tales of The Silmarillion are set in an age when Morgoth, the first Dark Lord, dwelt in Middle-Earth, and the High Elves made war upon him for the recovery of the Silmarils, the jewels containing the pure light of Valinor. Included in the book are several shorter works. The Ainulindale is a myth of the Creation and in the Valaquenta the nature and powers of each of the gods is described. The Akallabeth recounts the downfall of the great island kingdom of Numenor at the end of the Second Age and Of the Rings of Power tells of the great events at the end of the Third Age, as narrated in The Lord of the Rings. This pivotal work features the revised, corrected text and includes, by way of an introduction, a fascinating letter written by Tolkien in 1951 in which he gives a full explanation of how he conceived the early Ages of Middle-Earth.

#### [The Stormlight Archive](https://en.wikipedia.org/wiki/The_Stormlight_Archive) _by [Brandon Sanderson](https://en.wikipedia.org/wiki/Brandon_Sanderson)_ [4.6]

The Stormlight Archive books (only 2 out of a planned 10 last I heard) are 2 of the longest books out there, and I read on my Kindle and did not realize they were so long until I realized I was some 15 hours in and ~50% done IIRC. I was so engrossed, I hadn't cared. I got the 2nd one the day it came out and read it in about 10 days despite my busy schedule (sleep was sacrificed). - [@CWSpear](https://github.com/CWSpear)

I completely agree that however long these books are, it doesn't really matter. They're fantastic. The magic system is complex, and the characters Brandon focuses on have their own little foibles and bits of awesome. This is classic 90's fantasy, but still incredibly good. The world is also pretty novel for fantasy - no more England-like environments, but actually a different kind of landscape. - [@RichardLitt](https://github.com/RichardLitt)

> Brandon Sanderson's epic fantasy cycle tells the story of Roshar, a world of stone and storms. Uncanny tempests of incredible power sweep across the rocky terrain. It has been centuries since the fall of the ten consecrated orders known as the Knights Radiant, but their Shardblades and Shardplate remain: mystical swords and suits of armor that transform ordinary men into near-invincible warriors. As brutal wars rage over the control of these magical weapons, an ancient text called The Way of Kings tells of ancient times, the Knights Radiant, and perhaps the true cause of the war. The Knights Radiant must stand again.

Books:

- [The Way of Kings](https://www.goodreads.com/book/show/7235533-the-way-of-kings) [4.61] :fire:
- [Words of Radiance](https://www.goodreads.com/book/show/17332218-words-of-radiance) [4.76] :fire:
- [Oathbringer](https://www.goodreads.com/book/show/34002132-oathbringer) [4.73] :fire:
- [Rhythm of War](https://www.goodreads.com/book/show/49021976-rhythm-of-war) [4.63]
- _More coming_

#### [The Wandering Inn](https://www.goodreads.com/series/265443-the-wandering-inn) (2018) _by [Pirateaba](https://www.goodreads.com/author/show/18265573.Pirateaba)_ [4.3]

Initially this started as a webserial, which might indicate shorter length, but there are 9 volumes (each 1k+ pages). While there are LitRPG themes of a sort, this is more of people being transported into another world not a game. The world building is some of the best: countries (with politics), magic, characters (good, bad, side), plans/plots, bias/hatred, and unique monsters. - [@depperm](https://github.com/depperm)

> “No killing Goblins.”
>
>So reads the sign outside of The Wandering Inn, a small building run by a young woman named Erin Solstice. She serves pasta with sausage, blue fruit juice, and dead acid flies on request. And she comes from another world. Ours.
>
>It’s a bad day when Erin finds herself transported to a fantastical world and nearly gets eaten by a Dragon. She doesn’t belong in a place where monster attacks are a fact of life, and where Humans are one species among many. But she must adapt to her new life. Or die.
>
>In a dangerous world where magic is real and people can level up and gain classes, Erin Solstice must battle somewhat evil Goblins, deadly Rock Crabs, and hungry [Necromancers]. She is no warrior, no mage. Erin Solstice runs an inn.

#### [The Wheel of Time](https://en.wikipedia.org/wiki/The_Wheel_of_Time) _by [Robert Jordan](https://en.wikipedia.org/wiki/Robert_Jordan) (and [Brandon Sanderson](https://en.wikipedia.org/wiki/Brandon_Sanderson))_ [4.15] :fire:

These books are probably the longest single series in the fantasy genre. I've read the series eight times. I don't know what to make of that, except that it's worth reading. It's like a long soap opera - the characters are one sided and flat, but there are so many of them that you end up not minding. The magic system is very intricate, and the general plot line is good. The three last books were co-written, as Robert Jordan died before they were done. - [@RichardLitt](https://github.com/RichardLitt)

Books:

- [The Eye of the World](http://www.goodreads.com/book/show/228665.The_Eye_of_the_World) :fire:
- [The Great Hunt](http://www.goodreads.com/book/show/233649.The_Great_Hunt)
- [The Dragon Reborn](http://www.goodreads.com/book/show/34897.The_Dragon_Reborn)
- [The Shadow Rising](http://www.goodreads.com/book/show/9539.The_Shadow_Rising)
- [The Fires of Heaven](http://www.goodreads.com/book/show/13895.The_Fires_of_Heaven)
- [Lord of Chaos](http://www.goodreads.com/book/show/35231.Lord_of_Chaos)
- [A Crown of Swords](http://www.goodreads.com/book/show/13890.A_Crown_of_Swords)
- [The Path of Daggers](http://www.goodreads.com/book/show/140974.The_Path_of_Daggers)
- [Winter's Heart](http://www.goodreads.com/book/show/13891.Winter_s_Heart)
- [Crossroads of Twilight](http://www.goodreads.com/book/show/113435.Crossroads_of_Twilight)
- [Knife of Dreams](http://www.goodreads.com/book/show/13888.Knife_of_Dreams)
- [The Gathering Storm](http://www.goodreads.com/book/show/1166599.The_Gathering_Storm)
- [Towers of Midnight](http://www.goodreads.com/book/show/8253920-towers-of-midnight)
- [A Memory of Light](http://www.goodreads.com/book/show/7743175-a-memory-of-light)
- [New Spring (prequel)](http://www.goodreads.com/book/show/187065.New_Spring)

> The Wheel of Time turns and Ages come and go, leaving memories that become legend. Legend fades to myth, and even myth is long forgotten when the Age that gave it birth returns again. In the Third Age, an Age of Prophecy, the World and Time themselves hang in the balance. What was, what will be, and what is, may yet fall under the Shadow.

#### [Thorn of Glass Series](https://www.goodreads.com/book/show/7896527-throne-of-glass) (2012) _by [Sarah J. Maas](https://en.wikipedia.org/wiki/Sarah_J._Maas)_ [4.21] 🔥

This is gorgeous, dark and ridiculously epic. Fast-paced, action-packed and High-fantasy goodness lovers! People-who-don't-love-any-of-those-things-but-want-to-try-something-new lovers! - I definitely recommend this book! - [@gayatripalkar](https://github.com/gayatripalkar)

Books:

1. [The Assassin's Blade](https://www.goodreads.com/book/show/18243700-the-assassin-s-blade) [4.4] 🔥
2. [Throne of Glass](https://www.goodreads.com/book/show/7896527-throne-of-glass) [4.21] 🔥
3. [Crown of Midnight](https://www.goodreads.com/book/show/17167166-crown-of-midnight) [4.43] 🔥
4. [Heir of Fire](https://www.goodreads.com/book/show/20613470-heir-of-fire) [4.48] 🔥
5. [Queen of Shadows](https://www.goodreads.com/book/show/18006496-queen-of-shadows) [4.56] 🔥
6. [Empire of Storms](https://www.goodreads.com/book/show/28260587-empire-of-storms) [4.54] 🔥
7. [Tower of Dawn](https://www.goodreads.com/book/show/31450852-tower-of-dawn) [4.36] 🔥
8. [Kingdom of Ash](https://www.goodreads.com/book/show/33590260-kingdom-of-ash) [4.57] 🔥

> Throne of Glass is a young adult turned new adult, high fantasy novel series by American author Sarah J. Maas, beginning with the novel of the same name, released in August 2012. The story follows the journey of Celaena Sardothien, a teenage assassin in a corrupt kingdom with a tyrannical ruler. As the tale progresses, Celaena forms unexpected bonds and uncovers a conspiracy amidst her adventures. The series concluded with the eighth book in October 2018.
> The series appeared on the New York Times Best Seller list, and has been optioned by Hulu for a television series adaptation by Mark Gordon.

> After serving out a year of hard labor in the salt mines of Endovier for her crimes, 18-year-old assassin Celaena Sardothien is dragged before the Crown Prince. Prince Dorian offers her her freedom on one condition: she must act as his champion in a competition to find a new royal assassin.
> Her opponents are men-thieves and assassins and warriors from across the empire, each sponsored by a member of the king's council. If she beats her opponents in a series of eliminations, she'll serve the kingdom for four years and then be granted her freedom. Celaena finds her training sessions with the captain of the guard, Westfall, challenging and exhilarating. But she's bored stiff by court life. Things get a little more interesting when the prince starts to show interest in her ... but it's the gruff Captain Westfall who seems to understand her best.
> Then one of the other contestants turns up dead ... quickly followed by another. Can Celaena figure out who the killer is before she becomes a victim? As the young assassin investigates, her search leads her to discover a greater destiny than she could possibly have imagined.

#### [Tortall](https://www.goodreads.com/series/50262-tortall) (1983) _by [Tamora Pierce](https://en.wikipedia.org/wiki/Tamora_Pierce)_ [4.3]

These are a collection of series that all focus on female protagonists in unique fantasy jobs, from law enforcement to magicians. Each exist in the same universe but are generally years apart, so there are hints of other periods but each series can easily stand on its own. - [@depperm](https://github.com/depperm)

Series:

- [Beka Cooper](https://www.goodreads.com/series/44532-beka-cooper)
- [The Song of the Lioness](https://www.goodreads.com/series/43928-song-of-the-lioness)
- [The Immortals](https://www.goodreads.com/series/49863-immortals)
- [The Protector of the Small](https://www.goodreads.com/series/43815-protector-of-the-small)
- [Tricksters](https://www.goodreads.com/series/43688-daughter-of-the-lioness)

> The area known as Tortall and its surrounding countries is a medieval fantasy universe, emerging from a time in the north when only men were permitted to hold knighthoods.  It is the home of an interesting assortment of heroes, many of them girls, who have found ways to make a difference in a world that can be hard and bloody–as knights, as mages (wizards), as spies, as law enforcement.
>
>On the field of battle or in the corridors of noble houses, flanked by companions human, animal, and sometimes other, the Tortall heroes always have their work cut out for them.  There is military danger from neighbors like northern Scanra, eastern Tusaine, and worst of all, imperial Carthak in the south, with its ever-hungry slave culture and its greedy mage emperor.  Pirates from Carthak, Scanra, and the Copper Isles haunt Tortall’s eastern shores.  And in a country both large and sparsely policed, there is always a risk of conflict, be it from rebel nobles, the impoverished people of the eastern hills, or the barely vanquished Bazhir tribes.
>
>Its monarchs range from kind to fumbling to formidable, as do its thieves, its mages, its priests, its warriors, and most of all, its gods.  These are very much present in the lives of the people, taking up champions and taking against those who have angered them.  They are joined by god-like creatures–winged horses; giant spiders with human heads; dragons; griffins; giants; huge, icy lizards that hunt down thieves no matter what stands in their way.
>
>It is a beautiful, perilous place, where teenagers and adults can make their mark on a magical world!

### Standard Fantasy

#### [American Gods](https://www.goodreads.com/book/show/4407.American_Gods) _by [Neil Gaiman](https://en.wikipedia.org/wiki/Neil_Gaiman)_ [4.1]

This book stands up to a reread, and is a nice example of Neil Gaiman's ability to draw together a thousand different threads into one cohesive story. The scenes in the Wisconsin small towns stay with me much longer than the rest of the book - they're reminiscent of the much better book _Peace_ by Gene Wolfe, not to say they're not well done. This is a quick and great read, and it continually surprises. - [@RichardLitt](https://github.com/RichardLitt)

> Days before his release from prison, Shadow's wife, Laura, dies in a mysterious car crash. Numbly, he makes his way back home. On the plane, he encounters the enigmatic Mr Wednesday, who claims to be a refugee from a distant war, a former god and the king of America.
>
> Together they embark on a profoundly strange journey across the heart of the USA, whilst all around them a storm of preternatural and epic proportions threatens to break.
>
> Scary, gripping and deeply unsettling, AMERICAN GODS takes a long, hard look into the soul of America. You'll be surprised by what and who it finds there...

#### [The Book of Knights](https://www.goodreads.com/en/book/show/1583772) _by [Yves Menard](https://en.wikipedia.org/wiki/Yves_Meynard)_ [3.94]

An outstanding book. I was blown away by how exceptionally other-worldly this book felt - it reminded me of Jack Vance and Gene Wolfe, which is how I found it. One of the quotes in the book is used as an opener in Wolfe's _The Wizard Knight_. The book follows a young boy as he seeks to become a knight, inspired by his reading a book titled "The Book of Knights". I can't recommend this book enough. - [@RichardLitt](https://github.com/RichardLitt)

> A young boy and his journey to become a knight. He must complete a quest, but the book takes you places you don't expect a seemingly run-of-the-mill book would.

#### [Fablehaven](https://www.goodreads.com/book/show/44652.Fablehaven) (2006) _by [Brandon Mull](https://en.wikipedia.org/wiki/Brandon_Mull)_ [4.1] :fire:

Fantasy for the younger readers. Follow along two youths who visit their grandparents and discover that not everything is as it appears. - [@depperm](https://github.com/depperm)

> For centuries mystical creatures of all description were gathered into a hidden refuge called Fablehaven to prevent their extinction. The sanctuary survives today as one of the last strongholds of true magic. Enchanting? Absolutely. Exciting? You bet. Safe? Well, actually, quite the opposite.
>
>Kendra and her brother, Seth, have no idea that their grandfather is the current caretaker of Fablehaven. Inside the gated woods, ancient laws keep relative order among greedy trolls, mischievous satyrs, plotting witches, spiteful imps, and jealous fairies. However, when the rules get broken -- Seth is a bit too curious and reckless for his own good -- powerful forces of evil are unleashed, and Kendra and her brother face the greatest challenge of their lives. To save their family, Fablehaven, and perhaps even the world, Kendra and Seth must find the courage to do what they fear most.

#### [Ficciones](https://www.goodreads.com/book/show/426504.Ficciones) _by [Jorge Luis Borges](https://en.wikipedia.org/wiki/Jorge_Luis_Borges)_ [4.5]

Some of the best short stories I have ever read; The Library is my favourite of all time, so much that I'm debating getting a tattoo from it. - [@RichardLitt](https://github.com/RichardLitt)

> The seventeen pieces in Ficciones demonstrate the whirlwind of Borges' genius and mirror the precision and potency of his intellect and inventiveness, his piercing irony, his skepticism, and his obsession with fantasy. Borges sends us on a journey into a compelling, bizarre, and profoundly resonant realm; we enter the fearful sphere of Pascal's abyss, the surreal and literal labyrinth of books, and the iconography of eternal return. To enter the worlds in Ficciones is to enter the mind of Jorge Luis Borges, wherein lies Heaven, Hell, and everything in between.

#### [Grandma's Bag Of Stories](https://www.goodreads.com/book/show/13510813-grandma-s-bag-of-stories) (2012) _by [Sudha Murthy](https://en.wikipedia.org/wiki/Sudha_Murty)_ [4.21]

This book is quite realistic and reminded me of the stories my grandparents have told me. And just like me, everyone was upset when this adventure comes to an end. -[@NivedithaBBhat](https://github.com/NivedithaBBhat)

> When Grandma opens her bag of stories, everyone gathers Around.
> Who can resist a good story, especially when it’s being told by Grandma? From her bag emerges tales of kings and cheats, monkeys and mice, bears and gods. Here comes the bear who ate some really bad dessert and got very angry; a lazy man who would not put out a fire till it reached his beard; a princess who got turned into an onion; a queen who discovered silk, and many more weird and wonderful people and animals.
> Grandma tells the stories over long summer days and nights, as seven children enjoy life in her little town. The stories entertain, educate and provide hours of enjoyment to them.

#### [Imager](https://www.goodreads.com/book/show/20820423-imager) (2009) _by [L.E. Modesitt Jr.](https://en.wikipedia.org/wiki/L._E._Modesitt_Jr.)_ [4.02]

Although the author gets a little too detailed in some of his descriptions about unimportant details making the story slower than most, the magic system is unique and well thought out. The detail helps build a world you can imagine existing. - [@depperm](https://github.com/depperm)

> Although Rhennthyl is the son of a leading wool merchant in L’Excelsis, the capital of Solidar, the most powerful nation on Terahnar, he has spent years becoming a journeyman artist and is skilled and diligent enough to be considered for the status of master artisan—in another two years. Then, in a single moment, his entire life is transformed when his master patron is killed in a flash fire, and Rhenn discovers he is an imager—one of the few in the entire world of Terahnar who can visualize things and make them real.
>
>He must leave his family and join the Collegium of Imagisle.  Imagers live separately from the rest of society because of their abilities (they can do accidental magic even while asleep), and because they are both feared and vulnerable.
>
>In this new life, Rhenn discovers that all too many of the “truths” he knew were nothing of the sort. Every day brings a new threat to his life.  He makes a powerful enemy while righting a wrong, and begins to learn to do magic in secret. Imager is the innovative and enchanting opening of an involving new fantasy story.

#### [Jirel of Joiry](https://www.goodreads.com/book/show/941226.Jirel_of_Joiry) (1934) _by [C. L. Moore](https://en.wikipedia.org/wiki/C._L._Moore)_ [3.78]

I found Jirel fascinating as a heroine of 1930s pulp fantasy. Throughout her adventures, Jirel's opponents constantly seek to victimize her, use her as bait, lure her in, or overpower her. Often she can't escape witnessing or even being part of horrific things, but she takes these impossible situations and confronts them on her own terms. I thought this was a nice alternative to always evading danger or using feminine wiles to get out of tight corners. Jirel is physically and emotionally capable without being a know-it-all or preternaturally lucky. Moore paints incredibly vivid pictures of fantastical realms and creatures. I think these stories would translate well into a graphic novel. This collection is a fascinating bent on traditional sword and sorcery tales and well worth the read. - [@thejessleigh](https://github.com/thejessleigh)

> C. L. Moore created Jirel, ruler of Joiry, in reaction to the beefy total-testosterone blood-and-thunder tales of '30s pulp magazines, but Jirel is no anti-Conan. She's a good Catholic girl, stubbornly purposeful, relentless in pursuit of enemies or vengeance, hard-boiled and a little stupid, and cannot be distracted by mere physical attractiveness. Indeed, in Jirel's world, beauty = decadence = corruption. Were these stories written today, inevitably Jirel would have a lot of hot sex, but as they were first published in Weird Tales between 1934-1939, sexual attraction is mostly only vividly implied. No loss. Jirel's journeys through unnatural landscapes and her battles with supernatural opponents are still wonderful to read, and though newcomers Red Sonja and Xena are more famous now, Jirel rules as the archetypal, indomitable redheaded swordswoman in chain mail and greaves, swinging her "great two-edged sword."

#### [Jonathan Strange & Mr. Norrell](https://www.goodreads.com/book/show/14201.Jonathan_Strange_Mr_Norrell) (2006) _by [Susanna Clarke](https://en.wikipedia.org/wiki/Susanna_Clarke)_ [3.8] :fire:

This book takes a while to ramp up, but if you can get through the (intentionally) tedious first 100 pages or so, _Jonathan Strange & Mr. Norrell_ is a true delight. The characters are engaging and well-drawn, and the history-style writing offers surprising opportunities for humor and dry wit. I absolutely loved this. - [@thejessleigh](https://github.com/thejessleigh)

> At the dawn of the nineteenth century, two very different magicians emerge to change England's history. In the year 1806, with the Napoleonic Wars raging on land and sea, most people believe magic to be long dead in England--until the reclusive Mr. Norrell reveals his powers, and becomes a celebrity overnight.
>
> Soon, another practicing magician comes forth: the young, handsome, and daring Jonathan Strange. He becomes Norrell's student, and they join forces in the war against France. But Strange is increasingly drawn to the wildest, most perilous forms of magic, straining his partnership with Norrell, and putting at risk everything else he holds dear.

#### [Kushiel's Dart](https://www.goodreads.com/book/show/153008.Kushiel_s_Dart) _by [Jacqueline Carey](https://en.wikipedia.org/wiki/Jacqueline_Carey)_ [4.0]

This was an amazing read. It was a bit over a thousand words, but it went by fast as anything else. It really displays Carey's way with storytelling and worldbuilding. - [@masonbose](https://github.com/masonbose)

> This is a fantasy novel by American writer Jacqueline Carey, the first book in her Kushiel's Legacy series. The idea for this book first came to Carey when she was reading the Biblical Book of Genesis, and specifically a passage about "sons of God" coming into the "daughters of Men". Later, when she was writing a coffee table book, she encountered Jewish folklore, which paralleled the story in greater detail. The fictional nation of Terre D'Ange in the story was founded by a rebel angel.

#### [Orsinian Tales](https://www.goodreads.com/book/show/92623.Orsinian_Tales) _by [Ursula K. Le Guin](https://en.wikipedia.org/wiki/Ursula_K._Le_Guin)_ [3.7]

These were beautiful, finely crafted short stories. Rarely for me, I read a few of them immediately after I finished them, to make sure that I got the more subtle details. The writing was absolutely exquisite. - [@RichardLitt](https://github.com/RichardLitt)

> Orsinia ... a land of medieval forests, stonewalled cities, and railways reaching into the mountains where the old gods dwell. A country where life is harsh, dreams are gentle, and people feel torn by powerful forces and fight to remain whole. In this enchanting collection, Ursula K. Le Guin brings to mainstream fiction the same compelling mastery of word and deed, of story and character, of violence and love, that has won her the Pushcart Prize, and the Kafka and National Book Awards.

#### [Poison Study](https://www.goodreads.com/book/show/60510.Poison_Study) (2005) _by [Maria V. Snyder](https://en.wikipedia.org/wiki/Maria_V._Snyder)_ [4.14]

The first book in the Study series, Snyder does a great job of building the suspense throughout the novel because at the start Yelena gets poisoned and you think she'll die and it carries on throughout the book. I enjoyed how Yelena's magic trickles throughout the story and the reader doesn't find out too much at the beginning. - [@louisefindlay23](https://github.com/louisefindlay23)

> Choose: A quick death…Or slow poison...

> About to be executed for murder, Yelena is offered an extraordinary reprieve. She'll eat the best meals, have rooms in the palace—and risk assassination by anyone trying to kill the Commander of Ixia.

> And so Yelena chooses to become a food taster. But the chief of security, leaving nothing to chance, deliberately feeds her Butterfly's Dust—and only by appearing for her daily antidote will she delay an agonizing death from the poison.

> As Yelena tries to escape her new dilemma, disasters keep mounting. Rebels plot to seize Ixia and Yelena develops magical powers she can't control. Her life is threatened again and choices must be made. But this time the outcomes aren't so clear...

#### [Princess and the Curdie](http://www.goodreads.com/book/show/18941223-the-princess-and-curdie-illustrated) _by [George MacDonald](https://en.wikipedia.org/wiki/George_MacDonald)_ [4.0]

This book inspired me at the age of 14 to get a tattoo I ended up getting 7 years later. This is the kind of fantasy I wish we were still making; half theological, fantastic and weird, somewhere between Grimm's Fairytales and George R.R. Martin. - [@RichardLitt](https://github.com/RichardLitt)

> Princess Irene's great-grandmother has a testing task for Curdie. He will not go alone though, as she provides him with a companion -- the oddest and ugliest creature Curdie has ever seen, but one who turns out to be the most loyal friend he could have hoped for.

#### [The Darkest Part of the Forest](https://www.goodreads.com/book/show/20958632-the-darkest-part-of-the-forest) (2015) _by [Holly Black](https://en.wikipedia.org/wiki/Holly_Black)_ [3.85]

I read this book in high school and I loved how the book was able to merge the fantasy elements with relatable storylines aimed towards teenagers. - [@jilloestreicher](https://github.com/jilloestreicher)

> Hazel lives with her brother, Ben, in the strange town of Fairfold where humans and fae exist side by side. The faeries’ seemingly harmless magic attracts tourists, but Hazel knows how dangerous they can be, and she knows how to stop them. Or she did, once. As the world turns upside down, Hazel tries to remember her years pretending to be a knight. But swept up in new love, shifting loyalties, and the fresh sting of betrayal, will it be enough?

#### [The Gentleman Bastards Series](https://www.goodreads.com/series/43531-gentleman-bastard) (2006) _by [Scott Lynch](https://en.wikipedia.org/wiki/Scott_Lynch)_ [4.25]

This series has an ingenious narrative, set in a world of intrigue, blades in the night, camaraderie between brothers, bloodthirsty monarchs, tight-fisted crime lords, and honor amongst thieves. The Gentleman Bastards will keep you guessing, and as soon as you think you understand what's happening, they'll steal the floor out from under you and leave you dangling off the side of an Elderglass tower. If you like rogues, heists, magic, or deception, this series will keep you guessing until the last page, and after. - [@dgpalmieri](https://github.com/dgpalmieri)

Books:

- [The Bastards and the Knives](https://www.goodreads.com/book/show/1321351.The_Bastards_and_the_Knives) (Book 0) _forthcoming_
- [The Lies of Locke Lamora](https://www.goodreads.com/book/show/29588376-the-lies-of-locke-lamora) [4.3] :fire:
- [Red Seas Under Red Skies](https://www.goodreads.com/book/show/40604556-red-seas-under-red-skies) [4.24]
- [The Republic of Thieves](https://www.goodreads.com/book/show/2890090-the-republic-of-thieves) [4.24]
- [The Thorn of Emberlain](https://www.goodreads.com/book/show/8074907-the-thorn-of-emberlain) _forthcoming_
- [The Ministry of Necessity](https://www.goodreads.com/book/show/10626950-the-ministry-of-necessity) _forthcoming_
- [The Mage and the Master Spy](https://www.goodreads.com/book/show/15998999-the-mage-and-the-master-spy) _forthcoming_
- [Inherit the Night](https://www.goodreads.com/book/show/15999003-inherit-the-night) _forthcoming_

> An orphan’s life is harsh—and often short—in the mysterious island city of Camorr. But young Locke Lamora dodges death and slavery, becoming a thief under the tutelage of a gifted con artist. As leader of the band of light-fingered brothers known as the Gentleman Bastards, Locke is soon infamous, fooling even the underworld’s most feared ruler. But in the shadows lurks someone still more ambitious and deadly. Faced with a bloody coup that threatens to destroy everyone and everything that holds meaning in his mercenary life, Locke vows to beat the enemy at his own brutal game... or die trying.

#### [The Hobbit](http://www.goodreads.com/book/show/5907.The_Hobbit) _by [J.R.R. Tolkien](https://en.wikipedia.org/wiki/J._R._R._Tolkien)_ [4.2] :star2: :fire:

A pretty good children's story. Defined modern fantasy as we know it. - [@RichardLitt](https://github.com/RichardLitt)

> In a hole in the ground there lived a hobbit. Not a nasty, dirty, wet hole, filled with the ends of worms and an oozy smell, nor yet a dry, bare, sandy hole with nothing in it to sit down on or to eat: it was a hobbit-hole, and that means comfort.
> Written for J.R.R. Tolkien’s own children, The Hobbit met with instant critical acclaim when it was first published in 1937. Now recognized as a timeless classic, this introduction to the hobbit Bilbo Baggins, the wizard Gandalf, Gollum, and the spectacular world of Middle-earth recounts of the adventures of a reluctant hero, a powerful and dangerous ring, and the cruel dragon Smaug the Magnificent.

#### [The King of Elfland's Daughter](http://www.goodreads.com/book/show/14686.The_King_of_Elfland_s_Daughter) _by [Lord Dunsanay](https://en.wikipedia.org/wiki/Edward_Plunkett,_18th_Baron_of_Dunsany)_ [3.8]

Read this if you want to go on an acid trip and if you want to see the roots of modern fantasy. - [@RichardLitt](https://github.com/RichardLitt)

> The poetic style and sweeping grandeur of The King of Elfland's Daughter has made it one of the most beloved fantasy novels of our time, a masterpiece that influenced some of the greatest contemporary fantasists. The heartbreaking story of a marriage between a mortal man and an elf princess is a masterful tapestry of the fairy tale following the "happily ever after."

#### [The Nevernight Chronicle](https://www.goodreads.com/series/164599-the-nevernight-chronicle) _by [Jay Kristoff](https://en.wikipedia.org/wiki/Jay_Kristoff)_

This is an absolutely amazing series. If you're looking for epic bloody action, saucy romance, and thrilling reveals, then look no further. - [@Charpal](https://github.com/Charpal)

Books:

1. [Nevernight](https://www.goodreads.com/book/show/26114463-nevernight) [4.2]
2. [Godsgrave](https://www.goodreads.com/book/show/23264671-godsgrave) [4.5]
3. [Darkdawn](https://www.goodreads.com/book/show/23264672-darkdawn) [4.3]

> The Nevernight Chronicle is the New York Times bestselling fantasy series by award-winning author Jay Kristoff, which follows flawed heroine Mia Corvere as she trains as an assassin as part of her mission for personal revenge. Her tale takes place in the immersive world of Godsgrave and is full of fast-paced action, magic, betrayal, vengeance, and more.

#### [The Ocean at the End of the Lane](https://www.goodreads.com/book/show/15783514-the-ocean-at-the-end-of-the-lane) _by [Neil Gaiman](https://en.wikipedia.org/wiki/Neil_Gaiman)_ [4.0]

This was a delightful book. Short and sweet, it exhibits both Gaiman's ability to run with magic, and his deep love for the English countryside and mythology. - [@RichardLitt](https://github.com/RichardLitt)

> Sussex, England. A middle-aged man returns to his childhood home to attend a funeral. Although the house he lived in is long gone, he is drawn to the farm at the end of the road, where, when he was seven, he encountered a most remarkable girl, Lettie Hempstock, and her mother and grandmother. He hasn't thought of Lettie in decades, and yet as he sits by the pond (a pond that she'd claimed was an ocean) behind the ramshackle old farmhouse, the unremembered past comes flooding back. And it is a past too strange, too frightening, too dangerous to have happened to anyone, let alone a small boy.
>
> Forty years earlier, a man committed suicide in a stolen car at this farm at the end of the road. Like a fuse on a firework, his death lit a touch paper and resonated in unimaginable ways. The darkness was unleashed, something scary and thoroughly incomprehensible to a little boy. And Lettie—magical, comforting, wise beyond her years—promised to protect him, no matter what.
>
> A groundbreaking work from a master, The Ocean at the End of the Lane is told with a rare understanding of all that makes us human, and shows the power of stories to reveal and shelter us from the darkness inside and out. It is a stirring, terrifying, and elegiac fable as delicate as a butterfly's wing and as menacing as a knife in the dark.

#### [The Second Apocalypse](https://www.goodreads.com/series/83561-the-second-apocalypse) by [R. Scott Bakker](https://en.wikipedia.org/wiki/R._Scott_Bakker)

A huge world, much inspired by our own, rife with conflict, religious strife, and extremely powerful magic. There is plenty of darkness, horror, cruelty, heroism, sacrifice, and any content trigger you can imagine. If you are not easily impressed, you will find a deeply philosophical series, with compelling characters, and amazing prose. Perhaps the darkest fantasy series out there (so far), it is made of a trilogy (The Prince of Nothing) and a quadrilogy (The Aspect-Emperor) that directly follows the events of the first three books. Possibly a closing trilogy will be published, but the author has not promised anything. A masterpiece, but not for everybody. [@Donearm](https://github.com/Donearm)

> R. Scott Bakker's work is dominated by a sprawling series informally known as The Second Apocalypse which he began developing while in college in the 1980s. The series was originally planned to be a trilogy with the first two books entitled The Prince of Nothing and The Aspect-Emperor.

Prince of Nothing trilogy:

1. [The Darkness that Comes Before](https://www.goodreads.com/book/show/301538.The_Darkness_That_Comes_Before) [3.82]
2. [The Warrior Prophet](https://www.goodreads.com/book/show/18877.The_Warrior_Prophet) [3.97]
3. [The Thousandfold Thought](https://www.goodreads.com/book/show/13806.The_Thousandfold_Thought) [3.94]

Aspect-Emperor quadrilogy:

1. [The Judging Eye](https://www.goodreads.com/book/show/4117865-the-judging-eye) [4.01]
2. [The White Luck Warrior](https://www.goodreads.com/book/show/7704943-the-white-luck-warrior) [4.11]
3. [The Great Ordeal](https://www.goodreads.com/book/show/27160926-the-great-ordeal) [4.07]
4. [The Unholy Consult](https://www.goodreads.com/book/show/9968073-the-unholy-consult) [3.88]

#### [The Smith of Wooten Major](http://www.goodreads.com/book/show/1018117.Smith_of_Wooten_Major_and_Farmer_Giles_of_Ham) _by [J.R.R. Tolkien](https://en.wikipedia.org/wiki/J._R._R._Tolkien)_ [4.0]

Smith of Wooton Major is my favourite story by Tolkien, hands down. Lord of the Rings and all of Middle Earth can rot in comparison to this small, finely crafted story about a smith who goes to Faery, and a cook who bakes a cake. - [@RichardLitt](https://github.com/RichardLitt)

> In Smith of Wooton Major, Tolkien explores the gift of fantasy, and what it means to the life and character of the man who receives it.

#### [The Witcher](https://en.wikipedia.org/wiki/The_Witcher) _by [Andrzej Sapkowski](https://en.wikipedia.org/wiki/Andrzej_Sapkowski)_

Great books especially if you like folklore of Central Europe or you played Witcher 3 video game or want to read it before watching the Netflix show. - [@hercegtomas](https://github.com/hercegtomas)

> Geralt of Rivia is a witcher. A cunning sorcerer. A merciless assassin. And a cold-blooded killer. His sole purpose: to destroy the monsters that plague the world. But not everything monstrous-looking is evil and not everything fair is good... and in every fairy tale there is a grain of truth.

Books:

- [The Last Wish](https://www.goodreads.com/book/show/40603587-the-last-wish) [4.19] :fire:
- [Sword of Destiny](https://www.goodreads.com/hr/book/show/24709918-sword-of-destiny) [4.36]
- [Blood of Elves](https://www.goodreads.com/book/show/6043781-blood-of-elves) [4.18]
- [Time of Contempt](https://www.goodreads.com/sl/book/show/18924206-the-time-of-contempt) [4.27]
- [Baptism of Fire](https://www.goodreads.com/nl/book/show/26080167-baptism-of-fire) [4.35]
- [The Tower of the Swallow](https://www.goodreads.com/book/show/30079689-the-tower-of-swallows) [4.32]
- [The Lady of the Lake](https://www.goodreads.com/hu/book/show/32841081-lady-of-the-lake) [4.25]
- [Season of Storms](https://www.goodreads.com/lt/book/show/36099978-season-of-storms) [3.94]

#### [The Wizard Knight](http://www.goodreads.com/book/show/101949.The_Wizard_Knight) _by [Gene Wolfe](https://en.wikipedia.org/wiki/Gene_Wolfe)_ [3.8]

I read this book at least once a year. The story is well told, easily approachable, has a lot of gems, and is a good trip. - [@RichardLitt](https://github.com/RichardLitt)

> A young man in his teens is transported from our world to a magical realm that contains seven levels of reality. Very quickly transformed by magic into a grown man of heroic proportions, he takes the name Able and sets out on a quest to find the sword that has been promised to him, a sword he will get from a dragon, the one very special blade that will help him fulfill his life ambition to become a knight and a true hero. Inside, however, able remains a boy, and he must grow in every sense to survive the dangers and delights that lie ahead in encounters with giants, elves, wizards, and dragons. His adventure will conclude in the second volume of The Wizard Knight, The Wizard. With this new series, Wolfe not only surpasses all the most popular genre writers of the last three decades, he takes on the legends of the past century, in a work that will be favorably compared with the best of J. R. R. Tolkien, E. R. Eddison, Mervyn Peake, and T. H. White. This is a book---and a series---for the ages, from perhaps the greatest living writer in (or outside) the fantasy genre.

#### [Vicious](https://www.goodreads.com/book/show/40874032-vicious) _by [V.E. Schwab](https://en.wikipedia.org/wiki/V._E._Schwab)_ [4.25]

A fantastic start to an amazing series. Schwab really knows how to 'set a scene', and create an environment that grips you and doesn't let go. - [@masonbose](https://github.com/masonbose)

> Victor and Eli started out as college roommates—brilliant, arrogant, lonely boys who recognized the same sharpness and ambition in each other. In their senior year, a shared research interest in adrenaline, near-death experiences, and seemingly supernatural events reveals an intriguing possibility: that under the right conditions, someone could develop extraordinary abilities. But when their thesis moves from the academic to the experimental, things go horribly wrong.

### Allegory

#### [Kafka On the Shore](https://www.goodreads.com/book/show/4929.Kafka_on_the_Shore) _by [Haruki Murakami](https://en.wikipedia.org/wiki/Haruki_Murakami)_ [4.1]

This book is a metaphor. It is poignant, magical and somewhat weird. If you want to get swept away and really dive into a story, stop whatever you are doing and find a way to get your hands on a copy of this book. This is a story of a young man who is discovering himself where he meets a lot of people and experiences  different feelings altogether. Reality almost seems sterile when we immerse ourselves in this book. It a must read book for fantasy lovers. - [@NehaChaudhary311](https://github.com/NehaChaudhary311)

> Kafka on the Shore, a tour de force of metaphysical reality, is powered by two remarkable characters: a teenage boy, Kafka Tamura, who runs away from home either to escape a gruesome oedipal prophecy or to search for his long-missing mother and sister; and an aging simpleton called Nakata, who never recovered from a wartime affliction and now is drawn toward Kafka for reasons that, like the most basic activities of daily life, he cannot fathom. Their odyssey, as mysterious to them as it is to us, is enriched throughout by vivid accomplices and mesmerizing events. Cats and people carry on conversations, a ghostlike pimp employs a Hegel-quoting prostitute, a forest harbors soldiers apparently unaged since World War II, and rainstorms of fish (and worse) fall from the sky. There is a brutal murder, with the identity of both victim and perpetrator a riddle—yet this, along with everything else, is eventually answered, just as the entwined destinies of Kafka and Nakata are gradually revealed, with one escaping his fate entirely and the other given a fresh start on his own.

#### [Lilith](http://www.goodreads.com/book/show/268187.Lilith) _by [George MacDonald](https://en.wikipedia.org/wiki/George_MacDonald)_ [3.9]

This was a weird, weird book, just like _Phantastes_. George MacDonald had a gift for writing essentially plotless books that journey through fantastic realms; but at no point do they ever become uninteresting. They were also the inspiration for a lot of later writers, most notably CS Lewis, and it is easy to see why. Worth the read. - [@RichardLitt](https://github.com/RichardLitt)

> After he followed the old man through the mirror, nothing in his life was ever right again. It was a special mirror and the man he followed was a special man - a man who led him to the things that underlie the fate of all creation. Lilith is considered among the darkest of MacDonald's works, and among the most profound. It is a story concerning the nature of life, death, and salvation. In the story, MacDonald mentions a cosmic sleep that heals tortured souls, preceding the salvation of all.

#### [Phantastes](http://www.goodreads.com/book/show/174948.Phantastes) _by [George MacDonald](https://en.wikipedia.org/wiki/George_MacDonald)_ [4.0]

See the review for _Lilith_, above. - [@RichardLitt](https://github.com/RichardLitt)

> "I was dead, and right content," the narrator says in the penultimate chapter of Phantastes. C.S. Lewis said that upon reading this astonishing 19th-century fairy tale he "had crossed a great frontier," and numerous others both before and since have felt similarly. In MacDonald's fairy tales, both those for children and (like this one) those for adults, the "fairy land" clearly represents the spiritual world, or our own world revealed in all of its depth and meaning. At times almost forthrightly allegorical, at other times richly dreamlike (and indeed having a close connection to the symbolic world of dreams), this story of a young man who finds himself on a long journey through a land of fantasy is more truly the story of the spiritual quest that is at the core of his life's work, a quest that must end with the ultimate surrender of the self. The glory of MacDonald's work is that this surrender is both hard won (or lost ) and yet rippling with joy when at last experienced. As the narrator says of a heavenly woman in this tale, "She knew something too good to be told." One senses the same of the author himself.

#### [Pilgrim's Progress](http://www.goodreads.com/book/show/29797.The_Pilgrim_s_Progress) _by [John Bunyan](https://en.wikipedia.org/wiki/John_Bunyan)_ [4.0]

You know, this is still a pretty good read even if you're not a Christian. Christian, the protagonist, is pretty beleaguered by every possible obstacle on his way to Heaven, and it's fun just hearing how he gets out of scrapes. - [@RichardLitt](https://github.com/RichardLitt)

> This work is written in the King James/ Shakespearean/ Old English language. It is the story of a man becoming saved and his dangerous and challenging journey to the Celestial City.

#### [The Chronicles of Narnia](https://en.wikipedia.org/wiki/The_Chronicles_of_Narnia) _by [C.S. Lewis](https://en.wikipedia.org/wiki/C._S._Lewis)_

These books are great, quick reading, although the Christian overtones can grow old with time. I'm not quite sure how to suggest them, as I grew up with them - but I can't imagine not having done so. Reading about Mr. Tumnus carrying parcels through a snowy forest in The Lion, The Witch, and the Wardrobe is one of my earliest memories. - [@RichardLitt](https://github.com/RichardLitt)

Books:

- [The Magician’s Nephew](http://www.goodreads.com/book/show/509797.The_Magician_s_Nephew) :star2: :fire:
- [The Lion, The Witch, and The Wardrobe](http://www.goodreads.com/book/show/100915.The_Lion_the_Witch_and_the_Wardrobe) :star2: :fire:
- [The Horse and His Boy](http://www.goodreads.com/book/show/84119.The_Horse_and_His_Boy) :star2: :fire:
- [Prince Caspian](http://www.goodreads.com/book/show/121749.Prince_Caspian) :star2: :fire:
- [The Voyage of the Dawn Treader](http://www.goodreads.com/book/show/140225.The_Voyage_of_the_Dawn_Treader) :star2: :fire:
- [The Silver Chair](http://www.goodreads.com/book/show/65641.The_Silver_Chair) :star2: :fire:
- [The Last Battle](http://www.goodreads.com/book/show/84369.The_Last_Battle) :star2: :fire:

### Satire

#### [Discworld](https://en.wikipedia.org/wiki/Discworld) _by [Terry Pratchett](https://en.wikipedia.org/wiki/Terry_Pratchett)_

Discworld is a massive, sprawling world outlined in dozens of books by the late Terry Pratchett. Rather than list them all here, here are a few that have been read by contributors of this list, with comments on each.

> Discworld is a flat planet, standing on the shoulders of four giant elephants, who live on the shell of a gigantic turtle, the great A'Tuin, whose sex is unknown and currently under heavy investigation. In the city of Ankh-Morpok, where the thieves and assassins guilds offer their services at reasonable price, there is the Unseen University, where wizards learn how to use the magic and do wizard stuff, like getting drunk, murdering each other and growing beards. Rincewind is a wizard who can't cast a single spell; he will be forced into being the tourist guide for Twoflowers, an innocent and naive tourist from a far realm followed by a murderous legged luggage...

Books:

- [The Colour of Magic](http://www.goodreads.com/book/show/601238.The_Colour_of_Magic) [3.9]
  This is the first book of the series Discworld. The books can be read in order or independently. There are several narrative threads that cross quite often creating a funny and enjoyable reading experience.

  I love this book. The style is original and hilarious and the characters' personality is deeply developed. Death alone is a good reason to read this book. - [@fourlastor](https://github.com/fourlastor)

- [Mort](https://www.goodreads.com/book/show/386372.Mort) [4.2]
  This was my intro to Discworld, and I loved it. Death is hilarious. - [@RichardLitt](https://github.com/RichardLitt)
- [Making Money](https://www.goodreads.com/book/show/116296.Making_Money) [4.2]
  How Terry Pratchett consistently came up with good stories is beyond me. This one is also good, particularly for how TP envisions banks and automatons. - [@RichardLitt](https://github.com/RichardLitt)

#### [Farmer Giles of Ham](http://www.goodreads.com/book/show/66797.Smith_of_Wootton_Major_Farmer_Giles_of_Ham) _by [J.R.R. Tolkien](https://en.wikipedia.org/wiki/J._R._R._Tolkien)_ [3.9]

Farmer Giles is one of my favourite encapsulated stories set in something akin to Old England. It's basically Tolkien's nod to classic fairy tale writers like Lord Dunsanay or MacDonald, but with some humor. "Give us your crown!" is one of my favourite quotes, and I am totally going to name my dog Garm. - [@RichardLitt](https://github.com/RichardLitt)

> The editors of the best-selling rediscovered Tolkien novel Roverandom present an expanded fiftieth anniversary edition of Tolkien's beloved classic Farmer Giles of Ham, complete with a map, the original story outline, the original first-edition illustrations by Pauline Baynes, and the author's notes for an unpublished sequel. Farmer Giles of Ham is a light-hearted satire for readers of all ages that tells the tale of a reluctant hero who must save his village from a dragon. It is a small gem of a tale that grows more delightful with each rereading.

#### [Good Omens](https://www.goodreads.com/book/show/12067.Good_Omens) _by [Terry Pratchett](https://en.wikipedia.org/wiki/Terry_Pratchett) and [Neil Gaiman](https://en.wikipedia.org/wiki/Neil_Gaiman)_ [4.3]

This was a fun book, and a great collaboration. At times it is a bit clear where Neil Gaiman was writing, and I'm not sure that the book is better for his inclusions at points; he hadn't yet perfected his craft, I think. But the story as a whole is good. - [@RichardLitt](https://github.com/RichardLitt)

> According to The Nice and Accurate Prophecies of Agnes Nutter, Witch (the world's only completely accurate book of prophecies, written in 1655, before she exploded), the world will end on a Saturday. Next Saturday, in fact. Just before dinner.
>
> So the armies of Good and Evil are amassing, Atlantis is rising, frogs are falling, tempers are flaring. Everything appears to be going according to Divine Plan. Except a somewhat fussy angel and a fast-living demon — both of whom have lived amongst Earth's mortals since The Beginning and have grown rather fond of the lifestyle — are not actually looking forward to the coming Rapture.
>
> And someone seems to have misplaced the Antichrist . . .

#### [The Princess Bride](http://www.goodreads.com/book/show/21787.The_Princess_Bride) _by [William Goldman](https://en.wikipedia.org/wiki/William_Goldman)_ [4.2] :fire:

This is a book that doesn't take away from the classic movie rendition of it, but adds to it. It stands alone as a fun little read. - [@RichardLitt](https://github.com/RichardLitt)

> What happens when the most beautiful girl in the world marries the handsomest prince of all time and he turns out to be...well...a lot less than the man of her dreams? As a boy, William Goldman claims, he loved to hear his father read the S. Morgenstern classic, The Princess Bride. But as a grown-up he discovered that the boring parts were left out of good old Dad's recitation, and only the "good parts" reached his ears. Now Goldman does Dad one better. He's reconstructed the "Good Parts Version" to delight wise kids and wide-eyed grownups everywhere. What's it about? Fencing. Fighting. True Love. Strong Hate. Harsh Revenge. A Few Giants. Lots of Bad Men. Lots of Good Men. Five or Six Beautiful Women. Beasties Monstrous and Gentle. Some Swell Escapes and Captures. Death, Lies, Truth, Miracles, and a Little Sex. In short, it's about everything.

### [A Series of Unfortunate Events](https://en.wikipedia.org/wiki/A_Series_of_Unfortunate_Events) _by [Lemony Snicket AKA Daniel Handler](https://en.wikipedia.org/wiki/Daniel_Handler) 🔥 [4.00]

A Series of Unfortunate Events follows the story of the Baudelaire kids Violet, Klaus and Sunny as they navigate the aftermath of their parents' death and try to escape the evil clutches of their distant relative Count Olaf. - [@umadhatri](https://github.com/umadhatri)

> These books were my childhood. I love the dry and satirical humor as the author puts these kids through incredibly campy situations and they find increasingly clever ways to escape the evil Count. The kids are just the sweetest characters and as a kid I enjoyed the adventures that they went on in each of the books. The narrator Lemony Snicket almost enjoys reliving the tales of the kids' adventures in a sort of devilish way. The Netflix adaptation was just as deliciously good as the books. People might not agree with me, but then, everybody has their own opinions.

Books:
- [The Bad Beginging](https://www.goodreads.com/book/show/78411.The_Bad_Beginning)
- [The Reptile Room](https://www.goodreads.com/book/show/78418.The_Reptile_Room) 🔥
- [The Wide Window](https://www.goodreads.com/book/show/438492.The_Wide_Window) 🔥
- [The Miserable Mill](https://www.goodreads.com/book/show/65119.The_Miserable_Mill) 🔥
- [The Austere Academy](https://www.goodreads.com/book/show/131123.The_Austere_Academy) 🔥
- [The Ersatz Elevator](https://www.goodreads.com/book/show/172327.The_Ersatz_Elevator) 🔥
- [The Vile Village](https://www.goodreads.com/book/show/150037.The_Vile_Village) 🔥
- [The Hostile Hospital](https://www.goodreads.com/book/show/65118.The_Hostile_Hospital) 🔥
- [The Carnivorous Carnival](https://www.goodreads.com/book/show/324277.The_Carnivorous_Carnival) 🔥
- [The Slippery Slope](https://www.goodreads.com/book/show/297792.The_Slippery_Slope) 🔥
- [The Grim Grotto](https://www.goodreads.com/book/show/65111.The_Grim_Grotto) 🔥
- [The Penultimate Peril](https://www.goodreads.com/book/show/65110.The_Penultimate_Peril)
- [The End](https://www.goodreads.com/book/show/65112.The_End)

### Horror

#### [The Call of Cthulhu and Other Weird Stories](https://www.goodreads.com/book/show/160149.The_Call_of_Cthulhu_and_Other_Weird_Stories) _by [H.P. Lovecraft](https://en.wikipedia.org/wiki/H._P._Lovecraft)_ [4.3]

Horror wouldn't be what it is today without HP Lovecraft. He spawned an entire sub-genre of weird aliens and psychological threats; some of the stories in this book are so good that I still shudder when I think of them. A master at work. - [@RichardLitt](https://github.com/RichardLitt)

> An unparalleled selection of fiction from H. P. Lovecraft, master of the American horror tale
>
> Long after his death, H. P. Lovecraft continues to enthrall readers with his gripping tales of madness and cosmic terror, and his effect on modern horror fiction continues to be felt - Stephen King, Anne Rice, and Clive Barker have acknowledged his influence. His unique contribution to American literature was a melding of Poe's traditional supernaturalism with the emerging genre of science fiction. Originally appearing in pulp magazines like Weird Tales in the 1920s and 1930s, Lovecraft's work is now being regarded as the most important supernatural fiction of the twentieth century.
>
> Lovecraft's biographer and preeminent interpreter, S. T. Joshi, has prepared this volume of eighteen stories--from the early classics like "The Outsider" and "Rats in the Wall" to his mature masterworks, "The Call of Cthulhu" and "The Shadow over Innsmouth." The first paperback to include the definitive corrected texts, The Call of Cthulhu and Other Weird Stories reveals the development of Lovecraft's mesmerizing narrative style, and establishes him as a canonical--and visionary--American writer.
>
> "I think it is beyond doubt that H. P. Lovecraft has yet to be surpassed as the twentieth century's greatest practitioner of the classic horror tale." --Stephen King

#### [Under The Dome](https://www.goodreads.com/book/show/7137788-under-the-dome) _by [Stephen King](https://en.wikipedia.org/wiki/Stephen_King)_ [3.9] :fire:

Stephen King is as brilliant as he is prolific, having penned over fifty worldwide bestsellers and won multiple awards for his writing. Under The Dome is a real page turner that will keep you worrying about the wonderful and frightening cast of characters. It's no surprise a show was made based on the novel. - [@JamesDrysdale](https://github.com/JamesDrysdale)

> The small town of Chester's Mill, Maine is inexplicably and suddenly sealed off from the rest of the world by an invisible force field. No one can get in or out and the normal rules of society suddenly change when resources run short. A new and more sinister social order develops. A handful of citizens team up to fight the corruption sweeping through the town and to try to discover the source of the Dome before it's too late.

### Children's Books

#### [Dealing with Dragons](https://www.goodreads.com/book/show/150739.Dealing_with_Dragons) _by [Patricia C. Wrede](https://en.wikipedia.org/wiki/Patricia_Wrede)_ [4.15]

Fell in love with this book when I first read it in 4th grade. I had always liked fairy tales, but this was the first I read that subverted the usual tropes. - [@konpyuta](https://github.com/konpyuta)

> Cimorene is everything a princess is not supposed to be: headstrong, tomboyish, smart - and bored. So bored that she runs away to live with a dragon - and finds the family and excitement she's been looking for.

#### [Howl's Moving Castle](https://www.goodreads.com/book/show/6294.Howl_s_Moving_Castle) _by [Diana Wynne Jones](https://en.wikipedia.org/wiki/Diana_Wynne_Jones)_ [4.3]

The original story that inspired Miyazaki's film adaptation. Has a colorful, fun, and whimsical tone, but has an interesting twist. - [@konpyuta](https://github.com/konpyuta)

> Sophie has the great misfortune of being the eldest of three daughters, destined to fail miserably should she ever leave home to seek her fate. But when she unwittingly attracts the ire of the Witch of the Waste, Sophie finds herself under a horrid spell that transforms her into an old lady. Her only chance at breaking it lies in the ever-moving castle in the hills: the Wizard Howl's castle. To untangle the enchantment, Sophie must handle the heartless Howl, strike a bargain with a fire demon, and meet the Witch of the Waste head-on. Along the way, she discovers that there's far more to Howl—and herself—than first meets the eye.

#### [The Neverending Story](https://www.goodreads.com/book/show/27712.The_Neverending_Story) _by [Michael Ende](https://en.wikipedia.org/wiki/Michael_Ende)_ [4.18] :fire:

The story is a beautifully layered tale that blurs reality and fiction, filled with vivid characters and profound reflections that linger long after reading. - [@benya2bfh](https://github.com/benya2bfh)

> This epic work of the imagination has captured the hearts of millions of readers worldwide since it was first published. Its special story within a story is an irresistible invitation for readers to become part of the book itself.

> The story begins with a lonely boy named Bastian and the strange book that draws him into the beautiful but doomed world of Fantastica. Only a human can save this enchanted place by giving its ruler, the Childlike Empress, a new name. But the journey to her tower leads through lands of dragons, giants, monsters, and magic, and once Bastian begins his quest, he may never return. As he is drawn deeper into Fantastica, he must find the courage to face unspeakable foes and the mysteries of his own heart.

> Readers, too, can travel to the wondrous, unforgettable world of Fantastica if they will just turn the page...

#### [The Saga of Eric the Viking](https://www.goodreads.com/book/show/700349.The_Saga_of_Eric_the_Viking) _by [Terry Jones](https://en.wikipedia.org/wiki/Terry_Jones), [Michael Foreman](<https://en.wikipedia.org/wiki/Michael_Foreman_(author/illustrator)>)\_ [3.94]

One of the earliest books I can recall reading. This book is the best. - [@RichardLitt](https://github.com/RichardLitt)

> 'This is one tale of a Viking warrior who lived hundreds and hundreds of years ago. His name is Erik.' And Erik is no ordinary Viking. With his trusty band of men he sets sail in search of the land where the sun goes at night. In fact, he finds much more! The Sea Dragon, the Old Man of the Sea, Dogfighters and giants combine to make his voyage a great saga of thrilling adventures.

## Comic Books

#### [Delilah Dirk and the Turkish Lieutenant](https://www.goodreads.com/book/show/17261174-delilah-dirk-and-the-turkish-lieutenant) _by [Tony Cliff](https://www.goodreads.com/author/show/4593587.Tony_Cliff)_ [3.94]

Great adventure with a strong female protagonist. In a historical-based setting with interesting fantasy elements interspersed with cultural details. - [@konpyuta](https://github.com/konpyuta)

> Lovable ne'er-do-well Delilah Dirk has travelled to Japan, Indonesia, France, and even the New World. Using the skills she's picked up on the way, Delilah's adventures continue as she plots to rob a rich and corrupt Sultan in Constantinople. With the aid of her flying boat and her newfound friend, Selim, she evades the Sultan's guards, leaves angry pirates in the dust, and fights her way through the countryside. For Delilah, one adventure leads to the next in this thrilling and funny installment in her exciting life.

#### [Seconds](https://www.goodreads.com/book/show/18630542-seconds) _by [Bryan Lee O'Malley](https://en.wikipedia.org/wiki/Bryan_Lee_O%27Malley), [Nathan Fairbairn](https://www.goodreads.com/author/show/6497026.Nathan_Fairbairn)_ [4.07]

A colorful, funny, and heart-warming take on the consequences of being able to change the past. The best word to describe this comic is delightful. - [@sunrein](https://github.com/sunrein)

> Katie’s got it pretty good. She’s a talented young chef, she runs a successful restaurant, and she has big plans to open an even better one. Then, all at once, progress on the new location bogs down, her charming ex-boyfriend pops up, her fling with another chef goes sour, and her best waitress gets badly hurt. And just like that, Katie’s life goes from pretty good to not so much. What she needs is a second chance. Everybody deserves one, after all—but they don’t come easy. Luckily for Katie, a mysterious girl appears in the middle of the night with simple instructions for a do-it-yourself do-over:
>
> 1. Write your mistake
> 2. Ingest one mushroom
> 3. Go to sleep
> 4. Wake anew
>
> And just like that, all the bad stuff never happened, and Katie is given another chance to get things right. She’s also got a dresser drawer full of magical mushrooms—and an irresistible urge to make her life not just good, but perfect. Too bad it’s against the rules. But Katie doesn’t care about the rules—and she’s about to discover the unintended consequences of the best intentions.
>
> From the mind and pen behind the acclaimed Scott Pilgrim series comes a madcap new tale of existential angst, everyday obstacles, young love, and ancient spirits that’s sharp-witted and tenderhearted, whimsical and wise.

#### [The Black Bull of Norroway](https://www.goodreads.com/book/show/39913349-the-black-bull-of-norroway) _by [Cat Seaton](https://www.goodreads.com/author/show/15307132.Cat_Seaton), [Kit Seaton](https://www.goodreads.com/author/show/7989199.Kit_Seaton)_ [3.76]

Gorgeous comic based on a classic Scottish fairy tale, with lots of diversity represented. - [@konpyuta](https://github.com/konpyuta)

> Sibylla always wanted adventure, but she didn't know it would come in the form of a giant, magical bull. Is he a man or a monster? And who knew a prophecy could be so literal?

#### [The Miraculous Journey of Edward Tulane](https://www.goodreads.com/book/show/37186.The_Miraculous_Journey_of_Edward_Tulane) _by [Kate diCamillo](https://www.goodreads.com/author/show/13663.Kate_DiCamillo), [Bagram Ibatoulline](https://www.goodreads.com/author/show/1354902.Bagram_Ibatoulline)_ [4.36]

A heartwarming book that will teach adults and children to love and to let yourself be loved. 

Kate DiCamillo takes us on an extraordinary journey, from the depths of the ocean to the net of a fisherman, from the top of a garbage heap to the fireside of a hoboes' camp, from the bedside of an ailing child to the bustling streets of Memphis. And along the way, we are shown a true miracle — that even a heart of the most breakable kind can learn to love, to lose, and to love again. - [@e-costalmeida](https://github.com/e-costalmeida)

> Once, in a house on Egypt Street, there lived a china rabbit named Edward Tulane. The rabbit was very pleased with himself, and for good reason: he was owned by a girl named Abilene, who treated him with the utmost care and adored him completely.
>
> And then, one day, he was lost.

#### [Usagi Yojimbo](https://www.goodreads.com/series/71007-usagi-yojimbo) (1987) _by [Stan Sakai](https://en.wikipedia.org/wiki/Stan_Sakai)_ [4.1]

This series does a great job of portraying samurai life in ancient Japan, with characters who are all animals. The artistic style is simple and clean. - [@depperm](https://github.com/depperm)

> Miyamoto Usagi is no Bugs Bunny. He's a rabbit bodyguard, a samurai who wanders the mountains, plains, and villages of a 17th-century Japan populated almost exclusively by anthropomorphic animals. Cats, snakes, rhinos, and ninja moles plot and fight their way across a land ravaged by civil war. The 10 stories in this first collection introduce Usagi, the evil Lord Hikiji, and a host of other characters. The stories themselves can stand alone, but taken together they begin to form an ongoing saga of treachery and revenge. Sometimes violent, sometimes funny, Usagi's adventures are filled with fascinating historical detail. The costumes, landscapes, and buildings are beautifully drawn, creating such a sense of realism it's easy to forget the hero is a rabbit. If you buy the first book in this series, you'll want the rest.

## Movies

#### [Interstellar](https://www.imdb.com/title/tt0816692/) [8.6]
Best movie for SciFi lovers an Space enthusiast.
All important science fiction concepts combied together feels like magic of astronomy and science.-[@yuvihere23](https://github.com/yuvihere23)

>A team of explorers travel through a wormhole in space in an attempt to ensure humanity's survival.

#### [Birth](https://www.imdb.com/title/tt0337876/) [6.1]

A brilliant fantasy movie. Underrated. - [@ErvinaDe](https://github.com/ErvinaDe)

> A young boy attempts to convince a woman that he is her dead husband reborn.

#### [Dragonheart](http://www.imdb.com/title/tt0116136/) [6.4] :star2:

Sean Connery is the best dragon ever. This is a classic film. - [@RichardLitt](https://github.com/RichardLitt)

> The last dragon and a disillusioned dragon-slaying knight must cooperate to stop an evil king who was given partial immortality.

#### [Fire and Ice](https://www.imdb.com/title/tt0085542/) [6.6]

An animated fantasy classic collaboration between Ralph Bakshi and Frank Frazetta. This movie has great animation and even greater action. - [@teav](https://github.com/teav)

> At the end of the ice age, an evil queen and her son are set on conquering the world using magic and warriors. The lone survivor of a crushed village fights back as does the king of Fire Keep.

#### [Highlander](http://www.imdb.com/title/tt0091203/) [7.2]

This is an awesomely atrocious film. The only thing that is awesome about it is how amazingly poorly done everything is, and yet how it still is extremely entertaining. A must. - [@RichardLitt](https://github.com/RichardLitt)

> An immortal Scottish swordsman must confront the last of his immortal opponent, a murderously brutal barbarian who lusts for the fabled "Prize".

#### [Highlander II: The Quickening](https://www.imdb.com/title/tt0102034/) [4.3]

Worse than the first, but in the best way possible. - [@teav](https://github.com/teav)

> In the future, Highlander Connor MacLeod must prevent the destruction of Earth under an anti-ozone shield.

#### [Krull](http://www.imdb.com/title/tt0085811/) [6.0]

Truly a horrendous film. But would make a great drinking game, so I am including it. Also, early Liam Neeson is great. - [@RichardLitt](https://github.com/RichardLitt)

> A prince and a fellowship of companions set out to rescue his bride from a fortress of alien invaders who have arrived on their home planet.

#### [Labyrinth](http://www.imdb.com/title/tt0091369/) [7.4]

This is one of the weirder cult classics to come out of the 80's. I wouldn't include this here if David Bowie's performance wasn't so incredible. But it is. - [@RichardLitt](https://github.com/RichardLitt)

> A selfish 16-year old girl is given 13 hours to solve a labyrinth and rescue her baby brother when her wish for him to be taken away is granted by the Goblin King.

#### [Midnight in Paris](https://www.imdb.com/title/tt1605783/) [7.7]

This movie really captures the ways thinking of some writers who are always wondering how would it be if they lived in some other century. Besides, Owen Wilson killed it. - [@ErvinaDe](https://github.com/ErvinaDe)

> While on a trip to Paris with his fiancée's family, a nostalgic screenwriter finds himself mysteriously going back to the 1920s everyday at midnight.

#### [Percy Jackson & the Olympians: The Lightning Thief](https://www.imdb.com/title/tt0814255/) [5.9]

Kids have been waiting for this movie adaptation for a long time; too bad they'll be disappointed. A movie with demigods in a modern era. - [@AshishKnightfury](https://github.com/AshishKnightfury)

> A teenager discovers he's the descendant of a Greek god and sets out on an adventure to settle an on-going battle between the gods.

#### [Princess Mononoke](https://www.imdb.com/title/tt0119698/) [8.4]

Beautiful and stunning film with strong female characters. Even if you're not familiar with Japanese animation movies, I'm sure you will enjoy this one. - [@maysaborges](https://github.com/maysaborges)

> On a journey to find the cure for a Tatarigami's curse, Ashitaka finds himself in the middle of a war between the forest gods and Tatara, a mining colony. In this quest he also meets San, the Mononoke Hime.

#### [Puss in Boots: The Last Wish](https://www.imdb.com/title/tt3915174/) [7.9]

A fun and thrilling sequel, I enjoyed this adventure of found family and figuring out what you want is already with you. Great cast of characters and villains, this movie makes good use of the motivations they all have. - [@Shadowsarespooky] (https://github.com/Shadowsarespooky)

> When Puss in Boots discovers that his passion for adventure has taken its toll and he has burned through eight of his nine lives, he launches an epic journey to restore them by finding the mythical Last Wish.

#### [Reign of Fire](http://www.imdb.com/title/tt0253556/) [6.2]

An incredible film for the vision of the world, and the way they combine medieval technology with modern warfare. The dragons are bad-ass. - [@RichardLitt](https://github.com/RichardLitt)

> A brood of fire-breathing dragons emerges from the earth and begins setting fire to everything, establishing dominance over the planet.

#### [Spirited Away](https://www.imdb.com/title/tt0245429/) [8.6]

A beautifully drawn and wonderfully composed work of art - really, no other description will do. Don't let the fact that it is animated scare you. Just watch it! - [@TheSherlockHomie](https://github.com/TheSherlockHomie)

> During her family's move to the suburbs, a sullen 10-year-old girl wanders into a world ruled by gods, witches, and spirits, and where humans are changed into beasts.

#### [The BeastMaster](https://www.imdb.com/title/tt0083630/) [6.2]

A classic piece of 80s fantasy. It's basically Conan the Barbarian with some ferrets. - [@teav](https://github.com/teav)

> A sword-and-sorcery fantasy about a young man's search for revenge. Armed with supernatural powers, the handsome hero and his animal allies wage war against marauding forces.

#### The Lord of the Rings

Fantastic films. If you're reading this list, you've probably already seen them. - [@RichardLitt](https://github.com/RichardLitt)

- [The Fellowship of the Ring](http://www.imdb.com/title/tt0120737/) [8.8] :star2:

> A meek hobbit of the Shire and eight companions set out on a journey to Mount Doom to destroy the One Ring and the dark lord Sauron.

- [The Two Towers](http://www.imdb.com/title/tt0167261/) [8.7] :star2:

> While Frodo and Sam edge closer to Mordor with the help of the shifty Gollum, the divided fellowship makes a stand against Sauron's new ally, Saruman, and his hordes of Isengard.

- [Return of the King](http://www.imdb.com/title/tt0167260/) [8.9] :star2:

> Gandalf and Aragorn lead the World of Men against Sauron's army to draw his gaze from Frodo and Sam as they approach Mount Doom with the One Ring.

#### [The Princess Bride](http://www.imdb.com/title/tt0093779/) [8.2] :star2:

One of the best love stories ever told. This movie has everything any kid could want, and the book is just as good - it's satirical but not overly self-indulgent. - [@RichardLitt](https://github.com/RichardLitt)

> While home sick in bed, a young boy's grandfather reads him a story called The Princess Bride.

#### [The Sorcerer's Apprentice](https://www.imdb.com/title/tt0963966/) [6.1]

The fate of the world does not really hang in balance, contrary to what the movie says. Still very fun to watch, especially if you're part of Gen Z, or have kids in primary school. - [@TheSherlockHomie](https://github.com/TheSherlockHomie)

> Master sorcerer Balthazar Blake must find and train Merlin's descendant to defeat dark sorceress Morgana la Fée.

#### [Your Name - Kimi no na wa(Original title)](https://www.imdb.com/title/tt5311514/) [8.4]

The idea of eternal love through human existence and connection made be cry. A heartwarming romcom with an intriguing mystery that leaves priceless impressions on you. - [@kritikashah20](https://github.com/kritikashah20)

> Two strangers find themselves linked in a bizarre way. When a connection forms, will distance be the only thing to keep them apart?

#### [The Shape of Water](https://www.imdb.com/title/tt5580390/) [7.3]

It's a Romantic Dark Fantasy. Watch it when you have a good mood. The movie is full of hope and desire as the lead characters explore love in a unique way that is different and unnatural. The movie will have you shed tears, in suspense, and thrilled by shocking twists and events. - [@SinaMoghaddas](https://github.com/SinaMoghaddas)

> At a top secret research facility in the 1960s, a lonely janitor forms a unique relationship with an amphibious creature that is being held in captivity.

## TV Series

#### [Avatar: The Last Airbender](http://www.imdb.com/title/tt0417299/) (2005-2008) [9.3]

Uhm, the best. It's awesome. Stop what you're doing and go watch it. Now. - [@RichardLitt](https://github.com/RichardLitt)

> In a war-torn world of elemental magic, a young boy reawakens to undertake a dangerous mystic quest to fulfill his destiny as the Avatar.

#### [Cursed](https://www.imdb.com/title/tt8210856/?ref_=fn_al_tt_1) (2020-?) [7]

Reimagining of the Lady in the Lake with young King Arthur and Merlin by the legendary [Frank Miller](<https://en.wikipedia.org/wiki/Frank_Miller_(comics)>). This rendition of Merlin was awesome, very different take from previous versions. The mythical world has some twists and spin on favorites like Lord of the Rings and Witcher. - [@will-chow](https://github.com/will-chow)

> "A teenage sorceress named Nimue encounters a young Arthur on her quest to find a powerful and ancient sword."

#### [Game of Thrones](http://www.imdb.com/title/tt0944947/) (2011-2019) [9.5] :star2:

Pretty good, if overly televised at times and with too much emphasis on sexual violence. Beautifully shot otherwise. - [@RichardLitt](https://github.com/RichardLitt)

> Several noble families fight for control of the mythical land of Westeros.

#### [Good Omens](https://m.imdb.com/title/tt1869454/) (2019-2023) [8.2]

A great comedic mini-series with perfect casting wonderfully depicting the motifs of Gaiman and Pratchett's novel with the same name. - [@Djolo1802](https://github.com/djolo1802)

> A tale of the bungling of Armageddon features an angel, a demon, an eleven-year-old Antichrist, and a doom-saying witch.

#### [His Dark Materials](https://www.imdb.com/title/tt5607976/) (2019-2022) [7.9]

Excellent tv show. I love the books and I thought the adaptation was really good. - [@staelsabrina](https://github.com/staelsabrina)

> A young girl is destined to liberate her world from the grip of the Magisterium which represses people's ties to magic and their animal spirits known as daemons.

#### [Lucifer](https://www.imdb.com/title/tt4052886/) (2016-2021) [8.2]

I have loved this show since day one, and am an avid fan of all the lively and realistic characters. It is FUNNY and WELL WRITTEN and touches the nerves of Humanity, like never before. This show seems Hell-bent on showing you that every coin has two sides and every choice and decision you make has consequences, from YOU and no one else. - [@gayatripalkar](https://github.com/gayatripalkar)

> Lucifer Morningstar has decided he's had enough of being the dutiful servant in Hell and decides to spend some time on Earth to better understand humanity. He settles in Los Angeles - the City of Angels.

#### [Outlander](https://www.imdb.com/title/tt3006802/) (2014-ongoing) [8.4]

Outlander is a unique, satisfying adaptation of its source material, brought to life by lush scenery and potent chemistry between its leads. - [@AshishKnightfury](https://github.com/AshishKnightfury)

> An English combat nurse from 1945 is mysteriously swept back in time to 1743.

#### [Supernatural](https://www.imdb.com/title/tt0460681/) (2005-2020) [8.4]

Supernatural is somewhat endearing in that the main characters (the only ones who will be recurring) are brothers, however, the writing makes the characters more believable. They are different from each other, each with their own take on life and things that are not typical. - [@AshishKnightfury](https://github.com/AshishKnightfury)

> Two brothers follow their father's footsteps as hunters, fighting evil supernatural beings of many kinds, including monsters, demons, and gods that roam the earth.

#### [The Legend of Korra](https://www.imdb.com/title/tt1695360/) (2012-2014) [8.3]

The phenomenal sequel to *Avatar: The Last Airbender*, has just as good if not better storytelling, world building and lovable characters as the first entry in the franchise. Revolves around Korra, who's the new Avatar and you have to deal with it! - [@elvybean](https://github.com/elvybean)

> Avatar Korra fights to keep Republic City safe from the evil forces of both the physical and spiritual worlds.

#### [The Originals](https://www.imdb.com/title/tt2632424) (2013-2018) [8.2]

The Originals may overwhelm casual viewers with its myriad twists and bevy of supernatural beings, but this a sleek, atmospheric Vampire Diaries spinoff with potential. - [@TREXXX27](https://github.com/TREXXX27)

> A family of power-hungry thousand year old vampires look to take back the city that they built and dominate all those who have done them wrong.

#### [The Vampire Diaries](https://www.imdb.com/title/tt1405406/) (2009-2017) [7.7]

If you are looking for romance, teenagers figuring out life and guys removing their shirts for no reason. This series is for you. It is the kind of series you can binge-watch, whilst getting sucked into the mysteries of Mystic Falls. Easy to watch with a great storyline. - [@Hazelnoot](https://github.com/hazelnoot)

> The lives, loves, dangers and disasters in the town, Mystic Falls, Virginia. Creatures of unspeakable horror lurk beneath this town as a teenage girl is suddenly torn between two vampire brothers.

#### [The Witcher](https://www.imdb.com/title/tt5180504/) (2019-ongoing) [8.3]

The natural choice for those who read the Witcher book series, The Witcher tv adaption is mostly faithful to the books, in theme if not in actual screenplaying, with Henry Cavill in the main role, great acting and a tone similar to Game of Thrones. Bonus point for the captivating soundtrack. [@Donearm](https://github.com/Donearm)

Not as good as the source material but still an incredible show nonetheless. And yes the soundtrack is amazing! - [@elvybean](https://github.com/elvybean)

> Geralt of Rivia, a solitary monster hunter, struggles to find his place in a world where people often prove more wicked than beasts.

#### [Shadow and Bone](https://www.imdb.com/title/tt2403776/) (2021-2023) [7.6]

Shadow and Bone is one of the better fantasy shows to come out in the last few years. While it's not the best, it's up there! The show got me hooked from the first episode and I was pleasantly surprised by how much I enjoyed it. It has a little of something for everyone...fantasy, humor, action, drama, romance, etc. While it does take a few episodes to really get going, stay with it because it's worth it! If you like fantasy then give this show a chance, you won't be disappointed! [@Evy04](https://github.com/Evy04)

> Dark forces conspire against orphan mapmaker Alina Starkov when she unleashes an extraordinary power that could change the fate of her war-torn world.
 

---

## You got through the list and didn't find anything?

Try the [top 100 sci-fi and fantasy books as picked by NPR listeners](http://www.npr.org/2011/08/11/139085843/your-picks-top-100-science-fiction-fantasy-books) - NPR

## License

[![CC0](http://mirrors.creativecommons.org/presskit/buttons/88x31/svg/cc-zero.svg)](https://creativecommons.org/publicdomain/zero/1.0/)

To the extent possible under law, [Richard Littauer](http://burntfen.com) has waived all copyright and related or neighboring rights to this work.

