# Contribution Guidelines

Please ensure your pull request adheres to the following guidelines:

- You should have consumed the content you're suggesting.
- The entry should contain the title and author links, first publication year, rating, description and your personal commentary.
  - For the url links for titles and authors, use Goodreads or Wikipedia. Either is fine, choose the one with the better coverage.
  - For books, please copy the description and rating from [Goodreads](https://goodreads.com) and link to the Goodreads entry.
  - For movies and TV shows, please copy the description and rating from [IMDb](https://www.imdb.com) and link to the IMDb entry.
- Use the following format:

```
#### [title](link) (year) _by [author](link)_ [rating]

Commentary - [@you](https://github.com/you)

> Description
```

- Check your spelling and grammar.
- Please add the entry in the correct section, in alphabetical order.
- The author link should point to the author's [Wikipedia](https://en.wikipedia.org) page. If no such page exists, it should point to the author's [Goodreads](https://goodreads.com) page. If that doesn't exist either, please leave the author name in plain text instead of a link.
- Please add your name to your commentary, so we know who made it.
- Start the description with a capital and end with a full stop/period.
- Search previous suggestions before making a new one, as yours may be a duplicate.
- Make an individual pull request for each suggestion.
- The pull request and commit should have a useful title.
- Pull Requests without a personal comment will not be accepted until one is added.